# generated by datamodel-codegen:
#   filename:  2.0
#   timestamp: 2024-12-14T18:04:04+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List

from pydantic import BaseModel, ConfigDict, Field, conint, constr


class Software(BaseModel):
    """
    Metadata about server software in use.
    """

    model_config = ConfigDict(
        extra="forbid",
    )
    name: constr(pattern=r"^[a-z0-9-]+$") = Field(
        description="""
    The canonical name of this server software.
    """
    )
    version: str = Field(
        description="""
    The version of this server software.
    """
    )


class Protocol(str, Enum):
    activitypub = "activitypub"
    buddycloud = "buddycloud"
    dfrn = "dfrn"
    diaspora = "diaspora"
    libertree = "libertree"
    ostatus = "ostatus"
    pumpio = "pumpio"
    tent = "tent"
    xmpp = "xmpp"
    zot = "zot"


class InboundEnum(str, Enum):
    atom1_0 = "atom1.0"
    gnusocial = "gnusocial"
    imap = "imap"
    pnut = "pnut"
    pop3 = "pop3"
    pumpio = "pumpio"
    rss2_0 = "rss2.0"
    twitter = "twitter"


class OutboundEnum(str, Enum):
    atom1_0 = "atom1.0"
    blogger = "blogger"
    buddycloud = "buddycloud"
    diaspora = "diaspora"
    dreamwidth = "dreamwidth"
    drupal = "drupal"
    facebook = "facebook"
    friendica = "friendica"
    gnusocial = "gnusocial"
    google = "google"
    insanejournal = "insanejournal"
    libertree = "libertree"
    linkedin = "linkedin"
    livejournal = "livejournal"
    mediagoblin = "mediagoblin"
    myspace = "myspace"
    pinterest = "pinterest"
    pnut = "pnut"
    posterous = "posterous"
    pumpio = "pumpio"
    redmatrix = "redmatrix"
    rss2_0 = "rss2.0"
    smtp = "smtp"
    tent = "tent"
    tumblr = "tumblr"
    twitter = "twitter"
    wordpress = "wordpress"
    xmpp = "xmpp"


class Services(BaseModel):
    """
    The third party sites this server can connect to via their application API.
    """

    model_config = ConfigDict(
        extra="forbid",
    )
    inbound: List[InboundEnum] = Field(
        min_length=0,
        description="""
    The third party sites this server can retrieve messages from for combined display with regular traffic.
    """,
    )
    outbound: List[OutboundEnum] = Field(
        min_length=0,
        description="""
    The third party sites this server can publish messages to on the behalf of a user.
    """,
    )


class Users(BaseModel):
    """
    statistics about the users of this server.
    """

    model_config = ConfigDict(
        extra="forbid",
    )
    total: conint(ge=0) = Field(
        0,
        description="""
    The total amount of on this server registered users.
    """,
    )
    activeHalfyear: conint(ge=0) = Field(
        0,
        description="""
    The amount of users that signed in at least once in the last 180 days.
    """,
    )
    activeMonth: conint(ge=0) = Field(
        0,
        description="""
    The amount of users that signed in at least once in the last 30 days.
    """,
    )


class Usage(BaseModel):
    """
    Usage statistics for this server.
    """

    model_config = ConfigDict(
        extra="forbid",
    )
    users: Users = Field(
        default_factory=Users,
        description="""
    statistics about the users of this server.
    """,
    )
    localPosts: conint(ge=0) = Field(
        0,
        description="""
    The amount of posts that were made by users that are registered on this server.
    """,
    )
    localComments: conint(ge=0) = Field(
        0,
        description="""
    The amount of comments that were made by users that are registered on this server.
    """,
    )


class NodeInfo(BaseModel):
    """
    NodeInfo schema version 2.0.

    Usage:
    ```pycon
    >>> NodeInfo(software={"name": "bovine", "version": "0.0.1"}).model_dump()
    {'version': '2.0',
        'software': {'name': 'bovine', 'version': '0.0.1'},
        'protocols': [<Protocol.activitypub: 'activitypub'>],
        'services': {'inbound': [],
            'outbound': []},
        'openRegistrations': False,
        'usage': {'users':
            {'total': 0, 'activeHalfyear': 0, 'activeMonth': 0},
            'localPosts': 0,
            'localComments': 0},
        'metadata': {}}

    ```
    """

    model_config = ConfigDict(
        extra="forbid",
    )
    version: str = Field(
        "2.0",
        description="""
    The schema version, must be 2.0.
    """,
    )
    software: Software = Field(
        description="""
    Metadata about server software in use.
    """
    )
    protocols: List[Protocol] = Field(
        [Protocol.activitypub],
        min_length=1,
        description="""
    The protocols supported on this server.
    """,
    )
    services: Services = Field(
        Services(inbound=[], outbound=[]),
        description="""
    The third party sites this server can connect to via their application API.
    """,
    )
    openRegistrations: bool = Field(
        False,
        description="""
    Whether this server allows open self-registration.
    """,
    )
    usage: Usage = Field(
        default_factory=Usage,
        description="""
    Usage statistics for this server.
    """,
    )
    metadata: Dict[str, Any] = Field(
        {},
        description="""
    Free form key value pairs for software specific values. Clients should not rely on any specific key present.
    """,
    )
