"""
    EMIL BillingService

    The EMIL BillingService API description  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kontakt@emil.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from eis.billing.api_client import ApiClient, Endpoint as _Endpoint
from eis.billing.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from eis.billing.model.create_invoice_request_dto import CreateInvoiceRequestDto
from eis.billing.model.create_invoice_response_class import CreateInvoiceResponseClass
from eis.billing.model.get_invoice_response_class import GetInvoiceResponseClass
from eis.billing.model.list_invoices_response_class import ListInvoicesResponseClass
from eis.billing.model.list_policies_billings_response_class import ListPoliciesBillingsResponseClass


class InvoicesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_invoice_endpoint = _Endpoint(
            settings={
                'response_type': (CreateInvoiceResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/billingservice/v1/invoices',
                'operation_id': 'create_invoice',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_invoice_request_dto',
                    'authorization',
                    'idempotency_key',
                ],
                'required': [
                    'create_invoice_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_invoice_request_dto':
                        (CreateInvoiceRequestDto,),
                    'authorization':
                        (str,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                    'idempotency_key': 'Idempotency-Key',
                },
                'location_map': {
                    'create_invoice_request_dto': 'body',
                    'authorization': 'header',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_invoice_endpoint = _Endpoint(
            settings={
                'response_type': (GetInvoiceResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/billingservice/v1/invoices/{code}',
                'operation_id': 'get_invoice',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'expand',
                    'authorization',
                ],
                'required': [
                    'code',
                    'expand',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'expand':
                        (str,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'expand': 'expand',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'code': 'path',
                    'expand': 'query',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_invoices_endpoint = _Endpoint(
            settings={
                'response_type': (ListInvoicesResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/billingservice/v1/invoices',
                'operation_id': 'list_invoices',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'authorization',
                    'page_size',
                    'page_token',
                    'filter',
                    'search',
                    'order',
                    'expand',
                    'filters',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'authorization':
                        (str,),
                    'page_size':
                        (float,),
                    'page_token':
                        (str,),
                    'filter':
                        (str,),
                    'search':
                        (str,),
                    'order':
                        (str,),
                    'expand':
                        (str,),
                    'filters':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                    'page_size': 'pageSize',
                    'page_token': 'pageToken',
                    'filter': 'filter',
                    'search': 'search',
                    'order': 'order',
                    'expand': 'expand',
                    'filters': 'filters',
                },
                'location_map': {
                    'authorization': 'header',
                    'page_size': 'query',
                    'page_token': 'query',
                    'filter': 'query',
                    'search': 'query',
                    'order': 'query',
                    'expand': 'query',
                    'filters': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_policies_billing_dates_endpoint = _Endpoint(
            settings={
                'response_type': (ListPoliciesBillingsResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/billingservice/v1/invoices/policies-billing-dates',
                'operation_id': 'list_policies_billing_dates',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'authorization',
                    'page_size',
                    'page_token',
                    'filter',
                    'search',
                    'order',
                    'expand',
                    'filters',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'authorization':
                        (str,),
                    'page_size':
                        (float,),
                    'page_token':
                        (str,),
                    'filter':
                        (str,),
                    'search':
                        (str,),
                    'order':
                        (str,),
                    'expand':
                        (str,),
                    'filters':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                    'page_size': 'pageSize',
                    'page_token': 'pageToken',
                    'filter': 'filter',
                    'search': 'search',
                    'order': 'order',
                    'expand': 'expand',
                    'filters': 'filters',
                },
                'location_map': {
                    'authorization': 'header',
                    'page_size': 'query',
                    'page_token': 'query',
                    'filter': 'query',
                    'search': 'query',
                    'order': 'query',
                    'expand': 'query',
                    'filters': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create_invoice(
        self,
        create_invoice_request_dto,
        **kwargs
    ):
        """Create the invoice  # noqa: E501

        This will create invoice for a policy and save it in the DB.  **Required Permissions**  \"billing-management.invoices.create\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_invoice(create_invoice_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            create_invoice_request_dto (CreateInvoiceRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            idempotency_key (str): Idempotency Key used to make the request idempotent. The key should be unique.     Usually, a generated v4 UUID is enough.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateInvoiceResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_invoice_request_dto'] = \
            create_invoice_request_dto
        return self.create_invoice_endpoint.call_with_http_info(**kwargs)

    def get_invoice(
        self,
        code,
        expand,
        **kwargs
    ):
        """Retrieve the invoice  # noqa: E501

        Gets an invoice.  **Required Permissions**  \"billing-management.invoices.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_invoice(code, expand, async_req=True)
        >>> result = thread.get()

        Args:
            code (str):
            expand (str):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetInvoiceResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        kwargs['expand'] = \
            expand
        return self.get_invoice_endpoint.call_with_http_info(**kwargs)

    def list_invoices(
        self,
        **kwargs
    ):
        """List invoices  # noqa: E501

        Returns a list of invoices you have previously created.          The invoices are returned in sorted order, with the oldest one appearing first.          For more information about pagination, read the Pagination documentation.  **Required Permissions**  \"billing-management.invoices.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_invoices(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            authorization (str): Bearer Token. [optional]
            page_size (float): A limit on the number of objects to be returned.     Limit ranges between 1 and 50. Default: 10.. [optional]
            page_token (str): A cursor for use in pagination.     pageToken is an ID that defines your place in the list.     For instance, if you make a list request and receive 100 objects and pageToken=1, your subsequent call can include pageToken=2 in order to fetch the next page of the list.. [optional]
            filter (str): Filter the response by one or multiple fields.            In general, fetching filtered responses will conserve bandwidth and reduce response time.<br/>           <br/>           <i>Allowed values: code, policyCode, invoiceNumber, id, type, accountNumber, status, billingIntervalFrom, billingIntervalTo, createdAt</i>. [optional]
            search (str): To search the list by any field, pass search=xxx to fetch the result.. [optional]
            order (str): Order allows you to specify the desired order of entities retrieved from the server by           ascending (ASC) or descending (DESC) order.<br/>           <br/>           <i>Allowed values: invoiceNumber, status, netAmount, grossAmount, createdAt, dueDate, id</i>. [optional]
            expand (str): Expand to fetch additional information about the list items.       Expanding resources can reduce the number of API calls required to accomplish a task.       Use with discretion as some expanded fields can drastically increase payload size.<br/>       <br/>       <i>Allowed values: statuses, payments, invoiceItems<i>. [optional]
            filters (str): Filters the response by one or multiple fields.            Advanced filter functionality allows you to perform more complex filtering operations.<br/>           <br/>           <i>Allowed values: code, policyCode, invoiceNumber, id, type, accountNumber, status, billingIntervalFrom, billingIntervalTo, createdAt</i>. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListInvoicesResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_invoices_endpoint.call_with_http_info(**kwargs)

    def list_policies_billing_dates(
        self,
        **kwargs
    ):
        """List policies billing dates  # noqa: E501

        Returns a list of policies billing dates you have previously created.          The policies billing dates are returned in sorted order, with the oldest one appearing first.          For more information about pagination, read the Pagination documentation.  **Required Permissions**  \"billing-management.invoices.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_policies_billing_dates(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            authorization (str): Bearer Token. [optional]
            page_size (float): A limit on the number of objects to be returned.     Limit ranges between 1 and 50. Default: 10.. [optional]
            page_token (str): A cursor for use in pagination.     pageToken is an ID that defines your place in the list.     For instance, if you make a list request and receive 100 objects and pageToken=1, your subsequent call can include pageToken=2 in order to fetch the next page of the list.. [optional]
            filter (str): Filter the response by one or multiple fields.            In general, fetching filtered responses will conserve bandwidth and reduce response time.<br/>           <br/>           <i>Allowed values: policyCode, isInvoiced, nextBillingDate, status, billingIntervalFrom, billingIntervalTo</i>. [optional]
            search (str): To search the list by any field, pass search=xxx to fetch the result.. [optional]
            order (str): Order allows you to specify the desired order of entities retrieved from the server by           ascending (ASC) or descending (DESC) order.<br/>           <br/>           <i>Allowed values: createdAt</i>. [optional]
            expand (str): Expand to fetch additional information about the list items.       Expanding resources can reduce the number of API calls required to accomplish a task.       Use with discretion as some expanded fields can drastically increase payload size.<br/>       <br/>       . [optional]
            filters (str): Filters the response by one or multiple fields.            Advanced filter functionality allows you to perform more complex filtering operations.<br/>           <br/>           <i>Allowed values: policyCode, isInvoiced, nextBillingDate, status, billingIntervalFrom, billingIntervalTo</i>. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListPoliciesBillingsResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_policies_billing_dates_endpoint.call_with_http_info(**kwargs)

