"""
    EMIL BillingService

    The EMIL BillingService API description  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kontakt@emil.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from eis.billing.api_client import ApiClient, Endpoint as _Endpoint
from eis.billing.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from eis.billing.model.create_policy_billing_request_dto import CreatePolicyBillingRequestDto
from eis.billing.model.create_policy_billing_response_class import CreatePolicyBillingResponseClass
from eis.billing.model.update_policy_billing_request_dto import UpdatePolicyBillingRequestDto
from eis.billing.model.update_policy_billing_response_class import UpdatePolicyBillingResponseClass


class PolicyBillingApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_policy_billing_endpoint = _Endpoint(
            settings={
                'response_type': (CreatePolicyBillingResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/billingservice/v1/policies-billings',
                'operation_id': 'create_policy_billing',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_policy_billing_request_dto',
                    'authorization',
                ],
                'required': [
                    'create_policy_billing_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_policy_billing_request_dto':
                        (CreatePolicyBillingRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'create_policy_billing_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.list_policies_billings_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/billingservice/v1/policies-billings',
                'operation_id': 'list_policies_billings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'authorization',
                    'page_size',
                    'page_token',
                    'filter',
                    'search',
                    'order',
                    'expand',
                    'filters',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'authorization':
                        (str,),
                    'page_size':
                        (float,),
                    'page_token':
                        (str,),
                    'filter':
                        (str,),
                    'search':
                        (str,),
                    'order':
                        (str,),
                    'expand':
                        (str,),
                    'filters':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                    'page_size': 'pageSize',
                    'page_token': 'pageToken',
                    'filter': 'filter',
                    'search': 'search',
                    'order': 'order',
                    'expand': 'expand',
                    'filters': 'filters',
                },
                'location_map': {
                    'authorization': 'header',
                    'page_size': 'query',
                    'page_token': 'query',
                    'filter': 'query',
                    'search': 'query',
                    'order': 'query',
                    'expand': 'query',
                    'filters': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_policy_billing_endpoint = _Endpoint(
            settings={
                'response_type': (UpdatePolicyBillingResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/billingservice/v1/policies-billings/{code}',
                'operation_id': 'update_policy_billing',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'update_policy_billing_request_dto',
                    'authorization',
                ],
                'required': [
                    'code',
                    'update_policy_billing_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'update_policy_billing_request_dto':
                        (UpdatePolicyBillingRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'code': 'path',
                    'update_policy_billing_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_policy_billing(
        self,
        create_policy_billing_request_dto,
        **kwargs
    ):
        """Create the Policy Billing  # noqa: E501

        Create a new policy billing  **Required Permissions**  \"billing-management.invoices.create\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_policy_billing(create_policy_billing_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            create_policy_billing_request_dto (CreatePolicyBillingRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreatePolicyBillingResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_policy_billing_request_dto'] = \
            create_policy_billing_request_dto
        return self.create_policy_billing_endpoint.call_with_http_info(**kwargs)

    def list_policies_billings(
        self,
        **kwargs
    ):
        """List policies billings  # noqa: E501

        Returns a list of policies billings you have previously created.          The policies billings are returned in sorted order, with the oldest one appearing first.          For more information about pagination, read the Pagination documentation.  **Required Permissions**  \"billing-management.invoices.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_policies_billings(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            authorization (str): Bearer Token. [optional]
            page_size (float): A limit on the number of objects to be returned.     Limit ranges between 1 and 50. Default: 10.. [optional]
            page_token (str): A cursor for use in pagination.     pageToken is an ID that defines your place in the list.     For instance, if you make a list request and receive 100 objects and pageToken=1, your subsequent call can include pageToken=2 in order to fetch the next page of the list.. [optional]
            filter (str): Filter the response by one or multiple fields.            In general, fetching filtered responses will conserve bandwidth and reduce response time.<br/>           <br/>           <i>Allowed values: policyCode, isInvoiced, nextBillingDate, status, billingIntervalFrom, billingIntervalTo</i>. [optional]
            search (str): To search the list by any field, pass search=xxx to fetch the result.. [optional]
            order (str): Order allows you to specify the desired order of entities retrieved from the server by           ascending (ASC) or descending (DESC) order.<br/>           <br/>           <i>Allowed values: createdAt</i>. [optional]
            expand (str): Expand to fetch additional information about the list items.       Expanding resources can reduce the number of API calls required to accomplish a task.       Use with discretion as some expanded fields can drastically increase payload size.<br/>       <br/>       . [optional]
            filters (str): Filters the response by one or multiple fields.            Advanced filter functionality allows you to perform more complex filtering operations.<br/>           <br/>           <i>Allowed values: policyCode, isInvoiced, nextBillingDate, status, billingIntervalFrom, billingIntervalTo</i>. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_policies_billings_endpoint.call_with_http_info(**kwargs)

    def update_policy_billing(
        self,
        code,
        update_policy_billing_request_dto,
        **kwargs
    ):
        """Update the request message  # noqa: E501

        Updates the specified request message by setting the values of the parameters passed. Any parameters not provided will be left unchanged.  **Required Permissions**  \"billing-management.invoices.update\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_policy_billing(code, update_policy_billing_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            code (str): Unique identifier for the object.
            update_policy_billing_request_dto (UpdatePolicyBillingRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdatePolicyBillingResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        kwargs['update_policy_billing_request_dto'] = \
            update_policy_billing_request_dto
        return self.update_policy_billing_endpoint.call_with_http_info(**kwargs)

