"""
    EMIL BillingService

    The EMIL BillingService API description  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kontakt@emil.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from eis.billing.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from eis.billing.exceptions import ApiAttributeError


def lazy_import():
    from eis.billing.model.policy_version_dto import PolicyVersionDto
    globals()['PolicyVersionDto'] = PolicyVersionDto


class PolicyDto(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('status',): {
            'ACTIVE': "ACTIVE",
            'WITHDRAWN': "WITHDRAWN",
            'TERMINATED': "TERMINATED",
            'SUSPENDED': "SUSPENDED",
            'PENDING': "PENDING",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (float,),  # noqa: E501
            'code': (str,),  # noqa: E501
            'policy_number': (str,),  # noqa: E501
            'internal_policy_number': (str,),  # noqa: E501
            'product_version_id': (float,),  # noqa: E501
            'product_id': (float,),  # noqa: E501
            'account_code': (str,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'holder': (str,),  # noqa: E501
            'created_at': (datetime,),  # noqa: E501
            'updated_at': (datetime,),  # noqa: E501
            'versions': ([PolicyVersionDto],),  # noqa: E501
            'product_name': (str,),  # noqa: E501
            'product_slug': (str,),  # noqa: E501
            'partner_links': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),  # noqa: E501
            'policy_start_date': (datetime,),  # noqa: E501
            'ern': (str,),  # noqa: E501
            'created_by': (str,),  # noqa: E501
            'updated_by': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'code': 'code',  # noqa: E501
        'policy_number': 'policyNumber',  # noqa: E501
        'internal_policy_number': 'internalPolicyNumber',  # noqa: E501
        'product_version_id': 'productVersionId',  # noqa: E501
        'product_id': 'productId',  # noqa: E501
        'account_code': 'accountCode',  # noqa: E501
        'status': 'status',  # noqa: E501
        'holder': 'holder',  # noqa: E501
        'created_at': 'createdAt',  # noqa: E501
        'updated_at': 'updatedAt',  # noqa: E501
        'versions': 'versions',  # noqa: E501
        'product_name': 'productName',  # noqa: E501
        'product_slug': 'productSlug',  # noqa: E501
        'partner_links': 'partnerLinks',  # noqa: E501
        'policy_start_date': 'policyStartDate',  # noqa: E501
        'ern': 'ern',  # noqa: E501
        'created_by': 'createdBy',  # noqa: E501
        'updated_by': 'updatedBy',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, id, code, policy_number, internal_policy_number, product_version_id, product_id, account_code, status, holder, created_at, updated_at, versions, product_name, product_slug, partner_links, policy_start_date, ern, created_by, updated_by, *args, **kwargs):  # noqa: E501
        """PolicyDto - a model defined in OpenAPI

        Args:
            id (float): Internal unique identifier for the object. You should not have to use this, use code instead.
            code (str): Unique identifier for the object.
            policy_number (str): Policy number.
            internal_policy_number (str): Internal policy number.
            product_version_id (float): Unique identifier referencing the policy product version.
            product_id (float): Unique identifier referencing the policy product.
            account_code (str): Unique identifier of the account that this object belongs to.
            status (str): Policy status. This property shows different statuses depending on the status of a policy:                    ACTIVE, WITHDRAW, TERMINATED, SUSPENDED.
            holder (str): Policy holder.
            created_at (datetime): Time at which the object was created.
            updated_at (datetime): Time at which the object was updated.
            versions ([PolicyVersionDto]): Policy versions.
            product_name (str): Product name.
            product_slug (str): A slug is a human-readable, unique identifier, used to identify a resource     instead of a less human-readable identifier like an id.
            partner_links ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]): Linked partners.
            policy_start_date (datetime):
            ern (str):
            created_by (str):
            updated_by (str):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.code = code
        self.policy_number = policy_number
        self.internal_policy_number = internal_policy_number
        self.product_version_id = product_version_id
        self.product_id = product_id
        self.account_code = account_code
        self.status = status
        self.holder = holder
        self.created_at = created_at
        self.updated_at = updated_at
        self.versions = versions
        self.product_name = product_name
        self.product_slug = product_slug
        self.partner_links = partner_links
        self.policy_start_date = policy_start_date
        self.ern = ern
        self.created_by = created_by
        self.updated_by = updated_by
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, id, code, policy_number, internal_policy_number, product_version_id, product_id, account_code, status, holder, created_at, updated_at, versions, product_name, product_slug, partner_links, policy_start_date, ern, created_by, updated_by, *args, **kwargs):  # noqa: E501
        """PolicyDto - a model defined in OpenAPI

        Args:
            id (float): Internal unique identifier for the object. You should not have to use this, use code instead.
            code (str): Unique identifier for the object.
            policy_number (str): Policy number.
            internal_policy_number (str): Internal policy number.
            product_version_id (float): Unique identifier referencing the policy product version.
            product_id (float): Unique identifier referencing the policy product.
            account_code (str): Unique identifier of the account that this object belongs to.
            status (str): Policy status. This property shows different statuses depending on the status of a policy:                    ACTIVE, WITHDRAW, TERMINATED, SUSPENDED.
            holder (str): Policy holder.
            created_at (datetime): Time at which the object was created.
            updated_at (datetime): Time at which the object was updated.
            versions ([PolicyVersionDto]): Policy versions.
            product_name (str): Product name.
            product_slug (str): A slug is a human-readable, unique identifier, used to identify a resource     instead of a less human-readable identifier like an id.
            partner_links ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]): Linked partners.
            policy_start_date (datetime):
            ern (str):
            created_by (str):
            updated_by (str):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.code = code
        self.policy_number = policy_number
        self.internal_policy_number = internal_policy_number
        self.product_version_id = product_version_id
        self.product_id = product_id
        self.account_code = account_code
        self.status = status
        self.holder = holder
        self.created_at = created_at
        self.updated_at = updated_at
        self.versions = versions
        self.product_name = product_name
        self.product_slug = product_slug
        self.partner_links = partner_links
        self.policy_start_date = policy_start_date
        self.ern = ern
        self.created_by = created_by
        self.updated_by = updated_by
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
