---
description: "A workflow for creating, refining, and organizing textual content."
---
This workflow is for creating, refining, and organizing textual content.
Your goal is to produce content that is not just correct, but compelling, clear, and perfectly suited to its purpose.

# 1. The Foundation: Intent and Audience

Before you write a word, you must understand the "why" and the "who".

- **Define the Goal:** What is this text supposed to achieve? (e.g., persuade, inform, entertain, sell). If the user is vague, ask for clarification.
- **Identify the Audience:** Who are you writing for? (e.g., experts, beginners, customers). This dictates your tone, vocabulary, and level of detail.
- **Determine the Tone:** Choose a voice that serves the goal and resonates with the audience (e.g., formal, witty, technical, urgent).

# 2. The Process: From Outline to Polished Copy

Structure is not a suggestion; it's a requirement for effective communication.

## 2.1. Outline for Approval

- For any non-trivial content, create a logical outline first.
- Present this outline to the user for approval. This prevents wasted effort and ensures alignment. An outline should include:
  - A working title or headline.
  - Key sections or talking points.
  - A brief note on the call-to-action or concluding thought.

## 2.2. Draft with Purpose

- Write the full draft, focusing on conveying the message clearly and persuasively.
- **Hook the Reader:** Start with a strong opening that grabs attention.
- **Use Active Voice:** Make your writing direct and energetic.
- **Show, Don't Just Tell:** Use examples, stories, and data to illustrate your points.

## 2.3. Refine and Polish

- **Read it Aloud:** This is the fastest way to catch awkward phrasing and grammatical errors.
- **Cut Mercilessly:** If a word, sentence, or paragraph doesn't serve the goal, delete it.
- **Enhance Readability:** Use short paragraphs, headings, bullet points, and bold text to break up the text and guide the reader's eye.

# 3. Task-Specific Directives

- **Summarization:** Your job is to distill the essence. Identify the core thesis and key supporting arguments. Be objective and ruthless in cutting fluff.
- **Proofreading:** This is more than fixing typos. You are a quality gate. Correct grammar, spelling, and punctuation, but also improve sentence flow and clarity without altering the original meaning.
- **Refining/Editing:** Sharpen the author's message. Improve clarity, strengthen arguments, and ensure a consistent tone. Respect the original voice while making it more powerful.
