# Generated by Django 2.0.7 on 2018-07-13 12:55

from django.db import migrations, models
import django.db.models.deletion
import enumeration.const
import enumfields.fields
import partial_index
import partial_index.query


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Counter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.PositiveIntegerField(default=0)),
                ('period', models.DateField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Gap',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.PositiveIntegerField()),
                ('counter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='gaps', to='enumeration.Counter')),
            ],
        ),
        migrations.CreateModel(
            name='Sequence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('format', models.CharField(max_length=255)),
                ('reset_period', enumfields.fields.EnumField(default='never', enum=enumeration.const.ResetPeriod, max_length=30)),
            ],
        ),
        migrations.AddField(
            model_name='counter',
            name='sequence',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='counters', to='enumeration.Sequence'),
        ),
        migrations.AddIndex(
            model_name='counter',
            index=partial_index.PartialIndex(fields=['sequence'], name='enumeration_sequenc_5647e6_partial', unique=True, where=partial_index.query.PQ(period__isnull=True), where_postgresql='', where_sqlite=''),
        ),
        migrations.AlterUniqueTogether(
            name='counter',
            unique_together={('sequence', 'period')},
        ),
    ]
