# Generated by Django 5.2.7 on 2025-11-05 20:42

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('declaratives', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='SystemPerformance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cpu_usage', models.FloatField(help_text='CPU usage percentage')),
                ('memory_usage', models.FloatField(help_text='Memory usage percentage')),
                ('disk_usage', models.FloatField(help_text='Disk usage percentage')),
                ('network_in', models.FloatField(help_text='Network input in MB/s')),
                ('network_out', models.FloatField(help_text='Network output in MB/s')),
                ('active_users', models.IntegerField(default=0)),
                ('requests_per_second', models.FloatField(default=0.0)),
                ('response_time', models.FloatField(help_text='Average response time in ms')),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'ordering': ['-timestamp'],
            },
        ),
        migrations.CreateModel(
            name='ActivityFeed',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('action_type', models.CharField(choices=[('login', 'User Login'), ('logout', 'User Logout'), ('create', 'Created Item'), ('update', 'Updated Item'), ('delete', 'Deleted Item'), ('comment', 'Added Comment'), ('share', 'Shared Item'), ('like', 'Liked Item'), ('purchase', 'Made Purchase'), ('upload', 'Uploaded File')], max_length=20)),
                ('description', models.TextField()),
                ('object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('object_type', models.CharField(blank=True, max_length=50)),
                ('ip_address', models.GenericIPAddressField(blank=True, null=True)),
                ('user_agent', models.TextField(blank=True)),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-timestamp'],
            },
        ),
        migrations.CreateModel(
            name='DragDropItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('description', models.TextField(blank=True)),
                ('category', models.CharField(max_length=50)),
                ('order', models.PositiveIntegerField(default=0)),
                ('color', models.CharField(default='#007bff', help_text='Hex color code', max_length=7)),
                ('icon', models.CharField(default='move', help_text='Feather icon name', max_length=50)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['category', 'order', 'name'],
            },
        ),
        migrations.CreateModel(
            name='DynamicTab',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('content', models.TextField()),
                ('icon', models.CharField(default='file-text', help_text='Feather icon name', max_length=50)),
                ('is_active', models.BooleanField(default=False)),
                ('order', models.PositiveIntegerField(default=0)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['order', 'created_at'],
            },
        ),
        migrations.CreateModel(
            name='FileManager',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('file', models.FileField(upload_to='files/%Y/%m/')),
                ('file_type', models.CharField(choices=[('document', 'Document'), ('image', 'Image'), ('video', 'Video'), ('audio', 'Audio'), ('archive', 'Archive'), ('other', 'Other')], max_length=20)),
                ('file_size', models.PositiveIntegerField(help_text='File size in bytes')),
                ('mime_type', models.CharField(blank=True, max_length=100)),
                ('folder', models.CharField(default='root', max_length=255)),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
                ('is_public', models.BooleanField(default=False)),
                ('download_count', models.PositiveIntegerField(default=0)),
                ('uploaded_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['folder', 'name'],
            },
        ),
        migrations.CreateModel(
            name='GalleryItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200)),
                ('description', models.TextField(blank=True)),
                ('image', models.ImageField(blank=True, null=True, upload_to='gallery/')),
                ('image_url', models.URLField(blank=True, help_text='External image URL')),
                ('category', models.CharField(default='general', max_length=50)),
                ('is_featured', models.BooleanField(default=False)),
                ('order', models.PositiveIntegerField(default=0, help_text='Display order')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['order', '-created_at'],
            },
        ),
        migrations.CreateModel(
            name='SaleByRegion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('region', models.CharField(max_length=100)),
                ('country', models.CharField(blank=True, max_length=100)),
                ('sales_amount', models.DecimalField(decimal_places=2, max_digits=12)),
                ('units_sold', models.IntegerField(default=0)),
                ('growth_rate', models.FloatField(blank=True, help_text='Percentage growth', null=True)),
                ('period_start', models.DateField()),
                ('period_end', models.DateField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'ordering': ['-sales_amount'],
                'unique_together': {('region', 'period_start', 'period_end')},
            },
        ),
        migrations.CreateModel(
            name='WizardStep',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('wizard_name', models.CharField(max_length=100)),
                ('step_number', models.PositiveIntegerField()),
                ('title', models.CharField(max_length=200)),
                ('description', models.TextField(blank=True)),
                ('form_fields', models.JSONField(default=dict, help_text='Form field configuration')),
                ('validation_rules', models.JSONField(blank=True, default=dict)),
                ('is_required', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'ordering': ['wizard_name', 'step_number'],
                'unique_together': {('wizard_name', 'step_number')},
            },
        ),
        migrations.CreateModel(
            name='WizardSession',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('wizard_name', models.CharField(max_length=100)),
                ('current_step', models.PositiveIntegerField(default=1)),
                ('step_data', models.JSONField(default=dict, help_text='Data collected from each step')),
                ('completed', models.BooleanField(default=False)),
                ('started_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('user', 'wizard_name')},
            },
        ),
    ]
