from setuptools import setup, find_packages



setup(
    name="hyperx-htmx",
    version="3.3.0",
    author="Jeff Panasuik",
    author_email="jeff.panasuik@gmail.com",
    description="Declarative HTMX + Element framework for server-side rendering",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    url="https://github.com/faroncoder/hyperx-htmx",
    license="MIT",
    packages=find_packages(exclude=("tests", "tests.*")),
    include_package_data=True,
    install_requires=[
        "aiohttp",
        "asgiref",
        "attrs",
        "beautifulsoup4",
        "bs4",
        "celery",
        "celery[redis]",
        "channels",
        "channels-redis",
        "click-didyoumean",
        "click-plugins",
        "colorama",
        "daphne",
        "django",
        "Django",
        "django-bootstrap5",
        "django-celery-beat",
        "django-csp",
        "django-extensions",
        "django-htmx",
        "django-redis",
        "flower",
        "http2[twisted]",
        "httpx",
        "hyperlink",
        "jq",
        "openai",
        "Pillow",
        "platformdirs",
        "playwright",
        "psutil",
        "Pygments",
        "pyparser",
        "pyparsing",
        "pytest",
        "pytest-django",
        "pytest-playwright",
        "python-decouple",
        "python-dotenv",
        "python-json-logger",
        "pythonjsonlogger",
        "python-slugify",
        "PyYAML",
        "redis",
        "requests",
        "responses",
        "rich",
        "typing-extensions",
        "tzdata",
        "urllib3",
        "uuid",
        "watchdog",
        "websockets"
    ],
    python_requires=">=3.12",
    classifiers=[
        "Framework :: Django",
        "Framework :: Django :: 4.2",
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
	"Operating System :: POSIX :: Linux",
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
    entry_points={
        # ✅ Modern Django app autodiscovery (no default_app_config needed)
        "console_scripts": [
            "hx-find = hyperx.bin.cli.utils.autodiscover:main",
            # "hx-install = hyperx.bin.cli.installer:core_install_hyperx:Command:run",
            "hx = hyperx.bin.cli.hx:main", 
            "hx-env = hyperx.bin.cli.logger.setenv:main",
            # "hx-reactjs = hyperx.bin.cli.commands.reactjs:main",
            # "hx-reactjs-worker = hyperx.bin.cli.commands.celery_worker:main",
            # "hx-reactjs-flower = hyperx.bin.cli.commands.celery_flower:main",
            # "hx-reactjs-beat = hyperx.bin.cli.commands.celery_beat:main"
        ],
    },

    project_urls={
        "Documentation": "https://github.com/faroncoder/hyperx-htmx/wiki",
        "Source": "https://github.com/faroncoder/hyperx-htmx",
        "Tracker": "https://github.com/faroncoder/hyperx-htmx/issues",
    },
)
