# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ClusterAgentTokenArgs', 'ClusterAgentToken']

@pulumi.input_type
class ClusterAgentTokenArgs:
    def __init__(__self__, *,
                 agent_id: pulumi.Input[_builtins.int],
                 project: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ClusterAgentToken resource.
        :param pulumi.Input[_builtins.int] agent_id: The ID of the agent.
        :param pulumi.Input[_builtins.str] project: ID or full path of the project maintained by the authenticated user.
        :param pulumi.Input[_builtins.str] description: The Description for the agent.
        :param pulumi.Input[_builtins.str] name: The Name of the agent.
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "project", project)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the agent.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        ID or full path of the project maintained by the authenticated user.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Description for the agent.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the agent.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ClusterAgentTokenState:
    def __init__(__self__, *,
                 agent_id: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 last_used_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 token_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ClusterAgentToken resources.
        :param pulumi.Input[_builtins.int] agent_id: The ID of the agent.
        :param pulumi.Input[_builtins.str] created_at: The ISO8601 datetime when the agent was created.
        :param pulumi.Input[_builtins.int] created_by_user_id: The ID of the user who created the agent.
        :param pulumi.Input[_builtins.str] description: The Description for the agent.
        :param pulumi.Input[_builtins.str] last_used_at: The ISO8601 datetime when the token was last used.
        :param pulumi.Input[_builtins.str] name: The Name of the agent.
        :param pulumi.Input[_builtins.str] project: ID or full path of the project maintained by the authenticated user.
        :param pulumi.Input[_builtins.str] status: The status of the token. Valid values are `active`, `revoked`.
        :param pulumi.Input[_builtins.str] token: The secret token for the agent. The `token` is not available in imported resources.
        :param pulumi.Input[_builtins.int] token_id: The ID of the token.
        """
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by_user_id is not None:
            pulumi.set(__self__, "created_by_user_id", created_by_user_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if last_used_at is not None:
            pulumi.set(__self__, "last_used_at", last_used_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if token_id is not None:
            pulumi.set(__self__, "token_id", token_id)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the agent.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ISO8601 datetime when the agent was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdByUserId")
    def created_by_user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the user who created the agent.
        """
        return pulumi.get(self, "created_by_user_id")

    @created_by_user_id.setter
    def created_by_user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created_by_user_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Description for the agent.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="lastUsedAt")
    def last_used_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ISO8601 datetime when the token was last used.
        """
        return pulumi.get(self, "last_used_at")

    @last_used_at.setter
    def last_used_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_used_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the agent.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID or full path of the project maintained by the authenticated user.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the token. Valid values are `active`, `revoked`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret token for the agent. The `token` is not available in imported resources.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the token.
        """
        return pulumi.get(self, "token_id")

    @token_id.setter
    def token_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_id", value)


@pulumi.type_token("gitlab:index/clusterAgentToken:ClusterAgentToken")
class ClusterAgentToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_id: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `ClusterAgentToken` resource allows to manage the lifecycle of a token for a GitLab Agent for Kubernetes.

        > Requires at least maintainer permissions on the project.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/cluster_agents/#create-an-agent-token)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab
        import pulumi_helm as helm

        # Create token for an agent
        example = gitlab.ClusterAgentToken("example",
            project="12345",
            agent_id=42,
            name="some-token",
            description="some token")
        # The following example creates a GitLab Agent for Kubernetes in a given project,
        # creates a token and install the `gitlab-agent` Helm Chart.
        # (see https://gitlab.com/gitlab-org/charts/gitlab-agent)
        this = gitlab.get_project(path_with_namespace="my-org/example")
        this_cluster_agent = gitlab.ClusterAgent("this",
            project=this.id,
            name="my-agent")
        this_cluster_agent_token = gitlab.ClusterAgentToken("this",
            project=this.id,
            agent_id=this_cluster_agent.agent_id,
            name="my-agent-token",
            description="Token for the my-agent used with `gitlab-agent` Helm Chart")
        gitlab_agent = helm.index.Release("gitlab_agent",
            name=gitlab-agent,
            namespace=gitlab-agent,
            create_namespace=True,
            repository=https://charts.gitlab.io,
            chart=gitlab-agent,
            version=1.2.0,
            set=[{
                name: config.token,
                value: this_cluster_agent_token.token,
            }])
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_cluster_agent_token`. For example:

        terraform

        import {

          to = gitlab_cluster_agent_token.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        A token for a GitLab Agent for Kubernetes can be imported with the following command and the id pattern `<project>:<agent-id>:<token-id>`:

        ```sh
        $ pulumi import gitlab:index/clusterAgentToken:ClusterAgentToken example '12345:42:1'
        ```

        ATTENTION: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] agent_id: The ID of the agent.
        :param pulumi.Input[_builtins.str] description: The Description for the agent.
        :param pulumi.Input[_builtins.str] name: The Name of the agent.
        :param pulumi.Input[_builtins.str] project: ID or full path of the project maintained by the authenticated user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterAgentTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ClusterAgentToken` resource allows to manage the lifecycle of a token for a GitLab Agent for Kubernetes.

        > Requires at least maintainer permissions on the project.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/cluster_agents/#create-an-agent-token)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab
        import pulumi_helm as helm

        # Create token for an agent
        example = gitlab.ClusterAgentToken("example",
            project="12345",
            agent_id=42,
            name="some-token",
            description="some token")
        # The following example creates a GitLab Agent for Kubernetes in a given project,
        # creates a token and install the `gitlab-agent` Helm Chart.
        # (see https://gitlab.com/gitlab-org/charts/gitlab-agent)
        this = gitlab.get_project(path_with_namespace="my-org/example")
        this_cluster_agent = gitlab.ClusterAgent("this",
            project=this.id,
            name="my-agent")
        this_cluster_agent_token = gitlab.ClusterAgentToken("this",
            project=this.id,
            agent_id=this_cluster_agent.agent_id,
            name="my-agent-token",
            description="Token for the my-agent used with `gitlab-agent` Helm Chart")
        gitlab_agent = helm.index.Release("gitlab_agent",
            name=gitlab-agent,
            namespace=gitlab-agent,
            create_namespace=True,
            repository=https://charts.gitlab.io,
            chart=gitlab-agent,
            version=1.2.0,
            set=[{
                name: config.token,
                value: this_cluster_agent_token.token,
            }])
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_cluster_agent_token`. For example:

        terraform

        import {

          to = gitlab_cluster_agent_token.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        A token for a GitLab Agent for Kubernetes can be imported with the following command and the id pattern `<project>:<agent-id>:<token-id>`:

        ```sh
        $ pulumi import gitlab:index/clusterAgentToken:ClusterAgentToken example '12345:42:1'
        ```

        ATTENTION: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.

        :param str resource_name: The name of the resource.
        :param ClusterAgentTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterAgentTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_id: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterAgentTokenArgs.__new__(ClusterAgentTokenArgs)

            if agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_id'")
            __props__.__dict__["agent_id"] = agent_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by_user_id"] = None
            __props__.__dict__["last_used_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["token"] = None
            __props__.__dict__["token_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ClusterAgentToken, __self__).__init__(
            'gitlab:index/clusterAgentToken:ClusterAgentToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_id: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            created_by_user_id: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            last_used_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            token: Optional[pulumi.Input[_builtins.str]] = None,
            token_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'ClusterAgentToken':
        """
        Get an existing ClusterAgentToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] agent_id: The ID of the agent.
        :param pulumi.Input[_builtins.str] created_at: The ISO8601 datetime when the agent was created.
        :param pulumi.Input[_builtins.int] created_by_user_id: The ID of the user who created the agent.
        :param pulumi.Input[_builtins.str] description: The Description for the agent.
        :param pulumi.Input[_builtins.str] last_used_at: The ISO8601 datetime when the token was last used.
        :param pulumi.Input[_builtins.str] name: The Name of the agent.
        :param pulumi.Input[_builtins.str] project: ID or full path of the project maintained by the authenticated user.
        :param pulumi.Input[_builtins.str] status: The status of the token. Valid values are `active`, `revoked`.
        :param pulumi.Input[_builtins.str] token: The secret token for the agent. The `token` is not available in imported resources.
        :param pulumi.Input[_builtins.int] token_id: The ID of the token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterAgentTokenState.__new__(_ClusterAgentTokenState)

        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by_user_id"] = created_by_user_id
        __props__.__dict__["description"] = description
        __props__.__dict__["last_used_at"] = last_used_at
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["status"] = status
        __props__.__dict__["token"] = token
        __props__.__dict__["token_id"] = token_id
        return ClusterAgentToken(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the agent.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The ISO8601 datetime when the agent was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdByUserId")
    def created_by_user_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the user who created the agent.
        """
        return pulumi.get(self, "created_by_user_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Description for the agent.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="lastUsedAt")
    def last_used_at(self) -> pulumi.Output[_builtins.str]:
        """
        The ISO8601 datetime when the token was last used.
        """
        return pulumi.get(self, "last_used_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the agent.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        ID or full path of the project maintained by the authenticated user.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the token. Valid values are `active`, `revoked`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[_builtins.str]:
        """
        The secret token for the agent. The `token` is not available in imported resources.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the token.
        """
        return pulumi.get(self, "token_id")

