# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectIntegrationYoutrackArgs', 'ProjectIntegrationYoutrack']

@pulumi.input_type
class ProjectIntegrationYoutrackArgs:
    def __init__(__self__, *,
                 issues_url: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 project_url: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ProjectIntegrationYoutrack resource.
        :param pulumi.Input[_builtins.str] issues_url: URL to view an issue in the external issue tracker. Must contain :id.
        :param pulumi.Input[_builtins.str] project: ID or namespace of the project you want to activate integration on.
        :param pulumi.Input[_builtins.str] project_url: URL of the project in the external issue tracker.
        """
        pulumi.set(__self__, "issues_url", issues_url)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "project_url", project_url)

    @_builtins.property
    @pulumi.getter(name="issuesUrl")
    def issues_url(self) -> pulumi.Input[_builtins.str]:
        """
        URL to view an issue in the external issue tracker. Must contain :id.
        """
        return pulumi.get(self, "issues_url")

    @issues_url.setter
    def issues_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "issues_url", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        ID or namespace of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="projectUrl")
    def project_url(self) -> pulumi.Input[_builtins.str]:
        """
        URL of the project in the external issue tracker.
        """
        return pulumi.get(self, "project_url")

    @project_url.setter
    def project_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_url", value)


@pulumi.input_type
class _ProjectIntegrationYoutrackState:
    def __init__(__self__, *,
                 issues_url: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectIntegrationYoutrack resources.
        :param pulumi.Input[_builtins.str] issues_url: URL to view an issue in the external issue tracker. Must contain :id.
        :param pulumi.Input[_builtins.str] project: ID or namespace of the project you want to activate integration on.
        :param pulumi.Input[_builtins.str] project_url: URL of the project in the external issue tracker.
        """
        if issues_url is not None:
            pulumi.set(__self__, "issues_url", issues_url)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_url is not None:
            pulumi.set(__self__, "project_url", project_url)

    @_builtins.property
    @pulumi.getter(name="issuesUrl")
    def issues_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL to view an issue in the external issue tracker. Must contain :id.
        """
        return pulumi.get(self, "issues_url")

    @issues_url.setter
    def issues_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issues_url", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID or namespace of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="projectUrl")
    def project_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the project in the external issue tracker.
        """
        return pulumi.get(self, "project_url")

    @project_url.setter
    def project_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_url", value)


@pulumi.type_token("gitlab:index/projectIntegrationYoutrack:ProjectIntegrationYoutrack")
class ProjectIntegrationYoutrack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 issues_url: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `ProjectIntegrationYoutrack` resource manages the lifecycle of a project integration with YouTrack.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_integrations/#youtrack)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        my_project = gitlab.Project("my_project",
            name="my_project",
            description="My project.",
            visibility_level="public")
        default = gitlab.ProjectIntegrationYoutrack("default",
            project=my_project.id,
            issues_url="https://my.youtrack.com/issue/:id",
            project_url="https://my.youtrack.com")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_integration_youtrack`. For example:

        terraform

        import {

          to = gitlab_project_integration_youtrack.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        You can import a gitlab_project_integration_youtrack state using the project ID, for example:

        ```sh
        $ pulumi import gitlab:index/projectIntegrationYoutrack:ProjectIntegrationYoutrack default 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] issues_url: URL to view an issue in the external issue tracker. Must contain :id.
        :param pulumi.Input[_builtins.str] project: ID or namespace of the project you want to activate integration on.
        :param pulumi.Input[_builtins.str] project_url: URL of the project in the external issue tracker.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectIntegrationYoutrackArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ProjectIntegrationYoutrack` resource manages the lifecycle of a project integration with YouTrack.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_integrations/#youtrack)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        my_project = gitlab.Project("my_project",
            name="my_project",
            description="My project.",
            visibility_level="public")
        default = gitlab.ProjectIntegrationYoutrack("default",
            project=my_project.id,
            issues_url="https://my.youtrack.com/issue/:id",
            project_url="https://my.youtrack.com")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_integration_youtrack`. For example:

        terraform

        import {

          to = gitlab_project_integration_youtrack.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        You can import a gitlab_project_integration_youtrack state using the project ID, for example:

        ```sh
        $ pulumi import gitlab:index/projectIntegrationYoutrack:ProjectIntegrationYoutrack default 1
        ```

        :param str resource_name: The name of the resource.
        :param ProjectIntegrationYoutrackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectIntegrationYoutrackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 issues_url: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectIntegrationYoutrackArgs.__new__(ProjectIntegrationYoutrackArgs)

            if issues_url is None and not opts.urn:
                raise TypeError("Missing required property 'issues_url'")
            __props__.__dict__["issues_url"] = issues_url
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if project_url is None and not opts.urn:
                raise TypeError("Missing required property 'project_url'")
            __props__.__dict__["project_url"] = project_url
        super(ProjectIntegrationYoutrack, __self__).__init__(
            'gitlab:index/projectIntegrationYoutrack:ProjectIntegrationYoutrack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            issues_url: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            project_url: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProjectIntegrationYoutrack':
        """
        Get an existing ProjectIntegrationYoutrack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] issues_url: URL to view an issue in the external issue tracker. Must contain :id.
        :param pulumi.Input[_builtins.str] project: ID or namespace of the project you want to activate integration on.
        :param pulumi.Input[_builtins.str] project_url: URL of the project in the external issue tracker.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectIntegrationYoutrackState.__new__(_ProjectIntegrationYoutrackState)

        __props__.__dict__["issues_url"] = issues_url
        __props__.__dict__["project"] = project
        __props__.__dict__["project_url"] = project_url
        return ProjectIntegrationYoutrack(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="issuesUrl")
    def issues_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL to view an issue in the external issue tracker. Must contain :id.
        """
        return pulumi.get(self, "issues_url")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        ID or namespace of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="projectUrl")
    def project_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL of the project in the external issue tracker.
        """
        return pulumi.get(self, "project_url")

