# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectMergeRequestNoteArgs', 'ProjectMergeRequestNote']

@pulumi.input_type
class ProjectMergeRequestNoteArgs:
    def __init__(__self__, *,
                 body: pulumi.Input[_builtins.str],
                 merge_request_iid: pulumi.Input[_builtins.int],
                 project: pulumi.Input[_builtins.str],
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 merge_request_diff_head_sha: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProjectMergeRequestNote resource.
        :param pulumi.Input[_builtins.str] body: The body of the merge request note.
        :param pulumi.Input[_builtins.int] merge_request_iid: The IID of the merge request to add the note to.
        :param pulumi.Input[_builtins.str] project: The ID or path of the project to add the note to.
        :param pulumi.Input[_builtins.str] created_at: The creation date of the merge request note. Using this field requires the token used with the provider to either be an Admin, or hava a Project or Group Owner role.
        :param pulumi.Input[_builtins.bool] internal: Indicates if the merge request note is internal.
        :param pulumi.Input[_builtins.str] merge_request_diff_head_sha: The diff head SHA of the merge request when the note was created.
        """
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "merge_request_iid", merge_request_iid)
        pulumi.set(__self__, "project", project)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if merge_request_diff_head_sha is not None:
            pulumi.set(__self__, "merge_request_diff_head_sha", merge_request_diff_head_sha)

    @_builtins.property
    @pulumi.getter
    def body(self) -> pulumi.Input[_builtins.str]:
        """
        The body of the merge request note.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "body", value)

    @_builtins.property
    @pulumi.getter(name="mergeRequestIid")
    def merge_request_iid(self) -> pulumi.Input[_builtins.int]:
        """
        The IID of the merge request to add the note to.
        """
        return pulumi.get(self, "merge_request_iid")

    @merge_request_iid.setter
    def merge_request_iid(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "merge_request_iid", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The ID or path of the project to add the note to.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation date of the merge request note. Using this field requires the token used with the provider to either be an Admin, or hava a Project or Group Owner role.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def internal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the merge request note is internal.
        """
        return pulumi.get(self, "internal")

    @internal.setter
    def internal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internal", value)

    @_builtins.property
    @pulumi.getter(name="mergeRequestDiffHeadSha")
    def merge_request_diff_head_sha(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The diff head SHA of the merge request when the note was created.
        """
        return pulumi.get(self, "merge_request_diff_head_sha")

    @merge_request_diff_head_sha.setter
    def merge_request_diff_head_sha(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "merge_request_diff_head_sha", value)


@pulumi.input_type
class _ProjectMergeRequestNoteState:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 merge_request_diff_head_sha: Optional[pulumi.Input[_builtins.str]] = None,
                 merge_request_iid: Optional[pulumi.Input[_builtins.int]] = None,
                 note_id: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resolvable: Optional[pulumi.Input[_builtins.bool]] = None,
                 system: Optional[pulumi.Input[_builtins.bool]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectMergeRequestNote resources.
        :param pulumi.Input[_builtins.str] body: The body of the merge request note.
        :param pulumi.Input[_builtins.str] created_at: The creation date of the merge request note. Using this field requires the token used with the provider to either be an Admin, or hava a Project or Group Owner role.
        :param pulumi.Input[_builtins.bool] internal: Indicates if the merge request note is internal.
        :param pulumi.Input[_builtins.str] merge_request_diff_head_sha: The diff head SHA of the merge request when the note was created.
        :param pulumi.Input[_builtins.int] merge_request_iid: The IID of the merge request to add the note to.
        :param pulumi.Input[_builtins.int] note_id: The ID of the merge request note.
        :param pulumi.Input[_builtins.str] project: The ID or path of the project to add the note to.
        :param pulumi.Input[_builtins.bool] resolvable: Indicates if the merge request note is resolvable.
        :param pulumi.Input[_builtins.bool] system: Indicates if the merge request note is a system note.
        :param pulumi.Input[_builtins.str] updated_at: The last updated date of the merge request note.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if merge_request_diff_head_sha is not None:
            pulumi.set(__self__, "merge_request_diff_head_sha", merge_request_diff_head_sha)
        if merge_request_iid is not None:
            pulumi.set(__self__, "merge_request_iid", merge_request_iid)
        if note_id is not None:
            pulumi.set(__self__, "note_id", note_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resolvable is not None:
            pulumi.set(__self__, "resolvable", resolvable)
        if system is not None:
            pulumi.set(__self__, "system", system)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The body of the merge request note.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "body", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation date of the merge request note. Using this field requires the token used with the provider to either be an Admin, or hava a Project or Group Owner role.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def internal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the merge request note is internal.
        """
        return pulumi.get(self, "internal")

    @internal.setter
    def internal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internal", value)

    @_builtins.property
    @pulumi.getter(name="mergeRequestDiffHeadSha")
    def merge_request_diff_head_sha(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The diff head SHA of the merge request when the note was created.
        """
        return pulumi.get(self, "merge_request_diff_head_sha")

    @merge_request_diff_head_sha.setter
    def merge_request_diff_head_sha(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "merge_request_diff_head_sha", value)

    @_builtins.property
    @pulumi.getter(name="mergeRequestIid")
    def merge_request_iid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The IID of the merge request to add the note to.
        """
        return pulumi.get(self, "merge_request_iid")

    @merge_request_iid.setter
    def merge_request_iid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "merge_request_iid", value)

    @_builtins.property
    @pulumi.getter(name="noteId")
    def note_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the merge request note.
        """
        return pulumi.get(self, "note_id")

    @note_id.setter
    def note_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "note_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID or path of the project to add the note to.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def resolvable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the merge request note is resolvable.
        """
        return pulumi.get(self, "resolvable")

    @resolvable.setter
    def resolvable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resolvable", value)

    @_builtins.property
    @pulumi.getter
    def system(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the merge request note is a system note.
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last updated date of the merge request note.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("gitlab:index/projectMergeRequestNote:ProjectMergeRequestNote")
class ProjectMergeRequestNote(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 merge_request_diff_head_sha: Optional[pulumi.Input[_builtins.str]] = None,
                 merge_request_iid: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `ProjectMergeRequestNote` resource manages the lifecycle of a project merge request note.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/notes/#merge-requests)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.Project("example",
            name="example project",
            description="Lorem Ipsum",
            visibility_level="public")
        example_project_merge_request_note = gitlab.ProjectMergeRequestNote("example",
            project=example.id,
            merge_request_iid=456,
            body="Example note")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_merge_request_note`. For example:

        terraform

        import {

          to = gitlab_project_merge_request_note.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        A GitLab Project Merge Request Note can be imported using a key composed of `<project-id>:<merge-request-iid>:<note-id>`, for example:

        ```sh
        $ pulumi import gitlab:index/projectMergeRequestNote:ProjectMergeRequestNote example "12345:1:3"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] body: The body of the merge request note.
        :param pulumi.Input[_builtins.str] created_at: The creation date of the merge request note. Using this field requires the token used with the provider to either be an Admin, or hava a Project or Group Owner role.
        :param pulumi.Input[_builtins.bool] internal: Indicates if the merge request note is internal.
        :param pulumi.Input[_builtins.str] merge_request_diff_head_sha: The diff head SHA of the merge request when the note was created.
        :param pulumi.Input[_builtins.int] merge_request_iid: The IID of the merge request to add the note to.
        :param pulumi.Input[_builtins.str] project: The ID or path of the project to add the note to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectMergeRequestNoteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ProjectMergeRequestNote` resource manages the lifecycle of a project merge request note.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/notes/#merge-requests)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.Project("example",
            name="example project",
            description="Lorem Ipsum",
            visibility_level="public")
        example_project_merge_request_note = gitlab.ProjectMergeRequestNote("example",
            project=example.id,
            merge_request_iid=456,
            body="Example note")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_merge_request_note`. For example:

        terraform

        import {

          to = gitlab_project_merge_request_note.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        A GitLab Project Merge Request Note can be imported using a key composed of `<project-id>:<merge-request-iid>:<note-id>`, for example:

        ```sh
        $ pulumi import gitlab:index/projectMergeRequestNote:ProjectMergeRequestNote example "12345:1:3"
        ```

        :param str resource_name: The name of the resource.
        :param ProjectMergeRequestNoteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectMergeRequestNoteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 merge_request_diff_head_sha: Optional[pulumi.Input[_builtins.str]] = None,
                 merge_request_iid: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectMergeRequestNoteArgs.__new__(ProjectMergeRequestNoteArgs)

            if body is None and not opts.urn:
                raise TypeError("Missing required property 'body'")
            __props__.__dict__["body"] = body
            __props__.__dict__["created_at"] = created_at
            __props__.__dict__["internal"] = internal
            __props__.__dict__["merge_request_diff_head_sha"] = merge_request_diff_head_sha
            if merge_request_iid is None and not opts.urn:
                raise TypeError("Missing required property 'merge_request_iid'")
            __props__.__dict__["merge_request_iid"] = merge_request_iid
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["note_id"] = None
            __props__.__dict__["resolvable"] = None
            __props__.__dict__["system"] = None
            __props__.__dict__["updated_at"] = None
        super(ProjectMergeRequestNote, __self__).__init__(
            'gitlab:index/projectMergeRequestNote:ProjectMergeRequestNote',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            body: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            internal: Optional[pulumi.Input[_builtins.bool]] = None,
            merge_request_diff_head_sha: Optional[pulumi.Input[_builtins.str]] = None,
            merge_request_iid: Optional[pulumi.Input[_builtins.int]] = None,
            note_id: Optional[pulumi.Input[_builtins.int]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            resolvable: Optional[pulumi.Input[_builtins.bool]] = None,
            system: Optional[pulumi.Input[_builtins.bool]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProjectMergeRequestNote':
        """
        Get an existing ProjectMergeRequestNote resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] body: The body of the merge request note.
        :param pulumi.Input[_builtins.str] created_at: The creation date of the merge request note. Using this field requires the token used with the provider to either be an Admin, or hava a Project or Group Owner role.
        :param pulumi.Input[_builtins.bool] internal: Indicates if the merge request note is internal.
        :param pulumi.Input[_builtins.str] merge_request_diff_head_sha: The diff head SHA of the merge request when the note was created.
        :param pulumi.Input[_builtins.int] merge_request_iid: The IID of the merge request to add the note to.
        :param pulumi.Input[_builtins.int] note_id: The ID of the merge request note.
        :param pulumi.Input[_builtins.str] project: The ID or path of the project to add the note to.
        :param pulumi.Input[_builtins.bool] resolvable: Indicates if the merge request note is resolvable.
        :param pulumi.Input[_builtins.bool] system: Indicates if the merge request note is a system note.
        :param pulumi.Input[_builtins.str] updated_at: The last updated date of the merge request note.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectMergeRequestNoteState.__new__(_ProjectMergeRequestNoteState)

        __props__.__dict__["body"] = body
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["internal"] = internal
        __props__.__dict__["merge_request_diff_head_sha"] = merge_request_diff_head_sha
        __props__.__dict__["merge_request_iid"] = merge_request_iid
        __props__.__dict__["note_id"] = note_id
        __props__.__dict__["project"] = project
        __props__.__dict__["resolvable"] = resolvable
        __props__.__dict__["system"] = system
        __props__.__dict__["updated_at"] = updated_at
        return ProjectMergeRequestNote(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def body(self) -> pulumi.Output[_builtins.str]:
        """
        The body of the merge request note.
        """
        return pulumi.get(self, "body")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation date of the merge request note. Using this field requires the token used with the provider to either be an Admin, or hava a Project or Group Owner role.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def internal(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if the merge request note is internal.
        """
        return pulumi.get(self, "internal")

    @_builtins.property
    @pulumi.getter(name="mergeRequestDiffHeadSha")
    def merge_request_diff_head_sha(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The diff head SHA of the merge request when the note was created.
        """
        return pulumi.get(self, "merge_request_diff_head_sha")

    @_builtins.property
    @pulumi.getter(name="mergeRequestIid")
    def merge_request_iid(self) -> pulumi.Output[_builtins.int]:
        """
        The IID of the merge request to add the note to.
        """
        return pulumi.get(self, "merge_request_iid")

    @_builtins.property
    @pulumi.getter(name="noteId")
    def note_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the merge request note.
        """
        return pulumi.get(self, "note_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID or path of the project to add the note to.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def resolvable(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if the merge request note is resolvable.
        """
        return pulumi.get(self, "resolvable")

    @_builtins.property
    @pulumi.getter
    def system(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if the merge request note is a system note.
        """
        return pulumi.get(self, "system")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The last updated date of the merge request note.
        """
        return pulumi.get(self, "updated_at")

