# Quick Start

Get started with debrepomanager in 5 minutes.

## Installation

```bash
pip install debrepomanager
```

## Configuration

Create `~/.debrepomanager/config.yaml`:

```yaml
gpg:
  key_id: "YOUR_GPG_KEY_ID"

aptly:
  root_base: "/srv/aptly"
  publish_base: "/srv/repo/public"

repositories:
  architectures: [amd64, arm64]
```

## First Steps

### 1. Create release

```bash
debrepomanager release add bookworm
```

Creates repositories for default components:
- `jethome-tools`
- `jethome-bookworm`
- `jethome-armbian`

### 2. Add packages

```bash
debrepomanager add --codename bookworm \
  --component jethome-tools \
  --package-dir /path/to/packages/
```

Or with environment isolation:

```bash
# To stable (production)
debrepomanager add --environment stable \
  --codename bookworm \
  --package-dir /path/to/packages/

# To beta (testing)
debrepomanager add --environment beta \
  --codename bookworm \
  --package-dir /path/to/packages/
```

### 3. List packages

```bash
debrepomanager list --codename bookworm --component jethome-tools
```

### 4. Configure clients

On client machines:

```bash
# Import GPG key
wget -qO - http://repo.site.com/pubkey.gpg | \
  sudo gpg --dearmor -o /etc/apt/trusted.gpg.d/repo.gpg

# Add repository
echo "deb http://repo.site.com/bookworm jethome-tools main" | \
  sudo tee /etc/apt/sources.list.d/repo.list

# Update and install
sudo apt update
sudo apt install your-package
```

## Common Commands

```bash
# List all repositories
debrepomanager list

# Add new release
debrepomanager release add trixie

# Remove old release
debrepomanager release remove bullseye --backup --confirm

# Cleanup old versions
debrepomanager cleanup --codename bookworm --component jethome-tools --apply

# Rotate GPG key
debrepomanager rotate-gpg-key --new-key-id NEWKEY123

# Fix symlinks
debrepomanager fix-symlinks
```

## Environment Isolation

Use `--environment` for stable/beta/test isolation:

```bash
# Stable (production)
debrepomanager add --environment stable --codename bookworm --package-dir ./packages/

# Beta (testing)
debrepomanager add --environment beta --codename bookworm --package-dir ./packages/

# Test (development)
debrepomanager add --environment test --codename bookworm --package-dir ./packages/
```

URLs:
- Stable: `http://repo.site.com/`
- Beta: `http://repo.site.com/beta/`
- Test: `http://repo.site.com/test/`

## Next Steps

- 📖 [Full Documentation](docs/)
- 📋 [Command Cheat Sheet](docs/CHEATSHEET.md)
- 🔄 [Common Workflows](docs/WORKFLOWS.md)
- 🚀 [Deployment Guide](docs/DEPLOYMENT_GUIDE.md)
- 🔀 [Migration Guide](docs/MIGRATION.md) (if upgrading from v0.3.x)

## Help

```bash
# Global help
debrepomanager --help

# Command help
debrepomanager add --help
debrepomanager release --help
debrepomanager release add --help
```

## Troubleshooting

### "debrepomanager command not found"

```bash
# Install or add to PATH
pip install debrepomanager
export PATH=$PATH:~/.local/bin
```

### "Config file not found"

Create config in one of these locations:
- `/etc/debrepomanager/config.yaml` (system)
- `~/.debrepomanager/config.yaml` (user)
- `./config.yaml` (local)

Or specify explicitly:

```bash
debrepomanager --config /path/to/config.yaml <command>
```

### "GPG signing fails"

```bash
# Check GPG key
gpg --list-secret-keys

# Restart gpg-agent
gpgconf --kill gpg-agent
gpg-connect-agent /bye
```

---

**Made with ❤️ by JetHome Team**

