# debrepomanager Cheat Sheet

Краткая справка команд для быстрого доступа.

## Быстрый старт с нуля

### 1. Первоначальная настройка

```bash
# Установка
pip install debrepomanager

# Создать конфигурацию
mkdir -p ~/.debrepomanager
cat > ~/.debrepomanager/config.yaml <<EOF
gpg:
  key_id: "YOUR_GPG_KEY_ID"
aptly:
  root_base: "/srv/aptly"
  publish_base: "/srv/repo/public"
repositories:
  architectures: [amd64, arm64, riscv64]
EOF
```

### 2. Добавить новый релиз

```bash
# Создать репозитории для нового релиза
debrepomanager release add trixie

# Или с конкретными компонентами
debrepomanager release add trixie --components jethome-tools --components jethome-trixie
```

### 3. Добавить пакеты

```bash
# В production (stable)
debrepomanager add --environment stable \
  --codename bookworm \
  --package-dir /path/to/packages/

# В beta для тестирования
debrepomanager add --environment beta \
  --codename bookworm \
  --package-dir /path/to/packages/ \
  --component jethome-tools

# С явным указанием компонента
debrepomanager add \
  --codename bookworm \
  --component jethome-custom \
  --package-dir /path/to/packages/
```

### 4. Обновить пакеты

```bash
# Просто добавьте новые версии - автоматически заменят старые
debrepomanager add --codename bookworm --component jethome-tools \
  --package-dir /path/to/new-versions/
```

### 5. Удалить старые версии (retention)

```bash
# Проверить что будет удалено (dry-run)
debrepomanager cleanup --codename bookworm --component jethome-tools

# Применить очистку
debrepomanager cleanup --codename bookworm --component jethome-tools --apply
```

### 6. Удалить устаревший релиз

```bash
# Удалить EOL релиз (с backup)
debrepomanager release remove bullseye --backup --confirm

# Без backup (если уверены)
debrepomanager release remove bullseye --no-backup --force --confirm
```

## Частые операции

### Просмотр

```bash
# Все репозитории (группировка по codenames)
debrepomanager list

# С статистикой (количество пакетов и размер)
debrepomanager list --stats

# Репозитории конкретного релиза
debrepomanager list --codename bookworm

# Репозитории конкретного релиза со статистикой
debrepomanager list --codename bookworm --stats

# Пакеты в компоненте
debrepomanager list --codename bookworm --component jethome-tools

# Пакеты в компоненте со статистикой
debrepomanager list --codename bookworm --component jethome-tools --stats
```

### Управление репозиториями

```bash
# Создать новый компонент
debrepomanager create-repo --codename bookworm --component jethome-new

# Удалить компонент
debrepomanager delete-repo --codename bookworm --component old-component --confirm
```

### GPG операции

```bash
# Ротация GPG ключа
debrepomanager rotate-gpg-key --new-key-id NEWKEY123

# С grace period (оба ключа валидны)
debrepomanager rotate-gpg-key --new-key-id NEWKEY123 --grace-period
```

### Dual format symlinks

```bash
# Проверить симлинки
debrepomanager fix-symlinks --check-only

# Исправить все симлинки
debrepomanager fix-symlinks

# Для конкретного релиза
debrepomanager fix-symlinks --codename trixie
```

### Release lifecycle

```bash
# Добавить новый релиз
debrepomanager release add trixie
debrepomanager release add oracular --components jethome-tools --components jethome-desktop

# Удалить устаревший релиз
debrepomanager release remove bullseye --confirm
debrepomanager release remove jammy --no-backup --force --confirm
```

### Environment isolation

```bash
# Stable (production)
debrepomanager add --environment stable --codename bookworm --package-dir ./packages/

# Beta (testing)
debrepomanager add --environment beta --codename bookworm --package-dir ./packages/

# Test (development)
debrepomanager add --environment test --codename bookworm --package-dir ./packages/
```

## Глобальные опции

```bash
# Verbose режим (детальные логи)
debrepomanager --verbose <command>

# Dry-run (симуляция без изменений)
debrepomanager --dry-run <command>

# Указать конфигурационный файл
debrepomanager --config /path/to/config.yaml <command>

# Указать publish prefix для изоляции
debrepomanager --publish-prefix beta <command>
```

## Переменные окружения

```bash
# Путь к конфигу
export REPOMANAGER_CONFIG=/path/to/config.yaml

# Verbose режим
export REPOMANAGER_VERBOSE=1

# Dry-run (ничего не изменять)
export REPOMANAGER_DRY_RUN=1

# Publish prefix
export REPOMANAGER_PUBLISH_PREFIX=beta
```

## Распространенные сценарии

### Workflow 1: Ежедневная загрузка пакетов

```bash
# 1. В beta для тестирования
debrepomanager add --environment beta --codename bookworm --package-dir ./build/

# 2. Тестирование...

# 3. В stable когда протестировано
debrepomanager add --environment stable --codename bookworm --package-dir ./build/
```

### Workflow 2: Добавление нового Debian релиза

```bash
# 1. Создать релиз
debrepomanager release add trixie

# 2. Загрузить пакеты
debrepomanager add --codename trixie --component jethome-tools --package-dir ./packages/

# 3. Создать symlinks
debrepomanager fix-symlinks --codename trixie

# 4. Обновить nginx
./scripts/update-nginx-codenames.sh
sudo systemctl reload nginx
```

### Workflow 3: Удаление EOL релиза

```bash
# 1. Проверить активность
sudo grep "/bullseye/" /var/log/nginx/repo-access.log* | wc -l

# 2. Удалить с backup
debrepomanager release remove bullseye --backup --confirm

# 3. Обновить nginx
./scripts/update-nginx-codenames.sh
sudo systemctl reload nginx
```

### Workflow 4: Еженедельная очистка

```bash
# Для всех компонентов
for component in jethome-tools jethome-armbian jethome-bookworm; do
  debrepomanager cleanup --codename bookworm --component $component --apply
done
```

## Миграция со старых скриптов

### repoadd → debrepomanager add --environment

```bash
# Старое
./repoadd stable bookworm armbian-bookworm

# Новое
debrepomanager add --environment stable --codename bookworm --package-dir armbian-bookworm
```

### add-release.sh → debrepomanager release add

```bash
# Старое
./add-release.sh trixie

# Новое
debrepomanager release add trixie
```

### remove-release.sh → debrepomanager release remove

```bash
# Старое
./remove-release.sh bullseye yes

# Новое
debrepomanager release remove bullseye --backup --confirm
```

## См. также

- [WORKFLOWS.md](WORKFLOWS.md) - Подробные рабочие процессы
- [MIGRATION.md](MIGRATION.md) - Полный гид по миграции
- [QUICKSTART.md](QUICKSTART.md) - Быстрый старт за 5 минут
- [README.md](../README.md) - Полная документация

