# Migration Guide

Руководство по миграции с bash-скриптов (v0.3.x) на Python CLI (v0.4.0+).

## Обзор изменений

### v0.4.0 (Current)

- ✅ **Новые команды**: `debrepomanager release add/remove`
- ✅ **Environment support**: `--environment stable/beta/test`  
- ✅ **Auto-component generation**: автоматическое имя компонента из директории
- ⚠️  **Deprecated**: bash скрипты `repoadd`, `add-release.sh`, `remove-release.sh`

### v0.5.0 (Planned)

- ❌ Wrapper скрипты будут удалены
- ✅ Только Python CLI

### v0.6.0 (Planned)

- ❌ Legacy скрипты будут удалены полностью

## Миграция команд

### 1. repoadd → debrepomanager add --environment

#### Базовое использование

**Старое:**
```bash
./repoadd stable bookworm armbian-bookworm
```

**Новое:**
```bash
debrepomanager add --environment stable \
  --codename bookworm \
  --package-dir armbian-bookworm
```

#### С явным компонентом

**Старое:**
```bash
./repoadd stable bookworm ./packages/ jethome-custom
```

**Новое:**
```bash
debrepomanager add --environment stable \
  --codename bookworm \
  --component jethome-custom \
  --package-dir ./packages/
```

#### Beta/Test окружения

**Старое:**
```bash
./repoadd beta noble jethome-tools
./repoadd test bookworm ./packages/
```

**Новое:**
```bash
debrepomanager add --environment beta \
  --codename noble \
  --package-dir jethome-tools

debrepomanager add --environment test \
  --codename bookworm \
  --package-dir ./packages/
```

#### Переменные окружения

**Старое:**
```bash
DEBUG=1 DRY_RUN=1 ./repoadd stable bookworm packages/
```

**Новое:**
```bash
debrepomanager --verbose --dry-run add \
  --environment stable \
  --codename bookworm \
  --package-dir packages/
```

### 2. add-release.sh → debrepomanager release add

#### Базовое использование

**Старое:**
```bash
./add-release.sh trixie
```

**Новое:**
```bash
debrepomanager release add trixie
```

#### С конкретными компонентами

**Старое:**
```bash
./add-release.sh trixie "jethome-tools jethome-trixie jethome-desktop"
```

**Новое:**
```bash
debrepomanager release add trixie \
  --components jethome-tools \
  --components jethome-trixie \
  --components jethome-desktop
```

#### Пропустить создание symlinks

**Новое:**
```bash
debrepomanager release add trixie --skip-symlinks
```

### 3. remove-release.sh → debrepomanager release remove

#### С backup

**Старое:**
```bash
./remove-release.sh bullseye yes
```

**Новое:**
```bash
debrepomanager release remove bullseye --backup --confirm
```

#### Без backup

**Старое:**
```bash
./remove-release.sh jammy no
```

**Новое:**
```bash
debrepomanager release remove jammy --no-backup --confirm
```

#### Force (пропустить проверку активности)

**Новое:**
```bash
debrepomanager release remove bullseye --force --confirm
```

## Миграция CI/CD workflows

### GitHub Actions

**Старое (v0.3.x):**

```yaml
name: Upload Packages

on:
  push:
    branches: [main]

jobs:
  upload:
    runs-on: ubuntu-latest
    steps:
      - uses: actions/checkout@v4
      
      - name: Upload to stable
        run: ./scripts/repoadd stable bookworm armbian-bookworm
```

**Новое (v0.4.0+):**

```yaml
name: Upload Packages

on:
  push:
    branches: [main]

jobs:
  upload:
    runs-on: ubuntu-latest
    steps:
      - uses: actions/checkout@v4
      
      - name: Install debrepomanager
        run: pip install debrepomanager
      
      - name: Upload to stable
        run: |
          debrepomanager add \
            --environment stable \
            --codename bookworm \
            --package-dir armbian-bookworm
```

### GitLab CI

**Старое:**

```yaml
deploy:
  script:
    - ./scripts/repoadd stable bookworm packages/
```

**Новое:**

```yaml
deploy:
  before_script:
    - pip install debrepomanager
  script:
    - debrepomanager add --environment stable --codename bookworm --package-dir packages/
```

## Обратная совместимость

### Wrapper скрипты (v0.4.0)

В v0.4.0 старые скрипты работают как обертки с предупреждениями:

```bash
./repoadd stable bookworm packages/

# Вывод:
# ⚠️  DEPRECATION WARNING
# This script is deprecated and will be removed in v0.5.0
# Use: debrepomanager add --environment stable --codename bookworm --package-dir packages/
#
# [затем выполняется новая команда]
```

### Отключение предупреждений

Если нужно временно отключить предупреждения (для логов CI/CD):

```bash
./repoadd stable bookworm packages/ 2>/dev/null
```

## Проверка миграции

### 1. Audit существующих скриптов

```bash
# Найти все использования старых скриптов
grep -r "repoadd" .
grep -r "add-release.sh" .
grep -r "remove-release.sh" .
```

### 2. Тестирование с --dry-run

```bash
# Сначала dry-run для проверки
debrepomanager --dry-run add \
  --environment stable \
  --codename bookworm \
  --package-dir packages/

# Если все OK - выполнить реально
debrepomanager add \
  --environment stable \
  --codename bookworm \
  --package-dir packages/
```

### 3. Параллельное тестирование

Можно временно использовать оба подхода:

```bash
# Старый способ (в beta)
./repoadd beta bookworm packages/

# Новый способ (тоже в beta)
debrepomanager add --environment beta --codename bookworm --package-dir packages/

# Сравнить результаты
debrepomanager list --codename bookworm --component jethome-packages
```

## Преимущества новых команд

### 1. Единый интерфейс

Все функции в одном CLI инструменте:

```bash
debrepomanager add ...
debrepomanager release add ...
debrepomanager release remove ...
debrepomanager cleanup ...
debrepomanager rotate-gpg-key ...
```

### 2. Лучшая обработка ошибок

```python
# Python CLI с proper error handling
try:
    manager.add_packages(...)
except ValidationError as e:
    click.echo(f"Error: {e}", err=True)
    sys.exit(1)
```

### 3. Type safety

```python
def add_release(
    codename: str,
    components: Optional[List[str]] = None,
    skip_symlinks: bool = False,
) -> Dict:
    ...
```

### 4. Comprehensive testing

- 304 тестов с 80%+ покрытием
- Unit + Integration + E2E tests
- Проверка всех edge cases

### 5. Dry-run поддержка

```bash
debrepomanager --dry-run release add trixie
# Dry-run mode: No changes will be made
# Would create release: trixie
# Components: jethome-tools, jethome-trixie, jethome-armbian (default)
```

### 6. Verbose режим

```bash
debrepomanager --verbose add --environment stable --codename bookworm --package-dir packages/
# [INFO] Loaded configuration from: /etc/debrepomanager/config.yaml
# [INFO] Using publish prefix: 
# [INFO] Auto-generated component: jethome-packages
# [INFO] Found 42 .deb package(s) in packages/
# [INFO] Adding 42 package(s) to bookworm/jethome-packages
# ...
```

## Troubleshooting

### Проблема: "debrepomanager command not found"

**Решение:**

```bash
# Установить debrepomanager
pip install debrepomanager

# Или добавить в PATH
export PATH=$PATH:~/.local/bin
```

### Проблема: Разные результаты между старым и новым

**Решение:**

```bash
# Проверить verbose вывод
debrepomanager --verbose add ...

# Сравнить с legacy скриптом
DEBUG=1 ./scripts/legacy/repoadd ...
```

### Проблема: CI/CD ломается после миграции

**Решение:**

1. Проверить что debrepomanager установлен в CI/CD

```yaml
- name: Install debrepomanager
  run: pip install debrepomanager
```

2. Проверить переменные окружения

```yaml
- name: Upload packages
  env:
    REPOMANAGER_CONFIG: /etc/debrepomanager/config.yaml
  run: debrepomanager add ...
```

## Поддержка

Если возникли проблемы:

1. Проверьте [CHEATSHEET.md](CHEATSHEET.md) для quick reference
2. Посмотрите [WORKFLOWS.md](WORKFLOWS.md) для примеров
3. Используйте `--verbose` для детальной диагностики
4. Откройте issue на GitHub: https://github.com/jethome-iot/repomanager/issues

## Roadmap

- **v0.4.0** (Current): Новые команды + deprecated старые
- **v0.5.0** (Q2 2025): Удаление wrapper скриптов
- **v0.6.0** (Q3 2025): Удаление legacy директории

## См. также

- [CHEATSHEET.md](CHEATSHEET.md) - Краткая справка
- [WORKFLOWS.md](WORKFLOWS.md) - Типовые сценарии
- [README.md](../README.md) - Полная документация

