# Документация Debian Repository Manager

Полная документация проекта для пользователей и администраторов.

## 📚 Основные документы

### Начало работы

| Документ | Описание | Для кого |
|----------|----------|----------|
| [**QUICKSTART.md**](QUICKSTART.md) | Быстрый старт за 5 минут | Все |
| [**CONFIG.md**](CONFIG.md) | Детальное описание всех параметров конфигурации | Администраторы |
| [**DEPLOYMENT_GUIDE.md**](DEPLOYMENT_GUIDE.md) | Полное руководство по развертыванию на сервере | Администраторы |

### Использование

| Документ | Описание | Для кого |
|----------|----------|----------|
| [**Основной README**](../README.md) | Команды CLI и примеры использования | Все |
| [**REPOADD_SCRIPT.md**](REPOADD_SCRIPT.md) | Упрощенный скрипт для загрузки пакетов | Пользователи |
| [**APT_CONFIGURATION.md**](APT_CONFIGURATION.md) | Настройка APT на клиентских системах | Пользователи |

### Расширенная настройка

| Документ | Описание | Для кого |
|----------|----------|----------|
| [**NGINX_MULTI_ENV.md**](NGINX_MULTI_ENV.md) | Настройка нескольких окружений (stable/beta/test) | Администраторы |
| [**DUAL_FORMAT.md**](DUAL_FORMAT.md) | Поддержка двух форматов URL одновременно | Администраторы |
| [**ARCHITECTURE.md**](ARCHITECTURE.md) | Архитектура системы и ключевые решения | Администраторы, разработчики |

### Разработка

| Документ | Описание | Для кого |
|----------|----------|----------|
| [**DEVELOPMENT.md**](DEVELOPMENT.md) | Setup окружения, тесты, code style | Разработчики |
| [**CHANGELOG.md**](CHANGELOG.md) | История изменений | Все |

## 🚀 Быстрая навигация

### Хочу начать использовать
1. [QUICKSTART.md](QUICKSTART.md) - установка и первый репозиторий за 5 минут
2. [CONFIG.md](CONFIG.md) - настройка конфигурации
3. [Основной README](../README.md) - команды CLI и примеры

### Хочу развернуть на production
1. [DEPLOYMENT_GUIDE.md](DEPLOYMENT_GUIDE.md) - полное руководство по развертыванию
2. [NGINX_MULTI_ENV.md](NGINX_MULTI_ENV.md) - настройка нескольких окружений
3. [CONFIG.md](CONFIG.md) - параметры конфигурации

### Хочу настроить клиентские системы
1. [APT_CONFIGURATION.md](APT_CONFIGURATION.md) - примеры для разных дистрибутивов
2. [DUAL_FORMAT.md](DUAL_FORMAT.md) - если нужны разные форматы URL

### Хочу использовать упрощенный скрипт
1. [REPOADD_SCRIPT.md](REPOADD_SCRIPT.md) - документация скрипта repoadd
2. [QUICKSTART.md](QUICKSTART.md#способ-1-упрощенный-repoadd-script) - быстрые примеры

### Хочу понять как работает
1. [ARCHITECTURE.md](ARCHITECTURE.md) - архитектурные решения и дизайн
2. [Основной README](../README.md) - обзор возможностей

## 📖 Порядок чтения для новичков

### День 1: Понимание и установка
1. [Основной README](../README.md) - обзор возможностей (5 минут)
2. [QUICKSTART.md](QUICKSTART.md) - установка и первый репозиторий (10 минут)
3. Попробовать создать тестовый репозиторий

### День 2: Настройка
1. [CONFIG.md](CONFIG.md) - изучить параметры конфигурации
2. [APT_CONFIGURATION.md](APT_CONFIGURATION.md) - настроить клиентские системы
3. [REPOADD_SCRIPT.md](REPOADD_SCRIPT.md) - если нужен упрощенный workflow

### День 3: Production (если нужно)
1. [DEPLOYMENT_GUIDE.md](DEPLOYMENT_GUIDE.md) - развертывание на сервере
2. [NGINX_MULTI_ENV.md](NGINX_MULTI_ENV.md) - настройка окружений
3. [ARCHITECTURE.md](ARCHITECTURE.md) - понимание архитектуры

## 🎯 Документация по ролям

### Системный администратор
- ✅ [QUICKSTART.md](QUICKSTART.md) - установка и быстрый старт
- ✅ [DEPLOYMENT_GUIDE.md](DEPLOYMENT_GUIDE.md) - развертывание на production
- ✅ [CONFIG.md](CONFIG.md) - настройка конфигурации
- ✅ [NGINX_MULTI_ENV.md](NGINX_MULTI_ENV.md) - несколько окружений
- ⚠️ [ARCHITECTURE.md](ARCHITECTURE.md) - понимание системы

### DevOps инженер
- ✅ [DEPLOYMENT_GUIDE.md](DEPLOYMENT_GUIDE.md) - развертывание
- ✅ [QUICKSTART.md](QUICKSTART.md#github-actions-setup) - GitHub Actions
- ✅ [CONFIG.md](CONFIG.md) - параметры конфигурации
- ✅ [NGINX_MULTI_ENV.md](NGINX_MULTI_ENV.md) - окружения
- ⚠️ [ARCHITECTURE.md](ARCHITECTURE.md) - архитектура

### Пользователь / Package Maintainer
- ✅ [QUICKSTART.md](QUICKSTART.md) - быстрый старт
- ✅ [REPOADD_SCRIPT.md](REPOADD_SCRIPT.md) - упрощенный скрипт
- ✅ [Основной README](../README.md) - команды CLI
- ⚠️ [APT_CONFIGURATION.md](APT_CONFIGURATION.md) - настройка клиентов

### Python разработчик
- ✅ [DEVELOPMENT.md](DEVELOPMENT.md) - setup окружения и workflow
- ✅ [ARCHITECTURE.md](ARCHITECTURE.md) - архитектура системы
- ✅ [Основной README](../README.md) - обзор функциональности
- ⚠️ [CHANGELOG.md](CHANGELOG.md) - история изменений

## 📝 Поддержка документации

### Когда обновлять
- **Новая функциональность** → Основной README + QUICKSTART
- **Изменение конфигурации** → CONFIG.md + config.yaml.example
- **Изменение API** → CHANGELOG.md
- **Архитектурные изменения** → ARCHITECTURE.md
- **Новые примеры использования** → QUICKSTART / REPOADD_SCRIPT

### Как обновить
1. Редактировать нужные .md файлы
2. Обновить примеры в README если нужно
3. Commit с префиксом `docs:`

## 🔗 Внешние ресурсы

### Технологии
- [aptly Documentation](https://www.aptly.info/doc/overview/)
- [Python Debian](https://pypi.org/project/python-debian/)
- [Click Documentation](https://click.palletsprojects.com/)

### Стандарты
- [Debian Repository Format](https://wiki.debian.org/DebianRepository/Format)
- [Semantic Versioning](https://semver.org/)
- [Keep a Changelog](https://keepachangelog.com/)
- [Conventional Commits](https://www.conventionalcommits.org/)

## 💬 Получить помощь

- **Issues**: https://github.com/jethome-iot/repomanager/issues
- **Email**: support@jethome.ru

## 📊 Список документов

| Документ | Описание | Статус |
|----------|----------|--------|
| QUICKSTART.md | Быстрый старт за 5 минут | ✅ Актуален |
| README.md | Обзор функциональности и CLI | ✅ Актуален |
| CONFIG.md | Параметры конфигурации | ✅ Актуален |
| DEPLOYMENT_GUIDE.md | Руководство по развертыванию | ✅ Актуален |
| REPOADD_SCRIPT.md | Упрощенный скрипт загрузки | ✅ Актуален |
| APT_CONFIGURATION.md | Настройка клиентов | ✅ Актуален |
| NGINX_MULTI_ENV.md | Несколько окружений | ✅ Актуален |
| DUAL_FORMAT.md | Два формата URL | ✅ Актуален |
| ARCHITECTURE.md | Архитектура системы | ✅ Актуален |
| DEVELOPMENT.md | Разработка | ✅ Актуален |
| CHANGELOG.md | История изменений | ✅ Актуален |

**Всего**: 11 документов

---

**Вопросы по документации?** Создайте [Issue](https://github.com/jethome-iot/repomanager/issues) с тегом `documentation`.
