# Scripts

Вспомогательные скрипты для работы с debrepomanager.

## repoadd

Упрощенный скрипт для загрузки пакетов в репозитории с поддержкой окружений stable/beta/test.

### Быстрый старт

```bash
# Загрузить пакеты в stable репозиторий
./repoadd stable bookworm armbian-bookworm

# Загрузить пакеты в beta репозиторий
./repoadd beta noble jethome-tools

# Загрузить пакеты в test репозиторий
./repoadd test bookworm ./packages/
```

### Документация

Полная документация: [REPOADD_SCRIPT.md](../docs/REPOADD_SCRIPT.md)

### Синтаксис

```bash
repoadd <stable|beta|test> <codename> <dir>
```

- `stable` → `http://deb.repo.com/`
- `beta` → `http://deb.repo.com/beta/`
- `test` → `http://deb.repo.com/test/`

### Примеры

**Загрузка в production:**
```bash
./repoadd stable bookworm armbian-bookworm
```
→ `deb http://deb.repo.com/ bookworm jethome-armbian-bookworm`

**Загрузка в beta:**
```bash
./repoadd beta noble jethome-tools
```
→ `deb http://deb.repo.com/beta/ noble jethome-tools`

**Dry-run режим:**
```bash
DRY_RUN=1 ./repoadd stable bookworm armbian-bookworm
```

### Установка

1. Убедитесь что debrepomanager установлен:
   ```bash
   pip install debrepomanager
   ```

2. Сделайте скрипт исполняемым:
   ```bash
   chmod +x repoadd
   ```

3. Опционально, добавьте в PATH:
   ```bash
   sudo ln -s $(pwd)/repoadd /usr/local/bin/repoadd
   ```

## add-release.sh

Добавление нового релиза дистрибутива (например, Debian Trixie, Ubuntu Oracular).

### Использование

```bash
# Создать стандартные компоненты
./add-release.sh trixie

# Указать свои компоненты
./add-release.sh trixie "jethome-tools jethome-trixie jethome-desktop"
```

### Что делает

1. Создаёт репозитории для всех компонентов
2. Создаёт dual format симлинки
3. Показывает следующие шаги (nginx, документация)

### Документация

Полная документация: [RELEASE_LIFECYCLE.md](../docs/RELEASE_LIFECYCLE.md)

## remove-release.sh

Удаление устаревшего релиза (например, Debian Bullseye после EOL).

### Использование

```bash
# Удалить с backup
./remove-release.sh bullseye yes

# Удалить без backup
./remove-release.sh bullseye no
```

### Что делает

1. Проверяет активность в логах nginx
2. Создаёт backup (если указано)
3. Удаляет все репозитории
4. Очищает файлы и директории
5. Показывает следующие шаги

### Безопасность

- Требует явного подтверждения (ввести codename)
- Предупреждает если есть активность
- Создаёт backup по умолчанию
- Показывает инструкции для восстановления

### Документация

Полная документация: [RELEASE_LIFECYCLE.md](../docs/RELEASE_LIFECYCLE.md)

## update-nginx-codenames.sh

Автоматическое обновление nginx конфигурации с актуальным списком codenames.

### Использование

```bash
# Автоматически сканирует publish_base
./update-nginx-codenames.sh

# С кастомными путями
./update-nginx-codenames.sh /opt/repo/public /etc/nginx/conf.d/repo-codenames.conf
```

### Что делает

1. Сканирует publish_base для поиска codenames
2. Генерирует nginx конфигурацию с динамическим списком
3. Сохраняет в `/etc/nginx/conf.d/repo-codenames.conf`
4. Создаёт backup старой конфигурации
5. Проверяет nginx syntax

### Генерируемый файл

```nginx
geo $repo_pool_locations {
    default "
/trixie/$uri /noble/$uri /bookworm/$uri ";
}
```

Используется в главном nginx конфиге:
```nginx
include /etc/nginx/conf.d/repo-codenames.conf;

server {
    location ~ ^/pool/(.*)$ {
        set $uri $1;
        try_files $uri $repo_pool_locations =404;
    }
}
```

### Автоматизация

- Вызывается автоматически из `add-release.sh`
- Вызывается автоматически из `remove-release.sh`
- Не требует ручного вмешательства

### Документация

Полная документация: [NGINX_OLD_FORMAT.md](../docs/NGINX_OLD_FORMAT.md)

## migrate-gpg-key.sh

Клиентский скрипт для миграции на новый GPG ключ.

Документация: [GPG_ROTATION.md](../docs/GPG_ROTATION.md)

