#!/usr/bin/env bash
#
# add-release.sh - DEPRECATED wrapper for debrepomanager release add
#
# ⚠️  DEPRECATED: This script will be removed in v0.5.0
# Use: debrepomanager release add <codename> [--components <comp1> --components <comp2> ...]
#

set -e
set -o pipefail

# Colors
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m'

CODENAME=$1
COMPONENTS=${2:-}

# Show deprecation warning
echo -e "${YELLOW}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}" >&2
echo -e "${YELLOW}⚠️  DEPRECATION WARNING${NC}" >&2
echo -e "${YELLOW}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}" >&2
echo -e "" >&2
echo -e "${YELLOW}This script is deprecated and will be removed in v0.5.0${NC}" >&2
echo -e "" >&2

if [ -z "$COMPONENTS" ]; then
	echo -e "Use instead:" >&2
	echo -e "  ${RED}debrepomanager release add $CODENAME${NC}" >&2
else
	echo -e "Use instead:" >&2
	echo -e "  ${RED}debrepomanager release add $CODENAME \\" >&2
	for comp in $COMPONENTS; do
		echo -e "    --components $comp \\" >&2
	done | sed '$ s/ \\$//'
fi

echo -e "" >&2
echo -e "See: docs/MIGRATION.md for full migration guide" >&2
echo -e "${YELLOW}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}" >&2
echo -e "" >&2

# Validate arguments
if [ -z "$CODENAME" ]; then
	echo "Error: codename is required" >&2
	echo "Usage: $(basename "$0") <codename> [components]" >&2
	exit 1
fi

# Build command
CMD_ARGS=(release add "$CODENAME")

# Parse components
if [ -n "$COMPONENTS" ]; then
	for comp in $COMPONENTS; do
		CMD_ARGS+=(--components "$comp")
	done
fi

# Forward verbose flag
if [ -n "$DEBUG" ]; then
	CMD_ARGS=(--verbose "${CMD_ARGS[@]}")
fi

# Execute debrepomanager
exec debrepomanager "${CMD_ARGS[@]}"
