# Deprecated Scripts

⚠️ **These scripts are deprecated and kept only for backward compatibility.**

## Migration Guide

### repoadd → debrepomanager add --environment

The `repoadd` script has been replaced by the native Python CLI command with environment support.

**Old:**
```bash
./repoadd stable bookworm armbian-bookworm
./repoadd beta noble jethome-tools
./repoadd test bookworm ./packages/ jethome-custom
```

**New:**
```bash
debrepomanager add --environment stable --codename bookworm --package-dir armbian-bookworm
debrepomanager add --environment beta --codename noble --package-dir jethome-tools
debrepomanager add --environment test --codename bookworm --component jethome-custom --package-dir ./packages/
```

### add-release.sh → debrepomanager release add

The `add-release.sh` script has been integrated into the main CLI.

**Old:**
```bash
./add-release.sh trixie
./add-release.sh trixie "jethome-tools jethome-trixie jethome-desktop"
```

**New:**
```bash
debrepomanager release add trixie
debrepomanager release add trixie --components jethome-tools --components jethome-trixie --components jethome-desktop
```

### remove-release.sh → debrepomanager release remove

The `remove-release.sh` script has been integrated into the main CLI.

**Old:**
```bash
./remove-release.sh bullseye yes
./remove-release.sh jammy no
```

**New:**
```bash
debrepomanager release remove bullseye --backup --confirm
debrepomanager release remove jammy --no-backup --confirm
```

## Benefits of New Commands

1. **Unified Interface**: All functionality in one CLI tool
2. **Better Error Handling**: Consistent error messages and exit codes
3. **Type Safety**: Python implementation with proper typing
4. **Testing**: Comprehensive test coverage
5. **Dry-Run Support**: Test commands before execution with `--dry-run`
6. **Better Logging**: Structured logging with configurable verbosity

## Wrapper Scripts

The original script names (`repoadd`, `add-release.sh`, `remove-release.sh`) are now thin wrappers that call the new CLI commands with a deprecation warning.

## Timeline

- **v0.4.0**: Deprecation warnings added
- **v0.5.0** (planned): Wrappers will be removed
- **v0.6.0** (planned): Legacy scripts removed entirely

## Documentation

For full documentation on the new commands, see:
- [CHEATSHEET.md](../../docs/CHEATSHEET.md) - Quick reference
- [WORKFLOWS.md](../../docs/WORKFLOWS.md) - Common workflows
- [QUICKSTART.md](../../docs/QUICKSTART.md) - Getting started

## Support

If you encounter issues with the migration, please:
1. Check the [migration guide](../../docs/MIGRATION.md)
2. Run commands with `--verbose` for detailed output
3. Open an issue on GitHub with details

