#!/usr/bin/env bash
#
# remove-release.sh - DEPRECATED wrapper for debrepomanager release remove
#
# ⚠️  DEPRECATED: This script will be removed in v0.5.0
# Use: debrepomanager release remove <codename> [--backup|--no-backup] --confirm
#

set -e
set -o pipefail

# Colors
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m'

CODENAME=$1
BACKUP=${2:-yes}

# Show deprecation warning
echo -e "${YELLOW}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}" >&2
echo -e "${YELLOW}⚠️  DEPRECATION WARNING${NC}" >&2
echo -e "${YELLOW}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}" >&2
echo -e "" >&2
echo -e "${YELLOW}This script is deprecated and will be removed in v0.5.0${NC}" >&2
echo -e "" >&2

if [ "$BACKUP" = "yes" ]; then
	echo -e "Use instead:" >&2
	echo -e "  ${RED}debrepomanager release remove $CODENAME --backup --confirm${NC}" >&2
else
	echo -e "Use instead:" >&2
	echo -e "  ${RED}debrepomanager release remove $CODENAME --no-backup --confirm${NC}" >&2
fi

echo -e "" >&2
echo -e "See: docs/MIGRATION.md for full migration guide" >&2
echo -e "${YELLOW}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}" >&2
echo -e "" >&2

# Validate arguments
if [ -z "$CODENAME" ]; then
	echo "Error: codename is required" >&2
	echo "Usage: $(basename "$0") <codename> [backup]" >&2
	exit 1
fi

# Build command
CMD_ARGS=(release remove "$CODENAME" --confirm)

# Add backup flag
if [ "$BACKUP" = "yes" ]; then
	CMD_ARGS+=(--backup)
else
	CMD_ARGS+=(--no-backup)
fi

# Forward verbose flag
if [ -n "$DEBUG" ]; then
	CMD_ARGS=(--verbose "${CMD_ARGS[@]}")
fi

# Execute debrepomanager
exec debrepomanager "${CMD_ARGS[@]}"
