"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventNotify = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const events = require("@aws-cdk/aws-events");
const target = require("@aws-cdk/aws-events-targets");
const _lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class EventNotify extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        if (!(props === null || props === void 0 ? void 0 : props.lineNotifyToken) && !(props === null || props === void 0 ? void 0 : props.slack)) {
            throw new Error('Please input lineNotifyToken or slack options');
        }
        const lambdaFun = new _lambda.Function(this, 'lambda_fun', {
            handler: 'linenotify.lambda_handler',
            code: _lambda.Code.fromAsset(path.join(__dirname, '../function')),
            runtime: _lambda.Runtime.PYTHON_3_8,
            timeout: cdk.Duration.minutes(3),
            logRetention: logs.RetentionDays.THREE_DAYS,
            environment: {
                LINE_NOTIFY_TOKEN: (props === null || props === void 0 ? void 0 : props.lineNotifyToken) ? props === null || props === void 0 ? void 0 : props.lineNotifyToken : 'none',
                SLACK_WEBHOOK_URL: ((_b = props === null || props === void 0 ? void 0 : props.slack) === null || _b === void 0 ? void 0 : _b.slackWebhookUrl) ? (_c = props === null || props === void 0 ? void 0 : props.slack) === null || _c === void 0 ? void 0 : _c.slackWebhookUrl : 'none',
                SLACK_CHANNEL_NAME: ((_d = props === null || props === void 0 ? void 0 : props.slack) === null || _d === void 0 ? void 0 : _d.slackChannelName) ? (_e = props === null || props === void 0 ? void 0 : props.slack) === null || _e === void 0 ? void 0 : _e.slackChannelName : 'none',
            },
        });
        const eventNotifyTarget = new target.LambdaFunction(lambdaFun);
        new events.Rule(this, 'EventBusConsoleLoginEvent', {
            ruleName: 'EventBusConsoleLoginEvent',
            description: 'Console login in specific region',
            targets: [eventNotifyTarget],
            eventPattern: {
                detailType: ['AWS Console Sign In via CloudTrail'],
            },
        });
    }
}
exports.EventNotify = EventNotify;
_a = JSII_RTTI_SYMBOL_1;
EventNotify[_a] = { fqn: "cdk-events-notify.EventNotify", version: "0.2.42" };
//# sourceMappingURL=data:application/json;base64,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