# Generated by Django 5.0.9 on 2025-01-07 10:01
from decimal import Decimal

import django.db.models.deletion
import django.db.models.lookups
import uuid
from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import ProjectState


class ApplyDatabaseOperationIfTableIsMissing(migrations.SeparateDatabaseAndState):
    def __init__(self, operations, model_name):
        self.model_name = model_name
        super().__init__(database_operations=operations, state_operations=operations)

    def database_forwards(
        self,
        app_label: str,
        schema_editor: BaseDatabaseSchemaEditor,
        from_state: ProjectState,
        to_state: ProjectState,
    ) -> None:
        manipulate_database = True
        with schema_editor.connection.cursor() as cursor:
            cursor.execute(
                f"SELECT EXISTS ( SELECT 1 FROM pg_tables WHERE tablename = 'wise_market_{self.model_name}' )"
            )
            if next(cursor.cursor)[0]:
                manipulate_database = False
        if manipulate_database:
            super().database_forwards(app_label, schema_editor, from_state, to_state)


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    symbol_operations = [
        migrations.CreateModel(
            name="Symbol",
            fields=[
                (
                    "key",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("is_active", models.BooleanField(db_index=True, default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True, db_index=True)),
                ("name", models.CharField(max_length=256)),
                ("slug", models.CharField(max_length=256, unique=True)),
            ],
            options={
                "ordering": ["-created_at"],
                "abstract": False,
            },
        ),
    ]

    pair_operations = [
        migrations.CreateModel(
            name="Pair",
            fields=[
                (
                    "key",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("is_active", models.BooleanField(db_index=True, default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True, db_index=True)),
                ("slug", models.CharField(max_length=256, unique=True)),
                ("name", models.CharField(max_length=256)),
                (
                    "base",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="base_pairs",
                        to="wise_market.symbol",
                    ),
                ),
                (
                    "quote",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="quote_pairs",
                        to="wise_market.symbol",
                    ),
                ),
            ],
            options={
                "ordering": ["-created_at"],
                "abstract": False,
                "unique_together": {("base", "quote")},
            },
        ),
    ]

    asset_operations = [
        migrations.CreateModel(
            name="Asset",
            fields=[
                (
                    "key",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("is_active", models.BooleanField(db_index=True, default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True, db_index=True)),
                (
                    "type",
                    models.CharField(
                        choices=[("SYMBOL", "SYMBOL"), ("PAIR", "PAIR")], max_length=32
                    ),
                ),
                (
                    "pair",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="wise_market.pair",
                    ),
                ),
                (
                    "symbol",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="wise_market.symbol",
                    ),
                ),
            ],
            options={
                "ordering": ["-created_at"],
                "abstract": False,
            },
        ),
        migrations.AddConstraint(
            model_name="asset",
            constraint=models.CheckConstraint(
                check=models.ExpressionWrapper(
                    models.Q(
                        django.db.models.lookups.Exact(
                            lhs=models.Func(
                                "symbol",
                                "pair",
                                function="num_nonnulls",
                                output_field=models.IntegerField(),
                            ),
                            rhs=models.Value(1),
                        )
                    ),
                    output_field=models.BooleanField(),
                ),
                name="exactly_one_non_null__symbol__pair",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="asset",
            unique_together={("type", "symbol", "pair")},
        ),
    ]

    exchange_operations = [
        migrations.CreateModel(
            name="Exchange",
            fields=[
                (
                    "key",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("is_active", models.BooleanField(db_index=True, default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True, db_index=True)),
                ("name", models.CharField(max_length=256, unique=True)),
            ],
            options={
                "ordering": ["-created_at"],
                "abstract": False,
            },
        ),
    ]

    market_operations = [
        migrations.CreateModel(
            name="Market",
            fields=[
                (
                    "key",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("is_active", models.BooleanField(db_index=True, default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True, db_index=True)),
                ("name", models.CharField(max_length=256, unique=True)),
            ],
            options={
                "ordering": ["-created_at"],
                "abstract": False,
            },
        ),
    ]

    network_operations = [
        migrations.CreateModel(
            name="Network",
            fields=[
                (
                    "key",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("is_active", models.BooleanField(db_index=True, default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True, db_index=True)),
                ("name", models.CharField(db_index=True, max_length=256, unique=True)),
                ("slug", models.CharField(max_length=256, unique=True)),
            ],
            options={
                "ordering": ["-created_at"],
                "abstract": False,
            },
        ),
    ]

    exchange_market_operations = [
        migrations.CreateModel(
            name="ExchangeMarket",
            fields=[
                (
                    "key",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("is_active", models.BooleanField(db_index=True, default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True, db_index=True)),
                (
                    "exchange",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="wise_market.exchange",
                    ),
                ),
                (
                    "market",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="wise_market.market",
                    ),
                ),
            ],
            options={
                "ordering": ["-created_at"],
                "abstract": False,
                "unique_together": {("exchange", "market")},
            },
        ),
    ]

    network_symbol_binding_operations = [
        migrations.CreateModel(
            name="NetworkSymbolBinding",
            fields=[
                (
                    "key",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("is_active", models.BooleanField(db_index=True, default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True, db_index=True)),
                ("decimals", models.IntegerField(default=0)),
                (
                    "step_size",
                    models.DecimalField(
                        decimal_places=20, default=Decimal("1"), max_digits=40
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[("COIN", "Native Coin"), ("TOKEN", "Utility Token")],
                        db_index=True,
                        default="TOKEN",
                        max_length=64,
                    ),
                ),
                (
                    "contract_address",
                    models.CharField(max_length=128, blank=True, null=True),
                ),
                (
                    "network",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="symbol_bindings",
                        to="wise_market.network",
                    ),
                ),
                (
                    "symbol",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="network_bindings",
                        to="wise_market.symbol",
                    ),
                ),
            ],
            options={
                "ordering": ["-created_at"],
                "abstract": False,
            },
        ),
        migrations.AddConstraint(
            model_name="networksymbolbinding",
            constraint=models.UniqueConstraint(
                models.F("network"),
                models.F("symbol"),
                name="network_symbol_binding_unique_network_symbol",
            ),
        ),
        migrations.AddConstraint(
            model_name="networksymbolbinding",
            constraint=models.UniqueConstraint(
                condition=models.Q(("type", "COIN")),
                fields=("network",),
                name="network_symbol_binding_unique_network_native_coin",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="networksymbolbinding",
            unique_together={("symbol", "network")},
        ),
    ]

    exchange_market_pair_binding_operations = [
        migrations.CreateModel(
            name="ExchangeMarketPairBinding",
            fields=[
                (
                    "key",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("is_active", models.BooleanField(db_index=True, default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True, db_index=True)),
                ("price_decimals", models.IntegerField(default=0)),
                ("quantity_decimals", models.IntegerField(default=0)),
                (
                    "price_step_size",
                    models.DecimalField(
                        decimal_places=20, default=Decimal("1"), max_digits=40
                    ),
                ),
                (
                    "quantity_step_size",
                    models.DecimalField(
                        decimal_places=20, default=Decimal("1"), max_digits=40
                    ),
                ),
                ("min_notional", models.FloatField()),
                (
                    "exchange_market",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="pair_bindings",
                        to="wise_market.exchangemarket",
                    ),
                ),
                (
                    "pair",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="exchange_market_bindings",
                        to="wise_market.pair",
                    ),
                ),
            ],
            options={
                "ordering": ["-created_at"],
                "abstract": False,
                "unique_together": {("exchange_market", "pair")},
            },
        ),
    ]

    network_exchange_operations = [
        migrations.CreateModel(
            name="NetworkExchangeBinding",
            fields=[
                (
                    "key",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("is_active", models.BooleanField(db_index=True, default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True, db_index=True)),
                (
                    "exchange",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="network_bindings",
                        to="wise_market.exchange",
                    ),
                ),
                (
                    "network",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="exchange_bindings",
                        to="wise_market.network",
                    ),
                ),
            ],
            options={
                "ordering": ["-created_at"],
                "abstract": False,
                "unique_together": {("network", "exchange")},
            },
        ),
    ]

    operations = [
        ApplyDatabaseOperationIfTableIsMissing(
            operations=symbol_operations, model_name="symbol"
        ),
        ApplyDatabaseOperationIfTableIsMissing(
            operations=pair_operations, model_name="pair"
        ),
        ApplyDatabaseOperationIfTableIsMissing(
            operations=asset_operations, model_name="asset"
        ),
        ApplyDatabaseOperationIfTableIsMissing(
            operations=exchange_operations, model_name="exchange"
        ),
        ApplyDatabaseOperationIfTableIsMissing(
            operations=market_operations, model_name="market"
        ),
        ApplyDatabaseOperationIfTableIsMissing(
            operations=network_operations, model_name="network"
        ),
        ApplyDatabaseOperationIfTableIsMissing(
            operations=exchange_market_operations, model_name="exchangemarket"
        ),
        ApplyDatabaseOperationIfTableIsMissing(
            operations=network_symbol_binding_operations,
            model_name="networksymbolbinding",
        ),
        ApplyDatabaseOperationIfTableIsMissing(
            operations=exchange_market_pair_binding_operations,
            model_name="exchangemarketpairbinding",
        ),
        ApplyDatabaseOperationIfTableIsMissing(
            operations=network_exchange_operations, model_name="networkexchangebinding"
        ),
    ]
