# coding=utf-8
from abc import (
    abstractmethod,
)
import builtins
from conjure_python_client import (
    BinaryType,
    ConjureBeanType,
    ConjureDecoder,
    ConjureEncoder,
    ConjureEnumType,
    ConjureFieldDefinition,
    ConjureUnionType,
    OptionalTypeWrapper,
    Service,
)
from requests.adapters import (
    Response,
)
from typing import (
    Any,
    Dict,
    List,
    Optional,
    Set,
)
from urllib.parse import (
    quote,
)

class api_ArchivedStatus(ConjureEnumType):

    NOT_ARCHIVED = 'NOT_ARCHIVED'
    '''NOT_ARCHIVED'''
    ARCHIVED = 'ARCHIVED'
    '''ARCHIVED'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


api_ArchivedStatus.__name__ = "ArchivedStatus"
api_ArchivedStatus.__qualname__ = "ArchivedStatus"
api_ArchivedStatus.__module__ = "nominal_api.api"


class api_DataSourceType(ConjureEnumType):

    DATASET = 'DATASET'
    '''DATASET'''
    CONNECTION = 'CONNECTION'
    '''CONNECTION'''
    VIDEO = 'VIDEO'
    '''VIDEO'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


api_DataSourceType.__name__ = "DataSourceType"
api_DataSourceType.__qualname__ = "DataSourceType"
api_DataSourceType.__module__ = "nominal_api.api"


class api_Empty(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



api_Empty.__name__ = "Empty"
api_Empty.__qualname__ = "Empty"
api_Empty.__module__ = "nominal_api.api"


class api_ErrorResult(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'error_type': ConjureFieldDefinition('errorType', api_ErrorType),
            'message': ConjureFieldDefinition('message', str)
        }

    __slots__: List[str] = ['_error_type', '_message']

    def __init__(self, error_type: str, message: str) -> None:
        self._error_type = error_type
        self._message = message

    @builtins.property
    def error_type(self) -> str:
        return self._error_type

    @builtins.property
    def message(self) -> str:
        return self._message


api_ErrorResult.__name__ = "ErrorResult"
api_ErrorResult.__qualname__ = "ErrorResult"
api_ErrorResult.__module__ = "nominal_api.api"


class api_Granularity(ConjureEnumType):

    PICOSECONDS = 'PICOSECONDS'
    '''PICOSECONDS'''
    NANOSECONDS = 'NANOSECONDS'
    '''NANOSECONDS'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


api_Granularity.__name__ = "Granularity"
api_Granularity.__qualname__ = "Granularity"
api_Granularity.__module__ = "nominal_api.api"


class api_Handle(ConjureUnionType):
    _s3: Optional[str] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            's3': ConjureFieldDefinition('s3', api_S3Path)
        }

    def __init__(
            self,
            s3: Optional[str] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (s3 is not None) != 1:
                raise ValueError('a union must contain a single member')

            if s3 is not None:
                self._s3 = s3
                self._type = 's3'

        elif type_of_union == 's3':
            if s3 is None:
                raise ValueError('a union value must not be None')
            self._s3 = s3
            self._type = 's3'

    @builtins.property
    def s3(self) -> Optional[str]:
        return self._s3

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, api_HandleVisitor):
            raise ValueError('{} is not an instance of api_HandleVisitor'.format(visitor.__class__.__name__))
        if self._type == 's3' and self.s3 is not None:
            return visitor._s3(self.s3)


api_Handle.__name__ = "Handle"
api_Handle.__qualname__ = "Handle"
api_Handle.__module__ = "nominal_api.api"


class api_HandleVisitor:

    @abstractmethod
    def _s3(self, s3: str) -> Any:
        pass


api_HandleVisitor.__name__ = "HandleVisitor"
api_HandleVisitor.__qualname__ = "HandleVisitor"
api_HandleVisitor.__module__ = "nominal_api.api"


class api_InProgressResult(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



api_InProgressResult.__name__ = "InProgressResult"
api_InProgressResult.__qualname__ = "InProgressResult"
api_InProgressResult.__module__ = "nominal_api.api"


class api_IngestStatus(ConjureEnumType):

    SUCCEEDED = 'SUCCEEDED'
    '''SUCCEEDED'''
    FAILED = 'FAILED'
    '''FAILED'''
    IN_PROGRESS = 'IN_PROGRESS'
    '''IN_PROGRESS'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


api_IngestStatus.__name__ = "IngestStatus"
api_IngestStatus.__qualname__ = "IngestStatus"
api_IngestStatus.__module__ = "nominal_api.api"


class api_IngestStatusV2(ConjureUnionType):
    _success: Optional["api_SuccessResult"] = None
    _error: Optional["api_ErrorResult"] = None
    _in_progress: Optional["api_InProgressResult"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'success': ConjureFieldDefinition('success', api_SuccessResult),
            'error': ConjureFieldDefinition('error', api_ErrorResult),
            'in_progress': ConjureFieldDefinition('inProgress', api_InProgressResult)
        }

    def __init__(
            self,
            success: Optional["api_SuccessResult"] = None,
            error: Optional["api_ErrorResult"] = None,
            in_progress: Optional["api_InProgressResult"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (success is not None) + (error is not None) + (in_progress is not None) != 1:
                raise ValueError('a union must contain a single member')

            if success is not None:
                self._success = success
                self._type = 'success'
            if error is not None:
                self._error = error
                self._type = 'error'
            if in_progress is not None:
                self._in_progress = in_progress
                self._type = 'inProgress'

        elif type_of_union == 'success':
            if success is None:
                raise ValueError('a union value must not be None')
            self._success = success
            self._type = 'success'
        elif type_of_union == 'error':
            if error is None:
                raise ValueError('a union value must not be None')
            self._error = error
            self._type = 'error'
        elif type_of_union == 'inProgress':
            if in_progress is None:
                raise ValueError('a union value must not be None')
            self._in_progress = in_progress
            self._type = 'inProgress'

    @builtins.property
    def success(self) -> Optional["api_SuccessResult"]:
        return self._success

    @builtins.property
    def error(self) -> Optional["api_ErrorResult"]:
        return self._error

    @builtins.property
    def in_progress(self) -> Optional["api_InProgressResult"]:
        return self._in_progress

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, api_IngestStatusV2Visitor):
            raise ValueError('{} is not an instance of api_IngestStatusV2Visitor'.format(visitor.__class__.__name__))
        if self._type == 'success' and self.success is not None:
            return visitor._success(self.success)
        if self._type == 'error' and self.error is not None:
            return visitor._error(self.error)
        if self._type == 'inProgress' and self.in_progress is not None:
            return visitor._in_progress(self.in_progress)


api_IngestStatusV2.__name__ = "IngestStatusV2"
api_IngestStatusV2.__qualname__ = "IngestStatusV2"
api_IngestStatusV2.__module__ = "nominal_api.api"


class api_IngestStatusV2Visitor:

    @abstractmethod
    def _success(self, success: "api_SuccessResult") -> Any:
        pass

    @abstractmethod
    def _error(self, error: "api_ErrorResult") -> Any:
        pass

    @abstractmethod
    def _in_progress(self, in_progress: "api_InProgressResult") -> Any:
        pass


api_IngestStatusV2Visitor.__name__ = "IngestStatusV2Visitor"
api_IngestStatusV2Visitor.__qualname__ = "IngestStatusV2Visitor"
api_IngestStatusV2Visitor.__module__ = "nominal_api.api"


class api_McapChannelLocator(ConjureUnionType):
    """Locator for a channel in an mcap file. Channel name is not guaranteed to be unique, so channel ID should
be used for mcap files with duplicate channel names.
    """
    _topic: Optional[str] = None
    _id: Optional[int] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'topic': ConjureFieldDefinition('topic', api_McapChannelTopic),
            'id': ConjureFieldDefinition('id', api_McapChannelId)
        }

    def __init__(
            self,
            topic: Optional[str] = None,
            id: Optional[int] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (topic is not None) + (id is not None) != 1:
                raise ValueError('a union must contain a single member')

            if topic is not None:
                self._topic = topic
                self._type = 'topic'
            if id is not None:
                self._id = id
                self._type = 'id'

        elif type_of_union == 'topic':
            if topic is None:
                raise ValueError('a union value must not be None')
            self._topic = topic
            self._type = 'topic'
        elif type_of_union == 'id':
            if id is None:
                raise ValueError('a union value must not be None')
            self._id = id
            self._type = 'id'

    @builtins.property
    def topic(self) -> Optional[str]:
        return self._topic

    @builtins.property
    def id(self) -> Optional[int]:
        return self._id

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, api_McapChannelLocatorVisitor):
            raise ValueError('{} is not an instance of api_McapChannelLocatorVisitor'.format(visitor.__class__.__name__))
        if self._type == 'topic' and self.topic is not None:
            return visitor._topic(self.topic)
        if self._type == 'id' and self.id is not None:
            return visitor._id(self.id)


api_McapChannelLocator.__name__ = "McapChannelLocator"
api_McapChannelLocator.__qualname__ = "McapChannelLocator"
api_McapChannelLocator.__module__ = "nominal_api.api"


class api_McapChannelLocatorVisitor:

    @abstractmethod
    def _topic(self, topic: str) -> Any:
        pass

    @abstractmethod
    def _id(self, id: int) -> Any:
        pass


api_McapChannelLocatorVisitor.__name__ = "McapChannelLocatorVisitor"
api_McapChannelLocatorVisitor.__qualname__ = "McapChannelLocatorVisitor"
api_McapChannelLocatorVisitor.__module__ = "nominal_api.api"


class api_Property(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', api_PropertyName),
            'value': ConjureFieldDefinition('value', api_PropertyValue)
        }

    __slots__: List[str] = ['_name', '_value']

    def __init__(self, name: str, value: str) -> None:
        self._name = name
        self._value = value

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def value(self) -> str:
        return self._value


api_Property.__name__ = "Property"
api_Property.__qualname__ = "Property"
api_Property.__module__ = "nominal_api.api"


class api_Range(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'start': ConjureFieldDefinition('start', api_Timestamp),
            'end': ConjureFieldDefinition('end', api_Timestamp)
        }

    __slots__: List[str] = ['_start', '_end']

    def __init__(self, end: "api_Timestamp", start: "api_Timestamp") -> None:
        self._start = start
        self._end = end

    @builtins.property
    def start(self) -> "api_Timestamp":
        return self._start

    @builtins.property
    def end(self) -> "api_Timestamp":
        return self._end


api_Range.__name__ = "Range"
api_Range.__qualname__ = "Range"
api_Range.__module__ = "nominal_api.api"


class api_RefNameAndType(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', api_DataSourceRefName),
            'type': ConjureFieldDefinition('type', api_DataSourceType)
        }

    __slots__: List[str] = ['_name', '_type']

    def __init__(self, name: str, type: "api_DataSourceType") -> None:
        self._name = name
        self._type = type

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def type(self) -> "api_DataSourceType":
        return self._type


api_RefNameAndType.__name__ = "RefNameAndType"
api_RefNameAndType.__qualname__ = "RefNameAndType"
api_RefNameAndType.__module__ = "nominal_api.api"


class api_SerializableError(ConjureBeanType):
    """A SerializableError is a representation of a ServiceException that exists to send error
results to clients as part of a response object when directly throwing an exception is undesirable.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', str),
            'message': ConjureFieldDefinition('message', OptionalTypeWrapper[str]),
            'error_instance_id': ConjureFieldDefinition('errorInstanceId', str),
            'status_code': ConjureFieldDefinition('statusCode', int),
            'params': ConjureFieldDefinition('params', Dict[str, str])
        }

    __slots__: List[str] = ['_name', '_message', '_error_instance_id', '_status_code', '_params']

    def __init__(self, error_instance_id: str, name: str, params: Dict[str, str], status_code: int, message: Optional[str] = None) -> None:
        self._name = name
        self._message = message
        self._error_instance_id = error_instance_id
        self._status_code = status_code
        self._params = params

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def message(self) -> Optional[str]:
        return self._message

    @builtins.property
    def error_instance_id(self) -> str:
        return self._error_instance_id

    @builtins.property
    def status_code(self) -> int:
        return self._status_code

    @builtins.property
    def params(self) -> Dict[str, str]:
        return self._params


api_SerializableError.__name__ = "SerializableError"
api_SerializableError.__qualname__ = "SerializableError"
api_SerializableError.__module__ = "nominal_api.api"


class api_SeriesDataType(ConjureEnumType):
    """The data types that are available for querying.
    """

    DOUBLE = 'DOUBLE'
    '''DOUBLE'''
    STRING = 'STRING'
    '''STRING'''
    LOG = 'LOG'
    '''LOG'''
    INT = 'INT'
    '''INT'''
    UINT = 'UINT'
    '''UINT'''
    DOUBLE_ARRAY = 'DOUBLE_ARRAY'
    '''DOUBLE_ARRAY'''
    STRING_ARRAY = 'STRING_ARRAY'
    '''STRING_ARRAY'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


api_SeriesDataType.__name__ = "SeriesDataType"
api_SeriesDataType.__qualname__ = "SeriesDataType"
api_SeriesDataType.__module__ = "nominal_api.api"


class api_SetOperator(ConjureEnumType):

    AND = 'AND'
    '''AND'''
    OR = 'OR'
    '''OR'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


api_SetOperator.__name__ = "SetOperator"
api_SetOperator.__qualname__ = "SetOperator"
api_SetOperator.__module__ = "nominal_api.api"


class api_SuccessResult(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



api_SuccessResult.__name__ = "SuccessResult"
api_SuccessResult.__qualname__ = "SuccessResult"
api_SuccessResult.__module__ = "nominal_api.api"


class api_TimeUnit(ConjureEnumType):

    DAYS = 'DAYS'
    '''DAYS'''
    HOURS = 'HOURS'
    '''HOURS'''
    MINUTES = 'MINUTES'
    '''MINUTES'''
    SECONDS = 'SECONDS'
    '''SECONDS'''
    MILLISECONDS = 'MILLISECONDS'
    '''MILLISECONDS'''
    MICROSECONDS = 'MICROSECONDS'
    '''MICROSECONDS'''
    NANOSECONDS = 'NANOSECONDS'
    '''NANOSECONDS'''
    PICOSECONDS = 'PICOSECONDS'
    '''PICOSECONDS'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


api_TimeUnit.__name__ = "TimeUnit"
api_TimeUnit.__qualname__ = "TimeUnit"
api_TimeUnit.__module__ = "nominal_api.api"


class api_Timestamp(ConjureBeanType):
    """Picosecond precision timestamp type, represented by an epoch time in seconds, a nanosecond offset, and
optional picosecond offset.
The nanosecond offset is from the start of the epoch second, so must be less than 1 billion.
The optional picosecond offset is only used for picosecond-precision data sources and is from the start of
the nanosecond, so must be less than 1000.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'seconds': ConjureFieldDefinition('seconds', int),
            'nanos': ConjureFieldDefinition('nanos', int),
            'picos': ConjureFieldDefinition('picos', OptionalTypeWrapper[int])
        }

    __slots__: List[str] = ['_seconds', '_nanos', '_picos']

    def __init__(self, nanos: int, seconds: int, picos: Optional[int] = None) -> None:
        self._seconds = seconds
        self._nanos = nanos
        self._picos = picos

    @builtins.property
    def seconds(self) -> int:
        return self._seconds

    @builtins.property
    def nanos(self) -> int:
        return self._nanos

    @builtins.property
    def picos(self) -> Optional[int]:
        return self._picos


api_Timestamp.__name__ = "Timestamp"
api_Timestamp.__qualname__ = "Timestamp"
api_Timestamp.__module__ = "nominal_api.api"


class attachments_api_Attachment(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', api_rids_AttachmentRid),
            'title': ConjureFieldDefinition('title', str),
            's3_path': ConjureFieldDefinition('s3Path', api_S3Path),
            'file_type': ConjureFieldDefinition('fileType', str),
            'description': ConjureFieldDefinition('description', str),
            'created_by': ConjureFieldDefinition('createdBy', str),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'created_at': ConjureFieldDefinition('createdAt', str),
            'is_archived': ConjureFieldDefinition('isArchived', bool)
        }

    __slots__: List[str] = ['_rid', '_title', '_s3_path', '_file_type', '_description', '_created_by', '_properties', '_labels', '_created_at', '_is_archived']

    def __init__(self, created_at: str, created_by: str, description: str, file_type: str, is_archived: bool, labels: List[str], properties: Dict[str, str], rid: str, s3_path: str, title: str) -> None:
        self._rid = rid
        self._title = title
        self._s3_path = s3_path
        self._file_type = file_type
        self._description = description
        self._created_by = created_by
        self._properties = properties
        self._labels = labels
        self._created_at = created_at
        self._is_archived = is_archived

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def title(self) -> str:
        return self._title

    @builtins.property
    def s3_path(self) -> str:
        return self._s3_path

    @builtins.property
    def file_type(self) -> str:
        return self._file_type

    @builtins.property
    def description(self) -> str:
        return self._description

    @builtins.property
    def created_by(self) -> str:
        return self._created_by

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels

    @builtins.property
    def created_at(self) -> str:
        return self._created_at

    @builtins.property
    def is_archived(self) -> bool:
        return self._is_archived


attachments_api_Attachment.__name__ = "Attachment"
attachments_api_Attachment.__qualname__ = "Attachment"
attachments_api_Attachment.__module__ = "nominal_api.attachments_api"


class attachments_api_AttachmentService(Service):
    """The attachment service provides functionality for creating, updating, and archiving attachments uploaded to S3.
    """

    def create(self, auth_header: str, request: "attachments_api_CreateAttachmentRequest") -> "attachments_api_Attachment":
        """Create a new attachment. Assumes the file is already uploaded to S3 through the upload service.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/attachments/v1/attachments'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), attachments_api_Attachment, self._return_none_for_unknown_union_types)

    def get(self, auth_header: str, rid: str) -> "attachments_api_Attachment":
        """Get an attachment by its RID.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/attachments/v1/attachments/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), attachments_api_Attachment, self._return_none_for_unknown_union_types)

    def get_batch(self, auth_header: str, request: "attachments_api_GetAttachmentsRequest") -> "attachments_api_GetAttachmentsResponse":
        """Get a set of attachments by their RIDs.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/attachments/v1/attachments/batch'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), attachments_api_GetAttachmentsResponse, self._return_none_for_unknown_union_types)

    def get_content(self, auth_header: str, rid: str) -> Any:
        """Get the binary content of an attachment.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/octet-stream',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/attachments/v1/attachments/{rid}/content'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            stream=True,
            json=_json)

        _raw = _response.raw
        _raw.decode_content = True
        return _raw

    def get_uri(self, auth_header: str, rid: str) -> "attachments_api_AttachmentUri":
        """Get a pre-signed URI to download an attachment. The link expires in 1 minute.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/attachments/v1/attachments/{rid}/uri'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), attachments_api_AttachmentUri, self._return_none_for_unknown_union_types)

    def update(self, auth_header: str, request: "attachments_api_UpdateAttachmentRequest", rid: str) -> "attachments_api_Attachment":
        """Update an attachment. Only the fields that are set in the request will be updated.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/attachments/v1/attachments/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), attachments_api_Attachment, self._return_none_for_unknown_union_types)

    def archive(self, auth_header: str, rid: str) -> None:
        """Archive an attachment.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/attachments/v1/attachments/{rid}/archive'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def unarchive(self, auth_header: str, rid: str) -> None:
        """Unarchive an attachment.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/attachments/v1/attachments/{rid}/unarchive'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return


attachments_api_AttachmentService.__name__ = "AttachmentService"
attachments_api_AttachmentService.__qualname__ = "AttachmentService"
attachments_api_AttachmentService.__module__ = "nominal_api.attachments_api"


class attachments_api_AttachmentUri(ConjureBeanType):
    """Pre-signed URI that will download the attachment directly from S3.
Expires if the download has not started in 1 minute.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'uri': ConjureFieldDefinition('uri', str)
        }

    __slots__: List[str] = ['_uri']

    def __init__(self, uri: str) -> None:
        self._uri = uri

    @builtins.property
    def uri(self) -> str:
        return self._uri


attachments_api_AttachmentUri.__name__ = "AttachmentUri"
attachments_api_AttachmentUri.__qualname__ = "AttachmentUri"
attachments_api_AttachmentUri.__module__ = "nominal_api.attachments_api"


class attachments_api_CreateAttachmentRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            's3_path': ConjureFieldDefinition('s3Path', api_S3Path),
            'title': ConjureFieldDefinition('title', str),
            'description': ConjureFieldDefinition('description', str),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'workspace': ConjureFieldDefinition('workspace', OptionalTypeWrapper[api_rids_WorkspaceRid])
        }

    __slots__: List[str] = ['_s3_path', '_title', '_description', '_properties', '_labels', '_workspace']

    def __init__(self, description: str, labels: List[str], properties: Dict[str, str], s3_path: str, title: str, workspace: Optional[str] = None) -> None:
        self._s3_path = s3_path
        self._title = title
        self._description = description
        self._properties = properties
        self._labels = labels
        self._workspace = workspace

    @builtins.property
    def s3_path(self) -> str:
        return self._s3_path

    @builtins.property
    def title(self) -> str:
        return self._title

    @builtins.property
    def description(self) -> str:
        return self._description

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels

    @builtins.property
    def workspace(self) -> Optional[str]:
        """The workspace in which to create the attachment. If not provided, the attachment will be created in
the default workspace for the user's organization, if the default workspace for the
organization is configured.
        """
        return self._workspace


attachments_api_CreateAttachmentRequest.__name__ = "CreateAttachmentRequest"
attachments_api_CreateAttachmentRequest.__qualname__ = "CreateAttachmentRequest"
attachments_api_CreateAttachmentRequest.__module__ = "nominal_api.attachments_api"


class attachments_api_GetAttachmentsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'attachment_rids': ConjureFieldDefinition('attachmentRids', List[api_rids_AttachmentRid])
        }

    __slots__: List[str] = ['_attachment_rids']

    def __init__(self, attachment_rids: List[str]) -> None:
        self._attachment_rids = attachment_rids

    @builtins.property
    def attachment_rids(self) -> List[str]:
        return self._attachment_rids


attachments_api_GetAttachmentsRequest.__name__ = "GetAttachmentsRequest"
attachments_api_GetAttachmentsRequest.__qualname__ = "GetAttachmentsRequest"
attachments_api_GetAttachmentsRequest.__module__ = "nominal_api.attachments_api"


class attachments_api_GetAttachmentsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'response': ConjureFieldDefinition('response', List[attachments_api_Attachment])
        }

    __slots__: List[str] = ['_response']

    def __init__(self, response: List["attachments_api_Attachment"]) -> None:
        self._response = response

    @builtins.property
    def response(self) -> List["attachments_api_Attachment"]:
        return self._response


attachments_api_GetAttachmentsResponse.__name__ = "GetAttachmentsResponse"
attachments_api_GetAttachmentsResponse.__qualname__ = "GetAttachmentsResponse"
attachments_api_GetAttachmentsResponse.__module__ = "nominal_api.attachments_api"


class attachments_api_SearchAttachmentsQuery(ConjureUnionType):
    _search_text: Optional[str] = None
    _label: Optional[str] = None
    _property: Optional["api_Property"] = None
    _and_: Optional[List["attachments_api_SearchAttachmentsQuery"]] = None
    _or_: Optional[List["attachments_api_SearchAttachmentsQuery"]] = None
    _workspace: Optional[str] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'search_text': ConjureFieldDefinition('searchText', str),
            'label': ConjureFieldDefinition('label', api_Label),
            'property': ConjureFieldDefinition('property', api_Property),
            'and_': ConjureFieldDefinition('and', List[attachments_api_SearchAttachmentsQuery]),
            'or_': ConjureFieldDefinition('or', List[attachments_api_SearchAttachmentsQuery]),
            'workspace': ConjureFieldDefinition('workspace', api_rids_WorkspaceRid)
        }

    def __init__(
            self,
            search_text: Optional[str] = None,
            label: Optional[str] = None,
            property: Optional["api_Property"] = None,
            and_: Optional[List["attachments_api_SearchAttachmentsQuery"]] = None,
            or_: Optional[List["attachments_api_SearchAttachmentsQuery"]] = None,
            workspace: Optional[str] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (search_text is not None) + (label is not None) + (property is not None) + (and_ is not None) + (or_ is not None) + (workspace is not None) != 1:
                raise ValueError('a union must contain a single member')

            if search_text is not None:
                self._search_text = search_text
                self._type = 'searchText'
            if label is not None:
                self._label = label
                self._type = 'label'
            if property is not None:
                self._property = property
                self._type = 'property'
            if and_ is not None:
                self._and_ = and_
                self._type = 'and'
            if or_ is not None:
                self._or_ = or_
                self._type = 'or'
            if workspace is not None:
                self._workspace = workspace
                self._type = 'workspace'

        elif type_of_union == 'searchText':
            if search_text is None:
                raise ValueError('a union value must not be None')
            self._search_text = search_text
            self._type = 'searchText'
        elif type_of_union == 'label':
            if label is None:
                raise ValueError('a union value must not be None')
            self._label = label
            self._type = 'label'
        elif type_of_union == 'property':
            if property is None:
                raise ValueError('a union value must not be None')
            self._property = property
            self._type = 'property'
        elif type_of_union == 'and':
            if and_ is None:
                raise ValueError('a union value must not be None')
            self._and_ = and_
            self._type = 'and'
        elif type_of_union == 'or':
            if or_ is None:
                raise ValueError('a union value must not be None')
            self._or_ = or_
            self._type = 'or'
        elif type_of_union == 'workspace':
            if workspace is None:
                raise ValueError('a union value must not be None')
            self._workspace = workspace
            self._type = 'workspace'

    @builtins.property
    def search_text(self) -> Optional[str]:
        return self._search_text

    @builtins.property
    def label(self) -> Optional[str]:
        return self._label

    @builtins.property
    def property(self) -> Optional["api_Property"]:
        return self._property

    @builtins.property
    def and_(self) -> Optional[List["attachments_api_SearchAttachmentsQuery"]]:
        return self._and_

    @builtins.property
    def or_(self) -> Optional[List["attachments_api_SearchAttachmentsQuery"]]:
        return self._or_

    @builtins.property
    def workspace(self) -> Optional[str]:
        return self._workspace

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, attachments_api_SearchAttachmentsQueryVisitor):
            raise ValueError('{} is not an instance of attachments_api_SearchAttachmentsQueryVisitor'.format(visitor.__class__.__name__))
        if self._type == 'searchText' and self.search_text is not None:
            return visitor._search_text(self.search_text)
        if self._type == 'label' and self.label is not None:
            return visitor._label(self.label)
        if self._type == 'property' and self.property is not None:
            return visitor._property(self.property)
        if self._type == 'and' and self.and_ is not None:
            return visitor._and(self.and_)
        if self._type == 'or' and self.or_ is not None:
            return visitor._or(self.or_)
        if self._type == 'workspace' and self.workspace is not None:
            return visitor._workspace(self.workspace)


attachments_api_SearchAttachmentsQuery.__name__ = "SearchAttachmentsQuery"
attachments_api_SearchAttachmentsQuery.__qualname__ = "SearchAttachmentsQuery"
attachments_api_SearchAttachmentsQuery.__module__ = "nominal_api.attachments_api"


class attachments_api_SearchAttachmentsQueryVisitor:

    @abstractmethod
    def _search_text(self, search_text: str) -> Any:
        pass

    @abstractmethod
    def _label(self, label: str) -> Any:
        pass

    @abstractmethod
    def _property(self, property: "api_Property") -> Any:
        pass

    @abstractmethod
    def _and(self, and_: List["attachments_api_SearchAttachmentsQuery"]) -> Any:
        pass

    @abstractmethod
    def _or(self, or_: List["attachments_api_SearchAttachmentsQuery"]) -> Any:
        pass

    @abstractmethod
    def _workspace(self, workspace: str) -> Any:
        pass


attachments_api_SearchAttachmentsQueryVisitor.__name__ = "SearchAttachmentsQueryVisitor"
attachments_api_SearchAttachmentsQueryVisitor.__qualname__ = "SearchAttachmentsQueryVisitor"
attachments_api_SearchAttachmentsQueryVisitor.__module__ = "nominal_api.attachments_api"


class attachments_api_UpdateAttachmentRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'title': ConjureFieldDefinition('title', OptionalTypeWrapper[str]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'properties': ConjureFieldDefinition('properties', OptionalTypeWrapper[Dict[api_PropertyName, api_PropertyValue]]),
            'labels': ConjureFieldDefinition('labels', OptionalTypeWrapper[List[api_Label]])
        }

    __slots__: List[str] = ['_title', '_description', '_properties', '_labels']

    def __init__(self, description: Optional[str] = None, labels: Optional[List[str]] = None, properties: Optional[Dict[str, str]] = None, title: Optional[str] = None) -> None:
        self._title = title
        self._description = description
        self._properties = properties
        self._labels = labels

    @builtins.property
    def title(self) -> Optional[str]:
        return self._title

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def properties(self) -> Optional[Dict[str, str]]:
        return self._properties

    @builtins.property
    def labels(self) -> Optional[List[str]]:
        return self._labels


attachments_api_UpdateAttachmentRequest.__name__ = "UpdateAttachmentRequest"
attachments_api_UpdateAttachmentRequest.__qualname__ = "UpdateAttachmentRequest"
attachments_api_UpdateAttachmentRequest.__module__ = "nominal_api.attachments_api"


class authentication_api_AppearanceSetting(ConjureEnumType):

    SYSTEM = 'SYSTEM'
    '''SYSTEM'''
    LIGHT = 'LIGHT'
    '''LIGHT'''
    DARK = 'DARK'
    '''DARK'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


authentication_api_AppearanceSetting.__name__ = "AppearanceSetting"
authentication_api_AppearanceSetting.__qualname__ = "AppearanceSetting"
authentication_api_AppearanceSetting.__module__ = "nominal_api.authentication_api"


class authentication_api_AuthenticationServiceV2(Service):
    """This service provides operations for managing user and org profiles/settings.
Its name is a bit of a misnomer.
    """

    def get_my_profile(self, auth_header: str) -> "authentication_api_UserV2":
        """Gets the profile of the authenticated user.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = None

        _path = '/authentication/v2/my/profile'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authentication_api_UserV2, self._return_none_for_unknown_union_types)

    def update_my_profile(self, auth_header: str, update_my_profile_request: "authentication_api_UpdateMyProfileRequest") -> "authentication_api_UserV2":
        """Updates the profile of the authenticated user.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(update_my_profile_request)

        _path = '/authentication/v2/my/profile'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authentication_api_UserV2, self._return_none_for_unknown_union_types)

    def get_my_settings(self, auth_header: str) -> "authentication_api_UserSettings":
        """Gets the settings of the authenticated user.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = None

        _path = '/authentication/v2/my/settings'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authentication_api_UserSettings, self._return_none_for_unknown_union_types)

    def update_my_settings(self, auth_header: str, user_settings: "authentication_api_UserSettings") -> "authentication_api_UserSettings":
        """Updates the settings of the authenticated user.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(user_settings)

        _path = '/authentication/v2/my/settings'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authentication_api_UserSettings, self._return_none_for_unknown_union_types)

    def get_my_org_settings(self, auth_header: str) -> "authentication_api_OrgSettings":
        """Gets the settings of the org of the authenticated user.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = None

        _path = '/authentication/v2/org/settings'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authentication_api_OrgSettings, self._return_none_for_unknown_union_types)

    def update_my_org_settings(self, auth_header: str, org_settings: "authentication_api_OrgSettings") -> "authentication_api_OrgSettings":
        """Updates the settings of the org of the authenticated user.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(org_settings)

        _path = '/authentication/v2/org/settings'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authentication_api_OrgSettings, self._return_none_for_unknown_union_types)

    def search_users_v2(self, auth_header: str, request: "authentication_api_SearchUsersRequest") -> "authentication_api_SearchUsersResponseV2":
        """Searches for users by email and displayName.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/authentication/v2/users'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authentication_api_SearchUsersResponseV2, self._return_none_for_unknown_union_types)

    def get_users(self, auth_header: str, user_rids: List[str] = None) -> List["authentication_api_UserV2"]:
        """Get users by RID.
        """
        user_rids = user_rids if user_rids is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(user_rids)

        _path = '/authentication/v2/users/batch'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[authentication_api_UserV2], self._return_none_for_unknown_union_types)

    def get_user(self, auth_header: str, user_rid: str) -> "authentication_api_UserV2":
        """Gets a user by RID.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'userRid': quote(str(_conjure_encoder.default(user_rid)), safe=''),
        }

        _json: Any = None

        _path = '/authentication/v2/users/{userRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authentication_api_UserV2, self._return_none_for_unknown_union_types)

    def get_jwks(self, ) -> "authentication_api_Jwks":
        """Returns JWKS (JSON Web Key Set) for MediaMTX JWT verification.
Only available if MediaMTX integration is enabled.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = None

        _path = '/authentication/v2/jwks'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authentication_api_Jwks, self._return_none_for_unknown_union_types)

    def generate_media_mtx_token(self, auth_header: str, request: "authentication_api_GenerateMediaMtxTokenRequest") -> "authentication_api_GenerateMediaMtxTokenResponse":
        """Generates a JWT token for MediaMTX authentication with a 2-hour expiration.
The token is signed with the MediaMTX private key and contains the specified permissions.
Requires authentication with Nominal. This endpoint is intended for internal use only.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/authentication/v2/mediamtx/token'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authentication_api_GenerateMediaMtxTokenResponse, self._return_none_for_unknown_union_types)


authentication_api_AuthenticationServiceV2.__name__ = "AuthenticationServiceV2"
authentication_api_AuthenticationServiceV2.__qualname__ = "AuthenticationServiceV2"
authentication_api_AuthenticationServiceV2.__module__ = "nominal_api.authentication_api"


class authentication_api_DefaultTimeRangeTypeSetting(ConjureEnumType):

    DEFAULT = 'DEFAULT'
    '''DEFAULT'''
    ABSOLUTE = 'ABSOLUTE'
    '''ABSOLUTE'''
    RELATIVE = 'RELATIVE'
    '''RELATIVE'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


authentication_api_DefaultTimeRangeTypeSetting.__name__ = "DefaultTimeRangeTypeSetting"
authentication_api_DefaultTimeRangeTypeSetting.__qualname__ = "DefaultTimeRangeTypeSetting"
authentication_api_DefaultTimeRangeTypeSetting.__module__ = "nominal_api.authentication_api"


class authentication_api_GenerateMediaMtxTokenRequest(ConjureBeanType):
    """Request to generate a MediaMTX authentication token
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'permissions': ConjureFieldDefinition('permissions', List[authentication_api_MediaMtxPermission])
        }

    __slots__: List[str] = ['_permissions']

    def __init__(self, permissions: List["authentication_api_MediaMtxPermission"]) -> None:
        self._permissions = permissions

    @builtins.property
    def permissions(self) -> List["authentication_api_MediaMtxPermission"]:
        """List of permissions to include in the token
        """
        return self._permissions


authentication_api_GenerateMediaMtxTokenRequest.__name__ = "GenerateMediaMtxTokenRequest"
authentication_api_GenerateMediaMtxTokenRequest.__qualname__ = "GenerateMediaMtxTokenRequest"
authentication_api_GenerateMediaMtxTokenRequest.__module__ = "nominal_api.authentication_api"


class authentication_api_GenerateMediaMtxTokenResponse(ConjureBeanType):
    """Response containing the generated MediaMTX token
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'token': ConjureFieldDefinition('token', str)
        }

    __slots__: List[str] = ['_token']

    def __init__(self, token: str) -> None:
        self._token = token

    @builtins.property
    def token(self) -> str:
        """The signed JWT token for MediaMTX authentication
        """
        return self._token


authentication_api_GenerateMediaMtxTokenResponse.__name__ = "GenerateMediaMtxTokenResponse"
authentication_api_GenerateMediaMtxTokenResponse.__qualname__ = "GenerateMediaMtxTokenResponse"
authentication_api_GenerateMediaMtxTokenResponse.__module__ = "nominal_api.authentication_api"


class authentication_api_Jwk(ConjureBeanType):
    """A JSON Web Key (JWK) representation for RSA public keys
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'kty': ConjureFieldDefinition('kty', str),
            'kid': ConjureFieldDefinition('kid', str),
            'use': ConjureFieldDefinition('use', str),
            'alg': ConjureFieldDefinition('alg', str),
            'n': ConjureFieldDefinition('n', str),
            'e': ConjureFieldDefinition('e', str)
        }

    __slots__: List[str] = ['_kty', '_kid', '_use', '_alg', '_n', '_e']

    def __init__(self, alg: str, e: str, kid: str, kty: str, n: str, use: str) -> None:
        self._kty = kty
        self._kid = kid
        self._use = use
        self._alg = alg
        self._n = n
        self._e = e

    @builtins.property
    def kty(self) -> str:
        return self._kty

    @builtins.property
    def kid(self) -> str:
        return self._kid

    @builtins.property
    def use(self) -> str:
        return self._use

    @builtins.property
    def alg(self) -> str:
        return self._alg

    @builtins.property
    def n(self) -> str:
        return self._n

    @builtins.property
    def e(self) -> str:
        return self._e


authentication_api_Jwk.__name__ = "Jwk"
authentication_api_Jwk.__qualname__ = "Jwk"
authentication_api_Jwk.__module__ = "nominal_api.authentication_api"


class authentication_api_Jwks(ConjureBeanType):
    """A JSON Web Key Set (JWKS) containing one or more keys
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'keys': ConjureFieldDefinition('keys', List[authentication_api_Jwk])
        }

    __slots__: List[str] = ['_keys']

    def __init__(self, keys: List["authentication_api_Jwk"]) -> None:
        self._keys = keys

    @builtins.property
    def keys(self) -> List["authentication_api_Jwk"]:
        return self._keys


authentication_api_Jwks.__name__ = "Jwks"
authentication_api_Jwks.__qualname__ = "Jwks"
authentication_api_Jwks.__module__ = "nominal_api.authentication_api"


class authentication_api_MediaMtxPermission(ConjureBeanType):
    """A permission definition for MediaMTX authentication
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'action': ConjureFieldDefinition('action', str),
            'path': ConjureFieldDefinition('path', str)
        }

    __slots__: List[str] = ['_action', '_path']

    def __init__(self, action: str, path: str) -> None:
        self._action = action
        self._path = path

    @builtins.property
    def action(self) -> str:
        """The action permitted. Allowed values are publish, read, playback, api, metrics, pprof.
        """
        return self._action

    @builtins.property
    def path(self) -> str:
        """The stream path this permission applies to (e.g., "stream/test")
        """
        return self._path


authentication_api_MediaMtxPermission.__name__ = "MediaMtxPermission"
authentication_api_MediaMtxPermission.__qualname__ = "MediaMtxPermission"
authentication_api_MediaMtxPermission.__module__ = "nominal_api.authentication_api"


class authentication_api_OrgSettings(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'default_time_range_type': ConjureFieldDefinition('defaultTimeRangeType', OptionalTypeWrapper[authentication_api_DefaultTimeRangeTypeSetting])
        }

    __slots__: List[str] = ['_default_time_range_type']

    def __init__(self, default_time_range_type: Optional["authentication_api_DefaultTimeRangeTypeSetting"] = None) -> None:
        self._default_time_range_type = default_time_range_type

    @builtins.property
    def default_time_range_type(self) -> Optional["authentication_api_DefaultTimeRangeTypeSetting"]:
        return self._default_time_range_type


authentication_api_OrgSettings.__name__ = "OrgSettings"
authentication_api_OrgSettings.__qualname__ = "OrgSettings"
authentication_api_OrgSettings.__module__ = "nominal_api.authentication_api"


class authentication_api_SearchUsersQuery(ConjureUnionType):
    _and_: Optional[List["authentication_api_SearchUsersQuery"]] = None
    _or_: Optional[List["authentication_api_SearchUsersQuery"]] = None
    _exact_match: Optional[str] = None
    _search_text: Optional[str] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'and_': ConjureFieldDefinition('and', List[authentication_api_SearchUsersQuery]),
            'or_': ConjureFieldDefinition('or', List[authentication_api_SearchUsersQuery]),
            'exact_match': ConjureFieldDefinition('exactMatch', str),
            'search_text': ConjureFieldDefinition('searchText', str)
        }

    def __init__(
            self,
            and_: Optional[List["authentication_api_SearchUsersQuery"]] = None,
            or_: Optional[List["authentication_api_SearchUsersQuery"]] = None,
            exact_match: Optional[str] = None,
            search_text: Optional[str] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (and_ is not None) + (or_ is not None) + (exact_match is not None) + (search_text is not None) != 1:
                raise ValueError('a union must contain a single member')

            if and_ is not None:
                self._and_ = and_
                self._type = 'and'
            if or_ is not None:
                self._or_ = or_
                self._type = 'or'
            if exact_match is not None:
                self._exact_match = exact_match
                self._type = 'exactMatch'
            if search_text is not None:
                self._search_text = search_text
                self._type = 'searchText'

        elif type_of_union == 'and':
            if and_ is None:
                raise ValueError('a union value must not be None')
            self._and_ = and_
            self._type = 'and'
        elif type_of_union == 'or':
            if or_ is None:
                raise ValueError('a union value must not be None')
            self._or_ = or_
            self._type = 'or'
        elif type_of_union == 'exactMatch':
            if exact_match is None:
                raise ValueError('a union value must not be None')
            self._exact_match = exact_match
            self._type = 'exactMatch'
        elif type_of_union == 'searchText':
            if search_text is None:
                raise ValueError('a union value must not be None')
            self._search_text = search_text
            self._type = 'searchText'

    @builtins.property
    def and_(self) -> Optional[List["authentication_api_SearchUsersQuery"]]:
        return self._and_

    @builtins.property
    def or_(self) -> Optional[List["authentication_api_SearchUsersQuery"]]:
        return self._or_

    @builtins.property
    def exact_match(self) -> Optional[str]:
        """Performs case insensitive exact match on email
        """
        return self._exact_match

    @builtins.property
    def search_text(self) -> Optional[str]:
        """Searches email and display name
        """
        return self._search_text

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, authentication_api_SearchUsersQueryVisitor):
            raise ValueError('{} is not an instance of authentication_api_SearchUsersQueryVisitor'.format(visitor.__class__.__name__))
        if self._type == 'and' and self.and_ is not None:
            return visitor._and(self.and_)
        if self._type == 'or' and self.or_ is not None:
            return visitor._or(self.or_)
        if self._type == 'exactMatch' and self.exact_match is not None:
            return visitor._exact_match(self.exact_match)
        if self._type == 'searchText' and self.search_text is not None:
            return visitor._search_text(self.search_text)


authentication_api_SearchUsersQuery.__name__ = "SearchUsersQuery"
authentication_api_SearchUsersQuery.__qualname__ = "SearchUsersQuery"
authentication_api_SearchUsersQuery.__module__ = "nominal_api.authentication_api"


class authentication_api_SearchUsersQueryVisitor:

    @abstractmethod
    def _and(self, and_: List["authentication_api_SearchUsersQuery"]) -> Any:
        pass

    @abstractmethod
    def _or(self, or_: List["authentication_api_SearchUsersQuery"]) -> Any:
        pass

    @abstractmethod
    def _exact_match(self, exact_match: str) -> Any:
        pass

    @abstractmethod
    def _search_text(self, search_text: str) -> Any:
        pass


authentication_api_SearchUsersQueryVisitor.__name__ = "SearchUsersQueryVisitor"
authentication_api_SearchUsersQueryVisitor.__qualname__ = "SearchUsersQueryVisitor"
authentication_api_SearchUsersQueryVisitor.__module__ = "nominal_api.authentication_api"


class authentication_api_SearchUsersRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'query': ConjureFieldDefinition('query', authentication_api_SearchUsersQuery),
            'sort_by': ConjureFieldDefinition('sortBy', OptionalTypeWrapper[authentication_api_SortBy]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token]),
            'page_size': ConjureFieldDefinition('pageSize', OptionalTypeWrapper[int])
        }

    __slots__: List[str] = ['_query', '_sort_by', '_next_page_token', '_page_size']

    def __init__(self, query: "authentication_api_SearchUsersQuery", next_page_token: Optional[str] = None, page_size: Optional[int] = None, sort_by: Optional["authentication_api_SortBy"] = None) -> None:
        self._query = query
        self._sort_by = sort_by
        self._next_page_token = next_page_token
        self._page_size = page_size

    @builtins.property
    def query(self) -> "authentication_api_SearchUsersQuery":
        return self._query

    @builtins.property
    def sort_by(self) -> Optional["authentication_api_SortBy"]:
        """UPDATED_AT descending by default
        """
        return self._sort_by

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token

    @builtins.property
    def page_size(self) -> Optional[int]:
        """Defaults to 100. Will throw if larger than 1_000.
        """
        return self._page_size


authentication_api_SearchUsersRequest.__name__ = "SearchUsersRequest"
authentication_api_SearchUsersRequest.__qualname__ = "SearchUsersRequest"
authentication_api_SearchUsersRequest.__module__ = "nominal_api.authentication_api"


class authentication_api_SearchUsersResponseV2(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[authentication_api_UserV2]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_results', '_next_page_token']

    def __init__(self, results: List["authentication_api_UserV2"], next_page_token: Optional[str] = None) -> None:
        self._results = results
        self._next_page_token = next_page_token

    @builtins.property
    def results(self) -> List["authentication_api_UserV2"]:
        return self._results

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


authentication_api_SearchUsersResponseV2.__name__ = "SearchUsersResponseV2"
authentication_api_SearchUsersResponseV2.__qualname__ = "SearchUsersResponseV2"
authentication_api_SearchUsersResponseV2.__module__ = "nominal_api.authentication_api"


class authentication_api_SortBy(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'is_descending': ConjureFieldDefinition('isDescending', bool),
            'field': ConjureFieldDefinition('field', authentication_api_SortByField)
        }

    __slots__: List[str] = ['_is_descending', '_field']

    def __init__(self, field: "authentication_api_SortByField", is_descending: bool) -> None:
        self._is_descending = is_descending
        self._field = field

    @builtins.property
    def is_descending(self) -> bool:
        return self._is_descending

    @builtins.property
    def field(self) -> "authentication_api_SortByField":
        return self._field


authentication_api_SortBy.__name__ = "SortBy"
authentication_api_SortBy.__qualname__ = "SortBy"
authentication_api_SortBy.__module__ = "nominal_api.authentication_api"


class authentication_api_SortByField(ConjureEnumType):

    NAME = 'NAME'
    '''NAME'''
    EMAIL = 'EMAIL'
    '''EMAIL'''
    CREATED_AT = 'CREATED_AT'
    '''CREATED_AT'''
    UPDATED_AT = 'UPDATED_AT'
    '''UPDATED_AT'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


authentication_api_SortByField.__name__ = "SortByField"
authentication_api_SortByField.__qualname__ = "SortByField"
authentication_api_SortByField.__module__ = "nominal_api.authentication_api"


class authentication_api_TimezoneSetting(ConjureEnumType):

    LOCAL = 'LOCAL'
    '''LOCAL'''
    UTC = 'UTC'
    '''UTC'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


authentication_api_TimezoneSetting.__name__ = "TimezoneSetting"
authentication_api_TimezoneSetting.__qualname__ = "TimezoneSetting"
authentication_api_TimezoneSetting.__module__ = "nominal_api.authentication_api"


class authentication_api_UpdateMyProfileRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'display_name': ConjureFieldDefinition('displayName', str)
        }

    __slots__: List[str] = ['_display_name']

    def __init__(self, display_name: str) -> None:
        self._display_name = display_name

    @builtins.property
    def display_name(self) -> str:
        return self._display_name


authentication_api_UpdateMyProfileRequest.__name__ = "UpdateMyProfileRequest"
authentication_api_UpdateMyProfileRequest.__qualname__ = "UpdateMyProfileRequest"
authentication_api_UpdateMyProfileRequest.__module__ = "nominal_api.authentication_api"


class authentication_api_UserSettings(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'default_time_range_type': ConjureFieldDefinition('defaultTimeRangeType', OptionalTypeWrapper[authentication_api_DefaultTimeRangeTypeSetting]),
            'appearance': ConjureFieldDefinition('appearance', OptionalTypeWrapper[authentication_api_AppearanceSetting]),
            'timezone': ConjureFieldDefinition('timezone', OptionalTypeWrapper[authentication_api_TimezoneSetting]),
            'time_series_hover_tooltip_concise': ConjureFieldDefinition('timeSeriesHoverTooltipConcise', OptionalTypeWrapper[bool])
        }

    __slots__: List[str] = ['_default_time_range_type', '_appearance', '_timezone', '_time_series_hover_tooltip_concise']

    def __init__(self, appearance: Optional["authentication_api_AppearanceSetting"] = None, default_time_range_type: Optional["authentication_api_DefaultTimeRangeTypeSetting"] = None, time_series_hover_tooltip_concise: Optional[bool] = None, timezone: Optional["authentication_api_TimezoneSetting"] = None) -> None:
        self._default_time_range_type = default_time_range_type
        self._appearance = appearance
        self._timezone = timezone
        self._time_series_hover_tooltip_concise = time_series_hover_tooltip_concise

    @builtins.property
    def default_time_range_type(self) -> Optional["authentication_api_DefaultTimeRangeTypeSetting"]:
        return self._default_time_range_type

    @builtins.property
    def appearance(self) -> Optional["authentication_api_AppearanceSetting"]:
        return self._appearance

    @builtins.property
    def timezone(self) -> Optional["authentication_api_TimezoneSetting"]:
        return self._timezone

    @builtins.property
    def time_series_hover_tooltip_concise(self) -> Optional[bool]:
        return self._time_series_hover_tooltip_concise


authentication_api_UserSettings.__name__ = "UserSettings"
authentication_api_UserSettings.__qualname__ = "UserSettings"
authentication_api_UserSettings.__module__ = "nominal_api.authentication_api"


class authentication_api_UserV2(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', authentication_api_UserRid),
            'org_rid': ConjureFieldDefinition('orgRid', authentication_api_OrgRid),
            'email': ConjureFieldDefinition('email', str),
            'display_name': ConjureFieldDefinition('displayName', str),
            'avatar_url': ConjureFieldDefinition('avatarUrl', str)
        }

    __slots__: List[str] = ['_rid', '_org_rid', '_email', '_display_name', '_avatar_url']

    def __init__(self, avatar_url: str, display_name: str, email: str, org_rid: str, rid: str) -> None:
        self._rid = rid
        self._org_rid = org_rid
        self._email = email
        self._display_name = display_name
        self._avatar_url = avatar_url

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def org_rid(self) -> str:
        return self._org_rid

    @builtins.property
    def email(self) -> str:
        return self._email

    @builtins.property
    def display_name(self) -> str:
        return self._display_name

    @builtins.property
    def avatar_url(self) -> str:
        """Avatar URL or a default avatar if the user does not have one.
        """
        return self._avatar_url


authentication_api_UserV2.__name__ = "UserV2"
authentication_api_UserV2.__qualname__ = "UserV2"
authentication_api_UserV2.__module__ = "nominal_api.authentication_api"


class authorization_ApiKey(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', authorization_ApiKeyRid),
            'api_key_name': ConjureFieldDefinition('apiKeyName', str),
            'created_by': ConjureFieldDefinition('createdBy', str),
            'created_at': ConjureFieldDefinition('createdAt', str),
            'expires_at': ConjureFieldDefinition('expiresAt', OptionalTypeWrapper[str]),
            'is_deleted': ConjureFieldDefinition('isDeleted', bool)
        }

    __slots__: List[str] = ['_rid', '_api_key_name', '_created_by', '_created_at', '_expires_at', '_is_deleted']

    def __init__(self, api_key_name: str, created_at: str, created_by: str, is_deleted: bool, rid: str, expires_at: Optional[str] = None) -> None:
        self._rid = rid
        self._api_key_name = api_key_name
        self._created_by = created_by
        self._created_at = created_at
        self._expires_at = expires_at
        self._is_deleted = is_deleted

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def api_key_name(self) -> str:
        return self._api_key_name

    @builtins.property
    def created_by(self) -> str:
        return self._created_by

    @builtins.property
    def created_at(self) -> str:
        return self._created_at

    @builtins.property
    def expires_at(self) -> Optional[str]:
        return self._expires_at

    @builtins.property
    def is_deleted(self) -> bool:
        return self._is_deleted


authorization_ApiKey.__name__ = "ApiKey"
authorization_ApiKey.__qualname__ = "ApiKey"
authorization_ApiKey.__module__ = "nominal_api.authorization"


class authorization_AuthorizationRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rids': ConjureFieldDefinition('rids', List[str])
        }

    __slots__: List[str] = ['_rids']

    def __init__(self, rids: List[str]) -> None:
        self._rids = rids

    @builtins.property
    def rids(self) -> List[str]:
        return self._rids


authorization_AuthorizationRequest.__name__ = "AuthorizationRequest"
authorization_AuthorizationRequest.__qualname__ = "AuthorizationRequest"
authorization_AuthorizationRequest.__module__ = "nominal_api.authorization"


class authorization_AuthorizationService(Service):
    """Authorization service manages the permissions for a user
to access resources.
    """

    def authorize(self, auth_header: str, request: "authorization_AuthorizationRequest") -> List[str]:
        """Given a set of resources, returns the set of resources that the
user is authorized to access.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/authorization/v1/authorize'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[str], self._return_none_for_unknown_union_types)

    def batch_get_workspace_for_resource(self, auth_header: str, request: List[str] = None) -> Dict[str, str]:
        """Given a set of resources, returns the workspace that each resource belongs to. If a user
is not authorized on the resource, will omit the resource from the response.
        """
        request = request if request is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/authorization/v1/batch-get-workspace-for-resource'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), Dict[str, api_rids_WorkspaceRid], self._return_none_for_unknown_union_types)

    def register_in_workspace(self, auth_header: str, request: "authorization_RegisterInWorkspaceRequest") -> None:
        """Marks a set of resources as belonging to a workspace. Either all resources are
registered or none are.
If the user is not in the workspace, this will throw.
If a resource already belongs to a different workspace, this will throw.
If a resource already belongs to this workspace, this is a no-op.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/authorization/v1/register-in-workspace'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def check_admin(self, auth_header: str) -> None:
        """Given an authenticated session, this endpoint returns a HTTP 204 if the
authenticated user is an admin and HTTP 403 otherwise.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = None

        _path = '/authorization/v1/checkAdmin'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def is_email_allowed(self, request: "authorization_IsEmailAllowedRequest") -> "authorization_IsEmailAllowedResponse":
        """Checks if the email is allowed to register.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/authorization/v1/is-email-allowed'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authorization_IsEmailAllowedResponse, self._return_none_for_unknown_union_types)

    def get_access_token(self, request: "authorization_GetAccessTokenRequest") -> "authorization_GetAccessTokenResponse":
        """Provide an OIDC ID and access token to get a Nominal access token,
suitable for making API requests. Its expiry will match that of the
input access token, capped at 24h.
Throws NotAuthorized if either token is invalid or if the OIDC provider
is not known.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/authorization/v1/access-token'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authorization_GetAccessTokenResponse, self._return_none_for_unknown_union_types)

    def create_api_key(self, auth_header: str, request: "authorization_CreateApiKeyRequest") -> "authorization_CreateApiKeyResponse":
        """Provide a long-lived API key for making API requests.
The API key is irretrievable after initial creation.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/authorization/v1/api-key'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authorization_CreateApiKeyResponse, self._return_none_for_unknown_union_types)

    def list_api_keys_in_org(self, auth_header: str, request: "authorization_ListApiKeyRequest") -> "authorization_ListApiKeyResponse":
        """List all API keys in the organization.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/authorization/v1/api-keys/org'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authorization_ListApiKeyResponse, self._return_none_for_unknown_union_types)

    def list_user_api_keys(self, auth_header: str, request: "authorization_ListApiKeyRequest") -> "authorization_ListApiKeyResponse":
        """List all API keys for the user.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/authorization/v1/api-keys/user'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authorization_ListApiKeyResponse, self._return_none_for_unknown_union_types)

    def revoke_api_key(self, auth_header: str, rid: str) -> None:
        """Delete an API key.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/authorization/v1/api-key/{rid}/delete'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return


authorization_AuthorizationService.__name__ = "AuthorizationService"
authorization_AuthorizationService.__qualname__ = "AuthorizationService"
authorization_AuthorizationService.__module__ = "nominal_api.authorization"


class authorization_Claim(ConjureUnionType):
    _string: Optional[str] = None
    _string_list: Optional[List[str]] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'string': ConjureFieldDefinition('string', str),
            'string_list': ConjureFieldDefinition('stringList', List[str])
        }

    def __init__(
            self,
            string: Optional[str] = None,
            string_list: Optional[List[str]] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (string is not None) + (string_list is not None) != 1:
                raise ValueError('a union must contain a single member')

            if string is not None:
                self._string = string
                self._type = 'string'
            if string_list is not None:
                self._string_list = string_list
                self._type = 'stringList'

        elif type_of_union == 'string':
            if string is None:
                raise ValueError('a union value must not be None')
            self._string = string
            self._type = 'string'
        elif type_of_union == 'stringList':
            if string_list is None:
                raise ValueError('a union value must not be None')
            self._string_list = string_list
            self._type = 'stringList'

    @builtins.property
    def string(self) -> Optional[str]:
        return self._string

    @builtins.property
    def string_list(self) -> Optional[List[str]]:
        return self._string_list

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, authorization_ClaimVisitor):
            raise ValueError('{} is not an instance of authorization_ClaimVisitor'.format(visitor.__class__.__name__))
        if self._type == 'string' and self.string is not None:
            return visitor._string(self.string)
        if self._type == 'stringList' and self.string_list is not None:
            return visitor._string_list(self.string_list)


authorization_Claim.__name__ = "Claim"
authorization_Claim.__qualname__ = "Claim"
authorization_Claim.__module__ = "nominal_api.authorization"


class authorization_ClaimVisitor:

    @abstractmethod
    def _string(self, string: str) -> Any:
        pass

    @abstractmethod
    def _string_list(self, string_list: List[str]) -> Any:
        pass


authorization_ClaimVisitor.__name__ = "ClaimVisitor"
authorization_ClaimVisitor.__qualname__ = "ClaimVisitor"
authorization_ClaimVisitor.__module__ = "nominal_api.authorization"


class authorization_CreateApiKeyRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'api_key_name': ConjureFieldDefinition('apiKeyName', str),
            'expires_after_days': ConjureFieldDefinition('expiresAfterDays', OptionalTypeWrapper[int])
        }

    __slots__: List[str] = ['_api_key_name', '_expires_after_days']

    def __init__(self, api_key_name: str, expires_after_days: Optional[int] = None) -> None:
        self._api_key_name = api_key_name
        self._expires_after_days = expires_after_days

    @builtins.property
    def api_key_name(self) -> str:
        """The name of the API key to create.
        """
        return self._api_key_name

    @builtins.property
    def expires_after_days(self) -> Optional[int]:
        """The number of days after which the API key will expire.
If omitted, the API key will not expire.
        """
        return self._expires_after_days


authorization_CreateApiKeyRequest.__name__ = "CreateApiKeyRequest"
authorization_CreateApiKeyRequest.__qualname__ = "CreateApiKeyRequest"
authorization_CreateApiKeyRequest.__module__ = "nominal_api.authorization"


class authorization_CreateApiKeyResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'api_key_metadata': ConjureFieldDefinition('apiKeyMetadata', authorization_ApiKey),
            'api_key_value': ConjureFieldDefinition('apiKeyValue', str)
        }

    __slots__: List[str] = ['_api_key_metadata', '_api_key_value']

    def __init__(self, api_key_metadata: "authorization_ApiKey", api_key_value: str) -> None:
        self._api_key_metadata = api_key_metadata
        self._api_key_value = api_key_value

    @builtins.property
    def api_key_metadata(self) -> "authorization_ApiKey":
        return self._api_key_metadata

    @builtins.property
    def api_key_value(self) -> str:
        return self._api_key_value


authorization_CreateApiKeyResponse.__name__ = "CreateApiKeyResponse"
authorization_CreateApiKeyResponse.__qualname__ = "CreateApiKeyResponse"
authorization_CreateApiKeyResponse.__module__ = "nominal_api.authorization"


class authorization_GetAccessTokenFromApiKeyRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'api_key_value': ConjureFieldDefinition('apiKeyValue', str)
        }

    __slots__: List[str] = ['_api_key_value']

    def __init__(self, api_key_value: str) -> None:
        self._api_key_value = api_key_value

    @builtins.property
    def api_key_value(self) -> str:
        return self._api_key_value


authorization_GetAccessTokenFromApiKeyRequest.__name__ = "GetAccessTokenFromApiKeyRequest"
authorization_GetAccessTokenFromApiKeyRequest.__qualname__ = "GetAccessTokenFromApiKeyRequest"
authorization_GetAccessTokenFromApiKeyRequest.__module__ = "nominal_api.authorization"


class authorization_GetAccessTokenRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'id_token': ConjureFieldDefinition('idToken', str),
            'access_token': ConjureFieldDefinition('accessToken', str)
        }

    __slots__: List[str] = ['_id_token', '_access_token']

    def __init__(self, access_token: str, id_token: str) -> None:
        self._id_token = id_token
        self._access_token = access_token

    @builtins.property
    def id_token(self) -> str:
        return self._id_token

    @builtins.property
    def access_token(self) -> str:
        """The access token's audience must be for the Nominal API.
        """
        return self._access_token


authorization_GetAccessTokenRequest.__name__ = "GetAccessTokenRequest"
authorization_GetAccessTokenRequest.__qualname__ = "GetAccessTokenRequest"
authorization_GetAccessTokenRequest.__module__ = "nominal_api.authorization"


class authorization_GetAccessTokenResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'access_token': ConjureFieldDefinition('accessToken', str),
            'expires_at_seconds': ConjureFieldDefinition('expiresAtSeconds', int),
            'user_uuid': ConjureFieldDefinition('userUuid', str),
            'org_uuid': ConjureFieldDefinition('orgUuid', str)
        }

    __slots__: List[str] = ['_access_token', '_expires_at_seconds', '_user_uuid', '_org_uuid']

    def __init__(self, access_token: str, expires_at_seconds: int, org_uuid: str, user_uuid: str) -> None:
        self._access_token = access_token
        self._expires_at_seconds = expires_at_seconds
        self._user_uuid = user_uuid
        self._org_uuid = org_uuid

    @builtins.property
    def access_token(self) -> str:
        return self._access_token

    @builtins.property
    def expires_at_seconds(self) -> int:
        return self._expires_at_seconds

    @builtins.property
    def user_uuid(self) -> str:
        return self._user_uuid

    @builtins.property
    def org_uuid(self) -> str:
        return self._org_uuid


authorization_GetAccessTokenResponse.__name__ = "GetAccessTokenResponse"
authorization_GetAccessTokenResponse.__qualname__ = "GetAccessTokenResponse"
authorization_GetAccessTokenResponse.__module__ = "nominal_api.authorization"


class authorization_InternalApiKeyService(Service):
    """This internal-only service manages long lived api keys.e
    """

    def get_access_token_from_api_key_value(self, request: "authorization_GetAccessTokenFromApiKeyRequest") -> "authorization_GetAccessTokenResponse":
        """Get a Nominal-issued access token from a long-lived API key. Callers should verify that
their api key is formatted properly (i.e. prefixed with "nominal_api_key") before calling this endpoint.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/api-key-internal/v1/access-token'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), authorization_GetAccessTokenResponse, self._return_none_for_unknown_union_types)


authorization_InternalApiKeyService.__name__ = "InternalApiKeyService"
authorization_InternalApiKeyService.__qualname__ = "InternalApiKeyService"
authorization_InternalApiKeyService.__module__ = "nominal_api.authorization"


class authorization_IsEmailAllowedRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'email': ConjureFieldDefinition('email', str)
        }

    __slots__: List[str] = ['_email']

    def __init__(self, email: str) -> None:
        self._email = email

    @builtins.property
    def email(self) -> str:
        return self._email


authorization_IsEmailAllowedRequest.__name__ = "IsEmailAllowedRequest"
authorization_IsEmailAllowedRequest.__qualname__ = "IsEmailAllowedRequest"
authorization_IsEmailAllowedRequest.__module__ = "nominal_api.authorization"


class authorization_IsEmailAllowedResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'allowed': ConjureFieldDefinition('allowed', bool)
        }

    __slots__: List[str] = ['_allowed']

    def __init__(self, allowed: bool) -> None:
        self._allowed = allowed

    @builtins.property
    def allowed(self) -> bool:
        return self._allowed


authorization_IsEmailAllowedResponse.__name__ = "IsEmailAllowedResponse"
authorization_IsEmailAllowedResponse.__qualname__ = "IsEmailAllowedResponse"
authorization_IsEmailAllowedResponse.__module__ = "nominal_api.authorization"


class authorization_ListApiKeyRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'include_deleted': ConjureFieldDefinition('includeDeleted', OptionalTypeWrapper[bool]),
            'include_expired': ConjureFieldDefinition('includeExpired', OptionalTypeWrapper[bool]),
            'page_size': ConjureFieldDefinition('pageSize', OptionalTypeWrapper[int]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_include_deleted', '_include_expired', '_page_size', '_next_page_token']

    def __init__(self, include_deleted: Optional[bool] = None, include_expired: Optional[bool] = None, next_page_token: Optional[str] = None, page_size: Optional[int] = None) -> None:
        self._include_deleted = include_deleted
        self._include_expired = include_expired
        self._page_size = page_size
        self._next_page_token = next_page_token

    @builtins.property
    def include_deleted(self) -> Optional[bool]:
        """If true, include deleted API keys in the response. Defaults to false.
        """
        return self._include_deleted

    @builtins.property
    def include_expired(self) -> Optional[bool]:
        """If true, include expired API keys in the response. Defaults to false.
        """
        return self._include_expired

    @builtins.property
    def page_size(self) -> Optional[int]:
        """The maximum number of API keys to return. Defaults to 100.
        """
        return self._page_size

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


authorization_ListApiKeyRequest.__name__ = "ListApiKeyRequest"
authorization_ListApiKeyRequest.__qualname__ = "ListApiKeyRequest"
authorization_ListApiKeyRequest.__module__ = "nominal_api.authorization"


class authorization_ListApiKeyResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'api_keys': ConjureFieldDefinition('apiKeys', List[authorization_ApiKey]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_api_keys', '_next_page_token']

    def __init__(self, api_keys: List["authorization_ApiKey"], next_page_token: Optional[str] = None) -> None:
        self._api_keys = api_keys
        self._next_page_token = next_page_token

    @builtins.property
    def api_keys(self) -> List["authorization_ApiKey"]:
        return self._api_keys

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


authorization_ListApiKeyResponse.__name__ = "ListApiKeyResponse"
authorization_ListApiKeyResponse.__qualname__ = "ListApiKeyResponse"
authorization_ListApiKeyResponse.__module__ = "nominal_api.authorization"


class authorization_RegisterInWorkspaceRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'resource_rids': ConjureFieldDefinition('resourceRids', List[str]),
            'workspace_rid': ConjureFieldDefinition('workspaceRid', api_rids_WorkspaceRid)
        }

    __slots__: List[str] = ['_resource_rids', '_workspace_rid']

    def __init__(self, resource_rids: List[str], workspace_rid: str) -> None:
        self._resource_rids = resource_rids
        self._workspace_rid = workspace_rid

    @builtins.property
    def resource_rids(self) -> List[str]:
        return self._resource_rids

    @builtins.property
    def workspace_rid(self) -> str:
        return self._workspace_rid


authorization_RegisterInWorkspaceRequest.__name__ = "RegisterInWorkspaceRequest"
authorization_RegisterInWorkspaceRequest.__qualname__ = "RegisterInWorkspaceRequest"
authorization_RegisterInWorkspaceRequest.__module__ = "nominal_api.authorization"


class comments_api_Comment(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', comments_api_CommentRid),
            'parent': ConjureFieldDefinition('parent', comments_api_CommentParent),
            'author_rid': ConjureFieldDefinition('authorRid', str),
            'created_at': ConjureFieldDefinition('createdAt', str),
            'edited_at': ConjureFieldDefinition('editedAt', OptionalTypeWrapper[str]),
            'deleted_at': ConjureFieldDefinition('deletedAt', OptionalTypeWrapper[str]),
            'content': ConjureFieldDefinition('content', str),
            'pinned_by': ConjureFieldDefinition('pinnedBy', OptionalTypeWrapper[str]),
            'pinned_at': ConjureFieldDefinition('pinnedAt', OptionalTypeWrapper[str]),
            'reactions': ConjureFieldDefinition('reactions', List[comments_api_Reaction]),
            'attachments': ConjureFieldDefinition('attachments', List[api_rids_AttachmentRid])
        }

    __slots__: List[str] = ['_rid', '_parent', '_author_rid', '_created_at', '_edited_at', '_deleted_at', '_content', '_pinned_by', '_pinned_at', '_reactions', '_attachments']

    def __init__(self, attachments: List[str], author_rid: str, content: str, created_at: str, parent: "comments_api_CommentParent", reactions: List["comments_api_Reaction"], rid: str, deleted_at: Optional[str] = None, edited_at: Optional[str] = None, pinned_at: Optional[str] = None, pinned_by: Optional[str] = None) -> None:
        self._rid = rid
        self._parent = parent
        self._author_rid = author_rid
        self._created_at = created_at
        self._edited_at = edited_at
        self._deleted_at = deleted_at
        self._content = content
        self._pinned_by = pinned_by
        self._pinned_at = pinned_at
        self._reactions = reactions
        self._attachments = attachments

    @builtins.property
    def rid(self) -> str:
        """Unique resource identifier for the comment
        """
        return self._rid

    @builtins.property
    def parent(self) -> "comments_api_CommentParent":
        """The parent of the comment. It can be a resource or another comment.
        """
        return self._parent

    @builtins.property
    def author_rid(self) -> str:
        """The user who authored the comment
        """
        return self._author_rid

    @builtins.property
    def created_at(self) -> str:
        """The time the comment was created
        """
        return self._created_at

    @builtins.property
    def edited_at(self) -> Optional[str]:
        """The time the comment was edited. Empty if the comment has not been edited.
        """
        return self._edited_at

    @builtins.property
    def deleted_at(self) -> Optional[str]:
        """The time the comment was deleted. Empty if the comment has not been deleted.
        """
        return self._deleted_at

    @builtins.property
    def content(self) -> str:
        """The markdown content of the comment.
        """
        return self._content

    @builtins.property
    def pinned_by(self) -> Optional[str]:
        """The user who pinned the comment. Empty if the comment is not pinned.
        """
        return self._pinned_by

    @builtins.property
    def pinned_at(self) -> Optional[str]:
        """The time the comment was pinned. Empty if the comment is not pinned.
        """
        return self._pinned_at

    @builtins.property
    def reactions(self) -> List["comments_api_Reaction"]:
        """The reactions on the comment
        """
        return self._reactions

    @builtins.property
    def attachments(self) -> List[str]:
        """The comment's attachments
        """
        return self._attachments


comments_api_Comment.__name__ = "Comment"
comments_api_Comment.__qualname__ = "Comment"
comments_api_Comment.__module__ = "nominal_api.comments_api"


class comments_api_CommentParent(ConjureUnionType):
    """The parent of a comment. It can be a resource or another comment in the case of a reply.
    """
    _resource: Optional["comments_api_CommentParentResource"] = None
    _comment: Optional["comments_api_CommentParentComment"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'resource': ConjureFieldDefinition('resource', comments_api_CommentParentResource),
            'comment': ConjureFieldDefinition('comment', comments_api_CommentParentComment)
        }

    def __init__(
            self,
            resource: Optional["comments_api_CommentParentResource"] = None,
            comment: Optional["comments_api_CommentParentComment"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (resource is not None) + (comment is not None) != 1:
                raise ValueError('a union must contain a single member')

            if resource is not None:
                self._resource = resource
                self._type = 'resource'
            if comment is not None:
                self._comment = comment
                self._type = 'comment'

        elif type_of_union == 'resource':
            if resource is None:
                raise ValueError('a union value must not be None')
            self._resource = resource
            self._type = 'resource'
        elif type_of_union == 'comment':
            if comment is None:
                raise ValueError('a union value must not be None')
            self._comment = comment
            self._type = 'comment'

    @builtins.property
    def resource(self) -> Optional["comments_api_CommentParentResource"]:
        return self._resource

    @builtins.property
    def comment(self) -> Optional["comments_api_CommentParentComment"]:
        return self._comment

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, comments_api_CommentParentVisitor):
            raise ValueError('{} is not an instance of comments_api_CommentParentVisitor'.format(visitor.__class__.__name__))
        if self._type == 'resource' and self.resource is not None:
            return visitor._resource(self.resource)
        if self._type == 'comment' and self.comment is not None:
            return visitor._comment(self.comment)


comments_api_CommentParent.__name__ = "CommentParent"
comments_api_CommentParent.__qualname__ = "CommentParent"
comments_api_CommentParent.__module__ = "nominal_api.comments_api"


class comments_api_CommentParentVisitor:

    @abstractmethod
    def _resource(self, resource: "comments_api_CommentParentResource") -> Any:
        pass

    @abstractmethod
    def _comment(self, comment: "comments_api_CommentParentComment") -> Any:
        pass


comments_api_CommentParentVisitor.__name__ = "CommentParentVisitor"
comments_api_CommentParentVisitor.__qualname__ = "CommentParentVisitor"
comments_api_CommentParentVisitor.__module__ = "nominal_api.comments_api"


class comments_api_CommentParentComment(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'comment_rid': ConjureFieldDefinition('commentRid', comments_api_CommentRid)
        }

    __slots__: List[str] = ['_comment_rid']

    def __init__(self, comment_rid: str) -> None:
        self._comment_rid = comment_rid

    @builtins.property
    def comment_rid(self) -> str:
        """The resource identifier for the comment that the comment is replying to
        """
        return self._comment_rid


comments_api_CommentParentComment.__name__ = "CommentParentComment"
comments_api_CommentParentComment.__qualname__ = "CommentParentComment"
comments_api_CommentParentComment.__module__ = "nominal_api.comments_api"


class comments_api_CommentParentResource(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'resource_type': ConjureFieldDefinition('resourceType', comments_api_ResourceType),
            'resource_rid': ConjureFieldDefinition('resourceRid', str)
        }

    __slots__: List[str] = ['_resource_type', '_resource_rid']

    def __init__(self, resource_rid: str, resource_type: "comments_api_ResourceType") -> None:
        self._resource_type = resource_type
        self._resource_rid = resource_rid

    @builtins.property
    def resource_type(self) -> "comments_api_ResourceType":
        """The type of resource that the comment is associated with
        """
        return self._resource_type

    @builtins.property
    def resource_rid(self) -> str:
        """The resource identifier for the resource that the comment is associated with. For example, a run or a workbook.
        """
        return self._resource_rid


comments_api_CommentParentResource.__name__ = "CommentParentResource"
comments_api_CommentParentResource.__qualname__ = "CommentParentResource"
comments_api_CommentParentResource.__module__ = "nominal_api.comments_api"


class comments_api_CommentsService(Service):
    """Comments service manages conversations about resources.
    """

    def get_conversation(self, auth_header: str, resource_rid: str, resource_type: "comments_api_ResourceType") -> "comments_api_Conversation":
        """A conversation is a fully resolved comment tree. It includes all comments for the given resource
and all the nested comments/replies to those comments.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceType': quote(str(_conjure_encoder.default(resource_type)), safe=''),
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
        }

        _json: Any = None

        _path = '/comments/v1/conversations/{resourceType}/{resourceRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), comments_api_Conversation, self._return_none_for_unknown_union_types)

    def get_conversation_count(self, auth_header: str, resource_rid: str, resource_type: "comments_api_ResourceType", include_deleted: Optional[bool] = None) -> int:
        """Returns the number of comments in a conversation.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'includeDeleted': _conjure_encoder.default(include_deleted),
        }

        _path_params: Dict[str, str] = {
            'resourceType': quote(str(_conjure_encoder.default(resource_type)), safe=''),
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
        }

        _json: Any = None

        _path = '/comments/v1/conversations/{resourceType}/{resourceRid}/count'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), int, self._return_none_for_unknown_union_types)

    def get_comment(self, auth_header: str, comment_rid: str) -> "comments_api_Comment":
        """Get a comment identified by its RID
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'commentRid': quote(str(_conjure_encoder.default(comment_rid)), safe=''),
        }

        _json: Any = None

        _path = '/comments/v1/comments/{commentRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), comments_api_Comment, self._return_none_for_unknown_union_types)

    def create_comment(self, auth_header: str, request: "comments_api_CreateCommentRequest") -> "comments_api_Comment":
        """Create a comment on a resource
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/comments/v1/comments'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), comments_api_Comment, self._return_none_for_unknown_union_types)

    def edit_comment(self, auth_header: str, comment_rid: str, request: "comments_api_EditCommentRequest") -> "comments_api_Comment":
        """Edit an existing comment
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'commentRid': quote(str(_conjure_encoder.default(comment_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/comments/v1/comments/{commentRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), comments_api_Comment, self._return_none_for_unknown_union_types)

    def delete_comment(self, auth_header: str, comment_rid: str) -> "comments_api_Comment":
        """Delete an existing comment
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'commentRid': quote(str(_conjure_encoder.default(comment_rid)), safe=''),
        }

        _json: Any = None

        _path = '/comments/v1/comments/{commentRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'DELETE',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), comments_api_Comment, self._return_none_for_unknown_union_types)

    def pin_comment(self, auth_header: str, comment_rid: str) -> "comments_api_Comment":
        """Pin a comment to the top of the conversation
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'commentRid': quote(str(_conjure_encoder.default(comment_rid)), safe=''),
        }

        _json: Any = None

        _path = '/comments/v1/comments/{commentRid}/pin'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), comments_api_Comment, self._return_none_for_unknown_union_types)

    def unpin_comment(self, auth_header: str, comment_rid: str) -> "comments_api_Comment":
        """Unpin a comment from the top of the conversation
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'commentRid': quote(str(_conjure_encoder.default(comment_rid)), safe=''),
        }

        _json: Any = None

        _path = '/comments/v1/comments/{commentRid}/pin'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'DELETE',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), comments_api_Comment, self._return_none_for_unknown_union_types)

    def add_reaction(self, auth_header: str, comment_rid: str, type: "comments_api_ReactionType") -> "comments_api_Comment":
        """Create a reaction on a comment
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'commentRid': quote(str(_conjure_encoder.default(comment_rid)), safe=''),
            'type': quote(str(_conjure_encoder.default(type)), safe=''),
        }

        _json: Any = None

        _path = '/comments/v1/comments/{commentRid}/reactions/{type}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), comments_api_Comment, self._return_none_for_unknown_union_types)

    def remove_reaction(self, auth_header: str, comment_rid: str, type: "comments_api_ReactionType") -> "comments_api_Comment":
        """Create a reaction on a comment
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'commentRid': quote(str(_conjure_encoder.default(comment_rid)), safe=''),
            'type': quote(str(_conjure_encoder.default(type)), safe=''),
        }

        _json: Any = None

        _path = '/comments/v1/comments/{commentRid}/reactions/{type}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'DELETE',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), comments_api_Comment, self._return_none_for_unknown_union_types)


comments_api_CommentsService.__name__ = "CommentsService"
comments_api_CommentsService.__qualname__ = "CommentsService"
comments_api_CommentsService.__module__ = "nominal_api.comments_api"


class comments_api_Conversation(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'resource_rid': ConjureFieldDefinition('resourceRid', str),
            'resource_type': ConjureFieldDefinition('resourceType', comments_api_ResourceType),
            'comments': ConjureFieldDefinition('comments', List[comments_api_ConversationNode])
        }

    __slots__: List[str] = ['_resource_rid', '_resource_type', '_comments']

    def __init__(self, comments: List["comments_api_ConversationNode"], resource_rid: str, resource_type: "comments_api_ResourceType") -> None:
        self._resource_rid = resource_rid
        self._resource_type = resource_type
        self._comments = comments

    @builtins.property
    def resource_rid(self) -> str:
        """RID for the resource that the conversation is associated with.
        """
        return self._resource_rid

    @builtins.property
    def resource_type(self) -> "comments_api_ResourceType":
        """The type of the resource that the conversation is associated with.
        """
        return self._resource_type

    @builtins.property
    def comments(self) -> List["comments_api_ConversationNode"]:
        """The comments on the conversation ordered by creation time.
Empty if the comment has no replies.
        """
        return self._comments


comments_api_Conversation.__name__ = "Conversation"
comments_api_Conversation.__qualname__ = "Conversation"
comments_api_Conversation.__module__ = "nominal_api.comments_api"


class comments_api_ConversationNode(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'comment': ConjureFieldDefinition('comment', comments_api_Comment),
            'replies': ConjureFieldDefinition('replies', List[comments_api_ConversationNode])
        }

    __slots__: List[str] = ['_comment', '_replies']

    def __init__(self, comment: "comments_api_Comment", replies: List["comments_api_ConversationNode"]) -> None:
        self._comment = comment
        self._replies = replies

    @builtins.property
    def comment(self) -> "comments_api_Comment":
        """The comment
        """
        return self._comment

    @builtins.property
    def replies(self) -> List["comments_api_ConversationNode"]:
        """The comments on (aka replies to) the comment ordered by creation time. Empty if the comment has no replies.
        """
        return self._replies


comments_api_ConversationNode.__name__ = "ConversationNode"
comments_api_ConversationNode.__qualname__ = "ConversationNode"
comments_api_ConversationNode.__module__ = "nominal_api.comments_api"


class comments_api_CreateCommentRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'parent': ConjureFieldDefinition('parent', comments_api_CommentParent),
            'content': ConjureFieldDefinition('content', str),
            'attachments': ConjureFieldDefinition('attachments', List[api_rids_AttachmentRid])
        }

    __slots__: List[str] = ['_parent', '_content', '_attachments']

    def __init__(self, attachments: List[str], content: str, parent: "comments_api_CommentParent") -> None:
        self._parent = parent
        self._content = content
        self._attachments = attachments

    @builtins.property
    def parent(self) -> "comments_api_CommentParent":
        return self._parent

    @builtins.property
    def content(self) -> str:
        """The content of the comment. Markdown supported.
        """
        return self._content

    @builtins.property
    def attachments(self) -> List[str]:
        """Attachments to the comment.
        """
        return self._attachments


comments_api_CreateCommentRequest.__name__ = "CreateCommentRequest"
comments_api_CreateCommentRequest.__qualname__ = "CreateCommentRequest"
comments_api_CreateCommentRequest.__module__ = "nominal_api.comments_api"


class comments_api_EditCommentRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'content': ConjureFieldDefinition('content', str),
            'attachments': ConjureFieldDefinition('attachments', List[api_rids_AttachmentRid])
        }

    __slots__: List[str] = ['_content', '_attachments']

    def __init__(self, attachments: List[str], content: str) -> None:
        self._content = content
        self._attachments = attachments

    @builtins.property
    def content(self) -> str:
        """The content of the comment. Markdown supported.
        """
        return self._content

    @builtins.property
    def attachments(self) -> List[str]:
        """Attachments to the comment.
        """
        return self._attachments


comments_api_EditCommentRequest.__name__ = "EditCommentRequest"
comments_api_EditCommentRequest.__qualname__ = "EditCommentRequest"
comments_api_EditCommentRequest.__module__ = "nominal_api.comments_api"


class comments_api_Reaction(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', comments_api_ReactionRid),
            'user_rid': ConjureFieldDefinition('userRid', str),
            'created_at': ConjureFieldDefinition('createdAt', str),
            'type': ConjureFieldDefinition('type', comments_api_ReactionType)
        }

    __slots__: List[str] = ['_rid', '_user_rid', '_created_at', '_type']

    def __init__(self, created_at: str, rid: str, type: "comments_api_ReactionType", user_rid: str) -> None:
        self._rid = rid
        self._user_rid = user_rid
        self._created_at = created_at
        self._type = type

    @builtins.property
    def rid(self) -> str:
        """Unique resource identifier for the reaction
        """
        return self._rid

    @builtins.property
    def user_rid(self) -> str:
        """The user who authored the reaction
        """
        return self._user_rid

    @builtins.property
    def created_at(self) -> str:
        """The time the reaction was created
        """
        return self._created_at

    @builtins.property
    def type(self) -> "comments_api_ReactionType":
        """The type of reaction
        """
        return self._type


comments_api_Reaction.__name__ = "Reaction"
comments_api_Reaction.__qualname__ = "Reaction"
comments_api_Reaction.__module__ = "nominal_api.comments_api"


class comments_api_ReactionType(ConjureEnumType):

    LIKE = 'LIKE'
    '''LIKE'''
    DISLIKE = 'DISLIKE'
    '''DISLIKE'''
    HEART = 'HEART'
    '''HEART'''
    HOORAY = 'HOORAY'
    '''HOORAY'''
    ROCKET = 'ROCKET'
    '''ROCKET'''
    EYES = 'EYES'
    '''EYES'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


comments_api_ReactionType.__name__ = "ReactionType"
comments_api_ReactionType.__qualname__ = "ReactionType"
comments_api_ReactionType.__module__ = "nominal_api.comments_api"


class comments_api_ResourceType(ConjureEnumType):

    RUN = 'RUN'
    '''RUN'''
    EVENT = 'EVENT'
    '''EVENT'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


comments_api_ResourceType.__name__ = "ResourceType"
comments_api_ResourceType.__qualname__ = "ResourceType"
comments_api_ResourceType.__module__ = "nominal_api.comments_api"


class connect_download_Platform(ConjureEnumType):

    WINDOWS = 'WINDOWS'
    '''WINDOWS'''
    UBUNTU = 'UBUNTU'
    '''UBUNTU'''
    MACOS = 'MACOS'
    '''MACOS'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


connect_download_Platform.__name__ = "Platform"
connect_download_Platform.__qualname__ = "Platform"
connect_download_Platform.__module__ = "nominal_api.connect_download"


class datasource_TimestampType(ConjureEnumType):

    RELATIVE = 'RELATIVE'
    '''RELATIVE'''
    ABSOLUTE = 'ABSOLUTE'
    '''ABSOLUTE'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


datasource_TimestampType.__name__ = "TimestampType"
datasource_TimestampType.__qualname__ = "TimestampType"
datasource_TimestampType.__module__ = "nominal_api.datasource"


class datasource_api_BatchGetChannelPrefixTreeRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'data_source_rids': ConjureFieldDefinition('dataSourceRids', List[api_rids_DataSourceRid]),
            'data_scope_filters': ConjureFieldDefinition('dataScopeFilters', OptionalTypeWrapper[datasource_api_DataScopeFilters])
        }

    __slots__: List[str] = ['_data_source_rids', '_data_scope_filters']

    def __init__(self, data_source_rids: List[str], data_scope_filters: Optional["datasource_api_DataScopeFilters"] = None) -> None:
        self._data_source_rids = data_source_rids
        self._data_scope_filters = data_scope_filters

    @builtins.property
    def data_source_rids(self) -> List[str]:
        return self._data_source_rids

    @builtins.property
    def data_scope_filters(self) -> Optional["datasource_api_DataScopeFilters"]:
        """When dataScopeFilters are specified, the set of data sources must match the set of data sources in
DataScopeFilters#tags
        """
        return self._data_scope_filters


datasource_api_BatchGetChannelPrefixTreeRequest.__name__ = "BatchGetChannelPrefixTreeRequest"
datasource_api_BatchGetChannelPrefixTreeRequest.__qualname__ = "BatchGetChannelPrefixTreeRequest"
datasource_api_BatchGetChannelPrefixTreeRequest.__module__ = "nominal_api.datasource_api"


class datasource_api_BatchGetChannelPrefixTreeResponse(ConjureBeanType):
    """If the tree for a data source has not been indexed, it will be omitted from the map.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'channel_prefix_trees': ConjureFieldDefinition('channelPrefixTrees', Dict[api_rids_DataSourceRid, datasource_api_ChannelPrefixTree])
        }

    __slots__: List[str] = ['_channel_prefix_trees']

    def __init__(self, channel_prefix_trees: Dict[str, "datasource_api_ChannelPrefixTree"]) -> None:
        self._channel_prefix_trees = channel_prefix_trees

    @builtins.property
    def channel_prefix_trees(self) -> Dict[str, "datasource_api_ChannelPrefixTree"]:
        return self._channel_prefix_trees


datasource_api_BatchGetChannelPrefixTreeResponse.__name__ = "BatchGetChannelPrefixTreeResponse"
datasource_api_BatchGetChannelPrefixTreeResponse.__qualname__ = "BatchGetChannelPrefixTreeResponse"
datasource_api_BatchGetChannelPrefixTreeResponse.__module__ = "nominal_api.datasource_api"


class datasource_api_BatchGetDataScopeBoundsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'requests': ConjureFieldDefinition('requests', List[datasource_api_GetDataScopeBoundsRequest])
        }

    __slots__: List[str] = ['_requests']

    def __init__(self, requests: List["datasource_api_GetDataScopeBoundsRequest"]) -> None:
        self._requests = requests

    @builtins.property
    def requests(self) -> List["datasource_api_GetDataScopeBoundsRequest"]:
        return self._requests


datasource_api_BatchGetDataScopeBoundsRequest.__name__ = "BatchGetDataScopeBoundsRequest"
datasource_api_BatchGetDataScopeBoundsRequest.__qualname__ = "BatchGetDataScopeBoundsRequest"
datasource_api_BatchGetDataScopeBoundsRequest.__module__ = "nominal_api.datasource_api"


class datasource_api_BatchGetDataScopeBoundsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'responses': ConjureFieldDefinition('responses', List[datasource_api_GetDataScopeBoundsResponse])
        }

    __slots__: List[str] = ['_responses']

    def __init__(self, responses: List["datasource_api_GetDataScopeBoundsResponse"]) -> None:
        self._responses = responses

    @builtins.property
    def responses(self) -> List["datasource_api_GetDataScopeBoundsResponse"]:
        return self._responses


datasource_api_BatchGetDataScopeBoundsResponse.__name__ = "BatchGetDataScopeBoundsResponse"
datasource_api_BatchGetDataScopeBoundsResponse.__qualname__ = "BatchGetDataScopeBoundsResponse"
datasource_api_BatchGetDataScopeBoundsResponse.__module__ = "nominal_api.datasource_api"


class datasource_api_ChannelMetadata(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', api_Channel),
            'data_source': ConjureFieldDefinition('dataSource', api_rids_DataSourceRid),
            'unit': ConjureFieldDefinition('unit', OptionalTypeWrapper[scout_run_api_Unit]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'data_type': ConjureFieldDefinition('dataType', OptionalTypeWrapper[api_SeriesDataType]),
            'series_rid': ConjureFieldDefinition('seriesRid', datasource_api_SeriesMetadataRidOrLogicalSeriesRid)
        }

    __slots__: List[str] = ['_name', '_data_source', '_unit', '_description', '_data_type', '_series_rid']

    def __init__(self, data_source: str, name: str, series_rid: "datasource_api_SeriesMetadataRidOrLogicalSeriesRid", data_type: Optional["api_SeriesDataType"] = None, description: Optional[str] = None, unit: Optional["scout_run_api_Unit"] = None) -> None:
        self._name = name
        self._data_source = data_source
        self._unit = unit
        self._description = description
        self._data_type = data_type
        self._series_rid = series_rid

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def data_source(self) -> str:
        return self._data_source

    @builtins.property
    def unit(self) -> Optional["scout_run_api_Unit"]:
        return self._unit

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def data_type(self) -> Optional["api_SeriesDataType"]:
        return self._data_type

    @builtins.property
    def series_rid(self) -> "datasource_api_SeriesMetadataRidOrLogicalSeriesRid":
        return self._series_rid


datasource_api_ChannelMetadata.__name__ = "ChannelMetadata"
datasource_api_ChannelMetadata.__qualname__ = "ChannelMetadata"
datasource_api_ChannelMetadata.__module__ = "nominal_api.datasource_api"


class datasource_api_ChannelOrPrefix(ConjureUnionType):
    _channel: Optional["datasource_api_ChannelMetadata"] = None
    _prefix: Optional["datasource_api_DataSourcePrefixNode"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'channel': ConjureFieldDefinition('channel', datasource_api_ChannelMetadata),
            'prefix': ConjureFieldDefinition('prefix', datasource_api_DataSourcePrefixNode)
        }

    def __init__(
            self,
            channel: Optional["datasource_api_ChannelMetadata"] = None,
            prefix: Optional["datasource_api_DataSourcePrefixNode"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (channel is not None) + (prefix is not None) != 1:
                raise ValueError('a union must contain a single member')

            if channel is not None:
                self._channel = channel
                self._type = 'channel'
            if prefix is not None:
                self._prefix = prefix
                self._type = 'prefix'

        elif type_of_union == 'channel':
            if channel is None:
                raise ValueError('a union value must not be None')
            self._channel = channel
            self._type = 'channel'
        elif type_of_union == 'prefix':
            if prefix is None:
                raise ValueError('a union value must not be None')
            self._prefix = prefix
            self._type = 'prefix'

    @builtins.property
    def channel(self) -> Optional["datasource_api_ChannelMetadata"]:
        return self._channel

    @builtins.property
    def prefix(self) -> Optional["datasource_api_DataSourcePrefixNode"]:
        return self._prefix

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, datasource_api_ChannelOrPrefixVisitor):
            raise ValueError('{} is not an instance of datasource_api_ChannelOrPrefixVisitor'.format(visitor.__class__.__name__))
        if self._type == 'channel' and self.channel is not None:
            return visitor._channel(self.channel)
        if self._type == 'prefix' and self.prefix is not None:
            return visitor._prefix(self.prefix)


datasource_api_ChannelOrPrefix.__name__ = "ChannelOrPrefix"
datasource_api_ChannelOrPrefix.__qualname__ = "ChannelOrPrefix"
datasource_api_ChannelOrPrefix.__module__ = "nominal_api.datasource_api"


class datasource_api_ChannelOrPrefixVisitor:

    @abstractmethod
    def _channel(self, channel: "datasource_api_ChannelMetadata") -> Any:
        pass

    @abstractmethod
    def _prefix(self, prefix: "datasource_api_DataSourcePrefixNode") -> Any:
        pass


datasource_api_ChannelOrPrefixVisitor.__name__ = "ChannelOrPrefixVisitor"
datasource_api_ChannelOrPrefixVisitor.__qualname__ = "ChannelOrPrefixVisitor"
datasource_api_ChannelOrPrefixVisitor.__module__ = "nominal_api.datasource_api"


class datasource_api_ChannelPrefixTree(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'roots': ConjureFieldDefinition('roots', List[datasource_api_ChannelPrefixTreeNode]),
            'delimiter': ConjureFieldDefinition('delimiter', str)
        }

    __slots__: List[str] = ['_roots', '_delimiter']

    def __init__(self, delimiter: str, roots: List["datasource_api_ChannelPrefixTreeNode"]) -> None:
        self._roots = roots
        self._delimiter = delimiter

    @builtins.property
    def roots(self) -> List["datasource_api_ChannelPrefixTreeNode"]:
        return self._roots

    @builtins.property
    def delimiter(self) -> str:
        return self._delimiter


datasource_api_ChannelPrefixTree.__name__ = "ChannelPrefixTree"
datasource_api_ChannelPrefixTree.__qualname__ = "ChannelPrefixTree"
datasource_api_ChannelPrefixTree.__module__ = "nominal_api.datasource_api"


class datasource_api_ChannelPrefixTreeNode(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'part': ConjureFieldDefinition('part', str),
            'children': ConjureFieldDefinition('children', List[datasource_api_ChannelPrefixTreeNode])
        }

    __slots__: List[str] = ['_part', '_children']

    def __init__(self, children: List["datasource_api_ChannelPrefixTreeNode"], part: str) -> None:
        self._part = part
        self._children = children

    @builtins.property
    def part(self) -> str:
        """Should be combined with the ancestor parts and the delimiter to form the full prefix.
        """
        return self._part

    @builtins.property
    def children(self) -> List["datasource_api_ChannelPrefixTreeNode"]:
        return self._children


datasource_api_ChannelPrefixTreeNode.__name__ = "ChannelPrefixTreeNode"
datasource_api_ChannelPrefixTreeNode.__qualname__ = "ChannelPrefixTreeNode"
datasource_api_ChannelPrefixTreeNode.__module__ = "nominal_api.datasource_api"


class datasource_api_ChannelWithAvailableTags(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'data_source_rid': ConjureFieldDefinition('dataSourceRid', api_rids_DataSourceRid),
            'channel': ConjureFieldDefinition('channel', api_Channel),
            'available_tags': ConjureFieldDefinition('availableTags', Dict[api_TagName, List[api_TagValue]])
        }

    __slots__: List[str] = ['_data_source_rid', '_channel', '_available_tags']

    def __init__(self, available_tags: Dict[str, List[str]], channel: str, data_source_rid: str) -> None:
        self._data_source_rid = data_source_rid
        self._channel = channel
        self._available_tags = available_tags

    @builtins.property
    def data_source_rid(self) -> str:
        return self._data_source_rid

    @builtins.property
    def channel(self) -> str:
        return self._channel

    @builtins.property
    def available_tags(self) -> Dict[str, List[str]]:
        """A set of tag keys and their values given the initial set of filters. The initial tag filters
will be included in the map with their corresponding values.
        """
        return self._available_tags


datasource_api_ChannelWithAvailableTags.__name__ = "ChannelWithAvailableTags"
datasource_api_ChannelWithAvailableTags.__qualname__ = "ChannelWithAvailableTags"
datasource_api_ChannelWithAvailableTags.__module__ = "nominal_api.datasource_api"


class datasource_api_ChannelWithTagFilters(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'data_source_rid': ConjureFieldDefinition('dataSourceRid', api_rids_DataSourceRid),
            'channel': ConjureFieldDefinition('channel', api_Channel),
            'tag_filters': ConjureFieldDefinition('tagFilters', Dict[api_TagName, api_TagValue])
        }

    __slots__: List[str] = ['_data_source_rid', '_channel', '_tag_filters']

    def __init__(self, channel: str, data_source_rid: str, tag_filters: Dict[str, str]) -> None:
        self._data_source_rid = data_source_rid
        self._channel = channel
        self._tag_filters = tag_filters

    @builtins.property
    def data_source_rid(self) -> str:
        return self._data_source_rid

    @builtins.property
    def channel(self) -> str:
        return self._channel

    @builtins.property
    def tag_filters(self) -> Dict[str, str]:
        return self._tag_filters


datasource_api_ChannelWithTagFilters.__name__ = "ChannelWithTagFilters"
datasource_api_ChannelWithTagFilters.__qualname__ = "ChannelWithTagFilters"
datasource_api_ChannelWithTagFilters.__module__ = "nominal_api.datasource_api"


class datasource_api_DataScopeFilters(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'tags': ConjureFieldDefinition('tags', Dict[api_rids_DataSourceRid, Dict[api_TagName, api_TagValue]]),
            'min_data_updated_time': ConjureFieldDefinition('minDataUpdatedTime', scout_run_api_UtcTimestamp),
            'max_data_start_time': ConjureFieldDefinition('maxDataStartTime', scout_run_api_UtcTimestamp)
        }

    __slots__: List[str] = ['_tags', '_min_data_updated_time', '_max_data_start_time']

    def __init__(self, max_data_start_time: "scout_run_api_UtcTimestamp", min_data_updated_time: "scout_run_api_UtcTimestamp", tags: Dict[str, Dict[str, str]]) -> None:
        self._tags = tags
        self._min_data_updated_time = min_data_updated_time
        self._max_data_start_time = max_data_start_time

    @builtins.property
    def tags(self) -> Dict[str, Dict[str, str]]:
        """For each data source specified as a key, search will only return channels containing a superset of the 
tags specified for that given datasource.
        """
        return self._tags

    @builtins.property
    def min_data_updated_time(self) -> "scout_run_api_UtcTimestamp":
        """Will only return channels that have had new data after the specified time.
        """
        return self._min_data_updated_time

    @builtins.property
    def max_data_start_time(self) -> "scout_run_api_UtcTimestamp":
        """Will only return channels that have data before the specified time.
        """
        return self._max_data_start_time


datasource_api_DataScopeFilters.__name__ = "DataScopeFilters"
datasource_api_DataScopeFilters.__qualname__ = "DataScopeFilters"
datasource_api_DataScopeFilters.__module__ = "nominal_api.datasource_api"


class datasource_api_DataSourcePrefixNode(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'part': ConjureFieldDefinition('part', str),
            'data_source': ConjureFieldDefinition('dataSource', api_rids_DataSourceRid)
        }

    __slots__: List[str] = ['_part', '_data_source']

    def __init__(self, data_source: str, part: str) -> None:
        self._part = part
        self._data_source = data_source

    @builtins.property
    def part(self) -> str:
        """Should be combined with the ancestor parts and the delimiter to form the full prefix.
        """
        return self._part

    @builtins.property
    def data_source(self) -> str:
        return self._data_source


datasource_api_DataSourcePrefixNode.__name__ = "DataSourcePrefixNode"
datasource_api_DataSourcePrefixNode.__qualname__ = "DataSourcePrefixNode"
datasource_api_DataSourcePrefixNode.__module__ = "nominal_api.datasource_api"


class datasource_api_GetAvailableTagKeysRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'filters': ConjureFieldDefinition('filters', datasource_api_TagSearchFilters),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_TagName]),
            'page_size': ConjureFieldDefinition('pageSize', OptionalTypeWrapper[int])
        }

    __slots__: List[str] = ['_filters', '_next_page_token', '_page_size']

    def __init__(self, filters: "datasource_api_TagSearchFilters", next_page_token: Optional[str] = None, page_size: Optional[int] = None) -> None:
        self._filters = filters
        self._next_page_token = next_page_token
        self._page_size = page_size

    @builtins.property
    def filters(self) -> "datasource_api_TagSearchFilters":
        return self._filters

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token

    @builtins.property
    def page_size(self) -> Optional[int]:
        return self._page_size


datasource_api_GetAvailableTagKeysRequest.__name__ = "GetAvailableTagKeysRequest"
datasource_api_GetAvailableTagKeysRequest.__qualname__ = "GetAvailableTagKeysRequest"
datasource_api_GetAvailableTagKeysRequest.__module__ = "nominal_api.datasource_api"


class datasource_api_GetAvailableTagKeysResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[api_TagName]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_TagName])
        }

    __slots__: List[str] = ['_results', '_next_page_token']

    def __init__(self, results: List[str], next_page_token: Optional[str] = None) -> None:
        self._results = results
        self._next_page_token = next_page_token

    @builtins.property
    def results(self) -> List[str]:
        return self._results

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


datasource_api_GetAvailableTagKeysResponse.__name__ = "GetAvailableTagKeysResponse"
datasource_api_GetAvailableTagKeysResponse.__qualname__ = "GetAvailableTagKeysResponse"
datasource_api_GetAvailableTagKeysResponse.__module__ = "nominal_api.datasource_api"


class datasource_api_GetAvailableTagValuesRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'filters': ConjureFieldDefinition('filters', datasource_api_TagSearchFilters),
            'tag_name': ConjureFieldDefinition('tagName', api_TagName),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_TagValue]),
            'page_size': ConjureFieldDefinition('pageSize', OptionalTypeWrapper[int])
        }

    __slots__: List[str] = ['_filters', '_tag_name', '_next_page_token', '_page_size']

    def __init__(self, filters: "datasource_api_TagSearchFilters", tag_name: str, next_page_token: Optional[str] = None, page_size: Optional[int] = None) -> None:
        self._filters = filters
        self._tag_name = tag_name
        self._next_page_token = next_page_token
        self._page_size = page_size

    @builtins.property
    def filters(self) -> "datasource_api_TagSearchFilters":
        return self._filters

    @builtins.property
    def tag_name(self) -> str:
        return self._tag_name

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token

    @builtins.property
    def page_size(self) -> Optional[int]:
        """Defaults to 1000. Will throw if larger than 10000.
        """
        return self._page_size


datasource_api_GetAvailableTagValuesRequest.__name__ = "GetAvailableTagValuesRequest"
datasource_api_GetAvailableTagValuesRequest.__qualname__ = "GetAvailableTagValuesRequest"
datasource_api_GetAvailableTagValuesRequest.__module__ = "nominal_api.datasource_api"


class datasource_api_GetAvailableTagValuesResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[api_TagValue]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_TagValue])
        }

    __slots__: List[str] = ['_results', '_next_page_token']

    def __init__(self, results: List[str], next_page_token: Optional[str] = None) -> None:
        self._results = results
        self._next_page_token = next_page_token

    @builtins.property
    def results(self) -> List[str]:
        return self._results

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


datasource_api_GetAvailableTagValuesResponse.__name__ = "GetAvailableTagValuesResponse"
datasource_api_GetAvailableTagValuesResponse.__qualname__ = "GetAvailableTagValuesResponse"
datasource_api_GetAvailableTagValuesResponse.__module__ = "nominal_api.datasource_api"


class datasource_api_GetAvailableTagsForChannelRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'channel_with_tag_filters': ConjureFieldDefinition('channelWithTagFilters', datasource_api_ChannelWithTagFilters),
            'start_time': ConjureFieldDefinition('startTime', scout_run_api_UtcTimestamp),
            'end_time': ConjureFieldDefinition('endTime', scout_run_api_UtcTimestamp)
        }

    __slots__: List[str] = ['_channel_with_tag_filters', '_start_time', '_end_time']

    def __init__(self, channel_with_tag_filters: "datasource_api_ChannelWithTagFilters", end_time: "scout_run_api_UtcTimestamp", start_time: "scout_run_api_UtcTimestamp") -> None:
        self._channel_with_tag_filters = channel_with_tag_filters
        self._start_time = start_time
        self._end_time = end_time

    @builtins.property
    def channel_with_tag_filters(self) -> "datasource_api_ChannelWithTagFilters":
        return self._channel_with_tag_filters

    @builtins.property
    def start_time(self) -> "scout_run_api_UtcTimestamp":
        return self._start_time

    @builtins.property
    def end_time(self) -> "scout_run_api_UtcTimestamp":
        return self._end_time


datasource_api_GetAvailableTagsForChannelRequest.__name__ = "GetAvailableTagsForChannelRequest"
datasource_api_GetAvailableTagsForChannelRequest.__qualname__ = "GetAvailableTagsForChannelRequest"
datasource_api_GetAvailableTagsForChannelRequest.__module__ = "nominal_api.datasource_api"


class datasource_api_GetAvailableTagsForChannelResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'available_tags': ConjureFieldDefinition('availableTags', datasource_api_ChannelWithAvailableTags)
        }

    __slots__: List[str] = ['_available_tags']

    def __init__(self, available_tags: "datasource_api_ChannelWithAvailableTags") -> None:
        self._available_tags = available_tags

    @builtins.property
    def available_tags(self) -> "datasource_api_ChannelWithAvailableTags":
        return self._available_tags


datasource_api_GetAvailableTagsForChannelResponse.__name__ = "GetAvailableTagsForChannelResponse"
datasource_api_GetAvailableTagsForChannelResponse.__qualname__ = "GetAvailableTagsForChannelResponse"
datasource_api_GetAvailableTagsForChannelResponse.__module__ = "nominal_api.datasource_api"


class datasource_api_GetDataScopeBoundsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'data_source_rid': ConjureFieldDefinition('dataSourceRid', api_rids_DataSourceRid),
            'tags': ConjureFieldDefinition('tags', Dict[api_TagName, api_TagValue])
        }

    __slots__: List[str] = ['_data_source_rid', '_tags']

    def __init__(self, data_source_rid: str, tags: Dict[str, str]) -> None:
        self._data_source_rid = data_source_rid
        self._tags = tags

    @builtins.property
    def data_source_rid(self) -> str:
        return self._data_source_rid

    @builtins.property
    def tags(self) -> Dict[str, str]:
        return self._tags


datasource_api_GetDataScopeBoundsRequest.__name__ = "GetDataScopeBoundsRequest"
datasource_api_GetDataScopeBoundsRequest.__qualname__ = "GetDataScopeBoundsRequest"
datasource_api_GetDataScopeBoundsRequest.__module__ = "nominal_api.datasource_api"


class datasource_api_GetDataScopeBoundsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'end_time': ConjureFieldDefinition('endTime', OptionalTypeWrapper[api_Timestamp])
        }

    __slots__: List[str] = ['_end_time']

    def __init__(self, end_time: Optional["api_Timestamp"] = None) -> None:
        self._end_time = end_time

    @builtins.property
    def end_time(self) -> Optional["api_Timestamp"]:
        """If missing, the end bound is not known definitively. This can happen if the
data scope corresponds to an external database or its data was not updated in the last month.
        """
        return self._end_time


datasource_api_GetDataScopeBoundsResponse.__name__ = "GetDataScopeBoundsResponse"
datasource_api_GetDataScopeBoundsResponse.__qualname__ = "GetDataScopeBoundsResponse"
datasource_api_GetDataScopeBoundsResponse.__module__ = "nominal_api.datasource_api"


class datasource_api_GetTagValuesForDataSourceRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'tag_keys': ConjureFieldDefinition('tagKeys', OptionalTypeWrapper[List[api_TagName]]),
            'range': ConjureFieldDefinition('range', OptionalTypeWrapper[api_Range])
        }

    __slots__: List[str] = ['_tag_keys', '_range']

    def __init__(self, range: Optional["api_Range"] = None, tag_keys: Optional[List[str]] = None) -> None:
        self._tag_keys = tag_keys
        self._range = range

    @builtins.property
    def tag_keys(self) -> Optional[List[str]]:
        """If empty, returns all available tag keys.
        """
        return self._tag_keys

    @builtins.property
    def range(self) -> Optional["api_Range"]:
        """For Nominal data sources, a time range can be provided to filter tag values to those present within the 
months spanned by the range. If left empty, this defaults to the last month. For external data sources, 
the range must not be specified, as all tag values are returned.
        """
        return self._range


datasource_api_GetTagValuesForDataSourceRequest.__name__ = "GetTagValuesForDataSourceRequest"
datasource_api_GetTagValuesForDataSourceRequest.__qualname__ = "GetTagValuesForDataSourceRequest"
datasource_api_GetTagValuesForDataSourceRequest.__module__ = "nominal_api.datasource_api"


class datasource_api_IndexChannelPrefixTreeRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'data_source_rid': ConjureFieldDefinition('dataSourceRid', api_rids_DataSourceRid),
            'delimiter': ConjureFieldDefinition('delimiter', str)
        }

    __slots__: List[str] = ['_data_source_rid', '_delimiter']

    def __init__(self, data_source_rid: str, delimiter: str) -> None:
        self._data_source_rid = data_source_rid
        self._delimiter = delimiter

    @builtins.property
    def data_source_rid(self) -> str:
        return self._data_source_rid

    @builtins.property
    def delimiter(self) -> str:
        return self._delimiter


datasource_api_IndexChannelPrefixTreeRequest.__name__ = "IndexChannelPrefixTreeRequest"
datasource_api_IndexChannelPrefixTreeRequest.__qualname__ = "IndexChannelPrefixTreeRequest"
datasource_api_IndexChannelPrefixTreeRequest.__module__ = "nominal_api.datasource_api"


class datasource_api_SearchChannelsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'fuzzy_search_text': ConjureFieldDefinition('fuzzySearchText', str),
            'prefix': ConjureFieldDefinition('prefix', OptionalTypeWrapper[str]),
            'exact_match': ConjureFieldDefinition('exactMatch', List[str]),
            'data_sources': ConjureFieldDefinition('dataSources', List[api_rids_DataSourceRid]),
            'previously_selected_channels': ConjureFieldDefinition('previouslySelectedChannels', OptionalTypeWrapper[Dict[api_rids_DataSourceRid, List[api_Channel]]]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token]),
            'page_size': ConjureFieldDefinition('pageSize', OptionalTypeWrapper[int])
        }

    __slots__: List[str] = ['_fuzzy_search_text', '_prefix', '_exact_match', '_data_sources', '_previously_selected_channels', '_next_page_token', '_page_size']

    def __init__(self, data_sources: List[str], exact_match: List[str], fuzzy_search_text: str, next_page_token: Optional[str] = None, page_size: Optional[int] = None, prefix: Optional[str] = None, previously_selected_channels: Optional[Dict[str, List[str]]] = None) -> None:
        self._fuzzy_search_text = fuzzy_search_text
        self._prefix = prefix
        self._exact_match = exact_match
        self._data_sources = data_sources
        self._previously_selected_channels = previously_selected_channels
        self._next_page_token = next_page_token
        self._page_size = page_size

    @builtins.property
    def fuzzy_search_text(self) -> str:
        return self._fuzzy_search_text

    @builtins.property
    def prefix(self) -> Optional[str]:
        return self._prefix

    @builtins.property
    def exact_match(self) -> List[str]:
        """Will return only channels that contain all strings specified as exact matches (case insensitive).
        """
        return self._exact_match

    @builtins.property
    def data_sources(self) -> List[str]:
        return self._data_sources

    @builtins.property
    def previously_selected_channels(self) -> Optional[Dict[str, List[str]]]:
        return self._previously_selected_channels

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token

    @builtins.property
    def page_size(self) -> Optional[int]:
        """Defaults to 1000. Will throw if larger than 1000.
        """
        return self._page_size


datasource_api_SearchChannelsRequest.__name__ = "SearchChannelsRequest"
datasource_api_SearchChannelsRequest.__qualname__ = "SearchChannelsRequest"
datasource_api_SearchChannelsRequest.__module__ = "nominal_api.datasource_api"


class datasource_api_SearchChannelsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[datasource_api_ChannelMetadata]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_results', '_next_page_token']

    def __init__(self, results: List["datasource_api_ChannelMetadata"], next_page_token: Optional[str] = None) -> None:
        self._results = results
        self._next_page_token = next_page_token

    @builtins.property
    def results(self) -> List["datasource_api_ChannelMetadata"]:
        return self._results

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


datasource_api_SearchChannelsResponse.__name__ = "SearchChannelsResponse"
datasource_api_SearchChannelsResponse.__qualname__ = "SearchChannelsResponse"
datasource_api_SearchChannelsResponse.__module__ = "nominal_api.datasource_api"


class datasource_api_SearchFilteredChannelsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'substrings': ConjureFieldDefinition('substrings', OptionalTypeWrapper[List[str]]),
            'subsequences': ConjureFieldDefinition('subsequences', OptionalTypeWrapper[List[str]]),
            'data_sources': ConjureFieldDefinition('dataSources', List[api_rids_DataSourceRid]),
            'result_size': ConjureFieldDefinition('resultSize', OptionalTypeWrapper[int]),
            'tags': ConjureFieldDefinition('tags', Dict[api_rids_DataSourceRid, Dict[api_TagName, api_TagValue]]),
            'min_data_updated_time': ConjureFieldDefinition('minDataUpdatedTime', OptionalTypeWrapper[scout_run_api_UtcTimestamp]),
            'max_data_start_time': ConjureFieldDefinition('maxDataStartTime', OptionalTypeWrapper[scout_run_api_UtcTimestamp]),
            'previously_selected_channels': ConjureFieldDefinition('previouslySelectedChannels', OptionalTypeWrapper[Dict[api_rids_DataSourceRid, List[api_Channel]]]),
            'fuzzy_search_text': ConjureFieldDefinition('fuzzySearchText', OptionalTypeWrapper[str]),
            'exact_match': ConjureFieldDefinition('exactMatch', OptionalTypeWrapper[List[str]])
        }

    __slots__: List[str] = ['_substrings', '_subsequences', '_data_sources', '_result_size', '_tags', '_min_data_updated_time', '_max_data_start_time', '_previously_selected_channels', '_fuzzy_search_text', '_exact_match']

    def __init__(self, data_sources: List[str], tags: Dict[str, Dict[str, str]], exact_match: Optional[List[str]] = None, fuzzy_search_text: Optional[str] = None, max_data_start_time: Optional["scout_run_api_UtcTimestamp"] = None, min_data_updated_time: Optional["scout_run_api_UtcTimestamp"] = None, previously_selected_channels: Optional[Dict[str, List[str]]] = None, result_size: Optional[int] = None, subsequences: Optional[List[str]] = None, substrings: Optional[List[str]] = None) -> None:
        self._substrings = substrings
        self._subsequences = subsequences
        self._data_sources = data_sources
        self._result_size = result_size
        self._tags = tags
        self._min_data_updated_time = min_data_updated_time
        self._max_data_start_time = max_data_start_time
        self._previously_selected_channels = previously_selected_channels
        self._fuzzy_search_text = fuzzy_search_text
        self._exact_match = exact_match

    @builtins.property
    def substrings(self) -> Optional[List[str]]:
        """All of the strings in the set must appear exactly as substrings within the channel name.
        """
        return self._substrings

    @builtins.property
    def subsequences(self) -> Optional[List[str]]:
        """All of the characters in the string will appear in the same order (not necessarily adjacently)
within the channel name. Only supports one subsequence to match at this time.
        """
        return self._subsequences

    @builtins.property
    def data_sources(self) -> List[str]:
        return self._data_sources

    @builtins.property
    def result_size(self) -> Optional[int]:
        """Defaults to 200. Will throw if larger than 200.
        """
        return self._result_size

    @builtins.property
    def tags(self) -> Dict[str, Dict[str, str]]:
        """For each data source specified as a key, search will only return channels containing a superset of the 
tags specified for that given datasource. If a data source is present in the dataSources field but not
in this map, or if a data source points to an empty map of tags, it will be searched without tag filters.
        """
        return self._tags

    @builtins.property
    def min_data_updated_time(self) -> Optional["scout_run_api_UtcTimestamp"]:
        """If specified, search will only return channels that have had new data after the specified time.
        """
        return self._min_data_updated_time

    @builtins.property
    def max_data_start_time(self) -> Optional["scout_run_api_UtcTimestamp"]:
        """If specified, search will only return channels that have data before the specified time.
        """
        return self._max_data_start_time

    @builtins.property
    def previously_selected_channels(self) -> Optional[Dict[str, List[str]]]:
        return self._previously_selected_channels

    @builtins.property
    def fuzzy_search_text(self) -> Optional[str]:
        return self._fuzzy_search_text

    @builtins.property
    def exact_match(self) -> Optional[List[str]]:
        """Will return only channels that contain all strings specified as exact matches (case insensitive).
        """
        return self._exact_match


datasource_api_SearchFilteredChannelsRequest.__name__ = "SearchFilteredChannelsRequest"
datasource_api_SearchFilteredChannelsRequest.__qualname__ = "SearchFilteredChannelsRequest"
datasource_api_SearchFilteredChannelsRequest.__module__ = "nominal_api.datasource_api"


class datasource_api_SearchFilteredChannelsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[datasource_api_ChannelMetadata])
        }

    __slots__: List[str] = ['_results']

    def __init__(self, results: List["datasource_api_ChannelMetadata"]) -> None:
        self._results = results

    @builtins.property
    def results(self) -> List["datasource_api_ChannelMetadata"]:
        return self._results


datasource_api_SearchFilteredChannelsResponse.__name__ = "SearchFilteredChannelsResponse"
datasource_api_SearchFilteredChannelsResponse.__qualname__ = "SearchFilteredChannelsResponse"
datasource_api_SearchFilteredChannelsResponse.__module__ = "nominal_api.datasource_api"


class datasource_api_SearchHierarchicalChannelsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'parent': ConjureFieldDefinition('parent', List[str]),
            'data_sources': ConjureFieldDefinition('dataSources', List[api_rids_DataSourceRid]),
            'data_scope_filters': ConjureFieldDefinition('dataScopeFilters', OptionalTypeWrapper[datasource_api_DataScopeFilters])
        }

    __slots__: List[str] = ['_parent', '_data_sources', '_data_scope_filters']

    def __init__(self, data_sources: List[str], parent: List[str], data_scope_filters: Optional["datasource_api_DataScopeFilters"] = None) -> None:
        self._parent = parent
        self._data_sources = data_sources
        self._data_scope_filters = data_scope_filters

    @builtins.property
    def parent(self) -> List[str]:
        """The parent (represented as a list of parts) to search under. If empty, will return all top-level channels.
        """
        return self._parent

    @builtins.property
    def data_sources(self) -> List[str]:
        return self._data_sources

    @builtins.property
    def data_scope_filters(self) -> Optional["datasource_api_DataScopeFilters"]:
        """When dataScopeFilters are specified, the set of data sources must match the set of data sources in
DataScopeFilters#tags
        """
        return self._data_scope_filters


datasource_api_SearchHierarchicalChannelsRequest.__name__ = "SearchHierarchicalChannelsRequest"
datasource_api_SearchHierarchicalChannelsRequest.__qualname__ = "SearchHierarchicalChannelsRequest"
datasource_api_SearchHierarchicalChannelsRequest.__module__ = "nominal_api.datasource_api"


class datasource_api_SearchHierarchicalChannelsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[datasource_api_ChannelOrPrefix])
        }

    __slots__: List[str] = ['_results']

    def __init__(self, results: List["datasource_api_ChannelOrPrefix"]) -> None:
        self._results = results

    @builtins.property
    def results(self) -> List["datasource_api_ChannelOrPrefix"]:
        return self._results


datasource_api_SearchHierarchicalChannelsResponse.__name__ = "SearchHierarchicalChannelsResponse"
datasource_api_SearchHierarchicalChannelsResponse.__qualname__ = "SearchHierarchicalChannelsResponse"
datasource_api_SearchHierarchicalChannelsResponse.__module__ = "nominal_api.datasource_api"


class datasource_api_SeriesMetadataRidOrLogicalSeriesRid(ConjureUnionType):
    _series_archetype: Optional[str] = None
    _logical_series: Optional[str] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'series_archetype': ConjureFieldDefinition('seriesArchetype', api_SeriesMetadataRid),
            'logical_series': ConjureFieldDefinition('logicalSeries', api_LogicalSeriesRid)
        }

    def __init__(
            self,
            series_archetype: Optional[str] = None,
            logical_series: Optional[str] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (series_archetype is not None) + (logical_series is not None) != 1:
                raise ValueError('a union must contain a single member')

            if series_archetype is not None:
                self._series_archetype = series_archetype
                self._type = 'seriesArchetype'
            if logical_series is not None:
                self._logical_series = logical_series
                self._type = 'logicalSeries'

        elif type_of_union == 'seriesArchetype':
            if series_archetype is None:
                raise ValueError('a union value must not be None')
            self._series_archetype = series_archetype
            self._type = 'seriesArchetype'
        elif type_of_union == 'logicalSeries':
            if logical_series is None:
                raise ValueError('a union value must not be None')
            self._logical_series = logical_series
            self._type = 'logicalSeries'

    @builtins.property
    def series_archetype(self) -> Optional[str]:
        return self._series_archetype

    @builtins.property
    def logical_series(self) -> Optional[str]:
        return self._logical_series

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, datasource_api_SeriesMetadataRidOrLogicalSeriesRidVisitor):
            raise ValueError('{} is not an instance of datasource_api_SeriesMetadataRidOrLogicalSeriesRidVisitor'.format(visitor.__class__.__name__))
        if self._type == 'seriesArchetype' and self.series_archetype is not None:
            return visitor._series_archetype(self.series_archetype)
        if self._type == 'logicalSeries' and self.logical_series is not None:
            return visitor._logical_series(self.logical_series)


datasource_api_SeriesMetadataRidOrLogicalSeriesRid.__name__ = "SeriesMetadataRidOrLogicalSeriesRid"
datasource_api_SeriesMetadataRidOrLogicalSeriesRid.__qualname__ = "SeriesMetadataRidOrLogicalSeriesRid"
datasource_api_SeriesMetadataRidOrLogicalSeriesRid.__module__ = "nominal_api.datasource_api"


class datasource_api_SeriesMetadataRidOrLogicalSeriesRidVisitor:

    @abstractmethod
    def _series_archetype(self, series_archetype: str) -> Any:
        pass

    @abstractmethod
    def _logical_series(self, logical_series: str) -> Any:
        pass


datasource_api_SeriesMetadataRidOrLogicalSeriesRidVisitor.__name__ = "SeriesMetadataRidOrLogicalSeriesRidVisitor"
datasource_api_SeriesMetadataRidOrLogicalSeriesRidVisitor.__qualname__ = "SeriesMetadataRidOrLogicalSeriesRidVisitor"
datasource_api_SeriesMetadataRidOrLogicalSeriesRidVisitor.__module__ = "nominal_api.datasource_api"


class datasource_api_TagSearchFilters(ConjureBeanType):
    """Filters to use when searching for available tag names and values in paged endpoints.
All filters are optional.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'channel': ConjureFieldDefinition('channel', OptionalTypeWrapper[api_Channel]),
            'tag_filters': ConjureFieldDefinition('tagFilters', Dict[api_TagName, api_TagValue]),
            'range': ConjureFieldDefinition('range', OptionalTypeWrapper[api_Range])
        }

    __slots__: List[str] = ['_channel', '_tag_filters', '_range']

    def __init__(self, tag_filters: Dict[str, str], channel: Optional[str] = None, range: Optional["api_Range"] = None) -> None:
        self._channel = channel
        self._tag_filters = tag_filters
        self._range = range

    @builtins.property
    def channel(self) -> Optional[str]:
        """Optional, defaults to all channels in datasource.
        """
        return self._channel

    @builtins.property
    def tag_filters(self) -> Dict[str, str]:
        """Optional, defaults to no tag filter.
        """
        return self._tag_filters

    @builtins.property
    def range(self) -> Optional["api_Range"]:
        """Optional, defaults to no range filter.
        """
        return self._range


datasource_api_TagSearchFilters.__name__ = "TagSearchFilters"
datasource_api_TagSearchFilters.__qualname__ = "TagSearchFilters"
datasource_api_TagSearchFilters.__module__ = "nominal_api.datasource_api"


class datasource_logset_LogSetService(Service):
    """Log sets are a type of datasource which can be used to store log data.
    """

    def create(self, auth_header: str, request: "datasource_logset_api_CreateLogSetRequest") -> "datasource_logset_api_LogSetMetadata":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/data-source/log-set/v1/log-sets'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), datasource_logset_api_LogSetMetadata, self._return_none_for_unknown_union_types)

    def attach_logs_and_finalize(self, auth_header: str, log_set_rid: str, request: "datasource_logset_api_AttachLogsAndFinalizeRequest") -> "datasource_logset_api_LogSetMetadata":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'logSetRid': quote(str(_conjure_encoder.default(log_set_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/data-source/log-set/v1/log-set/{logSetRid}/attach-and-finalize'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), datasource_logset_api_LogSetMetadata, self._return_none_for_unknown_union_types)

    def get_log_set_metadata(self, auth_header: str, log_set_rid: str) -> "datasource_logset_api_LogSetMetadata":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'logSetRid': quote(str(_conjure_encoder.default(log_set_rid)), safe=''),
        }

        _json: Any = None

        _path = '/data-source/log-set/v1/log-set/{logSetRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), datasource_logset_api_LogSetMetadata, self._return_none_for_unknown_union_types)

    def batch_get_log_set_metadata(self, auth_header: str, request: List[str] = None) -> List["datasource_logset_api_LogSetMetadata"]:
        request = request if request is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/data-source/log-set/v1/log-set/multiple'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[datasource_logset_api_LogSetMetadata], self._return_none_for_unknown_union_types)

    def search_log_sets(self, auth_header: str, request: "datasource_logset_api_SearchLogSetsRequest") -> "datasource_logset_api_SearchLogSetsResponse":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/data-source/log-set/v1/log-sets/get'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), datasource_logset_api_SearchLogSetsResponse, self._return_none_for_unknown_union_types)

    def search_logs(self, auth_header: str, log_set_rid: str, request: "datasource_logset_api_SearchLogsRequest") -> "datasource_logset_api_SearchLogsResponse":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'logSetRid': quote(str(_conjure_encoder.default(log_set_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/data-source/log-set/v1/log-set/{logSetRid}/logs'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), datasource_logset_api_SearchLogsResponse, self._return_none_for_unknown_union_types)


datasource_logset_LogSetService.__name__ = "LogSetService"
datasource_logset_LogSetService.__qualname__ = "LogSetService"
datasource_logset_LogSetService.__module__ = "nominal_api.datasource_logset"


class datasource_logset_api_AttachLogsAndFinalizeRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'logs': ConjureFieldDefinition('logs', List[datasource_logset_api_Log])
        }

    __slots__: List[str] = ['_logs']

    def __init__(self, logs: List["datasource_logset_api_Log"]) -> None:
        self._logs = logs

    @builtins.property
    def logs(self) -> List["datasource_logset_api_Log"]:
        return self._logs


datasource_logset_api_AttachLogsAndFinalizeRequest.__name__ = "AttachLogsAndFinalizeRequest"
datasource_logset_api_AttachLogsAndFinalizeRequest.__qualname__ = "AttachLogsAndFinalizeRequest"
datasource_logset_api_AttachLogsAndFinalizeRequest.__module__ = "nominal_api.datasource_logset_api"


class datasource_logset_api_BasicLogBody(ConjureBeanType):
    """A largely unopinionated but very flexible format.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'properties': ConjureFieldDefinition('properties', Dict[str, str]),
            'message': ConjureFieldDefinition('message', str)
        }

    __slots__: List[str] = ['_properties', '_message']

    def __init__(self, message: str, properties: Dict[str, str]) -> None:
        self._properties = properties
        self._message = message

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def message(self) -> str:
        return self._message


datasource_logset_api_BasicLogBody.__name__ = "BasicLogBody"
datasource_logset_api_BasicLogBody.__qualname__ = "BasicLogBody"
datasource_logset_api_BasicLogBody.__module__ = "nominal_api.datasource_logset_api"


class datasource_logset_api_CreateLogSetRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', str),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'origin_metadata': ConjureFieldDefinition('originMetadata', Dict[str, str]),
            'timestamp_type': ConjureFieldDefinition('timestampType', datasource_TimestampType),
            'workspace': ConjureFieldDefinition('workspace', OptionalTypeWrapper[api_rids_WorkspaceRid])
        }

    __slots__: List[str] = ['_name', '_description', '_origin_metadata', '_timestamp_type', '_workspace']

    def __init__(self, name: str, origin_metadata: Dict[str, str], timestamp_type: "datasource_TimestampType", description: Optional[str] = None, workspace: Optional[str] = None) -> None:
        self._name = name
        self._description = description
        self._origin_metadata = origin_metadata
        self._timestamp_type = timestamp_type
        self._workspace = workspace

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def origin_metadata(self) -> Dict[str, str]:
        return self._origin_metadata

    @builtins.property
    def timestamp_type(self) -> "datasource_TimestampType":
        return self._timestamp_type

    @builtins.property
    def workspace(self) -> Optional[str]:
        """The workspace in which to create the logset. If not provided, the logset will be created in the default workspace for
the user's organization, if the default workspace for the organization is configured.
        """
        return self._workspace


datasource_logset_api_CreateLogSetRequest.__name__ = "CreateLogSetRequest"
datasource_logset_api_CreateLogSetRequest.__qualname__ = "CreateLogSetRequest"
datasource_logset_api_CreateLogSetRequest.__module__ = "nominal_api.datasource_logset_api"


class datasource_logset_api_Log(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'time': ConjureFieldDefinition('time', api_Timestamp),
            'body': ConjureFieldDefinition('body', datasource_logset_api_LogBody)
        }

    __slots__: List[str] = ['_time', '_body']

    def __init__(self, body: "datasource_logset_api_LogBody", time: "api_Timestamp") -> None:
        self._time = time
        self._body = body

    @builtins.property
    def time(self) -> "api_Timestamp":
        return self._time

    @builtins.property
    def body(self) -> "datasource_logset_api_LogBody":
        return self._body


datasource_logset_api_Log.__name__ = "Log"
datasource_logset_api_Log.__qualname__ = "Log"
datasource_logset_api_Log.__module__ = "nominal_api.datasource_logset_api"


class datasource_logset_api_LogBody(ConjureUnionType):
    _basic: Optional["datasource_logset_api_BasicLogBody"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'basic': ConjureFieldDefinition('basic', datasource_logset_api_BasicLogBody)
        }

    def __init__(
            self,
            basic: Optional["datasource_logset_api_BasicLogBody"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (basic is not None) != 1:
                raise ValueError('a union must contain a single member')

            if basic is not None:
                self._basic = basic
                self._type = 'basic'

        elif type_of_union == 'basic':
            if basic is None:
                raise ValueError('a union value must not be None')
            self._basic = basic
            self._type = 'basic'

    @builtins.property
    def basic(self) -> Optional["datasource_logset_api_BasicLogBody"]:
        return self._basic

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, datasource_logset_api_LogBodyVisitor):
            raise ValueError('{} is not an instance of datasource_logset_api_LogBodyVisitor'.format(visitor.__class__.__name__))
        if self._type == 'basic' and self.basic is not None:
            return visitor._basic(self.basic)


datasource_logset_api_LogBody.__name__ = "LogBody"
datasource_logset_api_LogBody.__qualname__ = "LogBody"
datasource_logset_api_LogBody.__module__ = "nominal_api.datasource_logset_api"


class datasource_logset_api_LogBodyVisitor:

    @abstractmethod
    def _basic(self, basic: "datasource_logset_api_BasicLogBody") -> Any:
        pass


datasource_logset_api_LogBodyVisitor.__name__ = "LogBodyVisitor"
datasource_logset_api_LogBodyVisitor.__qualname__ = "LogBodyVisitor"
datasource_logset_api_LogBodyVisitor.__module__ = "nominal_api.datasource_logset_api"


class datasource_logset_api_LogFormat(ConjureEnumType):

    V1 = 'V1'
    '''V1'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


datasource_logset_api_LogFormat.__name__ = "LogFormat"
datasource_logset_api_LogFormat.__qualname__ = "LogFormat"
datasource_logset_api_LogFormat.__module__ = "nominal_api.datasource_logset_api"


class datasource_logset_api_LogHandle(ConjureUnionType):
    _s3: Optional["datasource_logset_api_S3LogHandle"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            's3': ConjureFieldDefinition('s3', datasource_logset_api_S3LogHandle)
        }

    def __init__(
            self,
            s3: Optional["datasource_logset_api_S3LogHandle"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (s3 is not None) != 1:
                raise ValueError('a union must contain a single member')

            if s3 is not None:
                self._s3 = s3
                self._type = 's3'

        elif type_of_union == 's3':
            if s3 is None:
                raise ValueError('a union value must not be None')
            self._s3 = s3
            self._type = 's3'

    @builtins.property
    def s3(self) -> Optional["datasource_logset_api_S3LogHandle"]:
        return self._s3

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, datasource_logset_api_LogHandleVisitor):
            raise ValueError('{} is not an instance of datasource_logset_api_LogHandleVisitor'.format(visitor.__class__.__name__))
        if self._type == 's3' and self.s3 is not None:
            return visitor._s3(self.s3)


datasource_logset_api_LogHandle.__name__ = "LogHandle"
datasource_logset_api_LogHandle.__qualname__ = "LogHandle"
datasource_logset_api_LogHandle.__module__ = "nominal_api.datasource_logset_api"


class datasource_logset_api_LogHandleVisitor:

    @abstractmethod
    def _s3(self, s3: "datasource_logset_api_S3LogHandle") -> Any:
        pass


datasource_logset_api_LogHandleVisitor.__name__ = "LogHandleVisitor"
datasource_logset_api_LogHandleVisitor.__qualname__ = "LogHandleVisitor"
datasource_logset_api_LogHandleVisitor.__module__ = "nominal_api.datasource_logset_api"


class datasource_logset_api_LogSetMetadata(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', datasource_logset_api_LogSetRid),
            'created_by': ConjureFieldDefinition('createdBy', str),
            'name': ConjureFieldDefinition('name', str),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'origin_metadata': ConjureFieldDefinition('originMetadata', Dict[str, str]),
            'created_at': ConjureFieldDefinition('createdAt', str),
            'updated_at': ConjureFieldDefinition('updatedAt', str),
            'log_count': ConjureFieldDefinition('logCount', int),
            'timestamp_type': ConjureFieldDefinition('timestampType', datasource_TimestampType)
        }

    __slots__: List[str] = ['_rid', '_created_by', '_name', '_description', '_origin_metadata', '_created_at', '_updated_at', '_log_count', '_timestamp_type']

    def __init__(self, created_at: str, created_by: str, log_count: int, name: str, origin_metadata: Dict[str, str], rid: str, timestamp_type: "datasource_TimestampType", updated_at: str, description: Optional[str] = None) -> None:
        self._rid = rid
        self._created_by = created_by
        self._name = name
        self._description = description
        self._origin_metadata = origin_metadata
        self._created_at = created_at
        self._updated_at = updated_at
        self._log_count = log_count
        self._timestamp_type = timestamp_type

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def created_by(self) -> str:
        return self._created_by

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def origin_metadata(self) -> Dict[str, str]:
        return self._origin_metadata

    @builtins.property
    def created_at(self) -> str:
        return self._created_at

    @builtins.property
    def updated_at(self) -> str:
        return self._updated_at

    @builtins.property
    def log_count(self) -> int:
        return self._log_count

    @builtins.property
    def timestamp_type(self) -> "datasource_TimestampType":
        return self._timestamp_type


datasource_logset_api_LogSetMetadata.__name__ = "LogSetMetadata"
datasource_logset_api_LogSetMetadata.__qualname__ = "LogSetMetadata"
datasource_logset_api_LogSetMetadata.__module__ = "nominal_api.datasource_logset_api"


class datasource_logset_api_S3LogHandle(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'path': ConjureFieldDefinition('path', str),
            'format': ConjureFieldDefinition('format', datasource_logset_api_LogFormat)
        }

    __slots__: List[str] = ['_path', '_format']

    def __init__(self, format: "datasource_logset_api_LogFormat", path: str) -> None:
        self._path = path
        self._format = format

    @builtins.property
    def path(self) -> str:
        return self._path

    @builtins.property
    def format(self) -> "datasource_logset_api_LogFormat":
        return self._format


datasource_logset_api_S3LogHandle.__name__ = "S3LogHandle"
datasource_logset_api_S3LogHandle.__qualname__ = "S3LogHandle"
datasource_logset_api_S3LogHandle.__module__ = "nominal_api.datasource_logset_api"


class datasource_logset_api_SearchLogSetsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'token': ConjureFieldDefinition('token', OptionalTypeWrapper[api_Token]),
            'page_size': ConjureFieldDefinition('pageSize', OptionalTypeWrapper[int]),
            'workspaces': ConjureFieldDefinition('workspaces', List[api_rids_WorkspaceRid])
        }

    __slots__: List[str] = ['_token', '_page_size', '_workspaces']

    def __init__(self, workspaces: List[str], page_size: Optional[int] = None, token: Optional[str] = None) -> None:
        self._token = token
        self._page_size = page_size
        self._workspaces = workspaces

    @builtins.property
    def token(self) -> Optional[str]:
        return self._token

    @builtins.property
    def page_size(self) -> Optional[int]:
        """The maximum allowed page size is 1000. Defaults to the maximum if not supplied.
        """
        return self._page_size

    @builtins.property
    def workspaces(self) -> List[str]:
        """If supplied, will return only the log sets within the supplied workspaces. If empty
will return all connections for workspaces that the user is permitted to see.
        """
        return self._workspaces


datasource_logset_api_SearchLogSetsRequest.__name__ = "SearchLogSetsRequest"
datasource_logset_api_SearchLogSetsRequest.__qualname__ = "SearchLogSetsRequest"
datasource_logset_api_SearchLogSetsRequest.__module__ = "nominal_api.datasource_logset_api"


class datasource_logset_api_SearchLogSetsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'values': ConjureFieldDefinition('values', List[datasource_logset_api_LogSetMetadata]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_values', '_next_page_token']

    def __init__(self, values: List["datasource_logset_api_LogSetMetadata"], next_page_token: Optional[str] = None) -> None:
        self._values = values
        self._next_page_token = next_page_token

    @builtins.property
    def values(self) -> List["datasource_logset_api_LogSetMetadata"]:
        return self._values

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


datasource_logset_api_SearchLogSetsResponse.__name__ = "SearchLogSetsResponse"
datasource_logset_api_SearchLogSetsResponse.__qualname__ = "SearchLogSetsResponse"
datasource_logset_api_SearchLogSetsResponse.__module__ = "nominal_api.datasource_logset_api"


class datasource_logset_api_SearchLogsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'token': ConjureFieldDefinition('token', OptionalTypeWrapper[api_Token]),
            'page_size': ConjureFieldDefinition('pageSize', OptionalTypeWrapper[int])
        }

    __slots__: List[str] = ['_token', '_page_size']

    def __init__(self, page_size: Optional[int] = None, token: Optional[str] = None) -> None:
        self._token = token
        self._page_size = page_size

    @builtins.property
    def token(self) -> Optional[str]:
        return self._token

    @builtins.property
    def page_size(self) -> Optional[int]:
        """The maximum allowed page size is 10000. Defaults to the maximum if not supplied.
        """
        return self._page_size


datasource_logset_api_SearchLogsRequest.__name__ = "SearchLogsRequest"
datasource_logset_api_SearchLogsRequest.__qualname__ = "SearchLogsRequest"
datasource_logset_api_SearchLogsRequest.__module__ = "nominal_api.datasource_logset_api"


class datasource_logset_api_SearchLogsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'logs': ConjureFieldDefinition('logs', List[datasource_logset_api_Log]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_logs', '_next_page_token']

    def __init__(self, logs: List["datasource_logset_api_Log"], next_page_token: Optional[str] = None) -> None:
        self._logs = logs
        self._next_page_token = next_page_token

    @builtins.property
    def logs(self) -> List["datasource_logset_api_Log"]:
        return self._logs

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


datasource_logset_api_SearchLogsResponse.__name__ = "SearchLogsResponse"
datasource_logset_api_SearchLogsResponse.__qualname__ = "SearchLogsResponse"
datasource_logset_api_SearchLogsResponse.__module__ = "nominal_api.datasource_logset_api"


class datasource_pagination_api_PageRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'page_token': ConjureFieldDefinition('pageToken', OptionalTypeWrapper[datasource_pagination_api_PageToken]),
            'page_size': ConjureFieldDefinition('pageSize', int)
        }

    __slots__: List[str] = ['_page_token', '_page_size']

    def __init__(self, page_size: int, page_token: Optional[str] = None) -> None:
        self._page_token = page_token
        self._page_size = page_size

    @builtins.property
    def page_token(self) -> Optional[str]:
        return self._page_token

    @builtins.property
    def page_size(self) -> int:
        return self._page_size


datasource_pagination_api_PageRequest.__name__ = "PageRequest"
datasource_pagination_api_PageRequest.__qualname__ = "PageRequest"
datasource_pagination_api_PageRequest.__module__ = "nominal_api.datasource_pagination_api"


class datasource_pagination_api_PageResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[datasource_pagination_api_PageToken])
        }

    __slots__: List[str] = ['_next_page_token']

    def __init__(self, next_page_token: Optional[str] = None) -> None:
        self._next_page_token = next_page_token

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


datasource_pagination_api_PageResponse.__name__ = "PageResponse"
datasource_pagination_api_PageResponse.__qualname__ = "PageResponse"
datasource_pagination_api_PageResponse.__module__ = "nominal_api.datasource_pagination_api"


class event_ApiEventOrigin(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



event_ApiEventOrigin.__name__ = "ApiEventOrigin"
event_ApiEventOrigin.__qualname__ = "ApiEventOrigin"
event_ApiEventOrigin.__module__ = "nominal_api.event"


class event_ArchiveEvent(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'uuid': ConjureFieldDefinition('uuid', str)
        }

    __slots__: List[str] = ['_uuid']

    def __init__(self, uuid: str) -> None:
        self._uuid = uuid

    @builtins.property
    def uuid(self) -> str:
        return self._uuid


event_ArchiveEvent.__name__ = "ArchiveEvent"
event_ArchiveEvent.__qualname__ = "ArchiveEvent"
event_ArchiveEvent.__module__ = "nominal_api.event"


class event_BatchUpdateDispositionRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'requests': ConjureFieldDefinition('requests', List[event_UpdateDispositionRequest])
        }

    __slots__: List[str] = ['_requests']

    def __init__(self, requests: List["event_UpdateDispositionRequest"]) -> None:
        self._requests = requests

    @builtins.property
    def requests(self) -> List["event_UpdateDispositionRequest"]:
        return self._requests


event_BatchUpdateDispositionRequest.__name__ = "BatchUpdateDispositionRequest"
event_BatchUpdateDispositionRequest.__qualname__ = "BatchUpdateDispositionRequest"
event_BatchUpdateDispositionRequest.__module__ = "nominal_api.event"


class event_BatchUpdateDispositionResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'events': ConjureFieldDefinition('events', List[event_Event])
        }

    __slots__: List[str] = ['_events']

    def __init__(self, events: List["event_Event"]) -> None:
        self._events = events

    @builtins.property
    def events(self) -> List["event_Event"]:
        return self._events


event_BatchUpdateDispositionResponse.__name__ = "BatchUpdateDispositionResponse"
event_BatchUpdateDispositionResponse.__qualname__ = "BatchUpdateDispositionResponse"
event_BatchUpdateDispositionResponse.__module__ = "nominal_api.event"


class event_BatchUpdateEventRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'requests': ConjureFieldDefinition('requests', List[event_UpdateEventRequest])
        }

    __slots__: List[str] = ['_requests']

    def __init__(self, requests: List["event_UpdateEventRequest"]) -> None:
        self._requests = requests

    @builtins.property
    def requests(self) -> List["event_UpdateEventRequest"]:
        return self._requests


event_BatchUpdateEventRequest.__name__ = "BatchUpdateEventRequest"
event_BatchUpdateEventRequest.__qualname__ = "BatchUpdateEventRequest"
event_BatchUpdateEventRequest.__module__ = "nominal_api.event"


class event_BatchUpdateEventResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'events': ConjureFieldDefinition('events', List[event_Event])
        }

    __slots__: List[str] = ['_events']

    def __init__(self, events: List["event_Event"]) -> None:
        self._events = events

    @builtins.property
    def events(self) -> List["event_Event"]:
        return self._events


event_BatchUpdateEventResponse.__name__ = "BatchUpdateEventResponse"
event_BatchUpdateEventResponse.__qualname__ = "BatchUpdateEventResponse"
event_BatchUpdateEventResponse.__module__ = "nominal_api.event"


class event_CheckOriginMetadata(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'check_evaluation_rid': ConjureFieldDefinition('checkEvaluationRid', api_rids_AutomaticCheckEvaluationRid),
            'check_rid': ConjureFieldDefinition('checkRid', scout_rids_api_CheckRid),
            'check_lineage_rid': ConjureFieldDefinition('checkLineageRid', scout_rids_api_CheckLineageRid),
            'implementation_index': ConjureFieldDefinition('implementationIndex', OptionalTypeWrapper[int])
        }

    __slots__: List[str] = ['_check_evaluation_rid', '_check_rid', '_check_lineage_rid', '_implementation_index']

    def __init__(self, check_evaluation_rid: str, check_lineage_rid: str, check_rid: str, implementation_index: Optional[int] = None) -> None:
        self._check_evaluation_rid = check_evaluation_rid
        self._check_rid = check_rid
        self._check_lineage_rid = check_lineage_rid
        self._implementation_index = implementation_index

    @builtins.property
    def check_evaluation_rid(self) -> str:
        return self._check_evaluation_rid

    @builtins.property
    def check_rid(self) -> str:
        return self._check_rid

    @builtins.property
    def check_lineage_rid(self) -> str:
        return self._check_lineage_rid

    @builtins.property
    def implementation_index(self) -> Optional[int]:
        return self._implementation_index


event_CheckOriginMetadata.__name__ = "CheckOriginMetadata"
event_CheckOriginMetadata.__qualname__ = "CheckOriginMetadata"
event_CheckOriginMetadata.__module__ = "nominal_api.event"


class event_CreateEvent(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'asset_rids': ConjureFieldDefinition('assetRids', List[scout_rids_api_AssetRid]),
            'origins': ConjureFieldDefinition('origins', List[event_EventOrigin]),
            'timestamp': ConjureFieldDefinition('timestamp', api_Timestamp),
            'duration': ConjureFieldDefinition('duration', scout_run_api_Duration),
            'name': ConjureFieldDefinition('name', str),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'type': ConjureFieldDefinition('type', event_EventType),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'disposition': ConjureFieldDefinition('disposition', OptionalTypeWrapper[event_EventDisposition])
        }

    __slots__: List[str] = ['_asset_rids', '_origins', '_timestamp', '_duration', '_name', '_description', '_type', '_labels', '_properties', '_disposition']

    def __init__(self, asset_rids: List[str], duration: "scout_run_api_Duration", labels: List[str], name: str, origins: List["event_EventOrigin"], properties: Dict[str, str], timestamp: "api_Timestamp", type: "event_EventType", description: Optional[str] = None, disposition: Optional["event_EventDisposition"] = None) -> None:
        self._asset_rids = asset_rids
        self._origins = origins
        self._timestamp = timestamp
        self._duration = duration
        self._name = name
        self._description = description
        self._type = type
        self._labels = labels
        self._properties = properties
        self._disposition = disposition

    @builtins.property
    def asset_rids(self) -> List[str]:
        """Must contain at least one asset rid.
        """
        return self._asset_rids

    @builtins.property
    def origins(self) -> List["event_EventOrigin"]:
        """If empty, will default to set<EventOrigin.api>.
        """
        return self._origins

    @builtins.property
    def timestamp(self) -> "api_Timestamp":
        return self._timestamp

    @builtins.property
    def duration(self) -> "scout_run_api_Duration":
        return self._duration

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def description(self) -> Optional[str]:
        """If not provided, will default to an empty string.
        """
        return self._description

    @builtins.property
    def type(self) -> "event_EventType":
        return self._type

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def disposition(self) -> Optional["event_EventDisposition"]:
        return self._disposition


event_CreateEvent.__name__ = "CreateEvent"
event_CreateEvent.__qualname__ = "CreateEvent"
event_CreateEvent.__module__ = "nominal_api.event"


class event_DataReviewEventOrigin(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'data_review_rid': ConjureFieldDefinition('dataReviewRid', scout_rids_api_DataReviewRid),
            'check_metadata': ConjureFieldDefinition('checkMetadata', event_CheckOriginMetadata)
        }

    __slots__: List[str] = ['_data_review_rid', '_check_metadata']

    def __init__(self, check_metadata: "event_CheckOriginMetadata", data_review_rid: str) -> None:
        self._data_review_rid = data_review_rid
        self._check_metadata = check_metadata

    @builtins.property
    def data_review_rid(self) -> str:
        return self._data_review_rid

    @builtins.property
    def check_metadata(self) -> "event_CheckOriginMetadata":
        """Metadata about the check that created this event.
        """
        return self._check_metadata


event_DataReviewEventOrigin.__name__ = "DataReviewEventOrigin"
event_DataReviewEventOrigin.__qualname__ = "DataReviewEventOrigin"
event_DataReviewEventOrigin.__module__ = "nominal_api.event"


class event_Event(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'uuid': ConjureFieldDefinition('uuid', str),
            'rid': ConjureFieldDefinition('rid', api_rids_EventRid),
            'asset_rids': ConjureFieldDefinition('assetRids', List[scout_rids_api_AssetRid]),
            'origins': ConjureFieldDefinition('origins', List[event_EventOrigin]),
            'timestamp': ConjureFieldDefinition('timestamp', api_Timestamp),
            'duration': ConjureFieldDefinition('duration', scout_run_api_Duration),
            'name': ConjureFieldDefinition('name', str),
            'description': ConjureFieldDefinition('description', str),
            'type': ConjureFieldDefinition('type', event_EventType),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'is_archived': ConjureFieldDefinition('isArchived', bool),
            'created_by': ConjureFieldDefinition('createdBy', OptionalTypeWrapper[scout_rids_api_UserRid]),
            'disposition': ConjureFieldDefinition('disposition', OptionalTypeWrapper[event_EventDisposition])
        }

    __slots__: List[str] = ['_uuid', '_rid', '_asset_rids', '_origins', '_timestamp', '_duration', '_name', '_description', '_type', '_labels', '_properties', '_is_archived', '_created_by', '_disposition']

    def __init__(self, asset_rids: List[str], description: str, duration: "scout_run_api_Duration", is_archived: bool, labels: List[str], name: str, origins: List["event_EventOrigin"], properties: Dict[str, str], rid: str, timestamp: "api_Timestamp", type: "event_EventType", uuid: str, created_by: Optional[str] = None, disposition: Optional["event_EventDisposition"] = None) -> None:
        self._uuid = uuid
        self._rid = rid
        self._asset_rids = asset_rids
        self._origins = origins
        self._timestamp = timestamp
        self._duration = duration
        self._name = name
        self._description = description
        self._type = type
        self._labels = labels
        self._properties = properties
        self._is_archived = is_archived
        self._created_by = created_by
        self._disposition = disposition

    @builtins.property
    def uuid(self) -> str:
        return self._uuid

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def asset_rids(self) -> List[str]:
        """A set of asset rids associated with the event.
        """
        return self._asset_rids

    @builtins.property
    def origins(self) -> List["event_EventOrigin"]:
        """A set of origins associated with the event.
        """
        return self._origins

    @builtins.property
    def timestamp(self) -> "api_Timestamp":
        return self._timestamp

    @builtins.property
    def duration(self) -> "scout_run_api_Duration":
        return self._duration

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def description(self) -> str:
        return self._description

    @builtins.property
    def type(self) -> "event_EventType":
        return self._type

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def is_archived(self) -> bool:
        return self._is_archived

    @builtins.property
    def created_by(self) -> Optional[str]:
        """The user who created the event.
This field may be missing for legacy events.
        """
        return self._created_by

    @builtins.property
    def disposition(self) -> Optional["event_EventDisposition"]:
        return self._disposition


event_Event.__name__ = "Event"
event_Event.__qualname__ = "Event"
event_Event.__module__ = "nominal_api.event"


class event_EventDisposition(ConjureBeanType):
    """Describes the review status for an event.
This is used to track the disposition status of an event.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'priority': ConjureFieldDefinition('priority', scout_api_Priority),
            'state': ConjureFieldDefinition('state', scout_api_DispositionState),
            'assignees': ConjureFieldDefinition('assignees', List[scout_rids_api_UserRid])
        }

    __slots__: List[str] = ['_priority', '_state', '_assignees']

    def __init__(self, assignees: List[str], priority: "scout_api_Priority", state: "scout_api_DispositionState") -> None:
        self._priority = priority
        self._state = state
        self._assignees = assignees

    @builtins.property
    def priority(self) -> "scout_api_Priority":
        return self._priority

    @builtins.property
    def state(self) -> "scout_api_DispositionState":
        return self._state

    @builtins.property
    def assignees(self) -> List[str]:
        return self._assignees


event_EventDisposition.__name__ = "EventDisposition"
event_EventDisposition.__qualname__ = "EventDisposition"
event_EventDisposition.__module__ = "nominal_api.event"


class event_EventDispositionStatus(ConjureEnumType):

    PENDING_REVIEW = 'PENDING_REVIEW'
    '''PENDING_REVIEW'''
    CLOSED_IGNORED = 'CLOSED_IGNORED'
    '''CLOSED_IGNORED'''
    CLOSED_REQUIRES_FURTHER_ACTION = 'CLOSED_REQUIRES_FURTHER_ACTION'
    '''CLOSED_REQUIRES_FURTHER_ACTION'''
    NO_DISPOSITION = 'NO_DISPOSITION'
    '''NO_DISPOSITION'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


event_EventDispositionStatus.__name__ = "EventDispositionStatus"
event_EventDispositionStatus.__qualname__ = "EventDispositionStatus"
event_EventDispositionStatus.__module__ = "nominal_api.event"


class event_EventOrigin(ConjureUnionType):
    """Describes where an event came from.
    """
    _workbook: Optional["event_WorkbookEventOrigin"] = None
    _template: Optional["event_TemplateEventOrigin"] = None
    _api: Optional["event_ApiEventOrigin"] = None
    _data_review: Optional["event_DataReviewEventOrigin"] = None
    _procedure: Optional["event_ProcedureEventOrigin"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'workbook': ConjureFieldDefinition('workbook', event_WorkbookEventOrigin),
            'template': ConjureFieldDefinition('template', event_TemplateEventOrigin),
            'api': ConjureFieldDefinition('api', event_ApiEventOrigin),
            'data_review': ConjureFieldDefinition('dataReview', event_DataReviewEventOrigin),
            'procedure': ConjureFieldDefinition('procedure', event_ProcedureEventOrigin)
        }

    def __init__(
            self,
            workbook: Optional["event_WorkbookEventOrigin"] = None,
            template: Optional["event_TemplateEventOrigin"] = None,
            api: Optional["event_ApiEventOrigin"] = None,
            data_review: Optional["event_DataReviewEventOrigin"] = None,
            procedure: Optional["event_ProcedureEventOrigin"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (workbook is not None) + (template is not None) + (api is not None) + (data_review is not None) + (procedure is not None) != 1:
                raise ValueError('a union must contain a single member')

            if workbook is not None:
                self._workbook = workbook
                self._type = 'workbook'
            if template is not None:
                self._template = template
                self._type = 'template'
            if api is not None:
                self._api = api
                self._type = 'api'
            if data_review is not None:
                self._data_review = data_review
                self._type = 'dataReview'
            if procedure is not None:
                self._procedure = procedure
                self._type = 'procedure'

        elif type_of_union == 'workbook':
            if workbook is None:
                raise ValueError('a union value must not be None')
            self._workbook = workbook
            self._type = 'workbook'
        elif type_of_union == 'template':
            if template is None:
                raise ValueError('a union value must not be None')
            self._template = template
            self._type = 'template'
        elif type_of_union == 'api':
            if api is None:
                raise ValueError('a union value must not be None')
            self._api = api
            self._type = 'api'
        elif type_of_union == 'dataReview':
            if data_review is None:
                raise ValueError('a union value must not be None')
            self._data_review = data_review
            self._type = 'dataReview'
        elif type_of_union == 'procedure':
            if procedure is None:
                raise ValueError('a union value must not be None')
            self._procedure = procedure
            self._type = 'procedure'

    @builtins.property
    def workbook(self) -> Optional["event_WorkbookEventOrigin"]:
        """This event was created in this workbook
        """
        return self._workbook

    @builtins.property
    def template(self) -> Optional["event_TemplateEventOrigin"]:
        """This event was created in this template
        """
        return self._template

    @builtins.property
    def api(self) -> Optional["event_ApiEventOrigin"]:
        """This event was created programmatically via the API
        """
        return self._api

    @builtins.property
    def data_review(self) -> Optional["event_DataReviewEventOrigin"]:
        """This event was created automatically from a checklist execution.
        """
        return self._data_review

    @builtins.property
    def procedure(self) -> Optional["event_ProcedureEventOrigin"]:
        """This event was created automatically from a procedure execution.
        """
        return self._procedure

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, event_EventOriginVisitor):
            raise ValueError('{} is not an instance of event_EventOriginVisitor'.format(visitor.__class__.__name__))
        if self._type == 'workbook' and self.workbook is not None:
            return visitor._workbook(self.workbook)
        if self._type == 'template' and self.template is not None:
            return visitor._template(self.template)
        if self._type == 'api' and self.api is not None:
            return visitor._api(self.api)
        if self._type == 'dataReview' and self.data_review is not None:
            return visitor._data_review(self.data_review)
        if self._type == 'procedure' and self.procedure is not None:
            return visitor._procedure(self.procedure)


event_EventOrigin.__name__ = "EventOrigin"
event_EventOrigin.__qualname__ = "EventOrigin"
event_EventOrigin.__module__ = "nominal_api.event"


class event_EventOriginVisitor:

    @abstractmethod
    def _workbook(self, workbook: "event_WorkbookEventOrigin") -> Any:
        pass

    @abstractmethod
    def _template(self, template: "event_TemplateEventOrigin") -> Any:
        pass

    @abstractmethod
    def _api(self, api: "event_ApiEventOrigin") -> Any:
        pass

    @abstractmethod
    def _data_review(self, data_review: "event_DataReviewEventOrigin") -> Any:
        pass

    @abstractmethod
    def _procedure(self, procedure: "event_ProcedureEventOrigin") -> Any:
        pass


event_EventOriginVisitor.__name__ = "EventOriginVisitor"
event_EventOriginVisitor.__qualname__ = "EventOriginVisitor"
event_EventOriginVisitor.__module__ = "nominal_api.event"


class event_EventService(Service):
    """An Event is an annotated moment or time range.
The Event Service is responsible for creating and retrieving events for a particular data source.
    """

    def create_event(self, auth_header: str, request: "event_CreateEvent") -> "event_Event":
        """Creates an event.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/event/v1/events'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), event_Event, self._return_none_for_unknown_union_types)

    def get_events(self, auth_header: str, request: "event_GetEvents") -> List["event_Event"]:
        """Gets a set of events by UUIDs
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/event/v1/get-events'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[event_Event], self._return_none_for_unknown_union_types)

    def batch_get_events(self, auth_header: str, request: List[str] = None) -> List["event_Event"]:
        """Gets a set of events by RID.
        """
        request = request if request is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/event/v1/events/batch-get'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[event_Event], self._return_none_for_unknown_union_types)

    def update_event(self, auth_header: str, request: "event_UpdateEvent") -> "event_Event":
        """Updates the fields of an event. Empty fields are left unchanged.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/event/v1/update-event'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), event_Event, self._return_none_for_unknown_union_types)

    def batch_update_event(self, auth_header: str, request: "event_BatchUpdateEventRequest") -> "event_BatchUpdateEventResponse":
        """Updates the fields of an event specified by each request in the batch.
Empty fields in the UpdateEventRequest are left unchanged.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/event/v1/events/batch-update'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), event_BatchUpdateEventResponse, self._return_none_for_unknown_union_types)

    def batch_update_disposition(self, auth_header: str, request: "event_BatchUpdateDispositionRequest") -> "event_BatchUpdateDispositionResponse":
        """Updates the disposition of an event.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/event/v1/update-disposition'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), event_BatchUpdateDispositionResponse, self._return_none_for_unknown_union_types)

    def archive_event(self, auth_header: str, request: "event_ArchiveEvent") -> None:
        """Archives an event
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/event/v1/archive-event'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def batch_archive_event(self, auth_header: str, request: List[str] = None) -> None:
        """Archives a set of events
        """
        request = request if request is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/event/v1/batch-archive-events'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def batch_unarchive_event(self, auth_header: str, request: List[str] = None) -> None:
        """Unarchives a set of events
        """
        request = request if request is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/event/v1/batch-unarchive-events'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def search_events(self, auth_header: str, request: "event_SearchEventsRequest") -> "event_SearchEventsResponse":
        """Searches for events that match the given filters.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/event/v1/search-events'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), event_SearchEventsResponse, self._return_none_for_unknown_union_types)

    def get_events_histogram(self, auth_header: str, request: "event_EventsHistogramRequest") -> "event_EventsHistogramResponse":
        """Gets a histogram of events that match the given filters.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/event/v1/histogram'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), event_EventsHistogramResponse, self._return_none_for_unknown_union_types)

    def list_properties_and_labels(self, auth_header: str, request: "event_ListPropertiesAndLabelsRequest") -> "scout_metadata_ListPropertiesAndLabelsResponse":
        """Lists the properties and labels of all events in the provided workspaces.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/event/v1/list-properties-labels'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_metadata_ListPropertiesAndLabelsResponse, self._return_none_for_unknown_union_types)


event_EventService.__name__ = "EventService"
event_EventService.__qualname__ = "EventService"
event_EventService.__module__ = "nominal_api.event"


class event_EventTimeFilter(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'timestamp': ConjureFieldDefinition('timestamp', api_Timestamp),
            'timestamp_condition': ConjureFieldDefinition('timestampCondition', event_EventTimeFilterCondition)
        }

    __slots__: List[str] = ['_timestamp', '_timestamp_condition']

    def __init__(self, timestamp: "api_Timestamp", timestamp_condition: "event_EventTimeFilterCondition") -> None:
        self._timestamp = timestamp
        self._timestamp_condition = timestamp_condition

    @builtins.property
    def timestamp(self) -> "api_Timestamp":
        return self._timestamp

    @builtins.property
    def timestamp_condition(self) -> "event_EventTimeFilterCondition":
        return self._timestamp_condition


event_EventTimeFilter.__name__ = "EventTimeFilter"
event_EventTimeFilter.__qualname__ = "EventTimeFilter"
event_EventTimeFilter.__module__ = "nominal_api.event"


class event_EventTimeFilterCondition(ConjureEnumType):

    START_TIME_BEFORE_INCLUSIVE = 'START_TIME_BEFORE_INCLUSIVE'
    '''START_TIME_BEFORE_INCLUSIVE'''
    START_TIME_BEFORE_EXCLUSIVE = 'START_TIME_BEFORE_EXCLUSIVE'
    '''START_TIME_BEFORE_EXCLUSIVE'''
    START_TIME_AFTER_INCLUSIVE = 'START_TIME_AFTER_INCLUSIVE'
    '''START_TIME_AFTER_INCLUSIVE'''
    START_TIME_AFTER_EXCLUSIVE = 'START_TIME_AFTER_EXCLUSIVE'
    '''START_TIME_AFTER_EXCLUSIVE'''
    END_TIME_BEFORE_INCLUSIVE = 'END_TIME_BEFORE_INCLUSIVE'
    '''END_TIME_BEFORE_INCLUSIVE'''
    END_TIME_BEFORE_EXCLUSIVE = 'END_TIME_BEFORE_EXCLUSIVE'
    '''END_TIME_BEFORE_EXCLUSIVE'''
    END_TIME_AFTER_INCLUSIVE = 'END_TIME_AFTER_INCLUSIVE'
    '''END_TIME_AFTER_INCLUSIVE'''
    END_TIME_AFTER_EXCLUSIVE = 'END_TIME_AFTER_EXCLUSIVE'
    '''END_TIME_AFTER_EXCLUSIVE'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


event_EventTimeFilterCondition.__name__ = "EventTimeFilterCondition"
event_EventTimeFilterCondition.__qualname__ = "EventTimeFilterCondition"
event_EventTimeFilterCondition.__module__ = "nominal_api.event"


class event_EventType(ConjureEnumType):

    INFO = 'INFO'
    '''INFO'''
    FLAG = 'FLAG'
    '''FLAG'''
    ERROR = 'ERROR'
    '''ERROR'''
    SUCCESS = 'SUCCESS'
    '''SUCCESS'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


event_EventType.__name__ = "EventType"
event_EventType.__qualname__ = "EventType"
event_EventType.__module__ = "nominal_api.event"


class event_EventsHistogramBucket(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'start_inclusive': ConjureFieldDefinition('startInclusive', api_Timestamp),
            'end_exclusive': ConjureFieldDefinition('endExclusive', api_Timestamp),
            'count': ConjureFieldDefinition('count', int)
        }

    __slots__: List[str] = ['_start_inclusive', '_end_exclusive', '_count']

    def __init__(self, count: int, end_exclusive: "api_Timestamp", start_inclusive: "api_Timestamp") -> None:
        self._start_inclusive = start_inclusive
        self._end_exclusive = end_exclusive
        self._count = count

    @builtins.property
    def start_inclusive(self) -> "api_Timestamp":
        return self._start_inclusive

    @builtins.property
    def end_exclusive(self) -> "api_Timestamp":
        return self._end_exclusive

    @builtins.property
    def count(self) -> int:
        return self._count


event_EventsHistogramBucket.__name__ = "EventsHistogramBucket"
event_EventsHistogramBucket.__qualname__ = "EventsHistogramBucket"
event_EventsHistogramBucket.__module__ = "nominal_api.event"


class event_EventsHistogramRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'start_inclusive': ConjureFieldDefinition('startInclusive', api_Timestamp),
            'end_exclusive': ConjureFieldDefinition('endExclusive', api_Timestamp),
            'filter_query': ConjureFieldDefinition('filterQuery', OptionalTypeWrapper[event_HistogramFilterQuery]),
            'archived_statuses': ConjureFieldDefinition('archivedStatuses', OptionalTypeWrapper[List[api_ArchivedStatus]]),
            'num_bins': ConjureFieldDefinition('numBins', OptionalTypeWrapper[int]),
            'event_limit': ConjureFieldDefinition('eventLimit', OptionalTypeWrapper[int])
        }

    __slots__: List[str] = ['_start_inclusive', '_end_exclusive', '_filter_query', '_archived_statuses', '_num_bins', '_event_limit']

    def __init__(self, end_exclusive: "api_Timestamp", start_inclusive: "api_Timestamp", archived_statuses: Optional[List["api_ArchivedStatus"]] = None, event_limit: Optional[int] = None, filter_query: Optional["event_HistogramFilterQuery"] = None, num_bins: Optional[int] = None) -> None:
        self._start_inclusive = start_inclusive
        self._end_exclusive = end_exclusive
        self._filter_query = filter_query
        self._archived_statuses = archived_statuses
        self._num_bins = num_bins
        self._event_limit = event_limit

    @builtins.property
    def start_inclusive(self) -> "api_Timestamp":
        return self._start_inclusive

    @builtins.property
    def end_exclusive(self) -> "api_Timestamp":
        return self._end_exclusive

    @builtins.property
    def filter_query(self) -> Optional["event_HistogramFilterQuery"]:
        """The query to filter the events to be included in the histogram.
        """
        return self._filter_query

    @builtins.property
    def archived_statuses(self) -> Optional[List["api_ArchivedStatus"]]:
        """Filters search on check alerts based on the archived statuses provided. 
Default is NOT_ARCHIVED only if none are provided.
        """
        return self._archived_statuses

    @builtins.property
    def num_bins(self) -> Optional[int]:
        """Defaults to 100. Throws if larger than 1_000.
The resulting histogram may have fewer bins than requested if the requested time window is too small.
        """
        return self._num_bins

    @builtins.property
    def event_limit(self) -> Optional[int]:
        """Limits the number of events to be included in the histogram.
Defaults to 1_000. Throws if larger than 10_000.
        """
        return self._event_limit


event_EventsHistogramRequest.__name__ = "EventsHistogramRequest"
event_EventsHistogramRequest.__qualname__ = "EventsHistogramRequest"
event_EventsHistogramRequest.__module__ = "nominal_api.event"


class event_EventsHistogramResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'buckets': ConjureFieldDefinition('buckets', List[event_EventsHistogramBucket])
        }

    __slots__: List[str] = ['_buckets']

    def __init__(self, buckets: List["event_EventsHistogramBucket"]) -> None:
        self._buckets = buckets

    @builtins.property
    def buckets(self) -> List["event_EventsHistogramBucket"]:
        return self._buckets


event_EventsHistogramResponse.__name__ = "EventsHistogramResponse"
event_EventsHistogramResponse.__qualname__ = "EventsHistogramResponse"
event_EventsHistogramResponse.__module__ = "nominal_api.event"


class event_GetEvents(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'uuids': ConjureFieldDefinition('uuids', List[str])
        }

    __slots__: List[str] = ['_uuids']

    def __init__(self, uuids: List[str]) -> None:
        self._uuids = uuids

    @builtins.property
    def uuids(self) -> List[str]:
        return self._uuids


event_GetEvents.__name__ = "GetEvents"
event_GetEvents.__qualname__ = "GetEvents"
event_GetEvents.__module__ = "nominal_api.event"


class event_HistogramFilterQuery(ConjureUnionType):
    _search_text: Optional[str] = None
    _asset: Optional[str] = None
    _template: Optional[str] = None
    _workbook: Optional[str] = None
    _data_review: Optional[str] = None
    _origin_type: Optional["event_SearchEventOriginType"] = None
    _data_review_check: Optional[str] = None
    _disposition_status: Optional["event_EventDispositionStatus"] = None
    _priority: Optional["scout_api_Priority"] = None
    _assignee: Optional[str] = None
    _event_type: Optional["event_EventType"] = None
    _created_by: Optional[str] = None
    _label: Optional[str] = None
    _property: Optional["api_Property"] = None
    _and_: Optional[List["event_HistogramFilterQuery"]] = None
    _or_: Optional[List["event_HistogramFilterQuery"]] = None
    _not_: Optional["event_HistogramFilterQuery"] = None
    _workspace: Optional[str] = None
    _procedure: Optional[str] = None
    _procedure_execution: Optional[str] = None
    _step_id: Optional[str] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'search_text': ConjureFieldDefinition('searchText', str),
            'asset': ConjureFieldDefinition('asset', scout_rids_api_AssetRid),
            'template': ConjureFieldDefinition('template', scout_rids_api_TemplateRid),
            'workbook': ConjureFieldDefinition('workbook', scout_rids_api_NotebookRid),
            'data_review': ConjureFieldDefinition('dataReview', scout_rids_api_DataReviewRid),
            'origin_type': ConjureFieldDefinition('originType', event_SearchEventOriginType),
            'data_review_check': ConjureFieldDefinition('dataReviewCheck', scout_rids_api_CheckRid),
            'disposition_status': ConjureFieldDefinition('dispositionStatus', event_EventDispositionStatus),
            'priority': ConjureFieldDefinition('priority', scout_api_Priority),
            'assignee': ConjureFieldDefinition('assignee', scout_rids_api_UserRid),
            'event_type': ConjureFieldDefinition('eventType', event_EventType),
            'created_by': ConjureFieldDefinition('createdBy', scout_rids_api_UserRid),
            'label': ConjureFieldDefinition('label', api_Label),
            'property': ConjureFieldDefinition('property', api_Property),
            'and_': ConjureFieldDefinition('and', List[event_HistogramFilterQuery]),
            'or_': ConjureFieldDefinition('or', List[event_HistogramFilterQuery]),
            'not_': ConjureFieldDefinition('not', event_HistogramFilterQuery),
            'workspace': ConjureFieldDefinition('workspace', api_rids_WorkspaceRid),
            'procedure': ConjureFieldDefinition('procedure', api_rids_ProcedureRid),
            'procedure_execution': ConjureFieldDefinition('procedureExecution', api_rids_ProcedureExecutionRid),
            'step_id': ConjureFieldDefinition('stepId', str)
        }

    def __init__(
            self,
            search_text: Optional[str] = None,
            asset: Optional[str] = None,
            template: Optional[str] = None,
            workbook: Optional[str] = None,
            data_review: Optional[str] = None,
            origin_type: Optional["event_SearchEventOriginType"] = None,
            data_review_check: Optional[str] = None,
            disposition_status: Optional["event_EventDispositionStatus"] = None,
            priority: Optional["scout_api_Priority"] = None,
            assignee: Optional[str] = None,
            event_type: Optional["event_EventType"] = None,
            created_by: Optional[str] = None,
            label: Optional[str] = None,
            property: Optional["api_Property"] = None,
            and_: Optional[List["event_HistogramFilterQuery"]] = None,
            or_: Optional[List["event_HistogramFilterQuery"]] = None,
            not_: Optional["event_HistogramFilterQuery"] = None,
            workspace: Optional[str] = None,
            procedure: Optional[str] = None,
            procedure_execution: Optional[str] = None,
            step_id: Optional[str] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (search_text is not None) + (asset is not None) + (template is not None) + (workbook is not None) + (data_review is not None) + (origin_type is not None) + (data_review_check is not None) + (disposition_status is not None) + (priority is not None) + (assignee is not None) + (event_type is not None) + (created_by is not None) + (label is not None) + (property is not None) + (and_ is not None) + (or_ is not None) + (not_ is not None) + (workspace is not None) + (procedure is not None) + (procedure_execution is not None) + (step_id is not None) != 1:
                raise ValueError('a union must contain a single member')

            if search_text is not None:
                self._search_text = search_text
                self._type = 'searchText'
            if asset is not None:
                self._asset = asset
                self._type = 'asset'
            if template is not None:
                self._template = template
                self._type = 'template'
            if workbook is not None:
                self._workbook = workbook
                self._type = 'workbook'
            if data_review is not None:
                self._data_review = data_review
                self._type = 'dataReview'
            if origin_type is not None:
                self._origin_type = origin_type
                self._type = 'originType'
            if data_review_check is not None:
                self._data_review_check = data_review_check
                self._type = 'dataReviewCheck'
            if disposition_status is not None:
                self._disposition_status = disposition_status
                self._type = 'dispositionStatus'
            if priority is not None:
                self._priority = priority
                self._type = 'priority'
            if assignee is not None:
                self._assignee = assignee
                self._type = 'assignee'
            if event_type is not None:
                self._event_type = event_type
                self._type = 'eventType'
            if created_by is not None:
                self._created_by = created_by
                self._type = 'createdBy'
            if label is not None:
                self._label = label
                self._type = 'label'
            if property is not None:
                self._property = property
                self._type = 'property'
            if and_ is not None:
                self._and_ = and_
                self._type = 'and'
            if or_ is not None:
                self._or_ = or_
                self._type = 'or'
            if not_ is not None:
                self._not_ = not_
                self._type = 'not'
            if workspace is not None:
                self._workspace = workspace
                self._type = 'workspace'
            if procedure is not None:
                self._procedure = procedure
                self._type = 'procedure'
            if procedure_execution is not None:
                self._procedure_execution = procedure_execution
                self._type = 'procedureExecution'
            if step_id is not None:
                self._step_id = step_id
                self._type = 'stepId'

        elif type_of_union == 'searchText':
            if search_text is None:
                raise ValueError('a union value must not be None')
            self._search_text = search_text
            self._type = 'searchText'
        elif type_of_union == 'asset':
            if asset is None:
                raise ValueError('a union value must not be None')
            self._asset = asset
            self._type = 'asset'
        elif type_of_union == 'template':
            if template is None:
                raise ValueError('a union value must not be None')
            self._template = template
            self._type = 'template'
        elif type_of_union == 'workbook':
            if workbook is None:
                raise ValueError('a union value must not be None')
            self._workbook = workbook
            self._type = 'workbook'
        elif type_of_union == 'dataReview':
            if data_review is None:
                raise ValueError('a union value must not be None')
            self._data_review = data_review
            self._type = 'dataReview'
        elif type_of_union == 'originType':
            if origin_type is None:
                raise ValueError('a union value must not be None')
            self._origin_type = origin_type
            self._type = 'originType'
        elif type_of_union == 'dataReviewCheck':
            if data_review_check is None:
                raise ValueError('a union value must not be None')
            self._data_review_check = data_review_check
            self._type = 'dataReviewCheck'
        elif type_of_union == 'dispositionStatus':
            if disposition_status is None:
                raise ValueError('a union value must not be None')
            self._disposition_status = disposition_status
            self._type = 'dispositionStatus'
        elif type_of_union == 'priority':
            if priority is None:
                raise ValueError('a union value must not be None')
            self._priority = priority
            self._type = 'priority'
        elif type_of_union == 'assignee':
            if assignee is None:
                raise ValueError('a union value must not be None')
            self._assignee = assignee
            self._type = 'assignee'
        elif type_of_union == 'eventType':
            if event_type is None:
                raise ValueError('a union value must not be None')
            self._event_type = event_type
            self._type = 'eventType'
        elif type_of_union == 'createdBy':
            if created_by is None:
                raise ValueError('a union value must not be None')
            self._created_by = created_by
            self._type = 'createdBy'
        elif type_of_union == 'label':
            if label is None:
                raise ValueError('a union value must not be None')
            self._label = label
            self._type = 'label'
        elif type_of_union == 'property':
            if property is None:
                raise ValueError('a union value must not be None')
            self._property = property
            self._type = 'property'
        elif type_of_union == 'and':
            if and_ is None:
                raise ValueError('a union value must not be None')
            self._and_ = and_
            self._type = 'and'
        elif type_of_union == 'or':
            if or_ is None:
                raise ValueError('a union value must not be None')
            self._or_ = or_
            self._type = 'or'
        elif type_of_union == 'not':
            if not_ is None:
                raise ValueError('a union value must not be None')
            self._not_ = not_
            self._type = 'not'
        elif type_of_union == 'workspace':
            if workspace is None:
                raise ValueError('a union value must not be None')
            self._workspace = workspace
            self._type = 'workspace'
        elif type_of_union == 'procedure':
            if procedure is None:
                raise ValueError('a union value must not be None')
            self._procedure = procedure
            self._type = 'procedure'
        elif type_of_union == 'procedureExecution':
            if procedure_execution is None:
                raise ValueError('a union value must not be None')
            self._procedure_execution = procedure_execution
            self._type = 'procedureExecution'
        elif type_of_union == 'stepId':
            if step_id is None:
                raise ValueError('a union value must not be None')
            self._step_id = step_id
            self._type = 'stepId'

    @builtins.property
    def search_text(self) -> Optional[str]:
        return self._search_text

    @builtins.property
    def asset(self) -> Optional[str]:
        return self._asset

    @builtins.property
    def template(self) -> Optional[str]:
        return self._template

    @builtins.property
    def workbook(self) -> Optional[str]:
        return self._workbook

    @builtins.property
    def data_review(self) -> Optional[str]:
        return self._data_review

    @builtins.property
    def origin_type(self) -> Optional["event_SearchEventOriginType"]:
        return self._origin_type

    @builtins.property
    def data_review_check(self) -> Optional[str]:
        return self._data_review_check

    @builtins.property
    def disposition_status(self) -> Optional["event_EventDispositionStatus"]:
        return self._disposition_status

    @builtins.property
    def priority(self) -> Optional["scout_api_Priority"]:
        return self._priority

    @builtins.property
    def assignee(self) -> Optional[str]:
        return self._assignee

    @builtins.property
    def event_type(self) -> Optional["event_EventType"]:
        return self._event_type

    @builtins.property
    def created_by(self) -> Optional[str]:
        return self._created_by

    @builtins.property
    def label(self) -> Optional[str]:
        return self._label

    @builtins.property
    def property(self) -> Optional["api_Property"]:
        return self._property

    @builtins.property
    def and_(self) -> Optional[List["event_HistogramFilterQuery"]]:
        return self._and_

    @builtins.property
    def or_(self) -> Optional[List["event_HistogramFilterQuery"]]:
        return self._or_

    @builtins.property
    def not_(self) -> Optional["event_HistogramFilterQuery"]:
        return self._not_

    @builtins.property
    def workspace(self) -> Optional[str]:
        return self._workspace

    @builtins.property
    def procedure(self) -> Optional[str]:
        return self._procedure

    @builtins.property
    def procedure_execution(self) -> Optional[str]:
        return self._procedure_execution

    @builtins.property
    def step_id(self) -> Optional[str]:
        return self._step_id

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, event_HistogramFilterQueryVisitor):
            raise ValueError('{} is not an instance of event_HistogramFilterQueryVisitor'.format(visitor.__class__.__name__))
        if self._type == 'searchText' and self.search_text is not None:
            return visitor._search_text(self.search_text)
        if self._type == 'asset' and self.asset is not None:
            return visitor._asset(self.asset)
        if self._type == 'template' and self.template is not None:
            return visitor._template(self.template)
        if self._type == 'workbook' and self.workbook is not None:
            return visitor._workbook(self.workbook)
        if self._type == 'dataReview' and self.data_review is not None:
            return visitor._data_review(self.data_review)
        if self._type == 'originType' and self.origin_type is not None:
            return visitor._origin_type(self.origin_type)
        if self._type == 'dataReviewCheck' and self.data_review_check is not None:
            return visitor._data_review_check(self.data_review_check)
        if self._type == 'dispositionStatus' and self.disposition_status is not None:
            return visitor._disposition_status(self.disposition_status)
        if self._type == 'priority' and self.priority is not None:
            return visitor._priority(self.priority)
        if self._type == 'assignee' and self.assignee is not None:
            return visitor._assignee(self.assignee)
        if self._type == 'eventType' and self.event_type is not None:
            return visitor._event_type(self.event_type)
        if self._type == 'createdBy' and self.created_by is not None:
            return visitor._created_by(self.created_by)
        if self._type == 'label' and self.label is not None:
            return visitor._label(self.label)
        if self._type == 'property' and self.property is not None:
            return visitor._property(self.property)
        if self._type == 'and' and self.and_ is not None:
            return visitor._and(self.and_)
        if self._type == 'or' and self.or_ is not None:
            return visitor._or(self.or_)
        if self._type == 'not' and self.not_ is not None:
            return visitor._not(self.not_)
        if self._type == 'workspace' and self.workspace is not None:
            return visitor._workspace(self.workspace)
        if self._type == 'procedure' and self.procedure is not None:
            return visitor._procedure(self.procedure)
        if self._type == 'procedureExecution' and self.procedure_execution is not None:
            return visitor._procedure_execution(self.procedure_execution)
        if self._type == 'stepId' and self.step_id is not None:
            return visitor._step_id(self.step_id)


event_HistogramFilterQuery.__name__ = "HistogramFilterQuery"
event_HistogramFilterQuery.__qualname__ = "HistogramFilterQuery"
event_HistogramFilterQuery.__module__ = "nominal_api.event"


class event_HistogramFilterQueryVisitor:

    @abstractmethod
    def _search_text(self, search_text: str) -> Any:
        pass

    @abstractmethod
    def _asset(self, asset: str) -> Any:
        pass

    @abstractmethod
    def _template(self, template: str) -> Any:
        pass

    @abstractmethod
    def _workbook(self, workbook: str) -> Any:
        pass

    @abstractmethod
    def _data_review(self, data_review: str) -> Any:
        pass

    @abstractmethod
    def _origin_type(self, origin_type: "event_SearchEventOriginType") -> Any:
        pass

    @abstractmethod
    def _data_review_check(self, data_review_check: str) -> Any:
        pass

    @abstractmethod
    def _disposition_status(self, disposition_status: "event_EventDispositionStatus") -> Any:
        pass

    @abstractmethod
    def _priority(self, priority: "scout_api_Priority") -> Any:
        pass

    @abstractmethod
    def _assignee(self, assignee: str) -> Any:
        pass

    @abstractmethod
    def _event_type(self, event_type: "event_EventType") -> Any:
        pass

    @abstractmethod
    def _created_by(self, created_by: str) -> Any:
        pass

    @abstractmethod
    def _label(self, label: str) -> Any:
        pass

    @abstractmethod
    def _property(self, property: "api_Property") -> Any:
        pass

    @abstractmethod
    def _and(self, and_: List["event_HistogramFilterQuery"]) -> Any:
        pass

    @abstractmethod
    def _or(self, or_: List["event_HistogramFilterQuery"]) -> Any:
        pass

    @abstractmethod
    def _not(self, not_: "event_HistogramFilterQuery") -> Any:
        pass

    @abstractmethod
    def _workspace(self, workspace: str) -> Any:
        pass

    @abstractmethod
    def _procedure(self, procedure: str) -> Any:
        pass

    @abstractmethod
    def _procedure_execution(self, procedure_execution: str) -> Any:
        pass

    @abstractmethod
    def _step_id(self, step_id: str) -> Any:
        pass


event_HistogramFilterQueryVisitor.__name__ = "HistogramFilterQueryVisitor"
event_HistogramFilterQueryVisitor.__qualname__ = "HistogramFilterQueryVisitor"
event_HistogramFilterQueryVisitor.__module__ = "nominal_api.event"


class event_ListPropertiesAndLabelsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'workspaces': ConjureFieldDefinition('workspaces', OptionalTypeWrapper[List[api_rids_WorkspaceRid]])
        }

    __slots__: List[str] = ['_workspaces']

    def __init__(self, workspaces: Optional[List[str]] = None) -> None:
        self._workspaces = workspaces

    @builtins.property
    def workspaces(self) -> Optional[List[str]]:
        """If omitted, results will come from all workspaces the user belongs to.
        """
        return self._workspaces


event_ListPropertiesAndLabelsRequest.__name__ = "ListPropertiesAndLabelsRequest"
event_ListPropertiesAndLabelsRequest.__qualname__ = "ListPropertiesAndLabelsRequest"
event_ListPropertiesAndLabelsRequest.__module__ = "nominal_api.event"


class event_ProcedureEventOrigin(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'procedure_execution_rid': ConjureFieldDefinition('procedureExecutionRid', api_rids_ProcedureExecutionRid),
            'procedure_rid': ConjureFieldDefinition('procedureRid', api_rids_ProcedureRid),
            'step_id': ConjureFieldDefinition('stepId', str)
        }

    __slots__: List[str] = ['_procedure_execution_rid', '_procedure_rid', '_step_id']

    def __init__(self, procedure_execution_rid: str, procedure_rid: str, step_id: str) -> None:
        self._procedure_execution_rid = procedure_execution_rid
        self._procedure_rid = procedure_rid
        self._step_id = step_id

    @builtins.property
    def procedure_execution_rid(self) -> str:
        return self._procedure_execution_rid

    @builtins.property
    def procedure_rid(self) -> str:
        return self._procedure_rid

    @builtins.property
    def step_id(self) -> str:
        return self._step_id


event_ProcedureEventOrigin.__name__ = "ProcedureEventOrigin"
event_ProcedureEventOrigin.__qualname__ = "ProcedureEventOrigin"
event_ProcedureEventOrigin.__module__ = "nominal_api.event"


class event_SearchEventOriginType(ConjureEnumType):

    WORKBOOK = 'WORKBOOK'
    '''WORKBOOK'''
    TEMPLATE = 'TEMPLATE'
    '''TEMPLATE'''
    API = 'API'
    '''API'''
    DATA_REVIEW = 'DATA_REVIEW'
    '''DATA_REVIEW'''
    PROCEDURE = 'PROCEDURE'
    '''PROCEDURE'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


event_SearchEventOriginType.__name__ = "SearchEventOriginType"
event_SearchEventOriginType.__qualname__ = "SearchEventOriginType"
event_SearchEventOriginType.__module__ = "nominal_api.event"


class event_SearchEventsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'sort': ConjureFieldDefinition('sort', event_SortOptions),
            'page_size': ConjureFieldDefinition('pageSize', int),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token]),
            'query': ConjureFieldDefinition('query', event_SearchQuery),
            'archived_statuses': ConjureFieldDefinition('archivedStatuses', OptionalTypeWrapper[List[api_ArchivedStatus]])
        }

    __slots__: List[str] = ['_sort', '_page_size', '_next_page_token', '_query', '_archived_statuses']

    def __init__(self, page_size: int, query: "event_SearchQuery", sort: "event_SortOptions", archived_statuses: Optional[List["api_ArchivedStatus"]] = None, next_page_token: Optional[str] = None) -> None:
        self._sort = sort
        self._page_size = page_size
        self._next_page_token = next_page_token
        self._query = query
        self._archived_statuses = archived_statuses

    @builtins.property
    def sort(self) -> "event_SortOptions":
        return self._sort

    @builtins.property
    def page_size(self) -> int:
        """Will reject page sizes greater than 10k.
        """
        return self._page_size

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token

    @builtins.property
    def query(self) -> "event_SearchQuery":
        return self._query

    @builtins.property
    def archived_statuses(self) -> Optional[List["api_ArchivedStatus"]]:
        """Default search status is NOT_ARCHIVED if none are provided. Allows for including archived events in search.
        """
        return self._archived_statuses


event_SearchEventsRequest.__name__ = "SearchEventsRequest"
event_SearchEventsRequest.__qualname__ = "SearchEventsRequest"
event_SearchEventsRequest.__module__ = "nominal_api.event"


class event_SearchEventsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[event_Event]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_results', '_next_page_token']

    def __init__(self, results: List["event_Event"], next_page_token: Optional[str] = None) -> None:
        self._results = results
        self._next_page_token = next_page_token

    @builtins.property
    def results(self) -> List["event_Event"]:
        return self._results

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


event_SearchEventsResponse.__name__ = "SearchEventsResponse"
event_SearchEventsResponse.__qualname__ = "SearchEventsResponse"
event_SearchEventsResponse.__module__ = "nominal_api.event"


class event_SearchQuery(ConjureUnionType):
    _search_text: Optional[str] = None
    _after: Optional["api_Timestamp"] = None
    _before: Optional["api_Timestamp"] = None
    _advanced_time_filter: Optional["event_EventTimeFilter"] = None
    _asset: Optional[str] = None
    _template: Optional[str] = None
    _workbook: Optional[str] = None
    _data_review: Optional[str] = None
    _origin_type: Optional["event_SearchEventOriginType"] = None
    _data_review_check: Optional[str] = None
    _disposition_status: Optional["event_EventDispositionStatus"] = None
    _priority: Optional["scout_api_Priority"] = None
    _assignee: Optional[str] = None
    _event_type: Optional["event_EventType"] = None
    _created_by: Optional[str] = None
    _label: Optional[str] = None
    _property: Optional["api_Property"] = None
    _and_: Optional[List["event_SearchQuery"]] = None
    _or_: Optional[List["event_SearchQuery"]] = None
    _not_: Optional["event_SearchQuery"] = None
    _workspace: Optional[str] = None
    _procedure: Optional[str] = None
    _procedure_execution: Optional[str] = None
    _step_id: Optional[str] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'search_text': ConjureFieldDefinition('searchText', str),
            'after': ConjureFieldDefinition('after', api_Timestamp),
            'before': ConjureFieldDefinition('before', api_Timestamp),
            'advanced_time_filter': ConjureFieldDefinition('advancedTimeFilter', event_EventTimeFilter),
            'asset': ConjureFieldDefinition('asset', scout_rids_api_AssetRid),
            'template': ConjureFieldDefinition('template', scout_rids_api_TemplateRid),
            'workbook': ConjureFieldDefinition('workbook', scout_rids_api_NotebookRid),
            'data_review': ConjureFieldDefinition('dataReview', scout_rids_api_DataReviewRid),
            'origin_type': ConjureFieldDefinition('originType', event_SearchEventOriginType),
            'data_review_check': ConjureFieldDefinition('dataReviewCheck', scout_rids_api_CheckRid),
            'disposition_status': ConjureFieldDefinition('dispositionStatus', event_EventDispositionStatus),
            'priority': ConjureFieldDefinition('priority', scout_api_Priority),
            'assignee': ConjureFieldDefinition('assignee', scout_rids_api_UserRid),
            'event_type': ConjureFieldDefinition('eventType', event_EventType),
            'created_by': ConjureFieldDefinition('createdBy', scout_rids_api_UserRid),
            'label': ConjureFieldDefinition('label', api_Label),
            'property': ConjureFieldDefinition('property', api_Property),
            'and_': ConjureFieldDefinition('and', List[event_SearchQuery]),
            'or_': ConjureFieldDefinition('or', List[event_SearchQuery]),
            'not_': ConjureFieldDefinition('not', event_SearchQuery),
            'workspace': ConjureFieldDefinition('workspace', api_rids_WorkspaceRid),
            'procedure': ConjureFieldDefinition('procedure', api_rids_ProcedureRid),
            'procedure_execution': ConjureFieldDefinition('procedureExecution', api_rids_ProcedureExecutionRid),
            'step_id': ConjureFieldDefinition('stepId', str)
        }

    def __init__(
            self,
            search_text: Optional[str] = None,
            after: Optional["api_Timestamp"] = None,
            before: Optional["api_Timestamp"] = None,
            advanced_time_filter: Optional["event_EventTimeFilter"] = None,
            asset: Optional[str] = None,
            template: Optional[str] = None,
            workbook: Optional[str] = None,
            data_review: Optional[str] = None,
            origin_type: Optional["event_SearchEventOriginType"] = None,
            data_review_check: Optional[str] = None,
            disposition_status: Optional["event_EventDispositionStatus"] = None,
            priority: Optional["scout_api_Priority"] = None,
            assignee: Optional[str] = None,
            event_type: Optional["event_EventType"] = None,
            created_by: Optional[str] = None,
            label: Optional[str] = None,
            property: Optional["api_Property"] = None,
            and_: Optional[List["event_SearchQuery"]] = None,
            or_: Optional[List["event_SearchQuery"]] = None,
            not_: Optional["event_SearchQuery"] = None,
            workspace: Optional[str] = None,
            procedure: Optional[str] = None,
            procedure_execution: Optional[str] = None,
            step_id: Optional[str] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (search_text is not None) + (after is not None) + (before is not None) + (advanced_time_filter is not None) + (asset is not None) + (template is not None) + (workbook is not None) + (data_review is not None) + (origin_type is not None) + (data_review_check is not None) + (disposition_status is not None) + (priority is not None) + (assignee is not None) + (event_type is not None) + (created_by is not None) + (label is not None) + (property is not None) + (and_ is not None) + (or_ is not None) + (not_ is not None) + (workspace is not None) + (procedure is not None) + (procedure_execution is not None) + (step_id is not None) != 1:
                raise ValueError('a union must contain a single member')

            if search_text is not None:
                self._search_text = search_text
                self._type = 'searchText'
            if after is not None:
                self._after = after
                self._type = 'after'
            if before is not None:
                self._before = before
                self._type = 'before'
            if advanced_time_filter is not None:
                self._advanced_time_filter = advanced_time_filter
                self._type = 'advancedTimeFilter'
            if asset is not None:
                self._asset = asset
                self._type = 'asset'
            if template is not None:
                self._template = template
                self._type = 'template'
            if workbook is not None:
                self._workbook = workbook
                self._type = 'workbook'
            if data_review is not None:
                self._data_review = data_review
                self._type = 'dataReview'
            if origin_type is not None:
                self._origin_type = origin_type
                self._type = 'originType'
            if data_review_check is not None:
                self._data_review_check = data_review_check
                self._type = 'dataReviewCheck'
            if disposition_status is not None:
                self._disposition_status = disposition_status
                self._type = 'dispositionStatus'
            if priority is not None:
                self._priority = priority
                self._type = 'priority'
            if assignee is not None:
                self._assignee = assignee
                self._type = 'assignee'
            if event_type is not None:
                self._event_type = event_type
                self._type = 'eventType'
            if created_by is not None:
                self._created_by = created_by
                self._type = 'createdBy'
            if label is not None:
                self._label = label
                self._type = 'label'
            if property is not None:
                self._property = property
                self._type = 'property'
            if and_ is not None:
                self._and_ = and_
                self._type = 'and'
            if or_ is not None:
                self._or_ = or_
                self._type = 'or'
            if not_ is not None:
                self._not_ = not_
                self._type = 'not'
            if workspace is not None:
                self._workspace = workspace
                self._type = 'workspace'
            if procedure is not None:
                self._procedure = procedure
                self._type = 'procedure'
            if procedure_execution is not None:
                self._procedure_execution = procedure_execution
                self._type = 'procedureExecution'
            if step_id is not None:
                self._step_id = step_id
                self._type = 'stepId'

        elif type_of_union == 'searchText':
            if search_text is None:
                raise ValueError('a union value must not be None')
            self._search_text = search_text
            self._type = 'searchText'
        elif type_of_union == 'after':
            if after is None:
                raise ValueError('a union value must not be None')
            self._after = after
            self._type = 'after'
        elif type_of_union == 'before':
            if before is None:
                raise ValueError('a union value must not be None')
            self._before = before
            self._type = 'before'
        elif type_of_union == 'advancedTimeFilter':
            if advanced_time_filter is None:
                raise ValueError('a union value must not be None')
            self._advanced_time_filter = advanced_time_filter
            self._type = 'advancedTimeFilter'
        elif type_of_union == 'asset':
            if asset is None:
                raise ValueError('a union value must not be None')
            self._asset = asset
            self._type = 'asset'
        elif type_of_union == 'template':
            if template is None:
                raise ValueError('a union value must not be None')
            self._template = template
            self._type = 'template'
        elif type_of_union == 'workbook':
            if workbook is None:
                raise ValueError('a union value must not be None')
            self._workbook = workbook
            self._type = 'workbook'
        elif type_of_union == 'dataReview':
            if data_review is None:
                raise ValueError('a union value must not be None')
            self._data_review = data_review
            self._type = 'dataReview'
        elif type_of_union == 'originType':
            if origin_type is None:
                raise ValueError('a union value must not be None')
            self._origin_type = origin_type
            self._type = 'originType'
        elif type_of_union == 'dataReviewCheck':
            if data_review_check is None:
                raise ValueError('a union value must not be None')
            self._data_review_check = data_review_check
            self._type = 'dataReviewCheck'
        elif type_of_union == 'dispositionStatus':
            if disposition_status is None:
                raise ValueError('a union value must not be None')
            self._disposition_status = disposition_status
            self._type = 'dispositionStatus'
        elif type_of_union == 'priority':
            if priority is None:
                raise ValueError('a union value must not be None')
            self._priority = priority
            self._type = 'priority'
        elif type_of_union == 'assignee':
            if assignee is None:
                raise ValueError('a union value must not be None')
            self._assignee = assignee
            self._type = 'assignee'
        elif type_of_union == 'eventType':
            if event_type is None:
                raise ValueError('a union value must not be None')
            self._event_type = event_type
            self._type = 'eventType'
        elif type_of_union == 'createdBy':
            if created_by is None:
                raise ValueError('a union value must not be None')
            self._created_by = created_by
            self._type = 'createdBy'
        elif type_of_union == 'label':
            if label is None:
                raise ValueError('a union value must not be None')
            self._label = label
            self._type = 'label'
        elif type_of_union == 'property':
            if property is None:
                raise ValueError('a union value must not be None')
            self._property = property
            self._type = 'property'
        elif type_of_union == 'and':
            if and_ is None:
                raise ValueError('a union value must not be None')
            self._and_ = and_
            self._type = 'and'
        elif type_of_union == 'or':
            if or_ is None:
                raise ValueError('a union value must not be None')
            self._or_ = or_
            self._type = 'or'
        elif type_of_union == 'not':
            if not_ is None:
                raise ValueError('a union value must not be None')
            self._not_ = not_
            self._type = 'not'
        elif type_of_union == 'workspace':
            if workspace is None:
                raise ValueError('a union value must not be None')
            self._workspace = workspace
            self._type = 'workspace'
        elif type_of_union == 'procedure':
            if procedure is None:
                raise ValueError('a union value must not be None')
            self._procedure = procedure
            self._type = 'procedure'
        elif type_of_union == 'procedureExecution':
            if procedure_execution is None:
                raise ValueError('a union value must not be None')
            self._procedure_execution = procedure_execution
            self._type = 'procedureExecution'
        elif type_of_union == 'stepId':
            if step_id is None:
                raise ValueError('a union value must not be None')
            self._step_id = step_id
            self._type = 'stepId'

    @builtins.property
    def search_text(self) -> Optional[str]:
        return self._search_text

    @builtins.property
    def after(self) -> Optional["api_Timestamp"]:
        """Filters to events after this timestamp, exclusive.
This includes events that start before, but end after this time.
        """
        return self._after

    @builtins.property
    def before(self) -> Optional["api_Timestamp"]:
        """Filters to events before this timestamp, exclusive.
This includes events that start before, but end after this time.
        """
        return self._before

    @builtins.property
    def advanced_time_filter(self) -> Optional["event_EventTimeFilter"]:
        return self._advanced_time_filter

    @builtins.property
    def asset(self) -> Optional[str]:
        return self._asset

    @builtins.property
    def template(self) -> Optional[str]:
        return self._template

    @builtins.property
    def workbook(self) -> Optional[str]:
        return self._workbook

    @builtins.property
    def data_review(self) -> Optional[str]:
        return self._data_review

    @builtins.property
    def origin_type(self) -> Optional["event_SearchEventOriginType"]:
        return self._origin_type

    @builtins.property
    def data_review_check(self) -> Optional[str]:
        return self._data_review_check

    @builtins.property
    def disposition_status(self) -> Optional["event_EventDispositionStatus"]:
        return self._disposition_status

    @builtins.property
    def priority(self) -> Optional["scout_api_Priority"]:
        return self._priority

    @builtins.property
    def assignee(self) -> Optional[str]:
        return self._assignee

    @builtins.property
    def event_type(self) -> Optional["event_EventType"]:
        return self._event_type

    @builtins.property
    def created_by(self) -> Optional[str]:
        return self._created_by

    @builtins.property
    def label(self) -> Optional[str]:
        return self._label

    @builtins.property
    def property(self) -> Optional["api_Property"]:
        return self._property

    @builtins.property
    def and_(self) -> Optional[List["event_SearchQuery"]]:
        return self._and_

    @builtins.property
    def or_(self) -> Optional[List["event_SearchQuery"]]:
        return self._or_

    @builtins.property
    def not_(self) -> Optional["event_SearchQuery"]:
        return self._not_

    @builtins.property
    def workspace(self) -> Optional[str]:
        return self._workspace

    @builtins.property
    def procedure(self) -> Optional[str]:
        return self._procedure

    @builtins.property
    def procedure_execution(self) -> Optional[str]:
        return self._procedure_execution

    @builtins.property
    def step_id(self) -> Optional[str]:
        return self._step_id

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, event_SearchQueryVisitor):
            raise ValueError('{} is not an instance of event_SearchQueryVisitor'.format(visitor.__class__.__name__))
        if self._type == 'searchText' and self.search_text is not None:
            return visitor._search_text(self.search_text)
        if self._type == 'after' and self.after is not None:
            return visitor._after(self.after)
        if self._type == 'before' and self.before is not None:
            return visitor._before(self.before)
        if self._type == 'advancedTimeFilter' and self.advanced_time_filter is not None:
            return visitor._advanced_time_filter(self.advanced_time_filter)
        if self._type == 'asset' and self.asset is not None:
            return visitor._asset(self.asset)
        if self._type == 'template' and self.template is not None:
            return visitor._template(self.template)
        if self._type == 'workbook' and self.workbook is not None:
            return visitor._workbook(self.workbook)
        if self._type == 'dataReview' and self.data_review is not None:
            return visitor._data_review(self.data_review)
        if self._type == 'originType' and self.origin_type is not None:
            return visitor._origin_type(self.origin_type)
        if self._type == 'dataReviewCheck' and self.data_review_check is not None:
            return visitor._data_review_check(self.data_review_check)
        if self._type == 'dispositionStatus' and self.disposition_status is not None:
            return visitor._disposition_status(self.disposition_status)
        if self._type == 'priority' and self.priority is not None:
            return visitor._priority(self.priority)
        if self._type == 'assignee' and self.assignee is not None:
            return visitor._assignee(self.assignee)
        if self._type == 'eventType' and self.event_type is not None:
            return visitor._event_type(self.event_type)
        if self._type == 'createdBy' and self.created_by is not None:
            return visitor._created_by(self.created_by)
        if self._type == 'label' and self.label is not None:
            return visitor._label(self.label)
        if self._type == 'property' and self.property is not None:
            return visitor._property(self.property)
        if self._type == 'and' and self.and_ is not None:
            return visitor._and(self.and_)
        if self._type == 'or' and self.or_ is not None:
            return visitor._or(self.or_)
        if self._type == 'not' and self.not_ is not None:
            return visitor._not(self.not_)
        if self._type == 'workspace' and self.workspace is not None:
            return visitor._workspace(self.workspace)
        if self._type == 'procedure' and self.procedure is not None:
            return visitor._procedure(self.procedure)
        if self._type == 'procedureExecution' and self.procedure_execution is not None:
            return visitor._procedure_execution(self.procedure_execution)
        if self._type == 'stepId' and self.step_id is not None:
            return visitor._step_id(self.step_id)


event_SearchQuery.__name__ = "SearchQuery"
event_SearchQuery.__qualname__ = "SearchQuery"
event_SearchQuery.__module__ = "nominal_api.event"


class event_SearchQueryVisitor:

    @abstractmethod
    def _search_text(self, search_text: str) -> Any:
        pass

    @abstractmethod
    def _after(self, after: "api_Timestamp") -> Any:
        pass

    @abstractmethod
    def _before(self, before: "api_Timestamp") -> Any:
        pass

    @abstractmethod
    def _advanced_time_filter(self, advanced_time_filter: "event_EventTimeFilter") -> Any:
        pass

    @abstractmethod
    def _asset(self, asset: str) -> Any:
        pass

    @abstractmethod
    def _template(self, template: str) -> Any:
        pass

    @abstractmethod
    def _workbook(self, workbook: str) -> Any:
        pass

    @abstractmethod
    def _data_review(self, data_review: str) -> Any:
        pass

    @abstractmethod
    def _origin_type(self, origin_type: "event_SearchEventOriginType") -> Any:
        pass

    @abstractmethod
    def _data_review_check(self, data_review_check: str) -> Any:
        pass

    @abstractmethod
    def _disposition_status(self, disposition_status: "event_EventDispositionStatus") -> Any:
        pass

    @abstractmethod
    def _priority(self, priority: "scout_api_Priority") -> Any:
        pass

    @abstractmethod
    def _assignee(self, assignee: str) -> Any:
        pass

    @abstractmethod
    def _event_type(self, event_type: "event_EventType") -> Any:
        pass

    @abstractmethod
    def _created_by(self, created_by: str) -> Any:
        pass

    @abstractmethod
    def _label(self, label: str) -> Any:
        pass

    @abstractmethod
    def _property(self, property: "api_Property") -> Any:
        pass

    @abstractmethod
    def _and(self, and_: List["event_SearchQuery"]) -> Any:
        pass

    @abstractmethod
    def _or(self, or_: List["event_SearchQuery"]) -> Any:
        pass

    @abstractmethod
    def _not(self, not_: "event_SearchQuery") -> Any:
        pass

    @abstractmethod
    def _workspace(self, workspace: str) -> Any:
        pass

    @abstractmethod
    def _procedure(self, procedure: str) -> Any:
        pass

    @abstractmethod
    def _procedure_execution(self, procedure_execution: str) -> Any:
        pass

    @abstractmethod
    def _step_id(self, step_id: str) -> Any:
        pass


event_SearchQueryVisitor.__name__ = "SearchQueryVisitor"
event_SearchQueryVisitor.__qualname__ = "SearchQueryVisitor"
event_SearchQueryVisitor.__module__ = "nominal_api.event"


class event_SortField(ConjureEnumType):

    START_TIME = 'START_TIME'
    '''START_TIME'''
    END_TIME = 'END_TIME'
    '''END_TIME'''
    DURATION = 'DURATION'
    '''DURATION'''
    DISPOSITION_STATUS = 'DISPOSITION_STATUS'
    '''DISPOSITION_STATUS'''
    PRIORITY = 'PRIORITY'
    '''PRIORITY'''
    EVENT_NAME = 'EVENT_NAME'
    '''EVENT_NAME'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


event_SortField.__name__ = "SortField"
event_SortField.__qualname__ = "SortField"
event_SortField.__module__ = "nominal_api.event"


class event_SortOptions(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'is_descending': ConjureFieldDefinition('isDescending', bool),
            'field': ConjureFieldDefinition('field', event_SortField)
        }

    __slots__: List[str] = ['_is_descending', '_field']

    def __init__(self, field: "event_SortField", is_descending: bool) -> None:
        self._is_descending = is_descending
        self._field = field

    @builtins.property
    def is_descending(self) -> bool:
        return self._is_descending

    @builtins.property
    def field(self) -> "event_SortField":
        return self._field


event_SortOptions.__name__ = "SortOptions"
event_SortOptions.__qualname__ = "SortOptions"
event_SortOptions.__module__ = "nominal_api.event"


class event_TemplateEventOrigin(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', scout_rids_api_TemplateRid)
        }

    __slots__: List[str] = ['_rid']

    def __init__(self, rid: str) -> None:
        self._rid = rid

    @builtins.property
    def rid(self) -> str:
        return self._rid


event_TemplateEventOrigin.__name__ = "TemplateEventOrigin"
event_TemplateEventOrigin.__qualname__ = "TemplateEventOrigin"
event_TemplateEventOrigin.__module__ = "nominal_api.event"


class event_TimeSeriesChannelAssociation(ConjureBeanType):
    """A singular time series to associate the event with.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'variable_name': ConjureFieldDefinition('variableName', str),
            'tags': ConjureFieldDefinition('tags', OptionalTypeWrapper[Dict[str, str]])
        }

    __slots__: List[str] = ['_variable_name', '_tags']

    def __init__(self, variable_name: str, tags: Optional[Dict[str, str]] = None) -> None:
        self._variable_name = variable_name
        self._tags = tags

    @builtins.property
    def variable_name(self) -> str:
        return self._variable_name

    @builtins.property
    def tags(self) -> Optional[Dict[str, str]]:
        """If this variable is grouped, the tags within the groupings this event should associate with
        """
        return self._tags


event_TimeSeriesChannelAssociation.__name__ = "TimeSeriesChannelAssociation"
event_TimeSeriesChannelAssociation.__qualname__ = "TimeSeriesChannelAssociation"
event_TimeSeriesChannelAssociation.__module__ = "nominal_api.event"


class event_UpdateDispositionRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', api_rids_EventRid),
            'disposition': ConjureFieldDefinition('disposition', OptionalTypeWrapper[event_EventDisposition])
        }

    __slots__: List[str] = ['_rid', '_disposition']

    def __init__(self, rid: str, disposition: Optional["event_EventDisposition"] = None) -> None:
        self._rid = rid
        self._disposition = disposition

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def disposition(self) -> Optional["event_EventDisposition"]:
        """The new disposition for the event.
If empty, will remove the disposition from the event.
        """
        return self._disposition


event_UpdateDispositionRequest.__name__ = "UpdateDispositionRequest"
event_UpdateDispositionRequest.__qualname__ = "UpdateDispositionRequest"
event_UpdateDispositionRequest.__module__ = "nominal_api.event"


class event_UpdateEvent(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'uuid': ConjureFieldDefinition('uuid', str),
            'rid': ConjureFieldDefinition('rid', OptionalTypeWrapper[api_rids_EventRid]),
            'asset_rids': ConjureFieldDefinition('assetRids', OptionalTypeWrapper[List[scout_rids_api_AssetRid]]),
            'timestamp': ConjureFieldDefinition('timestamp', OptionalTypeWrapper[api_Timestamp]),
            'duration': ConjureFieldDefinition('duration', OptionalTypeWrapper[scout_run_api_Duration]),
            'name': ConjureFieldDefinition('name', OptionalTypeWrapper[str]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'type': ConjureFieldDefinition('type', OptionalTypeWrapper[event_EventType]),
            'labels': ConjureFieldDefinition('labels', OptionalTypeWrapper[List[api_Label]]),
            'properties': ConjureFieldDefinition('properties', OptionalTypeWrapper[Dict[api_PropertyName, api_PropertyValue]])
        }

    __slots__: List[str] = ['_uuid', '_rid', '_asset_rids', '_timestamp', '_duration', '_name', '_description', '_type', '_labels', '_properties']

    def __init__(self, uuid: str, asset_rids: Optional[List[str]] = None, description: Optional[str] = None, duration: Optional["scout_run_api_Duration"] = None, labels: Optional[List[str]] = None, name: Optional[str] = None, properties: Optional[Dict[str, str]] = None, rid: Optional[str] = None, timestamp: Optional["api_Timestamp"] = None, type: Optional["event_EventType"] = None) -> None:
        self._uuid = uuid
        self._rid = rid
        self._asset_rids = asset_rids
        self._timestamp = timestamp
        self._duration = duration
        self._name = name
        self._description = description
        self._type = type
        self._labels = labels
        self._properties = properties

    @builtins.property
    def uuid(self) -> str:
        return self._uuid

    @builtins.property
    def rid(self) -> Optional[str]:
        """The unique identifier for the event.
This field is required if the uuid field is not provided.
        """
        return self._rid

    @builtins.property
    def asset_rids(self) -> Optional[List[str]]:
        """If provided, will replace the existing asset rids.
If provided, must contain at least one asset rid.
        """
        return self._asset_rids

    @builtins.property
    def timestamp(self) -> Optional["api_Timestamp"]:
        return self._timestamp

    @builtins.property
    def duration(self) -> Optional["scout_run_api_Duration"]:
        return self._duration

    @builtins.property
    def name(self) -> Optional[str]:
        return self._name

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def type(self) -> Optional["event_EventType"]:
        return self._type

    @builtins.property
    def labels(self) -> Optional[List[str]]:
        return self._labels

    @builtins.property
    def properties(self) -> Optional[Dict[str, str]]:
        return self._properties


event_UpdateEvent.__name__ = "UpdateEvent"
event_UpdateEvent.__qualname__ = "UpdateEvent"
event_UpdateEvent.__module__ = "nominal_api.event"


class event_UpdateEventRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', api_rids_EventRid),
            'asset_rids': ConjureFieldDefinition('assetRids', OptionalTypeWrapper[List[scout_rids_api_AssetRid]]),
            'timestamp': ConjureFieldDefinition('timestamp', OptionalTypeWrapper[api_Timestamp]),
            'duration': ConjureFieldDefinition('duration', OptionalTypeWrapper[scout_run_api_Duration]),
            'name': ConjureFieldDefinition('name', OptionalTypeWrapper[str]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'type': ConjureFieldDefinition('type', OptionalTypeWrapper[event_EventType]),
            'labels': ConjureFieldDefinition('labels', OptionalTypeWrapper[List[api_Label]]),
            'properties': ConjureFieldDefinition('properties', OptionalTypeWrapper[Dict[api_PropertyName, api_PropertyValue]])
        }

    __slots__: List[str] = ['_rid', '_asset_rids', '_timestamp', '_duration', '_name', '_description', '_type', '_labels', '_properties']

    def __init__(self, rid: str, asset_rids: Optional[List[str]] = None, description: Optional[str] = None, duration: Optional["scout_run_api_Duration"] = None, labels: Optional[List[str]] = None, name: Optional[str] = None, properties: Optional[Dict[str, str]] = None, timestamp: Optional["api_Timestamp"] = None, type: Optional["event_EventType"] = None) -> None:
        self._rid = rid
        self._asset_rids = asset_rids
        self._timestamp = timestamp
        self._duration = duration
        self._name = name
        self._description = description
        self._type = type
        self._labels = labels
        self._properties = properties

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def asset_rids(self) -> Optional[List[str]]:
        """If provided, will replace the existing asset rids.
If provided, must contain at least one asset rid.
        """
        return self._asset_rids

    @builtins.property
    def timestamp(self) -> Optional["api_Timestamp"]:
        return self._timestamp

    @builtins.property
    def duration(self) -> Optional["scout_run_api_Duration"]:
        return self._duration

    @builtins.property
    def name(self) -> Optional[str]:
        return self._name

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def type(self) -> Optional["event_EventType"]:
        return self._type

    @builtins.property
    def labels(self) -> Optional[List[str]]:
        return self._labels

    @builtins.property
    def properties(self) -> Optional[Dict[str, str]]:
        return self._properties


event_UpdateEventRequest.__name__ = "UpdateEventRequest"
event_UpdateEventRequest.__qualname__ = "UpdateEventRequest"
event_UpdateEventRequest.__module__ = "nominal_api.event"


class event_WorkbookDataAssociation(ConjureUnionType):
    _time_series_channel: Optional["event_TimeSeriesChannelAssociation"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'time_series_channel': ConjureFieldDefinition('timeSeriesChannel', event_TimeSeriesChannelAssociation)
        }

    def __init__(
            self,
            time_series_channel: Optional["event_TimeSeriesChannelAssociation"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (time_series_channel is not None) != 1:
                raise ValueError('a union must contain a single member')

            if time_series_channel is not None:
                self._time_series_channel = time_series_channel
                self._type = 'timeSeriesChannel'

        elif type_of_union == 'timeSeriesChannel':
            if time_series_channel is None:
                raise ValueError('a union value must not be None')
            self._time_series_channel = time_series_channel
            self._type = 'timeSeriesChannel'

    @builtins.property
    def time_series_channel(self) -> Optional["event_TimeSeriesChannelAssociation"]:
        return self._time_series_channel

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, event_WorkbookDataAssociationVisitor):
            raise ValueError('{} is not an instance of event_WorkbookDataAssociationVisitor'.format(visitor.__class__.__name__))
        if self._type == 'timeSeriesChannel' and self.time_series_channel is not None:
            return visitor._time_series_channel(self.time_series_channel)


event_WorkbookDataAssociation.__name__ = "WorkbookDataAssociation"
event_WorkbookDataAssociation.__qualname__ = "WorkbookDataAssociation"
event_WorkbookDataAssociation.__module__ = "nominal_api.event"


class event_WorkbookDataAssociationVisitor:

    @abstractmethod
    def _time_series_channel(self, time_series_channel: "event_TimeSeriesChannelAssociation") -> Any:
        pass


event_WorkbookDataAssociationVisitor.__name__ = "WorkbookDataAssociationVisitor"
event_WorkbookDataAssociationVisitor.__qualname__ = "WorkbookDataAssociationVisitor"
event_WorkbookDataAssociationVisitor.__module__ = "nominal_api.event"


class event_WorkbookEventOrigin(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', scout_rids_api_NotebookRid),
            'data': ConjureFieldDefinition('data', OptionalTypeWrapper[List[event_WorkbookDataAssociation]])
        }

    __slots__: List[str] = ['_rid', '_data']

    def __init__(self, rid: str, data: Optional[List["event_WorkbookDataAssociation"]] = None) -> None:
        self._rid = rid
        self._data = data

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def data(self) -> Optional[List["event_WorkbookDataAssociation"]]:
        """Data visualizations to associate this event with
        """
        return self._data


event_WorkbookEventOrigin.__name__ = "WorkbookEventOrigin"
event_WorkbookEventOrigin.__qualname__ = "WorkbookEventOrigin"
event_WorkbookEventOrigin.__module__ = "nominal_api.event"


class ingest_api_AbsoluteTimestamp(ConjureUnionType):
    _iso8601: Optional["ingest_api_Iso8601Timestamp"] = None
    _epoch_of_time_unit: Optional["ingest_api_EpochTimestamp"] = None
    _custom_format: Optional["ingest_api_CustomTimestamp"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'iso8601': ConjureFieldDefinition('iso8601', ingest_api_Iso8601Timestamp),
            'epoch_of_time_unit': ConjureFieldDefinition('epochOfTimeUnit', ingest_api_EpochTimestamp),
            'custom_format': ConjureFieldDefinition('customFormat', ingest_api_CustomTimestamp)
        }

    def __init__(
            self,
            iso8601: Optional["ingest_api_Iso8601Timestamp"] = None,
            epoch_of_time_unit: Optional["ingest_api_EpochTimestamp"] = None,
            custom_format: Optional["ingest_api_CustomTimestamp"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (iso8601 is not None) + (epoch_of_time_unit is not None) + (custom_format is not None) != 1:
                raise ValueError('a union must contain a single member')

            if iso8601 is not None:
                self._iso8601 = iso8601
                self._type = 'iso8601'
            if epoch_of_time_unit is not None:
                self._epoch_of_time_unit = epoch_of_time_unit
                self._type = 'epochOfTimeUnit'
            if custom_format is not None:
                self._custom_format = custom_format
                self._type = 'customFormat'

        elif type_of_union == 'iso8601':
            if iso8601 is None:
                raise ValueError('a union value must not be None')
            self._iso8601 = iso8601
            self._type = 'iso8601'
        elif type_of_union == 'epochOfTimeUnit':
            if epoch_of_time_unit is None:
                raise ValueError('a union value must not be None')
            self._epoch_of_time_unit = epoch_of_time_unit
            self._type = 'epochOfTimeUnit'
        elif type_of_union == 'customFormat':
            if custom_format is None:
                raise ValueError('a union value must not be None')
            self._custom_format = custom_format
            self._type = 'customFormat'

    @builtins.property
    def iso8601(self) -> Optional["ingest_api_Iso8601Timestamp"]:
        return self._iso8601

    @builtins.property
    def epoch_of_time_unit(self) -> Optional["ingest_api_EpochTimestamp"]:
        return self._epoch_of_time_unit

    @builtins.property
    def custom_format(self) -> Optional["ingest_api_CustomTimestamp"]:
        return self._custom_format

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_AbsoluteTimestampVisitor):
            raise ValueError('{} is not an instance of ingest_api_AbsoluteTimestampVisitor'.format(visitor.__class__.__name__))
        if self._type == 'iso8601' and self.iso8601 is not None:
            return visitor._iso8601(self.iso8601)
        if self._type == 'epochOfTimeUnit' and self.epoch_of_time_unit is not None:
            return visitor._epoch_of_time_unit(self.epoch_of_time_unit)
        if self._type == 'customFormat' and self.custom_format is not None:
            return visitor._custom_format(self.custom_format)


ingest_api_AbsoluteTimestamp.__name__ = "AbsoluteTimestamp"
ingest_api_AbsoluteTimestamp.__qualname__ = "AbsoluteTimestamp"
ingest_api_AbsoluteTimestamp.__module__ = "nominal_api.ingest_api"


class ingest_api_AbsoluteTimestampVisitor:

    @abstractmethod
    def _iso8601(self, iso8601: "ingest_api_Iso8601Timestamp") -> Any:
        pass

    @abstractmethod
    def _epoch_of_time_unit(self, epoch_of_time_unit: "ingest_api_EpochTimestamp") -> Any:
        pass

    @abstractmethod
    def _custom_format(self, custom_format: "ingest_api_CustomTimestamp") -> Any:
        pass


ingest_api_AbsoluteTimestampVisitor.__name__ = "AbsoluteTimestampVisitor"
ingest_api_AbsoluteTimestampVisitor.__qualname__ = "AbsoluteTimestampVisitor"
ingest_api_AbsoluteTimestampVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_AsyncHandle(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', str)
        }

    __slots__: List[str] = ['_rid']

    def __init__(self, rid: str) -> None:
        self._rid = rid

    @builtins.property
    def rid(self) -> str:
        return self._rid


ingest_api_AsyncHandle.__name__ = "AsyncHandle"
ingest_api_AsyncHandle.__qualname__ = "AsyncHandle"
ingest_api_AsyncHandle.__module__ = "nominal_api.ingest_api"


class ingest_api_Authentication(ConjureUnionType):
    """Authentication methods for Docker registries.
    """
    _user_and_password: Optional["ingest_api_UserAndPasswordAuthentication"] = None
    _public: Optional["ingest_api_PublicAuthentication"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'user_and_password': ConjureFieldDefinition('userAndPassword', ingest_api_UserAndPasswordAuthentication),
            'public': ConjureFieldDefinition('public', ingest_api_PublicAuthentication)
        }

    def __init__(
            self,
            user_and_password: Optional["ingest_api_UserAndPasswordAuthentication"] = None,
            public: Optional["ingest_api_PublicAuthentication"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (user_and_password is not None) + (public is not None) != 1:
                raise ValueError('a union must contain a single member')

            if user_and_password is not None:
                self._user_and_password = user_and_password
                self._type = 'userAndPassword'
            if public is not None:
                self._public = public
                self._type = 'public'

        elif type_of_union == 'userAndPassword':
            if user_and_password is None:
                raise ValueError('a union value must not be None')
            self._user_and_password = user_and_password
            self._type = 'userAndPassword'
        elif type_of_union == 'public':
            if public is None:
                raise ValueError('a union value must not be None')
            self._public = public
            self._type = 'public'

    @builtins.property
    def user_and_password(self) -> Optional["ingest_api_UserAndPasswordAuthentication"]:
        return self._user_and_password

    @builtins.property
    def public(self) -> Optional["ingest_api_PublicAuthentication"]:
        return self._public

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_AuthenticationVisitor):
            raise ValueError('{} is not an instance of ingest_api_AuthenticationVisitor'.format(visitor.__class__.__name__))
        if self._type == 'userAndPassword' and self.user_and_password is not None:
            return visitor._user_and_password(self.user_and_password)
        if self._type == 'public' and self.public is not None:
            return visitor._public(self.public)


ingest_api_Authentication.__name__ = "Authentication"
ingest_api_Authentication.__qualname__ = "Authentication"
ingest_api_Authentication.__module__ = "nominal_api.ingest_api"


class ingest_api_AuthenticationVisitor:

    @abstractmethod
    def _user_and_password(self, user_and_password: "ingest_api_UserAndPasswordAuthentication") -> Any:
        pass

    @abstractmethod
    def _public(self, public: "ingest_api_PublicAuthentication") -> Any:
        pass


ingest_api_AuthenticationVisitor.__name__ = "AuthenticationVisitor"
ingest_api_AuthenticationVisitor.__qualname__ = "AuthenticationVisitor"
ingest_api_AuthenticationVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_AvroStreamOpts(ConjureBeanType):
    """Options for ingesting Avro data with the following schema. This is a "stream-like" file format to support
use cases where a columnar/tabular format does not make sense. This closely matches Nominal's streaming
API, making it useful for use cases where network connection drops during streaming and a backup file needs
to be created.

If this schema is not used, will result in a failed ingestion.
{
    "type": "record",
    "name": "AvroStream",
    "namespace": "io.nominal.ingest",
    "fields": [
        {
            "name": "channel",
            "type": "string",
            "doc": "Channel/series name (e.g., 'vehicle_id', 'col_1', 'temperature')",
        },
        {
            "name": "timestamps",
            "type": {"type": "array", "items": "long"},
            "doc": "Array of Unix timestamps in nanoseconds",
        },
        {
            "name": "values",
            "type": {"type": "array", "items": ["double", "string"]},
            "doc": "Array of values. Can either be doubles or strings",
        },
        {
            "name": "tags",
            "type": {"type": "map", "values": "string"},
            "default": {},
            "doc": "Key-value metadata tags",
        },
    ],
}
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'source': ConjureFieldDefinition('source', ingest_api_IngestSource),
            'target': ConjureFieldDefinition('target', ingest_api_DatasetIngestTarget)
        }

    __slots__: List[str] = ['_source', '_target']

    def __init__(self, source: "ingest_api_IngestSource", target: "ingest_api_DatasetIngestTarget") -> None:
        self._source = source
        self._target = target

    @builtins.property
    def source(self) -> "ingest_api_IngestSource":
        return self._source

    @builtins.property
    def target(self) -> "ingest_api_DatasetIngestTarget":
        return self._target


ingest_api_AvroStreamOpts.__name__ = "AvroStreamOpts"
ingest_api_AvroStreamOpts.__qualname__ = "AvroStreamOpts"
ingest_api_AvroStreamOpts.__module__ = "nominal_api.ingest_api"


class ingest_api_ChannelConfig(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'prefix_tree_delimiter': ConjureFieldDefinition('prefixTreeDelimiter', OptionalTypeWrapper[str])
        }

    __slots__: List[str] = ['_prefix_tree_delimiter']

    def __init__(self, prefix_tree_delimiter: Optional[str] = None) -> None:
        self._prefix_tree_delimiter = prefix_tree_delimiter

    @builtins.property
    def prefix_tree_delimiter(self) -> Optional[str]:
        """If set, will construct a prefix tree for channels of the dataset using the given delimiter.
        """
        return self._prefix_tree_delimiter


ingest_api_ChannelConfig.__name__ = "ChannelConfig"
ingest_api_ChannelConfig.__qualname__ = "ChannelConfig"
ingest_api_ChannelConfig.__module__ = "nominal_api.ingest_api"


class ingest_api_CompleteMultipartUploadResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'location': ConjureFieldDefinition('location', OptionalTypeWrapper[str])
        }

    __slots__: List[str] = ['_location']

    def __init__(self, location: Optional[str] = None) -> None:
        self._location = location

    @builtins.property
    def location(self) -> Optional[str]:
        return self._location


ingest_api_CompleteMultipartUploadResponse.__name__ = "CompleteMultipartUploadResponse"
ingest_api_CompleteMultipartUploadResponse.__qualname__ = "CompleteMultipartUploadResponse"
ingest_api_CompleteMultipartUploadResponse.__module__ = "nominal_api.ingest_api"


class ingest_api_ContainerizedExtractor(ConjureBeanType):
    """Represents a containerized extractor that processes input files using a container.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', ingest_api_ContainerizedExtractorRid),
            'name': ConjureFieldDefinition('name', str),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'image': ConjureFieldDefinition('image', ingest_api_DockerImageSource),
            'inputs': ConjureFieldDefinition('inputs', List[ingest_api_FileExtractionInput]),
            'parameters': ConjureFieldDefinition('parameters', List[ingest_api_FileExtractionParameter]),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'created_at': ConjureFieldDefinition('createdAt', str),
            'is_archived': ConjureFieldDefinition('isArchived', bool),
            'timestamp_metadata': ConjureFieldDefinition('timestampMetadata', ingest_api_TimestampMetadata),
            'output_file_format': ConjureFieldDefinition('outputFileFormat', ingest_api_FileOutputFormat)
        }

    __slots__: List[str] = ['_rid', '_name', '_description', '_image', '_inputs', '_parameters', '_properties', '_labels', '_created_at', '_is_archived', '_timestamp_metadata', '_output_file_format']

    def __init__(self, created_at: str, image: "ingest_api_DockerImageSource", inputs: List["ingest_api_FileExtractionInput"], is_archived: bool, labels: List[str], name: str, output_file_format: "ingest_api_FileOutputFormat", parameters: List["ingest_api_FileExtractionParameter"], properties: Dict[str, str], rid: str, timestamp_metadata: "ingest_api_TimestampMetadata", description: Optional[str] = None) -> None:
        self._rid = rid
        self._name = name
        self._description = description
        self._image = image
        self._inputs = inputs
        self._parameters = parameters
        self._properties = properties
        self._labels = labels
        self._created_at = created_at
        self._is_archived = is_archived
        self._timestamp_metadata = timestamp_metadata
        self._output_file_format = output_file_format

    @builtins.property
    def rid(self) -> str:
        """Unique resource identifier for the extractor.
        """
        return self._rid

    @builtins.property
    def name(self) -> str:
        """The name of the extractor as defined by the user.
        """
        return self._name

    @builtins.property
    def description(self) -> Optional[str]:
        """Optional description of the extractor.
        """
        return self._description

    @builtins.property
    def image(self) -> "ingest_api_DockerImageSource":
        """Container image used to run the extractor.
        """
        return self._image

    @builtins.property
    def inputs(self) -> List["ingest_api_FileExtractionInput"]:
        """The input files that this extractor requires, mapped to environment variables that store the path to the file.
        """
        return self._inputs

    @builtins.property
    def parameters(self) -> List["ingest_api_FileExtractionParameter"]:
        """Describes the parameters of the extractor.
        """
        return self._parameters

    @builtins.property
    def properties(self) -> Dict[str, str]:
        """Additional properties associated with this extractor.
        """
        return self._properties

    @builtins.property
    def labels(self) -> List[str]:
        """Set of labels applied to this extractor.
        """
        return self._labels

    @builtins.property
    def created_at(self) -> str:
        """Timestamp when this extractor was created.
        """
        return self._created_at

    @builtins.property
    def is_archived(self) -> bool:
        """Whether this extractor is archived.
        """
        return self._is_archived

    @builtins.property
    def timestamp_metadata(self) -> "ingest_api_TimestampMetadata":
        """Metadata about the intermediate parquet this extractor will produce
        """
        return self._timestamp_metadata

    @builtins.property
    def output_file_format(self) -> "ingest_api_FileOutputFormat":
        """The format of the output file. Currently only "parquet", "csv", "parquet.tar" are supported
        """
        return self._output_file_format


ingest_api_ContainerizedExtractor.__name__ = "ContainerizedExtractor"
ingest_api_ContainerizedExtractor.__qualname__ = "ContainerizedExtractor"
ingest_api_ContainerizedExtractor.__module__ = "nominal_api.ingest_api"


class ingest_api_ContainerizedExtractorService(Service):
    """The Containerized Extractor service provides functionality for creating, updating, and archiving containerized extractors.
    """

    def register_containerized_extractor(self, auth_header: str, request: "ingest_api_RegisterContainerizedExtractorRequest") -> "ingest_api_RegisterContainerizedExtractorResponse":
        """Registers a containerized extractor for a given set of containerized files.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/extractors/v1/container'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), ingest_api_RegisterContainerizedExtractorResponse, self._return_none_for_unknown_union_types)

    def get_containerized_extractor(self, auth_header: str, extractor_rid: str) -> "ingest_api_ContainerizedExtractor":
        """Get a containerized extractor by its RID.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'extractorRid': quote(str(_conjure_encoder.default(extractor_rid)), safe=''),
        }

        _json: Any = None

        _path = '/extractors/v1/container/{extractorRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), ingest_api_ContainerizedExtractor, self._return_none_for_unknown_union_types)

    def search_containerized_extractors(self, auth_header: str, request: "ingest_api_SearchContainerizedExtractorsRequest") -> List["ingest_api_ContainerizedExtractor"]:
        """Search for containerized extractors based on query parameters.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/extractors/v1/container/search'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[ingest_api_ContainerizedExtractor], self._return_none_for_unknown_union_types)

    def update_containerized_extractor(self, auth_header: str, extractor_rid: str, request: "ingest_api_UpdateContainerizedExtractorRequest") -> "ingest_api_ContainerizedExtractor":
        """Update a containerized extractor. Only the fields that are set in the request will be updated.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'extractorRid': quote(str(_conjure_encoder.default(extractor_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/extractors/v1/container/{extractorRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), ingest_api_ContainerizedExtractor, self._return_none_for_unknown_union_types)

    def archive_containerized_extractor(self, auth_header: str, extractor_rid: str) -> None:
        """Archive a containerized extractor.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'extractorRid': quote(str(_conjure_encoder.default(extractor_rid)), safe=''),
        }

        _json: Any = None

        _path = '/extractors/v1/container/{extractorRid}/archive'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def unarchive_containerized_extractor(self, auth_header: str, extractor_rid: str) -> None:
        """Unarchive a containerized extractor.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'extractorRid': quote(str(_conjure_encoder.default(extractor_rid)), safe=''),
        }

        _json: Any = None

        _path = '/extractors/v1/container/{extractorRid}/unarchive'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return


ingest_api_ContainerizedExtractorService.__name__ = "ContainerizedExtractorService"
ingest_api_ContainerizedExtractorService.__qualname__ = "ContainerizedExtractorService"
ingest_api_ContainerizedExtractorService.__module__ = "nominal_api.ingest_api"


class ingest_api_ContainerizedOpts(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'sources': ConjureFieldDefinition('sources', Dict[ingest_api_EnvironmentVariable, ingest_api_IngestSource]),
            'arguments': ConjureFieldDefinition('arguments', Dict[ingest_api_EnvironmentVariable, str]),
            'extractor_rid': ConjureFieldDefinition('extractorRid', ingest_api_ContainerizedExtractorRid),
            'tag': ConjureFieldDefinition('tag', OptionalTypeWrapper[str]),
            'target': ConjureFieldDefinition('target', ingest_api_DatasetIngestTarget)
        }

    __slots__: List[str] = ['_sources', '_arguments', '_extractor_rid', '_tag', '_target']

    def __init__(self, arguments: Dict[str, str], extractor_rid: str, sources: Dict[str, "ingest_api_IngestSource"], target: "ingest_api_DatasetIngestTarget", tag: Optional[str] = None) -> None:
        self._sources = sources
        self._arguments = arguments
        self._extractor_rid = extractor_rid
        self._tag = tag
        self._target = target

    @builtins.property
    def sources(self) -> Dict[str, "ingest_api_IngestSource"]:
        return self._sources

    @builtins.property
    def arguments(self) -> Dict[str, str]:
        return self._arguments

    @builtins.property
    def extractor_rid(self) -> str:
        return self._extractor_rid

    @builtins.property
    def tag(self) -> Optional[str]:
        return self._tag

    @builtins.property
    def target(self) -> "ingest_api_DatasetIngestTarget":
        return self._target


ingest_api_ContainerizedOpts.__name__ = "ContainerizedOpts"
ingest_api_ContainerizedOpts.__qualname__ = "ContainerizedOpts"
ingest_api_ContainerizedOpts.__module__ = "nominal_api.ingest_api"


class ingest_api_CsvOpts(ConjureBeanType):
    """Options for ingesting csv files.  Supported file formats include .csv, .csv.gz
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'source': ConjureFieldDefinition('source', ingest_api_IngestSource),
            'target': ConjureFieldDefinition('target', ingest_api_DatasetIngestTarget),
            'timestamp_metadata': ConjureFieldDefinition('timestampMetadata', ingest_api_TimestampMetadata),
            'channel_prefix': ConjureFieldDefinition('channelPrefix', ingest_api_ChannelPrefix),
            'tag_keys_from_columns': ConjureFieldDefinition('tagKeysFromColumns', OptionalTypeWrapper[List[api_TagName]]),
            'tag_columns': ConjureFieldDefinition('tagColumns', OptionalTypeWrapper[Dict[api_TagName, api_ColumnName]]),
            'additional_file_tags': ConjureFieldDefinition('additionalFileTags', OptionalTypeWrapper[Dict[api_TagName, api_TagValue]])
        }

    __slots__: List[str] = ['_source', '_target', '_timestamp_metadata', '_channel_prefix', '_tag_keys_from_columns', '_tag_columns', '_additional_file_tags']

    def __init__(self, source: "ingest_api_IngestSource", target: "ingest_api_DatasetIngestTarget", timestamp_metadata: "ingest_api_TimestampMetadata", additional_file_tags: Optional[Dict[str, str]] = None, channel_prefix: Optional[str] = None, tag_columns: Optional[Dict[str, str]] = None, tag_keys_from_columns: Optional[List[str]] = None) -> None:
        self._source = source
        self._target = target
        self._timestamp_metadata = timestamp_metadata
        self._channel_prefix = channel_prefix
        self._tag_keys_from_columns = tag_keys_from_columns
        self._tag_columns = tag_columns
        self._additional_file_tags = additional_file_tags

    @builtins.property
    def source(self) -> "ingest_api_IngestSource":
        return self._source

    @builtins.property
    def target(self) -> "ingest_api_DatasetIngestTarget":
        return self._target

    @builtins.property
    def timestamp_metadata(self) -> "ingest_api_TimestampMetadata":
        return self._timestamp_metadata

    @builtins.property
    def channel_prefix(self) -> Optional[str]:
        return self._channel_prefix

    @builtins.property
    def tag_keys_from_columns(self) -> Optional[List[str]]:
        return self._tag_keys_from_columns

    @builtins.property
    def tag_columns(self) -> Optional[Dict[str, str]]:
        """A map of tag names to column names to derive the tag values from.
        """
        return self._tag_columns

    @builtins.property
    def additional_file_tags(self) -> Optional[Dict[str, str]]:
        """Specifies a tag set to apply to all data in the file.
        """
        return self._additional_file_tags


ingest_api_CsvOpts.__name__ = "CsvOpts"
ingest_api_CsvOpts.__qualname__ = "CsvOpts"
ingest_api_CsvOpts.__module__ = "nominal_api.ingest_api"


class ingest_api_CustomTimestamp(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'format': ConjureFieldDefinition('format', str),
            'default_year': ConjureFieldDefinition('defaultYear', OptionalTypeWrapper[int]),
            'default_day_of_year': ConjureFieldDefinition('defaultDayOfYear', OptionalTypeWrapper[int])
        }

    __slots__: List[str] = ['_format', '_default_year', '_default_day_of_year']

    def __init__(self, format: str, default_day_of_year: Optional[int] = None, default_year: Optional[int] = None) -> None:
        self._format = format
        self._default_year = default_year
        self._default_day_of_year = default_day_of_year

    @builtins.property
    def format(self) -> str:
        """The format string should be in the format of the `DateTimeFormatter` class in Java.
        """
        return self._format

    @builtins.property
    def default_year(self) -> Optional[int]:
        """Default year is accepted as an optional field for cases like IRIG time format and will be overridden by year in time format.
        """
        return self._default_year

    @builtins.property
    def default_day_of_year(self) -> Optional[int]:
        """Default day of year is accepted as an optional field for cases like IRIG time format and will be overridden by day of year in time format.
        """
        return self._default_day_of_year


ingest_api_CustomTimestamp.__name__ = "CustomTimestamp"
ingest_api_CustomTimestamp.__qualname__ = "CustomTimestamp"
ingest_api_CustomTimestamp.__module__ = "nominal_api.ingest_api"


class ingest_api_DataflashOpts(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'source': ConjureFieldDefinition('source', ingest_api_IngestSource),
            'target': ConjureFieldDefinition('target', ingest_api_DatasetIngestTarget)
        }

    __slots__: List[str] = ['_source', '_target']

    def __init__(self, source: "ingest_api_IngestSource", target: "ingest_api_DatasetIngestTarget") -> None:
        self._source = source
        self._target = target

    @builtins.property
    def source(self) -> "ingest_api_IngestSource":
        return self._source

    @builtins.property
    def target(self) -> "ingest_api_DatasetIngestTarget":
        return self._target


ingest_api_DataflashOpts.__name__ = "DataflashOpts"
ingest_api_DataflashOpts.__qualname__ = "DataflashOpts"
ingest_api_DataflashOpts.__module__ = "nominal_api.ingest_api"


class ingest_api_DatasetIngestTarget(ConjureUnionType):
    _new: Optional["ingest_api_NewDatasetIngestDestination"] = None
    _existing: Optional["ingest_api_ExistingDatasetIngestDestination"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'new': ConjureFieldDefinition('new', ingest_api_NewDatasetIngestDestination),
            'existing': ConjureFieldDefinition('existing', ingest_api_ExistingDatasetIngestDestination)
        }

    def __init__(
            self,
            new: Optional["ingest_api_NewDatasetIngestDestination"] = None,
            existing: Optional["ingest_api_ExistingDatasetIngestDestination"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (new is not None) + (existing is not None) != 1:
                raise ValueError('a union must contain a single member')

            if new is not None:
                self._new = new
                self._type = 'new'
            if existing is not None:
                self._existing = existing
                self._type = 'existing'

        elif type_of_union == 'new':
            if new is None:
                raise ValueError('a union value must not be None')
            self._new = new
            self._type = 'new'
        elif type_of_union == 'existing':
            if existing is None:
                raise ValueError('a union value must not be None')
            self._existing = existing
            self._type = 'existing'

    @builtins.property
    def new(self) -> Optional["ingest_api_NewDatasetIngestDestination"]:
        return self._new

    @builtins.property
    def existing(self) -> Optional["ingest_api_ExistingDatasetIngestDestination"]:
        return self._existing

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_DatasetIngestTargetVisitor):
            raise ValueError('{} is not an instance of ingest_api_DatasetIngestTargetVisitor'.format(visitor.__class__.__name__))
        if self._type == 'new' and self.new is not None:
            return visitor._new(self.new)
        if self._type == 'existing' and self.existing is not None:
            return visitor._existing(self.existing)


ingest_api_DatasetIngestTarget.__name__ = "DatasetIngestTarget"
ingest_api_DatasetIngestTarget.__qualname__ = "DatasetIngestTarget"
ingest_api_DatasetIngestTarget.__module__ = "nominal_api.ingest_api"


class ingest_api_DatasetIngestTargetVisitor:

    @abstractmethod
    def _new(self, new: "ingest_api_NewDatasetIngestDestination") -> Any:
        pass

    @abstractmethod
    def _existing(self, existing: "ingest_api_ExistingDatasetIngestDestination") -> Any:
        pass


ingest_api_DatasetIngestTargetVisitor.__name__ = "DatasetIngestTargetVisitor"
ingest_api_DatasetIngestTargetVisitor.__qualname__ = "DatasetIngestTargetVisitor"
ingest_api_DatasetIngestTargetVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_DatasetSpec(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', OptionalTypeWrapper[str])
        }

    __slots__: List[str] = ['_name']

    def __init__(self, name: Optional[str] = None) -> None:
        self._name = name

    @builtins.property
    def name(self) -> Optional[str]:
        return self._name


ingest_api_DatasetSpec.__name__ = "DatasetSpec"
ingest_api_DatasetSpec.__qualname__ = "DatasetSpec"
ingest_api_DatasetSpec.__module__ = "nominal_api.ingest_api"


class ingest_api_DeprecatedNewCsv(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'source': ConjureFieldDefinition('source', ingest_api_IngestSource),
            'name': ConjureFieldDefinition('name', OptionalTypeWrapper[str]),
            'properties': ConjureFieldDefinition('properties', Dict[str, str]),
            'time_column_spec': ConjureFieldDefinition('timeColumnSpec', OptionalTypeWrapper[ingest_api_TimestampMetadata]),
            'channel_config': ConjureFieldDefinition('channelConfig', OptionalTypeWrapper[ingest_api_ChannelConfig])
        }

    __slots__: List[str] = ['_source', '_name', '_properties', '_time_column_spec', '_channel_config']

    def __init__(self, properties: Dict[str, str], source: "ingest_api_IngestSource", channel_config: Optional["ingest_api_ChannelConfig"] = None, name: Optional[str] = None, time_column_spec: Optional["ingest_api_TimestampMetadata"] = None) -> None:
        self._source = source
        self._name = name
        self._properties = properties
        self._time_column_spec = time_column_spec
        self._channel_config = channel_config

    @builtins.property
    def source(self) -> "ingest_api_IngestSource":
        return self._source

    @builtins.property
    def name(self) -> Optional[str]:
        return self._name

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def time_column_spec(self) -> Optional["ingest_api_TimestampMetadata"]:
        return self._time_column_spec

    @builtins.property
    def channel_config(self) -> Optional["ingest_api_ChannelConfig"]:
        return self._channel_config


ingest_api_DeprecatedNewCsv.__name__ = "DeprecatedNewCsv"
ingest_api_DeprecatedNewCsv.__qualname__ = "DeprecatedNewCsv"
ingest_api_DeprecatedNewCsv.__module__ = "nominal_api.ingest_api"


class ingest_api_DeprecatedNewDataSource(ConjureUnionType):
    _csv: Optional["ingest_api_DeprecatedNewCsv"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'csv': ConjureFieldDefinition('csv', ingest_api_DeprecatedNewCsv)
        }

    def __init__(
            self,
            csv: Optional["ingest_api_DeprecatedNewCsv"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (csv is not None) != 1:
                raise ValueError('a union must contain a single member')

            if csv is not None:
                self._csv = csv
                self._type = 'csv'

        elif type_of_union == 'csv':
            if csv is None:
                raise ValueError('a union value must not be None')
            self._csv = csv
            self._type = 'csv'

    @builtins.property
    def csv(self) -> Optional["ingest_api_DeprecatedNewCsv"]:
        return self._csv

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_DeprecatedNewDataSourceVisitor):
            raise ValueError('{} is not an instance of ingest_api_DeprecatedNewDataSourceVisitor'.format(visitor.__class__.__name__))
        if self._type == 'csv' and self.csv is not None:
            return visitor._csv(self.csv)


ingest_api_DeprecatedNewDataSource.__name__ = "DeprecatedNewDataSource"
ingest_api_DeprecatedNewDataSource.__qualname__ = "DeprecatedNewDataSource"
ingest_api_DeprecatedNewDataSource.__module__ = "nominal_api.ingest_api"


class ingest_api_DeprecatedNewDataSourceVisitor:

    @abstractmethod
    def _csv(self, csv: "ingest_api_DeprecatedNewCsv") -> Any:
        pass


ingest_api_DeprecatedNewDataSourceVisitor.__name__ = "DeprecatedNewDataSourceVisitor"
ingest_api_DeprecatedNewDataSourceVisitor.__qualname__ = "DeprecatedNewDataSourceVisitor"
ingest_api_DeprecatedNewDataSourceVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_DockerImageSource(ConjureBeanType):
    """Docker container image source definition.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'registry': ConjureFieldDefinition('registry', str),
            'repository': ConjureFieldDefinition('repository', str),
            'tag_details': ConjureFieldDefinition('tagDetails', ingest_api_TagDetails),
            'authentication': ConjureFieldDefinition('authentication', ingest_api_Authentication),
            'command': ConjureFieldDefinition('command', OptionalTypeWrapper[str])
        }

    __slots__: List[str] = ['_registry', '_repository', '_tag_details', '_authentication', '_command']

    def __init__(self, authentication: "ingest_api_Authentication", registry: str, repository: str, tag_details: "ingest_api_TagDetails", command: Optional[str] = None) -> None:
        self._registry = registry
        self._repository = repository
        self._tag_details = tag_details
        self._authentication = authentication
        self._command = command

    @builtins.property
    def registry(self) -> str:
        """The container registry where the image is hosted.
        """
        return self._registry

    @builtins.property
    def repository(self) -> str:
        """The repository name of the image.
        """
        return self._repository

    @builtins.property
    def tag_details(self) -> "ingest_api_TagDetails":
        return self._tag_details

    @builtins.property
    def authentication(self) -> "ingest_api_Authentication":
        """Optional authentication for accessing private container registries.
        """
        return self._authentication

    @builtins.property
    def command(self) -> Optional[str]:
        return self._command


ingest_api_DockerImageSource.__name__ = "DockerImageSource"
ingest_api_DockerImageSource.__qualname__ = "DockerImageSource"
ingest_api_DockerImageSource.__module__ = "nominal_api.ingest_api"


class ingest_api_EpochTimestamp(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'time_unit': ConjureFieldDefinition('timeUnit', api_TimeUnit)
        }

    __slots__: List[str] = ['_time_unit']

    def __init__(self, time_unit: "api_TimeUnit") -> None:
        self._time_unit = time_unit

    @builtins.property
    def time_unit(self) -> "api_TimeUnit":
        return self._time_unit


ingest_api_EpochTimestamp.__name__ = "EpochTimestamp"
ingest_api_EpochTimestamp.__qualname__ = "EpochTimestamp"
ingest_api_EpochTimestamp.__module__ = "nominal_api.ingest_api"


class ingest_api_ExistingDatasetIngestDestination(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'dataset_rid': ConjureFieldDefinition('datasetRid', str),
            'expand_run_bounds': ConjureFieldDefinition('expandRunBounds', OptionalTypeWrapper[List[scout_run_api_RunRid]])
        }

    __slots__: List[str] = ['_dataset_rid', '_expand_run_bounds']

    def __init__(self, dataset_rid: str, expand_run_bounds: Optional[List[str]] = None) -> None:
        self._dataset_rid = dataset_rid
        self._expand_run_bounds = expand_run_bounds

    @builtins.property
    def dataset_rid(self) -> str:
        return self._dataset_rid

    @builtins.property
    def expand_run_bounds(self) -> Optional[List[str]]:
        """The ingest will keep track of the range of timestamps in the ingested data and update the included
run's time bounds.
For runs with no end time (uninitialized), it will always set the start time to the file's start time
and set the end time to the file's end time.
For runs with existing end times, it will only expand the bounds (earliest start time, latest end time).
        """
        return self._expand_run_bounds


ingest_api_ExistingDatasetIngestDestination.__name__ = "ExistingDatasetIngestDestination"
ingest_api_ExistingDatasetIngestDestination.__qualname__ = "ExistingDatasetIngestDestination"
ingest_api_ExistingDatasetIngestDestination.__module__ = "nominal_api.ingest_api"


class ingest_api_ExistingVideoIngestDestination(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'video_rid': ConjureFieldDefinition('videoRid', api_rids_VideoRid),
            'video_file_details': ConjureFieldDefinition('videoFileDetails', OptionalTypeWrapper[ingest_api_VideoFileIngestDetails])
        }

    __slots__: List[str] = ['_video_rid', '_video_file_details']

    def __init__(self, video_rid: str, video_file_details: Optional["ingest_api_VideoFileIngestDetails"] = None) -> None:
        self._video_rid = video_rid
        self._video_file_details = video_file_details

    @builtins.property
    def video_rid(self) -> str:
        """RID of the video to ingest the newly created video file to.
        """
        return self._video_rid

    @builtins.property
    def video_file_details(self) -> Optional["ingest_api_VideoFileIngestDetails"]:
        """Metadata to associate with any created video file
        """
        return self._video_file_details


ingest_api_ExistingVideoIngestDestination.__name__ = "ExistingVideoIngestDestination"
ingest_api_ExistingVideoIngestDestination.__qualname__ = "ExistingVideoIngestDestination"
ingest_api_ExistingVideoIngestDestination.__module__ = "nominal_api.ingest_api"


class ingest_api_FileExtractionInput(ConjureBeanType):
    """Defines an input file to be provided to the extractor.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'environment_variable': ConjureFieldDefinition('environmentVariable', ingest_api_EnvironmentVariable),
            'name': ConjureFieldDefinition('name', str),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'file_filters': ConjureFieldDefinition('fileFilters', List[ingest_api_FileFilter]),
            'required': ConjureFieldDefinition('required', OptionalTypeWrapper[bool])
        }

    __slots__: List[str] = ['_environment_variable', '_name', '_description', '_file_filters', '_required']

    def __init__(self, environment_variable: str, file_filters: List["ingest_api_FileFilter"], name: str, description: Optional[str] = None, required: Optional[bool] = None) -> None:
        self._environment_variable = environment_variable
        self._name = name
        self._description = description
        self._file_filters = file_filters
        self._required = required

    @builtins.property
    def environment_variable(self) -> str:
        """The environment variable that stores the path to the input file.
        """
        return self._environment_variable

    @builtins.property
    def name(self) -> str:
        """Name of the input file which users will be prompted with
        """
        return self._name

    @builtins.property
    def description(self) -> Optional[str]:
        """Description of the input file which users will be prompted with
        """
        return self._description

    @builtins.property
    def file_filters(self) -> List["ingest_api_FileFilter"]:
        """Optionally filter files for file selection
        """
        return self._file_filters

    @builtins.property
    def required(self) -> Optional[bool]:
        """Whether the input file is required for the extractor to run.
        """
        return self._required


ingest_api_FileExtractionInput.__name__ = "FileExtractionInput"
ingest_api_FileExtractionInput.__qualname__ = "FileExtractionInput"
ingest_api_FileExtractionInput.__module__ = "nominal_api.ingest_api"


class ingest_api_FileExtractionParameter(ConjureBeanType):
    """Defines an input parameter to be provided to the extractor.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'environment_variable': ConjureFieldDefinition('environmentVariable', ingest_api_EnvironmentVariable),
            'name': ConjureFieldDefinition('name', str),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'required': ConjureFieldDefinition('required', OptionalTypeWrapper[bool])
        }

    __slots__: List[str] = ['_environment_variable', '_name', '_description', '_required']

    def __init__(self, environment_variable: str, name: str, description: Optional[str] = None, required: Optional[bool] = None) -> None:
        self._environment_variable = environment_variable
        self._name = name
        self._description = description
        self._required = required

    @builtins.property
    def environment_variable(self) -> str:
        """The environment variable that stores the argument
        """
        return self._environment_variable

    @builtins.property
    def name(self) -> str:
        """Name of the parameter which users will be prompted with
        """
        return self._name

    @builtins.property
    def description(self) -> Optional[str]:
        """Description of the parameter which users will be prompted with
        """
        return self._description

    @builtins.property
    def required(self) -> Optional[bool]:
        """Whether the parameter is required for the extractor to run.
        """
        return self._required


ingest_api_FileExtractionParameter.__name__ = "FileExtractionParameter"
ingest_api_FileExtractionParameter.__qualname__ = "FileExtractionParameter"
ingest_api_FileExtractionParameter.__module__ = "nominal_api.ingest_api"


class ingest_api_FileFilter(ConjureUnionType):
    _suffix: Optional[str] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'suffix': ConjureFieldDefinition('suffix', ingest_api_FileSuffix)
        }

    def __init__(
            self,
            suffix: Optional[str] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (suffix is not None) != 1:
                raise ValueError('a union must contain a single member')

            if suffix is not None:
                self._suffix = suffix
                self._type = 'suffix'

        elif type_of_union == 'suffix':
            if suffix is None:
                raise ValueError('a union value must not be None')
            self._suffix = suffix
            self._type = 'suffix'

    @builtins.property
    def suffix(self) -> Optional[str]:
        return self._suffix

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_FileFilterVisitor):
            raise ValueError('{} is not an instance of ingest_api_FileFilterVisitor'.format(visitor.__class__.__name__))
        if self._type == 'suffix' and self.suffix is not None:
            return visitor._suffix(self.suffix)


ingest_api_FileFilter.__name__ = "FileFilter"
ingest_api_FileFilter.__qualname__ = "FileFilter"
ingest_api_FileFilter.__module__ = "nominal_api.ingest_api"


class ingest_api_FileFilterVisitor:

    @abstractmethod
    def _suffix(self, suffix: str) -> Any:
        pass


ingest_api_FileFilterVisitor.__name__ = "FileFilterVisitor"
ingest_api_FileFilterVisitor.__qualname__ = "FileFilterVisitor"
ingest_api_FileFilterVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_FileOutputFormat(ConjureEnumType):

    PARQUET = 'PARQUET'
    '''PARQUET'''
    CSV = 'CSV'
    '''CSV'''
    PARQUET_TAR = 'PARQUET_TAR'
    '''PARQUET_TAR'''
    AVRO_STREAM = 'AVRO_STREAM'
    '''AVRO_STREAM'''
    JSON_L = 'JSON_L'
    '''JSON_L'''
    MANIFEST = 'MANIFEST'
    '''MANIFEST'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


ingest_api_FileOutputFormat.__name__ = "FileOutputFormat"
ingest_api_FileOutputFormat.__qualname__ = "FileOutputFormat"
ingest_api_FileOutputFormat.__module__ = "nominal_api.ingest_api"


class ingest_api_GcsIngestSource(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'path': ConjureFieldDefinition('path', str)
        }

    __slots__: List[str] = ['_path']

    def __init__(self, path: str) -> None:
        self._path = path

    @builtins.property
    def path(self) -> str:
        return self._path


ingest_api_GcsIngestSource.__name__ = "GcsIngestSource"
ingest_api_GcsIngestSource.__qualname__ = "GcsIngestSource"
ingest_api_GcsIngestSource.__module__ = "nominal_api.ingest_api"


class ingest_api_GetContainerizedExtractorsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'extractor_rids': ConjureFieldDefinition('extractorRids', List[ingest_api_ContainerizedExtractorRid])
        }

    __slots__: List[str] = ['_extractor_rids']

    def __init__(self, extractor_rids: List[str]) -> None:
        self._extractor_rids = extractor_rids

    @builtins.property
    def extractor_rids(self) -> List[str]:
        return self._extractor_rids


ingest_api_GetContainerizedExtractorsRequest.__name__ = "GetContainerizedExtractorsRequest"
ingest_api_GetContainerizedExtractorsRequest.__qualname__ = "GetContainerizedExtractorsRequest"
ingest_api_GetContainerizedExtractorsRequest.__module__ = "nominal_api.ingest_api"


class ingest_api_GetContainerizedExtractorsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'extractors': ConjureFieldDefinition('extractors', List[ingest_api_ContainerizedExtractor])
        }

    __slots__: List[str] = ['_extractors']

    def __init__(self, extractors: List["ingest_api_ContainerizedExtractor"]) -> None:
        self._extractors = extractors

    @builtins.property
    def extractors(self) -> List["ingest_api_ContainerizedExtractor"]:
        return self._extractors


ingest_api_GetContainerizedExtractorsResponse.__name__ = "GetContainerizedExtractorsResponse"
ingest_api_GetContainerizedExtractorsResponse.__qualname__ = "GetContainerizedExtractorsResponse"
ingest_api_GetContainerizedExtractorsResponse.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestDataSource(ConjureUnionType):
    _existing_data_source: Optional[str] = None
    _new_data_source: Optional["ingest_api_DeprecatedNewDataSource"] = None
    _new_data_source_v2: Optional["ingest_api_NewDataSource"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'existing_data_source': ConjureFieldDefinition('existingDataSource', api_rids_DataSourceRid),
            'new_data_source': ConjureFieldDefinition('newDataSource', ingest_api_DeprecatedNewDataSource),
            'new_data_source_v2': ConjureFieldDefinition('newDataSourceV2', ingest_api_NewDataSource)
        }

    def __init__(
            self,
            existing_data_source: Optional[str] = None,
            new_data_source: Optional["ingest_api_DeprecatedNewDataSource"] = None,
            new_data_source_v2: Optional["ingest_api_NewDataSource"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (existing_data_source is not None) + (new_data_source is not None) + (new_data_source_v2 is not None) != 1:
                raise ValueError('a union must contain a single member')

            if existing_data_source is not None:
                self._existing_data_source = existing_data_source
                self._type = 'existingDataSource'
            if new_data_source is not None:
                self._new_data_source = new_data_source
                self._type = 'newDataSource'
            if new_data_source_v2 is not None:
                self._new_data_source_v2 = new_data_source_v2
                self._type = 'newDataSourceV2'

        elif type_of_union == 'existingDataSource':
            if existing_data_source is None:
                raise ValueError('a union value must not be None')
            self._existing_data_source = existing_data_source
            self._type = 'existingDataSource'
        elif type_of_union == 'newDataSource':
            if new_data_source is None:
                raise ValueError('a union value must not be None')
            self._new_data_source = new_data_source
            self._type = 'newDataSource'
        elif type_of_union == 'newDataSourceV2':
            if new_data_source_v2 is None:
                raise ValueError('a union value must not be None')
            self._new_data_source_v2 = new_data_source_v2
            self._type = 'newDataSourceV2'

    @builtins.property
    def existing_data_source(self) -> Optional[str]:
        return self._existing_data_source

    @builtins.property
    def new_data_source(self) -> Optional["ingest_api_DeprecatedNewDataSource"]:
        return self._new_data_source

    @builtins.property
    def new_data_source_v2(self) -> Optional["ingest_api_NewDataSource"]:
        return self._new_data_source_v2

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_IngestDataSourceVisitor):
            raise ValueError('{} is not an instance of ingest_api_IngestDataSourceVisitor'.format(visitor.__class__.__name__))
        if self._type == 'existingDataSource' and self.existing_data_source is not None:
            return visitor._existing_data_source(self.existing_data_source)
        if self._type == 'newDataSource' and self.new_data_source is not None:
            return visitor._new_data_source(self.new_data_source)
        if self._type == 'newDataSourceV2' and self.new_data_source_v2 is not None:
            return visitor._new_data_source_v2(self.new_data_source_v2)


ingest_api_IngestDataSource.__name__ = "IngestDataSource"
ingest_api_IngestDataSource.__qualname__ = "IngestDataSource"
ingest_api_IngestDataSource.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestDataSourceVisitor:

    @abstractmethod
    def _existing_data_source(self, existing_data_source: str) -> Any:
        pass

    @abstractmethod
    def _new_data_source(self, new_data_source: "ingest_api_DeprecatedNewDataSource") -> Any:
        pass

    @abstractmethod
    def _new_data_source_v2(self, new_data_source_v2: "ingest_api_NewDataSource") -> Any:
        pass


ingest_api_IngestDataSourceVisitor.__name__ = "IngestDataSourceVisitor"
ingest_api_IngestDataSourceVisitor.__qualname__ = "IngestDataSourceVisitor"
ingest_api_IngestDataSourceVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestDatasetFileDetails(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'dataset_file_id': ConjureFieldDefinition('datasetFileId', str),
            'dataset_rid': ConjureFieldDefinition('datasetRid', api_rids_DatasetRid)
        }

    __slots__: List[str] = ['_dataset_file_id', '_dataset_rid']

    def __init__(self, dataset_file_id: str, dataset_rid: str) -> None:
        self._dataset_file_id = dataset_file_id
        self._dataset_rid = dataset_rid

    @builtins.property
    def dataset_file_id(self) -> str:
        return self._dataset_file_id

    @builtins.property
    def dataset_rid(self) -> str:
        return self._dataset_rid


ingest_api_IngestDatasetFileDetails.__name__ = "IngestDatasetFileDetails"
ingest_api_IngestDatasetFileDetails.__qualname__ = "IngestDatasetFileDetails"
ingest_api_IngestDatasetFileDetails.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestDestination(ConjureUnionType):
    _new_dataset: Optional["ingest_api_NewDatasetIngestDestination"] = None
    _existing_dataset: Optional["ingest_api_ExistingDatasetIngestDestination"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'new_dataset': ConjureFieldDefinition('newDataset', ingest_api_NewDatasetIngestDestination),
            'existing_dataset': ConjureFieldDefinition('existingDataset', ingest_api_ExistingDatasetIngestDestination)
        }

    def __init__(
            self,
            new_dataset: Optional["ingest_api_NewDatasetIngestDestination"] = None,
            existing_dataset: Optional["ingest_api_ExistingDatasetIngestDestination"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (new_dataset is not None) + (existing_dataset is not None) != 1:
                raise ValueError('a union must contain a single member')

            if new_dataset is not None:
                self._new_dataset = new_dataset
                self._type = 'newDataset'
            if existing_dataset is not None:
                self._existing_dataset = existing_dataset
                self._type = 'existingDataset'

        elif type_of_union == 'newDataset':
            if new_dataset is None:
                raise ValueError('a union value must not be None')
            self._new_dataset = new_dataset
            self._type = 'newDataset'
        elif type_of_union == 'existingDataset':
            if existing_dataset is None:
                raise ValueError('a union value must not be None')
            self._existing_dataset = existing_dataset
            self._type = 'existingDataset'

    @builtins.property
    def new_dataset(self) -> Optional["ingest_api_NewDatasetIngestDestination"]:
        return self._new_dataset

    @builtins.property
    def existing_dataset(self) -> Optional["ingest_api_ExistingDatasetIngestDestination"]:
        return self._existing_dataset

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_IngestDestinationVisitor):
            raise ValueError('{} is not an instance of ingest_api_IngestDestinationVisitor'.format(visitor.__class__.__name__))
        if self._type == 'newDataset' and self.new_dataset is not None:
            return visitor._new_dataset(self.new_dataset)
        if self._type == 'existingDataset' and self.existing_dataset is not None:
            return visitor._existing_dataset(self.existing_dataset)


ingest_api_IngestDestination.__name__ = "IngestDestination"
ingest_api_IngestDestination.__qualname__ = "IngestDestination"
ingest_api_IngestDestination.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestDestinationVisitor:

    @abstractmethod
    def _new_dataset(self, new_dataset: "ingest_api_NewDatasetIngestDestination") -> Any:
        pass

    @abstractmethod
    def _existing_dataset(self, existing_dataset: "ingest_api_ExistingDatasetIngestDestination") -> Any:
        pass


ingest_api_IngestDestinationVisitor.__name__ = "IngestDestinationVisitor"
ingest_api_IngestDestinationVisitor.__qualname__ = "IngestDestinationVisitor"
ingest_api_IngestDestinationVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestDetails(ConjureUnionType):
    _dataset: Optional["ingest_api_IngestDatasetFileDetails"] = None
    _video: Optional["ingest_api_IngestVideoFileDetails"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'dataset': ConjureFieldDefinition('dataset', ingest_api_IngestDatasetFileDetails),
            'video': ConjureFieldDefinition('video', ingest_api_IngestVideoFileDetails)
        }

    def __init__(
            self,
            dataset: Optional["ingest_api_IngestDatasetFileDetails"] = None,
            video: Optional["ingest_api_IngestVideoFileDetails"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (dataset is not None) + (video is not None) != 1:
                raise ValueError('a union must contain a single member')

            if dataset is not None:
                self._dataset = dataset
                self._type = 'dataset'
            if video is not None:
                self._video = video
                self._type = 'video'

        elif type_of_union == 'dataset':
            if dataset is None:
                raise ValueError('a union value must not be None')
            self._dataset = dataset
            self._type = 'dataset'
        elif type_of_union == 'video':
            if video is None:
                raise ValueError('a union value must not be None')
            self._video = video
            self._type = 'video'

    @builtins.property
    def dataset(self) -> Optional["ingest_api_IngestDatasetFileDetails"]:
        return self._dataset

    @builtins.property
    def video(self) -> Optional["ingest_api_IngestVideoFileDetails"]:
        return self._video

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_IngestDetailsVisitor):
            raise ValueError('{} is not an instance of ingest_api_IngestDetailsVisitor'.format(visitor.__class__.__name__))
        if self._type == 'dataset' and self.dataset is not None:
            return visitor._dataset(self.dataset)
        if self._type == 'video' and self.video is not None:
            return visitor._video(self.video)


ingest_api_IngestDetails.__name__ = "IngestDetails"
ingest_api_IngestDetails.__qualname__ = "IngestDetails"
ingest_api_IngestDetails.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestDetailsVisitor:

    @abstractmethod
    def _dataset(self, dataset: "ingest_api_IngestDatasetFileDetails") -> Any:
        pass

    @abstractmethod
    def _video(self, video: "ingest_api_IngestVideoFileDetails") -> Any:
        pass


ingest_api_IngestDetailsVisitor.__name__ = "IngestDetailsVisitor"
ingest_api_IngestDetailsVisitor.__qualname__ = "IngestDetailsVisitor"
ingest_api_IngestDetailsVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestJob(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'ingest_job_rid': ConjureFieldDefinition('ingestJobRid', ingest_api_IngestJobRid),
            'status': ConjureFieldDefinition('status', ingest_api_IngestJobStatus),
            'ingest_job_request': ConjureFieldDefinition('ingestJobRequest', ingest_api_IngestJobRequest),
            'origin_files': ConjureFieldDefinition('originFiles', OptionalTypeWrapper[List[str]]),
            'created_by': ConjureFieldDefinition('createdBy', str),
            'org_uuid': ConjureFieldDefinition('orgUuid', str),
            'ingest_type': ConjureFieldDefinition('ingestType', ingest_api_IngestType)
        }

    __slots__: List[str] = ['_ingest_job_rid', '_status', '_ingest_job_request', '_origin_files', '_created_by', '_org_uuid', '_ingest_type']

    def __init__(self, created_by: str, ingest_job_request: "ingest_api_IngestJobRequest", ingest_job_rid: str, ingest_type: "ingest_api_IngestType", org_uuid: str, status: "ingest_api_IngestJobStatus", origin_files: Optional[List[str]] = None) -> None:
        self._ingest_job_rid = ingest_job_rid
        self._status = status
        self._ingest_job_request = ingest_job_request
        self._origin_files = origin_files
        self._created_by = created_by
        self._org_uuid = org_uuid
        self._ingest_type = ingest_type

    @builtins.property
    def ingest_job_rid(self) -> str:
        return self._ingest_job_rid

    @builtins.property
    def status(self) -> "ingest_api_IngestJobStatus":
        return self._status

    @builtins.property
    def ingest_job_request(self) -> "ingest_api_IngestJobRequest":
        return self._ingest_job_request

    @builtins.property
    def origin_files(self) -> Optional[List[str]]:
        return self._origin_files

    @builtins.property
    def created_by(self) -> str:
        return self._created_by

    @builtins.property
    def org_uuid(self) -> str:
        return self._org_uuid

    @builtins.property
    def ingest_type(self) -> "ingest_api_IngestType":
        return self._ingest_type


ingest_api_IngestJob.__name__ = "IngestJob"
ingest_api_IngestJob.__qualname__ = "IngestJob"
ingest_api_IngestJob.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestJobRequest(ConjureUnionType):
    _ingest_request: Optional["ingest_api_IngestRequest"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'ingest_request': ConjureFieldDefinition('ingestRequest', ingest_api_IngestRequest)
        }

    def __init__(
            self,
            ingest_request: Optional["ingest_api_IngestRequest"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (ingest_request is not None) != 1:
                raise ValueError('a union must contain a single member')

            if ingest_request is not None:
                self._ingest_request = ingest_request
                self._type = 'ingestRequest'

        elif type_of_union == 'ingestRequest':
            if ingest_request is None:
                raise ValueError('a union value must not be None')
            self._ingest_request = ingest_request
            self._type = 'ingestRequest'

    @builtins.property
    def ingest_request(self) -> Optional["ingest_api_IngestRequest"]:
        return self._ingest_request

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_IngestJobRequestVisitor):
            raise ValueError('{} is not an instance of ingest_api_IngestJobRequestVisitor'.format(visitor.__class__.__name__))
        if self._type == 'ingestRequest' and self.ingest_request is not None:
            return visitor._ingest_request(self.ingest_request)


ingest_api_IngestJobRequest.__name__ = "IngestJobRequest"
ingest_api_IngestJobRequest.__qualname__ = "IngestJobRequest"
ingest_api_IngestJobRequest.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestJobRequestVisitor:

    @abstractmethod
    def _ingest_request(self, ingest_request: "ingest_api_IngestRequest") -> Any:
        pass


ingest_api_IngestJobRequestVisitor.__name__ = "IngestJobRequestVisitor"
ingest_api_IngestJobRequestVisitor.__qualname__ = "IngestJobRequestVisitor"
ingest_api_IngestJobRequestVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestJobStatus(ConjureEnumType):

    SUBMITTED = 'SUBMITTED'
    '''SUBMITTED'''
    QUEUED = 'QUEUED'
    '''QUEUED'''
    IN_PROGRESS = 'IN_PROGRESS'
    '''IN_PROGRESS'''
    COMPLETED = 'COMPLETED'
    '''COMPLETED'''
    FAILED = 'FAILED'
    '''FAILED'''
    CANCELLED = 'CANCELLED'
    '''CANCELLED'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


ingest_api_IngestJobStatus.__name__ = "IngestJobStatus"
ingest_api_IngestJobStatus.__qualname__ = "IngestJobStatus"
ingest_api_IngestJobStatus.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestMcapRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'sources': ConjureFieldDefinition('sources', List[ingest_api_IngestSource]),
            'channel_config': ConjureFieldDefinition('channelConfig', List[ingest_api_McapChannelConfig]),
            'channels': ConjureFieldDefinition('channels', OptionalTypeWrapper[ingest_api_McapChannels]),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'title': ConjureFieldDefinition('title', OptionalTypeWrapper[str]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'workspace': ConjureFieldDefinition('workspace', OptionalTypeWrapper[api_rids_WorkspaceRid])
        }

    __slots__: List[str] = ['_sources', '_channel_config', '_channels', '_properties', '_labels', '_title', '_description', '_workspace']

    def __init__(self, channel_config: List["ingest_api_McapChannelConfig"], labels: List[str], properties: Dict[str, str], sources: List["ingest_api_IngestSource"], channels: Optional["ingest_api_McapChannels"] = None, description: Optional[str] = None, title: Optional[str] = None, workspace: Optional[str] = None) -> None:
        self._sources = sources
        self._channel_config = channel_config
        self._channels = channels
        self._properties = properties
        self._labels = labels
        self._title = title
        self._description = description
        self._workspace = workspace

    @builtins.property
    def sources(self) -> List["ingest_api_IngestSource"]:
        """List of files in S3 to be ingested. These should be ordered by time, as data will be ingested and
concatenated across all the files.
Note: only a single files are currently supported, this field is mostly for forward compatibility.
        """
        return self._sources

    @builtins.property
    def channel_config(self) -> List["ingest_api_McapChannelConfig"]:
        return self._channel_config

    @builtins.property
    def channels(self) -> Optional["ingest_api_McapChannels"]:
        """Config to define which channels in the mcap should be ingested. The default is to ingest only
channels with config, otherwise the mcap may not be supported.
        """
        return self._channels

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels

    @builtins.property
    def title(self) -> Optional[str]:
        return self._title

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def workspace(self) -> Optional[str]:
        """The workspace in which to create the dataset or video. If not provided, the dataset or video
will be created in the default workspace for the user's organization, if the default
workspace for the organization is configured.
        """
        return self._workspace


ingest_api_IngestMcapRequest.__name__ = "IngestMcapRequest"
ingest_api_IngestMcapRequest.__qualname__ = "IngestMcapRequest"
ingest_api_IngestMcapRequest.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestMcapResponse(ConjureBeanType):
    """Returns references to the data ingested from an MCAP file.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'outputs': ConjureFieldDefinition('outputs', List[ingest_api_McapIngestionOutput]),
            'async_handle': ConjureFieldDefinition('asyncHandle', OptionalTypeWrapper[ingest_api_AsyncHandle])
        }

    __slots__: List[str] = ['_outputs', '_async_handle']

    def __init__(self, outputs: List["ingest_api_McapIngestionOutput"], async_handle: Optional["ingest_api_AsyncHandle"] = None) -> None:
        self._outputs = outputs
        self._async_handle = async_handle

    @builtins.property
    def outputs(self) -> List["ingest_api_McapIngestionOutput"]:
        return self._outputs

    @builtins.property
    def async_handle(self) -> Optional["ingest_api_AsyncHandle"]:
        return self._async_handle


ingest_api_IngestMcapResponse.__name__ = "IngestMcapResponse"
ingest_api_IngestMcapResponse.__qualname__ = "IngestMcapResponse"
ingest_api_IngestMcapResponse.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestMetadata(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'timestamp_metadata': ConjureFieldDefinition('timestampMetadata', OptionalTypeWrapper[ingest_api_TimestampMetadata]),
            'channel_prefix': ConjureFieldDefinition('channelPrefix', OptionalTypeWrapper[str]),
            'tag_columns': ConjureFieldDefinition('tagColumns', OptionalTypeWrapper[Dict[api_TagName, api_ColumnName]]),
            'additional_file_tags': ConjureFieldDefinition('additionalFileTags', OptionalTypeWrapper[Dict[api_TagName, api_TagValue]])
        }

    __slots__: List[str] = ['_timestamp_metadata', '_channel_prefix', '_tag_columns', '_additional_file_tags']

    def __init__(self, additional_file_tags: Optional[Dict[str, str]] = None, channel_prefix: Optional[str] = None, tag_columns: Optional[Dict[str, str]] = None, timestamp_metadata: Optional["ingest_api_TimestampMetadata"] = None) -> None:
        self._timestamp_metadata = timestamp_metadata
        self._channel_prefix = channel_prefix
        self._tag_columns = tag_columns
        self._additional_file_tags = additional_file_tags

    @builtins.property
    def timestamp_metadata(self) -> Optional["ingest_api_TimestampMetadata"]:
        """The timestamp metadata will be recovered from the dataset files if possible.
Older datasets may have unrecoverable timestamp metadata.
If unrecoverable, reingestion will throw MissingMetadataForReingest if not provided in request.
        """
        return self._timestamp_metadata

    @builtins.property
    def channel_prefix(self) -> Optional[str]:
        """Channel prefix to use when reingesting the dataset.
Defaults to empty string. Not recoverable from prior ingests and must be provided in request if needed.
        """
        return self._channel_prefix

    @builtins.property
    def tag_columns(self) -> Optional[Dict[str, str]]:
        """A map of tag names to column names to derive the tag values from.
Not recoverable from prior ingests and must be provided in request if needed.
        """
        return self._tag_columns

    @builtins.property
    def additional_file_tags(self) -> Optional[Dict[str, str]]:
        """Additional tags to apply to all dataset files within the the given dataset.
Not recoverable from prior ingests and must be provided in request if needed.
        """
        return self._additional_file_tags


ingest_api_IngestMetadata.__name__ = "IngestMetadata"
ingest_api_IngestMetadata.__qualname__ = "IngestMetadata"
ingest_api_IngestMetadata.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestOptions(ConjureUnionType):
    _dataflash: Optional["ingest_api_DataflashOpts"] = None
    _mcap_protobuf_timeseries: Optional["ingest_api_McapProtobufTimeseriesOpts"] = None
    _journal_json: Optional["ingest_api_JournalJsonOpts"] = None
    _csv: Optional["ingest_api_CsvOpts"] = None
    _parquet: Optional["ingest_api_ParquetOpts"] = None
    _video: Optional["ingest_api_VideoOpts"] = None
    _containerized: Optional["ingest_api_ContainerizedOpts"] = None
    _avro_stream: Optional["ingest_api_AvroStreamOpts"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'dataflash': ConjureFieldDefinition('dataflash', ingest_api_DataflashOpts),
            'mcap_protobuf_timeseries': ConjureFieldDefinition('mcapProtobufTimeseries', ingest_api_McapProtobufTimeseriesOpts),
            'journal_json': ConjureFieldDefinition('journalJson', ingest_api_JournalJsonOpts),
            'csv': ConjureFieldDefinition('csv', ingest_api_CsvOpts),
            'parquet': ConjureFieldDefinition('parquet', ingest_api_ParquetOpts),
            'video': ConjureFieldDefinition('video', ingest_api_VideoOpts),
            'containerized': ConjureFieldDefinition('containerized', ingest_api_ContainerizedOpts),
            'avro_stream': ConjureFieldDefinition('avroStream', ingest_api_AvroStreamOpts)
        }

    def __init__(
            self,
            dataflash: Optional["ingest_api_DataflashOpts"] = None,
            mcap_protobuf_timeseries: Optional["ingest_api_McapProtobufTimeseriesOpts"] = None,
            journal_json: Optional["ingest_api_JournalJsonOpts"] = None,
            csv: Optional["ingest_api_CsvOpts"] = None,
            parquet: Optional["ingest_api_ParquetOpts"] = None,
            video: Optional["ingest_api_VideoOpts"] = None,
            containerized: Optional["ingest_api_ContainerizedOpts"] = None,
            avro_stream: Optional["ingest_api_AvroStreamOpts"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (dataflash is not None) + (mcap_protobuf_timeseries is not None) + (journal_json is not None) + (csv is not None) + (parquet is not None) + (video is not None) + (containerized is not None) + (avro_stream is not None) != 1:
                raise ValueError('a union must contain a single member')

            if dataflash is not None:
                self._dataflash = dataflash
                self._type = 'dataflash'
            if mcap_protobuf_timeseries is not None:
                self._mcap_protobuf_timeseries = mcap_protobuf_timeseries
                self._type = 'mcapProtobufTimeseries'
            if journal_json is not None:
                self._journal_json = journal_json
                self._type = 'journalJson'
            if csv is not None:
                self._csv = csv
                self._type = 'csv'
            if parquet is not None:
                self._parquet = parquet
                self._type = 'parquet'
            if video is not None:
                self._video = video
                self._type = 'video'
            if containerized is not None:
                self._containerized = containerized
                self._type = 'containerized'
            if avro_stream is not None:
                self._avro_stream = avro_stream
                self._type = 'avroStream'

        elif type_of_union == 'dataflash':
            if dataflash is None:
                raise ValueError('a union value must not be None')
            self._dataflash = dataflash
            self._type = 'dataflash'
        elif type_of_union == 'mcapProtobufTimeseries':
            if mcap_protobuf_timeseries is None:
                raise ValueError('a union value must not be None')
            self._mcap_protobuf_timeseries = mcap_protobuf_timeseries
            self._type = 'mcapProtobufTimeseries'
        elif type_of_union == 'journalJson':
            if journal_json is None:
                raise ValueError('a union value must not be None')
            self._journal_json = journal_json
            self._type = 'journalJson'
        elif type_of_union == 'csv':
            if csv is None:
                raise ValueError('a union value must not be None')
            self._csv = csv
            self._type = 'csv'
        elif type_of_union == 'parquet':
            if parquet is None:
                raise ValueError('a union value must not be None')
            self._parquet = parquet
            self._type = 'parquet'
        elif type_of_union == 'video':
            if video is None:
                raise ValueError('a union value must not be None')
            self._video = video
            self._type = 'video'
        elif type_of_union == 'containerized':
            if containerized is None:
                raise ValueError('a union value must not be None')
            self._containerized = containerized
            self._type = 'containerized'
        elif type_of_union == 'avroStream':
            if avro_stream is None:
                raise ValueError('a union value must not be None')
            self._avro_stream = avro_stream
            self._type = 'avroStream'

    @builtins.property
    def dataflash(self) -> Optional["ingest_api_DataflashOpts"]:
        return self._dataflash

    @builtins.property
    def mcap_protobuf_timeseries(self) -> Optional["ingest_api_McapProtobufTimeseriesOpts"]:
        return self._mcap_protobuf_timeseries

    @builtins.property
    def journal_json(self) -> Optional["ingest_api_JournalJsonOpts"]:
        return self._journal_json

    @builtins.property
    def csv(self) -> Optional["ingest_api_CsvOpts"]:
        return self._csv

    @builtins.property
    def parquet(self) -> Optional["ingest_api_ParquetOpts"]:
        return self._parquet

    @builtins.property
    def video(self) -> Optional["ingest_api_VideoOpts"]:
        return self._video

    @builtins.property
    def containerized(self) -> Optional["ingest_api_ContainerizedOpts"]:
        return self._containerized

    @builtins.property
    def avro_stream(self) -> Optional["ingest_api_AvroStreamOpts"]:
        return self._avro_stream

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_IngestOptionsVisitor):
            raise ValueError('{} is not an instance of ingest_api_IngestOptionsVisitor'.format(visitor.__class__.__name__))
        if self._type == 'dataflash' and self.dataflash is not None:
            return visitor._dataflash(self.dataflash)
        if self._type == 'mcapProtobufTimeseries' and self.mcap_protobuf_timeseries is not None:
            return visitor._mcap_protobuf_timeseries(self.mcap_protobuf_timeseries)
        if self._type == 'journalJson' and self.journal_json is not None:
            return visitor._journal_json(self.journal_json)
        if self._type == 'csv' and self.csv is not None:
            return visitor._csv(self.csv)
        if self._type == 'parquet' and self.parquet is not None:
            return visitor._parquet(self.parquet)
        if self._type == 'video' and self.video is not None:
            return visitor._video(self.video)
        if self._type == 'containerized' and self.containerized is not None:
            return visitor._containerized(self.containerized)
        if self._type == 'avroStream' and self.avro_stream is not None:
            return visitor._avro_stream(self.avro_stream)


ingest_api_IngestOptions.__name__ = "IngestOptions"
ingest_api_IngestOptions.__qualname__ = "IngestOptions"
ingest_api_IngestOptions.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestOptionsVisitor:

    @abstractmethod
    def _dataflash(self, dataflash: "ingest_api_DataflashOpts") -> Any:
        pass

    @abstractmethod
    def _mcap_protobuf_timeseries(self, mcap_protobuf_timeseries: "ingest_api_McapProtobufTimeseriesOpts") -> Any:
        pass

    @abstractmethod
    def _journal_json(self, journal_json: "ingest_api_JournalJsonOpts") -> Any:
        pass

    @abstractmethod
    def _csv(self, csv: "ingest_api_CsvOpts") -> Any:
        pass

    @abstractmethod
    def _parquet(self, parquet: "ingest_api_ParquetOpts") -> Any:
        pass

    @abstractmethod
    def _video(self, video: "ingest_api_VideoOpts") -> Any:
        pass

    @abstractmethod
    def _containerized(self, containerized: "ingest_api_ContainerizedOpts") -> Any:
        pass

    @abstractmethod
    def _avro_stream(self, avro_stream: "ingest_api_AvroStreamOpts") -> Any:
        pass


ingest_api_IngestOptionsVisitor.__name__ = "IngestOptionsVisitor"
ingest_api_IngestOptionsVisitor.__qualname__ = "IngestOptionsVisitor"
ingest_api_IngestOptionsVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestProgressV2(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'start_time': ConjureFieldDefinition('startTime', str),
            'end_time': ConjureFieldDefinition('endTime', OptionalTypeWrapper[str]),
            'ingest_status': ConjureFieldDefinition('ingestStatus', api_IngestStatusV2),
            'incalculable': ConjureFieldDefinition('incalculable', OptionalTypeWrapper[bool])
        }

    __slots__: List[str] = ['_start_time', '_end_time', '_ingest_status', '_incalculable']

    def __init__(self, ingest_status: "api_IngestStatusV2", start_time: str, end_time: Optional[str] = None, incalculable: Optional[bool] = None) -> None:
        self._start_time = start_time
        self._end_time = end_time
        self._ingest_status = ingest_status
        self._incalculable = incalculable

    @builtins.property
    def start_time(self) -> str:
        """Timestamp at start of ingest
        """
        return self._start_time

    @builtins.property
    def end_time(self) -> Optional[str]:
        """Timestamp at end of ingest, empty if still in progress
        """
        return self._end_time

    @builtins.property
    def ingest_status(self) -> "api_IngestStatusV2":
        """Status of ingest, contains error if failed
        """
        return self._ingest_status

    @builtins.property
    def incalculable(self) -> Optional[bool]:
        """Whether ingest duration can be reliably calculated
        """
        return self._incalculable


ingest_api_IngestProgressV2.__name__ = "IngestProgressV2"
ingest_api_IngestProgressV2.__qualname__ = "IngestProgressV2"
ingest_api_IngestProgressV2.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'options': ConjureFieldDefinition('options', ingest_api_IngestOptions)
        }

    __slots__: List[str] = ['_options']

    def __init__(self, options: "ingest_api_IngestOptions") -> None:
        self._options = options

    @builtins.property
    def options(self) -> "ingest_api_IngestOptions":
        return self._options


ingest_api_IngestRequest.__name__ = "IngestRequest"
ingest_api_IngestRequest.__qualname__ = "IngestRequest"
ingest_api_IngestRequest.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'details': ConjureFieldDefinition('details', ingest_api_IngestDetails),
            'ingest_job_rid': ConjureFieldDefinition('ingestJobRid', OptionalTypeWrapper[ingest_api_IngestJobRid])
        }

    __slots__: List[str] = ['_details', '_ingest_job_rid']

    def __init__(self, details: "ingest_api_IngestDetails", ingest_job_rid: Optional[str] = None) -> None:
        self._details = details
        self._ingest_job_rid = ingest_job_rid

    @builtins.property
    def details(self) -> "ingest_api_IngestDetails":
        return self._details

    @builtins.property
    def ingest_job_rid(self) -> Optional[str]:
        return self._ingest_job_rid


ingest_api_IngestResponse.__name__ = "IngestResponse"
ingest_api_IngestResponse.__qualname__ = "IngestResponse"
ingest_api_IngestResponse.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestRunDataSource(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'data_source': ConjureFieldDefinition('dataSource', ingest_api_IngestDataSource),
            'time_offset_spec': ConjureFieldDefinition('timeOffsetSpec', OptionalTypeWrapper[ingest_api_TimeOffsetSpec])
        }

    __slots__: List[str] = ['_data_source', '_time_offset_spec']

    def __init__(self, data_source: "ingest_api_IngestDataSource", time_offset_spec: Optional["ingest_api_TimeOffsetSpec"] = None) -> None:
        self._data_source = data_source
        self._time_offset_spec = time_offset_spec

    @builtins.property
    def data_source(self) -> "ingest_api_IngestDataSource":
        return self._data_source

    @builtins.property
    def time_offset_spec(self) -> Optional["ingest_api_TimeOffsetSpec"]:
        return self._time_offset_spec


ingest_api_IngestRunDataSource.__name__ = "IngestRunDataSource"
ingest_api_IngestRunDataSource.__qualname__ = "IngestRunDataSource"
ingest_api_IngestRunDataSource.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestRunRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', OptionalTypeWrapper[str]),
            'title': ConjureFieldDefinition('title', str),
            'description': ConjureFieldDefinition('description', str),
            'start_time': ConjureFieldDefinition('startTime', ingest_api_UtcTimestamp),
            'end_time': ConjureFieldDefinition('endTime', OptionalTypeWrapper[ingest_api_UtcTimestamp]),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'run_prefix': ConjureFieldDefinition('runPrefix', OptionalTypeWrapper[str]),
            'data_sources': ConjureFieldDefinition('dataSources', Dict[ingest_api_DataSourceRefName, ingest_api_IngestRunDataSource]),
            'workspace': ConjureFieldDefinition('workspace', OptionalTypeWrapper[api_rids_WorkspaceRid])
        }

    __slots__: List[str] = ['_rid', '_title', '_description', '_start_time', '_end_time', '_properties', '_labels', '_run_prefix', '_data_sources', '_workspace']

    def __init__(self, data_sources: Dict[str, "ingest_api_IngestRunDataSource"], description: str, labels: List[str], properties: Dict[str, str], start_time: "ingest_api_UtcTimestamp", title: str, end_time: Optional["ingest_api_UtcTimestamp"] = None, rid: Optional[str] = None, run_prefix: Optional[str] = None, workspace: Optional[str] = None) -> None:
        self._rid = rid
        self._title = title
        self._description = description
        self._start_time = start_time
        self._end_time = end_time
        self._properties = properties
        self._labels = labels
        self._run_prefix = run_prefix
        self._data_sources = data_sources
        self._workspace = workspace

    @builtins.property
    def rid(self) -> Optional[str]:
        """If a run with the same rid already exists, the run will be updated.
        """
        return self._rid

    @builtins.property
    def title(self) -> str:
        return self._title

    @builtins.property
    def description(self) -> str:
        return self._description

    @builtins.property
    def start_time(self) -> "ingest_api_UtcTimestamp":
        return self._start_time

    @builtins.property
    def end_time(self) -> Optional["ingest_api_UtcTimestamp"]:
        return self._end_time

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels

    @builtins.property
    def run_prefix(self) -> Optional[str]:
        """for example, SIM, HTL, FLT
        """
        return self._run_prefix

    @builtins.property
    def data_sources(self) -> Dict[str, "ingest_api_IngestRunDataSource"]:
        return self._data_sources

    @builtins.property
    def workspace(self) -> Optional[str]:
        """The workspace in which to create the dataset. If not provided, the dataset will be created in the default workspace for
the user's organization, if the default workspace for the organization is configured.
        """
        return self._workspace


ingest_api_IngestRunRequest.__name__ = "IngestRunRequest"
ingest_api_IngestRunRequest.__qualname__ = "IngestRunRequest"
ingest_api_IngestRunRequest.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestRunResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'run_rid': ConjureFieldDefinition('runRid', scout_run_api_RunRid)
        }

    __slots__: List[str] = ['_run_rid']

    def __init__(self, run_rid: str) -> None:
        self._run_rid = run_rid

    @builtins.property
    def run_rid(self) -> str:
        return self._run_rid


ingest_api_IngestRunResponse.__name__ = "IngestRunResponse"
ingest_api_IngestRunResponse.__qualname__ = "IngestRunResponse"
ingest_api_IngestRunResponse.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestService(Service):
    """The Ingest Service handles the data ingestion into Nominal/Clickhouse.
    """

    def ingest(self, auth_header: str, trigger_ingest: "ingest_api_IngestRequest") -> "ingest_api_IngestResponse":
        """Triggers an ingest job, allowing either creating a new dataset or uploading to an
existing one. This endpoint is meant to supersede all other ingestion endpoints as their functionality
gets migrated to this one.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(trigger_ingest)

        _path = '/ingest/v1/ingest'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), ingest_api_IngestResponse, self._return_none_for_unknown_union_types)

    def rerun_ingest(self, auth_header: str, request: "ingest_api_RerunIngestRequest") -> "ingest_api_IngestResponse":
        """Triggers an ingest job using an existing ingest job RID.
Returns the same response format as the /ingest endpoint.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/ingest/v1/re-ingest'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), ingest_api_IngestResponse, self._return_none_for_unknown_union_types)

    def ingest_run(self, auth_header: str, request: "ingest_api_IngestRunRequest") -> "ingest_api_IngestRunResponse":
        """Creates a run and ingests data sources to be added to the run.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/ingest/v1/ingest-run'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), ingest_api_IngestRunResponse, self._return_none_for_unknown_union_types)

    def ingest_video(self, auth_header: str, ingest_video: "ingest_api_IngestVideoRequest") -> "ingest_api_IngestVideoResponse":
        """Ingests video data from a S3 Nominal upload bucket.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(ingest_video)

        _path = '/ingest/v1/ingest-video'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), ingest_api_IngestVideoResponse, self._return_none_for_unknown_union_types)

    def reingest_from_datasets(self, auth_header: str, request: "ingest_api_ReingestDatasetsRequest") -> "ingest_api_ReingestDatasetsResponse":
        """Re-ingests data from provided source datasets into either an existing target dataset, or a new one.
Only supported for CSV and Parquet dataset files.
Will only reingest dataset files and will drop streaming data from datasets.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/ingest/v1/reingest-dataset-files'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), ingest_api_ReingestDatasetsResponse, self._return_none_for_unknown_union_types)

    def delete_file(self, auth_header: str, dataset_rid: str, file_id: str) -> None:
        """This is a best effort deletion of the file's data based on the ingestedAt timestamp. This is an unreversible
action. Only v2 dataset file deletion is supported.
!!!WARNING!!!
It's possible that the file has overwritten points, in which case, those older points will not be recovered.
Only use this endpoint if this is acceptable, the data across files are disjoint, or you're willing to
re-ingest files to manually recover older points.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'datasetRid': quote(str(_conjure_encoder.default(dataset_rid)), safe=''),
            'fileId': quote(str(_conjure_encoder.default(file_id)), safe=''),
        }

        _json: Any = None

        _path = '/ingest/v1/delete-file/{datasetRid}/file/{fileId}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'DELETE',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return


ingest_api_IngestService.__name__ = "IngestService"
ingest_api_IngestService.__qualname__ = "IngestService"
ingest_api_IngestService.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestSource(ConjureUnionType):
    _s3: Optional["ingest_api_S3IngestSource"] = None
    _gcs: Optional["ingest_api_GcsIngestSource"] = None
    _presigned_file: Optional["ingest_api_PresignedFileIngestSource"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            's3': ConjureFieldDefinition('s3', ingest_api_S3IngestSource),
            'gcs': ConjureFieldDefinition('gcs', ingest_api_GcsIngestSource),
            'presigned_file': ConjureFieldDefinition('presignedFile', ingest_api_PresignedFileIngestSource)
        }

    def __init__(
            self,
            s3: Optional["ingest_api_S3IngestSource"] = None,
            gcs: Optional["ingest_api_GcsIngestSource"] = None,
            presigned_file: Optional["ingest_api_PresignedFileIngestSource"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (s3 is not None) + (gcs is not None) + (presigned_file is not None) != 1:
                raise ValueError('a union must contain a single member')

            if s3 is not None:
                self._s3 = s3
                self._type = 's3'
            if gcs is not None:
                self._gcs = gcs
                self._type = 'gcs'
            if presigned_file is not None:
                self._presigned_file = presigned_file
                self._type = 'presignedFile'

        elif type_of_union == 's3':
            if s3 is None:
                raise ValueError('a union value must not be None')
            self._s3 = s3
            self._type = 's3'
        elif type_of_union == 'gcs':
            if gcs is None:
                raise ValueError('a union value must not be None')
            self._gcs = gcs
            self._type = 'gcs'
        elif type_of_union == 'presignedFile':
            if presigned_file is None:
                raise ValueError('a union value must not be None')
            self._presigned_file = presigned_file
            self._type = 'presignedFile'

    @builtins.property
    def s3(self) -> Optional["ingest_api_S3IngestSource"]:
        return self._s3

    @builtins.property
    def gcs(self) -> Optional["ingest_api_GcsIngestSource"]:
        return self._gcs

    @builtins.property
    def presigned_file(self) -> Optional["ingest_api_PresignedFileIngestSource"]:
        return self._presigned_file

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_IngestSourceVisitor):
            raise ValueError('{} is not an instance of ingest_api_IngestSourceVisitor'.format(visitor.__class__.__name__))
        if self._type == 's3' and self.s3 is not None:
            return visitor._s3(self.s3)
        if self._type == 'gcs' and self.gcs is not None:
            return visitor._gcs(self.gcs)
        if self._type == 'presignedFile' and self.presigned_file is not None:
            return visitor._presigned_file(self.presigned_file)


ingest_api_IngestSource.__name__ = "IngestSource"
ingest_api_IngestSource.__qualname__ = "IngestSource"
ingest_api_IngestSource.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestSourceVisitor:

    @abstractmethod
    def _s3(self, s3: "ingest_api_S3IngestSource") -> Any:
        pass

    @abstractmethod
    def _gcs(self, gcs: "ingest_api_GcsIngestSource") -> Any:
        pass

    @abstractmethod
    def _presigned_file(self, presigned_file: "ingest_api_PresignedFileIngestSource") -> Any:
        pass


ingest_api_IngestSourceVisitor.__name__ = "IngestSourceVisitor"
ingest_api_IngestSourceVisitor.__qualname__ = "IngestSourceVisitor"
ingest_api_IngestSourceVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestSourceMetadata(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'timestamp_metadata': ConjureFieldDefinition('timestampMetadata', OptionalTypeWrapper[ingest_api_TimestampMetadata])
        }

    __slots__: List[str] = ['_timestamp_metadata']

    def __init__(self, timestamp_metadata: Optional["ingest_api_TimestampMetadata"] = None) -> None:
        self._timestamp_metadata = timestamp_metadata

    @builtins.property
    def timestamp_metadata(self) -> Optional["ingest_api_TimestampMetadata"]:
        return self._timestamp_metadata


ingest_api_IngestSourceMetadata.__name__ = "IngestSourceMetadata"
ingest_api_IngestSourceMetadata.__qualname__ = "IngestSourceMetadata"
ingest_api_IngestSourceMetadata.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestStatus(ConjureEnumType):

    IN_PROGRESS = 'IN_PROGRESS'
    '''IN_PROGRESS'''
    COMPLETED = 'COMPLETED'
    '''COMPLETED'''
    FAILED = 'FAILED'
    '''FAILED'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


ingest_api_IngestStatus.__name__ = "IngestStatus"
ingest_api_IngestStatus.__qualname__ = "IngestStatus"
ingest_api_IngestStatus.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestType(ConjureEnumType):

    TABULAR = 'TABULAR'
    '''TABULAR'''
    MCAP = 'MCAP'
    '''MCAP'''
    DATAFLASH = 'DATAFLASH'
    '''DATAFLASH'''
    JOURNAL_JSON = 'JOURNAL_JSON'
    '''JOURNAL_JSON'''
    CONTAINERIZED = 'CONTAINERIZED'
    '''CONTAINERIZED'''
    VIDEO = 'VIDEO'
    '''VIDEO'''
    AVRO_STREAM = 'AVRO_STREAM'
    '''AVRO_STREAM'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


ingest_api_IngestType.__name__ = "IngestType"
ingest_api_IngestType.__qualname__ = "IngestType"
ingest_api_IngestType.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestVideoFileDetails(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'video_file_rid': ConjureFieldDefinition('videoFileRid', api_rids_VideoFileRid),
            'video_rid': ConjureFieldDefinition('videoRid', api_rids_VideoRid)
        }

    __slots__: List[str] = ['_video_file_rid', '_video_rid']

    def __init__(self, video_file_rid: str, video_rid: str) -> None:
        self._video_file_rid = video_file_rid
        self._video_rid = video_rid

    @builtins.property
    def video_file_rid(self) -> str:
        return self._video_file_rid

    @builtins.property
    def video_rid(self) -> str:
        return self._video_rid


ingest_api_IngestVideoFileDetails.__name__ = "IngestVideoFileDetails"
ingest_api_IngestVideoFileDetails.__qualname__ = "IngestVideoFileDetails"
ingest_api_IngestVideoFileDetails.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestVideoRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'sources': ConjureFieldDefinition('sources', List[ingest_api_IngestSource]),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'title': ConjureFieldDefinition('title', OptionalTypeWrapper[str]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'timestamps': ConjureFieldDefinition('timestamps', ingest_api_VideoTimestampManifest),
            'workspace': ConjureFieldDefinition('workspace', OptionalTypeWrapper[api_rids_WorkspaceRid])
        }

    __slots__: List[str] = ['_sources', '_properties', '_labels', '_title', '_description', '_timestamps', '_workspace']

    def __init__(self, labels: List[str], properties: Dict[str, str], sources: List["ingest_api_IngestSource"], timestamps: "ingest_api_VideoTimestampManifest", description: Optional[str] = None, title: Optional[str] = None, workspace: Optional[str] = None) -> None:
        self._sources = sources
        self._properties = properties
        self._labels = labels
        self._title = title
        self._description = description
        self._timestamps = timestamps
        self._workspace = workspace

    @builtins.property
    def sources(self) -> List["ingest_api_IngestSource"]:
        return self._sources

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels

    @builtins.property
    def title(self) -> Optional[str]:
        return self._title

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def timestamps(self) -> "ingest_api_VideoTimestampManifest":
        return self._timestamps

    @builtins.property
    def workspace(self) -> Optional[str]:
        """The workspace in which to create the video. If not provided, the video will be created in the default workspace for
the user's organization, if the default workspace for the organization is configured.
        """
        return self._workspace


ingest_api_IngestVideoRequest.__name__ = "IngestVideoRequest"
ingest_api_IngestVideoRequest.__qualname__ = "IngestVideoRequest"
ingest_api_IngestVideoRequest.__module__ = "nominal_api.ingest_api"


class ingest_api_IngestVideoResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'video_rid': ConjureFieldDefinition('videoRid', api_rids_VideoRid),
            'video_file_rid': ConjureFieldDefinition('videoFileRid', api_rids_VideoFileRid),
            'async_handle': ConjureFieldDefinition('asyncHandle', OptionalTypeWrapper[ingest_api_AsyncHandle])
        }

    __slots__: List[str] = ['_video_rid', '_video_file_rid', '_async_handle']

    def __init__(self, video_file_rid: str, video_rid: str, async_handle: Optional["ingest_api_AsyncHandle"] = None) -> None:
        self._video_rid = video_rid
        self._video_file_rid = video_file_rid
        self._async_handle = async_handle

    @builtins.property
    def video_rid(self) -> str:
        return self._video_rid

    @builtins.property
    def video_file_rid(self) -> str:
        return self._video_file_rid

    @builtins.property
    def async_handle(self) -> Optional["ingest_api_AsyncHandle"]:
        return self._async_handle


ingest_api_IngestVideoResponse.__name__ = "IngestVideoResponse"
ingest_api_IngestVideoResponse.__qualname__ = "IngestVideoResponse"
ingest_api_IngestVideoResponse.__module__ = "nominal_api.ingest_api"


class ingest_api_InitiateMultipartUploadRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'filename': ConjureFieldDefinition('filename', str),
            'filetype': ConjureFieldDefinition('filetype', str),
            'workspace': ConjureFieldDefinition('workspace', OptionalTypeWrapper[api_rids_WorkspaceRid])
        }

    __slots__: List[str] = ['_filename', '_filetype', '_workspace']

    def __init__(self, filename: str, filetype: str, workspace: Optional[str] = None) -> None:
        self._filename = filename
        self._filetype = filetype
        self._workspace = workspace

    @builtins.property
    def filename(self) -> str:
        """The desired name of the file in object storage. The final name will be
prefixed with a timestamp to ensure uniqueness.
        """
        return self._filename

    @builtins.property
    def filetype(self) -> str:
        """The MIME type of the file, eg "text/csv" for CSVs or "application/octet-stream"
for binary files.
        """
        return self._filetype

    @builtins.property
    def workspace(self) -> Optional[str]:
        """The workspace in which to upload the file. If not provided, the file will be uploaded to
the default workspace for the user's organization, if that is configured and the user
has access to it.
        """
        return self._workspace


ingest_api_InitiateMultipartUploadRequest.__name__ = "InitiateMultipartUploadRequest"
ingest_api_InitiateMultipartUploadRequest.__qualname__ = "InitiateMultipartUploadRequest"
ingest_api_InitiateMultipartUploadRequest.__module__ = "nominal_api.ingest_api"


class ingest_api_InitiateMultipartUploadResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'upload_id': ConjureFieldDefinition('uploadId', str),
            'key': ConjureFieldDefinition('key', str),
            'bucket': ConjureFieldDefinition('bucket', str)
        }

    __slots__: List[str] = ['_upload_id', '_key', '_bucket']

    def __init__(self, bucket: str, key: str, upload_id: str) -> None:
        self._upload_id = upload_id
        self._key = key
        self._bucket = bucket

    @builtins.property
    def upload_id(self) -> str:
        return self._upload_id

    @builtins.property
    def key(self) -> str:
        return self._key

    @builtins.property
    def bucket(self) -> str:
        return self._bucket


ingest_api_InitiateMultipartUploadResponse.__name__ = "InitiateMultipartUploadResponse"
ingest_api_InitiateMultipartUploadResponse.__qualname__ = "InitiateMultipartUploadResponse"
ingest_api_InitiateMultipartUploadResponse.__module__ = "nominal_api.ingest_api"


class ingest_api_Iso8601Timestamp(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



ingest_api_Iso8601Timestamp.__name__ = "Iso8601Timestamp"
ingest_api_Iso8601Timestamp.__qualname__ = "Iso8601Timestamp"
ingest_api_Iso8601Timestamp.__module__ = "nominal_api.ingest_api"


class ingest_api_JournalJsonOpts(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'source': ConjureFieldDefinition('source', ingest_api_IngestSource),
            'target': ConjureFieldDefinition('target', ingest_api_DatasetIngestTarget),
            'channel': ConjureFieldDefinition('channel', OptionalTypeWrapper[api_Channel])
        }

    __slots__: List[str] = ['_source', '_target', '_channel']

    def __init__(self, source: "ingest_api_IngestSource", target: "ingest_api_DatasetIngestTarget", channel: Optional[str] = None) -> None:
        self._source = source
        self._target = target
        self._channel = channel

    @builtins.property
    def source(self) -> "ingest_api_IngestSource":
        return self._source

    @builtins.property
    def target(self) -> "ingest_api_DatasetIngestTarget":
        return self._target

    @builtins.property
    def channel(self) -> Optional[str]:
        """If provided, ingests logs to the given channel.
By default, log data will be ingested to a channel named 'logs'.
        """
        return self._channel


ingest_api_JournalJsonOpts.__name__ = "JournalJsonOpts"
ingest_api_JournalJsonOpts.__qualname__ = "JournalJsonOpts"
ingest_api_JournalJsonOpts.__module__ = "nominal_api.ingest_api"


class ingest_api_JournalTimestampMetadata(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'field_name': ConjureFieldDefinition('fieldName', str),
            'epoch_of_time_unit': ConjureFieldDefinition('epochOfTimeUnit', ingest_api_EpochTimestamp)
        }

    __slots__: List[str] = ['_field_name', '_epoch_of_time_unit']

    def __init__(self, epoch_of_time_unit: "ingest_api_EpochTimestamp", field_name: str) -> None:
        self._field_name = field_name
        self._epoch_of_time_unit = epoch_of_time_unit

    @builtins.property
    def field_name(self) -> str:
        return self._field_name

    @builtins.property
    def epoch_of_time_unit(self) -> "ingest_api_EpochTimestamp":
        return self._epoch_of_time_unit


ingest_api_JournalTimestampMetadata.__name__ = "JournalTimestampMetadata"
ingest_api_JournalTimestampMetadata.__qualname__ = "JournalTimestampMetadata"
ingest_api_JournalTimestampMetadata.__module__ = "nominal_api.ingest_api"


class ingest_api_LogTime(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



ingest_api_LogTime.__name__ = "LogTime"
ingest_api_LogTime.__qualname__ = "LogTime"
ingest_api_LogTime.__module__ = "nominal_api.ingest_api"


class ingest_api_McapChannelConfig(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'locator': ConjureFieldDefinition('locator', api_McapChannelLocator),
            'channel_type': ConjureFieldDefinition('channelType', ingest_api_McapChannelConfigType)
        }

    __slots__: List[str] = ['_locator', '_channel_type']

    def __init__(self, channel_type: "ingest_api_McapChannelConfigType", locator: "api_McapChannelLocator") -> None:
        self._locator = locator
        self._channel_type = channel_type

    @builtins.property
    def locator(self) -> "api_McapChannelLocator":
        return self._locator

    @builtins.property
    def channel_type(self) -> "ingest_api_McapChannelConfigType":
        return self._channel_type


ingest_api_McapChannelConfig.__name__ = "McapChannelConfig"
ingest_api_McapChannelConfig.__qualname__ = "McapChannelConfig"
ingest_api_McapChannelConfig.__module__ = "nominal_api.ingest_api"


class ingest_api_McapChannelConfigType(ConjureUnionType):
    _video: Optional["ingest_api_McapVideoChannelConfig"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'video': ConjureFieldDefinition('video', ingest_api_McapVideoChannelConfig)
        }

    def __init__(
            self,
            video: Optional["ingest_api_McapVideoChannelConfig"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (video is not None) != 1:
                raise ValueError('a union must contain a single member')

            if video is not None:
                self._video = video
                self._type = 'video'

        elif type_of_union == 'video':
            if video is None:
                raise ValueError('a union value must not be None')
            self._video = video
            self._type = 'video'

    @builtins.property
    def video(self) -> Optional["ingest_api_McapVideoChannelConfig"]:
        return self._video

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_McapChannelConfigTypeVisitor):
            raise ValueError('{} is not an instance of ingest_api_McapChannelConfigTypeVisitor'.format(visitor.__class__.__name__))
        if self._type == 'video' and self.video is not None:
            return visitor._video(self.video)


ingest_api_McapChannelConfigType.__name__ = "McapChannelConfigType"
ingest_api_McapChannelConfigType.__qualname__ = "McapChannelConfigType"
ingest_api_McapChannelConfigType.__module__ = "nominal_api.ingest_api"


class ingest_api_McapChannelConfigTypeVisitor:

    @abstractmethod
    def _video(self, video: "ingest_api_McapVideoChannelConfig") -> Any:
        pass


ingest_api_McapChannelConfigTypeVisitor.__name__ = "McapChannelConfigTypeVisitor"
ingest_api_McapChannelConfigTypeVisitor.__qualname__ = "McapChannelConfigTypeVisitor"
ingest_api_McapChannelConfigTypeVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_McapChannels(ConjureUnionType):
    _all: Optional["api_Empty"] = None
    _include: Optional[List["api_McapChannelLocator"]] = None
    _exclude: Optional[List["api_McapChannelLocator"]] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'all': ConjureFieldDefinition('all', api_Empty),
            'include': ConjureFieldDefinition('include', List[api_McapChannelLocator]),
            'exclude': ConjureFieldDefinition('exclude', List[api_McapChannelLocator])
        }

    def __init__(
            self,
            all: Optional["api_Empty"] = None,
            include: Optional[List["api_McapChannelLocator"]] = None,
            exclude: Optional[List["api_McapChannelLocator"]] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (all is not None) + (include is not None) + (exclude is not None) != 1:
                raise ValueError('a union must contain a single member')

            if all is not None:
                self._all = all
                self._type = 'all'
            if include is not None:
                self._include = include
                self._type = 'include'
            if exclude is not None:
                self._exclude = exclude
                self._type = 'exclude'

        elif type_of_union == 'all':
            if all is None:
                raise ValueError('a union value must not be None')
            self._all = all
            self._type = 'all'
        elif type_of_union == 'include':
            if include is None:
                raise ValueError('a union value must not be None')
            self._include = include
            self._type = 'include'
        elif type_of_union == 'exclude':
            if exclude is None:
                raise ValueError('a union value must not be None')
            self._exclude = exclude
            self._type = 'exclude'

    @builtins.property
    def all(self) -> Optional["api_Empty"]:
        return self._all

    @builtins.property
    def include(self) -> Optional[List["api_McapChannelLocator"]]:
        return self._include

    @builtins.property
    def exclude(self) -> Optional[List["api_McapChannelLocator"]]:
        return self._exclude

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_McapChannelsVisitor):
            raise ValueError('{} is not an instance of ingest_api_McapChannelsVisitor'.format(visitor.__class__.__name__))
        if self._type == 'all' and self.all is not None:
            return visitor._all(self.all)
        if self._type == 'include' and self.include is not None:
            return visitor._include(self.include)
        if self._type == 'exclude' and self.exclude is not None:
            return visitor._exclude(self.exclude)


ingest_api_McapChannels.__name__ = "McapChannels"
ingest_api_McapChannels.__qualname__ = "McapChannels"
ingest_api_McapChannels.__module__ = "nominal_api.ingest_api"


class ingest_api_McapChannelsVisitor:

    @abstractmethod
    def _all(self, all: "api_Empty") -> Any:
        pass

    @abstractmethod
    def _include(self, include: List["api_McapChannelLocator"]) -> Any:
        pass

    @abstractmethod
    def _exclude(self, exclude: List["api_McapChannelLocator"]) -> Any:
        pass


ingest_api_McapChannelsVisitor.__name__ = "McapChannelsVisitor"
ingest_api_McapChannelsVisitor.__qualname__ = "McapChannelsVisitor"
ingest_api_McapChannelsVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_McapDestination(ConjureUnionType):
    _video_rid: Optional[str] = None
    _dataset_rid: Optional[str] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'video_rid': ConjureFieldDefinition('videoRid', api_rids_VideoRid),
            'dataset_rid': ConjureFieldDefinition('datasetRid', str)
        }

    def __init__(
            self,
            video_rid: Optional[str] = None,
            dataset_rid: Optional[str] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (video_rid is not None) + (dataset_rid is not None) != 1:
                raise ValueError('a union must contain a single member')

            if video_rid is not None:
                self._video_rid = video_rid
                self._type = 'videoRid'
            if dataset_rid is not None:
                self._dataset_rid = dataset_rid
                self._type = 'datasetRid'

        elif type_of_union == 'videoRid':
            if video_rid is None:
                raise ValueError('a union value must not be None')
            self._video_rid = video_rid
            self._type = 'videoRid'
        elif type_of_union == 'datasetRid':
            if dataset_rid is None:
                raise ValueError('a union value must not be None')
            self._dataset_rid = dataset_rid
            self._type = 'datasetRid'

    @builtins.property
    def video_rid(self) -> Optional[str]:
        return self._video_rid

    @builtins.property
    def dataset_rid(self) -> Optional[str]:
        return self._dataset_rid

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_McapDestinationVisitor):
            raise ValueError('{} is not an instance of ingest_api_McapDestinationVisitor'.format(visitor.__class__.__name__))
        if self._type == 'videoRid' and self.video_rid is not None:
            return visitor._video_rid(self.video_rid)
        if self._type == 'datasetRid' and self.dataset_rid is not None:
            return visitor._dataset_rid(self.dataset_rid)


ingest_api_McapDestination.__name__ = "McapDestination"
ingest_api_McapDestination.__qualname__ = "McapDestination"
ingest_api_McapDestination.__module__ = "nominal_api.ingest_api"


class ingest_api_McapDestinationVisitor:

    @abstractmethod
    def _video_rid(self, video_rid: str) -> Any:
        pass

    @abstractmethod
    def _dataset_rid(self, dataset_rid: str) -> Any:
        pass


ingest_api_McapDestinationVisitor.__name__ = "McapDestinationVisitor"
ingest_api_McapDestinationVisitor.__qualname__ = "McapDestinationVisitor"
ingest_api_McapDestinationVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_McapIngestionOutput(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'source': ConjureFieldDefinition('source', ingest_api_McapSource),
            'target': ConjureFieldDefinition('target', ingest_api_McapDestination),
            'video_file_rid': ConjureFieldDefinition('videoFileRid', OptionalTypeWrapper[api_rids_VideoFileRid])
        }

    __slots__: List[str] = ['_source', '_target', '_video_file_rid']

    def __init__(self, source: "ingest_api_McapSource", target: "ingest_api_McapDestination", video_file_rid: Optional[str] = None) -> None:
        self._source = source
        self._target = target
        self._video_file_rid = video_file_rid

    @builtins.property
    def source(self) -> "ingest_api_McapSource":
        return self._source

    @builtins.property
    def target(self) -> "ingest_api_McapDestination":
        return self._target

    @builtins.property
    def video_file_rid(self) -> Optional[str]:
        """If the destination points to a video, this will be populated with the video file
populated during ingestion.
        """
        return self._video_file_rid


ingest_api_McapIngestionOutput.__name__ = "McapIngestionOutput"
ingest_api_McapIngestionOutput.__qualname__ = "McapIngestionOutput"
ingest_api_McapIngestionOutput.__module__ = "nominal_api.ingest_api"


class ingest_api_McapProtobufTimeseriesOpts(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'source': ConjureFieldDefinition('source', ingest_api_IngestSource),
            'target': ConjureFieldDefinition('target', ingest_api_DatasetIngestTarget),
            'channel_filter': ConjureFieldDefinition('channelFilter', ingest_api_McapChannels),
            'timestamp_type': ConjureFieldDefinition('timestampType', ingest_api_McapTimestampType)
        }

    __slots__: List[str] = ['_source', '_target', '_channel_filter', '_timestamp_type']

    def __init__(self, channel_filter: "ingest_api_McapChannels", source: "ingest_api_IngestSource", target: "ingest_api_DatasetIngestTarget", timestamp_type: "ingest_api_McapTimestampType") -> None:
        self._source = source
        self._target = target
        self._channel_filter = channel_filter
        self._timestamp_type = timestamp_type

    @builtins.property
    def source(self) -> "ingest_api_IngestSource":
        return self._source

    @builtins.property
    def target(self) -> "ingest_api_DatasetIngestTarget":
        return self._target

    @builtins.property
    def channel_filter(self) -> "ingest_api_McapChannels":
        return self._channel_filter

    @builtins.property
    def timestamp_type(self) -> "ingest_api_McapTimestampType":
        return self._timestamp_type


ingest_api_McapProtobufTimeseriesOpts.__name__ = "McapProtobufTimeseriesOpts"
ingest_api_McapProtobufTimeseriesOpts.__qualname__ = "McapProtobufTimeseriesOpts"
ingest_api_McapProtobufTimeseriesOpts.__module__ = "nominal_api.ingest_api"


class ingest_api_McapSource(ConjureUnionType):
    _single_channel: Optional["api_McapChannelLocator"] = None
    _mcap_file: Optional["ingest_api_IngestSource"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'single_channel': ConjureFieldDefinition('singleChannel', api_McapChannelLocator),
            'mcap_file': ConjureFieldDefinition('mcapFile', ingest_api_IngestSource)
        }

    def __init__(
            self,
            single_channel: Optional["api_McapChannelLocator"] = None,
            mcap_file: Optional["ingest_api_IngestSource"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (single_channel is not None) + (mcap_file is not None) != 1:
                raise ValueError('a union must contain a single member')

            if single_channel is not None:
                self._single_channel = single_channel
                self._type = 'singleChannel'
            if mcap_file is not None:
                self._mcap_file = mcap_file
                self._type = 'mcapFile'

        elif type_of_union == 'singleChannel':
            if single_channel is None:
                raise ValueError('a union value must not be None')
            self._single_channel = single_channel
            self._type = 'singleChannel'
        elif type_of_union == 'mcapFile':
            if mcap_file is None:
                raise ValueError('a union value must not be None')
            self._mcap_file = mcap_file
            self._type = 'mcapFile'

    @builtins.property
    def single_channel(self) -> Optional["api_McapChannelLocator"]:
        return self._single_channel

    @builtins.property
    def mcap_file(self) -> Optional["ingest_api_IngestSource"]:
        return self._mcap_file

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_McapSourceVisitor):
            raise ValueError('{} is not an instance of ingest_api_McapSourceVisitor'.format(visitor.__class__.__name__))
        if self._type == 'singleChannel' and self.single_channel is not None:
            return visitor._single_channel(self.single_channel)
        if self._type == 'mcapFile' and self.mcap_file is not None:
            return visitor._mcap_file(self.mcap_file)


ingest_api_McapSource.__name__ = "McapSource"
ingest_api_McapSource.__qualname__ = "McapSource"
ingest_api_McapSource.__module__ = "nominal_api.ingest_api"


class ingest_api_McapSourceVisitor:

    @abstractmethod
    def _single_channel(self, single_channel: "api_McapChannelLocator") -> Any:
        pass

    @abstractmethod
    def _mcap_file(self, mcap_file: "ingest_api_IngestSource") -> Any:
        pass


ingest_api_McapSourceVisitor.__name__ = "McapSourceVisitor"
ingest_api_McapSourceVisitor.__qualname__ = "McapSourceVisitor"
ingest_api_McapSourceVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_McapTimestampType(ConjureUnionType):
    """LogTime is default timestamp for MCAP messages and should be used in most cases.
    """
    _log_time: Optional["ingest_api_LogTime"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'log_time': ConjureFieldDefinition('logTime', ingest_api_LogTime)
        }

    def __init__(
            self,
            log_time: Optional["ingest_api_LogTime"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (log_time is not None) != 1:
                raise ValueError('a union must contain a single member')

            if log_time is not None:
                self._log_time = log_time
                self._type = 'logTime'

        elif type_of_union == 'logTime':
            if log_time is None:
                raise ValueError('a union value must not be None')
            self._log_time = log_time
            self._type = 'logTime'

    @builtins.property
    def log_time(self) -> Optional["ingest_api_LogTime"]:
        return self._log_time

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_McapTimestampTypeVisitor):
            raise ValueError('{} is not an instance of ingest_api_McapTimestampTypeVisitor'.format(visitor.__class__.__name__))
        if self._type == 'logTime' and self.log_time is not None:
            return visitor._log_time(self.log_time)


ingest_api_McapTimestampType.__name__ = "McapTimestampType"
ingest_api_McapTimestampType.__qualname__ = "McapTimestampType"
ingest_api_McapTimestampType.__module__ = "nominal_api.ingest_api"


class ingest_api_McapTimestampTypeVisitor:

    @abstractmethod
    def _log_time(self, log_time: "ingest_api_LogTime") -> Any:
        pass


ingest_api_McapTimestampTypeVisitor.__name__ = "McapTimestampTypeVisitor"
ingest_api_McapTimestampTypeVisitor.__qualname__ = "McapTimestampTypeVisitor"
ingest_api_McapTimestampTypeVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_McapVideoChannelConfig(ConjureBeanType):
    """Ingest a channel as video. This requires:
* Using the `foxglove.CompressedVideo` schema
* Protobuf representation of the message data
* Messages are in sequential order in the mcap file
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



ingest_api_McapVideoChannelConfig.__name__ = "McapVideoChannelConfig"
ingest_api_McapVideoChannelConfig.__qualname__ = "McapVideoChannelConfig"
ingest_api_McapVideoChannelConfig.__module__ = "nominal_api.ingest_api"


class ingest_api_NewDataSource(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'source': ConjureFieldDefinition('source', ingest_api_IngestSource),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'name': ConjureFieldDefinition('name', OptionalTypeWrapper[str]),
            'time_column_spec': ConjureFieldDefinition('timeColumnSpec', OptionalTypeWrapper[ingest_api_TimestampMetadata]),
            'channel_config': ConjureFieldDefinition('channelConfig', OptionalTypeWrapper[ingest_api_ChannelConfig])
        }

    __slots__: List[str] = ['_source', '_properties', '_labels', '_description', '_name', '_time_column_spec', '_channel_config']

    def __init__(self, labels: List[str], properties: Dict[str, str], source: "ingest_api_IngestSource", channel_config: Optional["ingest_api_ChannelConfig"] = None, description: Optional[str] = None, name: Optional[str] = None, time_column_spec: Optional["ingest_api_TimestampMetadata"] = None) -> None:
        self._source = source
        self._properties = properties
        self._labels = labels
        self._description = description
        self._name = name
        self._time_column_spec = time_column_spec
        self._channel_config = channel_config

    @builtins.property
    def source(self) -> "ingest_api_IngestSource":
        return self._source

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def name(self) -> Optional[str]:
        return self._name

    @builtins.property
    def time_column_spec(self) -> Optional["ingest_api_TimestampMetadata"]:
        return self._time_column_spec

    @builtins.property
    def channel_config(self) -> Optional["ingest_api_ChannelConfig"]:
        return self._channel_config


ingest_api_NewDataSource.__name__ = "NewDataSource"
ingest_api_NewDataSource.__qualname__ = "NewDataSource"
ingest_api_NewDataSource.__module__ = "nominal_api.ingest_api"


class ingest_api_NewDatasetIngestDestination(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'dataset_name': ConjureFieldDefinition('datasetName', OptionalTypeWrapper[str]),
            'dataset_description': ConjureFieldDefinition('datasetDescription', OptionalTypeWrapper[str]),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'channel_config': ConjureFieldDefinition('channelConfig', OptionalTypeWrapper[ingest_api_ChannelConfig]),
            'workspace': ConjureFieldDefinition('workspace', OptionalTypeWrapper[api_rids_WorkspaceRid]),
            'marking_rids': ConjureFieldDefinition('markingRids', List[scout_rids_api_MarkingRid])
        }

    __slots__: List[str] = ['_dataset_name', '_dataset_description', '_properties', '_labels', '_channel_config', '_workspace', '_marking_rids']

    def __init__(self, labels: List[str], marking_rids: List[str], properties: Dict[str, str], channel_config: Optional["ingest_api_ChannelConfig"] = None, dataset_description: Optional[str] = None, dataset_name: Optional[str] = None, workspace: Optional[str] = None) -> None:
        self._dataset_name = dataset_name
        self._dataset_description = dataset_description
        self._properties = properties
        self._labels = labels
        self._channel_config = channel_config
        self._workspace = workspace
        self._marking_rids = marking_rids

    @builtins.property
    def dataset_name(self) -> Optional[str]:
        return self._dataset_name

    @builtins.property
    def dataset_description(self) -> Optional[str]:
        return self._dataset_description

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels

    @builtins.property
    def channel_config(self) -> Optional["ingest_api_ChannelConfig"]:
        return self._channel_config

    @builtins.property
    def workspace(self) -> Optional[str]:
        """The workspace in which to create the dataset. If not provided, the dataset will be created in the default workspace for
the user's organization, if the default workspace for the organization is configured.
        """
        return self._workspace

    @builtins.property
    def marking_rids(self) -> List[str]:
        """The markings to apply to the created dataset.
If not provided, the dataset will be visible to all users in the same workspace.
        """
        return self._marking_rids


ingest_api_NewDatasetIngestDestination.__name__ = "NewDatasetIngestDestination"
ingest_api_NewDatasetIngestDestination.__qualname__ = "NewDatasetIngestDestination"
ingest_api_NewDatasetIngestDestination.__module__ = "nominal_api.ingest_api"


class ingest_api_NewVideoIngestDestination(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'title': ConjureFieldDefinition('title', OptionalTypeWrapper[str]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'video_file_details': ConjureFieldDefinition('videoFileDetails', OptionalTypeWrapper[ingest_api_VideoFileIngestDetails]),
            'workspace': ConjureFieldDefinition('workspace', OptionalTypeWrapper[api_rids_WorkspaceRid]),
            'marking_rids': ConjureFieldDefinition('markingRids', List[scout_rids_api_MarkingRid])
        }

    __slots__: List[str] = ['_title', '_description', '_properties', '_labels', '_video_file_details', '_workspace', '_marking_rids']

    def __init__(self, labels: List[str], marking_rids: List[str], properties: Dict[str, str], description: Optional[str] = None, title: Optional[str] = None, video_file_details: Optional["ingest_api_VideoFileIngestDetails"] = None, workspace: Optional[str] = None) -> None:
        self._title = title
        self._description = description
        self._properties = properties
        self._labels = labels
        self._video_file_details = video_file_details
        self._workspace = workspace
        self._marking_rids = marking_rids

    @builtins.property
    def title(self) -> Optional[str]:
        """Title of the Video that will get created.
If not provided, a name is deduced from the ingested file.
        """
        return self._title

    @builtins.property
    def description(self) -> Optional[str]:
        """Description that is applied to the newly created video
        """
        return self._description

    @builtins.property
    def properties(self) -> Dict[str, str]:
        """Key-Value properties that are applied to the newly created video
        """
        return self._properties

    @builtins.property
    def labels(self) -> List[str]:
        """Labels that are applied to the newly created video
        """
        return self._labels

    @builtins.property
    def video_file_details(self) -> Optional["ingest_api_VideoFileIngestDetails"]:
        """Metadata to associate with any created video file
        """
        return self._video_file_details

    @builtins.property
    def workspace(self) -> Optional[str]:
        """The workspace in which to create the video. If not provided, the video will be created in the default workspace for
the user's organization, if the default workspace for the organization is configured.
        """
        return self._workspace

    @builtins.property
    def marking_rids(self) -> List[str]:
        """The markings to apply to the created video.
If not provided, the video will be visible to all users in the same workspace.
        """
        return self._marking_rids


ingest_api_NewVideoIngestDestination.__name__ = "NewVideoIngestDestination"
ingest_api_NewVideoIngestDestination.__qualname__ = "NewVideoIngestDestination"
ingest_api_NewVideoIngestDestination.__module__ = "nominal_api.ingest_api"


class ingest_api_NoTimestampManifest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'starting_timestamp': ConjureFieldDefinition('startingTimestamp', ingest_api_UtcTimestamp),
            'scale_parameter': ConjureFieldDefinition('scaleParameter', OptionalTypeWrapper[ingest_api_ScaleParameter])
        }

    __slots__: List[str] = ['_starting_timestamp', '_scale_parameter']

    def __init__(self, starting_timestamp: "ingest_api_UtcTimestamp", scale_parameter: Optional["ingest_api_ScaleParameter"] = None) -> None:
        self._starting_timestamp = starting_timestamp
        self._scale_parameter = scale_parameter

    @builtins.property
    def starting_timestamp(self) -> "ingest_api_UtcTimestamp":
        return self._starting_timestamp

    @builtins.property
    def scale_parameter(self) -> Optional["ingest_api_ScaleParameter"]:
        """A field that specifies that the frame rate of the video does not match the frame rate of the camera | i.e. a slowed down or sped up video. Can specify either the camera frame rate or the absolute end time.
        """
        return self._scale_parameter


ingest_api_NoTimestampManifest.__name__ = "NoTimestampManifest"
ingest_api_NoTimestampManifest.__qualname__ = "NoTimestampManifest"
ingest_api_NoTimestampManifest.__module__ = "nominal_api.ingest_api"


class ingest_api_ParquetOpts(ConjureBeanType):
    """Options for ingesting parquet files.
Supported file formats include .parquet, .parquet.gz 
and archives such as .tar, .tar.gz, and .zip (must set the isArchive flag).
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'source': ConjureFieldDefinition('source', ingest_api_IngestSource),
            'target': ConjureFieldDefinition('target', ingest_api_DatasetIngestTarget),
            'timestamp_metadata': ConjureFieldDefinition('timestampMetadata', ingest_api_TimestampMetadata),
            'channel_prefix': ConjureFieldDefinition('channelPrefix', ingest_api_ChannelPrefix),
            'tag_keys_from_columns': ConjureFieldDefinition('tagKeysFromColumns', OptionalTypeWrapper[List[api_TagName]]),
            'tag_columns': ConjureFieldDefinition('tagColumns', OptionalTypeWrapper[Dict[api_TagName, api_ColumnName]]),
            'additional_file_tags': ConjureFieldDefinition('additionalFileTags', OptionalTypeWrapper[Dict[api_TagName, api_TagValue]]),
            'is_archive': ConjureFieldDefinition('isArchive', OptionalTypeWrapper[bool])
        }

    __slots__: List[str] = ['_source', '_target', '_timestamp_metadata', '_channel_prefix', '_tag_keys_from_columns', '_tag_columns', '_additional_file_tags', '_is_archive']

    def __init__(self, source: "ingest_api_IngestSource", target: "ingest_api_DatasetIngestTarget", timestamp_metadata: "ingest_api_TimestampMetadata", additional_file_tags: Optional[Dict[str, str]] = None, channel_prefix: Optional[str] = None, is_archive: Optional[bool] = None, tag_columns: Optional[Dict[str, str]] = None, tag_keys_from_columns: Optional[List[str]] = None) -> None:
        self._source = source
        self._target = target
        self._timestamp_metadata = timestamp_metadata
        self._channel_prefix = channel_prefix
        self._tag_keys_from_columns = tag_keys_from_columns
        self._tag_columns = tag_columns
        self._additional_file_tags = additional_file_tags
        self._is_archive = is_archive

    @builtins.property
    def source(self) -> "ingest_api_IngestSource":
        return self._source

    @builtins.property
    def target(self) -> "ingest_api_DatasetIngestTarget":
        return self._target

    @builtins.property
    def timestamp_metadata(self) -> "ingest_api_TimestampMetadata":
        return self._timestamp_metadata

    @builtins.property
    def channel_prefix(self) -> Optional[str]:
        return self._channel_prefix

    @builtins.property
    def tag_keys_from_columns(self) -> Optional[List[str]]:
        return self._tag_keys_from_columns

    @builtins.property
    def tag_columns(self) -> Optional[Dict[str, str]]:
        """A map of tag names to column names to derive the tag values from.
        """
        return self._tag_columns

    @builtins.property
    def additional_file_tags(self) -> Optional[Dict[str, str]]:
        """Specifies a tag set to apply to all data in the file.
        """
        return self._additional_file_tags

    @builtins.property
    def is_archive(self) -> Optional[bool]:
        """If true, the file is an archive. Supported archive formats include
.tar, .tar.gz, and .zip. Only files ending in .parquet
within the archive will be ingested. If field not provided, defaults to false.
        """
        return self._is_archive


ingest_api_ParquetOpts.__name__ = "ParquetOpts"
ingest_api_ParquetOpts.__qualname__ = "ParquetOpts"
ingest_api_ParquetOpts.__module__ = "nominal_api.ingest_api"


class ingest_api_Part(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'part_number': ConjureFieldDefinition('partNumber', int),
            'etag': ConjureFieldDefinition('etag', str)
        }

    __slots__: List[str] = ['_part_number', '_etag']

    def __init__(self, etag: str, part_number: int) -> None:
        self._part_number = part_number
        self._etag = etag

    @builtins.property
    def part_number(self) -> int:
        return self._part_number

    @builtins.property
    def etag(self) -> str:
        return self._etag


ingest_api_Part.__name__ = "Part"
ingest_api_Part.__qualname__ = "Part"
ingest_api_Part.__module__ = "nominal_api.ingest_api"


class ingest_api_PartWithSize(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'part_number': ConjureFieldDefinition('partNumber', int),
            'etag': ConjureFieldDefinition('etag', str),
            'size': ConjureFieldDefinition('size', int)
        }

    __slots__: List[str] = ['_part_number', '_etag', '_size']

    def __init__(self, etag: str, part_number: int, size: int) -> None:
        self._part_number = part_number
        self._etag = etag
        self._size = size

    @builtins.property
    def part_number(self) -> int:
        return self._part_number

    @builtins.property
    def etag(self) -> str:
        return self._etag

    @builtins.property
    def size(self) -> int:
        return self._size


ingest_api_PartWithSize.__name__ = "PartWithSize"
ingest_api_PartWithSize.__qualname__ = "PartWithSize"
ingest_api_PartWithSize.__module__ = "nominal_api.ingest_api"


class ingest_api_PresignedFileIngestSource(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'url': ConjureFieldDefinition('url', str)
        }

    __slots__: List[str] = ['_url']

    def __init__(self, url: str) -> None:
        self._url = url

    @builtins.property
    def url(self) -> str:
        return self._url


ingest_api_PresignedFileIngestSource.__name__ = "PresignedFileIngestSource"
ingest_api_PresignedFileIngestSource.__qualname__ = "PresignedFileIngestSource"
ingest_api_PresignedFileIngestSource.__module__ = "nominal_api.ingest_api"


class ingest_api_PublicAuthentication(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



ingest_api_PublicAuthentication.__name__ = "PublicAuthentication"
ingest_api_PublicAuthentication.__qualname__ = "PublicAuthentication"
ingest_api_PublicAuthentication.__module__ = "nominal_api.ingest_api"


class ingest_api_RegisterContainerizedExtractorRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', str),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'image': ConjureFieldDefinition('image', ingest_api_DockerImageSource),
            'inputs': ConjureFieldDefinition('inputs', List[ingest_api_FileExtractionInput]),
            'parameters': ConjureFieldDefinition('parameters', List[ingest_api_FileExtractionParameter]),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'workspace': ConjureFieldDefinition('workspace', api_rids_WorkspaceRid),
            'timestamp_metadata': ConjureFieldDefinition('timestampMetadata', ingest_api_TimestampMetadata),
            'output_file_format': ConjureFieldDefinition('outputFileFormat', OptionalTypeWrapper[ingest_api_FileOutputFormat])
        }

    __slots__: List[str] = ['_name', '_description', '_image', '_inputs', '_parameters', '_properties', '_labels', '_workspace', '_timestamp_metadata', '_output_file_format']

    def __init__(self, image: "ingest_api_DockerImageSource", inputs: List["ingest_api_FileExtractionInput"], labels: List[str], name: str, parameters: List["ingest_api_FileExtractionParameter"], properties: Dict[str, str], timestamp_metadata: "ingest_api_TimestampMetadata", workspace: str, description: Optional[str] = None, output_file_format: Optional["ingest_api_FileOutputFormat"] = None) -> None:
        self._name = name
        self._description = description
        self._image = image
        self._inputs = inputs
        self._parameters = parameters
        self._properties = properties
        self._labels = labels
        self._workspace = workspace
        self._timestamp_metadata = timestamp_metadata
        self._output_file_format = output_file_format

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def image(self) -> "ingest_api_DockerImageSource":
        return self._image

    @builtins.property
    def inputs(self) -> List["ingest_api_FileExtractionInput"]:
        """payload must match input defined in containerized extraction
        """
        return self._inputs

    @builtins.property
    def parameters(self) -> List["ingest_api_FileExtractionParameter"]:
        """Describes the parameters of the extractor.
        """
        return self._parameters

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels

    @builtins.property
    def workspace(self) -> str:
        """The workspace in which to create the extractor
        """
        return self._workspace

    @builtins.property
    def timestamp_metadata(self) -> "ingest_api_TimestampMetadata":
        """Metadata about the intermediate parquet this extractor will produce
        """
        return self._timestamp_metadata

    @builtins.property
    def output_file_format(self) -> Optional["ingest_api_FileOutputFormat"]:
        """The format of the output file. Currently only "parquet", "csv", "parquet.tar" are supported
        """
        return self._output_file_format


ingest_api_RegisterContainerizedExtractorRequest.__name__ = "RegisterContainerizedExtractorRequest"
ingest_api_RegisterContainerizedExtractorRequest.__qualname__ = "RegisterContainerizedExtractorRequest"
ingest_api_RegisterContainerizedExtractorRequest.__module__ = "nominal_api.ingest_api"


class ingest_api_RegisterContainerizedExtractorResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'extractor_rid': ConjureFieldDefinition('extractorRid', ingest_api_ContainerizedExtractorRid)
        }

    __slots__: List[str] = ['_extractor_rid']

    def __init__(self, extractor_rid: str) -> None:
        self._extractor_rid = extractor_rid

    @builtins.property
    def extractor_rid(self) -> str:
        return self._extractor_rid


ingest_api_RegisterContainerizedExtractorResponse.__name__ = "RegisterContainerizedExtractorResponse"
ingest_api_RegisterContainerizedExtractorResponse.__qualname__ = "RegisterContainerizedExtractorResponse"
ingest_api_RegisterContainerizedExtractorResponse.__module__ = "nominal_api.ingest_api"


class ingest_api_ReingestDatasetsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'source_datasets': ConjureFieldDefinition('sourceDatasets', List[api_rids_DatasetRid]),
            'target_dataset': ConjureFieldDefinition('targetDataset', ingest_api_DatasetIngestTarget),
            'ingest_metadata': ConjureFieldDefinition('ingestMetadata', Dict[api_rids_DatasetRid, ingest_api_IngestMetadata])
        }

    __slots__: List[str] = ['_source_datasets', '_target_dataset', '_ingest_metadata']

    def __init__(self, ingest_metadata: Dict[str, "ingest_api_IngestMetadata"], source_datasets: List[str], target_dataset: "ingest_api_DatasetIngestTarget") -> None:
        self._source_datasets = source_datasets
        self._target_dataset = target_dataset
        self._ingest_metadata = ingest_metadata

    @builtins.property
    def source_datasets(self) -> List[str]:
        """The datasets to reingest data from. Can only include tagless, non-streaming datasets (V1).
The datasets must be of the same granularity and must only include CSV or Parquet files.
Will attempt to reingest from datasets in list order.
        """
        return self._source_datasets

    @builtins.property
    def target_dataset(self) -> "ingest_api_DatasetIngestTarget":
        """The dataset to ingest data into. Can either be a new dataset or an existing dataset RID.
        """
        return self._target_dataset

    @builtins.property
    def ingest_metadata(self) -> Dict[str, "ingest_api_IngestMetadata"]:
        """Mapping of dataset to ingest metadata.
Ingest metadata only needs to be provided in request if it cannot be recovered from prior ingests.
See documentation on each field to determine what metadata can be auto-recovered.
        """
        return self._ingest_metadata


ingest_api_ReingestDatasetsRequest.__name__ = "ReingestDatasetsRequest"
ingest_api_ReingestDatasetsRequest.__qualname__ = "ReingestDatasetsRequest"
ingest_api_ReingestDatasetsRequest.__module__ = "nominal_api.ingest_api"


class ingest_api_ReingestDatasetsResponse(ConjureBeanType):
    """The response to a reingest request.
Maps the source dataset RID and file ID to the destination dataset RID and file ID.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'datasets': ConjureFieldDefinition('datasets', Dict[api_rids_DatasetRid, ingest_api_ReingestFilesMapping])
        }

    __slots__: List[str] = ['_datasets']

    def __init__(self, datasets: Dict[str, "ingest_api_ReingestFilesMapping"]) -> None:
        self._datasets = datasets

    @builtins.property
    def datasets(self) -> Dict[str, "ingest_api_ReingestFilesMapping"]:
        return self._datasets


ingest_api_ReingestDatasetsResponse.__name__ = "ReingestDatasetsResponse"
ingest_api_ReingestDatasetsResponse.__qualname__ = "ReingestDatasetsResponse"
ingest_api_ReingestDatasetsResponse.__module__ = "nominal_api.ingest_api"


class ingest_api_ReingestFilesMapping(ConjureBeanType):
    """Maps the source dataset file ID to the destination dataset and file ID.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'file_map': ConjureFieldDefinition('fileMap', Dict[datasource_DatasetFileId, ingest_api_IngestDetails])
        }

    __slots__: List[str] = ['_file_map']

    def __init__(self, file_map: Dict[str, "ingest_api_IngestDetails"]) -> None:
        self._file_map = file_map

    @builtins.property
    def file_map(self) -> Dict[str, "ingest_api_IngestDetails"]:
        return self._file_map


ingest_api_ReingestFilesMapping.__name__ = "ReingestFilesMapping"
ingest_api_ReingestFilesMapping.__qualname__ = "ReingestFilesMapping"
ingest_api_ReingestFilesMapping.__module__ = "nominal_api.ingest_api"


class ingest_api_RelativeTimestamp(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'time_unit': ConjureFieldDefinition('timeUnit', api_TimeUnit),
            'offset': ConjureFieldDefinition('offset', OptionalTypeWrapper[str])
        }

    __slots__: List[str] = ['_time_unit', '_offset']

    def __init__(self, time_unit: "api_TimeUnit", offset: Optional[str] = None) -> None:
        self._time_unit = time_unit
        self._offset = offset

    @builtins.property
    def time_unit(self) -> "api_TimeUnit":
        return self._time_unit

    @builtins.property
    def offset(self) -> Optional[str]:
        """Starting timestamp to use when indexing the file. This field is required when uploading a new file to an existing dataset.
        """
        return self._offset


ingest_api_RelativeTimestamp.__name__ = "RelativeTimestamp"
ingest_api_RelativeTimestamp.__qualname__ = "RelativeTimestamp"
ingest_api_RelativeTimestamp.__module__ = "nominal_api.ingest_api"


class ingest_api_RerunIngestRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'ingest_job_rid': ConjureFieldDefinition('ingestJobRid', ingest_api_IngestJobRid)
        }

    __slots__: List[str] = ['_ingest_job_rid']

    def __init__(self, ingest_job_rid: str) -> None:
        self._ingest_job_rid = ingest_job_rid

    @builtins.property
    def ingest_job_rid(self) -> str:
        return self._ingest_job_rid


ingest_api_RerunIngestRequest.__name__ = "RerunIngestRequest"
ingest_api_RerunIngestRequest.__qualname__ = "RerunIngestRequest"
ingest_api_RerunIngestRequest.__module__ = "nominal_api.ingest_api"


class ingest_api_S3IngestSource(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'path': ConjureFieldDefinition('path', str)
        }

    __slots__: List[str] = ['_path']

    def __init__(self, path: str) -> None:
        self._path = path

    @builtins.property
    def path(self) -> str:
        return self._path


ingest_api_S3IngestSource.__name__ = "S3IngestSource"
ingest_api_S3IngestSource.__qualname__ = "S3IngestSource"
ingest_api_S3IngestSource.__module__ = "nominal_api.ingest_api"


class ingest_api_ScaleParameter(ConjureUnionType):
    _true_frame_rate: Optional[float] = None
    _ending_timestamp: Optional["ingest_api_UtcTimestamp"] = None
    _scale_factor: Optional[float] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'true_frame_rate': ConjureFieldDefinition('trueFrameRate', float),
            'ending_timestamp': ConjureFieldDefinition('endingTimestamp', ingest_api_UtcTimestamp),
            'scale_factor': ConjureFieldDefinition('scaleFactor', float)
        }

    def __init__(
            self,
            true_frame_rate: Optional[float] = None,
            ending_timestamp: Optional["ingest_api_UtcTimestamp"] = None,
            scale_factor: Optional[float] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (true_frame_rate is not None) + (ending_timestamp is not None) + (scale_factor is not None) != 1:
                raise ValueError('a union must contain a single member')

            if true_frame_rate is not None:
                self._true_frame_rate = true_frame_rate
                self._type = 'trueFrameRate'
            if ending_timestamp is not None:
                self._ending_timestamp = ending_timestamp
                self._type = 'endingTimestamp'
            if scale_factor is not None:
                self._scale_factor = scale_factor
                self._type = 'scaleFactor'

        elif type_of_union == 'trueFrameRate':
            if true_frame_rate is None:
                raise ValueError('a union value must not be None')
            self._true_frame_rate = true_frame_rate
            self._type = 'trueFrameRate'
        elif type_of_union == 'endingTimestamp':
            if ending_timestamp is None:
                raise ValueError('a union value must not be None')
            self._ending_timestamp = ending_timestamp
            self._type = 'endingTimestamp'
        elif type_of_union == 'scaleFactor':
            if scale_factor is None:
                raise ValueError('a union value must not be None')
            self._scale_factor = scale_factor
            self._type = 'scaleFactor'

    @builtins.property
    def true_frame_rate(self) -> Optional[float]:
        return self._true_frame_rate

    @builtins.property
    def ending_timestamp(self) -> Optional["ingest_api_UtcTimestamp"]:
        """the timestamp corresponding to absolute starting timestamp plus absolute duration of the video.
        """
        return self._ending_timestamp

    @builtins.property
    def scale_factor(self) -> Optional[float]:
        """the scale factor can be used to calculate whether media duration differs from a video's | real duration, and if so, the true frame rate of the camera. The video time will thus be scaled | by the ratio of the real duration to media duration, or media frame rate to true frame rate.
        """
        return self._scale_factor

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_ScaleParameterVisitor):
            raise ValueError('{} is not an instance of ingest_api_ScaleParameterVisitor'.format(visitor.__class__.__name__))
        if self._type == 'trueFrameRate' and self.true_frame_rate is not None:
            return visitor._true_frame_rate(self.true_frame_rate)
        if self._type == 'endingTimestamp' and self.ending_timestamp is not None:
            return visitor._ending_timestamp(self.ending_timestamp)
        if self._type == 'scaleFactor' and self.scale_factor is not None:
            return visitor._scale_factor(self.scale_factor)


ingest_api_ScaleParameter.__name__ = "ScaleParameter"
ingest_api_ScaleParameter.__qualname__ = "ScaleParameter"
ingest_api_ScaleParameter.__module__ = "nominal_api.ingest_api"


class ingest_api_ScaleParameterVisitor:

    @abstractmethod
    def _true_frame_rate(self, true_frame_rate: float) -> Any:
        pass

    @abstractmethod
    def _ending_timestamp(self, ending_timestamp: "ingest_api_UtcTimestamp") -> Any:
        pass

    @abstractmethod
    def _scale_factor(self, scale_factor: float) -> Any:
        pass


ingest_api_ScaleParameterVisitor.__name__ = "ScaleParameterVisitor"
ingest_api_ScaleParameterVisitor.__qualname__ = "ScaleParameterVisitor"
ingest_api_ScaleParameterVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_SearchContainerizedExtractorsQuery(ConjureUnionType):
    _search_text: Optional[str] = None
    _label: Optional[str] = None
    _property: Optional["api_Property"] = None
    _and_: Optional[List["ingest_api_SearchContainerizedExtractorsQuery"]] = None
    _or_: Optional[List["ingest_api_SearchContainerizedExtractorsQuery"]] = None
    _workspace: Optional[str] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'search_text': ConjureFieldDefinition('searchText', str),
            'label': ConjureFieldDefinition('label', api_Label),
            'property': ConjureFieldDefinition('property', api_Property),
            'and_': ConjureFieldDefinition('and', List[ingest_api_SearchContainerizedExtractorsQuery]),
            'or_': ConjureFieldDefinition('or', List[ingest_api_SearchContainerizedExtractorsQuery]),
            'workspace': ConjureFieldDefinition('workspace', api_rids_WorkspaceRid)
        }

    def __init__(
            self,
            search_text: Optional[str] = None,
            label: Optional[str] = None,
            property: Optional["api_Property"] = None,
            and_: Optional[List["ingest_api_SearchContainerizedExtractorsQuery"]] = None,
            or_: Optional[List["ingest_api_SearchContainerizedExtractorsQuery"]] = None,
            workspace: Optional[str] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (search_text is not None) + (label is not None) + (property is not None) + (and_ is not None) + (or_ is not None) + (workspace is not None) != 1:
                raise ValueError('a union must contain a single member')

            if search_text is not None:
                self._search_text = search_text
                self._type = 'searchText'
            if label is not None:
                self._label = label
                self._type = 'label'
            if property is not None:
                self._property = property
                self._type = 'property'
            if and_ is not None:
                self._and_ = and_
                self._type = 'and'
            if or_ is not None:
                self._or_ = or_
                self._type = 'or'
            if workspace is not None:
                self._workspace = workspace
                self._type = 'workspace'

        elif type_of_union == 'searchText':
            if search_text is None:
                raise ValueError('a union value must not be None')
            self._search_text = search_text
            self._type = 'searchText'
        elif type_of_union == 'label':
            if label is None:
                raise ValueError('a union value must not be None')
            self._label = label
            self._type = 'label'
        elif type_of_union == 'property':
            if property is None:
                raise ValueError('a union value must not be None')
            self._property = property
            self._type = 'property'
        elif type_of_union == 'and':
            if and_ is None:
                raise ValueError('a union value must not be None')
            self._and_ = and_
            self._type = 'and'
        elif type_of_union == 'or':
            if or_ is None:
                raise ValueError('a union value must not be None')
            self._or_ = or_
            self._type = 'or'
        elif type_of_union == 'workspace':
            if workspace is None:
                raise ValueError('a union value must not be None')
            self._workspace = workspace
            self._type = 'workspace'

    @builtins.property
    def search_text(self) -> Optional[str]:
        return self._search_text

    @builtins.property
    def label(self) -> Optional[str]:
        return self._label

    @builtins.property
    def property(self) -> Optional["api_Property"]:
        return self._property

    @builtins.property
    def and_(self) -> Optional[List["ingest_api_SearchContainerizedExtractorsQuery"]]:
        return self._and_

    @builtins.property
    def or_(self) -> Optional[List["ingest_api_SearchContainerizedExtractorsQuery"]]:
        return self._or_

    @builtins.property
    def workspace(self) -> Optional[str]:
        return self._workspace

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_SearchContainerizedExtractorsQueryVisitor):
            raise ValueError('{} is not an instance of ingest_api_SearchContainerizedExtractorsQueryVisitor'.format(visitor.__class__.__name__))
        if self._type == 'searchText' and self.search_text is not None:
            return visitor._search_text(self.search_text)
        if self._type == 'label' and self.label is not None:
            return visitor._label(self.label)
        if self._type == 'property' and self.property is not None:
            return visitor._property(self.property)
        if self._type == 'and' and self.and_ is not None:
            return visitor._and(self.and_)
        if self._type == 'or' and self.or_ is not None:
            return visitor._or(self.or_)
        if self._type == 'workspace' and self.workspace is not None:
            return visitor._workspace(self.workspace)


ingest_api_SearchContainerizedExtractorsQuery.__name__ = "SearchContainerizedExtractorsQuery"
ingest_api_SearchContainerizedExtractorsQuery.__qualname__ = "SearchContainerizedExtractorsQuery"
ingest_api_SearchContainerizedExtractorsQuery.__module__ = "nominal_api.ingest_api"


class ingest_api_SearchContainerizedExtractorsQueryVisitor:

    @abstractmethod
    def _search_text(self, search_text: str) -> Any:
        pass

    @abstractmethod
    def _label(self, label: str) -> Any:
        pass

    @abstractmethod
    def _property(self, property: "api_Property") -> Any:
        pass

    @abstractmethod
    def _and(self, and_: List["ingest_api_SearchContainerizedExtractorsQuery"]) -> Any:
        pass

    @abstractmethod
    def _or(self, or_: List["ingest_api_SearchContainerizedExtractorsQuery"]) -> Any:
        pass

    @abstractmethod
    def _workspace(self, workspace: str) -> Any:
        pass


ingest_api_SearchContainerizedExtractorsQueryVisitor.__name__ = "SearchContainerizedExtractorsQueryVisitor"
ingest_api_SearchContainerizedExtractorsQueryVisitor.__qualname__ = "SearchContainerizedExtractorsQueryVisitor"
ingest_api_SearchContainerizedExtractorsQueryVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_SearchContainerizedExtractorsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'query': ConjureFieldDefinition('query', ingest_api_SearchContainerizedExtractorsQuery)
        }

    __slots__: List[str] = ['_query']

    def __init__(self, query: "ingest_api_SearchContainerizedExtractorsQuery") -> None:
        self._query = query

    @builtins.property
    def query(self) -> "ingest_api_SearchContainerizedExtractorsQuery":
        return self._query


ingest_api_SearchContainerizedExtractorsRequest.__name__ = "SearchContainerizedExtractorsRequest"
ingest_api_SearchContainerizedExtractorsRequest.__qualname__ = "SearchContainerizedExtractorsRequest"
ingest_api_SearchContainerizedExtractorsRequest.__module__ = "nominal_api.ingest_api"


class ingest_api_SignPartResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'url': ConjureFieldDefinition('url', str),
            'headers': ConjureFieldDefinition('headers', Dict[str, str])
        }

    __slots__: List[str] = ['_url', '_headers']

    def __init__(self, headers: Dict[str, str], url: str) -> None:
        self._url = url
        self._headers = headers

    @builtins.property
    def url(self) -> str:
        return self._url

    @builtins.property
    def headers(self) -> Dict[str, str]:
        return self._headers


ingest_api_SignPartResponse.__name__ = "SignPartResponse"
ingest_api_SignPartResponse.__qualname__ = "SignPartResponse"
ingest_api_SignPartResponse.__module__ = "nominal_api.ingest_api"


class ingest_api_TagDetails(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'tags': ConjureFieldDefinition('tags', List[str]),
            'default_tag': ConjureFieldDefinition('defaultTag', str)
        }

    __slots__: List[str] = ['_tags', '_default_tag']

    def __init__(self, default_tag: str, tags: List[str]) -> None:
        self._tags = tags
        self._default_tag = default_tag

    @builtins.property
    def tags(self) -> List[str]:
        return self._tags

    @builtins.property
    def default_tag(self) -> str:
        return self._default_tag


ingest_api_TagDetails.__name__ = "TagDetails"
ingest_api_TagDetails.__qualname__ = "TagDetails"
ingest_api_TagDetails.__module__ = "nominal_api.ingest_api"


class ingest_api_TimeOffsetSpec(ConjureUnionType):
    _nanos: Optional["scout_run_api_Duration"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'nanos': ConjureFieldDefinition('nanos', scout_run_api_Duration)
        }

    def __init__(
            self,
            nanos: Optional["scout_run_api_Duration"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (nanos is not None) != 1:
                raise ValueError('a union must contain a single member')

            if nanos is not None:
                self._nanos = nanos
                self._type = 'nanos'

        elif type_of_union == 'nanos':
            if nanos is None:
                raise ValueError('a union value must not be None')
            self._nanos = nanos
            self._type = 'nanos'

    @builtins.property
    def nanos(self) -> Optional["scout_run_api_Duration"]:
        return self._nanos

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_TimeOffsetSpecVisitor):
            raise ValueError('{} is not an instance of ingest_api_TimeOffsetSpecVisitor'.format(visitor.__class__.__name__))
        if self._type == 'nanos' and self.nanos is not None:
            return visitor._nanos(self.nanos)


ingest_api_TimeOffsetSpec.__name__ = "TimeOffsetSpec"
ingest_api_TimeOffsetSpec.__qualname__ = "TimeOffsetSpec"
ingest_api_TimeOffsetSpec.__module__ = "nominal_api.ingest_api"


class ingest_api_TimeOffsetSpecVisitor:

    @abstractmethod
    def _nanos(self, nanos: "scout_run_api_Duration") -> Any:
        pass


ingest_api_TimeOffsetSpecVisitor.__name__ = "TimeOffsetSpecVisitor"
ingest_api_TimeOffsetSpecVisitor.__qualname__ = "TimeOffsetSpecVisitor"
ingest_api_TimeOffsetSpecVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_TimestampManifest(ConjureBeanType):
    """The timestamp manifest files will contain a list of absolute timestamps, in nanoseconds, that correspond to
each frame in a video. Each file should be of type JSON and store a single list, the length of which equals
the number of frames in its corresponding video.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'sources': ConjureFieldDefinition('sources', List[ingest_api_IngestSource])
        }

    __slots__: List[str] = ['_sources']

    def __init__(self, sources: List["ingest_api_IngestSource"]) -> None:
        self._sources = sources

    @builtins.property
    def sources(self) -> List["ingest_api_IngestSource"]:
        return self._sources


ingest_api_TimestampManifest.__name__ = "TimestampManifest"
ingest_api_TimestampManifest.__qualname__ = "TimestampManifest"
ingest_api_TimestampManifest.__module__ = "nominal_api.ingest_api"


class ingest_api_TimestampMetadata(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'series_name': ConjureFieldDefinition('seriesName', str),
            'timestamp_type': ConjureFieldDefinition('timestampType', ingest_api_TimestampType)
        }

    __slots__: List[str] = ['_series_name', '_timestamp_type']

    def __init__(self, series_name: str, timestamp_type: "ingest_api_TimestampType") -> None:
        self._series_name = series_name
        self._timestamp_type = timestamp_type

    @builtins.property
    def series_name(self) -> str:
        return self._series_name

    @builtins.property
    def timestamp_type(self) -> "ingest_api_TimestampType":
        return self._timestamp_type


ingest_api_TimestampMetadata.__name__ = "TimestampMetadata"
ingest_api_TimestampMetadata.__qualname__ = "TimestampMetadata"
ingest_api_TimestampMetadata.__module__ = "nominal_api.ingest_api"


class ingest_api_TimestampType(ConjureUnionType):
    _relative: Optional["ingest_api_RelativeTimestamp"] = None
    _absolute: Optional["ingest_api_AbsoluteTimestamp"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'relative': ConjureFieldDefinition('relative', ingest_api_RelativeTimestamp),
            'absolute': ConjureFieldDefinition('absolute', ingest_api_AbsoluteTimestamp)
        }

    def __init__(
            self,
            relative: Optional["ingest_api_RelativeTimestamp"] = None,
            absolute: Optional["ingest_api_AbsoluteTimestamp"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (relative is not None) + (absolute is not None) != 1:
                raise ValueError('a union must contain a single member')

            if relative is not None:
                self._relative = relative
                self._type = 'relative'
            if absolute is not None:
                self._absolute = absolute
                self._type = 'absolute'

        elif type_of_union == 'relative':
            if relative is None:
                raise ValueError('a union value must not be None')
            self._relative = relative
            self._type = 'relative'
        elif type_of_union == 'absolute':
            if absolute is None:
                raise ValueError('a union value must not be None')
            self._absolute = absolute
            self._type = 'absolute'

    @builtins.property
    def relative(self) -> Optional["ingest_api_RelativeTimestamp"]:
        return self._relative

    @builtins.property
    def absolute(self) -> Optional["ingest_api_AbsoluteTimestamp"]:
        return self._absolute

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_TimestampTypeVisitor):
            raise ValueError('{} is not an instance of ingest_api_TimestampTypeVisitor'.format(visitor.__class__.__name__))
        if self._type == 'relative' and self.relative is not None:
            return visitor._relative(self.relative)
        if self._type == 'absolute' and self.absolute is not None:
            return visitor._absolute(self.absolute)


ingest_api_TimestampType.__name__ = "TimestampType"
ingest_api_TimestampType.__qualname__ = "TimestampType"
ingest_api_TimestampType.__module__ = "nominal_api.ingest_api"


class ingest_api_TimestampTypeVisitor:

    @abstractmethod
    def _relative(self, relative: "ingest_api_RelativeTimestamp") -> Any:
        pass

    @abstractmethod
    def _absolute(self, absolute: "ingest_api_AbsoluteTimestamp") -> Any:
        pass


ingest_api_TimestampTypeVisitor.__name__ = "TimestampTypeVisitor"
ingest_api_TimestampTypeVisitor.__qualname__ = "TimestampTypeVisitor"
ingest_api_TimestampTypeVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_UpdateContainerizedExtractorRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', OptionalTypeWrapper[str]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'inputs': ConjureFieldDefinition('inputs', OptionalTypeWrapper[List[ingest_api_FileExtractionInput]]),
            'parameters': ConjureFieldDefinition('parameters', OptionalTypeWrapper[List[ingest_api_FileExtractionParameter]]),
            'properties': ConjureFieldDefinition('properties', OptionalTypeWrapper[Dict[api_PropertyName, api_PropertyValue]]),
            'labels': ConjureFieldDefinition('labels', OptionalTypeWrapper[List[api_Label]]),
            'timestamp_metadata': ConjureFieldDefinition('timestampMetadata', OptionalTypeWrapper[ingest_api_TimestampMetadata]),
            'output_file_format': ConjureFieldDefinition('outputFileFormat', OptionalTypeWrapper[ingest_api_FileOutputFormat]),
            'registry': ConjureFieldDefinition('registry', OptionalTypeWrapper[str]),
            'repository': ConjureFieldDefinition('repository', OptionalTypeWrapper[str]),
            'tags': ConjureFieldDefinition('tags', OptionalTypeWrapper[List[str]]),
            'default_tag': ConjureFieldDefinition('defaultTag', OptionalTypeWrapper[str]),
            'authentication': ConjureFieldDefinition('authentication', OptionalTypeWrapper[ingest_api_Authentication]),
            'command': ConjureFieldDefinition('command', OptionalTypeWrapper[str])
        }

    __slots__: List[str] = ['_name', '_description', '_inputs', '_parameters', '_properties', '_labels', '_timestamp_metadata', '_output_file_format', '_registry', '_repository', '_tags', '_default_tag', '_authentication', '_command']

    def __init__(self, authentication: Optional["ingest_api_Authentication"] = None, command: Optional[str] = None, default_tag: Optional[str] = None, description: Optional[str] = None, inputs: Optional[List["ingest_api_FileExtractionInput"]] = None, labels: Optional[List[str]] = None, name: Optional[str] = None, output_file_format: Optional["ingest_api_FileOutputFormat"] = None, parameters: Optional[List["ingest_api_FileExtractionParameter"]] = None, properties: Optional[Dict[str, str]] = None, registry: Optional[str] = None, repository: Optional[str] = None, tags: Optional[List[str]] = None, timestamp_metadata: Optional["ingest_api_TimestampMetadata"] = None) -> None:
        self._name = name
        self._description = description
        self._inputs = inputs
        self._parameters = parameters
        self._properties = properties
        self._labels = labels
        self._timestamp_metadata = timestamp_metadata
        self._output_file_format = output_file_format
        self._registry = registry
        self._repository = repository
        self._tags = tags
        self._default_tag = default_tag
        self._authentication = authentication
        self._command = command

    @builtins.property
    def name(self) -> Optional[str]:
        return self._name

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def inputs(self) -> Optional[List["ingest_api_FileExtractionInput"]]:
        return self._inputs

    @builtins.property
    def parameters(self) -> Optional[List["ingest_api_FileExtractionParameter"]]:
        return self._parameters

    @builtins.property
    def properties(self) -> Optional[Dict[str, str]]:
        return self._properties

    @builtins.property
    def labels(self) -> Optional[List[str]]:
        return self._labels

    @builtins.property
    def timestamp_metadata(self) -> Optional["ingest_api_TimestampMetadata"]:
        return self._timestamp_metadata

    @builtins.property
    def output_file_format(self) -> Optional["ingest_api_FileOutputFormat"]:
        return self._output_file_format

    @builtins.property
    def registry(self) -> Optional[str]:
        return self._registry

    @builtins.property
    def repository(self) -> Optional[str]:
        return self._repository

    @builtins.property
    def tags(self) -> Optional[List[str]]:
        return self._tags

    @builtins.property
    def default_tag(self) -> Optional[str]:
        return self._default_tag

    @builtins.property
    def authentication(self) -> Optional["ingest_api_Authentication"]:
        return self._authentication

    @builtins.property
    def command(self) -> Optional[str]:
        return self._command


ingest_api_UpdateContainerizedExtractorRequest.__name__ = "UpdateContainerizedExtractorRequest"
ingest_api_UpdateContainerizedExtractorRequest.__qualname__ = "UpdateContainerizedExtractorRequest"
ingest_api_UpdateContainerizedExtractorRequest.__module__ = "nominal_api.ingest_api"


class ingest_api_UserAndPasswordAuthentication(ConjureBeanType):
    """Username and password authentication.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'username': ConjureFieldDefinition('username', str),
            'password_secret_rid': ConjureFieldDefinition('passwordSecretRid', secrets_api_SecretRid)
        }

    __slots__: List[str] = ['_username', '_password_secret_rid']

    def __init__(self, password_secret_rid: str, username: str) -> None:
        self._username = username
        self._password_secret_rid = password_secret_rid

    @builtins.property
    def username(self) -> str:
        """Username for registry authentication.
        """
        return self._username

    @builtins.property
    def password_secret_rid(self) -> str:
        """The RID of the secret containing the password for registry authentication.
        """
        return self._password_secret_rid


ingest_api_UserAndPasswordAuthentication.__name__ = "UserAndPasswordAuthentication"
ingest_api_UserAndPasswordAuthentication.__qualname__ = "UserAndPasswordAuthentication"
ingest_api_UserAndPasswordAuthentication.__module__ = "nominal_api.ingest_api"


class ingest_api_UtcTimestamp(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'seconds_since_epoch': ConjureFieldDefinition('secondsSinceEpoch', int),
            'offset_nanoseconds': ConjureFieldDefinition('offsetNanoseconds', OptionalTypeWrapper[int])
        }

    __slots__: List[str] = ['_seconds_since_epoch', '_offset_nanoseconds']

    def __init__(self, seconds_since_epoch: int, offset_nanoseconds: Optional[int] = None) -> None:
        self._seconds_since_epoch = seconds_since_epoch
        self._offset_nanoseconds = offset_nanoseconds

    @builtins.property
    def seconds_since_epoch(self) -> int:
        return self._seconds_since_epoch

    @builtins.property
    def offset_nanoseconds(self) -> Optional[int]:
        return self._offset_nanoseconds


ingest_api_UtcTimestamp.__name__ = "UtcTimestamp"
ingest_api_UtcTimestamp.__qualname__ = "UtcTimestamp"
ingest_api_UtcTimestamp.__module__ = "nominal_api.ingest_api"


class ingest_api_VideoFileIngestDetails(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'file_description': ConjureFieldDefinition('fileDescription', OptionalTypeWrapper[str]),
            'file_properties': ConjureFieldDefinition('fileProperties', OptionalTypeWrapper[Dict[api_PropertyName, api_PropertyValue]]),
            'file_labels': ConjureFieldDefinition('fileLabels', OptionalTypeWrapper[List[api_Label]])
        }

    __slots__: List[str] = ['_file_description', '_file_properties', '_file_labels']

    def __init__(self, file_description: Optional[str] = None, file_labels: Optional[List[str]] = None, file_properties: Optional[Dict[str, str]] = None) -> None:
        self._file_description = file_description
        self._file_properties = file_properties
        self._file_labels = file_labels

    @builtins.property
    def file_description(self) -> Optional[str]:
        """Description that is applied to the newly created video file.
If not provided, defaults to the description used to create the video.
        """
        return self._file_description

    @builtins.property
    def file_properties(self) -> Optional[Dict[str, str]]:
        """Key-Value properties that are applied to the newly created video file.
        """
        return self._file_properties

    @builtins.property
    def file_labels(self) -> Optional[List[str]]:
        """Labels that are applied to the newly created video file.
        """
        return self._file_labels


ingest_api_VideoFileIngestDetails.__name__ = "VideoFileIngestDetails"
ingest_api_VideoFileIngestDetails.__qualname__ = "VideoFileIngestDetails"
ingest_api_VideoFileIngestDetails.__module__ = "nominal_api.ingest_api"


class ingest_api_VideoIngestTarget(ConjureUnionType):
    _new: Optional["ingest_api_NewVideoIngestDestination"] = None
    _existing: Optional["ingest_api_ExistingVideoIngestDestination"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'new': ConjureFieldDefinition('new', ingest_api_NewVideoIngestDestination),
            'existing': ConjureFieldDefinition('existing', ingest_api_ExistingVideoIngestDestination)
        }

    def __init__(
            self,
            new: Optional["ingest_api_NewVideoIngestDestination"] = None,
            existing: Optional["ingest_api_ExistingVideoIngestDestination"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (new is not None) + (existing is not None) != 1:
                raise ValueError('a union must contain a single member')

            if new is not None:
                self._new = new
                self._type = 'new'
            if existing is not None:
                self._existing = existing
                self._type = 'existing'

        elif type_of_union == 'new':
            if new is None:
                raise ValueError('a union value must not be None')
            self._new = new
            self._type = 'new'
        elif type_of_union == 'existing':
            if existing is None:
                raise ValueError('a union value must not be None')
            self._existing = existing
            self._type = 'existing'

    @builtins.property
    def new(self) -> Optional["ingest_api_NewVideoIngestDestination"]:
        return self._new

    @builtins.property
    def existing(self) -> Optional["ingest_api_ExistingVideoIngestDestination"]:
        return self._existing

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_VideoIngestTargetVisitor):
            raise ValueError('{} is not an instance of ingest_api_VideoIngestTargetVisitor'.format(visitor.__class__.__name__))
        if self._type == 'new' and self.new is not None:
            return visitor._new(self.new)
        if self._type == 'existing' and self.existing is not None:
            return visitor._existing(self.existing)


ingest_api_VideoIngestTarget.__name__ = "VideoIngestTarget"
ingest_api_VideoIngestTarget.__qualname__ = "VideoIngestTarget"
ingest_api_VideoIngestTarget.__module__ = "nominal_api.ingest_api"


class ingest_api_VideoIngestTargetVisitor:

    @abstractmethod
    def _new(self, new: "ingest_api_NewVideoIngestDestination") -> Any:
        pass

    @abstractmethod
    def _existing(self, existing: "ingest_api_ExistingVideoIngestDestination") -> Any:
        pass


ingest_api_VideoIngestTargetVisitor.__name__ = "VideoIngestTargetVisitor"
ingest_api_VideoIngestTargetVisitor.__qualname__ = "VideoIngestTargetVisitor"
ingest_api_VideoIngestTargetVisitor.__module__ = "nominal_api.ingest_api"


class ingest_api_VideoOpts(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'source': ConjureFieldDefinition('source', ingest_api_IngestSource),
            'target': ConjureFieldDefinition('target', ingest_api_VideoIngestTarget),
            'timestamp_manifest': ConjureFieldDefinition('timestampManifest', scout_video_api_VideoFileTimestampManifest)
        }

    __slots__: List[str] = ['_source', '_target', '_timestamp_manifest']

    def __init__(self, source: "ingest_api_IngestSource", target: "ingest_api_VideoIngestTarget", timestamp_manifest: "scout_video_api_VideoFileTimestampManifest") -> None:
        self._source = source
        self._target = target
        self._timestamp_manifest = timestamp_manifest

    @builtins.property
    def source(self) -> "ingest_api_IngestSource":
        return self._source

    @builtins.property
    def target(self) -> "ingest_api_VideoIngestTarget":
        return self._target

    @builtins.property
    def timestamp_manifest(self) -> "scout_video_api_VideoFileTimestampManifest":
        return self._timestamp_manifest


ingest_api_VideoOpts.__name__ = "VideoOpts"
ingest_api_VideoOpts.__qualname__ = "VideoOpts"
ingest_api_VideoOpts.__module__ = "nominal_api.ingest_api"


class ingest_api_VideoTimestampManifest(ConjureUnionType):
    _no_manifest: Optional["ingest_api_NoTimestampManifest"] = None
    _timestamp_manifests: Optional["ingest_api_TimestampManifest"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'no_manifest': ConjureFieldDefinition('noManifest', ingest_api_NoTimestampManifest),
            'timestamp_manifests': ConjureFieldDefinition('timestampManifests', ingest_api_TimestampManifest)
        }

    def __init__(
            self,
            no_manifest: Optional["ingest_api_NoTimestampManifest"] = None,
            timestamp_manifests: Optional["ingest_api_TimestampManifest"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (no_manifest is not None) + (timestamp_manifests is not None) != 1:
                raise ValueError('a union must contain a single member')

            if no_manifest is not None:
                self._no_manifest = no_manifest
                self._type = 'noManifest'
            if timestamp_manifests is not None:
                self._timestamp_manifests = timestamp_manifests
                self._type = 'timestampManifests'

        elif type_of_union == 'noManifest':
            if no_manifest is None:
                raise ValueError('a union value must not be None')
            self._no_manifest = no_manifest
            self._type = 'noManifest'
        elif type_of_union == 'timestampManifests':
            if timestamp_manifests is None:
                raise ValueError('a union value must not be None')
            self._timestamp_manifests = timestamp_manifests
            self._type = 'timestampManifests'

    @builtins.property
    def no_manifest(self) -> Optional["ingest_api_NoTimestampManifest"]:
        return self._no_manifest

    @builtins.property
    def timestamp_manifests(self) -> Optional["ingest_api_TimestampManifest"]:
        return self._timestamp_manifests

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_api_VideoTimestampManifestVisitor):
            raise ValueError('{} is not an instance of ingest_api_VideoTimestampManifestVisitor'.format(visitor.__class__.__name__))
        if self._type == 'noManifest' and self.no_manifest is not None:
            return visitor._no_manifest(self.no_manifest)
        if self._type == 'timestampManifests' and self.timestamp_manifests is not None:
            return visitor._timestamp_manifests(self.timestamp_manifests)


ingest_api_VideoTimestampManifest.__name__ = "VideoTimestampManifest"
ingest_api_VideoTimestampManifest.__qualname__ = "VideoTimestampManifest"
ingest_api_VideoTimestampManifest.__module__ = "nominal_api.ingest_api"


class ingest_api_VideoTimestampManifestVisitor:

    @abstractmethod
    def _no_manifest(self, no_manifest: "ingest_api_NoTimestampManifest") -> Any:
        pass

    @abstractmethod
    def _timestamp_manifests(self, timestamp_manifests: "ingest_api_TimestampManifest") -> Any:
        pass


ingest_api_VideoTimestampManifestVisitor.__name__ = "VideoTimestampManifestVisitor"
ingest_api_VideoTimestampManifestVisitor.__qualname__ = "VideoTimestampManifestVisitor"
ingest_api_VideoTimestampManifestVisitor.__module__ = "nominal_api.ingest_api"


class ingest_manifest_ExtractorManifest(ConjureBeanType):
    """Manifest file produced by containerized extractors to describe their outputs.
This is written as manifest.json in the OUTPUT_DIR by the container.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'outputs': ConjureFieldDefinition('outputs', List[ingest_manifest_ManifestOutput])
        }

    __slots__: List[str] = ['_outputs']

    def __init__(self, outputs: List["ingest_manifest_ManifestOutput"]) -> None:
        self._outputs = outputs

    @builtins.property
    def outputs(self) -> List["ingest_manifest_ManifestOutput"]:
        """List of output files produced by the extractor
        """
        return self._outputs


ingest_manifest_ExtractorManifest.__name__ = "ExtractorManifest"
ingest_manifest_ExtractorManifest.__qualname__ = "ExtractorManifest"
ingest_manifest_ExtractorManifest.__module__ = "nominal_api.ingest_manifest"


class ingest_manifest_ExtractorUploadMetadata(ConjureBeanType):
    """Metadata file created by yeeter after uploading extractor outputs to S3.
This is uploaded to S3 by yeeter and read by the Temporal activity to orchestrate ingestion.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'uploads': ConjureFieldDefinition('uploads', List[ingest_manifest_UploadMetadata])
        }

    __slots__: List[str] = ['_uploads']

    def __init__(self, uploads: List["ingest_manifest_UploadMetadata"]) -> None:
        self._uploads = uploads

    @builtins.property
    def uploads(self) -> List["ingest_manifest_UploadMetadata"]:
        """List of uploaded files with their S3 locations and manifest metadata
        """
        return self._uploads


ingest_manifest_ExtractorUploadMetadata.__name__ = "ExtractorUploadMetadata"
ingest_manifest_ExtractorUploadMetadata.__qualname__ = "ExtractorUploadMetadata"
ingest_manifest_ExtractorUploadMetadata.__module__ = "nominal_api.ingest_manifest"


class ingest_manifest_ManifestIngestType(ConjureEnumType):
    """Supported ingest types for containerized extractor outputs.
    """

    PARQUET = 'PARQUET'
    '''PARQUET'''
    CSV = 'CSV'
    '''CSV'''
    PARQUET_TAR = 'PARQUET_TAR'
    '''PARQUET_TAR'''
    AVRO_STREAM = 'AVRO_STREAM'
    '''AVRO_STREAM'''
    JSON_L = 'JSON_L'
    '''JSON_L'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


ingest_manifest_ManifestIngestType.__name__ = "ManifestIngestType"
ingest_manifest_ManifestIngestType.__qualname__ = "ManifestIngestType"
ingest_manifest_ManifestIngestType.__module__ = "nominal_api.ingest_manifest"


class ingest_manifest_ManifestOutput(ConjureBeanType):
    """Describes a single output file from a containerized extractor.
This is written by the container in manifest.json.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'ingest_type': ConjureFieldDefinition('ingestType', ingest_manifest_ManifestIngestType),
            'relative_path': ConjureFieldDefinition('relativePath', str),
            'tag_columns': ConjureFieldDefinition('tagColumns', Dict[str, str]),
            'channel_prefix': ConjureFieldDefinition('channelPrefix', OptionalTypeWrapper[str])
        }

    __slots__: List[str] = ['_ingest_type', '_relative_path', '_tag_columns', '_channel_prefix']

    def __init__(self, ingest_type: "ingest_manifest_ManifestIngestType", relative_path: str, tag_columns: Dict[str, str], channel_prefix: Optional[str] = None) -> None:
        self._ingest_type = ingest_type
        self._relative_path = relative_path
        self._tag_columns = tag_columns
        self._channel_prefix = channel_prefix

    @builtins.property
    def ingest_type(self) -> "ingest_manifest_ManifestIngestType":
        """The type of ingestion for this output file
        """
        return self._ingest_type

    @builtins.property
    def relative_path(self) -> str:
        """Relative path to the output file within OUTPUT_DIR.
Example: "telemetry.csv" or "data/sensor_readings.parquet"
        """
        return self._relative_path

    @builtins.property
    def tag_columns(self) -> Dict[str, str]:
        """Optional mapping of tag names to column names for CSV/Parquet ingestion.
Example: {"vehicle_id": "veh_id", "mission_id": "msn_id"}
        """
        return self._tag_columns

    @builtins.property
    def channel_prefix(self) -> Optional[str]:
        """Optional prefix to prepend to channel names during ingestion.
Example: "telemetry/" would create channels like "telemetry/speed", "telemetry/altitude"
        """
        return self._channel_prefix


ingest_manifest_ManifestOutput.__name__ = "ManifestOutput"
ingest_manifest_ManifestOutput.__qualname__ = "ManifestOutput"
ingest_manifest_ManifestOutput.__module__ = "nominal_api.ingest_manifest"


class ingest_manifest_UploadMetadata(ConjureBeanType):
    """Metadata about a single file uploaded to S3 by yeeter.
Enriches the original manifest entry with S3 upload information.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            's3_key': ConjureFieldDefinition('s3Key', str),
            's3_bucket': ConjureFieldDefinition('s3Bucket', str),
            'manifest_output': ConjureFieldDefinition('manifestOutput', ingest_manifest_ManifestOutput)
        }

    __slots__: List[str] = ['_s3_key', '_s3_bucket', '_manifest_output']

    def __init__(self, manifest_output: "ingest_manifest_ManifestOutput", s3_bucket: str, s3_key: str) -> None:
        self._s3_key = s3_key
        self._s3_bucket = s3_bucket
        self._manifest_output = manifest_output

    @builtins.property
    def s3_key(self) -> str:
        """Full S3 key where the file was uploaded
        """
        return self._s3_key

    @builtins.property
    def s3_bucket(self) -> str:
        """S3 bucket name where the file was uploaded
        """
        return self._s3_bucket

    @builtins.property
    def manifest_output(self) -> "ingest_manifest_ManifestOutput":
        """The original manifest entry from the container's manifest.yaml
        """
        return self._manifest_output


ingest_manifest_UploadMetadata.__name__ = "UploadMetadata"
ingest_manifest_UploadMetadata.__qualname__ = "UploadMetadata"
ingest_manifest_UploadMetadata.__module__ = "nominal_api.ingest_manifest"


class ingest_workflow_api_CreateIngestJobRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'workspace_rid': ConjureFieldDefinition('workspaceRid', api_rids_WorkspaceRid),
            'ingest_job_request': ConjureFieldDefinition('ingestJobRequest', ingest_api_IngestJobRequest)
        }

    __slots__: List[str] = ['_workspace_rid', '_ingest_job_request']

    def __init__(self, ingest_job_request: "ingest_api_IngestJobRequest", workspace_rid: str) -> None:
        self._workspace_rid = workspace_rid
        self._ingest_job_request = ingest_job_request

    @builtins.property
    def workspace_rid(self) -> str:
        return self._workspace_rid

    @builtins.property
    def ingest_job_request(self) -> "ingest_api_IngestJobRequest":
        return self._ingest_job_request


ingest_workflow_api_CreateIngestJobRequest.__name__ = "CreateIngestJobRequest"
ingest_workflow_api_CreateIngestJobRequest.__qualname__ = "CreateIngestJobRequest"
ingest_workflow_api_CreateIngestJobRequest.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_Empty(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



ingest_workflow_api_Empty.__name__ = "Empty"
ingest_workflow_api_Empty.__qualname__ = "Empty"
ingest_workflow_api_Empty.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_EnsureExtractorJobCreatedRequest(ConjureBeanType):
    """Ensure that the extractor job exists in the control plane. Runs in the namespace given by workspaceRid.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'bearer_token': ConjureFieldDefinition('bearerToken', str),
            'workspace_rid': ConjureFieldDefinition('workspaceRid', api_rids_WorkspaceRid),
            'ingest_job_uuid': ConjureFieldDefinition('ingestJobUuid', str),
            'containerized_extractor': ConjureFieldDefinition('containerizedExtractor', ingest_api_ContainerizedExtractor),
            'tag': ConjureFieldDefinition('tag', str),
            'validated_file_inputs': ConjureFieldDefinition('validatedFileInputs', List[ingest_workflow_api_ValidatedFileInput]),
            'multipart_upload_details': ConjureFieldDefinition('multipartUploadDetails', ingest_workflow_api_MultipartUploadDetails),
            'image_pull_secret_name': ConjureFieldDefinition('imagePullSecretName', OptionalTypeWrapper[str]),
            'arguments': ConjureFieldDefinition('arguments', Dict[ingest_api_EnvironmentVariable, str])
        }

    __slots__: List[str] = ['_bearer_token', '_workspace_rid', '_ingest_job_uuid', '_containerized_extractor', '_tag', '_validated_file_inputs', '_multipart_upload_details', '_image_pull_secret_name', '_arguments']

    def __init__(self, arguments: Dict[str, str], bearer_token: str, containerized_extractor: "ingest_api_ContainerizedExtractor", ingest_job_uuid: str, multipart_upload_details: "ingest_workflow_api_MultipartUploadDetails", tag: str, validated_file_inputs: List["ingest_workflow_api_ValidatedFileInput"], workspace_rid: str, image_pull_secret_name: Optional[str] = None) -> None:
        self._bearer_token = bearer_token
        self._workspace_rid = workspace_rid
        self._ingest_job_uuid = ingest_job_uuid
        self._containerized_extractor = containerized_extractor
        self._tag = tag
        self._validated_file_inputs = validated_file_inputs
        self._multipart_upload_details = multipart_upload_details
        self._image_pull_secret_name = image_pull_secret_name
        self._arguments = arguments

    @builtins.property
    def bearer_token(self) -> str:
        return self._bearer_token

    @builtins.property
    def workspace_rid(self) -> str:
        return self._workspace_rid

    @builtins.property
    def ingest_job_uuid(self) -> str:
        return self._ingest_job_uuid

    @builtins.property
    def containerized_extractor(self) -> "ingest_api_ContainerizedExtractor":
        return self._containerized_extractor

    @builtins.property
    def tag(self) -> str:
        return self._tag

    @builtins.property
    def validated_file_inputs(self) -> List["ingest_workflow_api_ValidatedFileInput"]:
        return self._validated_file_inputs

    @builtins.property
    def multipart_upload_details(self) -> "ingest_workflow_api_MultipartUploadDetails":
        return self._multipart_upload_details

    @builtins.property
    def image_pull_secret_name(self) -> Optional[str]:
        """Name of the Kubernetes secret to use for pulling the image, if authentication is required.
        """
        return self._image_pull_secret_name

    @builtins.property
    def arguments(self) -> Dict[str, str]:
        """Additional arguments to pass as environment variables to the container.
        """
        return self._arguments


ingest_workflow_api_EnsureExtractorJobCreatedRequest.__name__ = "EnsureExtractorJobCreatedRequest"
ingest_workflow_api_EnsureExtractorJobCreatedRequest.__qualname__ = "EnsureExtractorJobCreatedRequest"
ingest_workflow_api_EnsureExtractorJobCreatedRequest.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_EnsureExtractorJobCreatedResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



ingest_workflow_api_EnsureExtractorJobCreatedResponse.__name__ = "EnsureExtractorJobCreatedResponse"
ingest_workflow_api_EnsureExtractorJobCreatedResponse.__qualname__ = "EnsureExtractorJobCreatedResponse"
ingest_workflow_api_EnsureExtractorJobCreatedResponse.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_EnsureImagePullSecretCreatedRequest(ConjureBeanType):
    """Ensures a Kubernetes secret of type kubernetes.io/dockerconfigjson exists
for the given registry credentials.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'workspace_rid': ConjureFieldDefinition('workspaceRid', api_rids_WorkspaceRid),
            'image_source': ConjureFieldDefinition('imageSource', ingest_api_DockerImageSource),
            'authentication': ConjureFieldDefinition('authentication', ingest_api_UserAndPasswordAuthentication),
            'ingest_job_uuid': ConjureFieldDefinition('ingestJobUuid', str),
            'bearer_token': ConjureFieldDefinition('bearerToken', str)
        }

    __slots__: List[str] = ['_workspace_rid', '_image_source', '_authentication', '_ingest_job_uuid', '_bearer_token']

    def __init__(self, authentication: "ingest_api_UserAndPasswordAuthentication", bearer_token: str, image_source: "ingest_api_DockerImageSource", ingest_job_uuid: str, workspace_rid: str) -> None:
        self._workspace_rid = workspace_rid
        self._image_source = image_source
        self._authentication = authentication
        self._ingest_job_uuid = ingest_job_uuid
        self._bearer_token = bearer_token

    @builtins.property
    def workspace_rid(self) -> str:
        return self._workspace_rid

    @builtins.property
    def image_source(self) -> "ingest_api_DockerImageSource":
        return self._image_source

    @builtins.property
    def authentication(self) -> "ingest_api_UserAndPasswordAuthentication":
        return self._authentication

    @builtins.property
    def ingest_job_uuid(self) -> str:
        return self._ingest_job_uuid

    @builtins.property
    def bearer_token(self) -> str:
        return self._bearer_token


ingest_workflow_api_EnsureImagePullSecretCreatedRequest.__name__ = "EnsureImagePullSecretCreatedRequest"
ingest_workflow_api_EnsureImagePullSecretCreatedRequest.__qualname__ = "EnsureImagePullSecretCreatedRequest"
ingest_workflow_api_EnsureImagePullSecretCreatedRequest.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_EnsureImagePullSecretCreatedResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'secret_name': ConjureFieldDefinition('secretName', str)
        }

    __slots__: List[str] = ['_secret_name']

    def __init__(self, secret_name: str) -> None:
        self._secret_name = secret_name

    @builtins.property
    def secret_name(self) -> str:
        return self._secret_name


ingest_workflow_api_EnsureImagePullSecretCreatedResponse.__name__ = "EnsureImagePullSecretCreatedResponse"
ingest_workflow_api_EnsureImagePullSecretCreatedResponse.__qualname__ = "EnsureImagePullSecretCreatedResponse"
ingest_workflow_api_EnsureImagePullSecretCreatedResponse.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_EnsureWorkspaceConfigMapCreatedRequest(ConjureBeanType):
    """For a given workspace rid, ensures there is a log4j2 config map defined in the namespace.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'workspace_rid': ConjureFieldDefinition('workspaceRid', api_rids_WorkspaceRid)
        }

    __slots__: List[str] = ['_workspace_rid']

    def __init__(self, workspace_rid: str) -> None:
        self._workspace_rid = workspace_rid

    @builtins.property
    def workspace_rid(self) -> str:
        return self._workspace_rid


ingest_workflow_api_EnsureWorkspaceConfigMapCreatedRequest.__name__ = "EnsureWorkspaceConfigMapCreatedRequest"
ingest_workflow_api_EnsureWorkspaceConfigMapCreatedRequest.__qualname__ = "EnsureWorkspaceConfigMapCreatedRequest"
ingest_workflow_api_EnsureWorkspaceConfigMapCreatedRequest.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_EnsureWorkspaceNamespaceCreatedRequest(ConjureBeanType):
    """For a given workspace rid, ensures that there is a corresponding K8s namespace created.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'workspace_rid': ConjureFieldDefinition('workspaceRid', api_rids_WorkspaceRid)
        }

    __slots__: List[str] = ['_workspace_rid']

    def __init__(self, workspace_rid: str) -> None:
        self._workspace_rid = workspace_rid

    @builtins.property
    def workspace_rid(self) -> str:
        return self._workspace_rid


ingest_workflow_api_EnsureWorkspaceNamespaceCreatedRequest.__name__ = "EnsureWorkspaceNamespaceCreatedRequest"
ingest_workflow_api_EnsureWorkspaceNamespaceCreatedRequest.__qualname__ = "EnsureWorkspaceNamespaceCreatedRequest"
ingest_workflow_api_EnsureWorkspaceNamespaceCreatedRequest.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_EnsureWorkspaceServiceAccountCreatedRequest(ConjureBeanType):
    """For a given workspace rid, ensures that there is a service account in the proper K8s Namespace.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'workspace_rid': ConjureFieldDefinition('workspaceRid', api_rids_WorkspaceRid)
        }

    __slots__: List[str] = ['_workspace_rid']

    def __init__(self, workspace_rid: str) -> None:
        self._workspace_rid = workspace_rid

    @builtins.property
    def workspace_rid(self) -> str:
        return self._workspace_rid


ingest_workflow_api_EnsureWorkspaceServiceAccountCreatedRequest.__name__ = "EnsureWorkspaceServiceAccountCreatedRequest"
ingest_workflow_api_EnsureWorkspaceServiceAccountCreatedRequest.__qualname__ = "EnsureWorkspaceServiceAccountCreatedRequest"
ingest_workflow_api_EnsureWorkspaceServiceAccountCreatedRequest.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_ExtractorJobState(ConjureEnumType):

    PENDING = 'PENDING'
    '''PENDING'''
    RUNNING = 'RUNNING'
    '''RUNNING'''
    FAILED = 'FAILED'
    '''FAILED'''
    SUCCEEDED = 'SUCCEEDED'
    '''SUCCEEDED'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


ingest_workflow_api_ExtractorJobState.__name__ = "ExtractorJobState"
ingest_workflow_api_ExtractorJobState.__qualname__ = "ExtractorJobState"
ingest_workflow_api_ExtractorJobState.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_FetchExtractorJobLogsRequest(ConjureBeanType):
    """Request to fetch logs for all containers in a completed extractor job's pod.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'workspace_rid': ConjureFieldDefinition('workspaceRid', api_rids_WorkspaceRid),
            'log_dataset_rid': ConjureFieldDefinition('logDatasetRid', api_rids_DatasetRid),
            'ingest_job_uuid': ConjureFieldDefinition('ingestJobUuid', str),
            'bearer_token': ConjureFieldDefinition('bearerToken', str),
            'extractor_rid': ConjureFieldDefinition('extractorRid', ingest_api_ContainerizedExtractorRid)
        }

    __slots__: List[str] = ['_workspace_rid', '_log_dataset_rid', '_ingest_job_uuid', '_bearer_token', '_extractor_rid']

    def __init__(self, bearer_token: str, extractor_rid: str, ingest_job_uuid: str, log_dataset_rid: str, workspace_rid: str) -> None:
        self._workspace_rid = workspace_rid
        self._log_dataset_rid = log_dataset_rid
        self._ingest_job_uuid = ingest_job_uuid
        self._bearer_token = bearer_token
        self._extractor_rid = extractor_rid

    @builtins.property
    def workspace_rid(self) -> str:
        return self._workspace_rid

    @builtins.property
    def log_dataset_rid(self) -> str:
        return self._log_dataset_rid

    @builtins.property
    def ingest_job_uuid(self) -> str:
        return self._ingest_job_uuid

    @builtins.property
    def bearer_token(self) -> str:
        return self._bearer_token

    @builtins.property
    def extractor_rid(self) -> str:
        return self._extractor_rid


ingest_workflow_api_FetchExtractorJobLogsRequest.__name__ = "FetchExtractorJobLogsRequest"
ingest_workflow_api_FetchExtractorJobLogsRequest.__qualname__ = "FetchExtractorJobLogsRequest"
ingest_workflow_api_FetchExtractorJobLogsRequest.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_FetchExtractorJobLogsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



ingest_workflow_api_FetchExtractorJobLogsResponse.__name__ = "FetchExtractorJobLogsResponse"
ingest_workflow_api_FetchExtractorJobLogsResponse.__qualname__ = "FetchExtractorJobLogsResponse"
ingest_workflow_api_FetchExtractorJobLogsResponse.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_GetExtractorJobStateRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'workspace_rid': ConjureFieldDefinition('workspaceRid', api_rids_WorkspaceRid),
            'ingest_job_uuid': ConjureFieldDefinition('ingestJobUuid', str)
        }

    __slots__: List[str] = ['_workspace_rid', '_ingest_job_uuid']

    def __init__(self, ingest_job_uuid: str, workspace_rid: str) -> None:
        self._workspace_rid = workspace_rid
        self._ingest_job_uuid = ingest_job_uuid

    @builtins.property
    def workspace_rid(self) -> str:
        return self._workspace_rid

    @builtins.property
    def ingest_job_uuid(self) -> str:
        return self._ingest_job_uuid


ingest_workflow_api_GetExtractorJobStateRequest.__name__ = "GetExtractorJobStateRequest"
ingest_workflow_api_GetExtractorJobStateRequest.__qualname__ = "GetExtractorJobStateRequest"
ingest_workflow_api_GetExtractorJobStateRequest.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_GetExtractorJobStateResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'state': ConjureFieldDefinition('state', ingest_workflow_api_ExtractorJobState),
            'message': ConjureFieldDefinition('message', OptionalTypeWrapper[str])
        }

    __slots__: List[str] = ['_state', '_message']

    def __init__(self, state: "ingest_workflow_api_ExtractorJobState", message: Optional[str] = None) -> None:
        self._state = state
        self._message = message

    @builtins.property
    def state(self) -> "ingest_workflow_api_ExtractorJobState":
        return self._state

    @builtins.property
    def message(self) -> Optional[str]:
        return self._message


ingest_workflow_api_GetExtractorJobStateResponse.__name__ = "GetExtractorJobStateResponse"
ingest_workflow_api_GetExtractorJobStateResponse.__qualname__ = "GetExtractorJobStateResponse"
ingest_workflow_api_GetExtractorJobStateResponse.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_IngestDataflashRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'locator': ConjureFieldDefinition('locator', ingest_workflow_api_ObjectLocator)
        }

    __slots__: List[str] = ['_locator']

    def __init__(self, locator: "ingest_workflow_api_ObjectLocator") -> None:
        self._locator = locator

    @builtins.property
    def locator(self) -> "ingest_workflow_api_ObjectLocator":
        return self._locator


ingest_workflow_api_IngestDataflashRequest.__name__ = "IngestDataflashRequest"
ingest_workflow_api_IngestDataflashRequest.__qualname__ = "IngestDataflashRequest"
ingest_workflow_api_IngestDataflashRequest.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_IngestDataflashResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'units': ConjureFieldDefinition('units', Dict[str, str]),
            'parquet_object_locators': ConjureFieldDefinition('parquetObjectLocators', List[ingest_workflow_api_ObjectLocator]),
            'timestamp_series_name': ConjureFieldDefinition('timestampSeriesName', str),
            'time_unit': ConjureFieldDefinition('timeUnit', ingest_workflow_api_TimeUnitSeconds),
            'avro_locator': ConjureFieldDefinition('avroLocator', OptionalTypeWrapper[ingest_workflow_api_ObjectLocator])
        }

    __slots__: List[str] = ['_units', '_parquet_object_locators', '_timestamp_series_name', '_time_unit', '_avro_locator']

    def __init__(self, parquet_object_locators: List["ingest_workflow_api_ObjectLocator"], time_unit: "ingest_workflow_api_TimeUnitSeconds", timestamp_series_name: str, units: Dict[str, str], avro_locator: Optional["ingest_workflow_api_ObjectLocator"] = None) -> None:
        self._units = units
        self._parquet_object_locators = parquet_object_locators
        self._timestamp_series_name = timestamp_series_name
        self._time_unit = time_unit
        self._avro_locator = avro_locator

    @builtins.property
    def units(self) -> Dict[str, str]:
        return self._units

    @builtins.property
    def parquet_object_locators(self) -> List["ingest_workflow_api_ObjectLocator"]:
        """Azure or S3-style blob locators of parquet files. Currently
only a single file is supported, the list type is used for future compatibility.
        """
        return self._parquet_object_locators

    @builtins.property
    def timestamp_series_name(self) -> str:
        """The name of the column in the generated parquet file that contains the timestamp.
        """
        return self._timestamp_series_name

    @builtins.property
    def time_unit(self) -> "ingest_workflow_api_TimeUnitSeconds":
        """The unit of time for the timestamp column. Can only be seconds.
        """
        return self._time_unit

    @builtins.property
    def avro_locator(self) -> Optional["ingest_workflow_api_ObjectLocator"]:
        """Azure or S3-style blob locator of avro file when avro processing is configured.
This field is only set when the workflow is configured to write avro stream.
        """
        return self._avro_locator


ingest_workflow_api_IngestDataflashResponse.__name__ = "IngestDataflashResponse"
ingest_workflow_api_IngestDataflashResponse.__qualname__ = "IngestDataflashResponse"
ingest_workflow_api_IngestDataflashResponse.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_IngestInternalService(Service):

    def create_ingest_job(self, auth_header: str, create_ingest_job_request: "ingest_workflow_api_CreateIngestJobRequest") -> str:
        """Creates an ingest job, returning a RID for the job.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(create_ingest_job_request)

        _path = '/internal/ingest/v1/ingest-job'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), ingest_api_IngestJobRid, self._return_none_for_unknown_union_types)

    def get_ingest_job(self, auth_header: str, ingest_job_rid: str) -> "ingest_api_IngestJob":
        """Returns a single ingest job by RID.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'ingestJobRid': quote(str(_conjure_encoder.default(ingest_job_rid)), safe=''),
        }

        _json: Any = None

        _path = '/internal/ingest/v1/ingest-job/{ingestJobRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), ingest_api_IngestJob, self._return_none_for_unknown_union_types)

    def update_ingest_job_status(self, auth_header: str, ingest_job_rid: str, status: "ingest_api_IngestJobStatus") -> "ingest_api_IngestJobStatus":
        """Updates the status of an ingest job.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'ingestJobRid': quote(str(_conjure_encoder.default(ingest_job_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(status)

        _path = '/internal/ingest/v1/ingest-job/{ingestJobRid}/status'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), ingest_api_IngestJobStatus, self._return_none_for_unknown_union_types)


ingest_workflow_api_IngestInternalService.__name__ = "IngestInternalService"
ingest_workflow_api_IngestInternalService.__qualname__ = "IngestInternalService"
ingest_workflow_api_IngestInternalService.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_IngestMcapProtobufRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'locator': ConjureFieldDefinition('locator', ingest_workflow_api_ObjectLocator),
            'channels': ConjureFieldDefinition('channels', ingest_workflow_api_McapProtoChannels)
        }

    __slots__: List[str] = ['_locator', '_channels']

    def __init__(self, channels: "ingest_workflow_api_McapProtoChannels", locator: "ingest_workflow_api_ObjectLocator") -> None:
        self._locator = locator
        self._channels = channels

    @builtins.property
    def locator(self) -> "ingest_workflow_api_ObjectLocator":
        return self._locator

    @builtins.property
    def channels(self) -> "ingest_workflow_api_McapProtoChannels":
        return self._channels


ingest_workflow_api_IngestMcapProtobufRequest.__name__ = "IngestMcapProtobufRequest"
ingest_workflow_api_IngestMcapProtobufRequest.__qualname__ = "IngestMcapProtobufRequest"
ingest_workflow_api_IngestMcapProtobufRequest.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_IngestMcapProtobufResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'timestamp_column_name': ConjureFieldDefinition('timestampColumnName', str),
            'parquet_object_locators': ConjureFieldDefinition('parquetObjectLocators', List[ingest_workflow_api_ObjectLocator])
        }

    __slots__: List[str] = ['_timestamp_column_name', '_parquet_object_locators']

    def __init__(self, parquet_object_locators: List["ingest_workflow_api_ObjectLocator"], timestamp_column_name: str) -> None:
        self._timestamp_column_name = timestamp_column_name
        self._parquet_object_locators = parquet_object_locators

    @builtins.property
    def timestamp_column_name(self) -> str:
        return self._timestamp_column_name

    @builtins.property
    def parquet_object_locators(self) -> List["ingest_workflow_api_ObjectLocator"]:
        """Azure or S3-style blob locators of parquet files. Currently
only a single file is supported, the list type is used for future compatibility.
        """
        return self._parquet_object_locators


ingest_workflow_api_IngestMcapProtobufResponse.__name__ = "IngestMcapProtobufResponse"
ingest_workflow_api_IngestMcapProtobufResponse.__qualname__ = "IngestMcapProtobufResponse"
ingest_workflow_api_IngestMcapProtobufResponse.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_McapProtoChannels(ConjureUnionType):
    _all: Optional["ingest_workflow_api_Empty"] = None
    _include_topics: Optional[List[str]] = None
    _exclude_topics: Optional[List[str]] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'all': ConjureFieldDefinition('all', ingest_workflow_api_Empty),
            'include_topics': ConjureFieldDefinition('includeTopics', List[ingest_workflow_api_McapTopicName]),
            'exclude_topics': ConjureFieldDefinition('excludeTopics', List[ingest_workflow_api_McapTopicName])
        }

    def __init__(
            self,
            all: Optional["ingest_workflow_api_Empty"] = None,
            include_topics: Optional[List[str]] = None,
            exclude_topics: Optional[List[str]] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (all is not None) + (include_topics is not None) + (exclude_topics is not None) != 1:
                raise ValueError('a union must contain a single member')

            if all is not None:
                self._all = all
                self._type = 'all'
            if include_topics is not None:
                self._include_topics = include_topics
                self._type = 'includeTopics'
            if exclude_topics is not None:
                self._exclude_topics = exclude_topics
                self._type = 'excludeTopics'

        elif type_of_union == 'all':
            if all is None:
                raise ValueError('a union value must not be None')
            self._all = all
            self._type = 'all'
        elif type_of_union == 'includeTopics':
            if include_topics is None:
                raise ValueError('a union value must not be None')
            self._include_topics = include_topics
            self._type = 'includeTopics'
        elif type_of_union == 'excludeTopics':
            if exclude_topics is None:
                raise ValueError('a union value must not be None')
            self._exclude_topics = exclude_topics
            self._type = 'excludeTopics'

    @builtins.property
    def all(self) -> Optional["ingest_workflow_api_Empty"]:
        return self._all

    @builtins.property
    def include_topics(self) -> Optional[List[str]]:
        return self._include_topics

    @builtins.property
    def exclude_topics(self) -> Optional[List[str]]:
        return self._exclude_topics

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, ingest_workflow_api_McapProtoChannelsVisitor):
            raise ValueError('{} is not an instance of ingest_workflow_api_McapProtoChannelsVisitor'.format(visitor.__class__.__name__))
        if self._type == 'all' and self.all is not None:
            return visitor._all(self.all)
        if self._type == 'includeTopics' and self.include_topics is not None:
            return visitor._include_topics(self.include_topics)
        if self._type == 'excludeTopics' and self.exclude_topics is not None:
            return visitor._exclude_topics(self.exclude_topics)


ingest_workflow_api_McapProtoChannels.__name__ = "McapProtoChannels"
ingest_workflow_api_McapProtoChannels.__qualname__ = "McapProtoChannels"
ingest_workflow_api_McapProtoChannels.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_McapProtoChannelsVisitor:

    @abstractmethod
    def _all(self, all: "ingest_workflow_api_Empty") -> Any:
        pass

    @abstractmethod
    def _include_topics(self, include_topics: List[str]) -> Any:
        pass

    @abstractmethod
    def _exclude_topics(self, exclude_topics: List[str]) -> Any:
        pass


ingest_workflow_api_McapProtoChannelsVisitor.__name__ = "McapProtoChannelsVisitor"
ingest_workflow_api_McapProtoChannelsVisitor.__qualname__ = "McapProtoChannelsVisitor"
ingest_workflow_api_McapProtoChannelsVisitor.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_MultipartUploadDetails(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'upload_id': ConjureFieldDefinition('uploadId', str),
            's3_handle': ConjureFieldDefinition('s3Handle', scout_catalog_S3Handle)
        }

    __slots__: List[str] = ['_upload_id', '_s3_handle']

    def __init__(self, s3_handle: "scout_catalog_S3Handle", upload_id: str) -> None:
        self._upload_id = upload_id
        self._s3_handle = s3_handle

    @builtins.property
    def upload_id(self) -> str:
        return self._upload_id

    @builtins.property
    def s3_handle(self) -> "scout_catalog_S3Handle":
        return self._s3_handle


ingest_workflow_api_MultipartUploadDetails.__name__ = "MultipartUploadDetails"
ingest_workflow_api_MultipartUploadDetails.__qualname__ = "MultipartUploadDetails"
ingest_workflow_api_MultipartUploadDetails.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_ObjectLocator(ConjureBeanType):
    """Locator for files in an object store. 
Clients are expected to have auth and origin/region configured independently.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'bucket': ConjureFieldDefinition('bucket', str),
            'object_name': ConjureFieldDefinition('objectName', str)
        }

    __slots__: List[str] = ['_bucket', '_object_name']

    def __init__(self, bucket: str, object_name: str) -> None:
        self._bucket = bucket
        self._object_name = object_name

    @builtins.property
    def bucket(self) -> str:
        return self._bucket

    @builtins.property
    def object_name(self) -> str:
        return self._object_name


ingest_workflow_api_ObjectLocator.__name__ = "ObjectLocator"
ingest_workflow_api_ObjectLocator.__qualname__ = "ObjectLocator"
ingest_workflow_api_ObjectLocator.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_PresignedFileInput(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'url': ConjureFieldDefinition('url', ingest_workflow_api_PresignedUrl),
            'input': ConjureFieldDefinition('input', ingest_workflow_api_ValidatedFileInput)
        }

    __slots__: List[str] = ['_url', '_input']

    def __init__(self, input: "ingest_workflow_api_ValidatedFileInput", url: str) -> None:
        self._url = url
        self._input = input

    @builtins.property
    def url(self) -> str:
        return self._url

    @builtins.property
    def input(self) -> "ingest_workflow_api_ValidatedFileInput":
        return self._input


ingest_workflow_api_PresignedFileInput.__name__ = "PresignedFileInput"
ingest_workflow_api_PresignedFileInput.__qualname__ = "PresignedFileInput"
ingest_workflow_api_PresignedFileInput.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_TimeUnitSeconds(ConjureEnumType):

    SECONDS = 'SECONDS'
    '''SECONDS'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


ingest_workflow_api_TimeUnitSeconds.__name__ = "TimeUnitSeconds"
ingest_workflow_api_TimeUnitSeconds.__qualname__ = "TimeUnitSeconds"
ingest_workflow_api_TimeUnitSeconds.__module__ = "nominal_api.ingest_workflow_api"


class ingest_workflow_api_ValidatedFileInput(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'handle': ConjureFieldDefinition('handle', scout_catalog_S3Handle),
            'file_name': ConjureFieldDefinition('fileName', str),
            'env_var': ConjureFieldDefinition('envVar', str)
        }

    __slots__: List[str] = ['_handle', '_file_name', '_env_var']

    def __init__(self, env_var: str, file_name: str, handle: "scout_catalog_S3Handle") -> None:
        self._handle = handle
        self._file_name = file_name
        self._env_var = env_var

    @builtins.property
    def handle(self) -> "scout_catalog_S3Handle":
        """Path to the input file in S3.
        """
        return self._handle

    @builtins.property
    def file_name(self) -> str:
        """Name of the file that will be placed on disk.
        """
        return self._file_name

    @builtins.property
    def env_var(self) -> str:
        """Environment variable that will store the path to the file.
        """
        return self._env_var


ingest_workflow_api_ValidatedFileInput.__name__ = "ValidatedFileInput"
ingest_workflow_api_ValidatedFileInput.__qualname__ = "ValidatedFileInput"
ingest_workflow_api_ValidatedFileInput.__module__ = "nominal_api.ingest_workflow_api"


class module_ArchiveModuleApplicationRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'module_application_rid': ConjureFieldDefinition('moduleApplicationRid', modules_api_ModuleApplicationRid)
        }

    __slots__: List[str] = ['_module_application_rid']

    def __init__(self, module_application_rid: str) -> None:
        self._module_application_rid = module_application_rid

    @builtins.property
    def module_application_rid(self) -> str:
        return self._module_application_rid


module_ArchiveModuleApplicationRequest.__name__ = "ArchiveModuleApplicationRequest"
module_ArchiveModuleApplicationRequest.__qualname__ = "ArchiveModuleApplicationRequest"
module_ArchiveModuleApplicationRequest.__module__ = "nominal_api.module"


class module_ArchiveModuleApplicationResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'success': ConjureFieldDefinition('success', bool)
        }

    __slots__: List[str] = ['_success']

    def __init__(self, success: bool) -> None:
        self._success = success

    @builtins.property
    def success(self) -> bool:
        return self._success


module_ArchiveModuleApplicationResponse.__name__ = "ArchiveModuleApplicationResponse"
module_ArchiveModuleApplicationResponse.__qualname__ = "ArchiveModuleApplicationResponse"
module_ArchiveModuleApplicationResponse.__module__ = "nominal_api.module"


class module_BatchArchiveModulesRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'requests': ConjureFieldDefinition('requests', List[modules_api_ModuleRid])
        }

    __slots__: List[str] = ['_requests']

    def __init__(self, requests: List[str]) -> None:
        self._requests = requests

    @builtins.property
    def requests(self) -> List[str]:
        return self._requests


module_BatchArchiveModulesRequest.__name__ = "BatchArchiveModulesRequest"
module_BatchArchiveModulesRequest.__qualname__ = "BatchArchiveModulesRequest"
module_BatchArchiveModulesRequest.__module__ = "nominal_api.module"


class module_BatchArchiveModulesResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'archived_module_rids': ConjureFieldDefinition('archivedModuleRids', List[modules_api_ModuleRid])
        }

    __slots__: List[str] = ['_archived_module_rids']

    def __init__(self, archived_module_rids: List[str]) -> None:
        self._archived_module_rids = archived_module_rids

    @builtins.property
    def archived_module_rids(self) -> List[str]:
        return self._archived_module_rids


module_BatchArchiveModulesResponse.__name__ = "BatchArchiveModulesResponse"
module_BatchArchiveModulesResponse.__qualname__ = "BatchArchiveModulesResponse"
module_BatchArchiveModulesResponse.__module__ = "nominal_api.module"


class module_BatchGetModuleApplicationsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'requests': ConjureFieldDefinition('requests', List[modules_api_ModuleApplicationRid])
        }

    __slots__: List[str] = ['_requests']

    def __init__(self, requests: List[str]) -> None:
        self._requests = requests

    @builtins.property
    def requests(self) -> List[str]:
        return self._requests


module_BatchGetModuleApplicationsRequest.__name__ = "BatchGetModuleApplicationsRequest"
module_BatchGetModuleApplicationsRequest.__qualname__ = "BatchGetModuleApplicationsRequest"
module_BatchGetModuleApplicationsRequest.__module__ = "nominal_api.module"


class module_BatchGetModuleApplicationsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[module_ModuleApplication])
        }

    __slots__: List[str] = ['_results']

    def __init__(self, results: List["module_ModuleApplication"]) -> None:
        self._results = results

    @builtins.property
    def results(self) -> List["module_ModuleApplication"]:
        return self._results


module_BatchGetModuleApplicationsResponse.__name__ = "BatchGetModuleApplicationsResponse"
module_BatchGetModuleApplicationsResponse.__qualname__ = "BatchGetModuleApplicationsResponse"
module_BatchGetModuleApplicationsResponse.__module__ = "nominal_api.module"


class module_BatchGetModulesRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'requests': ConjureFieldDefinition('requests', List[module_RequestModuleRef])
        }

    __slots__: List[str] = ['_requests']

    def __init__(self, requests: List["module_RequestModuleRef"]) -> None:
        self._requests = requests

    @builtins.property
    def requests(self) -> List["module_RequestModuleRef"]:
        return self._requests


module_BatchGetModulesRequest.__name__ = "BatchGetModulesRequest"
module_BatchGetModulesRequest.__qualname__ = "BatchGetModulesRequest"
module_BatchGetModulesRequest.__module__ = "nominal_api.module"


class module_BatchUnarchiveModulesRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'requests': ConjureFieldDefinition('requests', List[modules_api_ModuleRid])
        }

    __slots__: List[str] = ['_requests']

    def __init__(self, requests: List[str]) -> None:
        self._requests = requests

    @builtins.property
    def requests(self) -> List[str]:
        return self._requests


module_BatchUnarchiveModulesRequest.__name__ = "BatchUnarchiveModulesRequest"
module_BatchUnarchiveModulesRequest.__qualname__ = "BatchUnarchiveModulesRequest"
module_BatchUnarchiveModulesRequest.__module__ = "nominal_api.module"


class module_BatchUnarchiveModulesResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'unarchived_module_rids': ConjureFieldDefinition('unarchivedModuleRids', List[modules_api_ModuleRid])
        }

    __slots__: List[str] = ['_unarchived_module_rids']

    def __init__(self, unarchived_module_rids: List[str]) -> None:
        self._unarchived_module_rids = unarchived_module_rids

    @builtins.property
    def unarchived_module_rids(self) -> List[str]:
        return self._unarchived_module_rids


module_BatchUnarchiveModulesResponse.__name__ = "BatchUnarchiveModulesResponse"
module_BatchUnarchiveModulesResponse.__qualname__ = "BatchUnarchiveModulesResponse"
module_BatchUnarchiveModulesResponse.__module__ = "nominal_api.module"


class module_CreateModuleApplicationRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'module_ref': ConjureFieldDefinition('moduleRef', module_RequestModuleRef),
            'asset_rid': ConjureFieldDefinition('assetRid', scout_rids_api_AssetRid)
        }

    __slots__: List[str] = ['_module_ref', '_asset_rid']

    def __init__(self, asset_rid: str, module_ref: "module_RequestModuleRef") -> None:
        self._module_ref = module_ref
        self._asset_rid = asset_rid

    @builtins.property
    def module_ref(self) -> "module_RequestModuleRef":
        return self._module_ref

    @builtins.property
    def asset_rid(self) -> str:
        return self._asset_rid


module_CreateModuleApplicationRequest.__name__ = "CreateModuleApplicationRequest"
module_CreateModuleApplicationRequest.__qualname__ = "CreateModuleApplicationRequest"
module_CreateModuleApplicationRequest.__module__ = "nominal_api.module"


class module_CreateModuleApplicationResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'result': ConjureFieldDefinition('result', module_ModuleApplication)
        }

    __slots__: List[str] = ['_result']

    def __init__(self, result: "module_ModuleApplication") -> None:
        self._result = result

    @builtins.property
    def result(self) -> "module_ModuleApplication":
        return self._result


module_CreateModuleApplicationResponse.__name__ = "CreateModuleApplicationResponse"
module_CreateModuleApplicationResponse.__qualname__ = "CreateModuleApplicationResponse"
module_CreateModuleApplicationResponse.__module__ = "nominal_api.module"


class module_CreateModuleRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'api_name': ConjureFieldDefinition('apiName', str),
            'title': ConjureFieldDefinition('title', str),
            'description': ConjureFieldDefinition('description', str),
            'definition': ConjureFieldDefinition('definition', module_ModuleVersionDefinition),
            'workspace': ConjureFieldDefinition('workspace', OptionalTypeWrapper[api_rids_WorkspaceRid])
        }

    __slots__: List[str] = ['_api_name', '_title', '_description', '_definition', '_workspace']

    def __init__(self, api_name: str, definition: "module_ModuleVersionDefinition", description: str, title: str, workspace: Optional[str] = None) -> None:
        self._api_name = api_name
        self._title = title
        self._description = description
        self._definition = definition
        self._workspace = workspace

    @builtins.property
    def api_name(self) -> str:
        """The API name for the module. This string will uniquely identify the module within the organization.
        """
        return self._api_name

    @builtins.property
    def title(self) -> str:
        return self._title

    @builtins.property
    def description(self) -> str:
        return self._description

    @builtins.property
    def definition(self) -> "module_ModuleVersionDefinition":
        return self._definition

    @builtins.property
    def workspace(self) -> Optional[str]:
        return self._workspace


module_CreateModuleRequest.__name__ = "CreateModuleRequest"
module_CreateModuleRequest.__qualname__ = "CreateModuleRequest"
module_CreateModuleRequest.__module__ = "nominal_api.module"


class module_DerivedSeriesMetadata(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'function_name': ConjureFieldDefinition('functionName', str),
            'function_description': ConjureFieldDefinition('functionDescription', str),
            'module_api_name': ConjureFieldDefinition('moduleApiName', str),
            'module_application_rid': ConjureFieldDefinition('moduleApplicationRid', modules_api_ModuleApplicationRid),
            'application_resolved_parameters': ConjureFieldDefinition('applicationResolvedParameters', List[module_ModuleVariable]),
            'data_type': ConjureFieldDefinition('dataType', module_ValueType)
        }

    __slots__: List[str] = ['_function_name', '_function_description', '_module_api_name', '_module_application_rid', '_application_resolved_parameters', '_data_type']

    def __init__(self, application_resolved_parameters: List["module_ModuleVariable"], data_type: "module_ValueType", function_description: str, function_name: str, module_api_name: str, module_application_rid: str) -> None:
        self._function_name = function_name
        self._function_description = function_description
        self._module_api_name = module_api_name
        self._module_application_rid = module_application_rid
        self._application_resolved_parameters = application_resolved_parameters
        self._data_type = data_type

    @builtins.property
    def function_name(self) -> str:
        return self._function_name

    @builtins.property
    def function_description(self) -> str:
        return self._function_description

    @builtins.property
    def module_api_name(self) -> str:
        return self._module_api_name

    @builtins.property
    def module_application_rid(self) -> str:
        return self._module_application_rid

    @builtins.property
    def application_resolved_parameters(self) -> List["module_ModuleVariable"]:
        """The parameters and their values that were resolved when the module was applied to the asset.
        """
        return self._application_resolved_parameters

    @builtins.property
    def data_type(self) -> "module_ValueType":
        return self._data_type


module_DerivedSeriesMetadata.__name__ = "DerivedSeriesMetadata"
module_DerivedSeriesMetadata.__qualname__ = "DerivedSeriesMetadata"
module_DerivedSeriesMetadata.__module__ = "nominal_api.module"


class module_Function(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', str),
            'description': ConjureFieldDefinition('description', str),
            'parameters': ConjureFieldDefinition('parameters', List[module_FunctionParameter]),
            'function_node': ConjureFieldDefinition('functionNode', module_FunctionNode),
            'is_exported': ConjureFieldDefinition('isExported', bool)
        }

    __slots__: List[str] = ['_name', '_description', '_parameters', '_function_node', '_is_exported']

    def __init__(self, description: str, function_node: "module_FunctionNode", is_exported: bool, name: str, parameters: List["module_FunctionParameter"]) -> None:
        self._name = name
        self._description = description
        self._parameters = parameters
        self._function_node = function_node
        self._is_exported = is_exported

    @builtins.property
    def name(self) -> str:
        """The name of the function. This should be unique to the function in the current module.
        """
        return self._name

    @builtins.property
    def description(self) -> str:
        return self._description

    @builtins.property
    def parameters(self) -> List["module_FunctionParameter"]:
        return self._parameters

    @builtins.property
    def function_node(self) -> "module_FunctionNode":
        return self._function_node

    @builtins.property
    def is_exported(self) -> bool:
        return self._is_exported


module_Function.__name__ = "Function"
module_Function.__qualname__ = "Function"
module_Function.__module__ = "nominal_api.module"


class module_FunctionNode(ConjureUnionType):
    _enum: Optional["scout_compute_api_EnumSeries"] = None
    _numeric: Optional["scout_compute_api_NumericSeries"] = None
    _ranges: Optional["scout_compute_api_RangeSeries"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'enum': ConjureFieldDefinition('enum', scout_compute_api_EnumSeries),
            'numeric': ConjureFieldDefinition('numeric', scout_compute_api_NumericSeries),
            'ranges': ConjureFieldDefinition('ranges', scout_compute_api_RangeSeries)
        }

    def __init__(
            self,
            enum: Optional["scout_compute_api_EnumSeries"] = None,
            numeric: Optional["scout_compute_api_NumericSeries"] = None,
            ranges: Optional["scout_compute_api_RangeSeries"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (enum is not None) + (numeric is not None) + (ranges is not None) != 1:
                raise ValueError('a union must contain a single member')

            if enum is not None:
                self._enum = enum
                self._type = 'enum'
            if numeric is not None:
                self._numeric = numeric
                self._type = 'numeric'
            if ranges is not None:
                self._ranges = ranges
                self._type = 'ranges'

        elif type_of_union == 'enum':
            if enum is None:
                raise ValueError('a union value must not be None')
            self._enum = enum
            self._type = 'enum'
        elif type_of_union == 'numeric':
            if numeric is None:
                raise ValueError('a union value must not be None')
            self._numeric = numeric
            self._type = 'numeric'
        elif type_of_union == 'ranges':
            if ranges is None:
                raise ValueError('a union value must not be None')
            self._ranges = ranges
            self._type = 'ranges'

    @builtins.property
    def enum(self) -> Optional["scout_compute_api_EnumSeries"]:
        return self._enum

    @builtins.property
    def numeric(self) -> Optional["scout_compute_api_NumericSeries"]:
        return self._numeric

    @builtins.property
    def ranges(self) -> Optional["scout_compute_api_RangeSeries"]:
        return self._ranges

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, module_FunctionNodeVisitor):
            raise ValueError('{} is not an instance of module_FunctionNodeVisitor'.format(visitor.__class__.__name__))
        if self._type == 'enum' and self.enum is not None:
            return visitor._enum(self.enum)
        if self._type == 'numeric' and self.numeric is not None:
            return visitor._numeric(self.numeric)
        if self._type == 'ranges' and self.ranges is not None:
            return visitor._ranges(self.ranges)


module_FunctionNode.__name__ = "FunctionNode"
module_FunctionNode.__qualname__ = "FunctionNode"
module_FunctionNode.__module__ = "nominal_api.module"


class module_FunctionNodeVisitor:

    @abstractmethod
    def _enum(self, enum: "scout_compute_api_EnumSeries") -> Any:
        pass

    @abstractmethod
    def _numeric(self, numeric: "scout_compute_api_NumericSeries") -> Any:
        pass

    @abstractmethod
    def _ranges(self, ranges: "scout_compute_api_RangeSeries") -> Any:
        pass


module_FunctionNodeVisitor.__name__ = "FunctionNodeVisitor"
module_FunctionNodeVisitor.__qualname__ = "FunctionNodeVisitor"
module_FunctionNodeVisitor.__module__ = "nominal_api.module"


class module_FunctionParameter(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', module_ParameterName),
            'type': ConjureFieldDefinition('type', module_ValueType),
            'default_value': ConjureFieldDefinition('defaultValue', OptionalTypeWrapper[module_VariableName])
        }

    __slots__: List[str] = ['_name', '_type', '_default_value']

    def __init__(self, name: str, type: "module_ValueType", default_value: Optional[str] = None) -> None:
        self._name = name
        self._type = type
        self._default_value = default_value

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def type(self) -> "module_ValueType":
        return self._type

    @builtins.property
    def default_value(self) -> Optional[str]:
        """This must reference a ModuleVariable within the `defaultVariables` field of the containing Module.
For now, this is required for all parameters.
        """
        return self._default_value


module_FunctionParameter.__name__ = "FunctionParameter"
module_FunctionParameter.__qualname__ = "FunctionParameter"
module_FunctionParameter.__module__ = "nominal_api.module"


class module_GetDerivedSeriesRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'asset_rid': ConjureFieldDefinition('assetRid', scout_rids_api_AssetRid),
            'exact_match': ConjureFieldDefinition('exactMatch', OptionalTypeWrapper[str]),
            'return_types': ConjureFieldDefinition('returnTypes', OptionalTypeWrapper[List[module_ValueType]]),
            'page_size': ConjureFieldDefinition('pageSize', int),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_asset_rid', '_exact_match', '_return_types', '_page_size', '_next_page_token']

    def __init__(self, asset_rid: str, page_size: int, exact_match: Optional[str] = None, next_page_token: Optional[str] = None, return_types: Optional[List["module_ValueType"]] = None) -> None:
        self._asset_rid = asset_rid
        self._exact_match = exact_match
        self._return_types = return_types
        self._page_size = page_size
        self._next_page_token = next_page_token

    @builtins.property
    def asset_rid(self) -> str:
        return self._asset_rid

    @builtins.property
    def exact_match(self) -> Optional[str]:
        """Search text which will be checked for exact matches with the derived channel names.
        """
        return self._exact_match

    @builtins.property
    def return_types(self) -> Optional[List["module_ValueType"]]:
        """Optional filter to limit the returned derived channels to those with specified return data type.
        """
        return self._return_types

    @builtins.property
    def page_size(self) -> int:
        return self._page_size

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


module_GetDerivedSeriesRequest.__name__ = "GetDerivedSeriesRequest"
module_GetDerivedSeriesRequest.__qualname__ = "GetDerivedSeriesRequest"
module_GetDerivedSeriesRequest.__module__ = "nominal_api.module"


class module_GetDerivedSeriesResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[module_DerivedSeriesMetadata]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_results', '_next_page_token']

    def __init__(self, results: List["module_DerivedSeriesMetadata"], next_page_token: Optional[str] = None) -> None:
        self._results = results
        self._next_page_token = next_page_token

    @builtins.property
    def results(self) -> List["module_DerivedSeriesMetadata"]:
        return self._results

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


module_GetDerivedSeriesResponse.__name__ = "GetDerivedSeriesResponse"
module_GetDerivedSeriesResponse.__qualname__ = "GetDerivedSeriesResponse"
module_GetDerivedSeriesResponse.__module__ = "nominal_api.module"


class module_LatestVersionStrategy(ConjureBeanType):
    """This strategy refers to the latest version of the module.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



module_LatestVersionStrategy.__name__ = "LatestVersionStrategy"
module_LatestVersionStrategy.__qualname__ = "LatestVersionStrategy"
module_LatestVersionStrategy.__module__ = "nominal_api.module"


class module_Module(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'metadata': ConjureFieldDefinition('metadata', module_ModuleMetadata),
            'version_metadata': ConjureFieldDefinition('versionMetadata', module_ModuleVersionMetadata),
            'definition': ConjureFieldDefinition('definition', module_ModuleVersionDefinition)
        }

    __slots__: List[str] = ['_metadata', '_version_metadata', '_definition']

    def __init__(self, definition: "module_ModuleVersionDefinition", metadata: "module_ModuleMetadata", version_metadata: "module_ModuleVersionMetadata") -> None:
        self._metadata = metadata
        self._version_metadata = version_metadata
        self._definition = definition

    @builtins.property
    def metadata(self) -> "module_ModuleMetadata":
        return self._metadata

    @builtins.property
    def version_metadata(self) -> "module_ModuleVersionMetadata":
        return self._version_metadata

    @builtins.property
    def definition(self) -> "module_ModuleVersionDefinition":
        return self._definition


module_Module.__name__ = "Module"
module_Module.__qualname__ = "Module"
module_Module.__module__ = "nominal_api.module"


class module_ModuleApplication(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', modules_api_ModuleApplicationRid),
            'module': ConjureFieldDefinition('module', module_ModuleRef),
            'asset_rid': ConjureFieldDefinition('assetRid', scout_rids_api_AssetRid),
            'applied_at': ConjureFieldDefinition('appliedAt', str),
            'applied_by': ConjureFieldDefinition('appliedBy', scout_rids_api_UserRid)
        }

    __slots__: List[str] = ['_rid', '_module', '_asset_rid', '_applied_at', '_applied_by']

    def __init__(self, applied_at: str, applied_by: str, asset_rid: str, module: "module_ModuleRef", rid: str) -> None:
        self._rid = rid
        self._module = module
        self._asset_rid = asset_rid
        self._applied_at = applied_at
        self._applied_by = applied_by

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def module(self) -> "module_ModuleRef":
        return self._module

    @builtins.property
    def asset_rid(self) -> str:
        return self._asset_rid

    @builtins.property
    def applied_at(self) -> str:
        return self._applied_at

    @builtins.property
    def applied_by(self) -> str:
        return self._applied_by


module_ModuleApplication.__name__ = "ModuleApplication"
module_ModuleApplication.__qualname__ = "ModuleApplication"
module_ModuleApplication.__module__ = "nominal_api.module"


class module_ModuleMetadata(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', modules_api_ModuleRid),
            'api_name': ConjureFieldDefinition('apiName', str),
            'title': ConjureFieldDefinition('title', str),
            'description': ConjureFieldDefinition('description', str),
            'created_by': ConjureFieldDefinition('createdBy', scout_rids_api_UserRid),
            'created_at': ConjureFieldDefinition('createdAt', str),
            'archived_at': ConjureFieldDefinition('archivedAt', OptionalTypeWrapper[str])
        }

    __slots__: List[str] = ['_rid', '_api_name', '_title', '_description', '_created_by', '_created_at', '_archived_at']

    def __init__(self, api_name: str, created_at: str, created_by: str, description: str, rid: str, title: str, archived_at: Optional[str] = None) -> None:
        self._rid = rid
        self._api_name = api_name
        self._title = title
        self._description = description
        self._created_by = created_by
        self._created_at = created_at
        self._archived_at = archived_at

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def api_name(self) -> str:
        """This uniquely identifies the module within the org.
Note that this cannot be changed after creation.
        """
        return self._api_name

    @builtins.property
    def title(self) -> str:
        return self._title

    @builtins.property
    def description(self) -> str:
        return self._description

    @builtins.property
    def created_by(self) -> str:
        return self._created_by

    @builtins.property
    def created_at(self) -> str:
        return self._created_at

    @builtins.property
    def archived_at(self) -> Optional[str]:
        """The time at which the module was archived. Unset if the module is not archived.
        """
        return self._archived_at


module_ModuleMetadata.__name__ = "ModuleMetadata"
module_ModuleMetadata.__qualname__ = "ModuleMetadata"
module_ModuleMetadata.__module__ = "nominal_api.module"


class module_ModuleParameter(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', module_ParameterName),
            'type': ConjureFieldDefinition('type', module_ValueType)
        }

    __slots__: List[str] = ['_name', '_type']

    def __init__(self, name: str, type: "module_ValueType") -> None:
        self._name = name
        self._type = type

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def type(self) -> "module_ValueType":
        return self._type


module_ModuleParameter.__name__ = "ModuleParameter"
module_ModuleParameter.__qualname__ = "ModuleParameter"
module_ModuleParameter.__module__ = "nominal_api.module"


class module_ModuleRef(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', modules_api_ModuleRid),
            'api_name': ConjureFieldDefinition('apiName', str),
            'version': ConjureFieldDefinition('version', module_ModuleVersion)
        }

    __slots__: List[str] = ['_rid', '_api_name', '_version']

    def __init__(self, api_name: str, rid: str, version: str) -> None:
        self._rid = rid
        self._api_name = api_name
        self._version = version

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def api_name(self) -> str:
        return self._api_name

    @builtins.property
    def version(self) -> str:
        return self._version


module_ModuleRef.__name__ = "ModuleRef"
module_ModuleRef.__qualname__ = "ModuleRef"
module_ModuleRef.__module__ = "nominal_api.module"


class module_ModuleService(Service):
    """Modules define collections of compute logic that can be shared and used across different contexts by applying them
to assets. The Modules Service provides the API for managing these collections and using them.
    """

    def create_module(self, auth_header: str, request: "module_CreateModuleRequest") -> "module_Module":
        """Create a new module.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/module'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), module_Module, self._return_none_for_unknown_union_types)

    def update_module(self, auth_header: str, module_rid: str, request: "module_UpdateModuleRequest") -> "module_Module":
        """Update an existing module.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'moduleRid': quote(str(_conjure_encoder.default(module_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/module/{moduleRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), module_Module, self._return_none_for_unknown_union_types)

    def batch_get_modules(self, auth_header: str, request: "module_BatchGetModulesRequest") -> List["module_Module"]:
        """Get a list of modules by their RIDs and version specifiers if provided.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/module/batch-get'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[module_Module], self._return_none_for_unknown_union_types)

    def search_modules(self, auth_header: str, request: "module_SearchModulesRequest") -> "module_SearchModulesResponse":
        """Search for modules.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/module/search'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), module_SearchModulesResponse, self._return_none_for_unknown_union_types)

    def batch_archive_modules(self, auth_header: str, request: "module_BatchArchiveModulesRequest") -> "module_BatchArchiveModulesResponse":
        """Archive a set of modules.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/module/archive'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), module_BatchArchiveModulesResponse, self._return_none_for_unknown_union_types)

    def batch_unarchive_modules(self, auth_header: str, request: "module_BatchUnarchiveModulesRequest") -> "module_BatchUnarchiveModulesResponse":
        """Unarchive a set of modules.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/module/unarchive'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), module_BatchUnarchiveModulesResponse, self._return_none_for_unknown_union_types)

    def create_module_application(self, auth_header: str, request: "module_CreateModuleApplicationRequest") -> "module_CreateModuleApplicationResponse":
        """Create a module application by applying a module to an asset.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/module/application/create'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), module_CreateModuleApplicationResponse, self._return_none_for_unknown_union_types)

    def archive_module_application(self, auth_header: str, request: "module_ArchiveModuleApplicationRequest") -> "module_ArchiveModuleApplicationResponse":
        """Archive a module application, un-applying the module from the asset.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/module/application/archive'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), module_ArchiveModuleApplicationResponse, self._return_none_for_unknown_union_types)

    def search_module_applications(self, auth_header: str, request: "module_SearchModuleApplicationsRequest") -> "module_SearchModuleApplicationsResponse":
        """Search for module applications.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/module/applications/search'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), module_SearchModuleApplicationsResponse, self._return_none_for_unknown_union_types)

    def batch_get_module_applications(self, auth_header: str, request: "module_BatchGetModuleApplicationsRequest") -> "module_BatchGetModuleApplicationsResponse":
        """Get a list of module applications by their RIDs.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/module/applications/batch-get'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), module_BatchGetModuleApplicationsResponse, self._return_none_for_unknown_union_types)

    def get_derived_series(self, auth_header: str, request: "module_GetDerivedSeriesRequest") -> "module_GetDerivedSeriesResponse":
        """Get the derived series from modules applied to an asset.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/module/derived-series/get'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), module_GetDerivedSeriesResponse, self._return_none_for_unknown_union_types)


module_ModuleService.__name__ = "ModuleService"
module_ModuleService.__qualname__ = "ModuleService"
module_ModuleService.__module__ = "nominal_api.module"


class module_ModuleSummary(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'metadata': ConjureFieldDefinition('metadata', module_ModuleMetadata),
            'latest': ConjureFieldDefinition('latest', module_ModuleVersionMetadata)
        }

    __slots__: List[str] = ['_metadata', '_latest']

    def __init__(self, latest: "module_ModuleVersionMetadata", metadata: "module_ModuleMetadata") -> None:
        self._metadata = metadata
        self._latest = latest

    @builtins.property
    def metadata(self) -> "module_ModuleMetadata":
        return self._metadata

    @builtins.property
    def latest(self) -> "module_ModuleVersionMetadata":
        return self._latest


module_ModuleSummary.__name__ = "ModuleSummary"
module_ModuleSummary.__qualname__ = "ModuleSummary"
module_ModuleSummary.__module__ = "nominal_api.module"


class module_ModuleVariable(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', module_VariableName),
            'type': ConjureFieldDefinition('type', module_ValueType),
            'value': ConjureFieldDefinition('value', scout_compute_api_VariableValue)
        }

    __slots__: List[str] = ['_name', '_type', '_value']

    def __init__(self, name: str, type: "module_ValueType", value: "scout_compute_api_VariableValue") -> None:
        self._name = name
        self._type = type
        self._value = value

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def type(self) -> "module_ValueType":
        return self._type

    @builtins.property
    def value(self) -> "scout_compute_api_VariableValue":
        return self._value


module_ModuleVariable.__name__ = "ModuleVariable"
module_ModuleVariable.__qualname__ = "ModuleVariable"
module_ModuleVariable.__module__ = "nominal_api.module"


class module_ModuleVersionDefinition(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'parameters': ConjureFieldDefinition('parameters', List[module_ModuleParameter]),
            'default_variables': ConjureFieldDefinition('defaultVariables', List[module_ModuleVariable]),
            'functions': ConjureFieldDefinition('functions', List[module_Function])
        }

    __slots__: List[str] = ['_parameters', '_default_variables', '_functions']

    def __init__(self, default_variables: List["module_ModuleVariable"], functions: List["module_Function"], parameters: List["module_ModuleParameter"]) -> None:
        self._parameters = parameters
        self._default_variables = default_variables
        self._functions = functions

    @builtins.property
    def parameters(self) -> List["module_ModuleParameter"]:
        """Specifies the parameters the module accepts when applying it.
For now, parameters MUST contain exactly 1 parameter with name 'ASSET_RID' and be of type ASSET_RID.
        """
        return self._parameters

    @builtins.property
    def default_variables(self) -> List["module_ModuleVariable"]:
        """Specifies the variables that are present within the module to be used by other variables or functions.
Limited to 100.
        """
        return self._default_variables

    @builtins.property
    def functions(self) -> List["module_Function"]:
        """The list of functions that resolve to derived series that appear in channel search after applying to an
asset. Limited to 100.
        """
        return self._functions


module_ModuleVersionDefinition.__name__ = "ModuleVersionDefinition"
module_ModuleVersionDefinition.__qualname__ = "ModuleVersionDefinition"
module_ModuleVersionDefinition.__module__ = "nominal_api.module"


class module_ModuleVersionMetadata(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'created_by': ConjureFieldDefinition('createdBy', scout_rids_api_UserRid),
            'created_at': ConjureFieldDefinition('createdAt', str),
            'version': ConjureFieldDefinition('version', module_ModuleVersion)
        }

    __slots__: List[str] = ['_created_by', '_created_at', '_version']

    def __init__(self, created_at: str, created_by: str, version: str) -> None:
        self._created_by = created_by
        self._created_at = created_at
        self._version = version

    @builtins.property
    def created_by(self) -> str:
        return self._created_by

    @builtins.property
    def created_at(self) -> str:
        return self._created_at

    @builtins.property
    def version(self) -> str:
        return self._version


module_ModuleVersionMetadata.__name__ = "ModuleVersionMetadata"
module_ModuleVersionMetadata.__qualname__ = "ModuleVersionMetadata"
module_ModuleVersionMetadata.__module__ = "nominal_api.module"


class module_PinnedVersionStrategy(ConjureBeanType):
    """This strategy refers to a specific version of the module.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'version': ConjureFieldDefinition('version', module_ModuleVersion)
        }

    __slots__: List[str] = ['_version']

    def __init__(self, version: str) -> None:
        self._version = version

    @builtins.property
    def version(self) -> str:
        return self._version


module_PinnedVersionStrategy.__name__ = "PinnedVersionStrategy"
module_PinnedVersionStrategy.__qualname__ = "PinnedVersionStrategy"
module_PinnedVersionStrategy.__module__ = "nominal_api.module"


class module_RequestModuleNameRef(ConjureBeanType):
    """This is used to refer to modules in requests by name.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'api_name': ConjureFieldDefinition('apiName', str),
            'version_strategy': ConjureFieldDefinition('versionStrategy', module_VersionStrategy)
        }

    __slots__: List[str] = ['_api_name', '_version_strategy']

    def __init__(self, api_name: str, version_strategy: "module_VersionStrategy") -> None:
        self._api_name = api_name
        self._version_strategy = version_strategy

    @builtins.property
    def api_name(self) -> str:
        return self._api_name

    @builtins.property
    def version_strategy(self) -> "module_VersionStrategy":
        return self._version_strategy


module_RequestModuleNameRef.__name__ = "RequestModuleNameRef"
module_RequestModuleNameRef.__qualname__ = "RequestModuleNameRef"
module_RequestModuleNameRef.__module__ = "nominal_api.module"


class module_RequestModuleRef(ConjureUnionType):
    """Request reference to a module. This is used to refer to modules in requests.
    """
    _name: Optional["module_RequestModuleNameRef"] = None
    _rid: Optional["module_RequestModuleRidRef"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', module_RequestModuleNameRef),
            'rid': ConjureFieldDefinition('rid', module_RequestModuleRidRef)
        }

    def __init__(
            self,
            name: Optional["module_RequestModuleNameRef"] = None,
            rid: Optional["module_RequestModuleRidRef"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (name is not None) + (rid is not None) != 1:
                raise ValueError('a union must contain a single member')

            if name is not None:
                self._name = name
                self._type = 'name'
            if rid is not None:
                self._rid = rid
                self._type = 'rid'

        elif type_of_union == 'name':
            if name is None:
                raise ValueError('a union value must not be None')
            self._name = name
            self._type = 'name'
        elif type_of_union == 'rid':
            if rid is None:
                raise ValueError('a union value must not be None')
            self._rid = rid
            self._type = 'rid'

    @builtins.property
    def name(self) -> Optional["module_RequestModuleNameRef"]:
        return self._name

    @builtins.property
    def rid(self) -> Optional["module_RequestModuleRidRef"]:
        return self._rid

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, module_RequestModuleRefVisitor):
            raise ValueError('{} is not an instance of module_RequestModuleRefVisitor'.format(visitor.__class__.__name__))
        if self._type == 'name' and self.name is not None:
            return visitor._name(self.name)
        if self._type == 'rid' and self.rid is not None:
            return visitor._rid(self.rid)


module_RequestModuleRef.__name__ = "RequestModuleRef"
module_RequestModuleRef.__qualname__ = "RequestModuleRef"
module_RequestModuleRef.__module__ = "nominal_api.module"


class module_RequestModuleRefVisitor:

    @abstractmethod
    def _name(self, name: "module_RequestModuleNameRef") -> Any:
        pass

    @abstractmethod
    def _rid(self, rid: "module_RequestModuleRidRef") -> Any:
        pass


module_RequestModuleRefVisitor.__name__ = "RequestModuleRefVisitor"
module_RequestModuleRefVisitor.__qualname__ = "RequestModuleRefVisitor"
module_RequestModuleRefVisitor.__module__ = "nominal_api.module"


class module_RequestModuleRidRef(ConjureBeanType):
    """This is used to refer to modules in requests by rid.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', modules_api_ModuleRid),
            'version_strategy': ConjureFieldDefinition('versionStrategy', module_VersionStrategy)
        }

    __slots__: List[str] = ['_rid', '_version_strategy']

    def __init__(self, rid: str, version_strategy: "module_VersionStrategy") -> None:
        self._rid = rid
        self._version_strategy = version_strategy

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def version_strategy(self) -> "module_VersionStrategy":
        return self._version_strategy


module_RequestModuleRidRef.__name__ = "RequestModuleRidRef"
module_RequestModuleRidRef.__qualname__ = "RequestModuleRidRef"
module_RequestModuleRidRef.__module__ = "nominal_api.module"


class module_SearchModuleApplicationsQuery(ConjureUnionType):
    _module_rid: Optional[str] = None
    _asset_rid: Optional[str] = None
    _workspace: Optional[str] = None
    _and_: Optional[List["module_SearchModuleApplicationsQuery"]] = None
    _or_: Optional[List["module_SearchModuleApplicationsQuery"]] = None
    _not_: Optional["module_SearchModuleApplicationsQuery"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'module_rid': ConjureFieldDefinition('moduleRid', modules_api_ModuleRid),
            'asset_rid': ConjureFieldDefinition('assetRid', scout_rids_api_AssetRid),
            'workspace': ConjureFieldDefinition('workspace', api_rids_WorkspaceRid),
            'and_': ConjureFieldDefinition('and', List[module_SearchModuleApplicationsQuery]),
            'or_': ConjureFieldDefinition('or', List[module_SearchModuleApplicationsQuery]),
            'not_': ConjureFieldDefinition('not', module_SearchModuleApplicationsQuery)
        }

    def __init__(
            self,
            module_rid: Optional[str] = None,
            asset_rid: Optional[str] = None,
            workspace: Optional[str] = None,
            and_: Optional[List["module_SearchModuleApplicationsQuery"]] = None,
            or_: Optional[List["module_SearchModuleApplicationsQuery"]] = None,
            not_: Optional["module_SearchModuleApplicationsQuery"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (module_rid is not None) + (asset_rid is not None) + (workspace is not None) + (and_ is not None) + (or_ is not None) + (not_ is not None) != 1:
                raise ValueError('a union must contain a single member')

            if module_rid is not None:
                self._module_rid = module_rid
                self._type = 'moduleRid'
            if asset_rid is not None:
                self._asset_rid = asset_rid
                self._type = 'assetRid'
            if workspace is not None:
                self._workspace = workspace
                self._type = 'workspace'
            if and_ is not None:
                self._and_ = and_
                self._type = 'and'
            if or_ is not None:
                self._or_ = or_
                self._type = 'or'
            if not_ is not None:
                self._not_ = not_
                self._type = 'not'

        elif type_of_union == 'moduleRid':
            if module_rid is None:
                raise ValueError('a union value must not be None')
            self._module_rid = module_rid
            self._type = 'moduleRid'
        elif type_of_union == 'assetRid':
            if asset_rid is None:
                raise ValueError('a union value must not be None')
            self._asset_rid = asset_rid
            self._type = 'assetRid'
        elif type_of_union == 'workspace':
            if workspace is None:
                raise ValueError('a union value must not be None')
            self._workspace = workspace
            self._type = 'workspace'
        elif type_of_union == 'and':
            if and_ is None:
                raise ValueError('a union value must not be None')
            self._and_ = and_
            self._type = 'and'
        elif type_of_union == 'or':
            if or_ is None:
                raise ValueError('a union value must not be None')
            self._or_ = or_
            self._type = 'or'
        elif type_of_union == 'not':
            if not_ is None:
                raise ValueError('a union value must not be None')
            self._not_ = not_
            self._type = 'not'

    @builtins.property
    def module_rid(self) -> Optional[str]:
        return self._module_rid

    @builtins.property
    def asset_rid(self) -> Optional[str]:
        return self._asset_rid

    @builtins.property
    def workspace(self) -> Optional[str]:
        return self._workspace

    @builtins.property
    def and_(self) -> Optional[List["module_SearchModuleApplicationsQuery"]]:
        return self._and_

    @builtins.property
    def or_(self) -> Optional[List["module_SearchModuleApplicationsQuery"]]:
        return self._or_

    @builtins.property
    def not_(self) -> Optional["module_SearchModuleApplicationsQuery"]:
        return self._not_

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, module_SearchModuleApplicationsQueryVisitor):
            raise ValueError('{} is not an instance of module_SearchModuleApplicationsQueryVisitor'.format(visitor.__class__.__name__))
        if self._type == 'moduleRid' and self.module_rid is not None:
            return visitor._module_rid(self.module_rid)
        if self._type == 'assetRid' and self.asset_rid is not None:
            return visitor._asset_rid(self.asset_rid)
        if self._type == 'workspace' and self.workspace is not None:
            return visitor._workspace(self.workspace)
        if self._type == 'and' and self.and_ is not None:
            return visitor._and(self.and_)
        if self._type == 'or' and self.or_ is not None:
            return visitor._or(self.or_)
        if self._type == 'not' and self.not_ is not None:
            return visitor._not(self.not_)


module_SearchModuleApplicationsQuery.__name__ = "SearchModuleApplicationsQuery"
module_SearchModuleApplicationsQuery.__qualname__ = "SearchModuleApplicationsQuery"
module_SearchModuleApplicationsQuery.__module__ = "nominal_api.module"


class module_SearchModuleApplicationsQueryVisitor:

    @abstractmethod
    def _module_rid(self, module_rid: str) -> Any:
        pass

    @abstractmethod
    def _asset_rid(self, asset_rid: str) -> Any:
        pass

    @abstractmethod
    def _workspace(self, workspace: str) -> Any:
        pass

    @abstractmethod
    def _and(self, and_: List["module_SearchModuleApplicationsQuery"]) -> Any:
        pass

    @abstractmethod
    def _or(self, or_: List["module_SearchModuleApplicationsQuery"]) -> Any:
        pass

    @abstractmethod
    def _not(self, not_: "module_SearchModuleApplicationsQuery") -> Any:
        pass


module_SearchModuleApplicationsQueryVisitor.__name__ = "SearchModuleApplicationsQueryVisitor"
module_SearchModuleApplicationsQueryVisitor.__qualname__ = "SearchModuleApplicationsQueryVisitor"
module_SearchModuleApplicationsQueryVisitor.__module__ = "nominal_api.module"


class module_SearchModuleApplicationsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'query': ConjureFieldDefinition('query', module_SearchModuleApplicationsQuery),
            'page_size': ConjureFieldDefinition('pageSize', int),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_query', '_page_size', '_next_page_token']

    def __init__(self, page_size: int, query: "module_SearchModuleApplicationsQuery", next_page_token: Optional[str] = None) -> None:
        self._query = query
        self._page_size = page_size
        self._next_page_token = next_page_token

    @builtins.property
    def query(self) -> "module_SearchModuleApplicationsQuery":
        return self._query

    @builtins.property
    def page_size(self) -> int:
        return self._page_size

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


module_SearchModuleApplicationsRequest.__name__ = "SearchModuleApplicationsRequest"
module_SearchModuleApplicationsRequest.__qualname__ = "SearchModuleApplicationsRequest"
module_SearchModuleApplicationsRequest.__module__ = "nominal_api.module"


class module_SearchModuleApplicationsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[module_ModuleApplication]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_results', '_next_page_token']

    def __init__(self, results: List["module_ModuleApplication"], next_page_token: Optional[str] = None) -> None:
        self._results = results
        self._next_page_token = next_page_token

    @builtins.property
    def results(self) -> List["module_ModuleApplication"]:
        return self._results

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


module_SearchModuleApplicationsResponse.__name__ = "SearchModuleApplicationsResponse"
module_SearchModuleApplicationsResponse.__qualname__ = "SearchModuleApplicationsResponse"
module_SearchModuleApplicationsResponse.__module__ = "nominal_api.module"


class module_SearchModulesQuery(ConjureUnionType):
    _search_text: Optional[str] = None
    _created_by: Optional[str] = None
    _last_updated_by: Optional[str] = None
    _workspace: Optional[str] = None
    _and_: Optional[List["module_SearchModulesQuery"]] = None
    _or_: Optional[List["module_SearchModulesQuery"]] = None
    _not_: Optional["module_SearchModulesQuery"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'search_text': ConjureFieldDefinition('searchText', str),
            'created_by': ConjureFieldDefinition('createdBy', scout_rids_api_UserRid),
            'last_updated_by': ConjureFieldDefinition('lastUpdatedBy', scout_rids_api_UserRid),
            'workspace': ConjureFieldDefinition('workspace', api_rids_WorkspaceRid),
            'and_': ConjureFieldDefinition('and', List[module_SearchModulesQuery]),
            'or_': ConjureFieldDefinition('or', List[module_SearchModulesQuery]),
            'not_': ConjureFieldDefinition('not', module_SearchModulesQuery)
        }

    def __init__(
            self,
            search_text: Optional[str] = None,
            created_by: Optional[str] = None,
            last_updated_by: Optional[str] = None,
            workspace: Optional[str] = None,
            and_: Optional[List["module_SearchModulesQuery"]] = None,
            or_: Optional[List["module_SearchModulesQuery"]] = None,
            not_: Optional["module_SearchModulesQuery"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (search_text is not None) + (created_by is not None) + (last_updated_by is not None) + (workspace is not None) + (and_ is not None) + (or_ is not None) + (not_ is not None) != 1:
                raise ValueError('a union must contain a single member')

            if search_text is not None:
                self._search_text = search_text
                self._type = 'searchText'
            if created_by is not None:
                self._created_by = created_by
                self._type = 'createdBy'
            if last_updated_by is not None:
                self._last_updated_by = last_updated_by
                self._type = 'lastUpdatedBy'
            if workspace is not None:
                self._workspace = workspace
                self._type = 'workspace'
            if and_ is not None:
                self._and_ = and_
                self._type = 'and'
            if or_ is not None:
                self._or_ = or_
                self._type = 'or'
            if not_ is not None:
                self._not_ = not_
                self._type = 'not'

        elif type_of_union == 'searchText':
            if search_text is None:
                raise ValueError('a union value must not be None')
            self._search_text = search_text
            self._type = 'searchText'
        elif type_of_union == 'createdBy':
            if created_by is None:
                raise ValueError('a union value must not be None')
            self._created_by = created_by
            self._type = 'createdBy'
        elif type_of_union == 'lastUpdatedBy':
            if last_updated_by is None:
                raise ValueError('a union value must not be None')
            self._last_updated_by = last_updated_by
            self._type = 'lastUpdatedBy'
        elif type_of_union == 'workspace':
            if workspace is None:
                raise ValueError('a union value must not be None')
            self._workspace = workspace
            self._type = 'workspace'
        elif type_of_union == 'and':
            if and_ is None:
                raise ValueError('a union value must not be None')
            self._and_ = and_
            self._type = 'and'
        elif type_of_union == 'or':
            if or_ is None:
                raise ValueError('a union value must not be None')
            self._or_ = or_
            self._type = 'or'
        elif type_of_union == 'not':
            if not_ is None:
                raise ValueError('a union value must not be None')
            self._not_ = not_
            self._type = 'not'

    @builtins.property
    def search_text(self) -> Optional[str]:
        return self._search_text

    @builtins.property
    def created_by(self) -> Optional[str]:
        return self._created_by

    @builtins.property
    def last_updated_by(self) -> Optional[str]:
        return self._last_updated_by

    @builtins.property
    def workspace(self) -> Optional[str]:
        return self._workspace

    @builtins.property
    def and_(self) -> Optional[List["module_SearchModulesQuery"]]:
        return self._and_

    @builtins.property
    def or_(self) -> Optional[List["module_SearchModulesQuery"]]:
        return self._or_

    @builtins.property
    def not_(self) -> Optional["module_SearchModulesQuery"]:
        return self._not_

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, module_SearchModulesQueryVisitor):
            raise ValueError('{} is not an instance of module_SearchModulesQueryVisitor'.format(visitor.__class__.__name__))
        if self._type == 'searchText' and self.search_text is not None:
            return visitor._search_text(self.search_text)
        if self._type == 'createdBy' and self.created_by is not None:
            return visitor._created_by(self.created_by)
        if self._type == 'lastUpdatedBy' and self.last_updated_by is not None:
            return visitor._last_updated_by(self.last_updated_by)
        if self._type == 'workspace' and self.workspace is not None:
            return visitor._workspace(self.workspace)
        if self._type == 'and' and self.and_ is not None:
            return visitor._and(self.and_)
        if self._type == 'or' and self.or_ is not None:
            return visitor._or(self.or_)
        if self._type == 'not' and self.not_ is not None:
            return visitor._not(self.not_)


module_SearchModulesQuery.__name__ = "SearchModulesQuery"
module_SearchModulesQuery.__qualname__ = "SearchModulesQuery"
module_SearchModulesQuery.__module__ = "nominal_api.module"


class module_SearchModulesQueryVisitor:

    @abstractmethod
    def _search_text(self, search_text: str) -> Any:
        pass

    @abstractmethod
    def _created_by(self, created_by: str) -> Any:
        pass

    @abstractmethod
    def _last_updated_by(self, last_updated_by: str) -> Any:
        pass

    @abstractmethod
    def _workspace(self, workspace: str) -> Any:
        pass

    @abstractmethod
    def _and(self, and_: List["module_SearchModulesQuery"]) -> Any:
        pass

    @abstractmethod
    def _or(self, or_: List["module_SearchModulesQuery"]) -> Any:
        pass

    @abstractmethod
    def _not(self, not_: "module_SearchModulesQuery") -> Any:
        pass


module_SearchModulesQueryVisitor.__name__ = "SearchModulesQueryVisitor"
module_SearchModulesQueryVisitor.__qualname__ = "SearchModulesQueryVisitor"
module_SearchModulesQueryVisitor.__module__ = "nominal_api.module"


class module_SearchModulesRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'query': ConjureFieldDefinition('query', module_SearchModulesQuery),
            'sort': ConjureFieldDefinition('sort', OptionalTypeWrapper[module_SearchModulesSortOptions]),
            'page_size': ConjureFieldDefinition('pageSize', int),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token]),
            'archived_statuses': ConjureFieldDefinition('archivedStatuses', OptionalTypeWrapper[List[api_ArchivedStatus]])
        }

    __slots__: List[str] = ['_query', '_sort', '_page_size', '_next_page_token', '_archived_statuses']

    def __init__(self, page_size: int, query: "module_SearchModulesQuery", archived_statuses: Optional[List["api_ArchivedStatus"]] = None, next_page_token: Optional[str] = None, sort: Optional["module_SearchModulesSortOptions"] = None) -> None:
        self._query = query
        self._sort = sort
        self._page_size = page_size
        self._next_page_token = next_page_token
        self._archived_statuses = archived_statuses

    @builtins.property
    def query(self) -> "module_SearchModulesQuery":
        return self._query

    @builtins.property
    def sort(self) -> Optional["module_SearchModulesSortOptions"]:
        return self._sort

    @builtins.property
    def page_size(self) -> int:
        return self._page_size

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token

    @builtins.property
    def archived_statuses(self) -> Optional[List["api_ArchivedStatus"]]:
        """Default search status is NOT_ARCHIVED if none are provided. Allows for including archived modules in search.
        """
        return self._archived_statuses


module_SearchModulesRequest.__name__ = "SearchModulesRequest"
module_SearchModulesRequest.__qualname__ = "SearchModulesRequest"
module_SearchModulesRequest.__module__ = "nominal_api.module"


class module_SearchModulesResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[module_ModuleSummary]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_results', '_next_page_token']

    def __init__(self, results: List["module_ModuleSummary"], next_page_token: Optional[str] = None) -> None:
        self._results = results
        self._next_page_token = next_page_token

    @builtins.property
    def results(self) -> List["module_ModuleSummary"]:
        return self._results

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


module_SearchModulesResponse.__name__ = "SearchModulesResponse"
module_SearchModulesResponse.__qualname__ = "SearchModulesResponse"
module_SearchModulesResponse.__module__ = "nominal_api.module"


class module_SearchModulesSortField(ConjureEnumType):

    NAME = 'NAME'
    '''NAME'''
    LAST_UPDATED_AT = 'LAST_UPDATED_AT'
    '''LAST_UPDATED_AT'''
    CREATED_AT = 'CREATED_AT'
    '''CREATED_AT'''
    ARCHIVED_AT = 'ARCHIVED_AT'
    '''ARCHIVED_AT'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


module_SearchModulesSortField.__name__ = "SearchModulesSortField"
module_SearchModulesSortField.__qualname__ = "SearchModulesSortField"
module_SearchModulesSortField.__module__ = "nominal_api.module"


class module_SearchModulesSortOptions(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'is_descending': ConjureFieldDefinition('isDescending', bool),
            'field': ConjureFieldDefinition('field', module_SearchModulesSortField)
        }

    __slots__: List[str] = ['_is_descending', '_field']

    def __init__(self, field: "module_SearchModulesSortField", is_descending: bool) -> None:
        self._is_descending = is_descending
        self._field = field

    @builtins.property
    def is_descending(self) -> bool:
        return self._is_descending

    @builtins.property
    def field(self) -> "module_SearchModulesSortField":
        return self._field


module_SearchModulesSortOptions.__name__ = "SearchModulesSortOptions"
module_SearchModulesSortOptions.__qualname__ = "SearchModulesSortOptions"
module_SearchModulesSortOptions.__module__ = "nominal_api.module"


class module_UpdateModuleRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'title': ConjureFieldDefinition('title', str),
            'description': ConjureFieldDefinition('description', str),
            'definition': ConjureFieldDefinition('definition', module_ModuleVersionDefinition)
        }

    __slots__: List[str] = ['_title', '_description', '_definition']

    def __init__(self, definition: "module_ModuleVersionDefinition", description: str, title: str) -> None:
        self._title = title
        self._description = description
        self._definition = definition

    @builtins.property
    def title(self) -> str:
        return self._title

    @builtins.property
    def description(self) -> str:
        return self._description

    @builtins.property
    def definition(self) -> "module_ModuleVersionDefinition":
        return self._definition


module_UpdateModuleRequest.__name__ = "UpdateModuleRequest"
module_UpdateModuleRequest.__qualname__ = "UpdateModuleRequest"
module_UpdateModuleRequest.__module__ = "nominal_api.module"


class module_ValueType(ConjureEnumType):

    NUMERIC_SERIES = 'NUMERIC_SERIES'
    '''NUMERIC_SERIES'''
    ENUM_SERIES = 'ENUM_SERIES'
    '''ENUM_SERIES'''
    RANGES_SERIES = 'RANGES_SERIES'
    '''RANGES_SERIES'''
    STRING_CONSTANT = 'STRING_CONSTANT'
    '''STRING_CONSTANT'''
    DURATION_CONSTANT = 'DURATION_CONSTANT'
    '''DURATION_CONSTANT'''
    TIMESTAMP_CONSTANT = 'TIMESTAMP_CONSTANT'
    '''TIMESTAMP_CONSTANT'''
    INTEGER_CONSTANT = 'INTEGER_CONSTANT'
    '''INTEGER_CONSTANT'''
    DOUBLE_CONSTANT = 'DOUBLE_CONSTANT'
    '''DOUBLE_CONSTANT'''
    ASSET_RID = 'ASSET_RID'
    '''ASSET_RID'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


module_ValueType.__name__ = "ValueType"
module_ValueType.__qualname__ = "ValueType"
module_ValueType.__module__ = "nominal_api.module"


class module_VersionStrategy(ConjureUnionType):
    _pinned: Optional["module_PinnedVersionStrategy"] = None
    _latest: Optional["module_LatestVersionStrategy"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'pinned': ConjureFieldDefinition('pinned', module_PinnedVersionStrategy),
            'latest': ConjureFieldDefinition('latest', module_LatestVersionStrategy)
        }

    def __init__(
            self,
            pinned: Optional["module_PinnedVersionStrategy"] = None,
            latest: Optional["module_LatestVersionStrategy"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (pinned is not None) + (latest is not None) != 1:
                raise ValueError('a union must contain a single member')

            if pinned is not None:
                self._pinned = pinned
                self._type = 'pinned'
            if latest is not None:
                self._latest = latest
                self._type = 'latest'

        elif type_of_union == 'pinned':
            if pinned is None:
                raise ValueError('a union value must not be None')
            self._pinned = pinned
            self._type = 'pinned'
        elif type_of_union == 'latest':
            if latest is None:
                raise ValueError('a union value must not be None')
            self._latest = latest
            self._type = 'latest'

    @builtins.property
    def pinned(self) -> Optional["module_PinnedVersionStrategy"]:
        return self._pinned

    @builtins.property
    def latest(self) -> Optional["module_LatestVersionStrategy"]:
        return self._latest

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, module_VersionStrategyVisitor):
            raise ValueError('{} is not an instance of module_VersionStrategyVisitor'.format(visitor.__class__.__name__))
        if self._type == 'pinned' and self.pinned is not None:
            return visitor._pinned(self.pinned)
        if self._type == 'latest' and self.latest is not None:
            return visitor._latest(self.latest)


module_VersionStrategy.__name__ = "VersionStrategy"
module_VersionStrategy.__qualname__ = "VersionStrategy"
module_VersionStrategy.__module__ = "nominal_api.module"


class module_VersionStrategyVisitor:

    @abstractmethod
    def _pinned(self, pinned: "module_PinnedVersionStrategy") -> Any:
        pass

    @abstractmethod
    def _latest(self, latest: "module_LatestVersionStrategy") -> Any:
        pass


module_VersionStrategyVisitor.__name__ = "VersionStrategyVisitor"
module_VersionStrategyVisitor.__qualname__ = "VersionStrategyVisitor"
module_VersionStrategyVisitor.__module__ = "nominal_api.module"


class module_internal_BatchGetResolvedModuleDefinitionsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'requests': ConjureFieldDefinition('requests', List[module_internal_ModuleApplicationReference])
        }

    __slots__: List[str] = ['_requests']

    def __init__(self, requests: List["module_internal_ModuleApplicationReference"]) -> None:
        self._requests = requests

    @builtins.property
    def requests(self) -> List["module_internal_ModuleApplicationReference"]:
        return self._requests


module_internal_BatchGetResolvedModuleDefinitionsRequest.__name__ = "BatchGetResolvedModuleDefinitionsRequest"
module_internal_BatchGetResolvedModuleDefinitionsRequest.__qualname__ = "BatchGetResolvedModuleDefinitionsRequest"
module_internal_BatchGetResolvedModuleDefinitionsRequest.__module__ = "nominal_api.module_internal"


class module_internal_BatchGetResolvedModuleDefinitionsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[module_internal_ResolvedModuleVersionDefinition])
        }

    __slots__: List[str] = ['_results']

    def __init__(self, results: List["module_internal_ResolvedModuleVersionDefinition"]) -> None:
        self._results = results

    @builtins.property
    def results(self) -> List["module_internal_ResolvedModuleVersionDefinition"]:
        return self._results


module_internal_BatchGetResolvedModuleDefinitionsResponse.__name__ = "BatchGetResolvedModuleDefinitionsResponse"
module_internal_BatchGetResolvedModuleDefinitionsResponse.__qualname__ = "BatchGetResolvedModuleDefinitionsResponse"
module_internal_BatchGetResolvedModuleDefinitionsResponse.__module__ = "nominal_api.module_internal"


class module_internal_BatchGetUnresolvedModuleDefinitionsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'requests': ConjureFieldDefinition('requests', List[module_RequestModuleNameRef])
        }

    __slots__: List[str] = ['_requests']

    def __init__(self, requests: List["module_RequestModuleNameRef"]) -> None:
        self._requests = requests

    @builtins.property
    def requests(self) -> List["module_RequestModuleNameRef"]:
        return self._requests


module_internal_BatchGetUnresolvedModuleDefinitionsRequest.__name__ = "BatchGetUnresolvedModuleDefinitionsRequest"
module_internal_BatchGetUnresolvedModuleDefinitionsRequest.__qualname__ = "BatchGetUnresolvedModuleDefinitionsRequest"
module_internal_BatchGetUnresolvedModuleDefinitionsRequest.__module__ = "nominal_api.module_internal"


class module_internal_BatchGetUnresolvedModuleDefinitionsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[module_internal_ModuleComputeDefinition])
        }

    __slots__: List[str] = ['_results']

    def __init__(self, results: List["module_internal_ModuleComputeDefinition"]) -> None:
        self._results = results

    @builtins.property
    def results(self) -> List["module_internal_ModuleComputeDefinition"]:
        return self._results


module_internal_BatchGetUnresolvedModuleDefinitionsResponse.__name__ = "BatchGetUnresolvedModuleDefinitionsResponse"
module_internal_BatchGetUnresolvedModuleDefinitionsResponse.__qualname__ = "BatchGetUnresolvedModuleDefinitionsResponse"
module_internal_BatchGetUnresolvedModuleDefinitionsResponse.__module__ = "nominal_api.module_internal"


class module_internal_InternalModuleService(Service):
    """This service provides internal APIs related to modules.
    """

    def batch_get_resolved_module_definitions(self, auth_header: str, request: "module_internal_BatchGetResolvedModuleDefinitionsRequest") -> "module_internal_BatchGetResolvedModuleDefinitionsResponse":
        """Returns the resolved module definitions for the requested ModuleApplication.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/internal/scout/v2/module/resolved-module/batch-get'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), module_internal_BatchGetResolvedModuleDefinitionsResponse, self._return_none_for_unknown_union_types)

    def batch_get_unresolved_module_definition(self, auth_header: str, request: "module_internal_BatchGetUnresolvedModuleDefinitionsRequest") -> "module_internal_BatchGetUnresolvedModuleDefinitionsResponse":
        """Returns the module definition for the given module reference.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/internal/scout/v2/module/unresolved-module/batch-get'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), module_internal_BatchGetUnresolvedModuleDefinitionsResponse, self._return_none_for_unknown_union_types)


module_internal_InternalModuleService.__name__ = "InternalModuleService"
module_internal_InternalModuleService.__qualname__ = "InternalModuleService"
module_internal_InternalModuleService.__module__ = "nominal_api.module_internal"


class module_internal_ModuleApplicationReference(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'module_application_rid': ConjureFieldDefinition('moduleApplicationRid', modules_api_ModuleApplicationRid)
        }

    __slots__: List[str] = ['_module_application_rid']

    def __init__(self, module_application_rid: str) -> None:
        self._module_application_rid = module_application_rid

    @builtins.property
    def module_application_rid(self) -> str:
        return self._module_application_rid


module_internal_ModuleApplicationReference.__name__ = "ModuleApplicationReference"
module_internal_ModuleApplicationReference.__qualname__ = "ModuleApplicationReference"
module_internal_ModuleApplicationReference.__module__ = "nominal_api.module_internal"


class module_internal_ModuleComputeDefinition(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'module_api_name': ConjureFieldDefinition('moduleApiName', str),
            'module_rid': ConjureFieldDefinition('moduleRid', modules_api_ModuleRid),
            'version': ConjureFieldDefinition('version', module_ModuleVersion),
            'default_variables': ConjureFieldDefinition('defaultVariables', List[module_ModuleVariable]),
            'functions': ConjureFieldDefinition('functions', List[module_Function])
        }

    __slots__: List[str] = ['_module_api_name', '_module_rid', '_version', '_default_variables', '_functions']

    def __init__(self, default_variables: List["module_ModuleVariable"], functions: List["module_Function"], module_api_name: str, module_rid: str, version: str) -> None:
        self._module_api_name = module_api_name
        self._module_rid = module_rid
        self._version = version
        self._default_variables = default_variables
        self._functions = functions

    @builtins.property
    def module_api_name(self) -> str:
        return self._module_api_name

    @builtins.property
    def module_rid(self) -> str:
        return self._module_rid

    @builtins.property
    def version(self) -> str:
        return self._version

    @builtins.property
    def default_variables(self) -> List["module_ModuleVariable"]:
        return self._default_variables

    @builtins.property
    def functions(self) -> List["module_Function"]:
        return self._functions


module_internal_ModuleComputeDefinition.__name__ = "ModuleComputeDefinition"
module_internal_ModuleComputeDefinition.__qualname__ = "ModuleComputeDefinition"
module_internal_ModuleComputeDefinition.__module__ = "nominal_api.module_internal"


class module_internal_ResolvedModuleVersionDefinition(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'module_application_rid': ConjureFieldDefinition('moduleApplicationRid', modules_api_ModuleApplicationRid),
            'resolved_parameters': ConjureFieldDefinition('resolvedParameters', List[module_ModuleVariable]),
            'module_definition': ConjureFieldDefinition('moduleDefinition', module_internal_ModuleComputeDefinition)
        }

    __slots__: List[str] = ['_module_application_rid', '_resolved_parameters', '_module_definition']

    def __init__(self, module_application_rid: str, module_definition: "module_internal_ModuleComputeDefinition", resolved_parameters: List["module_ModuleVariable"]) -> None:
        self._module_application_rid = module_application_rid
        self._resolved_parameters = resolved_parameters
        self._module_definition = module_definition

    @builtins.property
    def module_application_rid(self) -> str:
        return self._module_application_rid

    @builtins.property
    def resolved_parameters(self) -> List["module_ModuleVariable"]:
        return self._resolved_parameters

    @builtins.property
    def module_definition(self) -> "module_internal_ModuleComputeDefinition":
        return self._module_definition


module_internal_ResolvedModuleVersionDefinition.__name__ = "ResolvedModuleVersionDefinition"
module_internal_ResolvedModuleVersionDefinition.__qualname__ = "ResolvedModuleVersionDefinition"
module_internal_ResolvedModuleVersionDefinition.__module__ = "nominal_api.module_internal"


class persistent_compute_api_AppendResult(ConjureBeanType):
    """An append result won't cover the full `StreamingComputeNodeRequest#windowWidth` but rather just a smaller 
window. The end of the window that the append covers is guaranteed to be later than previously sent results.
The start, however, can and most likely will overlap with previous results. That allows us to support 
out-of-order points. The client will have to merge this new `AppendResult` with previous results.
Example of time windows that might be covered by results for a subscription: 
We send a full result for window [0s, 120s] followed by an append result for [116s, 121s] and another 
append result for [117s, 122s].
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'start': ConjureFieldDefinition('start', api_Timestamp),
            'end': ConjureFieldDefinition('end', api_Timestamp),
            'result': ConjureFieldDefinition('result', persistent_compute_api_ComputeNodeAppendResponse)
        }

    __slots__: List[str] = ['_start', '_end', '_result']

    def __init__(self, end: "api_Timestamp", result: "persistent_compute_api_ComputeNodeAppendResponse", start: "api_Timestamp") -> None:
        self._start = start
        self._end = end
        self._result = result

    @builtins.property
    def start(self) -> "api_Timestamp":
        """The start of the time range that the append result covers
        """
        return self._start

    @builtins.property
    def end(self) -> "api_Timestamp":
        """The end of the time range that the append result covers
        """
        return self._end

    @builtins.property
    def result(self) -> "persistent_compute_api_ComputeNodeAppendResponse":
        return self._result


persistent_compute_api_AppendResult.__name__ = "AppendResult"
persistent_compute_api_AppendResult.__qualname__ = "AppendResult"
persistent_compute_api_AppendResult.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_ClientMessage(ConjureUnionType):
    _subscribe: Optional[Dict[str, "persistent_compute_api_StreamingComputeNodeSubscription"]] = None
    _unsubscribe: Optional[List[str]] = None
    _ping: Optional["persistent_compute_api_Ping"] = None
    _pong: Optional["persistent_compute_api_Pong"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'subscribe': ConjureFieldDefinition('subscribe', Dict[persistent_compute_api_SubscriptionId, persistent_compute_api_StreamingComputeNodeSubscription]),
            'unsubscribe': ConjureFieldDefinition('unsubscribe', List[persistent_compute_api_SubscriptionId]),
            'ping': ConjureFieldDefinition('ping', persistent_compute_api_Ping),
            'pong': ConjureFieldDefinition('pong', persistent_compute_api_Pong)
        }

    def __init__(
            self,
            subscribe: Optional[Dict[str, "persistent_compute_api_StreamingComputeNodeSubscription"]] = None,
            unsubscribe: Optional[List[str]] = None,
            ping: Optional["persistent_compute_api_Ping"] = None,
            pong: Optional["persistent_compute_api_Pong"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (subscribe is not None) + (unsubscribe is not None) + (ping is not None) + (pong is not None) != 1:
                raise ValueError('a union must contain a single member')

            if subscribe is not None:
                self._subscribe = subscribe
                self._type = 'subscribe'
            if unsubscribe is not None:
                self._unsubscribe = unsubscribe
                self._type = 'unsubscribe'
            if ping is not None:
                self._ping = ping
                self._type = 'ping'
            if pong is not None:
                self._pong = pong
                self._type = 'pong'

        elif type_of_union == 'subscribe':
            if subscribe is None:
                raise ValueError('a union value must not be None')
            self._subscribe = subscribe
            self._type = 'subscribe'
        elif type_of_union == 'unsubscribe':
            if unsubscribe is None:
                raise ValueError('a union value must not be None')
            self._unsubscribe = unsubscribe
            self._type = 'unsubscribe'
        elif type_of_union == 'ping':
            if ping is None:
                raise ValueError('a union value must not be None')
            self._ping = ping
            self._type = 'ping'
        elif type_of_union == 'pong':
            if pong is None:
                raise ValueError('a union value must not be None')
            self._pong = pong
            self._type = 'pong'

    @builtins.property
    def subscribe(self) -> Optional[Dict[str, "persistent_compute_api_StreamingComputeNodeSubscription"]]:
        """Subscribes to all of the given `StreamingComputeNodeSubscription`s. For identifying the subscriptions and
their results a `SubscriptionId` has to be passed, which should be a unique identifier.
A `ServerMessage::subscriptionCreation` will be sent back for each subscription which shows whether the 
subscription was successfully created. If it was, updated results for the subscription will be  sent 
periodically via `ServerMessage::subscriptionUpdate`.
        """
        return self._subscribe

    @builtins.property
    def unsubscribe(self) -> Optional[List[str]]:
        return self._unsubscribe

    @builtins.property
    def ping(self) -> Optional["persistent_compute_api_Ping"]:
        return self._ping

    @builtins.property
    def pong(self) -> Optional["persistent_compute_api_Pong"]:
        return self._pong

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, persistent_compute_api_ClientMessageVisitor):
            raise ValueError('{} is not an instance of persistent_compute_api_ClientMessageVisitor'.format(visitor.__class__.__name__))
        if self._type == 'subscribe' and self.subscribe is not None:
            return visitor._subscribe(self.subscribe)
        if self._type == 'unsubscribe' and self.unsubscribe is not None:
            return visitor._unsubscribe(self.unsubscribe)
        if self._type == 'ping' and self.ping is not None:
            return visitor._ping(self.ping)
        if self._type == 'pong' and self.pong is not None:
            return visitor._pong(self.pong)


persistent_compute_api_ClientMessage.__name__ = "ClientMessage"
persistent_compute_api_ClientMessage.__qualname__ = "ClientMessage"
persistent_compute_api_ClientMessage.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_ClientMessageVisitor:

    @abstractmethod
    def _subscribe(self, subscribe: Dict[str, "persistent_compute_api_StreamingComputeNodeSubscription"]) -> Any:
        pass

    @abstractmethod
    def _unsubscribe(self, unsubscribe: List[str]) -> Any:
        pass

    @abstractmethod
    def _ping(self, ping: "persistent_compute_api_Ping") -> Any:
        pass

    @abstractmethod
    def _pong(self, pong: "persistent_compute_api_Pong") -> Any:
        pass


persistent_compute_api_ClientMessageVisitor.__name__ = "ClientMessageVisitor"
persistent_compute_api_ClientMessageVisitor.__qualname__ = "ClientMessageVisitor"
persistent_compute_api_ClientMessageVisitor.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_ClientMessageError(ConjureBeanType):
    """This will be sent if there is an error processing a `ClientMessage`. Note: This won't automatically close 
the connection. The client can continue sending `ClientMessage`s after receiving this error.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'error': ConjureFieldDefinition('error', api_SerializableError)
        }

    __slots__: List[str] = ['_error']

    def __init__(self, error: "api_SerializableError") -> None:
        self._error = error

    @builtins.property
    def error(self) -> "api_SerializableError":
        return self._error


persistent_compute_api_ClientMessageError.__name__ = "ClientMessageError"
persistent_compute_api_ClientMessageError.__qualname__ = "ClientMessageError"
persistent_compute_api_ClientMessageError.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_ComputeNodeAppendResponse(ConjureUnionType):
    """These cover the subset of the union type in `ComputeNodeResponse` for which we support append results.
Append results will have the same subtype as the previous full result for the same `SubscriptionId`. 
If the subtype were to change (e.g., we start doing bucketing because data frequency increased) we will send 
a new full result with that new type. The results will also have the same units as the previous `FullResult`.
Notably, we currently don't support appends for bucketed results as merging buckets is not trivial, especially 
when accounting for out-of-order points.
    """
    _range: Optional[List["scout_compute_api_Range"]] = None
    _enum_point: Optional[Optional["scout_compute_api_EnumPoint"]] = None
    _numeric_point: Optional[Optional["scout_compute_api_NumericPoint"]] = None
    _single_point: Optional[Optional["scout_compute_api_SinglePoint"]] = None
    _log_point: Optional[Optional["scout_compute_api_LogPoint"]] = None
    _range_value: Optional[Optional["scout_compute_api_Range"]] = None
    _numeric: Optional["scout_compute_api_NumericPlot"] = None
    _enum: Optional["scout_compute_api_EnumPlot"] = None
    _bucketed_numeric: Optional["scout_compute_api_BucketedNumericPlot"] = None
    _bucketed_enum: Optional["scout_compute_api_BucketedEnumPlot"] = None
    _arrow_numeric: Optional["scout_compute_api_ArrowNumericPlot"] = None
    _arrow_enum: Optional["scout_compute_api_ArrowEnumPlot"] = None
    _arrow_bucketed_numeric: Optional["scout_compute_api_ArrowBucketedNumericPlot"] = None
    _arrow_bucketed_enum: Optional["scout_compute_api_ArrowBucketedEnumPlot"] = None
    _grouped: Optional["persistent_compute_api_GroupedComputeNodeAppendResponses"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'range': ConjureFieldDefinition('range', List[scout_compute_api_Range]),
            'enum_point': ConjureFieldDefinition('enumPoint', OptionalTypeWrapper[scout_compute_api_EnumPoint]),
            'numeric_point': ConjureFieldDefinition('numericPoint', OptionalTypeWrapper[scout_compute_api_NumericPoint]),
            'single_point': ConjureFieldDefinition('singlePoint', OptionalTypeWrapper[scout_compute_api_SinglePoint]),
            'log_point': ConjureFieldDefinition('logPoint', OptionalTypeWrapper[scout_compute_api_LogPoint]),
            'range_value': ConjureFieldDefinition('rangeValue', OptionalTypeWrapper[scout_compute_api_Range]),
            'numeric': ConjureFieldDefinition('numeric', scout_compute_api_NumericPlot),
            'enum': ConjureFieldDefinition('enum', scout_compute_api_EnumPlot),
            'bucketed_numeric': ConjureFieldDefinition('bucketedNumeric', scout_compute_api_BucketedNumericPlot),
            'bucketed_enum': ConjureFieldDefinition('bucketedEnum', scout_compute_api_BucketedEnumPlot),
            'arrow_numeric': ConjureFieldDefinition('arrowNumeric', scout_compute_api_ArrowNumericPlot),
            'arrow_enum': ConjureFieldDefinition('arrowEnum', scout_compute_api_ArrowEnumPlot),
            'arrow_bucketed_numeric': ConjureFieldDefinition('arrowBucketedNumeric', scout_compute_api_ArrowBucketedNumericPlot),
            'arrow_bucketed_enum': ConjureFieldDefinition('arrowBucketedEnum', scout_compute_api_ArrowBucketedEnumPlot),
            'grouped': ConjureFieldDefinition('grouped', persistent_compute_api_GroupedComputeNodeAppendResponses)
        }

    def __init__(
            self,
            range: Optional[List["scout_compute_api_Range"]] = None,
            enum_point: Optional[Optional["scout_compute_api_EnumPoint"]] = None,
            numeric_point: Optional[Optional["scout_compute_api_NumericPoint"]] = None,
            single_point: Optional[Optional["scout_compute_api_SinglePoint"]] = None,
            log_point: Optional[Optional["scout_compute_api_LogPoint"]] = None,
            range_value: Optional[Optional["scout_compute_api_Range"]] = None,
            numeric: Optional["scout_compute_api_NumericPlot"] = None,
            enum: Optional["scout_compute_api_EnumPlot"] = None,
            bucketed_numeric: Optional["scout_compute_api_BucketedNumericPlot"] = None,
            bucketed_enum: Optional["scout_compute_api_BucketedEnumPlot"] = None,
            arrow_numeric: Optional["scout_compute_api_ArrowNumericPlot"] = None,
            arrow_enum: Optional["scout_compute_api_ArrowEnumPlot"] = None,
            arrow_bucketed_numeric: Optional["scout_compute_api_ArrowBucketedNumericPlot"] = None,
            arrow_bucketed_enum: Optional["scout_compute_api_ArrowBucketedEnumPlot"] = None,
            grouped: Optional["persistent_compute_api_GroupedComputeNodeAppendResponses"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (range is not None) + (enum_point is not None) + (numeric_point is not None) + (single_point is not None) + (log_point is not None) + (range_value is not None) + (numeric is not None) + (enum is not None) + (bucketed_numeric is not None) + (bucketed_enum is not None) + (arrow_numeric is not None) + (arrow_enum is not None) + (arrow_bucketed_numeric is not None) + (arrow_bucketed_enum is not None) + (grouped is not None) != 1:
                raise ValueError('a union must contain a single member')

            if range is not None:
                self._range = range
                self._type = 'range'
            if enum_point is not None:
                self._enum_point = enum_point
                self._type = 'enumPoint'
            if numeric_point is not None:
                self._numeric_point = numeric_point
                self._type = 'numericPoint'
            if single_point is not None:
                self._single_point = single_point
                self._type = 'singlePoint'
            if log_point is not None:
                self._log_point = log_point
                self._type = 'logPoint'
            if range_value is not None:
                self._range_value = range_value
                self._type = 'rangeValue'
            if numeric is not None:
                self._numeric = numeric
                self._type = 'numeric'
            if enum is not None:
                self._enum = enum
                self._type = 'enum'
            if bucketed_numeric is not None:
                self._bucketed_numeric = bucketed_numeric
                self._type = 'bucketedNumeric'
            if bucketed_enum is not None:
                self._bucketed_enum = bucketed_enum
                self._type = 'bucketedEnum'
            if arrow_numeric is not None:
                self._arrow_numeric = arrow_numeric
                self._type = 'arrowNumeric'
            if arrow_enum is not None:
                self._arrow_enum = arrow_enum
                self._type = 'arrowEnum'
            if arrow_bucketed_numeric is not None:
                self._arrow_bucketed_numeric = arrow_bucketed_numeric
                self._type = 'arrowBucketedNumeric'
            if arrow_bucketed_enum is not None:
                self._arrow_bucketed_enum = arrow_bucketed_enum
                self._type = 'arrowBucketedEnum'
            if grouped is not None:
                self._grouped = grouped
                self._type = 'grouped'

        elif type_of_union == 'range':
            if range is None:
                raise ValueError('a union value must not be None')
            self._range = range
            self._type = 'range'
        elif type_of_union == 'enumPoint':
            if enum_point is None:
                raise ValueError('a union value must not be None')
            self._enum_point = enum_point
            self._type = 'enumPoint'
        elif type_of_union == 'numericPoint':
            if numeric_point is None:
                raise ValueError('a union value must not be None')
            self._numeric_point = numeric_point
            self._type = 'numericPoint'
        elif type_of_union == 'singlePoint':
            if single_point is None:
                raise ValueError('a union value must not be None')
            self._single_point = single_point
            self._type = 'singlePoint'
        elif type_of_union == 'logPoint':
            if log_point is None:
                raise ValueError('a union value must not be None')
            self._log_point = log_point
            self._type = 'logPoint'
        elif type_of_union == 'rangeValue':
            if range_value is None:
                raise ValueError('a union value must not be None')
            self._range_value = range_value
            self._type = 'rangeValue'
        elif type_of_union == 'numeric':
            if numeric is None:
                raise ValueError('a union value must not be None')
            self._numeric = numeric
            self._type = 'numeric'
        elif type_of_union == 'enum':
            if enum is None:
                raise ValueError('a union value must not be None')
            self._enum = enum
            self._type = 'enum'
        elif type_of_union == 'bucketedNumeric':
            if bucketed_numeric is None:
                raise ValueError('a union value must not be None')
            self._bucketed_numeric = bucketed_numeric
            self._type = 'bucketedNumeric'
        elif type_of_union == 'bucketedEnum':
            if bucketed_enum is None:
                raise ValueError('a union value must not be None')
            self._bucketed_enum = bucketed_enum
            self._type = 'bucketedEnum'
        elif type_of_union == 'arrowNumeric':
            if arrow_numeric is None:
                raise ValueError('a union value must not be None')
            self._arrow_numeric = arrow_numeric
            self._type = 'arrowNumeric'
        elif type_of_union == 'arrowEnum':
            if arrow_enum is None:
                raise ValueError('a union value must not be None')
            self._arrow_enum = arrow_enum
            self._type = 'arrowEnum'
        elif type_of_union == 'arrowBucketedNumeric':
            if arrow_bucketed_numeric is None:
                raise ValueError('a union value must not be None')
            self._arrow_bucketed_numeric = arrow_bucketed_numeric
            self._type = 'arrowBucketedNumeric'
        elif type_of_union == 'arrowBucketedEnum':
            if arrow_bucketed_enum is None:
                raise ValueError('a union value must not be None')
            self._arrow_bucketed_enum = arrow_bucketed_enum
            self._type = 'arrowBucketedEnum'
        elif type_of_union == 'grouped':
            if grouped is None:
                raise ValueError('a union value must not be None')
            self._grouped = grouped
            self._type = 'grouped'

    @builtins.property
    def range(self) -> Optional[List["scout_compute_api_Range"]]:
        """Merging can be done via dropping any old ranges (possibly truncating the last one) and adding these new 
ranges, possibly merging them if they overlap or are adjacent.
        """
        return self._range

    @builtins.property
    def enum_point(self) -> Optional[Optional["scout_compute_api_EnumPoint"]]:
        """Merging can be done by keeping track of the applicable point present within the current window
        """
        return self._enum_point

    @builtins.property
    def numeric_point(self) -> Optional[Optional["scout_compute_api_NumericPoint"]]:
        """Merging can be done by keeping track of the applicable point present within the current window
        """
        return self._numeric_point

    @builtins.property
    def single_point(self) -> Optional[Optional["scout_compute_api_SinglePoint"]]:
        """Merging can be done by keeping track of the applicable point present within the current window
        """
        return self._single_point

    @builtins.property
    def log_point(self) -> Optional[Optional["scout_compute_api_LogPoint"]]:
        """Merging can be done by keeping track of the applicable point present within the current window
        """
        return self._log_point

    @builtins.property
    def range_value(self) -> Optional[Optional["scout_compute_api_Range"]]:
        """Merging can be done by keeping track of the applicable range present within the current window, possibly
merging ranges if they are overlap or are adjacent
        """
        return self._range_value

    @builtins.property
    def numeric(self) -> Optional["scout_compute_api_NumericPlot"]:
        """Merging can be done by dropping any old points and adding the new ones, accounting for overlaps
        """
        return self._numeric

    @builtins.property
    def enum(self) -> Optional["scout_compute_api_EnumPlot"]:
        """Merging can be done by dropping any old points and adding the new ones, accounting for overlaps
        """
        return self._enum

    @builtins.property
    def bucketed_numeric(self) -> Optional["scout_compute_api_BucketedNumericPlot"]:
        """Merging can be done by dropping any old buckets and adding the new ones. Overlapping buckets are
guaranteed to align (same bucket end timestamp) and the older version of the bucket can be replaced
with the newer ones.
        """
        return self._bucketed_numeric

    @builtins.property
    def bucketed_enum(self) -> Optional["scout_compute_api_BucketedEnumPlot"]:
        """Merging can be done by dropping any old buckets and adding the new ones. Overlapping buckets are
guaranteed to align (same bucket end timestamp) and the older version of the bucket can be replaced
with the newer ones.
        """
        return self._bucketed_enum

    @builtins.property
    def arrow_numeric(self) -> Optional["scout_compute_api_ArrowNumericPlot"]:
        """Merging can be done by dropping any old points and adding the new ones, accounting for overlaps
        """
        return self._arrow_numeric

    @builtins.property
    def arrow_enum(self) -> Optional["scout_compute_api_ArrowEnumPlot"]:
        """Merging can be done by dropping any old points and adding the new ones, accounting for overlaps
        """
        return self._arrow_enum

    @builtins.property
    def arrow_bucketed_numeric(self) -> Optional["scout_compute_api_ArrowBucketedNumericPlot"]:
        """Merging can be done by dropping any old buckets and adding the new ones. Overlapping buckets are
guaranteed to align (same bucket end timestamp) and the older version of the bucket can be replaced
with the newer ones.
        """
        return self._arrow_bucketed_numeric

    @builtins.property
    def arrow_bucketed_enum(self) -> Optional["scout_compute_api_ArrowBucketedEnumPlot"]:
        """Merging can be done by dropping any old buckets and adding the new ones. Overlapping buckets are
guaranteed to align (same bucket end timestamp) and the older version of the bucket can be replaced
with the newer ones.
        """
        return self._arrow_bucketed_enum

    @builtins.property
    def grouped(self) -> Optional["persistent_compute_api_GroupedComputeNodeAppendResponses"]:
        """Appends can be done by doing an append individually for each contained `ComputeNodeAppendResponse`.
        """
        return self._grouped

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, persistent_compute_api_ComputeNodeAppendResponseVisitor):
            raise ValueError('{} is not an instance of persistent_compute_api_ComputeNodeAppendResponseVisitor'.format(visitor.__class__.__name__))
        if self._type == 'range' and self.range is not None:
            return visitor._range(self.range)
        if self._type == 'enumPoint' and self.enum_point is not None:
            return visitor._enum_point(self.enum_point)
        if self._type == 'numericPoint' and self.numeric_point is not None:
            return visitor._numeric_point(self.numeric_point)
        if self._type == 'singlePoint' and self.single_point is not None:
            return visitor._single_point(self.single_point)
        if self._type == 'logPoint' and self.log_point is not None:
            return visitor._log_point(self.log_point)
        if self._type == 'rangeValue' and self.range_value is not None:
            return visitor._range_value(self.range_value)
        if self._type == 'numeric' and self.numeric is not None:
            return visitor._numeric(self.numeric)
        if self._type == 'enum' and self.enum is not None:
            return visitor._enum(self.enum)
        if self._type == 'bucketedNumeric' and self.bucketed_numeric is not None:
            return visitor._bucketed_numeric(self.bucketed_numeric)
        if self._type == 'bucketedEnum' and self.bucketed_enum is not None:
            return visitor._bucketed_enum(self.bucketed_enum)
        if self._type == 'arrowNumeric' and self.arrow_numeric is not None:
            return visitor._arrow_numeric(self.arrow_numeric)
        if self._type == 'arrowEnum' and self.arrow_enum is not None:
            return visitor._arrow_enum(self.arrow_enum)
        if self._type == 'arrowBucketedNumeric' and self.arrow_bucketed_numeric is not None:
            return visitor._arrow_bucketed_numeric(self.arrow_bucketed_numeric)
        if self._type == 'arrowBucketedEnum' and self.arrow_bucketed_enum is not None:
            return visitor._arrow_bucketed_enum(self.arrow_bucketed_enum)
        if self._type == 'grouped' and self.grouped is not None:
            return visitor._grouped(self.grouped)


persistent_compute_api_ComputeNodeAppendResponse.__name__ = "ComputeNodeAppendResponse"
persistent_compute_api_ComputeNodeAppendResponse.__qualname__ = "ComputeNodeAppendResponse"
persistent_compute_api_ComputeNodeAppendResponse.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_ComputeNodeAppendResponseVisitor:

    @abstractmethod
    def _range(self, range: List["scout_compute_api_Range"]) -> Any:
        pass

    @abstractmethod
    def _enum_point(self, enum_point: Optional["scout_compute_api_EnumPoint"]) -> Any:
        pass

    @abstractmethod
    def _numeric_point(self, numeric_point: Optional["scout_compute_api_NumericPoint"]) -> Any:
        pass

    @abstractmethod
    def _single_point(self, single_point: Optional["scout_compute_api_SinglePoint"]) -> Any:
        pass

    @abstractmethod
    def _log_point(self, log_point: Optional["scout_compute_api_LogPoint"]) -> Any:
        pass

    @abstractmethod
    def _range_value(self, range_value: Optional["scout_compute_api_Range"]) -> Any:
        pass

    @abstractmethod
    def _numeric(self, numeric: "scout_compute_api_NumericPlot") -> Any:
        pass

    @abstractmethod
    def _enum(self, enum: "scout_compute_api_EnumPlot") -> Any:
        pass

    @abstractmethod
    def _bucketed_numeric(self, bucketed_numeric: "scout_compute_api_BucketedNumericPlot") -> Any:
        pass

    @abstractmethod
    def _bucketed_enum(self, bucketed_enum: "scout_compute_api_BucketedEnumPlot") -> Any:
        pass

    @abstractmethod
    def _arrow_numeric(self, arrow_numeric: "scout_compute_api_ArrowNumericPlot") -> Any:
        pass

    @abstractmethod
    def _arrow_enum(self, arrow_enum: "scout_compute_api_ArrowEnumPlot") -> Any:
        pass

    @abstractmethod
    def _arrow_bucketed_numeric(self, arrow_bucketed_numeric: "scout_compute_api_ArrowBucketedNumericPlot") -> Any:
        pass

    @abstractmethod
    def _arrow_bucketed_enum(self, arrow_bucketed_enum: "scout_compute_api_ArrowBucketedEnumPlot") -> Any:
        pass

    @abstractmethod
    def _grouped(self, grouped: "persistent_compute_api_GroupedComputeNodeAppendResponses") -> Any:
        pass


persistent_compute_api_ComputeNodeAppendResponseVisitor.__name__ = "ComputeNodeAppendResponseVisitor"
persistent_compute_api_ComputeNodeAppendResponseVisitor.__qualname__ = "ComputeNodeAppendResponseVisitor"
persistent_compute_api_ComputeNodeAppendResponseVisitor.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_FullResult(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'result': ConjureFieldDefinition('result', scout_compute_api_ComputeNodeResponse)
        }

    __slots__: List[str] = ['_result']

    def __init__(self, result: "scout_compute_api_ComputeNodeResponse") -> None:
        self._result = result

    @builtins.property
    def result(self) -> "scout_compute_api_ComputeNodeResponse":
        return self._result


persistent_compute_api_FullResult.__name__ = "FullResult"
persistent_compute_api_FullResult.__qualname__ = "FullResult"
persistent_compute_api_FullResult.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_GroupedComputeNodeAppendResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'grouping': ConjureFieldDefinition('grouping', scout_compute_api_Grouping),
            'response': ConjureFieldDefinition('response', persistent_compute_api_ComputeNodeAppendResponse)
        }

    __slots__: List[str] = ['_grouping', '_response']

    def __init__(self, grouping: "scout_compute_api_Grouping", response: "persistent_compute_api_ComputeNodeAppendResponse") -> None:
        self._grouping = grouping
        self._response = response

    @builtins.property
    def grouping(self) -> "scout_compute_api_Grouping":
        return self._grouping

    @builtins.property
    def response(self) -> "persistent_compute_api_ComputeNodeAppendResponse":
        return self._response


persistent_compute_api_GroupedComputeNodeAppendResponse.__name__ = "GroupedComputeNodeAppendResponse"
persistent_compute_api_GroupedComputeNodeAppendResponse.__qualname__ = "GroupedComputeNodeAppendResponse"
persistent_compute_api_GroupedComputeNodeAppendResponse.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_GroupedComputeNodeAppendResponses(ConjureBeanType):
    """Contains a `GroupedComputeNodeAppendResponse` for each applicable grouping along with metadata describing the 
grouping. All the contained `GroupedComputeNodeAppendResponse`s are guaranteed to be of the same type.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'responses': ConjureFieldDefinition('responses', List[persistent_compute_api_GroupedComputeNodeAppendResponse])
        }

    __slots__: List[str] = ['_responses']

    def __init__(self, responses: List["persistent_compute_api_GroupedComputeNodeAppendResponse"]) -> None:
        self._responses = responses

    @builtins.property
    def responses(self) -> List["persistent_compute_api_GroupedComputeNodeAppendResponse"]:
        return self._responses


persistent_compute_api_GroupedComputeNodeAppendResponses.__name__ = "GroupedComputeNodeAppendResponses"
persistent_compute_api_GroupedComputeNodeAppendResponses.__qualname__ = "GroupedComputeNodeAppendResponses"
persistent_compute_api_GroupedComputeNodeAppendResponses.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_HealthMessage(ConjureUnionType):
    _ping: Optional["persistent_compute_api_Ping"] = None
    _pong: Optional["persistent_compute_api_Pong"] = None
    _shutdown_notice: Optional["persistent_compute_api_ShutdownNotice"] = None
    _client_message_error: Optional["persistent_compute_api_ClientMessageError"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'ping': ConjureFieldDefinition('ping', persistent_compute_api_Ping),
            'pong': ConjureFieldDefinition('pong', persistent_compute_api_Pong),
            'shutdown_notice': ConjureFieldDefinition('shutdownNotice', persistent_compute_api_ShutdownNotice),
            'client_message_error': ConjureFieldDefinition('clientMessageError', persistent_compute_api_ClientMessageError)
        }

    def __init__(
            self,
            ping: Optional["persistent_compute_api_Ping"] = None,
            pong: Optional["persistent_compute_api_Pong"] = None,
            shutdown_notice: Optional["persistent_compute_api_ShutdownNotice"] = None,
            client_message_error: Optional["persistent_compute_api_ClientMessageError"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (ping is not None) + (pong is not None) + (shutdown_notice is not None) + (client_message_error is not None) != 1:
                raise ValueError('a union must contain a single member')

            if ping is not None:
                self._ping = ping
                self._type = 'ping'
            if pong is not None:
                self._pong = pong
                self._type = 'pong'
            if shutdown_notice is not None:
                self._shutdown_notice = shutdown_notice
                self._type = 'shutdownNotice'
            if client_message_error is not None:
                self._client_message_error = client_message_error
                self._type = 'clientMessageError'

        elif type_of_union == 'ping':
            if ping is None:
                raise ValueError('a union value must not be None')
            self._ping = ping
            self._type = 'ping'
        elif type_of_union == 'pong':
            if pong is None:
                raise ValueError('a union value must not be None')
            self._pong = pong
            self._type = 'pong'
        elif type_of_union == 'shutdownNotice':
            if shutdown_notice is None:
                raise ValueError('a union value must not be None')
            self._shutdown_notice = shutdown_notice
            self._type = 'shutdownNotice'
        elif type_of_union == 'clientMessageError':
            if client_message_error is None:
                raise ValueError('a union value must not be None')
            self._client_message_error = client_message_error
            self._type = 'clientMessageError'

    @builtins.property
    def ping(self) -> Optional["persistent_compute_api_Ping"]:
        return self._ping

    @builtins.property
    def pong(self) -> Optional["persistent_compute_api_Pong"]:
        return self._pong

    @builtins.property
    def shutdown_notice(self) -> Optional["persistent_compute_api_ShutdownNotice"]:
        return self._shutdown_notice

    @builtins.property
    def client_message_error(self) -> Optional["persistent_compute_api_ClientMessageError"]:
        return self._client_message_error

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, persistent_compute_api_HealthMessageVisitor):
            raise ValueError('{} is not an instance of persistent_compute_api_HealthMessageVisitor'.format(visitor.__class__.__name__))
        if self._type == 'ping' and self.ping is not None:
            return visitor._ping(self.ping)
        if self._type == 'pong' and self.pong is not None:
            return visitor._pong(self.pong)
        if self._type == 'shutdownNotice' and self.shutdown_notice is not None:
            return visitor._shutdown_notice(self.shutdown_notice)
        if self._type == 'clientMessageError' and self.client_message_error is not None:
            return visitor._client_message_error(self.client_message_error)


persistent_compute_api_HealthMessage.__name__ = "HealthMessage"
persistent_compute_api_HealthMessage.__qualname__ = "HealthMessage"
persistent_compute_api_HealthMessage.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_HealthMessageVisitor:

    @abstractmethod
    def _ping(self, ping: "persistent_compute_api_Ping") -> Any:
        pass

    @abstractmethod
    def _pong(self, pong: "persistent_compute_api_Pong") -> Any:
        pass

    @abstractmethod
    def _shutdown_notice(self, shutdown_notice: "persistent_compute_api_ShutdownNotice") -> Any:
        pass

    @abstractmethod
    def _client_message_error(self, client_message_error: "persistent_compute_api_ClientMessageError") -> Any:
        pass


persistent_compute_api_HealthMessageVisitor.__name__ = "HealthMessageVisitor"
persistent_compute_api_HealthMessageVisitor.__qualname__ = "HealthMessageVisitor"
persistent_compute_api_HealthMessageVisitor.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_InvalidComputationType(ConjureEnumType):

    POINT_PERSISTENCE = 'POINT_PERSISTENCE'
    '''POINT_PERSISTENCE'''
    CUMULATIVE_SUM = 'CUMULATIVE_SUM'
    '''CUMULATIVE_SUM'''
    INTEGRAL = 'INTEGRAL'
    '''INTEGRAL'''
    STALENESS_DETECTION = 'STALENESS_DETECTION'
    '''STALENESS_DETECTION'''
    TIME_RANGE_FILTER = 'TIME_RANGE_FILTER'
    '''TIME_RANGE_FILTER'''
    FREQUENCY_DOMAIN = 'FREQUENCY_DOMAIN'
    '''FREQUENCY_DOMAIN'''
    CURVE_FITTING = 'CURVE_FITTING'
    '''CURVE_FITTING'''
    PAGE_SUMMARIZATION_STRATEGY = 'PAGE_SUMMARIZATION_STRATEGY'
    '''PAGE_SUMMARIZATION_STRATEGY'''
    TRUNCATE_SUMMARIZATION_STRATEGY = 'TRUNCATE_SUMMARIZATION_STRATEGY'
    '''TRUNCATE_SUMMARIZATION_STRATEGY'''
    LOG_SERIES = 'LOG_SERIES'
    '''LOG_SERIES'''
    LITERAL_RANGES = 'LITERAL_RANGES'
    '''LITERAL_RANGES'''
    ARRAY = 'ARRAY'
    '''ARRAY'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


persistent_compute_api_InvalidComputationType.__name__ = "InvalidComputationType"
persistent_compute_api_InvalidComputationType.__qualname__ = "InvalidComputationType"
persistent_compute_api_InvalidComputationType.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_IsEnabledResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



persistent_compute_api_IsEnabledResponse.__name__ = "IsEnabledResponse"
persistent_compute_api_IsEnabledResponse.__qualname__ = "IsEnabledResponse"
persistent_compute_api_IsEnabledResponse.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_PersistentComputeService(Service):
    """Exposes a simple endpoints for checking whether or not persistent compute is enabled.
    """

    def is_enabled(self, auth_header: str) -> "persistent_compute_api_IsEnabledResponse":
        """Simple "ping" like endpoint to see if the service is enabled (and available).
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = None

        _path = '/persistent-compute/enabled'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), persistent_compute_api_IsEnabledResponse, self._return_none_for_unknown_union_types)


persistent_compute_api_PersistentComputeService.__name__ = "PersistentComputeService"
persistent_compute_api_PersistentComputeService.__qualname__ = "PersistentComputeService"
persistent_compute_api_PersistentComputeService.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_Ping(ConjureBeanType):
    """A ping can be sent by both client and server to keep the connection open and check that it is still working.
The receiving end should send back a pong immediately.
We also include the times that pings and pongs are sent so that we can track latency and/or discover clock
drift between server and client.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'sent_at': ConjureFieldDefinition('sentAt', str)
        }

    __slots__: List[str] = ['_sent_at']

    def __init__(self, sent_at: str) -> None:
        self._sent_at = sent_at

    @builtins.property
    def sent_at(self) -> str:
        return self._sent_at


persistent_compute_api_Ping.__name__ = "Ping"
persistent_compute_api_Ping.__qualname__ = "Ping"
persistent_compute_api_Ping.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_Pong(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'ping_originally_sent_at': ConjureFieldDefinition('pingOriginallySentAt', str),
            'sent_at': ConjureFieldDefinition('sentAt', str)
        }

    __slots__: List[str] = ['_ping_originally_sent_at', '_sent_at']

    def __init__(self, ping_originally_sent_at: str, sent_at: str) -> None:
        self._ping_originally_sent_at = ping_originally_sent_at
        self._sent_at = sent_at

    @builtins.property
    def ping_originally_sent_at(self) -> str:
        return self._ping_originally_sent_at

    @builtins.property
    def sent_at(self) -> str:
        return self._sent_at


persistent_compute_api_Pong.__name__ = "Pong"
persistent_compute_api_Pong.__qualname__ = "Pong"
persistent_compute_api_Pong.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_ServerMessage(ConjureUnionType):
    _subscription_update: Optional["persistent_compute_api_SubscriptionUpdateMessage"] = None
    _subscription_creation: Optional["persistent_compute_api_SubscriptionCreationMessage"] = None
    _health: Optional["persistent_compute_api_HealthMessage"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'subscription_update': ConjureFieldDefinition('subscriptionUpdate', persistent_compute_api_SubscriptionUpdateMessage),
            'subscription_creation': ConjureFieldDefinition('subscriptionCreation', persistent_compute_api_SubscriptionCreationMessage),
            'health': ConjureFieldDefinition('health', persistent_compute_api_HealthMessage)
        }

    def __init__(
            self,
            subscription_update: Optional["persistent_compute_api_SubscriptionUpdateMessage"] = None,
            subscription_creation: Optional["persistent_compute_api_SubscriptionCreationMessage"] = None,
            health: Optional["persistent_compute_api_HealthMessage"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (subscription_update is not None) + (subscription_creation is not None) + (health is not None) != 1:
                raise ValueError('a union must contain a single member')

            if subscription_update is not None:
                self._subscription_update = subscription_update
                self._type = 'subscriptionUpdate'
            if subscription_creation is not None:
                self._subscription_creation = subscription_creation
                self._type = 'subscriptionCreation'
            if health is not None:
                self._health = health
                self._type = 'health'

        elif type_of_union == 'subscriptionUpdate':
            if subscription_update is None:
                raise ValueError('a union value must not be None')
            self._subscription_update = subscription_update
            self._type = 'subscriptionUpdate'
        elif type_of_union == 'subscriptionCreation':
            if subscription_creation is None:
                raise ValueError('a union value must not be None')
            self._subscription_creation = subscription_creation
            self._type = 'subscriptionCreation'
        elif type_of_union == 'health':
            if health is None:
                raise ValueError('a union value must not be None')
            self._health = health
            self._type = 'health'

    @builtins.property
    def subscription_update(self) -> Optional["persistent_compute_api_SubscriptionUpdateMessage"]:
        return self._subscription_update

    @builtins.property
    def subscription_creation(self) -> Optional["persistent_compute_api_SubscriptionCreationMessage"]:
        return self._subscription_creation

    @builtins.property
    def health(self) -> Optional["persistent_compute_api_HealthMessage"]:
        return self._health

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, persistent_compute_api_ServerMessageVisitor):
            raise ValueError('{} is not an instance of persistent_compute_api_ServerMessageVisitor'.format(visitor.__class__.__name__))
        if self._type == 'subscriptionUpdate' and self.subscription_update is not None:
            return visitor._subscription_update(self.subscription_update)
        if self._type == 'subscriptionCreation' and self.subscription_creation is not None:
            return visitor._subscription_creation(self.subscription_creation)
        if self._type == 'health' and self.health is not None:
            return visitor._health(self.health)


persistent_compute_api_ServerMessage.__name__ = "ServerMessage"
persistent_compute_api_ServerMessage.__qualname__ = "ServerMessage"
persistent_compute_api_ServerMessage.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_ServerMessageVisitor:

    @abstractmethod
    def _subscription_update(self, subscription_update: "persistent_compute_api_SubscriptionUpdateMessage") -> Any:
        pass

    @abstractmethod
    def _subscription_creation(self, subscription_creation: "persistent_compute_api_SubscriptionCreationMessage") -> Any:
        pass

    @abstractmethod
    def _health(self, health: "persistent_compute_api_HealthMessage") -> Any:
        pass


persistent_compute_api_ServerMessageVisitor.__name__ = "ServerMessageVisitor"
persistent_compute_api_ServerMessageVisitor.__qualname__ = "ServerMessageVisitor"
persistent_compute_api_ServerMessageVisitor.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_ShutdownNotice(ConjureBeanType):
    """Indicates that the websocket will shut down in the near future. Until it is, SubscriptionUpdates will 
still be sent to the client. Clients that want to avoid downtime or latency spikes should initiate a new 
websocket and recreate all their subscriptions there but still keep this websocket open until the new 
websockets starts sending SubscriptionUpdates. 
Note: The initial updates that the new websocket sends might be somewhat stale because of server and 
connection pools warm up. The client might want to wait with fully switching to the new subscription until 
the updates aren't very stale anymore.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



persistent_compute_api_ShutdownNotice.__name__ = "ShutdownNotice"
persistent_compute_api_ShutdownNotice.__qualname__ = "ShutdownNotice"
persistent_compute_api_ShutdownNotice.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_StreamingComputeNodeRequest(ConjureBeanType):
    """A templatized version of `ComputeNodeRequest` where the end of the range will track the current time and
the start of the range tracks `windowWidth` time ago.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'node': ConjureFieldDefinition('node', scout_compute_api_ComputableNode),
            'window_width': ConjureFieldDefinition('windowWidth', scout_run_api_Duration),
            'context': ConjureFieldDefinition('context', scout_compute_api_Context)
        }

    __slots__: List[str] = ['_node', '_window_width', '_context']

    def __init__(self, context: "scout_compute_api_Context", node: "scout_compute_api_ComputableNode", window_width: "scout_run_api_Duration") -> None:
        self._node = node
        self._window_width = window_width
        self._context = context

    @builtins.property
    def node(self) -> "scout_compute_api_ComputableNode":
        return self._node

    @builtins.property
    def window_width(self) -> "scout_run_api_Duration":
        return self._window_width

    @builtins.property
    def context(self) -> "scout_compute_api_Context":
        return self._context


persistent_compute_api_StreamingComputeNodeRequest.__name__ = "StreamingComputeNodeRequest"
persistent_compute_api_StreamingComputeNodeRequest.__qualname__ = "StreamingComputeNodeRequest"
persistent_compute_api_StreamingComputeNodeRequest.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_StreamingComputeNodeSubscription(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'compute_request': ConjureFieldDefinition('computeRequest', persistent_compute_api_StreamingComputeNodeRequest),
            'subscription_options': ConjureFieldDefinition('subscriptionOptions', persistent_compute_api_SubscriptionOptions)
        }

    __slots__: List[str] = ['_compute_request', '_subscription_options']

    def __init__(self, compute_request: "persistent_compute_api_StreamingComputeNodeRequest", subscription_options: "persistent_compute_api_SubscriptionOptions") -> None:
        self._compute_request = compute_request
        self._subscription_options = subscription_options

    @builtins.property
    def compute_request(self) -> "persistent_compute_api_StreamingComputeNodeRequest":
        return self._compute_request

    @builtins.property
    def subscription_options(self) -> "persistent_compute_api_SubscriptionOptions":
        return self._subscription_options


persistent_compute_api_StreamingComputeNodeSubscription.__name__ = "StreamingComputeNodeSubscription"
persistent_compute_api_StreamingComputeNodeSubscription.__qualname__ = "StreamingComputeNodeSubscription"
persistent_compute_api_StreamingComputeNodeSubscription.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_SubscriptionCreation(ConjureUnionType):
    _success: Optional["persistent_compute_api_SubscriptionCreationSuccess"] = None
    _error: Optional["persistent_compute_api_SubscriptionCreationError"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'success': ConjureFieldDefinition('success', persistent_compute_api_SubscriptionCreationSuccess),
            'error': ConjureFieldDefinition('error', persistent_compute_api_SubscriptionCreationError)
        }

    def __init__(
            self,
            success: Optional["persistent_compute_api_SubscriptionCreationSuccess"] = None,
            error: Optional["persistent_compute_api_SubscriptionCreationError"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (success is not None) + (error is not None) != 1:
                raise ValueError('a union must contain a single member')

            if success is not None:
                self._success = success
                self._type = 'success'
            if error is not None:
                self._error = error
                self._type = 'error'

        elif type_of_union == 'success':
            if success is None:
                raise ValueError('a union value must not be None')
            self._success = success
            self._type = 'success'
        elif type_of_union == 'error':
            if error is None:
                raise ValueError('a union value must not be None')
            self._error = error
            self._type = 'error'

    @builtins.property
    def success(self) -> Optional["persistent_compute_api_SubscriptionCreationSuccess"]:
        return self._success

    @builtins.property
    def error(self) -> Optional["persistent_compute_api_SubscriptionCreationError"]:
        return self._error

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, persistent_compute_api_SubscriptionCreationVisitor):
            raise ValueError('{} is not an instance of persistent_compute_api_SubscriptionCreationVisitor'.format(visitor.__class__.__name__))
        if self._type == 'success' and self.success is not None:
            return visitor._success(self.success)
        if self._type == 'error' and self.error is not None:
            return visitor._error(self.error)


persistent_compute_api_SubscriptionCreation.__name__ = "SubscriptionCreation"
persistent_compute_api_SubscriptionCreation.__qualname__ = "SubscriptionCreation"
persistent_compute_api_SubscriptionCreation.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_SubscriptionCreationVisitor:

    @abstractmethod
    def _success(self, success: "persistent_compute_api_SubscriptionCreationSuccess") -> Any:
        pass

    @abstractmethod
    def _error(self, error: "persistent_compute_api_SubscriptionCreationError") -> Any:
        pass


persistent_compute_api_SubscriptionCreationVisitor.__name__ = "SubscriptionCreationVisitor"
persistent_compute_api_SubscriptionCreationVisitor.__qualname__ = "SubscriptionCreationVisitor"
persistent_compute_api_SubscriptionCreationVisitor.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_SubscriptionCreationError(ConjureBeanType):
    """This will be sent if there is an error while creating a subscription. This means that the subscription was
never created and the client will have to re-try creating it if warranted.
This can also be sent after a subscription was first successfully started and sent result. In that case it
means that the subscription encountered an unrecoverable error at runtime and will be stopped.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'serializable_error': ConjureFieldDefinition('serializableError', api_SerializableError)
        }

    __slots__: List[str] = ['_serializable_error']

    def __init__(self, serializable_error: "api_SerializableError") -> None:
        self._serializable_error = serializable_error

    @builtins.property
    def serializable_error(self) -> "api_SerializableError":
        """A serialized version of the error. Should match the errors defined below.
        """
        return self._serializable_error


persistent_compute_api_SubscriptionCreationError.__name__ = "SubscriptionCreationError"
persistent_compute_api_SubscriptionCreationError.__qualname__ = "SubscriptionCreationError"
persistent_compute_api_SubscriptionCreationError.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_SubscriptionCreationMessage(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'subscription_id': ConjureFieldDefinition('subscriptionId', persistent_compute_api_SubscriptionId),
            'creation': ConjureFieldDefinition('creation', persistent_compute_api_SubscriptionCreation)
        }

    __slots__: List[str] = ['_subscription_id', '_creation']

    def __init__(self, creation: "persistent_compute_api_SubscriptionCreation", subscription_id: str) -> None:
        self._subscription_id = subscription_id
        self._creation = creation

    @builtins.property
    def subscription_id(self) -> str:
        return self._subscription_id

    @builtins.property
    def creation(self) -> "persistent_compute_api_SubscriptionCreation":
        return self._creation


persistent_compute_api_SubscriptionCreationMessage.__name__ = "SubscriptionCreationMessage"
persistent_compute_api_SubscriptionCreationMessage.__qualname__ = "SubscriptionCreationMessage"
persistent_compute_api_SubscriptionCreationMessage.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_SubscriptionCreationSuccess(ConjureBeanType):
    """Will be returned once a subscriptions has been successfully created.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'unit_result': ConjureFieldDefinition('unitResult', scout_compute_api_ComputeUnitResult)
        }

    __slots__: List[str] = ['_unit_result']

    def __init__(self, unit_result: "scout_compute_api_ComputeUnitResult") -> None:
        self._unit_result = unit_result

    @builtins.property
    def unit_result(self) -> "scout_compute_api_ComputeUnitResult":
        return self._unit_result


persistent_compute_api_SubscriptionCreationSuccess.__name__ = "SubscriptionCreationSuccess"
persistent_compute_api_SubscriptionCreationSuccess.__qualname__ = "SubscriptionCreationSuccess"
persistent_compute_api_SubscriptionCreationSuccess.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_SubscriptionOptions(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'min_delay': ConjureFieldDefinition('minDelay', persistent_compute_api_Milliseconds),
            'allow_appends': ConjureFieldDefinition('allowAppends', OptionalTypeWrapper[bool])
        }

    __slots__: List[str] = ['_min_delay', '_allow_appends']

    def __init__(self, min_delay: int, allow_appends: Optional[bool] = None) -> None:
        self._min_delay = min_delay
        self._allow_appends = allow_appends

    @builtins.property
    def min_delay(self) -> int:
        """The minimum delay between `SubscriptionUpdate`s sent for this subscription.
        """
        return self._min_delay

    @builtins.property
    def allow_appends(self) -> Optional[bool]:
        """Can be set to `false` by the client to indicate that it doesn't support appends for this subscription
and always wants to receive full results. Defaults to `false` if not set.
The expectation is that clients should implement support for appends for any of the results covered in
`ComputeNodeAppendResponse` and set this to `true` as quickly as possible. However, in order to support 
adding new sub-types to `ComputeNodeAppendResponse` without breaking clients that haven't upgraded yet 
and haven't yet added support for them, we default this to `false` and make clients opt-in as soon as they
implement support.
        """
        return self._allow_appends


persistent_compute_api_SubscriptionOptions.__name__ = "SubscriptionOptions"
persistent_compute_api_SubscriptionOptions.__qualname__ = "SubscriptionOptions"
persistent_compute_api_SubscriptionOptions.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_SubscriptionUpdate(ConjureUnionType):
    _full: Optional["persistent_compute_api_FullResult"] = None
    _append: Optional["persistent_compute_api_AppendResult"] = None
    _error: Optional["persistent_compute_api_SubscriptionUpdateError"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'full': ConjureFieldDefinition('full', persistent_compute_api_FullResult),
            'append': ConjureFieldDefinition('append', persistent_compute_api_AppendResult),
            'error': ConjureFieldDefinition('error', persistent_compute_api_SubscriptionUpdateError)
        }

    def __init__(
            self,
            full: Optional["persistent_compute_api_FullResult"] = None,
            append: Optional["persistent_compute_api_AppendResult"] = None,
            error: Optional["persistent_compute_api_SubscriptionUpdateError"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (full is not None) + (append is not None) + (error is not None) != 1:
                raise ValueError('a union must contain a single member')

            if full is not None:
                self._full = full
                self._type = 'full'
            if append is not None:
                self._append = append
                self._type = 'append'
            if error is not None:
                self._error = error
                self._type = 'error'

        elif type_of_union == 'full':
            if full is None:
                raise ValueError('a union value must not be None')
            self._full = full
            self._type = 'full'
        elif type_of_union == 'append':
            if append is None:
                raise ValueError('a union value must not be None')
            self._append = append
            self._type = 'append'
        elif type_of_union == 'error':
            if error is None:
                raise ValueError('a union value must not be None')
            self._error = error
            self._type = 'error'

    @builtins.property
    def full(self) -> Optional["persistent_compute_api_FullResult"]:
        return self._full

    @builtins.property
    def append(self) -> Optional["persistent_compute_api_AppendResult"]:
        return self._append

    @builtins.property
    def error(self) -> Optional["persistent_compute_api_SubscriptionUpdateError"]:
        return self._error

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, persistent_compute_api_SubscriptionUpdateVisitor):
            raise ValueError('{} is not an instance of persistent_compute_api_SubscriptionUpdateVisitor'.format(visitor.__class__.__name__))
        if self._type == 'full' and self.full is not None:
            return visitor._full(self.full)
        if self._type == 'append' and self.append is not None:
            return visitor._append(self.append)
        if self._type == 'error' and self.error is not None:
            return visitor._error(self.error)


persistent_compute_api_SubscriptionUpdate.__name__ = "SubscriptionUpdate"
persistent_compute_api_SubscriptionUpdate.__qualname__ = "SubscriptionUpdate"
persistent_compute_api_SubscriptionUpdate.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_SubscriptionUpdateVisitor:

    @abstractmethod
    def _full(self, full: "persistent_compute_api_FullResult") -> Any:
        pass

    @abstractmethod
    def _append(self, append: "persistent_compute_api_AppendResult") -> Any:
        pass

    @abstractmethod
    def _error(self, error: "persistent_compute_api_SubscriptionUpdateError") -> Any:
        pass


persistent_compute_api_SubscriptionUpdateVisitor.__name__ = "SubscriptionUpdateVisitor"
persistent_compute_api_SubscriptionUpdateVisitor.__qualname__ = "SubscriptionUpdateVisitor"
persistent_compute_api_SubscriptionUpdateVisitor.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_SubscriptionUpdateError(ConjureBeanType):
    """This will be sent if there is an error while updating a subscription. Note: This won't automatically cancel 
the subscription. The client will have to call `ClientMessage::unsubscribe` to do that if warranted.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'serializable_error': ConjureFieldDefinition('serializableError', api_SerializableError)
        }

    __slots__: List[str] = ['_serializable_error']

    def __init__(self, serializable_error: "api_SerializableError") -> None:
        self._serializable_error = serializable_error

    @builtins.property
    def serializable_error(self) -> "api_SerializableError":
        """A serialized version of the error. Should match the errors defined below.
        """
        return self._serializable_error


persistent_compute_api_SubscriptionUpdateError.__name__ = "SubscriptionUpdateError"
persistent_compute_api_SubscriptionUpdateError.__qualname__ = "SubscriptionUpdateError"
persistent_compute_api_SubscriptionUpdateError.__module__ = "nominal_api.persistent_compute_api"


class persistent_compute_api_SubscriptionUpdateMessage(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'subscription_id': ConjureFieldDefinition('subscriptionId', persistent_compute_api_SubscriptionId),
            'update': ConjureFieldDefinition('update', persistent_compute_api_SubscriptionUpdate)
        }

    __slots__: List[str] = ['_subscription_id', '_update']

    def __init__(self, subscription_id: str, update: "persistent_compute_api_SubscriptionUpdate") -> None:
        self._subscription_id = subscription_id
        self._update = update

    @builtins.property
    def subscription_id(self) -> str:
        return self._subscription_id

    @builtins.property
    def update(self) -> "persistent_compute_api_SubscriptionUpdate":
        return self._update


persistent_compute_api_SubscriptionUpdateMessage.__name__ = "SubscriptionUpdateMessage"
persistent_compute_api_SubscriptionUpdateMessage.__qualname__ = "SubscriptionUpdateMessage"
persistent_compute_api_SubscriptionUpdateMessage.__module__ = "nominal_api.persistent_compute_api"


class scout_InternalVersioningService(Service):
    """These endpoints are not intended to be used directly by clients, since
they require saving resource-specific state associated with new commits.
    """

    def init_resource_versioning(self, auth_header: str, request: "scout_versioning_api_InitResourceVersioningRequest", resource_rid: str) -> "scout_versioning_api_BranchAndCommit":
        """Creates a root commit (no parents) and a "main" branch 
pointing to that commit, for the given resource.
Throws if the resource already has a commit graph.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/internal/scout/v1/versioning/{resourceRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_versioning_api_BranchAndCommit, self._return_none_for_unknown_union_types)

    def save_working_state(self, auth_header: str, branch_name: str, request: "scout_versioning_api_SaveWorkingStateRequest", resource_rid: str) -> "scout_versioning_api_BranchAndCommit":
        """Creates a non-permanent commit on the given branch,
Throws if the branch doesn't exist.
Throws if latestCommit is passed and is not the latest commit.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
            'branchName': quote(str(_conjure_encoder.default(branch_name)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/internal/scout/v1/versioning/{resourceRid}/branch/{branchName}/working-state'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_versioning_api_BranchAndCommit, self._return_none_for_unknown_union_types)

    def commit(self, auth_header: str, branch_name: str, request: "scout_versioning_api_CommitRequest", resource_rid: str) -> "scout_versioning_api_BranchAndCommit":
        """Creates a new permanent commit on the given branch.
Throws if the branch doesn't exist.
Throws if latestCommit is passed and is not the latest commit.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
            'branchName': quote(str(_conjure_encoder.default(branch_name)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/internal/scout/v1/versioning/{resourceRid}/branch/{branchName}/commit'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_versioning_api_BranchAndCommit, self._return_none_for_unknown_union_types)

    def compact_commits(self, auth_header: str, request: "scout_versioning_api_CompactCommitsRequest", resource_rid: str) -> List[str]:
        """Compacts the commit graph for the resource by deleting
working state commits that match the provided strategy.
Persists commits that are pointed to by branches.
Returns the set of commits that were compacted.
Throws if the resource doesn't exist.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/internal/scout/v1/versioning/{resourceRid}/compact-commits'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_versioning_api_CommitId], self._return_none_for_unknown_union_types)


scout_InternalVersioningService.__name__ = "InternalVersioningService"
scout_InternalVersioningService.__qualname__ = "InternalVersioningService"
scout_InternalVersioningService.__module__ = "nominal_api.scout"


class scout_NotebookService(Service):
    """NotebookService manages workbooks (formerly known as notebooks).
    """

    def create(self, auth_header: str, request: "scout_notebook_api_CreateNotebookRequest") -> "scout_notebook_api_Notebook":
        """Creates a new workbook. The workbook will be associated with the provided run. If the run does not exist, 
a RunNotFound error will be thrown.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/notebook'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_notebook_api_Notebook, self._return_none_for_unknown_union_types)

    def update(self, auth_header: str, request: "scout_notebook_api_UpdateNotebookRequest", rid: str) -> "scout_notebook_api_Notebook":
        """Updates the contents of a workbook.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/notebook/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_notebook_api_Notebook, self._return_none_for_unknown_union_types)

    def get(self, auth_header: str, rid: str) -> "scout_notebook_api_Notebook":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v2/notebook/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_notebook_api_Notebook, self._return_none_for_unknown_union_types)

    def batch_get(self, auth_header: str, rids: List[str] = None) -> List["scout_notebook_api_Notebook"]:
        rids = rids if rids is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(rids)

        _path = '/scout/v2/notebook/batch-get'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_notebook_api_Notebook], self._return_none_for_unknown_union_types)

    def batch_get_metadata(self, auth_header: str, rids: List[str] = None) -> List["scout_notebook_api_NotebookMetadataWithRid"]:
        rids = rids if rids is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(rids)

        _path = '/scout/v2/notebook/batch-get-metadata'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_notebook_api_NotebookMetadataWithRid], self._return_none_for_unknown_union_types)

    def update_metadata(self, auth_header: str, request: "scout_notebook_api_UpdateNotebookMetadataRequest", rid: str) -> "scout_notebook_api_NotebookMetadata":
        """Updates metadata about a workbook, but not its contents.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/notebook/{rid}/update-metadata'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_notebook_api_NotebookMetadata, self._return_none_for_unknown_union_types)

    def get_used_ref_names(self, auth_header: str, rid: str) -> List[str]:
        """Returns the set of all ref names used by the workbook.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v2/notebook/{rid}/ref-names'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_api_DataSourceRefName], self._return_none_for_unknown_union_types)

    def update_ref_names(self, auth_header: str, request: "scout_notebook_api_UpdateRefNameRequest", rid: str) -> "scout_notebook_api_Notebook":
        """Updates the data source ref names for all variables used in the workbook.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/notebook/{rid}/update-ref-names'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_notebook_api_Notebook, self._return_none_for_unknown_union_types)

    def get_all_labels_and_properties(self, auth_header: str, workspaces: List[str] = None) -> "scout_notebook_api_GetAllLabelsAndPropertiesResponse":
        """Returns all properties (key value pairs) and labels that have been previously used on workbook. These can
be used to organize workbooks.
        """
        workspaces = workspaces if workspaces is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'workspaces': _conjure_encoder.default(workspaces),
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = None

        _path = '/scout/v2/notebook/get-all-labels-properties'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_notebook_api_GetAllLabelsAndPropertiesResponse, self._return_none_for_unknown_union_types)

    def search(self, auth_header: str, request: "scout_notebook_api_SearchNotebooksRequest") -> "scout_notebook_api_SearchNotebooksResponse":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v2/notebook/search'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_notebook_api_SearchNotebooksResponse, self._return_none_for_unknown_union_types)

    def lock(self, auth_header: str, rid: str) -> None:
        """Makes a workbook uneditable.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v2/notebook/{rid}/lock'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def unlock(self, auth_header: str, rid: str) -> None:
        """Unlocks a workbook for editing.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v2/notebook/{rid}/unlock'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def archive(self, auth_header: str, rid: str) -> None:
        """Archives a workbook, which excludes it from search and hides it from being publicly visible, but does not
permanently delete it. Archived workbooks can be unarchived.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v2/notebook/{rid}/archive'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def unarchive(self, auth_header: str, rid: str) -> None:
        """Makes a previously archived workbook searchable.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v2/notebook/{rid}/unarchive'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def delete(self, auth_header: str, rid: str) -> None:
        """The workbook will be deleted and is not recoverable. For soft deletion, use archive.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v2/notebook/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'DELETE',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return


scout_NotebookService.__name__ = "NotebookService"
scout_NotebookService.__qualname__ = "NotebookService"
scout_NotebookService.__module__ = "nominal_api.scout"


class scout_RunService(Service):
    """Runs are collections of channels and metadata from one or more data sources, synchronized over a 
range of real time, which represents a test event or simulation. These API endpoints let you
manage runs in the Nominal app.
    """

    def create_run(self, auth_header: str, details: "scout_run_api_CreateRunRequest") -> "scout_run_api_Run":
        """Create a new run in Nominal.

Throws if start is equal to or after end.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(details)

        _path = '/scout/v1/run'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_run_api_Run, self._return_none_for_unknown_union_types)

    def update_run(self, auth_header: str, details: "scout_run_api_UpdateRunRequest", rid: str) -> "scout_run_api_Run":
        """Updates an existing run based on its RID.

Throws if start is equal to or after end.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(details)

        _path = '/scout/v1/run/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_run_api_Run, self._return_none_for_unknown_union_types)

    def add_data_sources_to_run(self, auth_header: str, request: Dict[str, "scout_run_api_CreateRunDataSource"], run_rid: str) -> "scout_run_api_Run":
        """Adds datasources to the run in question.

Throws if any of the ref names conflict with existing data sources or each other.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'runRid': quote(str(_conjure_encoder.default(run_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/run/{runRid}/data-sources'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_run_api_Run, self._return_none_for_unknown_union_types)

    def create_or_update_run(self, auth_header: str, details: "scout_run_api_CreateOrUpdateRunRequest") -> "scout_run_api_Run":
        """Updates a run if it exists, otherwise it's created from scratch.
Will throw if the workspace of an existing run is different from the workspace of the request.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(details)

        _path = '/scout/v1/run/create-or-update'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_run_api_Run, self._return_none_for_unknown_union_types)

    def get_run(self, auth_header: str, rid: str) -> "scout_run_api_Run":
        """Fetches details about the run in question based on its RID.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/run/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_run_api_Run, self._return_none_for_unknown_union_types)

    def get_run_with_data_review_metrics(self, auth_header: str, rid: str) -> "scout_run_api_RunWithDataReviewMetrics":
        """Fetches details about the run in question based on its RID, 
including metrics for check and violation review status.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/run/{rid}/with-data-review-metrics'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_run_api_RunWithDataReviewMetrics, self._return_none_for_unknown_union_types)

    def get_run_with_data_review_summary(self, auth_header: str, rid: str) -> "scout_run_api_RunWithDataReviewSummary":
        """Fetches details about the run in question based on its RID, including a summary of the data review status.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/run/{rid}/with-data-review-summary'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_run_api_RunWithDataReviewSummary, self._return_none_for_unknown_union_types)

    def get_run_by_id(self, auth_header: str, get_run_by_id_request: "scout_run_api_GetRunByIdRequest") -> "scout_run_api_Run":
        """Fetches a run based on the run number, rather than RID.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(get_run_by_id_request)

        _path = '/scout/v1/run/by-id'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_run_api_Run, self._return_none_for_unknown_union_types)

    def get_runs(self, auth_header: str, rids: List[str] = None) -> Dict[str, "scout_run_api_Run"]:
        """Fetches a list of run details based on a list of RIDs.
        """
        rids = rids if rids is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(rids)

        _path = '/scout/v1/run/multiple'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), Dict[scout_run_api_RunRid, scout_run_api_Run], self._return_none_for_unknown_union_types)

    def get_runs_by_asset(self, auth_header: str, request: "scout_run_api_GetRunsByAssetRequest") -> "scout_run_api_GetRunsByAssetResponse":
        """Fetches the runs with the given asset.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/run/by-asset'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_run_api_GetRunsByAssetResponse, self._return_none_for_unknown_union_types)

    def get_latest_run_for_assets(self, auth_header: str, request: List[str] = None) -> Dict[str, "scout_run_api_Run"]:
        """Fetches the latest run for each requested asset.
Assets without associated runs will not be included in response.
        """
        request = request if request is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/run/by-assets/latest'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), Dict[scout_rids_api_AssetRid, scout_run_api_Run], self._return_none_for_unknown_union_types)

    def get_all_runs_properties_and_labels(self, auth_header: str, workspaces: List[str] = None) -> "scout_run_api_AllRunsPropertiesAndLabelsResponse":
        workspaces = workspaces if workspaces is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'workspaces': _conjure_encoder.default(workspaces),
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = None

        _path = '/scout/v1/all-runs-properties-labels'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_run_api_AllRunsPropertiesAndLabelsResponse, self._return_none_for_unknown_union_types)

    def search_runs(self, auth_header: str, request: "scout_run_api_SearchRunsRequest") -> "scout_run_api_SearchRunsResponse":
        """Searches for runs that match the given filters. Defaults to returning un-archived runs, absent an archive
filter.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/search-runs'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_run_api_SearchRunsResponse, self._return_none_for_unknown_union_types)

    def search_runs_with_data_review_metrics(self, auth_header: str, request: "scout_run_api_SearchRunsRequest") -> "scout_run_api_SearchRunsWithDataReviewMetricsResponse":
        """Searches for runs that match the given filters and 
includes metrics for check and violation review status. Defaults to returning un-archived runs, absent an 
archive filter.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/search-runs-with-data-review-metrics'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_run_api_SearchRunsWithDataReviewMetricsResponse, self._return_none_for_unknown_union_types)

    def search_runs_with_data_review_summary(self, auth_header: str, request: "scout_run_api_SearchRunsRequest") -> "scout_run_api_SearchRunsWithDataReviewSummaryResponse":
        """Searches for runs that match the given filters and includes a summary of the data review status. Defaults to 
returning un-archived runs, absent an archive filter.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/search-runs-with-data-review-summary'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_run_api_SearchRunsWithDataReviewSummaryResponse, self._return_none_for_unknown_union_types)

    def archive_run(self, auth_header: str, rid: str, include_linked_workbooks: Optional[bool] = None) -> bool:
        """Soft-deletes a run. Runs still exist in the database but are no longer visible.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'includeLinkedWorkbooks': _conjure_encoder.default(include_linked_workbooks),
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/archive-run/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), bool, self._return_none_for_unknown_union_types)

    def unarchive_run(self, auth_header: str, rid: str, include_linked_workbooks: Optional[bool] = None) -> bool:
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'includeLinkedWorkbooks': _conjure_encoder.default(include_linked_workbooks),
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/unarchive-run/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), bool, self._return_none_for_unknown_union_types)

    def archive_runs(self, auth_header: str, request: "scout_run_api_ArchiveRunsRequest") -> None:
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/archive-run'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def unarchive_runs(self, auth_header: str, request: "scout_run_api_UnarchiveRunsRequest") -> None:
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/unarchive-run'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def get_data_source_ref_name_and_type_list(self, auth_header: str, workspaces: List[str] = None) -> List["scout_run_api_RefNameAndType"]:
        """Returns the list of ref names that are in use across specified and authorized workspaces.
        """
        workspaces = workspaces if workspaces is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'workspaces': _conjure_encoder.default(workspaces),
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = None

        _path = '/scout/v1/data-source-ref-names-and-types'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_run_api_RefNameAndType], self._return_none_for_unknown_union_types)

    def search_channels(self, auth_header: str, request: "scout_run_api_SearchRunChannelsRequest", rid: str) -> "scout_run_api_SearchRunChannelsResponse":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/run/{rid}/search-channels'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_run_api_SearchRunChannelsResponse, self._return_none_for_unknown_union_types)

    def update_run_attachment(self, auth_header: str, request: "scout_run_api_UpdateAttachmentsRequest", rid: str) -> None:
        """Updates the attachments associated with a run.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/run/{rid}/attachments'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return


scout_RunService.__name__ = "RunService"
scout_RunService.__qualname__ = "RunService"
scout_RunService.__module__ = "nominal_api.scout"


class scout_TemplateService(Service):
    """TemplateService manages templates, which are workbooks that
can be re-used across runs. Templates are versioned.
    """

    def create(self, auth_header: str, request: "scout_template_api_CreateTemplateRequest") -> "scout_template_api_Template":
        """Creates a new template.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/template'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_template_api_Template, self._return_none_for_unknown_union_types)

    def get(self, auth_header: str, template_rid: str, branch: Optional[str] = None, commit: Optional[str] = None) -> "scout_template_api_Template":
        """Must only pass one of (branch, commit). If neither are passed,
the latest commit on the "main" branch is returned.
Throws if the template, branch, or commit doesn't exist.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'branch': _conjure_encoder.default(branch),
            'commit': _conjure_encoder.default(commit),
        }

        _path_params: Dict[str, str] = {
            'templateRid': quote(str(_conjure_encoder.default(template_rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/template/{templateRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_template_api_Template, self._return_none_for_unknown_union_types)

    def batch_get_metadata(self, auth_header: str, rids: List[str] = None) -> List["scout_template_api_TemplateSummary"]:
        rids = rids if rids is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(rids)

        _path = '/scout/v1/template/batch-get-metadata'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_template_api_TemplateSummary], self._return_none_for_unknown_union_types)

    def save_working_state(self, auth_header: str, request: "scout_template_api_SaveTemplateRequest", template_rid: str, branch: Optional[str] = None) -> "scout_template_api_Template":
        """Creates a commit that may be compacted, e.g cleaned up and not exist anymore.
Throws if the template or branch doesn't exist.
Throws if the latest commit doesn't match the provided id.
Throws if you save to an archived template.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'branch': _conjure_encoder.default(branch),
        }

        _path_params: Dict[str, str] = {
            'templateRid': quote(str(_conjure_encoder.default(template_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/template/{templateRid}/save-working-state'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_template_api_Template, self._return_none_for_unknown_union_types)

    def get_used_ref_names(self, auth_header: str, template_rid: str, branch: Optional[str] = None, commit: Optional[str] = None) -> List[str]:
        """Returns the set of all ref names used by the template.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'branch': _conjure_encoder.default(branch),
            'commit': _conjure_encoder.default(commit),
        }

        _path_params: Dict[str, str] = {
            'templateRid': quote(str(_conjure_encoder.default(template_rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/template/{templateRid}/ref-names'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_api_DataSourceRefName], self._return_none_for_unknown_union_types)

    def update_ref_names(self, auth_header: str, request: "scout_template_api_UpdateRefNameRequest", template_rid: str, branch: Optional[str] = None) -> "scout_template_api_Template":
        """Updates the data source ref names for all variables used in the template.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'branch': _conjure_encoder.default(branch),
        }

        _path_params: Dict[str, str] = {
            'templateRid': quote(str(_conjure_encoder.default(template_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/template/{templateRid}/update-ref-names'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_template_api_Template, self._return_none_for_unknown_union_types)

    def commit(self, auth_header: str, request: "scout_template_api_CommitTemplateRequest", template_rid: str, branch: Optional[str] = None) -> "scout_template_api_Template":
        """Creates a commit with a commit message. 
Throws if the template or branch doesn't exist.
Throws if the latest commit doesn't match the provided id.
Throws if you commit to an archived template.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'branch': _conjure_encoder.default(branch),
        }

        _path_params: Dict[str, str] = {
            'templateRid': quote(str(_conjure_encoder.default(template_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/template/{templateRid}/commit'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_template_api_Template, self._return_none_for_unknown_union_types)

    def update_metadata(self, auth_header: str, request: "scout_template_api_UpdateMetadataRequest", template_rid: str) -> "scout_template_api_TemplateMetadata":
        """Throws if the template doesn't exist.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'templateRid': quote(str(_conjure_encoder.default(template_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/template/{templateRid}/metadata'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_template_api_TemplateMetadata, self._return_none_for_unknown_union_types)

    def search_templates(self, auth_header: str, request: "scout_template_api_SearchTemplatesRequest") -> "scout_template_api_SearchTemplatesResponse":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/template/search'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_template_api_SearchTemplatesResponse, self._return_none_for_unknown_union_types)

    def get_all_labels_and_properties(self, auth_header: str, workspaces: List[str] = None) -> "scout_template_api_GetAllLabelsAndPropertiesResponse":
        workspaces = workspaces if workspaces is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'workspaces': _conjure_encoder.default(workspaces),
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = None

        _path = '/scout/v1/template/get-all-labels-properties'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_template_api_GetAllLabelsAndPropertiesResponse, self._return_none_for_unknown_union_types)

    def merge_to_main(self, auth_header: str, request: "scout_template_api_MergeToMainRequest", template_rid: str) -> "scout_template_api_Template":
        """Merges the given branch to the "main" branch.
Throws if the template or branch doesn't exist.
Throws if the latest commit doesn't match the provided id.
Throws if you merge on an archived template.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'templateRid': quote(str(_conjure_encoder.default(template_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/template/{templateRid}/merge-to-main'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_template_api_Template, self._return_none_for_unknown_union_types)


scout_TemplateService.__name__ = "TemplateService"
scout_TemplateService.__qualname__ = "TemplateService"
scout_TemplateService.__module__ = "nominal_api.scout"


class scout_UnitsService(Service):
    """The Units Service serves as a comprehensive catalog of the units of measurement supported by scout. Units, by 
default, follow the UCUM convention for representation.
    """

    def get_all_units(self, auth_header: str) -> "scout_units_api_GetUnitsResponse":
        """Returns all known units, grouped by the physical property they measure.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = None

        _path = '/units/v1/units'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_units_api_GetUnitsResponse, self._return_none_for_unknown_union_types)

    def get_unit(self, auth_header: str, unit: str) -> Optional["scout_units_api_Unit"]:
        """Returns information for a unit symbol if available. Returns as empty if the provided symbol cannot be parsed.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(unit)

        _path = '/units/v1/units/get-unit'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return None if _response.status_code == 204 else _decoder.decode(_response.json(), OptionalTypeWrapper[scout_units_api_Unit], self._return_none_for_unknown_union_types)

    def get_batch_units(self, auth_header: str, units: List[str] = None) -> Dict[str, "scout_units_api_Unit"]:
        """Returns information for the unit symbols if available. If the provided symbol cannot be parsed, it will be 
omitted from the map.
        """
        units = units if units is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(units)

        _path = '/units/v1/units/get-batch-units'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), Dict[scout_units_api_UnitSymbol, scout_units_api_Unit], self._return_none_for_unknown_union_types)

    def get_commensurable_units(self, auth_header: str, unit: str) -> List["scout_units_api_Unit"]:
        """Returns the set of cataloged units that can be converted to and from the given unit.
No commensurable units does not imply the unit is invalid. Use /get-unit to check for validity.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(unit)

        _path = '/units/v1/units/commensurable-units'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_units_api_Unit], self._return_none_for_unknown_union_types)


scout_UnitsService.__name__ = "UnitsService"
scout_UnitsService.__qualname__ = "UnitsService"
scout_UnitsService.__module__ = "nominal_api.scout"


class scout_VersioningService(Service):
    """This is the external-facing portion of VersioningService which
gives clients access to functionality that doesn't create new
commits. The creation of new commits should be done via the
resource-specific services.
    """

    def create_branch(self, auth_header: str, request: "scout_versioning_api_CreateBranchRequest", resource_rid: str) -> "scout_versioning_api_Branch":
        """Creates a mutable pointer to the provided commit.
"Saves"/"commits" can be performed on this pointer.
Throws if the name is already used as a commit
pointer for this resource.
Throws if the provided commit doesn't exist.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/versioning/{resourceRid}/branch'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_versioning_api_Branch, self._return_none_for_unknown_union_types)

    def create_tag(self, auth_header: str, request: "scout_versioning_api_CreateTagRequest", resource_rid: str) -> "scout_versioning_api_Tag":
        """Creates an immutable pointer to the provided commit.
Throws if the name is already used as a commit
pointer for this resource.
Throws if the provided commit doesn't exist.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/versioning/{resourceRid}/tag'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_versioning_api_Tag, self._return_none_for_unknown_union_types)

    def get_commit(self, auth_header: str, commit_id: str, resource_rid: str) -> "scout_versioning_api_Commit":
        """Throws if the commit doesn't exist.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
            'commitId': quote(str(_conjure_encoder.default(commit_id)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/versioning/{resourceRid}/commit/{commitId}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_versioning_api_Commit, self._return_none_for_unknown_union_types)

    def batch_get_commits(self, auth_header: str, resource_and_commit_ids: List["scout_versioning_api_ResourceAndCommitId"] = None) -> List["scout_versioning_api_Commit"]:
        """Filters out resources that are not authorized.
        """
        resource_and_commit_ids = resource_and_commit_ids if resource_and_commit_ids is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(resource_and_commit_ids)

        _path = '/scout/v1/versioning/commit/batch-get'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_versioning_api_Commit], self._return_none_for_unknown_union_types)

    def get_commit_by_branch(self, auth_header: str, branch_name: str, resource_rid: str) -> "scout_versioning_api_Commit":
        """Returns the commit pointed to by the branch.
Throws if the branch doesn't exist.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
            'branchName': quote(str(_conjure_encoder.default(branch_name)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/versioning/{resourceRid}/branch/{branchName}/commit'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_versioning_api_Commit, self._return_none_for_unknown_union_types)

    def get_commit_by_tag(self, auth_header: str, resource_rid: str, tag_name: str) -> "scout_versioning_api_Commit":
        """Returns the commit pointed to by the tag.
Throws if the tag doesn't exist.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
            'tagName': quote(str(_conjure_encoder.default(tag_name)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/versioning/{resourceRid}/tag/{tagName}/commit'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_versioning_api_Commit, self._return_none_for_unknown_union_types)

    def get_least_common_ancestor(self, auth_header: str, request: "scout_versioning_api_GetLeastCommonAncestorRequest", resource_rid: str) -> str:
        """Returns the least common ancestor of the two commits.
Throws if either commit doesn't exist.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/versioning/{resourceRid}/commit/least-common-ancestor'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_versioning_api_CommitId, self._return_none_for_unknown_union_types)

    def get_commit_history(self, auth_header: str, commit_id: str, resource_rid: str, next_page_token: Optional[str] = None, page_size: Optional[int] = None) -> "scout_versioning_api_CommitHistory":
        """Returns the commit history sorted by creation time descending.
Excludes working state commits.
Throws if the commit doesn't exist.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'pageSize': _conjure_encoder.default(page_size),
            'nextPageToken': _conjure_encoder.default(next_page_token),
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
            'commitId': quote(str(_conjure_encoder.default(commit_id)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/versioning/{resourceRid}/commit/{commitId}/history'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_versioning_api_CommitHistory, self._return_none_for_unknown_union_types)

    def persist_commits(self, auth_header: str, request: List["scout_versioning_api_ResourceAndCommitId"] = None) -> None:
        """Persists the commits so that they are not compacted.
This operation is atomic - either all commits are persisted
or none are (in the case of an error).
        """
        request = request if request is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/versioning/commit/persist'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def get_branch(self, auth_header: str, branch_name: str, resource_rid: str) -> "scout_versioning_api_Branch":
        """Throws if the branch doesn't exist.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
            'branchName': quote(str(_conjure_encoder.default(branch_name)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/versioning/{resourceRid}/branch/{branchName}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_versioning_api_Branch, self._return_none_for_unknown_union_types)

    def get_branches(self, auth_header: str, resource_rid: str) -> List["scout_versioning_api_Branch"]:
        """Returns all branches for the resource in order of
most recently updated.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/versioning/{resourceRid}/branch'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_versioning_api_Branch], self._return_none_for_unknown_union_types)

    def batch_get_branches(self, auth_header: str, resource_and_branches: List["scout_versioning_api_ResourceAndBranchName"] = None) -> List["scout_versioning_api_Branch"]:
        """Omits branches that are not authorized.
        """
        resource_and_branches = resource_and_branches if resource_and_branches is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(resource_and_branches)

        _path = '/scout/v1/versioning/branch/batch-get'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_versioning_api_Branch], self._return_none_for_unknown_union_types)

    def get_tag(self, auth_header: str, resource_rid: str, tag_name: str) -> "scout_versioning_api_Tag":
        """Throws if the tag doesn't exist.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
            'tagName': quote(str(_conjure_encoder.default(tag_name)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/versioning/{resourceRid}/tag/{tagName}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_versioning_api_Tag, self._return_none_for_unknown_union_types)

    def batch_get_tags(self, auth_header: str, resource_and_commits: List["scout_versioning_api_ResourceAndCommitId"] = None) -> List["scout_versioning_api_Tag"]:
        """Omits tags that are not authorized.
        """
        resource_and_commits = resource_and_commits if resource_and_commits is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(resource_and_commits)

        _path = '/scout/v1/versioning/tag/batch-get'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_versioning_api_Tag], self._return_none_for_unknown_union_types)

    def get_tags_by_resource(self, auth_header: str, resource_rid: str) -> List["scout_versioning_api_Tag"]:
        """Returns all tags for the resource in order of
most recently created.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/versioning/{resourceRid}/tag'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_versioning_api_Tag], self._return_none_for_unknown_union_types)

    def delete_branch(self, auth_header: str, branch_name: str, resource_rid: str) -> None:
        """Deletes the branch pointer.
Throws if the branch doesn't exist.
Throws if you attempt to delete the "main" branch.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
            'branchName': quote(str(_conjure_encoder.default(branch_name)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/versioning/{resourceRid}/branch/{branchName}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'DELETE',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def delete_branches(self, auth_header: str, resource_and_branches: List["scout_versioning_api_ResourceAndBranchName"] = None) -> None:
        """Deletes the branch pointers.
Throws if any resource or branch is non-existent
or unauthorized.
Throws if any attempt is made to delete "main".
        """
        resource_and_branches = resource_and_branches if resource_and_branches is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(resource_and_branches)

        _path = '/scout/v1/versioning/branch/batch-delete'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def delete_tag(self, auth_header: str, resource_rid: str, tag_name: str) -> None:
        """Deletes the tag pointer.
Throws if the tag doesn't exist.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'resourceRid': quote(str(_conjure_encoder.default(resource_rid)), safe=''),
            'tagName': quote(str(_conjure_encoder.default(tag_name)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/versioning/{resourceRid}/tag/{tagName}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'DELETE',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return


scout_VersioningService.__name__ = "VersioningService"
scout_VersioningService.__qualname__ = "VersioningService"
scout_VersioningService.__module__ = "nominal_api.scout"


class scout_api_ChannelLocator(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'data_source_ref': ConjureFieldDefinition('dataSourceRef', scout_api_DataSourceRefName),
            'channel': ConjureFieldDefinition('channel', api_Channel),
            'tags': ConjureFieldDefinition('tags', Dict[api_TagName, api_TagValue]),
            'asset': ConjureFieldDefinition('asset', OptionalTypeWrapper[scout_rids_api_AssetRefName]),
            'run': ConjureFieldDefinition('run', OptionalTypeWrapper[scout_rids_api_RunRefName])
        }

    __slots__: List[str] = ['_data_source_ref', '_channel', '_tags', '_asset', '_run']

    def __init__(self, channel: str, data_source_ref: str, tags: Dict[str, str], asset: Optional[str] = None, run: Optional[str] = None) -> None:
        self._data_source_ref = data_source_ref
        self._channel = channel
        self._tags = tags
        self._asset = asset
        self._run = run

    @builtins.property
    def data_source_ref(self) -> str:
        return self._data_source_ref

    @builtins.property
    def channel(self) -> str:
        return self._channel

    @builtins.property
    def tags(self) -> Dict[str, str]:
        return self._tags

    @builtins.property
    def asset(self) -> Optional[str]:
        return self._asset

    @builtins.property
    def run(self) -> Optional[str]:
        return self._run


scout_api_ChannelLocator.__name__ = "ChannelLocator"
scout_api_ChannelLocator.__qualname__ = "ChannelLocator"
scout_api_ChannelLocator.__module__ = "nominal_api.scout_api"


class scout_api_ClosedWithFurtherActionDispositionState(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'closed_by': ConjureFieldDefinition('closedBy', scout_rids_api_UserRid)
        }

    __slots__: List[str] = ['_closed_by']

    def __init__(self, closed_by: str) -> None:
        self._closed_by = closed_by

    @builtins.property
    def closed_by(self) -> str:
        return self._closed_by


scout_api_ClosedWithFurtherActionDispositionState.__name__ = "ClosedWithFurtherActionDispositionState"
scout_api_ClosedWithFurtherActionDispositionState.__qualname__ = "ClosedWithFurtherActionDispositionState"
scout_api_ClosedWithFurtherActionDispositionState.__module__ = "nominal_api.scout_api"


class scout_api_ClosedWithIgnoreDispositionState(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'closed_by': ConjureFieldDefinition('closedBy', scout_rids_api_UserRid)
        }

    __slots__: List[str] = ['_closed_by']

    def __init__(self, closed_by: str) -> None:
        self._closed_by = closed_by

    @builtins.property
    def closed_by(self) -> str:
        return self._closed_by


scout_api_ClosedWithIgnoreDispositionState.__name__ = "ClosedWithIgnoreDispositionState"
scout_api_ClosedWithIgnoreDispositionState.__qualname__ = "ClosedWithIgnoreDispositionState"
scout_api_ClosedWithIgnoreDispositionState.__module__ = "nominal_api.scout_api"


class scout_api_Color(ConjureUnionType):
    _hex_code: Optional[str] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'hex_code': ConjureFieldDefinition('hexCode', str)
        }

    def __init__(
            self,
            hex_code: Optional[str] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (hex_code is not None) != 1:
                raise ValueError('a union must contain a single member')

            if hex_code is not None:
                self._hex_code = hex_code
                self._type = 'hexCode'

        elif type_of_union == 'hexCode':
            if hex_code is None:
                raise ValueError('a union value must not be None')
            self._hex_code = hex_code
            self._type = 'hexCode'

    @builtins.property
    def hex_code(self) -> Optional[str]:
        return self._hex_code

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, scout_api_ColorVisitor):
            raise ValueError('{} is not an instance of scout_api_ColorVisitor'.format(visitor.__class__.__name__))
        if self._type == 'hexCode' and self.hex_code is not None:
            return visitor._hex_code(self.hex_code)


scout_api_Color.__name__ = "Color"
scout_api_Color.__qualname__ = "Color"
scout_api_Color.__module__ = "nominal_api.scout_api"


class scout_api_ColorVisitor:

    @abstractmethod
    def _hex_code(self, hex_code: str) -> Any:
        pass


scout_api_ColorVisitor.__name__ = "ColorVisitor"
scout_api_ColorVisitor.__qualname__ = "ColorVisitor"
scout_api_ColorVisitor.__module__ = "nominal_api.scout_api"


class scout_api_DispositionState(ConjureUnionType):
    _pending_review: Optional["scout_api_PendingReviewDispositionState"] = None
    _closed_with_further_action: Optional["scout_api_ClosedWithFurtherActionDispositionState"] = None
    _closed_with_ignore: Optional["scout_api_ClosedWithIgnoreDispositionState"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'pending_review': ConjureFieldDefinition('pendingReview', scout_api_PendingReviewDispositionState),
            'closed_with_further_action': ConjureFieldDefinition('closedWithFurtherAction', scout_api_ClosedWithFurtherActionDispositionState),
            'closed_with_ignore': ConjureFieldDefinition('closedWithIgnore', scout_api_ClosedWithIgnoreDispositionState)
        }

    def __init__(
            self,
            pending_review: Optional["scout_api_PendingReviewDispositionState"] = None,
            closed_with_further_action: Optional["scout_api_ClosedWithFurtherActionDispositionState"] = None,
            closed_with_ignore: Optional["scout_api_ClosedWithIgnoreDispositionState"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (pending_review is not None) + (closed_with_further_action is not None) + (closed_with_ignore is not None) != 1:
                raise ValueError('a union must contain a single member')

            if pending_review is not None:
                self._pending_review = pending_review
                self._type = 'pendingReview'
            if closed_with_further_action is not None:
                self._closed_with_further_action = closed_with_further_action
                self._type = 'closedWithFurtherAction'
            if closed_with_ignore is not None:
                self._closed_with_ignore = closed_with_ignore
                self._type = 'closedWithIgnore'

        elif type_of_union == 'pendingReview':
            if pending_review is None:
                raise ValueError('a union value must not be None')
            self._pending_review = pending_review
            self._type = 'pendingReview'
        elif type_of_union == 'closedWithFurtherAction':
            if closed_with_further_action is None:
                raise ValueError('a union value must not be None')
            self._closed_with_further_action = closed_with_further_action
            self._type = 'closedWithFurtherAction'
        elif type_of_union == 'closedWithIgnore':
            if closed_with_ignore is None:
                raise ValueError('a union value must not be None')
            self._closed_with_ignore = closed_with_ignore
            self._type = 'closedWithIgnore'

    @builtins.property
    def pending_review(self) -> Optional["scout_api_PendingReviewDispositionState"]:
        return self._pending_review

    @builtins.property
    def closed_with_further_action(self) -> Optional["scout_api_ClosedWithFurtherActionDispositionState"]:
        return self._closed_with_further_action

    @builtins.property
    def closed_with_ignore(self) -> Optional["scout_api_ClosedWithIgnoreDispositionState"]:
        return self._closed_with_ignore

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, scout_api_DispositionStateVisitor):
            raise ValueError('{} is not an instance of scout_api_DispositionStateVisitor'.format(visitor.__class__.__name__))
        if self._type == 'pendingReview' and self.pending_review is not None:
            return visitor._pending_review(self.pending_review)
        if self._type == 'closedWithFurtherAction' and self.closed_with_further_action is not None:
            return visitor._closed_with_further_action(self.closed_with_further_action)
        if self._type == 'closedWithIgnore' and self.closed_with_ignore is not None:
            return visitor._closed_with_ignore(self.closed_with_ignore)


scout_api_DispositionState.__name__ = "DispositionState"
scout_api_DispositionState.__qualname__ = "DispositionState"
scout_api_DispositionState.__module__ = "nominal_api.scout_api"


class scout_api_DispositionStateVisitor:

    @abstractmethod
    def _pending_review(self, pending_review: "scout_api_PendingReviewDispositionState") -> Any:
        pass

    @abstractmethod
    def _closed_with_further_action(self, closed_with_further_action: "scout_api_ClosedWithFurtherActionDispositionState") -> Any:
        pass

    @abstractmethod
    def _closed_with_ignore(self, closed_with_ignore: "scout_api_ClosedWithIgnoreDispositionState") -> Any:
        pass


scout_api_DispositionStateVisitor.__name__ = "DispositionStateVisitor"
scout_api_DispositionStateVisitor.__qualname__ = "DispositionStateVisitor"
scout_api_DispositionStateVisitor.__module__ = "nominal_api.scout_api"


class scout_api_PendingReviewDispositionState(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'opened_by': ConjureFieldDefinition('openedBy', scout_rids_api_UserRid)
        }

    __slots__: List[str] = ['_opened_by']

    def __init__(self, opened_by: str) -> None:
        self._opened_by = opened_by

    @builtins.property
    def opened_by(self) -> str:
        return self._opened_by


scout_api_PendingReviewDispositionState.__name__ = "PendingReviewDispositionState"
scout_api_PendingReviewDispositionState.__qualname__ = "PendingReviewDispositionState"
scout_api_PendingReviewDispositionState.__module__ = "nominal_api.scout_api"


class scout_api_Priority(ConjureEnumType):

    P0 = 'P0'
    '''P0'''
    P1 = 'P1'
    '''P1'''
    P2 = 'P2'
    '''P2'''
    P3 = 'P3'
    '''P3'''
    P4 = 'P4'
    '''P4'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


scout_api_Priority.__name__ = "Priority"
scout_api_Priority.__qualname__ = "Priority"
scout_api_Priority.__module__ = "nominal_api.scout_api"


class scout_api_Symbol(ConjureUnionType):
    _icon: Optional[str] = None
    _emoji: Optional[str] = None
    _image: Optional[str] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'icon': ConjureFieldDefinition('icon', str),
            'emoji': ConjureFieldDefinition('emoji', str),
            'image': ConjureFieldDefinition('image', str)
        }

    def __init__(
            self,
            icon: Optional[str] = None,
            emoji: Optional[str] = None,
            image: Optional[str] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (icon is not None) + (emoji is not None) + (image is not None) != 1:
                raise ValueError('a union must contain a single member')

            if icon is not None:
                self._icon = icon
                self._type = 'icon'
            if emoji is not None:
                self._emoji = emoji
                self._type = 'emoji'
            if image is not None:
                self._image = image
                self._type = 'image'

        elif type_of_union == 'icon':
            if icon is None:
                raise ValueError('a union value must not be None')
            self._icon = icon
            self._type = 'icon'
        elif type_of_union == 'emoji':
            if emoji is None:
                raise ValueError('a union value must not be None')
            self._emoji = emoji
            self._type = 'emoji'
        elif type_of_union == 'image':
            if image is None:
                raise ValueError('a union value must not be None')
            self._image = image
            self._type = 'image'

    @builtins.property
    def icon(self) -> Optional[str]:
        """Icon name (e.g. castle)
        """
        return self._icon

    @builtins.property
    def emoji(self) -> Optional[str]:
        """Emoji name (e.g. :castle:)
        """
        return self._emoji

    @builtins.property
    def image(self) -> Optional[str]:
        """Image url (e.g. https://example.com/image.png)
        """
        return self._image

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, scout_api_SymbolVisitor):
            raise ValueError('{} is not an instance of scout_api_SymbolVisitor'.format(visitor.__class__.__name__))
        if self._type == 'icon' and self.icon is not None:
            return visitor._icon(self.icon)
        if self._type == 'emoji' and self.emoji is not None:
            return visitor._emoji(self.emoji)
        if self._type == 'image' and self.image is not None:
            return visitor._image(self.image)


scout_api_Symbol.__name__ = "Symbol"
scout_api_Symbol.__qualname__ = "Symbol"
scout_api_Symbol.__module__ = "nominal_api.scout_api"


class scout_api_SymbolVisitor:

    @abstractmethod
    def _icon(self, icon: str) -> Any:
        pass

    @abstractmethod
    def _emoji(self, emoji: str) -> Any:
        pass

    @abstractmethod
    def _image(self, image: str) -> Any:
        pass


scout_api_SymbolVisitor.__name__ = "SymbolVisitor"
scout_api_SymbolVisitor.__qualname__ = "SymbolVisitor"
scout_api_SymbolVisitor.__module__ = "nominal_api.scout_api"


class scout_asset_api_AddDataScopesToAssetRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'data_scopes': ConjureFieldDefinition('dataScopes', List[scout_asset_api_CreateAssetDataScope])
        }

    __slots__: List[str] = ['_data_scopes']

    def __init__(self, data_scopes: List["scout_asset_api_CreateAssetDataScope"]) -> None:
        self._data_scopes = data_scopes

    @builtins.property
    def data_scopes(self) -> List["scout_asset_api_CreateAssetDataScope"]:
        """The data scopes to add to the asset.

Throws if any existing data scopes have data scope names that conflict with the data scope names
in the request.
        """
        return self._data_scopes


scout_asset_api_AddDataScopesToAssetRequest.__name__ = "AddDataScopesToAssetRequest"
scout_asset_api_AddDataScopesToAssetRequest.__qualname__ = "AddDataScopesToAssetRequest"
scout_asset_api_AddDataScopesToAssetRequest.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_Asset(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', scout_rids_api_AssetRid),
            'title': ConjureFieldDefinition('title', str),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'links': ConjureFieldDefinition('links', List[scout_run_api_Link]),
            'data_scopes': ConjureFieldDefinition('dataScopes', List[scout_asset_api_DataScope]),
            'created_by': ConjureFieldDefinition('createdBy', OptionalTypeWrapper[str]),
            'created_at': ConjureFieldDefinition('createdAt', str),
            'updated_at': ConjureFieldDefinition('updatedAt', str),
            'attachments': ConjureFieldDefinition('attachments', List[api_rids_AttachmentRid]),
            'type': ConjureFieldDefinition('type', OptionalTypeWrapper[scout_rids_api_TypeRid]),
            'is_staged': ConjureFieldDefinition('isStaged', bool),
            'is_archived': ConjureFieldDefinition('isArchived', bool)
        }

    __slots__: List[str] = ['_rid', '_title', '_description', '_properties', '_labels', '_links', '_data_scopes', '_created_by', '_created_at', '_updated_at', '_attachments', '_type', '_is_staged', '_is_archived']

    def __init__(self, attachments: List[str], created_at: str, data_scopes: List["scout_asset_api_DataScope"], is_archived: bool, is_staged: bool, labels: List[str], links: List["scout_run_api_Link"], properties: Dict[str, str], rid: str, title: str, updated_at: str, created_by: Optional[str] = None, description: Optional[str] = None, type: Optional[str] = None) -> None:
        self._rid = rid
        self._title = title
        self._description = description
        self._properties = properties
        self._labels = labels
        self._links = links
        self._data_scopes = data_scopes
        self._created_by = created_by
        self._created_at = created_at
        self._updated_at = updated_at
        self._attachments = attachments
        self._type = type
        self._is_staged = is_staged
        self._is_archived = is_archived

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def title(self) -> str:
        return self._title

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def labels(self) -> List[str]:
        """Labels associated with the asset. These labels do not have a time dimension.
To associate labels with a range of time, create a time range on the asset with labels.
        """
        return self._labels

    @builtins.property
    def links(self) -> List["scout_run_api_Link"]:
        """Links associated with the asset. These links do not have a time dimension.
To associate links with a range of time, create a time range on the asset with links.
        """
        return self._links

    @builtins.property
    def data_scopes(self) -> List["scout_asset_api_DataScope"]:
        """The data scopes associated with the asset.
        """
        return self._data_scopes

    @builtins.property
    def created_by(self) -> Optional[str]:
        return self._created_by

    @builtins.property
    def created_at(self) -> str:
        return self._created_at

    @builtins.property
    def updated_at(self) -> str:
        return self._updated_at

    @builtins.property
    def attachments(self) -> List[str]:
        return self._attachments

    @builtins.property
    def type(self) -> Optional[str]:
        return self._type

    @builtins.property
    def is_staged(self) -> bool:
        """Auto created assets are considered staged by default.
        """
        return self._is_staged

    @builtins.property
    def is_archived(self) -> bool:
        return self._is_archived


scout_asset_api_Asset.__name__ = "Asset"
scout_asset_api_Asset.__qualname__ = "Asset"
scout_asset_api_Asset.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_AssetSortField(ConjureEnumType):

    NAME = 'NAME'
    '''NAME'''
    CREATED_AT = 'CREATED_AT'
    '''CREATED_AT'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


scout_asset_api_AssetSortField.__name__ = "AssetSortField"
scout_asset_api_AssetSortField.__qualname__ = "AssetSortField"
scout_asset_api_AssetSortField.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_AssetSortOptions(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'is_descending': ConjureFieldDefinition('isDescending', bool),
            'field': ConjureFieldDefinition('field', OptionalTypeWrapper[scout_asset_api_AssetSortField]),
            'sort_key': ConjureFieldDefinition('sortKey', OptionalTypeWrapper[scout_asset_api_SortKey])
        }

    __slots__: List[str] = ['_is_descending', '_field', '_sort_key']

    def __init__(self, is_descending: bool, field: Optional["scout_asset_api_AssetSortField"] = None, sort_key: Optional["scout_asset_api_SortKey"] = None) -> None:
        self._is_descending = is_descending
        self._field = field
        self._sort_key = sort_key

    @builtins.property
    def is_descending(self) -> bool:
        return self._is_descending

    @builtins.property
    def field(self) -> Optional["scout_asset_api_AssetSortField"]:
        return self._field

    @builtins.property
    def sort_key(self) -> Optional["scout_asset_api_SortKey"]:
        """Field to sort by. Includes both field and property-based sorting.
Must be supplied if field is not provided separately.
        """
        return self._sort_key


scout_asset_api_AssetSortOptions.__name__ = "AssetSortOptions"
scout_asset_api_AssetSortOptions.__qualname__ = "AssetSortOptions"
scout_asset_api_AssetSortOptions.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_AssetTypeDataScopeConfig(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'suggested_ref_name': ConjureFieldDefinition('suggestedRefName', OptionalTypeWrapper[str]),
            'tags': ConjureFieldDefinition('tags', scout_asset_api_TagConfig)
        }

    __slots__: List[str] = ['_suggested_ref_name', '_tags']

    def __init__(self, tags: "scout_asset_api_TagConfig", suggested_ref_name: Optional[str] = None) -> None:
        self._suggested_ref_name = suggested_ref_name
        self._tags = tags

    @builtins.property
    def suggested_ref_name(self) -> Optional[str]:
        return self._suggested_ref_name

    @builtins.property
    def tags(self) -> "scout_asset_api_TagConfig":
        """Tag names that should be supplied to downscope data for an asset of the asset type. These are not 
enforced.
        """
        return self._tags


scout_asset_api_AssetTypeDataScopeConfig.__name__ = "AssetTypeDataScopeConfig"
scout_asset_api_AssetTypeDataScopeConfig.__qualname__ = "AssetTypeDataScopeConfig"
scout_asset_api_AssetTypeDataScopeConfig.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_AssetTypesFilter(ConjureBeanType):
    """returns runs that match any of the provided assetTypes.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'asset_types': ConjureFieldDefinition('assetTypes', List[scout_rids_api_TypeRid])
        }

    __slots__: List[str] = ['_asset_types']

    def __init__(self, asset_types: List[str]) -> None:
        self._asset_types = asset_types

    @builtins.property
    def asset_types(self) -> List[str]:
        return self._asset_types


scout_asset_api_AssetTypesFilter.__name__ = "AssetTypesFilter"
scout_asset_api_AssetTypesFilter.__qualname__ = "AssetTypesFilter"
scout_asset_api_AssetTypesFilter.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_ChannelMetadata(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', scout_asset_api_Channel),
            'data_source': ConjureFieldDefinition('dataSource', scout_run_api_DataSource),
            'unit': ConjureFieldDefinition('unit', OptionalTypeWrapper[scout_run_api_Unit]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'data_type': ConjureFieldDefinition('dataType', OptionalTypeWrapper[api_SeriesDataType])
        }

    __slots__: List[str] = ['_name', '_data_source', '_unit', '_description', '_data_type']

    def __init__(self, data_source: "scout_run_api_DataSource", name: str, data_type: Optional["api_SeriesDataType"] = None, description: Optional[str] = None, unit: Optional["scout_run_api_Unit"] = None) -> None:
        self._name = name
        self._data_source = data_source
        self._unit = unit
        self._description = description
        self._data_type = data_type

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def data_source(self) -> "scout_run_api_DataSource":
        return self._data_source

    @builtins.property
    def unit(self) -> Optional["scout_run_api_Unit"]:
        return self._unit

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def data_type(self) -> Optional["api_SeriesDataType"]:
        return self._data_type


scout_asset_api_ChannelMetadata.__name__ = "ChannelMetadata"
scout_asset_api_ChannelMetadata.__qualname__ = "ChannelMetadata"
scout_asset_api_ChannelMetadata.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_CreateAssetDataScope(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'data_scope_name': ConjureFieldDefinition('dataScopeName', scout_api_DataSourceRefName),
            'data_source': ConjureFieldDefinition('dataSource', scout_run_api_DataSource),
            'offset': ConjureFieldDefinition('offset', OptionalTypeWrapper[scout_run_api_Duration]),
            'series_tags': ConjureFieldDefinition('seriesTags', Dict[api_TagName, api_TagValue])
        }

    __slots__: List[str] = ['_data_scope_name', '_data_source', '_offset', '_series_tags']

    def __init__(self, data_scope_name: str, data_source: "scout_run_api_DataSource", series_tags: Dict[str, str], offset: Optional["scout_run_api_Duration"] = None) -> None:
        self._data_scope_name = data_scope_name
        self._data_source = data_source
        self._offset = offset
        self._series_tags = series_tags

    @builtins.property
    def data_scope_name(self) -> str:
        """The name of the data scope. The name is guaranteed to be be unique within the context of an asset.
        """
        return self._data_scope_name

    @builtins.property
    def data_source(self) -> "scout_run_api_DataSource":
        return self._data_source

    @builtins.property
    def offset(self) -> Optional["scout_run_api_Duration"]:
        return self._offset

    @builtins.property
    def series_tags(self) -> Dict[str, str]:
        """Filters the data source to series matching these tag values. The filtered set of series should be
the ones that belong to the asset.
        """
        return self._series_tags


scout_asset_api_CreateAssetDataScope.__name__ = "CreateAssetDataScope"
scout_asset_api_CreateAssetDataScope.__qualname__ = "CreateAssetDataScope"
scout_asset_api_CreateAssetDataScope.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_CreateAssetRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'title': ConjureFieldDefinition('title', str),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'links': ConjureFieldDefinition('links', List[scout_run_api_Link]),
            'data_scopes': ConjureFieldDefinition('dataScopes', List[scout_asset_api_CreateAssetDataScope]),
            'attachments': ConjureFieldDefinition('attachments', List[api_rids_AttachmentRid]),
            'type': ConjureFieldDefinition('type', OptionalTypeWrapper[scout_rids_api_TypeRid]),
            'workspace': ConjureFieldDefinition('workspace', OptionalTypeWrapper[api_rids_WorkspaceRid])
        }

    __slots__: List[str] = ['_title', '_description', '_properties', '_labels', '_links', '_data_scopes', '_attachments', '_type', '_workspace']

    def __init__(self, attachments: List[str], data_scopes: List["scout_asset_api_CreateAssetDataScope"], labels: List[str], links: List["scout_run_api_Link"], properties: Dict[str, str], title: str, description: Optional[str] = None, type: Optional[str] = None, workspace: Optional[str] = None) -> None:
        self._title = title
        self._description = description
        self._properties = properties
        self._labels = labels
        self._links = links
        self._data_scopes = data_scopes
        self._attachments = attachments
        self._type = type
        self._workspace = workspace

    @builtins.property
    def title(self) -> str:
        return self._title

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels

    @builtins.property
    def links(self) -> List["scout_run_api_Link"]:
        return self._links

    @builtins.property
    def data_scopes(self) -> List["scout_asset_api_CreateAssetDataScope"]:
        """The data scopes associated with the asset.
        """
        return self._data_scopes

    @builtins.property
    def attachments(self) -> List[str]:
        return self._attachments

    @builtins.property
    def type(self) -> Optional[str]:
        return self._type

    @builtins.property
    def workspace(self) -> Optional[str]:
        """The workspace in which to create the asset. If not provided, the asset will be created in
the default workspace for the user's organization, if the default workspace for the
organization is configured.
All data scopes, attachments, and the optional asset type must be in the same workspace.
        """
        return self._workspace


scout_asset_api_CreateAssetRequest.__name__ = "CreateAssetRequest"
scout_asset_api_CreateAssetRequest.__qualname__ = "CreateAssetRequest"
scout_asset_api_CreateAssetRequest.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_CreateTypeRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', str),
            'property_configs': ConjureFieldDefinition('propertyConfigs', Dict[api_PropertyName, scout_asset_api_PropertyConfig]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'icon_name': ConjureFieldDefinition('iconName', OptionalTypeWrapper[str]),
            'workspace': ConjureFieldDefinition('workspace', OptionalTypeWrapper[api_rids_WorkspaceRid]),
            'datasource_configs': ConjureFieldDefinition('datasourceConfigs', OptionalTypeWrapper[Dict[api_rids_DataSourceRid, scout_asset_api_AssetTypeDataScopeConfig]])
        }

    __slots__: List[str] = ['_name', '_property_configs', '_description', '_icon_name', '_workspace', '_datasource_configs']

    def __init__(self, name: str, property_configs: Dict[str, "scout_asset_api_PropertyConfig"], datasource_configs: Optional[Dict[str, "scout_asset_api_AssetTypeDataScopeConfig"]] = None, description: Optional[str] = None, icon_name: Optional[str] = None, workspace: Optional[str] = None) -> None:
        self._name = name
        self._property_configs = property_configs
        self._description = description
        self._icon_name = icon_name
        self._workspace = workspace
        self._datasource_configs = datasource_configs

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def property_configs(self) -> Dict[str, "scout_asset_api_PropertyConfig"]:
        return self._property_configs

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def icon_name(self) -> Optional[str]:
        return self._icon_name

    @builtins.property
    def workspace(self) -> Optional[str]:
        """The workspace in which to create the asset type. If not provided, the asset type will be created in
the default workspace for the user's organization, if the default workspace for the
organization is configured.
        """
        return self._workspace

    @builtins.property
    def datasource_configs(self) -> Optional[Dict[str, "scout_asset_api_AssetTypeDataScopeConfig"]]:
        """The configuration outlines what a data scope should provide when added to an asset of this type. It is 
referenced at data scope creation time, but does not actively modify existing data scopes.
        """
        return self._datasource_configs


scout_asset_api_CreateTypeRequest.__name__ = "CreateTypeRequest"
scout_asset_api_CreateTypeRequest.__qualname__ = "CreateTypeRequest"
scout_asset_api_CreateTypeRequest.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_DataScope(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'data_scope_name': ConjureFieldDefinition('dataScopeName', scout_api_DataSourceRefName),
            'data_source': ConjureFieldDefinition('dataSource', scout_run_api_DataSource),
            'offset': ConjureFieldDefinition('offset', OptionalTypeWrapper[scout_run_api_Duration]),
            'timestamp_type': ConjureFieldDefinition('timestampType', scout_run_api_WeakTimestampType),
            'series_tags': ConjureFieldDefinition('seriesTags', Dict[api_TagName, api_TagValue])
        }

    __slots__: List[str] = ['_data_scope_name', '_data_source', '_offset', '_timestamp_type', '_series_tags']

    def __init__(self, data_scope_name: str, data_source: "scout_run_api_DataSource", series_tags: Dict[str, str], timestamp_type: "scout_run_api_WeakTimestampType", offset: Optional["scout_run_api_Duration"] = None) -> None:
        self._data_scope_name = data_scope_name
        self._data_source = data_source
        self._offset = offset
        self._timestamp_type = timestamp_type
        self._series_tags = series_tags

    @builtins.property
    def data_scope_name(self) -> str:
        """The name of the data scope. The name is guaranteed to be be unique within the context of an asset.
        """
        return self._data_scope_name

    @builtins.property
    def data_source(self) -> "scout_run_api_DataSource":
        return self._data_source

    @builtins.property
    def offset(self) -> Optional["scout_run_api_Duration"]:
        return self._offset

    @builtins.property
    def timestamp_type(self) -> "scout_run_api_WeakTimestampType":
        return self._timestamp_type

    @builtins.property
    def series_tags(self) -> Dict[str, str]:
        """Filters the data source to series matching these tag values. The filtered set of series should be
the ones that belong to the asset.
        """
        return self._series_tags


scout_asset_api_DataScope.__name__ = "DataScope"
scout_asset_api_DataScope.__qualname__ = "DataScope"
scout_asset_api_DataScope.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_PropertyConfig(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'is_required': ConjureFieldDefinition('isRequired', bool),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str])
        }

    __slots__: List[str] = ['_is_required', '_description']

    def __init__(self, is_required: bool, description: Optional[str] = None) -> None:
        self._is_required = is_required
        self._description = description

    @builtins.property
    def is_required(self) -> bool:
        return self._is_required

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description


scout_asset_api_PropertyConfig.__name__ = "PropertyConfig"
scout_asset_api_PropertyConfig.__qualname__ = "PropertyConfig"
scout_asset_api_PropertyConfig.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_RemoveType(ConjureBeanType):
    """The request to remove the type from the asset.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



scout_asset_api_RemoveType.__name__ = "RemoveType"
scout_asset_api_RemoveType.__qualname__ = "RemoveType"
scout_asset_api_RemoveType.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_SearchAssetChannelsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'search_text': ConjureFieldDefinition('searchText', str),
            'data_scope_name_filter': ConjureFieldDefinition('dataScopeNameFilter', OptionalTypeWrapper[List[scout_api_DataSourceRefName]]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token]),
            'page_size': ConjureFieldDefinition('pageSize', OptionalTypeWrapper[int])
        }

    __slots__: List[str] = ['_search_text', '_data_scope_name_filter', '_next_page_token', '_page_size']

    def __init__(self, search_text: str, data_scope_name_filter: Optional[List[str]] = None, next_page_token: Optional[str] = None, page_size: Optional[int] = None) -> None:
        self._search_text = search_text
        self._data_scope_name_filter = data_scope_name_filter
        self._next_page_token = next_page_token
        self._page_size = page_size

    @builtins.property
    def search_text(self) -> str:
        return self._search_text

    @builtins.property
    def data_scope_name_filter(self) -> Optional[List[str]]:
        """If not empty, will filter to channels from the selected data scope names.
        """
        return self._data_scope_name_filter

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token

    @builtins.property
    def page_size(self) -> Optional[int]:
        """Defaults to 1000. Will throw if larger than 10000. Default pageSize is 100.
        """
        return self._page_size


scout_asset_api_SearchAssetChannelsRequest.__name__ = "SearchAssetChannelsRequest"
scout_asset_api_SearchAssetChannelsRequest.__qualname__ = "SearchAssetChannelsRequest"
scout_asset_api_SearchAssetChannelsRequest.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_SearchAssetChannelsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[scout_asset_api_ChannelMetadata]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_results', '_next_page_token']

    def __init__(self, results: List["scout_asset_api_ChannelMetadata"], next_page_token: Optional[str] = None) -> None:
        self._results = results
        self._next_page_token = next_page_token

    @builtins.property
    def results(self) -> List["scout_asset_api_ChannelMetadata"]:
        return self._results

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


scout_asset_api_SearchAssetChannelsResponse.__name__ = "SearchAssetChannelsResponse"
scout_asset_api_SearchAssetChannelsResponse.__qualname__ = "SearchAssetChannelsResponse"
scout_asset_api_SearchAssetChannelsResponse.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_SearchAssetsQuery(ConjureUnionType):
    _search_text: Optional[str] = None
    _exact_substring: Optional[str] = None
    _label: Optional[str] = None
    _labels: Optional["scout_rids_api_LabelsFilter"] = None
    _property: Optional["api_Property"] = None
    _properties: Optional["scout_rids_api_PropertiesFilter"] = None
    _type_rid: Optional[str] = None
    _asset_types: Optional["scout_asset_api_AssetTypesFilter"] = None
    _is_staged: Optional[bool] = None
    _archived: Optional[bool] = None
    _and_: Optional[List["scout_asset_api_SearchAssetsQuery"]] = None
    _or_: Optional[List["scout_asset_api_SearchAssetsQuery"]] = None
    _workspace: Optional[str] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'search_text': ConjureFieldDefinition('searchText', str),
            'exact_substring': ConjureFieldDefinition('exactSubstring', str),
            'label': ConjureFieldDefinition('label', api_Label),
            'labels': ConjureFieldDefinition('labels', scout_rids_api_LabelsFilter),
            'property': ConjureFieldDefinition('property', api_Property),
            'properties': ConjureFieldDefinition('properties', scout_rids_api_PropertiesFilter),
            'type_rid': ConjureFieldDefinition('typeRid', scout_rids_api_TypeRid),
            'asset_types': ConjureFieldDefinition('assetTypes', scout_asset_api_AssetTypesFilter),
            'is_staged': ConjureFieldDefinition('isStaged', bool),
            'archived': ConjureFieldDefinition('archived', bool),
            'and_': ConjureFieldDefinition('and', List[scout_asset_api_SearchAssetsQuery]),
            'or_': ConjureFieldDefinition('or', List[scout_asset_api_SearchAssetsQuery]),
            'workspace': ConjureFieldDefinition('workspace', api_rids_WorkspaceRid)
        }

    def __init__(
            self,
            search_text: Optional[str] = None,
            exact_substring: Optional[str] = None,
            label: Optional[str] = None,
            labels: Optional["scout_rids_api_LabelsFilter"] = None,
            property: Optional["api_Property"] = None,
            properties: Optional["scout_rids_api_PropertiesFilter"] = None,
            type_rid: Optional[str] = None,
            asset_types: Optional["scout_asset_api_AssetTypesFilter"] = None,
            is_staged: Optional[bool] = None,
            archived: Optional[bool] = None,
            and_: Optional[List["scout_asset_api_SearchAssetsQuery"]] = None,
            or_: Optional[List["scout_asset_api_SearchAssetsQuery"]] = None,
            workspace: Optional[str] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (search_text is not None) + (exact_substring is not None) + (label is not None) + (labels is not None) + (property is not None) + (properties is not None) + (type_rid is not None) + (asset_types is not None) + (is_staged is not None) + (archived is not None) + (and_ is not None) + (or_ is not None) + (workspace is not None) != 1:
                raise ValueError('a union must contain a single member')

            if search_text is not None:
                self._search_text = search_text
                self._type = 'searchText'
            if exact_substring is not None:
                self._exact_substring = exact_substring
                self._type = 'exactSubstring'
            if label is not None:
                self._label = label
                self._type = 'label'
            if labels is not None:
                self._labels = labels
                self._type = 'labels'
            if property is not None:
                self._property = property
                self._type = 'property'
            if properties is not None:
                self._properties = properties
                self._type = 'properties'
            if type_rid is not None:
                self._type_rid = type_rid
                self._type = 'typeRid'
            if asset_types is not None:
                self._asset_types = asset_types
                self._type = 'assetTypes'
            if is_staged is not None:
                self._is_staged = is_staged
                self._type = 'isStaged'
            if archived is not None:
                self._archived = archived
                self._type = 'archived'
            if and_ is not None:
                self._and_ = and_
                self._type = 'and'
            if or_ is not None:
                self._or_ = or_
                self._type = 'or'
            if workspace is not None:
                self._workspace = workspace
                self._type = 'workspace'

        elif type_of_union == 'searchText':
            if search_text is None:
                raise ValueError('a union value must not be None')
            self._search_text = search_text
            self._type = 'searchText'
        elif type_of_union == 'exactSubstring':
            if exact_substring is None:
                raise ValueError('a union value must not be None')
            self._exact_substring = exact_substring
            self._type = 'exactSubstring'
        elif type_of_union == 'label':
            if label is None:
                raise ValueError('a union value must not be None')
            self._label = label
            self._type = 'label'
        elif type_of_union == 'labels':
            if labels is None:
                raise ValueError('a union value must not be None')
            self._labels = labels
            self._type = 'labels'
        elif type_of_union == 'property':
            if property is None:
                raise ValueError('a union value must not be None')
            self._property = property
            self._type = 'property'
        elif type_of_union == 'properties':
            if properties is None:
                raise ValueError('a union value must not be None')
            self._properties = properties
            self._type = 'properties'
        elif type_of_union == 'typeRid':
            if type_rid is None:
                raise ValueError('a union value must not be None')
            self._type_rid = type_rid
            self._type = 'typeRid'
        elif type_of_union == 'assetTypes':
            if asset_types is None:
                raise ValueError('a union value must not be None')
            self._asset_types = asset_types
            self._type = 'assetTypes'
        elif type_of_union == 'isStaged':
            if is_staged is None:
                raise ValueError('a union value must not be None')
            self._is_staged = is_staged
            self._type = 'isStaged'
        elif type_of_union == 'archived':
            if archived is None:
                raise ValueError('a union value must not be None')
            self._archived = archived
            self._type = 'archived'
        elif type_of_union == 'and':
            if and_ is None:
                raise ValueError('a union value must not be None')
            self._and_ = and_
            self._type = 'and'
        elif type_of_union == 'or':
            if or_ is None:
                raise ValueError('a union value must not be None')
            self._or_ = or_
            self._type = 'or'
        elif type_of_union == 'workspace':
            if workspace is None:
                raise ValueError('a union value must not be None')
            self._workspace = workspace
            self._type = 'workspace'

    @builtins.property
    def search_text(self) -> Optional[str]:
        return self._search_text

    @builtins.property
    def exact_substring(self) -> Optional[str]:
        """An case-insensitive substring match of the title or description of the asset.
        """
        return self._exact_substring

    @builtins.property
    def label(self) -> Optional[str]:
        return self._label

    @builtins.property
    def labels(self) -> Optional["scout_rids_api_LabelsFilter"]:
        return self._labels

    @builtins.property
    def property(self) -> Optional["api_Property"]:
        return self._property

    @builtins.property
    def properties(self) -> Optional["scout_rids_api_PropertiesFilter"]:
        return self._properties

    @builtins.property
    def type_rid(self) -> Optional[str]:
        return self._type_rid

    @builtins.property
    def asset_types(self) -> Optional["scout_asset_api_AssetTypesFilter"]:
        return self._asset_types

    @builtins.property
    def is_staged(self) -> Optional[bool]:
        return self._is_staged

    @builtins.property
    def archived(self) -> Optional[bool]:
        return self._archived

    @builtins.property
    def and_(self) -> Optional[List["scout_asset_api_SearchAssetsQuery"]]:
        return self._and_

    @builtins.property
    def or_(self) -> Optional[List["scout_asset_api_SearchAssetsQuery"]]:
        return self._or_

    @builtins.property
    def workspace(self) -> Optional[str]:
        return self._workspace

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, scout_asset_api_SearchAssetsQueryVisitor):
            raise ValueError('{} is not an instance of scout_asset_api_SearchAssetsQueryVisitor'.format(visitor.__class__.__name__))
        if self._type == 'searchText' and self.search_text is not None:
            return visitor._search_text(self.search_text)
        if self._type == 'exactSubstring' and self.exact_substring is not None:
            return visitor._exact_substring(self.exact_substring)
        if self._type == 'label' and self.label is not None:
            return visitor._label(self.label)
        if self._type == 'labels' and self.labels is not None:
            return visitor._labels(self.labels)
        if self._type == 'property' and self.property is not None:
            return visitor._property(self.property)
        if self._type == 'properties' and self.properties is not None:
            return visitor._properties(self.properties)
        if self._type == 'typeRid' and self.type_rid is not None:
            return visitor._type_rid(self.type_rid)
        if self._type == 'assetTypes' and self.asset_types is not None:
            return visitor._asset_types(self.asset_types)
        if self._type == 'isStaged' and self.is_staged is not None:
            return visitor._is_staged(self.is_staged)
        if self._type == 'archived' and self.archived is not None:
            return visitor._archived(self.archived)
        if self._type == 'and' and self.and_ is not None:
            return visitor._and(self.and_)
        if self._type == 'or' and self.or_ is not None:
            return visitor._or(self.or_)
        if self._type == 'workspace' and self.workspace is not None:
            return visitor._workspace(self.workspace)


scout_asset_api_SearchAssetsQuery.__name__ = "SearchAssetsQuery"
scout_asset_api_SearchAssetsQuery.__qualname__ = "SearchAssetsQuery"
scout_asset_api_SearchAssetsQuery.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_SearchAssetsQueryVisitor:

    @abstractmethod
    def _search_text(self, search_text: str) -> Any:
        pass

    @abstractmethod
    def _exact_substring(self, exact_substring: str) -> Any:
        pass

    @abstractmethod
    def _label(self, label: str) -> Any:
        pass

    @abstractmethod
    def _labels(self, labels: "scout_rids_api_LabelsFilter") -> Any:
        pass

    @abstractmethod
    def _property(self, property: "api_Property") -> Any:
        pass

    @abstractmethod
    def _properties(self, properties: "scout_rids_api_PropertiesFilter") -> Any:
        pass

    @abstractmethod
    def _type_rid(self, type_rid: str) -> Any:
        pass

    @abstractmethod
    def _asset_types(self, asset_types: "scout_asset_api_AssetTypesFilter") -> Any:
        pass

    @abstractmethod
    def _is_staged(self, is_staged: bool) -> Any:
        pass

    @abstractmethod
    def _archived(self, archived: bool) -> Any:
        pass

    @abstractmethod
    def _and(self, and_: List["scout_asset_api_SearchAssetsQuery"]) -> Any:
        pass

    @abstractmethod
    def _or(self, or_: List["scout_asset_api_SearchAssetsQuery"]) -> Any:
        pass

    @abstractmethod
    def _workspace(self, workspace: str) -> Any:
        pass


scout_asset_api_SearchAssetsQueryVisitor.__name__ = "SearchAssetsQueryVisitor"
scout_asset_api_SearchAssetsQueryVisitor.__qualname__ = "SearchAssetsQueryVisitor"
scout_asset_api_SearchAssetsQueryVisitor.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_SearchAssetsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'sort': ConjureFieldDefinition('sort', scout_asset_api_AssetSortOptions),
            'page_size': ConjureFieldDefinition('pageSize', OptionalTypeWrapper[int]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token]),
            'query': ConjureFieldDefinition('query', scout_asset_api_SearchAssetsQuery),
            'archived_statuses': ConjureFieldDefinition('archivedStatuses', OptionalTypeWrapper[List[api_ArchivedStatus]])
        }

    __slots__: List[str] = ['_sort', '_page_size', '_next_page_token', '_query', '_archived_statuses']

    def __init__(self, query: "scout_asset_api_SearchAssetsQuery", sort: "scout_asset_api_AssetSortOptions", archived_statuses: Optional[List["api_ArchivedStatus"]] = None, next_page_token: Optional[str] = None, page_size: Optional[int] = None) -> None:
        self._sort = sort
        self._page_size = page_size
        self._next_page_token = next_page_token
        self._query = query
        self._archived_statuses = archived_statuses

    @builtins.property
    def sort(self) -> "scout_asset_api_AssetSortOptions":
        return self._sort

    @builtins.property
    def page_size(self) -> Optional[int]:
        """Page sizes greater than 10_000 will be rejected. Default pageSize is 100.
        """
        return self._page_size

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token

    @builtins.property
    def query(self) -> "scout_asset_api_SearchAssetsQuery":
        return self._query

    @builtins.property
    def archived_statuses(self) -> Optional[List["api_ArchivedStatus"]]:
        """Default search status is NOT_ARCHIVED if none are provided. Allows for including archived assets in search.
        """
        return self._archived_statuses


scout_asset_api_SearchAssetsRequest.__name__ = "SearchAssetsRequest"
scout_asset_api_SearchAssetsRequest.__qualname__ = "SearchAssetsRequest"
scout_asset_api_SearchAssetsRequest.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_SearchAssetsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[scout_asset_api_Asset]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_results', '_next_page_token']

    def __init__(self, results: List["scout_asset_api_Asset"], next_page_token: Optional[str] = None) -> None:
        self._results = results
        self._next_page_token = next_page_token

    @builtins.property
    def results(self) -> List["scout_asset_api_Asset"]:
        return self._results

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


scout_asset_api_SearchAssetsResponse.__name__ = "SearchAssetsResponse"
scout_asset_api_SearchAssetsResponse.__qualname__ = "SearchAssetsResponse"
scout_asset_api_SearchAssetsResponse.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_SearchTypesQuery(ConjureUnionType):
    _search_text: Optional[str] = None
    _property: Optional[str] = None
    _and_: Optional[List["scout_asset_api_SearchTypesQuery"]] = None
    _or_: Optional[List["scout_asset_api_SearchTypesQuery"]] = None
    _workspace: Optional[str] = None
    _configured_datasource: Optional[str] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'search_text': ConjureFieldDefinition('searchText', str),
            'property': ConjureFieldDefinition('property', api_PropertyName),
            'and_': ConjureFieldDefinition('and', List[scout_asset_api_SearchTypesQuery]),
            'or_': ConjureFieldDefinition('or', List[scout_asset_api_SearchTypesQuery]),
            'workspace': ConjureFieldDefinition('workspace', api_rids_WorkspaceRid),
            'configured_datasource': ConjureFieldDefinition('configuredDatasource', api_rids_DataSourceRid)
        }

    def __init__(
            self,
            search_text: Optional[str] = None,
            property: Optional[str] = None,
            and_: Optional[List["scout_asset_api_SearchTypesQuery"]] = None,
            or_: Optional[List["scout_asset_api_SearchTypesQuery"]] = None,
            workspace: Optional[str] = None,
            configured_datasource: Optional[str] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (search_text is not None) + (property is not None) + (and_ is not None) + (or_ is not None) + (workspace is not None) + (configured_datasource is not None) != 1:
                raise ValueError('a union must contain a single member')

            if search_text is not None:
                self._search_text = search_text
                self._type = 'searchText'
            if property is not None:
                self._property = property
                self._type = 'property'
            if and_ is not None:
                self._and_ = and_
                self._type = 'and'
            if or_ is not None:
                self._or_ = or_
                self._type = 'or'
            if workspace is not None:
                self._workspace = workspace
                self._type = 'workspace'
            if configured_datasource is not None:
                self._configured_datasource = configured_datasource
                self._type = 'configuredDatasource'

        elif type_of_union == 'searchText':
            if search_text is None:
                raise ValueError('a union value must not be None')
            self._search_text = search_text
            self._type = 'searchText'
        elif type_of_union == 'property':
            if property is None:
                raise ValueError('a union value must not be None')
            self._property = property
            self._type = 'property'
        elif type_of_union == 'and':
            if and_ is None:
                raise ValueError('a union value must not be None')
            self._and_ = and_
            self._type = 'and'
        elif type_of_union == 'or':
            if or_ is None:
                raise ValueError('a union value must not be None')
            self._or_ = or_
            self._type = 'or'
        elif type_of_union == 'workspace':
            if workspace is None:
                raise ValueError('a union value must not be None')
            self._workspace = workspace
            self._type = 'workspace'
        elif type_of_union == 'configuredDatasource':
            if configured_datasource is None:
                raise ValueError('a union value must not be None')
            self._configured_datasource = configured_datasource
            self._type = 'configuredDatasource'

    @builtins.property
    def search_text(self) -> Optional[str]:
        return self._search_text

    @builtins.property
    def property(self) -> Optional[str]:
        return self._property

    @builtins.property
    def and_(self) -> Optional[List["scout_asset_api_SearchTypesQuery"]]:
        return self._and_

    @builtins.property
    def or_(self) -> Optional[List["scout_asset_api_SearchTypesQuery"]]:
        return self._or_

    @builtins.property
    def workspace(self) -> Optional[str]:
        return self._workspace

    @builtins.property
    def configured_datasource(self) -> Optional[str]:
        return self._configured_datasource

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, scout_asset_api_SearchTypesQueryVisitor):
            raise ValueError('{} is not an instance of scout_asset_api_SearchTypesQueryVisitor'.format(visitor.__class__.__name__))
        if self._type == 'searchText' and self.search_text is not None:
            return visitor._search_text(self.search_text)
        if self._type == 'property' and self.property is not None:
            return visitor._property(self.property)
        if self._type == 'and' and self.and_ is not None:
            return visitor._and(self.and_)
        if self._type == 'or' and self.or_ is not None:
            return visitor._or(self.or_)
        if self._type == 'workspace' and self.workspace is not None:
            return visitor._workspace(self.workspace)
        if self._type == 'configuredDatasource' and self.configured_datasource is not None:
            return visitor._configured_datasource(self.configured_datasource)


scout_asset_api_SearchTypesQuery.__name__ = "SearchTypesQuery"
scout_asset_api_SearchTypesQuery.__qualname__ = "SearchTypesQuery"
scout_asset_api_SearchTypesQuery.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_SearchTypesQueryVisitor:

    @abstractmethod
    def _search_text(self, search_text: str) -> Any:
        pass

    @abstractmethod
    def _property(self, property: str) -> Any:
        pass

    @abstractmethod
    def _and(self, and_: List["scout_asset_api_SearchTypesQuery"]) -> Any:
        pass

    @abstractmethod
    def _or(self, or_: List["scout_asset_api_SearchTypesQuery"]) -> Any:
        pass

    @abstractmethod
    def _workspace(self, workspace: str) -> Any:
        pass

    @abstractmethod
    def _configured_datasource(self, configured_datasource: str) -> Any:
        pass


scout_asset_api_SearchTypesQueryVisitor.__name__ = "SearchTypesQueryVisitor"
scout_asset_api_SearchTypesQueryVisitor.__qualname__ = "SearchTypesQueryVisitor"
scout_asset_api_SearchTypesQueryVisitor.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_SearchTypesRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'sort': ConjureFieldDefinition('sort', scout_asset_api_TypeSortOptions),
            'page_size': ConjureFieldDefinition('pageSize', OptionalTypeWrapper[int]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token]),
            'query': ConjureFieldDefinition('query', scout_asset_api_SearchTypesQuery),
            'archived_statuses': ConjureFieldDefinition('archivedStatuses', OptionalTypeWrapper[List[api_ArchivedStatus]])
        }

    __slots__: List[str] = ['_sort', '_page_size', '_next_page_token', '_query', '_archived_statuses']

    def __init__(self, query: "scout_asset_api_SearchTypesQuery", sort: "scout_asset_api_TypeSortOptions", archived_statuses: Optional[List["api_ArchivedStatus"]] = None, next_page_token: Optional[str] = None, page_size: Optional[int] = None) -> None:
        self._sort = sort
        self._page_size = page_size
        self._next_page_token = next_page_token
        self._query = query
        self._archived_statuses = archived_statuses

    @builtins.property
    def sort(self) -> "scout_asset_api_TypeSortOptions":
        return self._sort

    @builtins.property
    def page_size(self) -> Optional[int]:
        """Page sizes greater than 10_000 will be rejected. Default pageSize is 100.
        """
        return self._page_size

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token

    @builtins.property
    def query(self) -> "scout_asset_api_SearchTypesQuery":
        return self._query

    @builtins.property
    def archived_statuses(self) -> Optional[List["api_ArchivedStatus"]]:
        return self._archived_statuses


scout_asset_api_SearchTypesRequest.__name__ = "SearchTypesRequest"
scout_asset_api_SearchTypesRequest.__qualname__ = "SearchTypesRequest"
scout_asset_api_SearchTypesRequest.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_SearchTypesResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[scout_asset_api_Type]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_results', '_next_page_token']

    def __init__(self, results: List["scout_asset_api_Type"], next_page_token: Optional[str] = None) -> None:
        self._results = results
        self._next_page_token = next_page_token

    @builtins.property
    def results(self) -> List["scout_asset_api_Type"]:
        return self._results

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


scout_asset_api_SearchTypesResponse.__name__ = "SearchTypesResponse"
scout_asset_api_SearchTypesResponse.__qualname__ = "SearchTypesResponse"
scout_asset_api_SearchTypesResponse.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_SortKey(ConjureUnionType):
    _field: Optional["scout_asset_api_AssetSortField"] = None
    _property: Optional["scout_asset_api_SortProperty"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'field': ConjureFieldDefinition('field', scout_asset_api_AssetSortField),
            'property': ConjureFieldDefinition('property', scout_asset_api_SortProperty)
        }

    def __init__(
            self,
            field: Optional["scout_asset_api_AssetSortField"] = None,
            property: Optional["scout_asset_api_SortProperty"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (field is not None) + (property is not None) != 1:
                raise ValueError('a union must contain a single member')

            if field is not None:
                self._field = field
                self._type = 'field'
            if property is not None:
                self._property = property
                self._type = 'property'

        elif type_of_union == 'field':
            if field is None:
                raise ValueError('a union value must not be None')
            self._field = field
            self._type = 'field'
        elif type_of_union == 'property':
            if property is None:
                raise ValueError('a union value must not be None')
            self._property = property
            self._type = 'property'

    @builtins.property
    def field(self) -> Optional["scout_asset_api_AssetSortField"]:
        return self._field

    @builtins.property
    def property(self) -> Optional["scout_asset_api_SortProperty"]:
        return self._property

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, scout_asset_api_SortKeyVisitor):
            raise ValueError('{} is not an instance of scout_asset_api_SortKeyVisitor'.format(visitor.__class__.__name__))
        if self._type == 'field' and self.field is not None:
            return visitor._field(self.field)
        if self._type == 'property' and self.property is not None:
            return visitor._property(self.property)


scout_asset_api_SortKey.__name__ = "SortKey"
scout_asset_api_SortKey.__qualname__ = "SortKey"
scout_asset_api_SortKey.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_SortKeyVisitor:

    @abstractmethod
    def _field(self, field: "scout_asset_api_AssetSortField") -> Any:
        pass

    @abstractmethod
    def _property(self, property: "scout_asset_api_SortProperty") -> Any:
        pass


scout_asset_api_SortKeyVisitor.__name__ = "SortKeyVisitor"
scout_asset_api_SortKeyVisitor.__qualname__ = "SortKeyVisitor"
scout_asset_api_SortKeyVisitor.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_SortProperty(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', api_PropertyName)
        }

    __slots__: List[str] = ['_name']

    def __init__(self, name: str) -> None:
        self._name = name

    @builtins.property
    def name(self) -> str:
        return self._name


scout_asset_api_SortProperty.__name__ = "SortProperty"
scout_asset_api_SortProperty.__qualname__ = "SortProperty"
scout_asset_api_SortProperty.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_TagConfig(ConjureUnionType):
    _v1: Optional[List[str]] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'v1': ConjureFieldDefinition('v1', List[api_TagName])
        }

    def __init__(
            self,
            v1: Optional[List[str]] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (v1 is not None) != 1:
                raise ValueError('a union must contain a single member')

            if v1 is not None:
                self._v1 = v1
                self._type = 'v1'

        elif type_of_union == 'v1':
            if v1 is None:
                raise ValueError('a union value must not be None')
            self._v1 = v1
            self._type = 'v1'

    @builtins.property
    def v1(self) -> Optional[List[str]]:
        return self._v1

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, scout_asset_api_TagConfigVisitor):
            raise ValueError('{} is not an instance of scout_asset_api_TagConfigVisitor'.format(visitor.__class__.__name__))
        if self._type == 'v1' and self.v1 is not None:
            return visitor._v1(self.v1)


scout_asset_api_TagConfig.__name__ = "TagConfig"
scout_asset_api_TagConfig.__qualname__ = "TagConfig"
scout_asset_api_TagConfig.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_TagConfigVisitor:

    @abstractmethod
    def _v1(self, v1: List[str]) -> Any:
        pass


scout_asset_api_TagConfigVisitor.__name__ = "TagConfigVisitor"
scout_asset_api_TagConfigVisitor.__qualname__ = "TagConfigVisitor"
scout_asset_api_TagConfigVisitor.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_Type(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', scout_rids_api_TypeRid),
            'name': ConjureFieldDefinition('name', str),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'property_configs': ConjureFieldDefinition('propertyConfigs', Dict[api_PropertyName, scout_asset_api_PropertyConfig]),
            'created_at': ConjureFieldDefinition('createdAt', str),
            'icon_name': ConjureFieldDefinition('iconName', OptionalTypeWrapper[str]),
            'datasource_configs': ConjureFieldDefinition('datasourceConfigs', Dict[api_rids_DataSourceRid, scout_asset_api_AssetTypeDataScopeConfig])
        }

    __slots__: List[str] = ['_rid', '_name', '_description', '_property_configs', '_created_at', '_icon_name', '_datasource_configs']

    def __init__(self, created_at: str, datasource_configs: Dict[str, "scout_asset_api_AssetTypeDataScopeConfig"], name: str, property_configs: Dict[str, "scout_asset_api_PropertyConfig"], rid: str, description: Optional[str] = None, icon_name: Optional[str] = None) -> None:
        self._rid = rid
        self._name = name
        self._description = description
        self._property_configs = property_configs
        self._created_at = created_at
        self._icon_name = icon_name
        self._datasource_configs = datasource_configs

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def property_configs(self) -> Dict[str, "scout_asset_api_PropertyConfig"]:
        return self._property_configs

    @builtins.property
    def created_at(self) -> str:
        return self._created_at

    @builtins.property
    def icon_name(self) -> Optional[str]:
        """The name of the icon to display for the type. This name maps to a Lucide icon in the frontend.
        """
        return self._icon_name

    @builtins.property
    def datasource_configs(self) -> Dict[str, "scout_asset_api_AssetTypeDataScopeConfig"]:
        """The configuration outlines what a data scope should provide when added to an asset of this type. It is 
referenced at data scope creation time, but does not actively modify existing data scopes.
        """
        return self._datasource_configs


scout_asset_api_Type.__name__ = "Type"
scout_asset_api_Type.__qualname__ = "Type"
scout_asset_api_Type.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_TypeSortField(ConjureEnumType):

    CREATED_AT = 'CREATED_AT'
    '''CREATED_AT'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


scout_asset_api_TypeSortField.__name__ = "TypeSortField"
scout_asset_api_TypeSortField.__qualname__ = "TypeSortField"
scout_asset_api_TypeSortField.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_TypeSortOptions(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'is_descending': ConjureFieldDefinition('isDescending', bool),
            'field': ConjureFieldDefinition('field', scout_asset_api_TypeSortField)
        }

    __slots__: List[str] = ['_is_descending', '_field']

    def __init__(self, field: "scout_asset_api_TypeSortField", is_descending: bool) -> None:
        self._is_descending = is_descending
        self._field = field

    @builtins.property
    def is_descending(self) -> bool:
        return self._is_descending

    @builtins.property
    def field(self) -> "scout_asset_api_TypeSortField":
        return self._field


scout_asset_api_TypeSortOptions.__name__ = "TypeSortOptions"
scout_asset_api_TypeSortOptions.__qualname__ = "TypeSortOptions"
scout_asset_api_TypeSortOptions.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_UpdateAssetRefNamesRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'data_scope_ref_name_updates': ConjureFieldDefinition('dataScopeRefNameUpdates', Dict[scout_api_DataSourceRefName, scout_api_DataSourceRefName])
        }

    __slots__: List[str] = ['_data_scope_ref_name_updates']

    def __init__(self, data_scope_ref_name_updates: Dict[str, str]) -> None:
        self._data_scope_ref_name_updates = data_scope_ref_name_updates

    @builtins.property
    def data_scope_ref_name_updates(self) -> Dict[str, str]:
        return self._data_scope_ref_name_updates


scout_asset_api_UpdateAssetRefNamesRequest.__name__ = "UpdateAssetRefNamesRequest"
scout_asset_api_UpdateAssetRefNamesRequest.__qualname__ = "UpdateAssetRefNamesRequest"
scout_asset_api_UpdateAssetRefNamesRequest.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_UpdateAssetRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'title': ConjureFieldDefinition('title', OptionalTypeWrapper[str]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'properties': ConjureFieldDefinition('properties', OptionalTypeWrapper[Dict[api_PropertyName, api_PropertyValue]]),
            'labels': ConjureFieldDefinition('labels', OptionalTypeWrapper[List[api_Label]]),
            'links': ConjureFieldDefinition('links', OptionalTypeWrapper[List[scout_run_api_Link]]),
            'data_scopes': ConjureFieldDefinition('dataScopes', OptionalTypeWrapper[List[scout_asset_api_CreateAssetDataScope]]),
            'type': ConjureFieldDefinition('type', OptionalTypeWrapper[scout_asset_api_UpdateOrRemoveAssetType]),
            'is_staged': ConjureFieldDefinition('isStaged', OptionalTypeWrapper[bool])
        }

    __slots__: List[str] = ['_title', '_description', '_properties', '_labels', '_links', '_data_scopes', '_type', '_is_staged']

    def __init__(self, data_scopes: Optional[List["scout_asset_api_CreateAssetDataScope"]] = None, description: Optional[str] = None, is_staged: Optional[bool] = None, labels: Optional[List[str]] = None, links: Optional[List["scout_run_api_Link"]] = None, properties: Optional[Dict[str, str]] = None, title: Optional[str] = None, type: Optional["scout_asset_api_UpdateOrRemoveAssetType"] = None) -> None:
        self._title = title
        self._description = description
        self._properties = properties
        self._labels = labels
        self._links = links
        self._data_scopes = data_scopes
        self._type = type
        self._is_staged = is_staged

    @builtins.property
    def title(self) -> Optional[str]:
        return self._title

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def properties(self) -> Optional[Dict[str, str]]:
        return self._properties

    @builtins.property
    def labels(self) -> Optional[List[str]]:
        return self._labels

    @builtins.property
    def links(self) -> Optional[List["scout_run_api_Link"]]:
        return self._links

    @builtins.property
    def data_scopes(self) -> Optional[List["scout_asset_api_CreateAssetDataScope"]]:
        """The data scopes for the asset. This will replace all existing data scopes with the scopes specified.
        """
        return self._data_scopes

    @builtins.property
    def type(self) -> Optional["scout_asset_api_UpdateOrRemoveAssetType"]:
        return self._type

    @builtins.property
    def is_staged(self) -> Optional[bool]:
        return self._is_staged


scout_asset_api_UpdateAssetRequest.__name__ = "UpdateAssetRequest"
scout_asset_api_UpdateAssetRequest.__qualname__ = "UpdateAssetRequest"
scout_asset_api_UpdateAssetRequest.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_UpdateAttachmentsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'attachments_to_add': ConjureFieldDefinition('attachmentsToAdd', List[api_rids_AttachmentRid]),
            'attachments_to_remove': ConjureFieldDefinition('attachmentsToRemove', List[api_rids_AttachmentRid])
        }

    __slots__: List[str] = ['_attachments_to_add', '_attachments_to_remove']

    def __init__(self, attachments_to_add: List[str], attachments_to_remove: List[str]) -> None:
        self._attachments_to_add = attachments_to_add
        self._attachments_to_remove = attachments_to_remove

    @builtins.property
    def attachments_to_add(self) -> List[str]:
        return self._attachments_to_add

    @builtins.property
    def attachments_to_remove(self) -> List[str]:
        return self._attachments_to_remove


scout_asset_api_UpdateAttachmentsRequest.__name__ = "UpdateAttachmentsRequest"
scout_asset_api_UpdateAttachmentsRequest.__qualname__ = "UpdateAttachmentsRequest"
scout_asset_api_UpdateAttachmentsRequest.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_UpdateOrRemoveAssetType(ConjureUnionType):
    """The request to update the type of the asset. The request will replace the existing type with the type
specified in the request if a typeRID is provided. Otherwise, the type will be removed from the asset.
    """
    _type_rid: Optional[str] = None
    _remove_type: Optional["scout_asset_api_RemoveType"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'type_rid': ConjureFieldDefinition('typeRid', scout_rids_api_TypeRid),
            'remove_type': ConjureFieldDefinition('removeType', scout_asset_api_RemoveType)
        }

    def __init__(
            self,
            type_rid: Optional[str] = None,
            remove_type: Optional["scout_asset_api_RemoveType"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (type_rid is not None) + (remove_type is not None) != 1:
                raise ValueError('a union must contain a single member')

            if type_rid is not None:
                self._type_rid = type_rid
                self._type = 'typeRid'
            if remove_type is not None:
                self._remove_type = remove_type
                self._type = 'removeType'

        elif type_of_union == 'typeRid':
            if type_rid is None:
                raise ValueError('a union value must not be None')
            self._type_rid = type_rid
            self._type = 'typeRid'
        elif type_of_union == 'removeType':
            if remove_type is None:
                raise ValueError('a union value must not be None')
            self._remove_type = remove_type
            self._type = 'removeType'

    @builtins.property
    def type_rid(self) -> Optional[str]:
        return self._type_rid

    @builtins.property
    def remove_type(self) -> Optional["scout_asset_api_RemoveType"]:
        return self._remove_type

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, scout_asset_api_UpdateOrRemoveAssetTypeVisitor):
            raise ValueError('{} is not an instance of scout_asset_api_UpdateOrRemoveAssetTypeVisitor'.format(visitor.__class__.__name__))
        if self._type == 'typeRid' and self.type_rid is not None:
            return visitor._type_rid(self.type_rid)
        if self._type == 'removeType' and self.remove_type is not None:
            return visitor._remove_type(self.remove_type)


scout_asset_api_UpdateOrRemoveAssetType.__name__ = "UpdateOrRemoveAssetType"
scout_asset_api_UpdateOrRemoveAssetType.__qualname__ = "UpdateOrRemoveAssetType"
scout_asset_api_UpdateOrRemoveAssetType.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_UpdateOrRemoveAssetTypeVisitor:

    @abstractmethod
    def _type_rid(self, type_rid: str) -> Any:
        pass

    @abstractmethod
    def _remove_type(self, remove_type: "scout_asset_api_RemoveType") -> Any:
        pass


scout_asset_api_UpdateOrRemoveAssetTypeVisitor.__name__ = "UpdateOrRemoveAssetTypeVisitor"
scout_asset_api_UpdateOrRemoveAssetTypeVisitor.__qualname__ = "UpdateOrRemoveAssetTypeVisitor"
scout_asset_api_UpdateOrRemoveAssetTypeVisitor.__module__ = "nominal_api.scout_asset_api"


class scout_asset_api_UpdateTypeRequest(ConjureBeanType):
    """The request to update a type. The request will replace all existing properties with the properties
specified in the request.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', OptionalTypeWrapper[str]),
            'property_configs': ConjureFieldDefinition('propertyConfigs', OptionalTypeWrapper[Dict[api_PropertyName, scout_asset_api_PropertyConfig]]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'icon_name': ConjureFieldDefinition('iconName', OptionalTypeWrapper[str]),
            'datasource_configs': ConjureFieldDefinition('datasourceConfigs', OptionalTypeWrapper[Dict[api_rids_DataSourceRid, scout_asset_api_AssetTypeDataScopeConfig]])
        }

    __slots__: List[str] = ['_name', '_property_configs', '_description', '_icon_name', '_datasource_configs']

    def __init__(self, datasource_configs: Optional[Dict[str, "scout_asset_api_AssetTypeDataScopeConfig"]] = None, description: Optional[str] = None, icon_name: Optional[str] = None, name: Optional[str] = None, property_configs: Optional[Dict[str, "scout_asset_api_PropertyConfig"]] = None) -> None:
        self._name = name
        self._property_configs = property_configs
        self._description = description
        self._icon_name = icon_name
        self._datasource_configs = datasource_configs

    @builtins.property
    def name(self) -> Optional[str]:
        return self._name

    @builtins.property
    def property_configs(self) -> Optional[Dict[str, "scout_asset_api_PropertyConfig"]]:
        return self._property_configs

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def icon_name(self) -> Optional[str]:
        return self._icon_name

    @builtins.property
    def datasource_configs(self) -> Optional[Dict[str, "scout_asset_api_AssetTypeDataScopeConfig"]]:
        """The configuration outlines what a data scope should provide when added to an asset of this type. It is 
referenced at data scope creation time, but does not actively modify existing data scopes.
        """
        return self._datasource_configs


scout_asset_api_UpdateTypeRequest.__name__ = "UpdateTypeRequest"
scout_asset_api_UpdateTypeRequest.__qualname__ = "UpdateTypeRequest"
scout_asset_api_UpdateTypeRequest.__module__ = "nominal_api.scout_asset_api"


class scout_assets_AssetService(Service):
    """An asset is a physical entity within an organization, such as a vehicle or ground station. Assets are comprised
of some metadata about the data, as well as a set of data scopes that define the data belonging to the asset. API
endpoints allow for CRUD operations on asset objects.
    """

    def create_asset(self, auth_header: str, details: "scout_asset_api_CreateAssetRequest") -> "scout_asset_api_Asset":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(details)

        _path = '/scout/v1/asset'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_asset_api_Asset, self._return_none_for_unknown_union_types)

    def update_asset(self, auth_header: str, details: "scout_asset_api_UpdateAssetRequest", rid: str) -> "scout_asset_api_Asset":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(details)

        _path = '/scout/v1/asset/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_asset_api_Asset, self._return_none_for_unknown_union_types)

    def add_data_scopes_to_asset(self, asset_rid: str, auth_header: str, request: "scout_asset_api_AddDataScopesToAssetRequest") -> "scout_asset_api_Asset":
        """Adds data scopes to an asset.

Throws if the asset already has data scopes with data scope names matching those in the request.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'assetRid': quote(str(_conjure_encoder.default(asset_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/asset/{assetRid}/data-sources'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_asset_api_Asset, self._return_none_for_unknown_union_types)

    def get_assets(self, auth_header: str, rids: List[str] = None) -> Dict[str, "scout_asset_api_Asset"]:
        rids = rids if rids is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(rids)

        _path = '/scout/v1/asset/multiple'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), Dict[scout_rids_api_AssetRid, scout_asset_api_Asset], self._return_none_for_unknown_union_types)

    def get_assets_by_data_source(self, auth_header: str, data_source_rid: str) -> List["scout_asset_api_Asset"]:
        """Returns all assets with given data source as a data scope.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'dataSourceRid': quote(str(_conjure_encoder.default(data_source_rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/asset/by-data-source/{dataSourceRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_asset_api_Asset], self._return_none_for_unknown_union_types)

    def archive(self, auth_header: str, rid: str, include_linked_workbooks: Optional[bool] = None) -> None:
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'includeLinkedWorkbooks': _conjure_encoder.default(include_linked_workbooks),
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/archive/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def unarchive(self, auth_header: str, rid: str, include_linked_workbooks: Optional[bool] = None) -> None:
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'includeLinkedWorkbooks': _conjure_encoder.default(include_linked_workbooks),
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/unarchive/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def search_assets(self, auth_header: str, search_assets_request: "scout_asset_api_SearchAssetsRequest") -> "scout_asset_api_SearchAssetsResponse":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(search_assets_request)

        _path = '/scout/v1/search-assets'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_asset_api_SearchAssetsResponse, self._return_none_for_unknown_union_types)

    def search_types(self, auth_header: str, search_types_request: "scout_asset_api_SearchTypesRequest") -> "scout_asset_api_SearchTypesResponse":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(search_types_request)

        _path = '/scout/v1/search-types'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_asset_api_SearchTypesResponse, self._return_none_for_unknown_union_types)

    def update_asset_attachments(self, auth_header: str, request: "scout_asset_api_UpdateAttachmentsRequest", rid: str) -> None:
        """Update the attachments associated with an asset.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/asset/{rid}/attachments'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def update_asset_ref_names(self, auth_header: str, request: "scout_asset_api_UpdateAssetRefNamesRequest", rid: str) -> None:
        """Update the ref names for the data scopes on the asset. This update will also be applied on all associated 
workbooks.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/asset/{rid}/ref-names'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def create_type(self, auth_header: str, request: "scout_asset_api_CreateTypeRequest") -> "scout_asset_api_Type":
        """Creates a new type.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/type'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_asset_api_Type, self._return_none_for_unknown_union_types)

    def update_type(self, auth_header: str, request: "scout_asset_api_UpdateTypeRequest", type_rid: str) -> "scout_asset_api_Type":
        """Updates a type. Will throw unless all assets that reference the type pass the updated type check.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'typeRid': quote(str(_conjure_encoder.default(type_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/scout/v1/type/{typeRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_asset_api_Type, self._return_none_for_unknown_union_types)

    def get_types(self, auth_header: str, rids: List[str] = None) -> Dict[str, "scout_asset_api_Type"]:
        rids = rids if rids is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(rids)

        _path = '/scout/v1/type/multiple'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), Dict[scout_rids_api_TypeRid, scout_asset_api_Type], self._return_none_for_unknown_union_types)

    def get_types_for_datasource(self, auth_header: str, datasource_rid: str) -> List["scout_asset_api_Type"]:
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(datasource_rid)

        _path = '/scout/v1/type/datasource'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_asset_api_Type], self._return_none_for_unknown_union_types)

    def delete_type(self, auth_header: str, rid: str) -> None:
        """Deletes a type. The type must not be referenced by any assets.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/type/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'DELETE',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def archive_type(self, auth_header: str, rid: str) -> None:
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/type/archive/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def unarchive_type(self, auth_header: str, rid: str) -> None:
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = None

        _path = '/scout/v1/type/unarchive/{rid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return


scout_assets_AssetService.__name__ = "AssetService"
scout_assets_AssetService.__qualname__ = "AssetService"
scout_assets_AssetService.__module__ = "nominal_api.scout_assets"


class scout_catalog_AbsoluteTimestamp(ConjureUnionType):
    _iso8601: Optional["scout_catalog_Iso8601Timestamp"] = None
    _epoch_of_time_unit: Optional["scout_catalog_EpochTimestamp"] = None
    _custom_format: Optional["scout_catalog_CustomTimestamp"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'iso8601': ConjureFieldDefinition('iso8601', scout_catalog_Iso8601Timestamp),
            'epoch_of_time_unit': ConjureFieldDefinition('epochOfTimeUnit', scout_catalog_EpochTimestamp),
            'custom_format': ConjureFieldDefinition('customFormat', scout_catalog_CustomTimestamp)
        }

    def __init__(
            self,
            iso8601: Optional["scout_catalog_Iso8601Timestamp"] = None,
            epoch_of_time_unit: Optional["scout_catalog_EpochTimestamp"] = None,
            custom_format: Optional["scout_catalog_CustomTimestamp"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (iso8601 is not None) + (epoch_of_time_unit is not None) + (custom_format is not None) != 1:
                raise ValueError('a union must contain a single member')

            if iso8601 is not None:
                self._iso8601 = iso8601
                self._type = 'iso8601'
            if epoch_of_time_unit is not None:
                self._epoch_of_time_unit = epoch_of_time_unit
                self._type = 'epochOfTimeUnit'
            if custom_format is not None:
                self._custom_format = custom_format
                self._type = 'customFormat'

        elif type_of_union == 'iso8601':
            if iso8601 is None:
                raise ValueError('a union value must not be None')
            self._iso8601 = iso8601
            self._type = 'iso8601'
        elif type_of_union == 'epochOfTimeUnit':
            if epoch_of_time_unit is None:
                raise ValueError('a union value must not be None')
            self._epoch_of_time_unit = epoch_of_time_unit
            self._type = 'epochOfTimeUnit'
        elif type_of_union == 'customFormat':
            if custom_format is None:
                raise ValueError('a union value must not be None')
            self._custom_format = custom_format
            self._type = 'customFormat'

    @builtins.property
    def iso8601(self) -> Optional["scout_catalog_Iso8601Timestamp"]:
        return self._iso8601

    @builtins.property
    def epoch_of_time_unit(self) -> Optional["scout_catalog_EpochTimestamp"]:
        return self._epoch_of_time_unit

    @builtins.property
    def custom_format(self) -> Optional["scout_catalog_CustomTimestamp"]:
        return self._custom_format

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, scout_catalog_AbsoluteTimestampVisitor):
            raise ValueError('{} is not an instance of scout_catalog_AbsoluteTimestampVisitor'.format(visitor.__class__.__name__))
        if self._type == 'iso8601' and self.iso8601 is not None:
            return visitor._iso8601(self.iso8601)
        if self._type == 'epochOfTimeUnit' and self.epoch_of_time_unit is not None:
            return visitor._epoch_of_time_unit(self.epoch_of_time_unit)
        if self._type == 'customFormat' and self.custom_format is not None:
            return visitor._custom_format(self.custom_format)


scout_catalog_AbsoluteTimestamp.__name__ = "AbsoluteTimestamp"
scout_catalog_AbsoluteTimestamp.__qualname__ = "AbsoluteTimestamp"
scout_catalog_AbsoluteTimestamp.__module__ = "nominal_api.scout_catalog"


class scout_catalog_AbsoluteTimestampVisitor:

    @abstractmethod
    def _iso8601(self, iso8601: "scout_catalog_Iso8601Timestamp") -> Any:
        pass

    @abstractmethod
    def _epoch_of_time_unit(self, epoch_of_time_unit: "scout_catalog_EpochTimestamp") -> Any:
        pass

    @abstractmethod
    def _custom_format(self, custom_format: "scout_catalog_CustomTimestamp") -> Any:
        pass


scout_catalog_AbsoluteTimestampVisitor.__name__ = "AbsoluteTimestampVisitor"
scout_catalog_AbsoluteTimestampVisitor.__qualname__ = "AbsoluteTimestampVisitor"
scout_catalog_AbsoluteTimestampVisitor.__module__ = "nominal_api.scout_catalog"


class scout_catalog_AddFileToDataset(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'handle': ConjureFieldDefinition('handle', scout_catalog_Handle),
            'file_size': ConjureFieldDefinition('fileSize', int),
            'timestamp_metadata': ConjureFieldDefinition('timestampMetadata', OptionalTypeWrapper[scout_catalog_TimestampMetadata]),
            'ingest_tag_metadata': ConjureFieldDefinition('ingestTagMetadata', OptionalTypeWrapper[scout_catalog_IngestTagMetadata]),
            'origin_file_handles': ConjureFieldDefinition('originFileHandles', OptionalTypeWrapper[List[scout_catalog_S3Handle]]),
            'ingest_job_rid': ConjureFieldDefinition('ingestJobRid', OptionalTypeWrapper[ingest_api_IngestJobRid])
        }

    __slots__: List[str] = ['_handle', '_file_size', '_timestamp_metadata', '_ingest_tag_metadata', '_origin_file_handles', '_ingest_job_rid']

    def __init__(self, file_size: int, handle: "scout_catalog_Handle", ingest_job_rid: Optional[str] = None, ingest_tag_metadata: Optional["scout_catalog_IngestTagMetadata"] = None, origin_file_handles: Optional[List["scout_catalog_S3Handle"]] = None, timestamp_metadata: Optional["scout_catalog_TimestampMetadata"] = None) -> None:
        self._handle = handle
        self._file_size = file_size
        self._timestamp_metadata = timestamp_metadata
        self._ingest_tag_metadata = ingest_tag_metadata
        self._origin_file_handles = origin_file_handles
        self._ingest_job_rid = ingest_job_rid

    @builtins.property
    def handle(self) -> "scout_catalog_Handle":
        return self._handle

    @builtins.property
    def file_size(self) -> int:
        """The size of the file in bytes.
        """
        return self._file_size

    @builtins.property
    def timestamp_metadata(self) -> Optional["scout_catalog_TimestampMetadata"]:
        return self._timestamp_metadata

    @builtins.property
    def ingest_tag_metadata(self) -> Optional["scout_catalog_IngestTagMetadata"]:
        return self._ingest_tag_metadata

    @builtins.property
    def origin_file_handles(self) -> Optional[List["scout_catalog_S3Handle"]]:
        return self._origin_file_handles

    @builtins.property
    def ingest_job_rid(self) -> Optional[str]:
        return self._ingest_job_rid


scout_catalog_AddFileToDataset.__name__ = "AddFileToDataset"
scout_catalog_AddFileToDataset.__qualname__ = "AddFileToDataset"
scout_catalog_AddFileToDataset.__module__ = "nominal_api.scout_catalog"


class scout_catalog_AllPropertiesAndLabelsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, List[api_PropertyValue]]),
            'labels': ConjureFieldDefinition('labels', List[api_Label])
        }

    __slots__: List[str] = ['_properties', '_labels']

    def __init__(self, labels: List[str], properties: Dict[str, List[str]]) -> None:
        self._properties = properties
        self._labels = labels

    @builtins.property
    def properties(self) -> Dict[str, List[str]]:
        return self._properties

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels


scout_catalog_AllPropertiesAndLabelsResponse.__name__ = "AllPropertiesAndLabelsResponse"
scout_catalog_AllPropertiesAndLabelsResponse.__qualname__ = "AllPropertiesAndLabelsResponse"
scout_catalog_AllPropertiesAndLabelsResponse.__module__ = "nominal_api.scout_catalog"


class scout_catalog_Bounds(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'start': ConjureFieldDefinition('start', api_Timestamp),
            'end': ConjureFieldDefinition('end', api_Timestamp),
            'type': ConjureFieldDefinition('type', datasource_TimestampType)
        }

    __slots__: List[str] = ['_start', '_end', '_type']

    def __init__(self, end: "api_Timestamp", start: "api_Timestamp", type: "datasource_TimestampType") -> None:
        self._start = start
        self._end = end
        self._type = type

    @builtins.property
    def start(self) -> "api_Timestamp":
        return self._start

    @builtins.property
    def end(self) -> "api_Timestamp":
        return self._end

    @builtins.property
    def type(self) -> "datasource_TimestampType":
        return self._type


scout_catalog_Bounds.__name__ = "Bounds"
scout_catalog_Bounds.__qualname__ = "Bounds"
scout_catalog_Bounds.__module__ = "nominal_api.scout_catalog"


class scout_catalog_CatalogService(Service):
    """The Catalog Service provides the ability to query for information about Datasets that are stored in
the Nominal platform. A Dataset is the Nominal representation of data that has been uploaded to Nominal via
a file, primarily CSV.
    """

    def get_enriched_dataset(self, auth_header: str, dataset_uuid: str) -> "scout_catalog_EnrichedDataset":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'datasetUuid': quote(str(_conjure_encoder.default(dataset_uuid)), safe=''),
        }

        _json: Any = None

        _path = '/catalog/v1/datasets/{datasetUuid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_EnrichedDataset, self._return_none_for_unknown_union_types)

    def get_enriched_datasets(self, auth_header: str, get_datasets_request: "scout_catalog_GetDatasetsRequest") -> List["scout_catalog_EnrichedDataset"]:
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(get_datasets_request)

        _path = '/catalog/v1/datasets/multiple'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_catalog_EnrichedDataset], self._return_none_for_unknown_union_types)

    def get_dataset(self, auth_header: str, dataset_uuid: str) -> "scout_catalog_Dataset":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'datasetUuid': quote(str(_conjure_encoder.default(dataset_uuid)), safe=''),
        }

        _json: Any = None

        _path = '/catalog/v1/datasets-simple/{datasetUuid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_Dataset, self._return_none_for_unknown_union_types)

    def get_datasets(self, auth_header: str, get_datasets_request: "scout_catalog_GetDatasetsRequest") -> List["scout_catalog_Dataset"]:
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(get_datasets_request)

        _path = '/catalog/v1/datasets-simple/multiple'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_catalog_Dataset], self._return_none_for_unknown_union_types)

    def get_dataset_file(self, auth_header: str, dataset_rid: str, file_id: str) -> "scout_catalog_DatasetFile":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'datasetRid': quote(str(_conjure_encoder.default(dataset_rid)), safe=''),
            'fileId': quote(str(_conjure_encoder.default(file_id)), safe=''),
        }

        _json: Any = None

        _path = '/catalog/v1/dataset/{datasetRid}/file/{fileId}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_DatasetFile, self._return_none_for_unknown_union_types)

    def get_dataset_files_for_job(self, auth_header: str, ingest_job_rid: str, next_page_token: Optional[str] = None) -> "scout_catalog_DatasetFilesPage":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'nextPageToken': _conjure_encoder.default(next_page_token),
        }

        _path_params: Dict[str, str] = {
            'ingestJobRid': quote(str(_conjure_encoder.default(ingest_job_rid)), safe=''),
        }

        _json: Any = None

        _path = '/catalog/v1/ingest-job/{ingestJobRid}/files'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_DatasetFilesPage, self._return_none_for_unknown_union_types)

    def search_datasets(self, auth_header: str, request: "scout_catalog_SearchDatasetsRequest") -> "scout_catalog_SearchDatasetsResponse":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/catalog/v1/search-datasets-v2'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_SearchDatasetsResponse, self._return_none_for_unknown_union_types)

    def update_dataset_ingest_status_v2(self, auth_header: str, details: "scout_catalog_UpdateIngestStatusV2") -> "api_IngestStatusV2":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(details)

        _path = '/catalog/v1/datasets/ingest-status-v2'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), api_IngestStatusV2, self._return_none_for_unknown_union_types)

    def get_ingest_progress_v2(self, auth_header: str, dataset_rid: str) -> "scout_catalog_IngestProgressV2":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'datasetRid': quote(str(_conjure_encoder.default(dataset_rid)), safe=''),
        }

        _json: Any = None

        _path = '/catalog/v1/datasets/{datasetRid}/ingest-progress-v2'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_IngestProgressV2, self._return_none_for_unknown_union_types)

    def get_handle_for_dataset(self, auth_header: str, dataset: str) -> Optional["scout_catalog_Handle"]:
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'dataset': quote(str(_conjure_encoder.default(dataset)), safe=''),
        }

        _json: Any = None

        _path = '/catalog/v1/datasets/{dataset}/handle'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return None if _response.status_code == 204 else _decoder.decode(_response.json(), OptionalTypeWrapper[scout_catalog_Handle], self._return_none_for_unknown_union_types)

    def create_dataset(self, auth_header: str, details: "scout_catalog_CreateDataset") -> "scout_catalog_EnrichedDataset":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(details)

        _path = '/catalog/v1/datasets'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_EnrichedDataset, self._return_none_for_unknown_union_types)

    def create_or_update_dataset(self, auth_header: str, details: "scout_catalog_CreateDataset") -> "scout_catalog_EnrichedDataset":
        """Creates a dataset if the s3 path does not exist, otherwise updates the dataset
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(details)

        _path = '/catalog/v1/datasets/create-or-update'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_EnrichedDataset, self._return_none_for_unknown_union_types)

    def add_file_to_dataset(self, auth_header: str, dataset_rid: str, request: "scout_catalog_AddFileToDataset") -> "scout_catalog_DatasetFile":
        """Adds a single file to an existing dataset.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'datasetRid': quote(str(_conjure_encoder.default(dataset_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/catalog/v1/datasets/{datasetRid}/add-file'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_DatasetFile, self._return_none_for_unknown_union_types)

    def list_dataset_files(self, auth_header: str, dataset_rid: str, next_page_token: Optional[str] = None) -> "scout_catalog_DatasetFilesPage":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'nextPageToken': _conjure_encoder.default(next_page_token),
        }

        _path_params: Dict[str, str] = {
            'datasetRid': quote(str(_conjure_encoder.default(dataset_rid)), safe=''),
        }

        _json: Any = None

        _path = '/catalog/v1/datasets/{datasetRid}/files'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_DatasetFilesPage, self._return_none_for_unknown_union_types)

    def search_dataset_files(self, auth_header: str, request: "scout_catalog_SearchDatasetFilesRequest") -> "scout_catalog_SearchDatasetFilesResponse":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/catalog/v1/search-dataset-files'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_SearchDatasetFilesResponse, self._return_none_for_unknown_union_types)

    def get_dataset_file_uri(self, auth_header: str, dataset_rid: str, file_id: str) -> "scout_catalog_DatasetFileUri":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'datasetRid': quote(str(_conjure_encoder.default(dataset_rid)), safe=''),
            'fileId': quote(str(_conjure_encoder.default(file_id)), safe=''),
        }

        _json: Any = None

        _path = '/catalog/v1/datasets/{datasetRid}/{fileId}/uri'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_DatasetFileUri, self._return_none_for_unknown_union_types)

    def get_origin_file_uris(self, auth_header: str, dataset_rid: str, file_id: str) -> List["scout_catalog_OriginFileUri"]:
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'datasetRid': quote(str(_conjure_encoder.default(dataset_rid)), safe=''),
            'fileId': quote(str(_conjure_encoder.default(file_id)), safe=''),
        }

        _json: Any = None

        _path = '/catalog/v1/datasets/{datasetRid}/{fileId}/origin-uris'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), List[scout_catalog_OriginFileUri], self._return_none_for_unknown_union_types)

    def mark_file_ingest_successful(self, auth_header: str, dataset_rid: str, file_id: str, request: "scout_catalog_MarkFileIngestSuccessful") -> "scout_catalog_DatasetFile":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'datasetRid': quote(str(_conjure_encoder.default(dataset_rid)), safe=''),
            'fileId': quote(str(_conjure_encoder.default(file_id)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/catalog/v1/datasets/{datasetRid}/file/{fileId}/success'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_DatasetFile, self._return_none_for_unknown_union_types)

    def mark_file_ingest_error(self, auth_header: str, dataset_rid: str, file_id: str, request: "scout_catalog_MarkFileIngestError") -> "scout_catalog_DatasetFile":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'datasetRid': quote(str(_conjure_encoder.default(dataset_rid)), safe=''),
            'fileId': quote(str(_conjure_encoder.default(file_id)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/catalog/v1/datasets/{datasetRid}/file/{fileId}/error'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_DatasetFile, self._return_none_for_unknown_union_types)

    def update_dataset_metadata(self, auth_header: str, dataset_rid: str, request: "scout_catalog_UpdateDatasetMetadata") -> "scout_catalog_EnrichedDataset":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'datasetRid': quote(str(_conjure_encoder.default(dataset_rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/catalog/v1/datasets/{datasetRid}'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_EnrichedDataset, self._return_none_for_unknown_union_types)

    def update_bounds(self, auth_header: str, request: "scout_catalog_UpdateBoundsRequest", rid: str) -> "scout_catalog_EnrichedDataset":
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/catalog/v1/datasets/{rid}/bounds'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_EnrichedDataset, self._return_none_for_unknown_union_types)

    def update_global_dataset_bounds(self, auth_header: str, request: "scout_catalog_UpdateBoundsRequest", rid: str) -> "scout_catalog_Dataset":
        """Update the bounds for a dataset without updating bounds of files within the dataset. If the
current bounds of the dataset are not set, then the bounds of the request will be used. Otherwise,
the bounds will be min(current start, request start), max(current end, request end).
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'rid': quote(str(_conjure_encoder.default(rid)), safe=''),
        }

        _json: Any = _conjure_encoder.default(request)

        _path = '/catalog/v1/datasets/{rid}/bounds-from-streaming'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'PUT',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_Dataset, self._return_none_for_unknown_union_types)

    def archive_dataset(self, auth_header: str, dataset_rid: str) -> None:
        """Archives a dataset, which will hide it from search results unless the includeArchived flag is set to true. The
dataset can still be directly accessed by its UUID/rid.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'datasetRid': quote(str(_conjure_encoder.default(dataset_rid)), safe=''),
        }

        _json: Any = None

        _path = '/catalog/v1/datasets/{datasetRid}/archive'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def unarchive_dataset(self, auth_header: str, dataset_rid: str) -> None:
        """Undoes the archiving of a dataset.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'datasetRid': quote(str(_conjure_encoder.default(dataset_rid)), safe=''),
        }

        _json: Any = None

        _path = '/catalog/v1/datasets/{datasetRid}/unarchive'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'POST',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        return

    def get_all_properties_and_labels(self, auth_header: str, workspaces: List[str] = None) -> "scout_catalog_AllPropertiesAndLabelsResponse":
        workspaces = workspaces if workspaces is not None else []
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
            'workspaces': _conjure_encoder.default(workspaces),
        }

        _path_params: Dict[str, str] = {
        }

        _json: Any = None

        _path = '/catalog/v1/datasets/all-properties-labels'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return _decoder.decode(_response.json(), scout_catalog_AllPropertiesAndLabelsResponse, self._return_none_for_unknown_union_types)

    def get_log_dataset_for_workspace(self, auth_header: str, workspace_rid: str) -> Optional[str]:
        """Returns the log dataset RID for the specified workspace if configured and accessible to the caller.
        """
        _conjure_encoder = ConjureEncoder()

        _headers: Dict[str, Any] = {
            'Accept': 'application/json',
            'Authorization': auth_header,
        }

        _params: Dict[str, Any] = {
        }

        _path_params: Dict[str, str] = {
            'workspaceRid': quote(str(_conjure_encoder.default(workspace_rid)), safe=''),
        }

        _json: Any = None

        _path = '/catalog/v1/workspaces/{workspaceRid}/log-dataset'
        _path = _path.format(**_path_params)

        _response: Response = self._request(
            'GET',
            self._uri + _path,
            params=_params,
            headers=_headers,
            json=_json)

        _decoder = ConjureDecoder()
        return None if _response.status_code == 204 else _decoder.decode(_response.json(), OptionalTypeWrapper[api_rids_DatasetRid], self._return_none_for_unknown_union_types)


scout_catalog_CatalogService.__name__ = "CatalogService"
scout_catalog_CatalogService.__qualname__ = "CatalogService"
scout_catalog_CatalogService.__module__ = "nominal_api.scout_catalog"


class scout_catalog_Channel(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'uuid': ConjureFieldDefinition('uuid', str),
            'name': ConjureFieldDefinition('name', str),
            'dataset_uuid': ConjureFieldDefinition('datasetUuid', str)
        }

    __slots__: List[str] = ['_uuid', '_name', '_dataset_uuid']

    def __init__(self, dataset_uuid: str, name: str, uuid: str) -> None:
        self._uuid = uuid
        self._name = name
        self._dataset_uuid = dataset_uuid

    @builtins.property
    def uuid(self) -> str:
        return self._uuid

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def dataset_uuid(self) -> str:
        return self._dataset_uuid


scout_catalog_Channel.__name__ = "Channel"
scout_catalog_Channel.__qualname__ = "Channel"
scout_catalog_Channel.__module__ = "nominal_api.scout_catalog"


class scout_catalog_ChannelConfig(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'prefix_tree_delimiter': ConjureFieldDefinition('prefixTreeDelimiter', OptionalTypeWrapper[str])
        }

    __slots__: List[str] = ['_prefix_tree_delimiter']

    def __init__(self, prefix_tree_delimiter: Optional[str] = None) -> None:
        self._prefix_tree_delimiter = prefix_tree_delimiter

    @builtins.property
    def prefix_tree_delimiter(self) -> Optional[str]:
        """If set, will construct a prefix tree for channels of the dataset using the given delimiter.
        """
        return self._prefix_tree_delimiter


scout_catalog_ChannelConfig.__name__ = "ChannelConfig"
scout_catalog_ChannelConfig.__qualname__ = "ChannelConfig"
scout_catalog_ChannelConfig.__module__ = "nominal_api.scout_catalog"


class scout_catalog_ChannelDetails(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'uuid': ConjureFieldDefinition('uuid', str),
            'name': ConjureFieldDefinition('name', str),
            'origin_metadata': ConjureFieldDefinition('originMetadata', Dict[str, str]),
            'csv_index': ConjureFieldDefinition('csvIndex', int),
            'dataset_uuid': ConjureFieldDefinition('datasetUuid', str),
            'handle': ConjureFieldDefinition('handle', scout_catalog_Handle)
        }

    __slots__: List[str] = ['_uuid', '_name', '_origin_metadata', '_csv_index', '_dataset_uuid', '_handle']

    def __init__(self, csv_index: int, dataset_uuid: str, handle: "scout_catalog_Handle", name: str, origin_metadata: Dict[str, str], uuid: str) -> None:
        self._uuid = uuid
        self._name = name
        self._origin_metadata = origin_metadata
        self._csv_index = csv_index
        self._dataset_uuid = dataset_uuid
        self._handle = handle

    @builtins.property
    def uuid(self) -> str:
        return self._uuid

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def origin_metadata(self) -> Dict[str, str]:
        return self._origin_metadata

    @builtins.property
    def csv_index(self) -> int:
        return self._csv_index

    @builtins.property
    def dataset_uuid(self) -> str:
        return self._dataset_uuid

    @builtins.property
    def handle(self) -> "scout_catalog_Handle":
        return self._handle


scout_catalog_ChannelDetails.__name__ = "ChannelDetails"
scout_catalog_ChannelDetails.__qualname__ = "ChannelDetails"
scout_catalog_ChannelDetails.__module__ = "nominal_api.scout_catalog"


class scout_catalog_CreateDataset(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'name': ConjureFieldDefinition('name', str),
            'handle': ConjureFieldDefinition('handle', OptionalTypeWrapper[scout_catalog_Handle]),
            'metadata': ConjureFieldDefinition('metadata', Dict[str, str]),
            'origin_metadata': ConjureFieldDefinition('originMetadata', scout_catalog_DatasetOriginMetadata),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'granularity': ConjureFieldDefinition('granularity', OptionalTypeWrapper[api_Granularity]),
            'is_v2_dataset': ConjureFieldDefinition('isV2Dataset', OptionalTypeWrapper[bool]),
            'workspace': ConjureFieldDefinition('workspace', OptionalTypeWrapper[api_rids_WorkspaceRid]),
            'marking_rids': ConjureFieldDefinition('markingRids', List[scout_rids_api_MarkingRid])
        }

    __slots__: List[str] = ['_name', '_handle', '_metadata', '_origin_metadata', '_labels', '_properties', '_description', '_granularity', '_is_v2_dataset', '_workspace', '_marking_rids']

    def __init__(self, labels: List[str], marking_rids: List[str], metadata: Dict[str, str], name: str, origin_metadata: "scout_catalog_DatasetOriginMetadata", properties: Dict[str, str], description: Optional[str] = None, granularity: Optional["api_Granularity"] = None, handle: Optional["scout_catalog_Handle"] = None, is_v2_dataset: Optional[bool] = None, workspace: Optional[str] = None) -> None:
        self._name = name
        self._handle = handle
        self._metadata = metadata
        self._origin_metadata = origin_metadata
        self._labels = labels
        self._properties = properties
        self._description = description
        self._granularity = granularity
        self._is_v2_dataset = is_v2_dataset
        self._workspace = workspace
        self._marking_rids = marking_rids

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def handle(self) -> Optional["scout_catalog_Handle"]:
        return self._handle

    @builtins.property
    def metadata(self) -> Dict[str, str]:
        return self._metadata

    @builtins.property
    def origin_metadata(self) -> "scout_catalog_DatasetOriginMetadata":
        return self._origin_metadata

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def granularity(self) -> Optional["api_Granularity"]:
        """Granularity of dataset timestamps. Defaults to nanoseconds.
        """
        return self._granularity

    @builtins.property
    def is_v2_dataset(self) -> Optional[bool]:
        """If true, the dataset should be ingested to the v2 tables and is compatible with streaming.
        """
        return self._is_v2_dataset

    @builtins.property
    def workspace(self) -> Optional[str]:
        """The workspace in which to create the dataset. If not provided, the dataset will be created in the default workspace for
the user's organization, if the default workspace for the organization is configured.
        """
        return self._workspace

    @builtins.property
    def marking_rids(self) -> List[str]:
        """The markings to apply to the created dataset.
If not provided, the dataset will be visible to all users in the same workspace.
        """
        return self._marking_rids


scout_catalog_CreateDataset.__name__ = "CreateDataset"
scout_catalog_CreateDataset.__qualname__ = "CreateDataset"
scout_catalog_CreateDataset.__module__ = "nominal_api.scout_catalog"


class scout_catalog_CustomTimestamp(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'format': ConjureFieldDefinition('format', str),
            'default_year': ConjureFieldDefinition('defaultYear', OptionalTypeWrapper[int]),
            'default_day_of_year': ConjureFieldDefinition('defaultDayOfYear', OptionalTypeWrapper[int])
        }

    __slots__: List[str] = ['_format', '_default_year', '_default_day_of_year']

    def __init__(self, format: str, default_day_of_year: Optional[int] = None, default_year: Optional[int] = None) -> None:
        self._format = format
        self._default_year = default_year
        self._default_day_of_year = default_day_of_year

    @builtins.property
    def format(self) -> str:
        """The format string should be in the format of the `DateTimeFormatter` class in Java.
        """
        return self._format

    @builtins.property
    def default_year(self) -> Optional[int]:
        """Year is accepted as an optional field for cases like IRIG time format, and will be assumed as current year if not provided.
        """
        return self._default_year

    @builtins.property
    def default_day_of_year(self) -> Optional[int]:
        """Default day of year is accepted as an optional field for cases like IRIG time format and will be overridden by day of year in time format.
        """
        return self._default_day_of_year


scout_catalog_CustomTimestamp.__name__ = "CustomTimestamp"
scout_catalog_CustomTimestamp.__qualname__ = "CustomTimestamp"
scout_catalog_CustomTimestamp.__module__ = "nominal_api.scout_catalog"


class scout_catalog_Dataset(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', str),
            'name': ConjureFieldDefinition('name', str),
            'handle': ConjureFieldDefinition('handle', OptionalTypeWrapper[scout_catalog_Handle]),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'origin_metadata': ConjureFieldDefinition('originMetadata', scout_catalog_DatasetOriginMetadata),
            'bounds': ConjureFieldDefinition('bounds', OptionalTypeWrapper[scout_catalog_Bounds]),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'timestamp_type': ConjureFieldDefinition('timestampType', scout_catalog_WeakTimestampType),
            'allow_streaming': ConjureFieldDefinition('allowStreaming', bool),
            'granularity': ConjureFieldDefinition('granularity', api_Granularity)
        }

    __slots__: List[str] = ['_rid', '_name', '_handle', '_description', '_origin_metadata', '_bounds', '_properties', '_labels', '_timestamp_type', '_allow_streaming', '_granularity']

    def __init__(self, allow_streaming: bool, granularity: "api_Granularity", labels: List[str], name: str, origin_metadata: "scout_catalog_DatasetOriginMetadata", properties: Dict[str, str], rid: str, timestamp_type: "scout_catalog_WeakTimestampType", bounds: Optional["scout_catalog_Bounds"] = None, description: Optional[str] = None, handle: Optional["scout_catalog_Handle"] = None) -> None:
        self._rid = rid
        self._name = name
        self._handle = handle
        self._description = description
        self._origin_metadata = origin_metadata
        self._bounds = bounds
        self._properties = properties
        self._labels = labels
        self._timestamp_type = timestamp_type
        self._allow_streaming = allow_streaming
        self._granularity = granularity

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def handle(self) -> Optional["scout_catalog_Handle"]:
        return self._handle

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def origin_metadata(self) -> "scout_catalog_DatasetOriginMetadata":
        return self._origin_metadata

    @builtins.property
    def bounds(self) -> Optional["scout_catalog_Bounds"]:
        return self._bounds

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels

    @builtins.property
    def timestamp_type(self) -> "scout_catalog_WeakTimestampType":
        return self._timestamp_type

    @builtins.property
    def allow_streaming(self) -> bool:
        return self._allow_streaming

    @builtins.property
    def granularity(self) -> "api_Granularity":
        return self._granularity


scout_catalog_Dataset.__name__ = "Dataset"
scout_catalog_Dataset.__qualname__ = "Dataset"
scout_catalog_Dataset.__module__ = "nominal_api.scout_catalog"


class scout_catalog_DatasetFile(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'id': ConjureFieldDefinition('id', datasource_DatasetFileId),
            'dataset_rid': ConjureFieldDefinition('datasetRid', api_rids_DatasetRid),
            'name': ConjureFieldDefinition('name', str),
            'handle': ConjureFieldDefinition('handle', scout_catalog_Handle),
            'bounds': ConjureFieldDefinition('bounds', OptionalTypeWrapper[scout_catalog_Bounds]),
            'uploaded_at': ConjureFieldDefinition('uploadedAt', str),
            'ingested_at': ConjureFieldDefinition('ingestedAt', OptionalTypeWrapper[str]),
            'ingest_status': ConjureFieldDefinition('ingestStatus', api_IngestStatusV2),
            'timestamp_metadata': ConjureFieldDefinition('timestampMetadata', OptionalTypeWrapper[scout_catalog_TimestampMetadata]),
            'ingest_tag_metadata': ConjureFieldDefinition('ingestTagMetadata', OptionalTypeWrapper[scout_catalog_IngestTagMetadata]),
            'origin_file_paths': ConjureFieldDefinition('originFilePaths', OptionalTypeWrapper[List[str]]),
            'ingest_job_rid': ConjureFieldDefinition('ingestJobRid', OptionalTypeWrapper[ingest_api_IngestJobRid]),
            'deleted_at': ConjureFieldDefinition('deletedAt', OptionalTypeWrapper[str])
        }

    __slots__: List[str] = ['_id', '_dataset_rid', '_name', '_handle', '_bounds', '_uploaded_at', '_ingested_at', '_ingest_status', '_timestamp_metadata', '_ingest_tag_metadata', '_origin_file_paths', '_ingest_job_rid', '_deleted_at']

    def __init__(self, dataset_rid: str, handle: "scout_catalog_Handle", id: str, ingest_status: "api_IngestStatusV2", name: str, uploaded_at: str, bounds: Optional["scout_catalog_Bounds"] = None, deleted_at: Optional[str] = None, ingest_job_rid: Optional[str] = None, ingest_tag_metadata: Optional["scout_catalog_IngestTagMetadata"] = None, ingested_at: Optional[str] = None, origin_file_paths: Optional[List[str]] = None, timestamp_metadata: Optional["scout_catalog_TimestampMetadata"] = None) -> None:
        self._id = id
        self._dataset_rid = dataset_rid
        self._name = name
        self._handle = handle
        self._bounds = bounds
        self._uploaded_at = uploaded_at
        self._ingested_at = ingested_at
        self._ingest_status = ingest_status
        self._timestamp_metadata = timestamp_metadata
        self._ingest_tag_metadata = ingest_tag_metadata
        self._origin_file_paths = origin_file_paths
        self._ingest_job_rid = ingest_job_rid
        self._deleted_at = deleted_at

    @builtins.property
    def id(self) -> str:
        return self._id

    @builtins.property
    def dataset_rid(self) -> str:
        return self._dataset_rid

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def handle(self) -> "scout_catalog_Handle":
        return self._handle

    @builtins.property
    def bounds(self) -> Optional["scout_catalog_Bounds"]:
        return self._bounds

    @builtins.property
    def uploaded_at(self) -> str:
        """Timestamp that the file was received and stored, but not processed or made available to consumers.
        """
        return self._uploaded_at

    @builtins.property
    def ingested_at(self) -> Optional[str]:
        """Timestamp that the file is ingested at and made available for processing. If the file has failed to be
ingested for any reason or is still being processed, then this value will be empty.
        """
        return self._ingested_at

    @builtins.property
    def ingest_status(self) -> "api_IngestStatusV2":
        return self._ingest_status

    @builtins.property
    def timestamp_metadata(self) -> Optional["scout_catalog_TimestampMetadata"]:
        return self._timestamp_metadata

    @builtins.property
    def ingest_tag_metadata(self) -> Optional["scout_catalog_IngestTagMetadata"]:
        return self._ingest_tag_metadata

    @builtins.property
    def origin_file_paths(self) -> Optional[List[str]]:
        return self._origin_file_paths

    @builtins.property
    def ingest_job_rid(self) -> Optional[str]:
        return self._ingest_job_rid

    @builtins.property
    def deleted_at(self) -> Optional[str]:
        """Timestamp that the file is deleted at, only present if the file has been deleted.
        """
        return self._deleted_at


scout_catalog_DatasetFile.__name__ = "DatasetFile"
scout_catalog_DatasetFile.__qualname__ = "DatasetFile"
scout_catalog_DatasetFile.__module__ = "nominal_api.scout_catalog"


class scout_catalog_DatasetFileSortField(ConjureEnumType):

    UPLOADED_AT = 'UPLOADED_AT'
    '''UPLOADED_AT'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


scout_catalog_DatasetFileSortField.__name__ = "DatasetFileSortField"
scout_catalog_DatasetFileSortField.__qualname__ = "DatasetFileSortField"
scout_catalog_DatasetFileSortField.__module__ = "nominal_api.scout_catalog"


class scout_catalog_DatasetFileSortOptions(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'is_descending': ConjureFieldDefinition('isDescending', bool),
            'field': ConjureFieldDefinition('field', scout_catalog_DatasetFileSortField)
        }

    __slots__: List[str] = ['_is_descending', '_field']

    def __init__(self, field: "scout_catalog_DatasetFileSortField", is_descending: bool) -> None:
        self._is_descending = is_descending
        self._field = field

    @builtins.property
    def is_descending(self) -> bool:
        return self._is_descending

    @builtins.property
    def field(self) -> "scout_catalog_DatasetFileSortField":
        return self._field


scout_catalog_DatasetFileSortOptions.__name__ = "DatasetFileSortOptions"
scout_catalog_DatasetFileSortOptions.__qualname__ = "DatasetFileSortOptions"
scout_catalog_DatasetFileSortOptions.__module__ = "nominal_api.scout_catalog"


class scout_catalog_DatasetFileUri(ConjureBeanType):
    """Pre-signed URI that can be used to download the original file directly. Expires if the download has
not been initiated within 1 minute.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'uri': ConjureFieldDefinition('uri', str)
        }

    __slots__: List[str] = ['_uri']

    def __init__(self, uri: str) -> None:
        self._uri = uri

    @builtins.property
    def uri(self) -> str:
        return self._uri


scout_catalog_DatasetFileUri.__name__ = "DatasetFileUri"
scout_catalog_DatasetFileUri.__qualname__ = "DatasetFileUri"
scout_catalog_DatasetFileUri.__module__ = "nominal_api.scout_catalog"


class scout_catalog_DatasetFilesPage(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'files': ConjureFieldDefinition('files', List[scout_catalog_DatasetFile]),
            'next_page': ConjureFieldDefinition('nextPage', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_files', '_next_page']

    def __init__(self, files: List["scout_catalog_DatasetFile"], next_page: Optional[str] = None) -> None:
        self._files = files
        self._next_page = next_page

    @builtins.property
    def files(self) -> List["scout_catalog_DatasetFile"]:
        return self._files

    @builtins.property
    def next_page(self) -> Optional[str]:
        return self._next_page


scout_catalog_DatasetFilesPage.__name__ = "DatasetFilesPage"
scout_catalog_DatasetFilesPage.__qualname__ = "DatasetFilesPage"
scout_catalog_DatasetFilesPage.__module__ = "nominal_api.scout_catalog"


class scout_catalog_DatasetOriginMetadata(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'path': ConjureFieldDefinition('path', OptionalTypeWrapper[str]),
            'x_series_is_absolute': ConjureFieldDefinition('xSeriesIsAbsolute', OptionalTypeWrapper[bool]),
            'schema_directive_path': ConjureFieldDefinition('schemaDirectivePath', OptionalTypeWrapper[str]),
            'x_series_column_name': ConjureFieldDefinition('xSeriesColumnName', OptionalTypeWrapper[str]),
            'x_series_time_unit': ConjureFieldDefinition('xSeriesTimeUnit', OptionalTypeWrapper[api_TimeUnit]),
            'timestamp_metadata': ConjureFieldDefinition('timestampMetadata', OptionalTypeWrapper[scout_catalog_TimestampMetadata]),
            'channel_config': ConjureFieldDefinition('channelConfig', OptionalTypeWrapper[scout_catalog_ChannelConfig])
        }

    __slots__: List[str] = ['_path', '_x_series_is_absolute', '_schema_directive_path', '_x_series_column_name', '_x_series_time_unit', '_timestamp_metadata', '_channel_config']

    def __init__(self, channel_config: Optional["scout_catalog_ChannelConfig"] = None, path: Optional[str] = None, schema_directive_path: Optional[str] = None, timestamp_metadata: Optional["scout_catalog_TimestampMetadata"] = None, x_series_column_name: Optional[str] = None, x_series_is_absolute: Optional[bool] = None, x_series_time_unit: Optional["api_TimeUnit"] = None) -> None:
        self._path = path
        self._x_series_is_absolute = x_series_is_absolute
        self._schema_directive_path = schema_directive_path
        self._x_series_column_name = x_series_column_name
        self._x_series_time_unit = x_series_time_unit
        self._timestamp_metadata = timestamp_metadata
        self._channel_config = channel_config

    @builtins.property
    def path(self) -> Optional[str]:
        """Deprecated in favor of FileOriginMetadata
        """
        return self._path

    @builtins.property
    def x_series_is_absolute(self) -> Optional[bool]:
        """Deprecated in favor of FileOriginMetadata
        """
        return self._x_series_is_absolute

    @builtins.property
    def schema_directive_path(self) -> Optional[str]:
        """Deprecated in favor of FileOriginMetadata
        """
        return self._schema_directive_path

    @builtins.property
    def x_series_column_name(self) -> Optional[str]:
        """Deprecated in favor of FileOriginMetadata
        """
        return self._x_series_column_name

    @builtins.property
    def x_series_time_unit(self) -> Optional["api_TimeUnit"]:
        """Deprecated in favor of FileOriginMetadata
        """
        return self._x_series_time_unit

    @builtins.property
    def timestamp_metadata(self) -> Optional["scout_catalog_TimestampMetadata"]:
        """Deprecated in favor of FileOriginMetadata
        """
        return self._timestamp_metadata

    @builtins.property
    def channel_config(self) -> Optional["scout_catalog_ChannelConfig"]:
        return self._channel_config


scout_catalog_DatasetOriginMetadata.__name__ = "DatasetOriginMetadata"
scout_catalog_DatasetOriginMetadata.__qualname__ = "DatasetOriginMetadata"
scout_catalog_DatasetOriginMetadata.__module__ = "nominal_api.scout_catalog"


class scout_catalog_EnrichedDataset(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'rid': ConjureFieldDefinition('rid', str),
            'uuid': ConjureFieldDefinition('uuid', str),
            'name': ConjureFieldDefinition('name', str),
            'description': ConjureFieldDefinition('description', OptionalTypeWrapper[str]),
            'display_name': ConjureFieldDefinition('displayName', str),
            'metadata': ConjureFieldDefinition('metadata', OptionalTypeWrapper[Dict[str, str]]),
            'handle': ConjureFieldDefinition('handle', OptionalTypeWrapper[scout_catalog_Handle]),
            'ingest_date': ConjureFieldDefinition('ingestDate', str),
            'ingest_status': ConjureFieldDefinition('ingestStatus', OptionalTypeWrapper[scout_catalog_IngestStatus]),
            'origin_metadata': ConjureFieldDefinition('originMetadata', scout_catalog_DatasetOriginMetadata),
            'last_ingest_status': ConjureFieldDefinition('lastIngestStatus', api_IngestStatusV2),
            'retention_policy': ConjureFieldDefinition('retentionPolicy', scout_catalog_RetentionPolicy),
            'source': ConjureFieldDefinition('source', OptionalTypeWrapper[str]),
            'bounds': ConjureFieldDefinition('bounds', OptionalTypeWrapper[scout_catalog_Bounds]),
            'timestamp_type': ConjureFieldDefinition('timestampType', scout_catalog_WeakTimestampType),
            'labels': ConjureFieldDefinition('labels', List[api_Label]),
            'properties': ConjureFieldDefinition('properties', Dict[api_PropertyName, api_PropertyValue]),
            'granularity': ConjureFieldDefinition('granularity', api_Granularity),
            'allow_streaming': ConjureFieldDefinition('allowStreaming', bool)
        }

    __slots__: List[str] = ['_rid', '_uuid', '_name', '_description', '_display_name', '_metadata', '_handle', '_ingest_date', '_ingest_status', '_origin_metadata', '_last_ingest_status', '_retention_policy', '_source', '_bounds', '_timestamp_type', '_labels', '_properties', '_granularity', '_allow_streaming']

    def __init__(self, allow_streaming: bool, display_name: str, granularity: "api_Granularity", ingest_date: str, labels: List[str], last_ingest_status: "api_IngestStatusV2", name: str, origin_metadata: "scout_catalog_DatasetOriginMetadata", properties: Dict[str, str], retention_policy: "scout_catalog_RetentionPolicy", rid: str, timestamp_type: "scout_catalog_WeakTimestampType", uuid: str, bounds: Optional["scout_catalog_Bounds"] = None, description: Optional[str] = None, handle: Optional["scout_catalog_Handle"] = None, ingest_status: Optional["scout_catalog_IngestStatus"] = None, metadata: Optional[Dict[str, str]] = None, source: Optional[str] = None) -> None:
        self._rid = rid
        self._uuid = uuid
        self._name = name
        self._description = description
        self._display_name = display_name
        self._metadata = metadata
        self._handle = handle
        self._ingest_date = ingest_date
        self._ingest_status = ingest_status
        self._origin_metadata = origin_metadata
        self._last_ingest_status = last_ingest_status
        self._retention_policy = retention_policy
        self._source = source
        self._bounds = bounds
        self._timestamp_type = timestamp_type
        self._labels = labels
        self._properties = properties
        self._granularity = granularity
        self._allow_streaming = allow_streaming

    @builtins.property
    def rid(self) -> str:
        return self._rid

    @builtins.property
    def uuid(self) -> str:
        return self._uuid

    @builtins.property
    def name(self) -> str:
        return self._name

    @builtins.property
    def description(self) -> Optional[str]:
        return self._description

    @builtins.property
    def display_name(self) -> str:
        return self._display_name

    @builtins.property
    def metadata(self) -> Optional[Dict[str, str]]:
        return self._metadata

    @builtins.property
    def handle(self) -> Optional["scout_catalog_Handle"]:
        return self._handle

    @builtins.property
    def ingest_date(self) -> str:
        return self._ingest_date

    @builtins.property
    def ingest_status(self) -> Optional["scout_catalog_IngestStatus"]:
        return self._ingest_status

    @builtins.property
    def origin_metadata(self) -> "scout_catalog_DatasetOriginMetadata":
        return self._origin_metadata

    @builtins.property
    def last_ingest_status(self) -> "api_IngestStatusV2":
        return self._last_ingest_status

    @builtins.property
    def retention_policy(self) -> "scout_catalog_RetentionPolicy":
        return self._retention_policy

    @builtins.property
    def source(self) -> Optional[str]:
        return self._source

    @builtins.property
    def bounds(self) -> Optional["scout_catalog_Bounds"]:
        return self._bounds

    @builtins.property
    def timestamp_type(self) -> "scout_catalog_WeakTimestampType":
        return self._timestamp_type

    @builtins.property
    def labels(self) -> List[str]:
        return self._labels

    @builtins.property
    def properties(self) -> Dict[str, str]:
        return self._properties

    @builtins.property
    def granularity(self) -> "api_Granularity":
        return self._granularity

    @builtins.property
    def allow_streaming(self) -> bool:
        return self._allow_streaming


scout_catalog_EnrichedDataset.__name__ = "EnrichedDataset"
scout_catalog_EnrichedDataset.__qualname__ = "EnrichedDataset"
scout_catalog_EnrichedDataset.__module__ = "nominal_api.scout_catalog"


class scout_catalog_EpochTimestamp(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'time_unit': ConjureFieldDefinition('timeUnit', api_TimeUnit)
        }

    __slots__: List[str] = ['_time_unit']

    def __init__(self, time_unit: "api_TimeUnit") -> None:
        self._time_unit = time_unit

    @builtins.property
    def time_unit(self) -> "api_TimeUnit":
        return self._time_unit


scout_catalog_EpochTimestamp.__name__ = "EpochTimestamp"
scout_catalog_EpochTimestamp.__qualname__ = "EpochTimestamp"
scout_catalog_EpochTimestamp.__module__ = "nominal_api.scout_catalog"


class scout_catalog_GetChannelsForDatasetsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'dataset_uuids': ConjureFieldDefinition('datasetUuids', List[str])
        }

    __slots__: List[str] = ['_dataset_uuids']

    def __init__(self, dataset_uuids: List[str]) -> None:
        self._dataset_uuids = dataset_uuids

    @builtins.property
    def dataset_uuids(self) -> List[str]:
        return self._dataset_uuids


scout_catalog_GetChannelsForDatasetsRequest.__name__ = "GetChannelsForDatasetsRequest"
scout_catalog_GetChannelsForDatasetsRequest.__qualname__ = "GetChannelsForDatasetsRequest"
scout_catalog_GetChannelsForDatasetsRequest.__module__ = "nominal_api.scout_catalog"


class scout_catalog_GetDatasetsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'dataset_rids': ConjureFieldDefinition('datasetRids', List[str])
        }

    __slots__: List[str] = ['_dataset_rids']

    def __init__(self, dataset_rids: List[str]) -> None:
        self._dataset_rids = dataset_rids

    @builtins.property
    def dataset_rids(self) -> List[str]:
        return self._dataset_rids


scout_catalog_GetDatasetsRequest.__name__ = "GetDatasetsRequest"
scout_catalog_GetDatasetsRequest.__qualname__ = "GetDatasetsRequest"
scout_catalog_GetDatasetsRequest.__module__ = "nominal_api.scout_catalog"


class scout_catalog_GetDetailsForChannelsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'channel_uuids': ConjureFieldDefinition('channelUuids', List[str])
        }

    __slots__: List[str] = ['_channel_uuids']

    def __init__(self, channel_uuids: List[str]) -> None:
        self._channel_uuids = channel_uuids

    @builtins.property
    def channel_uuids(self) -> List[str]:
        return self._channel_uuids


scout_catalog_GetDetailsForChannelsRequest.__name__ = "GetDetailsForChannelsRequest"
scout_catalog_GetDetailsForChannelsRequest.__qualname__ = "GetDetailsForChannelsRequest"
scout_catalog_GetDetailsForChannelsRequest.__module__ = "nominal_api.scout_catalog"


class scout_catalog_GetHandlesForDatasetsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'dataset_uuids': ConjureFieldDefinition('datasetUuids', List[str])
        }

    __slots__: List[str] = ['_dataset_uuids']

    def __init__(self, dataset_uuids: List[str]) -> None:
        self._dataset_uuids = dataset_uuids

    @builtins.property
    def dataset_uuids(self) -> List[str]:
        return self._dataset_uuids


scout_catalog_GetHandlesForDatasetsRequest.__name__ = "GetHandlesForDatasetsRequest"
scout_catalog_GetHandlesForDatasetsRequest.__qualname__ = "GetHandlesForDatasetsRequest"
scout_catalog_GetHandlesForDatasetsRequest.__module__ = "nominal_api.scout_catalog"


class scout_catalog_Handle(ConjureUnionType):
    _s3: Optional["scout_catalog_S3Handle"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            's3': ConjureFieldDefinition('s3', scout_catalog_S3Handle)
        }

    def __init__(
            self,
            s3: Optional["scout_catalog_S3Handle"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (s3 is not None) != 1:
                raise ValueError('a union must contain a single member')

            if s3 is not None:
                self._s3 = s3
                self._type = 's3'

        elif type_of_union == 's3':
            if s3 is None:
                raise ValueError('a union value must not be None')
            self._s3 = s3
            self._type = 's3'

    @builtins.property
    def s3(self) -> Optional["scout_catalog_S3Handle"]:
        return self._s3

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, scout_catalog_HandleVisitor):
            raise ValueError('{} is not an instance of scout_catalog_HandleVisitor'.format(visitor.__class__.__name__))
        if self._type == 's3' and self.s3 is not None:
            return visitor._s3(self.s3)


scout_catalog_Handle.__name__ = "Handle"
scout_catalog_Handle.__qualname__ = "Handle"
scout_catalog_Handle.__module__ = "nominal_api.scout_catalog"


class scout_catalog_HandleVisitor:

    @abstractmethod
    def _s3(self, s3: "scout_catalog_S3Handle") -> Any:
        pass


scout_catalog_HandleVisitor.__name__ = "HandleVisitor"
scout_catalog_HandleVisitor.__qualname__ = "HandleVisitor"
scout_catalog_HandleVisitor.__module__ = "nominal_api.scout_catalog"


class scout_catalog_IngestProgressV2(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'start_time': ConjureFieldDefinition('startTime', str),
            'end_time': ConjureFieldDefinition('endTime', OptionalTypeWrapper[str]),
            'ingest_status': ConjureFieldDefinition('ingestStatus', api_IngestStatusV2),
            'incalculable': ConjureFieldDefinition('incalculable', OptionalTypeWrapper[bool])
        }

    __slots__: List[str] = ['_start_time', '_end_time', '_ingest_status', '_incalculable']

    def __init__(self, ingest_status: "api_IngestStatusV2", start_time: str, end_time: Optional[str] = None, incalculable: Optional[bool] = None) -> None:
        self._start_time = start_time
        self._end_time = end_time
        self._ingest_status = ingest_status
        self._incalculable = incalculable

    @builtins.property
    def start_time(self) -> str:
        """Timestamp at start of ingest
        """
        return self._start_time

    @builtins.property
    def end_time(self) -> Optional[str]:
        """Timestamp at end of ingest, empty if still in progress
        """
        return self._end_time

    @builtins.property
    def ingest_status(self) -> "api_IngestStatusV2":
        """Status of ingest, contains error if failed
        """
        return self._ingest_status

    @builtins.property
    def incalculable(self) -> Optional[bool]:
        """Whether ingest duration can be reliably calculated
        """
        return self._incalculable


scout_catalog_IngestProgressV2.__name__ = "IngestProgressV2"
scout_catalog_IngestProgressV2.__qualname__ = "IngestProgressV2"
scout_catalog_IngestProgressV2.__module__ = "nominal_api.scout_catalog"


class scout_catalog_IngestStatus(ConjureEnumType):

    IN_PROGRESS = 'IN_PROGRESS'
    '''IN_PROGRESS'''
    COMPLETED = 'COMPLETED'
    '''COMPLETED'''
    FAILED = 'FAILED'
    '''FAILED'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


scout_catalog_IngestStatus.__name__ = "IngestStatus"
scout_catalog_IngestStatus.__qualname__ = "IngestStatus"
scout_catalog_IngestStatus.__module__ = "nominal_api.scout_catalog"


class scout_catalog_IngestTagMetadata(ConjureBeanType):
    """The tags used when ingesting the dataset file.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'tag_columns': ConjureFieldDefinition('tagColumns', Dict[api_TagName, api_ColumnName]),
            'additional_file_tags': ConjureFieldDefinition('additionalFileTags', Dict[api_TagName, api_TagValue])
        }

    __slots__: List[str] = ['_tag_columns', '_additional_file_tags']

    def __init__(self, additional_file_tags: Dict[str, str], tag_columns: Dict[str, str]) -> None:
        self._tag_columns = tag_columns
        self._additional_file_tags = additional_file_tags

    @builtins.property
    def tag_columns(self) -> Dict[str, str]:
        """A map of tag names to column names to derive the tag values from.
        """
        return self._tag_columns

    @builtins.property
    def additional_file_tags(self) -> Dict[str, str]:
        return self._additional_file_tags


scout_catalog_IngestTagMetadata.__name__ = "IngestTagMetadata"
scout_catalog_IngestTagMetadata.__qualname__ = "IngestTagMetadata"
scout_catalog_IngestTagMetadata.__module__ = "nominal_api.scout_catalog"


class scout_catalog_Iso8601Timestamp(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
        }

    __slots__: List[str] = []



scout_catalog_Iso8601Timestamp.__name__ = "Iso8601Timestamp"
scout_catalog_Iso8601Timestamp.__qualname__ = "Iso8601Timestamp"
scout_catalog_Iso8601Timestamp.__module__ = "nominal_api.scout_catalog"


class scout_catalog_MarkFileIngestError(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'error_result': ConjureFieldDefinition('errorResult', api_ErrorResult)
        }

    __slots__: List[str] = ['_error_result']

    def __init__(self, error_result: "api_ErrorResult") -> None:
        self._error_result = error_result

    @builtins.property
    def error_result(self) -> "api_ErrorResult":
        return self._error_result


scout_catalog_MarkFileIngestError.__name__ = "MarkFileIngestError"
scout_catalog_MarkFileIngestError.__qualname__ = "MarkFileIngestError"
scout_catalog_MarkFileIngestError.__module__ = "nominal_api.scout_catalog"


class scout_catalog_MarkFileIngestSuccessful(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'bounds': ConjureFieldDefinition('bounds', scout_catalog_Bounds),
            'ingested_at': ConjureFieldDefinition('ingestedAt', api_Timestamp)
        }

    __slots__: List[str] = ['_bounds', '_ingested_at']

    def __init__(self, bounds: "scout_catalog_Bounds", ingested_at: "api_Timestamp") -> None:
        self._bounds = bounds
        self._ingested_at = ingested_at

    @builtins.property
    def bounds(self) -> "scout_catalog_Bounds":
        return self._bounds

    @builtins.property
    def ingested_at(self) -> "api_Timestamp":
        """The ingestion timestamp is produced by CSV splitter and stored directly in the clickhouse table.
It's produced externally and passed here to handle retries and failures, and must be nanosecond precision.
Two files cannot have the same ingested at timestamp.
        """
        return self._ingested_at


scout_catalog_MarkFileIngestSuccessful.__name__ = "MarkFileIngestSuccessful"
scout_catalog_MarkFileIngestSuccessful.__qualname__ = "MarkFileIngestSuccessful"
scout_catalog_MarkFileIngestSuccessful.__module__ = "nominal_api.scout_catalog"


class scout_catalog_OriginFileUri(ConjureBeanType):
    """Pre-signed URI that can be used to download an origin file directly. Expires if the download has
not been initiated within 1 minute.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'uri': ConjureFieldDefinition('uri', str),
            'path': ConjureFieldDefinition('path', str)
        }

    __slots__: List[str] = ['_uri', '_path']

    def __init__(self, path: str, uri: str) -> None:
        self._uri = uri
        self._path = path

    @builtins.property
    def uri(self) -> str:
        return self._uri

    @builtins.property
    def path(self) -> str:
        return self._path


scout_catalog_OriginFileUri.__name__ = "OriginFileUri"
scout_catalog_OriginFileUri.__qualname__ = "OriginFileUri"
scout_catalog_OriginFileUri.__module__ = "nominal_api.scout_catalog"


class scout_catalog_RelativeTimestamp(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'time_unit': ConjureFieldDefinition('timeUnit', api_TimeUnit),
            'offset': ConjureFieldDefinition('offset', OptionalTypeWrapper[str])
        }

    __slots__: List[str] = ['_time_unit', '_offset']

    def __init__(self, time_unit: "api_TimeUnit", offset: Optional[str] = None) -> None:
        self._time_unit = time_unit
        self._offset = offset

    @builtins.property
    def time_unit(self) -> "api_TimeUnit":
        return self._time_unit

    @builtins.property
    def offset(self) -> Optional[str]:
        return self._offset


scout_catalog_RelativeTimestamp.__name__ = "RelativeTimestamp"
scout_catalog_RelativeTimestamp.__qualname__ = "RelativeTimestamp"
scout_catalog_RelativeTimestamp.__module__ = "nominal_api.scout_catalog"


class scout_catalog_RetentionPolicy(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'type': ConjureFieldDefinition('type', scout_catalog_RetentionPolicyType),
            'expiry_days': ConjureFieldDefinition('expiryDays', OptionalTypeWrapper[int])
        }

    __slots__: List[str] = ['_type', '_expiry_days']

    def __init__(self, type: "scout_catalog_RetentionPolicyType", expiry_days: Optional[int] = None) -> None:
        self._type = type
        self._expiry_days = expiry_days

    @builtins.property
    def type(self) -> "scout_catalog_RetentionPolicyType":
        return self._type

    @builtins.property
    def expiry_days(self) -> Optional[int]:
        return self._expiry_days


scout_catalog_RetentionPolicy.__name__ = "RetentionPolicy"
scout_catalog_RetentionPolicy.__qualname__ = "RetentionPolicy"
scout_catalog_RetentionPolicy.__module__ = "nominal_api.scout_catalog"


class scout_catalog_RetentionPolicyType(ConjureEnumType):

    KEEP_UNTIL_EXPIRY = 'KEEP_UNTIL_EXPIRY'
    '''KEEP_UNTIL_EXPIRY'''
    KEEP_FOREVER = 'KEEP_FOREVER'
    '''KEEP_FOREVER'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


scout_catalog_RetentionPolicyType.__name__ = "RetentionPolicyType"
scout_catalog_RetentionPolicyType.__qualname__ = "RetentionPolicyType"
scout_catalog_RetentionPolicyType.__module__ = "nominal_api.scout_catalog"


class scout_catalog_S3Handle(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'bucket': ConjureFieldDefinition('bucket', str),
            'key': ConjureFieldDefinition('key', str)
        }

    __slots__: List[str] = ['_bucket', '_key']

    def __init__(self, bucket: str, key: str) -> None:
        self._bucket = bucket
        self._key = key

    @builtins.property
    def bucket(self) -> str:
        return self._bucket

    @builtins.property
    def key(self) -> str:
        return self._key


scout_catalog_S3Handle.__name__ = "S3Handle"
scout_catalog_S3Handle.__qualname__ = "S3Handle"
scout_catalog_S3Handle.__module__ = "nominal_api.scout_catalog"


class scout_catalog_SearchDatasetFilesQuery(ConjureUnionType):
    _time_range: Optional["scout_catalog_TimeRangeFilter"] = None
    _file_tags: Optional[Dict[str, str]] = None
    _and_: Optional[List["scout_catalog_SearchDatasetFilesQuery"]] = None
    _or_: Optional[List["scout_catalog_SearchDatasetFilesQuery"]] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'time_range': ConjureFieldDefinition('timeRange', scout_catalog_TimeRangeFilter),
            'file_tags': ConjureFieldDefinition('fileTags', Dict[api_TagName, api_TagValue]),
            'and_': ConjureFieldDefinition('and', List[scout_catalog_SearchDatasetFilesQuery]),
            'or_': ConjureFieldDefinition('or', List[scout_catalog_SearchDatasetFilesQuery])
        }

    def __init__(
            self,
            time_range: Optional["scout_catalog_TimeRangeFilter"] = None,
            file_tags: Optional[Dict[str, str]] = None,
            and_: Optional[List["scout_catalog_SearchDatasetFilesQuery"]] = None,
            or_: Optional[List["scout_catalog_SearchDatasetFilesQuery"]] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (time_range is not None) + (file_tags is not None) + (and_ is not None) + (or_ is not None) != 1:
                raise ValueError('a union must contain a single member')

            if time_range is not None:
                self._time_range = time_range
                self._type = 'timeRange'
            if file_tags is not None:
                self._file_tags = file_tags
                self._type = 'fileTags'
            if and_ is not None:
                self._and_ = and_
                self._type = 'and'
            if or_ is not None:
                self._or_ = or_
                self._type = 'or'

        elif type_of_union == 'timeRange':
            if time_range is None:
                raise ValueError('a union value must not be None')
            self._time_range = time_range
            self._type = 'timeRange'
        elif type_of_union == 'fileTags':
            if file_tags is None:
                raise ValueError('a union value must not be None')
            self._file_tags = file_tags
            self._type = 'fileTags'
        elif type_of_union == 'and':
            if and_ is None:
                raise ValueError('a union value must not be None')
            self._and_ = and_
            self._type = 'and'
        elif type_of_union == 'or':
            if or_ is None:
                raise ValueError('a union value must not be None')
            self._or_ = or_
            self._type = 'or'

    @builtins.property
    def time_range(self) -> Optional["scout_catalog_TimeRangeFilter"]:
        return self._time_range

    @builtins.property
    def file_tags(self) -> Optional[Dict[str, str]]:
        return self._file_tags

    @builtins.property
    def and_(self) -> Optional[List["scout_catalog_SearchDatasetFilesQuery"]]:
        return self._and_

    @builtins.property
    def or_(self) -> Optional[List["scout_catalog_SearchDatasetFilesQuery"]]:
        return self._or_

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, scout_catalog_SearchDatasetFilesQueryVisitor):
            raise ValueError('{} is not an instance of scout_catalog_SearchDatasetFilesQueryVisitor'.format(visitor.__class__.__name__))
        if self._type == 'timeRange' and self.time_range is not None:
            return visitor._time_range(self.time_range)
        if self._type == 'fileTags' and self.file_tags is not None:
            return visitor._file_tags(self.file_tags)
        if self._type == 'and' and self.and_ is not None:
            return visitor._and(self.and_)
        if self._type == 'or' and self.or_ is not None:
            return visitor._or(self.or_)


scout_catalog_SearchDatasetFilesQuery.__name__ = "SearchDatasetFilesQuery"
scout_catalog_SearchDatasetFilesQuery.__qualname__ = "SearchDatasetFilesQuery"
scout_catalog_SearchDatasetFilesQuery.__module__ = "nominal_api.scout_catalog"


class scout_catalog_SearchDatasetFilesQueryVisitor:

    @abstractmethod
    def _time_range(self, time_range: "scout_catalog_TimeRangeFilter") -> Any:
        pass

    @abstractmethod
    def _file_tags(self, file_tags: Dict[str, str]) -> Any:
        pass

    @abstractmethod
    def _and(self, and_: List["scout_catalog_SearchDatasetFilesQuery"]) -> Any:
        pass

    @abstractmethod
    def _or(self, or_: List["scout_catalog_SearchDatasetFilesQuery"]) -> Any:
        pass


scout_catalog_SearchDatasetFilesQueryVisitor.__name__ = "SearchDatasetFilesQueryVisitor"
scout_catalog_SearchDatasetFilesQueryVisitor.__qualname__ = "SearchDatasetFilesQueryVisitor"
scout_catalog_SearchDatasetFilesQueryVisitor.__module__ = "nominal_api.scout_catalog"


class scout_catalog_SearchDatasetFilesRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'dataset_rid': ConjureFieldDefinition('datasetRid', api_rids_DatasetRid),
            'query': ConjureFieldDefinition('query', scout_catalog_SearchDatasetFilesQuery),
            'page_size': ConjureFieldDefinition('pageSize', OptionalTypeWrapper[int]),
            'token': ConjureFieldDefinition('token', OptionalTypeWrapper[api_Token]),
            'sort_options': ConjureFieldDefinition('sortOptions', scout_catalog_DatasetFileSortOptions)
        }

    __slots__: List[str] = ['_dataset_rid', '_query', '_page_size', '_token', '_sort_options']

    def __init__(self, dataset_rid: str, query: "scout_catalog_SearchDatasetFilesQuery", sort_options: "scout_catalog_DatasetFileSortOptions", page_size: Optional[int] = None, token: Optional[str] = None) -> None:
        self._dataset_rid = dataset_rid
        self._query = query
        self._page_size = page_size
        self._token = token
        self._sort_options = sort_options

    @builtins.property
    def dataset_rid(self) -> str:
        return self._dataset_rid

    @builtins.property
    def query(self) -> "scout_catalog_SearchDatasetFilesQuery":
        return self._query

    @builtins.property
    def page_size(self) -> Optional[int]:
        """Defaults to 100. Will throw if larger than 1000.
        """
        return self._page_size

    @builtins.property
    def token(self) -> Optional[str]:
        return self._token

    @builtins.property
    def sort_options(self) -> "scout_catalog_DatasetFileSortOptions":
        return self._sort_options


scout_catalog_SearchDatasetFilesRequest.__name__ = "SearchDatasetFilesRequest"
scout_catalog_SearchDatasetFilesRequest.__qualname__ = "SearchDatasetFilesRequest"
scout_catalog_SearchDatasetFilesRequest.__module__ = "nominal_api.scout_catalog"


class scout_catalog_SearchDatasetFilesResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[scout_catalog_DatasetFile]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_results', '_next_page_token']

    def __init__(self, results: List["scout_catalog_DatasetFile"], next_page_token: Optional[str] = None) -> None:
        self._results = results
        self._next_page_token = next_page_token

    @builtins.property
    def results(self) -> List["scout_catalog_DatasetFile"]:
        return self._results

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


scout_catalog_SearchDatasetFilesResponse.__name__ = "SearchDatasetFilesResponse"
scout_catalog_SearchDatasetFilesResponse.__qualname__ = "SearchDatasetFilesResponse"
scout_catalog_SearchDatasetFilesResponse.__module__ = "nominal_api.scout_catalog"


class scout_catalog_SearchDatasetsQuery(ConjureUnionType):
    _search_text: Optional[str] = None
    _exact_match: Optional[str] = None
    _label: Optional[str] = None
    _properties: Optional["api_Property"] = None
    _ingest_status: Optional["scout_catalog_IngestStatus"] = None
    _ingested_before_inclusive: Optional[str] = None
    _ingested_after_inclusive: Optional[str] = None
    _archive_status: Optional[bool] = None
    _and_: Optional[List["scout_catalog_SearchDatasetsQuery"]] = None
    _or_: Optional[List["scout_catalog_SearchDatasetsQuery"]] = None
    _workspace: Optional[str] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'search_text': ConjureFieldDefinition('searchText', str),
            'exact_match': ConjureFieldDefinition('exactMatch', str),
            'label': ConjureFieldDefinition('label', api_Label),
            'properties': ConjureFieldDefinition('properties', api_Property),
            'ingest_status': ConjureFieldDefinition('ingestStatus', scout_catalog_IngestStatus),
            'ingested_before_inclusive': ConjureFieldDefinition('ingestedBeforeInclusive', str),
            'ingested_after_inclusive': ConjureFieldDefinition('ingestedAfterInclusive', str),
            'archive_status': ConjureFieldDefinition('archiveStatus', bool),
            'and_': ConjureFieldDefinition('and', List[scout_catalog_SearchDatasetsQuery]),
            'or_': ConjureFieldDefinition('or', List[scout_catalog_SearchDatasetsQuery]),
            'workspace': ConjureFieldDefinition('workspace', api_rids_WorkspaceRid)
        }

    def __init__(
            self,
            search_text: Optional[str] = None,
            exact_match: Optional[str] = None,
            label: Optional[str] = None,
            properties: Optional["api_Property"] = None,
            ingest_status: Optional["scout_catalog_IngestStatus"] = None,
            ingested_before_inclusive: Optional[str] = None,
            ingested_after_inclusive: Optional[str] = None,
            archive_status: Optional[bool] = None,
            and_: Optional[List["scout_catalog_SearchDatasetsQuery"]] = None,
            or_: Optional[List["scout_catalog_SearchDatasetsQuery"]] = None,
            workspace: Optional[str] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (search_text is not None) + (exact_match is not None) + (label is not None) + (properties is not None) + (ingest_status is not None) + (ingested_before_inclusive is not None) + (ingested_after_inclusive is not None) + (archive_status is not None) + (and_ is not None) + (or_ is not None) + (workspace is not None) != 1:
                raise ValueError('a union must contain a single member')

            if search_text is not None:
                self._search_text = search_text
                self._type = 'searchText'
            if exact_match is not None:
                self._exact_match = exact_match
                self._type = 'exactMatch'
            if label is not None:
                self._label = label
                self._type = 'label'
            if properties is not None:
                self._properties = properties
                self._type = 'properties'
            if ingest_status is not None:
                self._ingest_status = ingest_status
                self._type = 'ingestStatus'
            if ingested_before_inclusive is not None:
                self._ingested_before_inclusive = ingested_before_inclusive
                self._type = 'ingestedBeforeInclusive'
            if ingested_after_inclusive is not None:
                self._ingested_after_inclusive = ingested_after_inclusive
                self._type = 'ingestedAfterInclusive'
            if archive_status is not None:
                self._archive_status = archive_status
                self._type = 'archiveStatus'
            if and_ is not None:
                self._and_ = and_
                self._type = 'and'
            if or_ is not None:
                self._or_ = or_
                self._type = 'or'
            if workspace is not None:
                self._workspace = workspace
                self._type = 'workspace'

        elif type_of_union == 'searchText':
            if search_text is None:
                raise ValueError('a union value must not be None')
            self._search_text = search_text
            self._type = 'searchText'
        elif type_of_union == 'exactMatch':
            if exact_match is None:
                raise ValueError('a union value must not be None')
            self._exact_match = exact_match
            self._type = 'exactMatch'
        elif type_of_union == 'label':
            if label is None:
                raise ValueError('a union value must not be None')
            self._label = label
            self._type = 'label'
        elif type_of_union == 'properties':
            if properties is None:
                raise ValueError('a union value must not be None')
            self._properties = properties
            self._type = 'properties'
        elif type_of_union == 'ingestStatus':
            if ingest_status is None:
                raise ValueError('a union value must not be None')
            self._ingest_status = ingest_status
            self._type = 'ingestStatus'
        elif type_of_union == 'ingestedBeforeInclusive':
            if ingested_before_inclusive is None:
                raise ValueError('a union value must not be None')
            self._ingested_before_inclusive = ingested_before_inclusive
            self._type = 'ingestedBeforeInclusive'
        elif type_of_union == 'ingestedAfterInclusive':
            if ingested_after_inclusive is None:
                raise ValueError('a union value must not be None')
            self._ingested_after_inclusive = ingested_after_inclusive
            self._type = 'ingestedAfterInclusive'
        elif type_of_union == 'archiveStatus':
            if archive_status is None:
                raise ValueError('a union value must not be None')
            self._archive_status = archive_status
            self._type = 'archiveStatus'
        elif type_of_union == 'and':
            if and_ is None:
                raise ValueError('a union value must not be None')
            self._and_ = and_
            self._type = 'and'
        elif type_of_union == 'or':
            if or_ is None:
                raise ValueError('a union value must not be None')
            self._or_ = or_
            self._type = 'or'
        elif type_of_union == 'workspace':
            if workspace is None:
                raise ValueError('a union value must not be None')
            self._workspace = workspace
            self._type = 'workspace'

    @builtins.property
    def search_text(self) -> Optional[str]:
        return self._search_text

    @builtins.property
    def exact_match(self) -> Optional[str]:
        """Performs case insensitive exact match search on the name.
        """
        return self._exact_match

    @builtins.property
    def label(self) -> Optional[str]:
        return self._label

    @builtins.property
    def properties(self) -> Optional["api_Property"]:
        return self._properties

    @builtins.property
    def ingest_status(self) -> Optional["scout_catalog_IngestStatus"]:
        return self._ingest_status

    @builtins.property
    def ingested_before_inclusive(self) -> Optional[str]:
        return self._ingested_before_inclusive

    @builtins.property
    def ingested_after_inclusive(self) -> Optional[str]:
        return self._ingested_after_inclusive

    @builtins.property
    def archive_status(self) -> Optional[bool]:
        return self._archive_status

    @builtins.property
    def and_(self) -> Optional[List["scout_catalog_SearchDatasetsQuery"]]:
        return self._and_

    @builtins.property
    def or_(self) -> Optional[List["scout_catalog_SearchDatasetsQuery"]]:
        return self._or_

    @builtins.property
    def workspace(self) -> Optional[str]:
        return self._workspace

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, scout_catalog_SearchDatasetsQueryVisitor):
            raise ValueError('{} is not an instance of scout_catalog_SearchDatasetsQueryVisitor'.format(visitor.__class__.__name__))
        if self._type == 'searchText' and self.search_text is not None:
            return visitor._search_text(self.search_text)
        if self._type == 'exactMatch' and self.exact_match is not None:
            return visitor._exact_match(self.exact_match)
        if self._type == 'label' and self.label is not None:
            return visitor._label(self.label)
        if self._type == 'properties' and self.properties is not None:
            return visitor._properties(self.properties)
        if self._type == 'ingestStatus' and self.ingest_status is not None:
            return visitor._ingest_status(self.ingest_status)
        if self._type == 'ingestedBeforeInclusive' and self.ingested_before_inclusive is not None:
            return visitor._ingested_before_inclusive(self.ingested_before_inclusive)
        if self._type == 'ingestedAfterInclusive' and self.ingested_after_inclusive is not None:
            return visitor._ingested_after_inclusive(self.ingested_after_inclusive)
        if self._type == 'archiveStatus' and self.archive_status is not None:
            return visitor._archive_status(self.archive_status)
        if self._type == 'and' and self.and_ is not None:
            return visitor._and(self.and_)
        if self._type == 'or' and self.or_ is not None:
            return visitor._or(self.or_)
        if self._type == 'workspace' and self.workspace is not None:
            return visitor._workspace(self.workspace)


scout_catalog_SearchDatasetsQuery.__name__ = "SearchDatasetsQuery"
scout_catalog_SearchDatasetsQuery.__qualname__ = "SearchDatasetsQuery"
scout_catalog_SearchDatasetsQuery.__module__ = "nominal_api.scout_catalog"


class scout_catalog_SearchDatasetsQueryVisitor:

    @abstractmethod
    def _search_text(self, search_text: str) -> Any:
        pass

    @abstractmethod
    def _exact_match(self, exact_match: str) -> Any:
        pass

    @abstractmethod
    def _label(self, label: str) -> Any:
        pass

    @abstractmethod
    def _properties(self, properties: "api_Property") -> Any:
        pass

    @abstractmethod
    def _ingest_status(self, ingest_status: "scout_catalog_IngestStatus") -> Any:
        pass

    @abstractmethod
    def _ingested_before_inclusive(self, ingested_before_inclusive: str) -> Any:
        pass

    @abstractmethod
    def _ingested_after_inclusive(self, ingested_after_inclusive: str) -> Any:
        pass

    @abstractmethod
    def _archive_status(self, archive_status: bool) -> Any:
        pass

    @abstractmethod
    def _and(self, and_: List["scout_catalog_SearchDatasetsQuery"]) -> Any:
        pass

    @abstractmethod
    def _or(self, or_: List["scout_catalog_SearchDatasetsQuery"]) -> Any:
        pass

    @abstractmethod
    def _workspace(self, workspace: str) -> Any:
        pass


scout_catalog_SearchDatasetsQueryVisitor.__name__ = "SearchDatasetsQueryVisitor"
scout_catalog_SearchDatasetsQueryVisitor.__qualname__ = "SearchDatasetsQueryVisitor"
scout_catalog_SearchDatasetsQueryVisitor.__module__ = "nominal_api.scout_catalog"


class scout_catalog_SearchDatasetsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'query': ConjureFieldDefinition('query', scout_catalog_SearchDatasetsQuery),
            'page_size': ConjureFieldDefinition('pageSize', OptionalTypeWrapper[int]),
            'token': ConjureFieldDefinition('token', OptionalTypeWrapper[api_Token]),
            'sort_options': ConjureFieldDefinition('sortOptions', scout_catalog_SortOptions)
        }

    __slots__: List[str] = ['_query', '_page_size', '_token', '_sort_options']

    def __init__(self, query: "scout_catalog_SearchDatasetsQuery", sort_options: "scout_catalog_SortOptions", page_size: Optional[int] = None, token: Optional[str] = None) -> None:
        self._query = query
        self._page_size = page_size
        self._token = token
        self._sort_options = sort_options

    @builtins.property
    def query(self) -> "scout_catalog_SearchDatasetsQuery":
        return self._query

    @builtins.property
    def page_size(self) -> Optional[int]:
        """Defaults to 100. Will throw if larger than 1000.
        """
        return self._page_size

    @builtins.property
    def token(self) -> Optional[str]:
        return self._token

    @builtins.property
    def sort_options(self) -> "scout_catalog_SortOptions":
        return self._sort_options


scout_catalog_SearchDatasetsRequest.__name__ = "SearchDatasetsRequest"
scout_catalog_SearchDatasetsRequest.__qualname__ = "SearchDatasetsRequest"
scout_catalog_SearchDatasetsRequest.__module__ = "nominal_api.scout_catalog"


class scout_catalog_SearchDatasetsResponse(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'results': ConjureFieldDefinition('results', List[scout_catalog_EnrichedDataset]),
            'next_page_token': ConjureFieldDefinition('nextPageToken', OptionalTypeWrapper[api_Token])
        }

    __slots__: List[str] = ['_results', '_next_page_token']

    def __init__(self, results: List["scout_catalog_EnrichedDataset"], next_page_token: Optional[str] = None) -> None:
        self._results = results
        self._next_page_token = next_page_token

    @builtins.property
    def results(self) -> List["scout_catalog_EnrichedDataset"]:
        return self._results

    @builtins.property
    def next_page_token(self) -> Optional[str]:
        return self._next_page_token


scout_catalog_SearchDatasetsResponse.__name__ = "SearchDatasetsResponse"
scout_catalog_SearchDatasetsResponse.__qualname__ = "SearchDatasetsResponse"
scout_catalog_SearchDatasetsResponse.__module__ = "nominal_api.scout_catalog"


class scout_catalog_SkipRowsConfig(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'header_row_index': ConjureFieldDefinition('headerRowIndex', int),
            'data_start_row_index': ConjureFieldDefinition('dataStartRowIndex', int)
        }

    __slots__: List[str] = ['_header_row_index', '_data_start_row_index']

    def __init__(self, data_start_row_index: int, header_row_index: int) -> None:
        self._header_row_index = header_row_index
        self._data_start_row_index = data_start_row_index

    @builtins.property
    def header_row_index(self) -> int:
        return self._header_row_index

    @builtins.property
    def data_start_row_index(self) -> int:
        return self._data_start_row_index


scout_catalog_SkipRowsConfig.__name__ = "SkipRowsConfig"
scout_catalog_SkipRowsConfig.__qualname__ = "SkipRowsConfig"
scout_catalog_SkipRowsConfig.__module__ = "nominal_api.scout_catalog"


class scout_catalog_SortField(ConjureEnumType):

    INGEST_DATE = 'INGEST_DATE'
    '''INGEST_DATE'''
    UNKNOWN = 'UNKNOWN'
    '''UNKNOWN'''

    def __reduce_ex__(self, proto):
        return self.__class__, (self.name,)


scout_catalog_SortField.__name__ = "SortField"
scout_catalog_SortField.__qualname__ = "SortField"
scout_catalog_SortField.__module__ = "nominal_api.scout_catalog"


class scout_catalog_SortOptions(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'is_descending': ConjureFieldDefinition('isDescending', bool),
            'field': ConjureFieldDefinition('field', scout_catalog_SortField)
        }

    __slots__: List[str] = ['_is_descending', '_field']

    def __init__(self, field: "scout_catalog_SortField", is_descending: bool) -> None:
        self._is_descending = is_descending
        self._field = field

    @builtins.property
    def is_descending(self) -> bool:
        return self._is_descending

    @builtins.property
    def field(self) -> "scout_catalog_SortField":
        return self._field


scout_catalog_SortOptions.__name__ = "SortOptions"
scout_catalog_SortOptions.__qualname__ = "SortOptions"
scout_catalog_SortOptions.__module__ = "nominal_api.scout_catalog"


class scout_catalog_TimeRangeFilter(ConjureBeanType):
    """searches for files that intersect with the specified range.
    """

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'start': ConjureFieldDefinition('start', OptionalTypeWrapper[scout_catalog_UtcTimestamp]),
            'end': ConjureFieldDefinition('end', OptionalTypeWrapper[scout_catalog_UtcTimestamp])
        }

    __slots__: List[str] = ['_start', '_end']

    def __init__(self, end: Optional["scout_catalog_UtcTimestamp"] = None, start: Optional["scout_catalog_UtcTimestamp"] = None) -> None:
        self._start = start
        self._end = end

    @builtins.property
    def start(self) -> Optional["scout_catalog_UtcTimestamp"]:
        return self._start

    @builtins.property
    def end(self) -> Optional["scout_catalog_UtcTimestamp"]:
        return self._end


scout_catalog_TimeRangeFilter.__name__ = "TimeRangeFilter"
scout_catalog_TimeRangeFilter.__qualname__ = "TimeRangeFilter"
scout_catalog_TimeRangeFilter.__module__ = "nominal_api.scout_catalog"


class scout_catalog_TimestampMetadata(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'series_name': ConjureFieldDefinition('seriesName', str),
            'timestamp_type': ConjureFieldDefinition('timestampType', scout_catalog_TimestampType)
        }

    __slots__: List[str] = ['_series_name', '_timestamp_type']

    def __init__(self, series_name: str, timestamp_type: "scout_catalog_TimestampType") -> None:
        self._series_name = series_name
        self._timestamp_type = timestamp_type

    @builtins.property
    def series_name(self) -> str:
        return self._series_name

    @builtins.property
    def timestamp_type(self) -> "scout_catalog_TimestampType":
        return self._timestamp_type


scout_catalog_TimestampMetadata.__name__ = "TimestampMetadata"
scout_catalog_TimestampMetadata.__qualname__ = "TimestampMetadata"
scout_catalog_TimestampMetadata.__module__ = "nominal_api.scout_catalog"


class scout_catalog_TimestampType(ConjureUnionType):
    _relative: Optional["scout_catalog_RelativeTimestamp"] = None
    _absolute: Optional["scout_catalog_AbsoluteTimestamp"] = None

    @builtins.classmethod
    def _options(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'relative': ConjureFieldDefinition('relative', scout_catalog_RelativeTimestamp),
            'absolute': ConjureFieldDefinition('absolute', scout_catalog_AbsoluteTimestamp)
        }

    def __init__(
            self,
            relative: Optional["scout_catalog_RelativeTimestamp"] = None,
            absolute: Optional["scout_catalog_AbsoluteTimestamp"] = None,
            type_of_union: Optional[str] = None
            ) -> None:
        if type_of_union is None:
            if (relative is not None) + (absolute is not None) != 1:
                raise ValueError('a union must contain a single member')

            if relative is not None:
                self._relative = relative
                self._type = 'relative'
            if absolute is not None:
                self._absolute = absolute
                self._type = 'absolute'

        elif type_of_union == 'relative':
            if relative is None:
                raise ValueError('a union value must not be None')
            self._relative = relative
            self._type = 'relative'
        elif type_of_union == 'absolute':
            if absolute is None:
                raise ValueError('a union value must not be None')
            self._absolute = absolute
            self._type = 'absolute'

    @builtins.property
    def relative(self) -> Optional["scout_catalog_RelativeTimestamp"]:
        return self._relative

    @builtins.property
    def absolute(self) -> Optional["scout_catalog_AbsoluteTimestamp"]:
        return self._absolute

    def accept(self, visitor) -> Any:
        if not isinstance(visitor, scout_catalog_TimestampTypeVisitor):
            raise ValueError('{} is not an instance of scout_catalog_TimestampTypeVisitor'.format(visitor.__class__.__name__))
        if self._type == 'relative' and self.relative is not None:
            return visitor._relative(self.relative)
        if self._type == 'absolute' and self.absolute is not None:
            return visitor._absolute(self.absolute)


scout_catalog_TimestampType.__name__ = "TimestampType"
scout_catalog_TimestampType.__qualname__ = "TimestampType"
scout_catalog_TimestampType.__module__ = "nominal_api.scout_catalog"


class scout_catalog_TimestampTypeVisitor:

    @abstractmethod
    def _relative(self, relative: "scout_catalog_RelativeTimestamp") -> Any:
        pass

    @abstractmethod
    def _absolute(self, absolute: "scout_catalog_AbsoluteTimestamp") -> Any:
        pass


scout_catalog_TimestampTypeVisitor.__name__ = "TimestampTypeVisitor"
scout_catalog_TimestampTypeVisitor.__qualname__ = "TimestampTypeVisitor"
scout_catalog_TimestampTypeVisitor.__module__ = "nominal_api.scout_catalog"


class scout_catalog_UnitConfig(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'unit_metadata_key': ConjureFieldDefinition('unitMetadataKey', str)
        }

    __slots__: List[str] = ['_unit_metadata_key']

    def __init__(self, unit_metadata_key: str) -> None:
        self._unit_metadata_key = unit_metadata_key

    @builtins.property
    def unit_metadata_key(self) -> str:
        """If set, will extract the series unit from the column metadata of the ingested file.
        """
        return self._unit_metadata_key


scout_catalog_UnitConfig.__name__ = "UnitConfig"
scout_catalog_UnitConfig.__qualname__ = "UnitConfig"
scout_catalog_UnitConfig.__module__ = "nominal_api.scout_catalog"


class scout_catalog_UpdateBoundsRequest(ConjureBeanType):

    @builtins.classmethod
    def _fields(cls) -> Dict[str, ConjureFieldDefinition]:
        return {
            'bounds': ConjureFieldDefinition('bounds', scout_catalog_Bounds)
        }

    __slots__: List[str] = ['_bounds']

    def __init__(self, bounds: "scout_catalog_Bounds") -> None:
        self._bounds = bounds

    @builtins.property
    def bounds(self) -> "scout_catalog_Bounds":
        return self._bounds


scout_catalog_UpdateBoundsRequest.__name__ = "UpdateBoundsRequest"
scout_catalog_UpdateBoundsRequest.__qualname__ = "UpdateBoundsRequest"
scout_catalog_UpdateBoundsRequest.__module__ = "nominal