from typing import Optional

import aiohttp
from ezmm import MultimodalSequence

from scrapemm.util import get_domain
from .bluesky import Bluesky
from .fb import Facebook
from .instagram import Instagram
from .telegram import Telegram
from .tiktok import TikTok
from .x import X
from .youtube import YouTube

RETRIEVAL_INTEGRATIONS = [X(), Telegram(), Bluesky(), TikTok(), Instagram(), Facebook(), YouTube()]
DOMAIN_TO_INTEGRATION = {domain: integration
                         for integration in RETRIEVAL_INTEGRATIONS
                         for domain in integration.domains}


async def retrieve_via_integration(url: str, session: aiohttp.ClientSession) -> Optional[MultimodalSequence]:
    domain = get_domain(url)
    if domain in DOMAIN_TO_INTEGRATION:
        integration = DOMAIN_TO_INTEGRATION[domain]
        if integration.connected or integration.connected is None:
            return await integration.get(url, session)
