# Sonolus.py
Sonolus.py is a Python library for creating Sonolus engines.

## Installation
Sonolus.py is available on PyPI and can be installed using a package manager like pip.

=== "pip"
    ```bash
    pip install sonolus.py
    ```
=== "uv"
    ```bash
    uv add sonolus.py
    ```


## Getting Started

If you're new to Sonolus.py, the [guide section](guides/index.md) is a good place to start. It provides an introduction
to various aspects of making a Sonolus.py engine.

For a ready-to-use example, the [pydori](https://github.com/qwewqa/pydori) engine is a Sonolus.py engine that 
implements a Bandori-style (vertical scrolling rhythm game) gameplay and is intended to serve as a reference 
implementation of a Sonolus.py engine.

When creating a new project, you may want to use the
[new project template](https://github.com/qwewqa/sonolus.py-template-project).

## Documentation

- [Overview](overview.md): High-level overview of Sonolus.py.
- [Concepts](concepts/index.md): Detailed information on concepts and usage.
- [Reference](reference/index.md): Detailed information on included classes and functions.
