# The COMPAS framework

![build](https://github.com/compas-dev/compas/workflows/build/badge.svg)
[![codecov](https://codecov.io/github/compas-dev/compas/graph/badge.svg?token=wpkfew9szQ)](https://codecov.io/github/compas-dev/compas)
[![GitHub - License](https://img.shields.io/github/license/compas-dev/compas.svg)](https://github.com/compas-dev/compas)
[![Conda Downloads](https://img.shields.io/conda/dn/conda-forge/compas)](https://anaconda.org/conda-forge/compas)
[![pip downloads](https://img.shields.io/pypi/dm/compas)](https://pypi.python.org/project/COMPAS)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/COMPAS.svg)](https://pypi.python.org/project/COMPAS)
[![PyPI - Latest Release](https://img.shields.io/pypi/v/COMPAS.svg)](https://pypi.python.org/project/COMPAS)
[![Conda (channel only)](https://img.shields.io/conda/vn/conda-forge/compas)](https://anaconda.org/conda-forge/compas)
[![Conda - Platform](https://img.shields.io/conda/pn/conda-forge/compas)](https://anaconda.org/conda-forge/compas)
[![DOI](https://zenodo.org/badge/104857648.svg)](https://zenodo.org/badge/latestdoi/104857648)
[![Twitter Follow](https://img.shields.io/twitter/follow/compas_dev?style=social)](https://twitter.com/compas_dev)

The **COMPAS** framework is an open-source, Python-based framework for computational research and collaboration in architecture, engineering, digital fabrication and construction.

The framework consists of a general-purpose core library, written in pure Python, and a growing collection of extensions that provide easy access to peer-reviewed research, state-of-the-art external libraries such as CGAL, libigl and Triangle, and tools with specialized functionality for AEFC applications such as Abaqus, ANSYS, SOFISTIK, ROS, etc.

COMPAS has dedicated packages for working with Rhino, Grasshopper, and Blender, but it can be used in any environment that supports Python scripting. It is available on PyPI and conda-forge and can be easily installed using popular package managers on multiple platforms.

## Installation

The recommended way to install **COMPAS** is to use [Anaconda/conda](https://conda.io/docs/):

```bash
conda config --add channels conda-forge
conda install compas
```

For other installation options, [see the user guide](https://compas.dev/compas/latest/userguide/installation.html)

## First Steps

* [First steps](https://compas.dev/compas/latest/userguide/firststeps.html)
* [Tutorials: geometry basics](https://compas.dev/compas/latest/userguide/basics.geometry.html)
* [Tutorials: datastructures](https://compas.dev/compas/latest/userguide/basics.datastructures.html)
* [API Reference](https://compas.dev/compas/latest/api/index.html)

## Questions and feedback

The **COMPAS** framework has a [forum for questions and discussions](https://forum.compas-framework.org/).

## Issue tracker

If you find a bug, please help us solve it by [filing a report](https://github.com/compas-dev/compas/issues).

## Contributing

If you want to contribute, check out the [contribution guidelines](https://compas.dev/compas/latest/devguide/index.html).

## Changelog

See changes between releases on the [changelog](https://github.com/compas-dev/compas/blob/main/CHANGELOG.md).

## License

The main library of **COMPAS** is [released under the MIT license](https://compas.dev/compas/latest/userguide/license.html).

## Credits

COMPAS is developed by a small team of core developers (`compas-dev`) and with the support of contributers from the open source community.
See the [list of authors](https://github.com/compas-dev/compas/blob/main/AUTHORS.md) for a complete overview...
