"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stack = exports.app = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const ses_smtp_credentials_1 = require("./ses-smtp-credentials");
// export CDK_DEFAULT_REGION=us-east-1
// export CDK_DEFAULT_ACCOUNT=123456789012
// projen bundle:provider/credentials-handler.lambda
// cdk deploy --app 'npx ts-node -P tsconfig.json --prefer-ts-exts ./src/integ.default.ts'
exports.app = new aws_cdk_lib_1.App();
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
exports.stack = new aws_cdk_lib_1.Stack(exports.app, "SesSmtpCredentialsIntegrationTest", { env: env });
const user = new aws_iam_1.User(exports.stack, "User", { userName: "SesTestUser" });
new ses_smtp_credentials_1.SesSmtpCredentials(exports.stack, "Credentials", { user: user });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDZDQUFzRDtBQUN0RCxpREFBMkM7QUFDM0MsaUVBQTREO0FBRTVELHNDQUFzQztBQUN0QywwQ0FBMEM7QUFDMUMsb0RBQW9EO0FBQ3BELDBGQUEwRjtBQUU3RSxRQUFBLEdBQUcsR0FBRyxJQUFJLGlCQUFHLEVBQUUsQ0FBQztBQUU3QixNQUFNLEdBQUcsR0FBZ0I7SUFDdkIsTUFBTSxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsa0JBQWtCO0lBQ3RDLE9BQU8sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLG1CQUFtQjtDQUN6QyxDQUFDO0FBRVcsUUFBQSxLQUFLLEdBQUcsSUFBSSxtQkFBSyxDQUFDLFdBQUcsRUFBRSxtQ0FBbUMsRUFBRSxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsQ0FBQyxDQUFDO0FBRXZGLE1BQU0sSUFBSSxHQUFHLElBQUksY0FBSSxDQUFDLGFBQUssRUFBRSxNQUFNLEVBQUUsRUFBRSxRQUFRLEVBQUUsYUFBYSxFQUFFLENBQUMsQ0FBQztBQUVsRSxJQUFJLHlDQUFrQixDQUFDLGFBQUssRUFBRSxhQUFhLEVBQUUsRUFBRSxJQUFJLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFwcCwgRW52aXJvbm1lbnQsIFN0YWNrIH0gZnJvbSBcImF3cy1jZGstbGliXCI7XG5pbXBvcnQgeyBVc2VyIH0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1pYW1cIjtcbmltcG9ydCB7IFNlc1NtdHBDcmVkZW50aWFscyB9IGZyb20gXCIuL3Nlcy1zbXRwLWNyZWRlbnRpYWxzXCI7XG5cbi8vIGV4cG9ydCBDREtfREVGQVVMVF9SRUdJT049dXMtZWFzdC0xXG4vLyBleHBvcnQgQ0RLX0RFRkFVTFRfQUNDT1VOVD0xMjM0NTY3ODkwMTJcbi8vIHByb2plbiBidW5kbGU6cHJvdmlkZXIvY3JlZGVudGlhbHMtaGFuZGxlci5sYW1iZGFcbi8vIGNkayBkZXBsb3kgLS1hcHAgJ25weCB0cy1ub2RlIC1QIHRzY29uZmlnLmpzb24gLS1wcmVmZXItdHMtZXh0cyAuL3NyYy9pbnRlZy5kZWZhdWx0LnRzJ1xuXG5leHBvcnQgY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuXG5jb25zdCBlbnY6IEVudmlyb25tZW50ID0ge1xuICByZWdpb246IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX1JFR0lPTixcbiAgYWNjb3VudDogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfQUNDT1VOVCxcbn07XG5cbmV4cG9ydCBjb25zdCBzdGFjayA9IG5ldyBTdGFjayhhcHAsIFwiU2VzU210cENyZWRlbnRpYWxzSW50ZWdyYXRpb25UZXN0XCIsIHsgZW52OiBlbnYgfSk7XG5cbmNvbnN0IHVzZXIgPSBuZXcgVXNlcihzdGFjaywgXCJVc2VyXCIsIHsgdXNlck5hbWU6IFwiU2VzVGVzdFVzZXJcIiB9KTtcblxubmV3IFNlc1NtdHBDcmVkZW50aWFscyhzdGFjaywgXCJDcmVkZW50aWFsc1wiLCB7IHVzZXI6IHVzZXIgfSk7XG4iXX0=