"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StateMachine = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions = require("aws-cdk-lib/aws-stepfunctions");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
class StateMachine extends aws_stepfunctions.StateMachine {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            definition: new aws_stepfunctions_1.Pass(scope, 'THISWILLBEDELETEDRIGHTAWAY'),
        });
        scope.node.tryRemoveChild('THISWILLBEDELETEDRIGHTAWAY');
        this.node.defaultChild.definitionString = JSON.stringify(StateMachine.smash(props.definition, props.overrides));
    }
    // eslint-disable-next-line @typescript-eslint/member-ordering
    static smash(definition, smash = {}) {
        let states = definition.States;
        for (let key in smash) {
            if (states[key]) {
                states[key] = mergeDeep(states[key], smash[key]);
            }
        }
        return {
            ...definition,
            States: states,
        };
    }
}
exports.StateMachine = StateMachine;
_a = JSII_RTTI_SYMBOL_1;
StateMachine[_a] = { fqn: "@matthewbonig/state-machine.StateMachine", version: "0.0.11" };
/**
 * Performs a deep merge of objects and returns new object. Does not modify
 * objects (immutable) and merges arrays via concatenation.
 *
 * @param {...object} objects - Objects to merge
 * @returns {object} New object with merged key/values
 */
function mergeDeep(...objects) {
    const isObject = (obj) => obj && typeof obj === 'object';
    return objects.reduce((prev, obj) => {
        Object.keys(obj).forEach(key => {
            const pVal = prev[key];
            const oVal = obj[key];
            if (Array.isArray(pVal) && Array.isArray(oVal)) {
                prev[key] = pVal.concat(...oVal);
            }
            else if (isObject(pVal) && isObject(oVal)) {
                prev[key] = mergeDeep(pVal, oVal);
            }
            else {
                prev[key] = oVal;
            }
        });
        return prev;
    }, {});
}
//# sourceMappingURL=data:application/json;base64,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