"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancerListenerProtocol = exports.LoadBalancerType = exports.ContextProvider = void 0;
/**
 * Identifier for the context provider
 */
var ContextProvider;
(function (ContextProvider) {
    /**
     * AMI provider
     */
    ContextProvider["AMI_PROVIDER"] = "ami";
    /**
     * AZ provider
     */
    ContextProvider["AVAILABILITY_ZONE_PROVIDER"] = "availability-zones";
    /**
     * Route53 Hosted Zone provider
     */
    ContextProvider["HOSTED_ZONE_PROVIDER"] = "hosted-zone";
    /**
     * SSM Parameter Provider
     */
    ContextProvider["SSM_PARAMETER_PROVIDER"] = "ssm";
    /**
     * VPC Provider
     */
    ContextProvider["VPC_PROVIDER"] = "vpc-provider";
    /**
     * VPC Endpoint Service AZ Provider
     */
    ContextProvider["ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER"] = "endpoint-service-availability-zones";
    /**
     * Load balancer provider
     */
    ContextProvider["LOAD_BALANCER_PROVIDER"] = "load-balancer";
    /**
     * Load balancer listener provider
     */
    ContextProvider["LOAD_BALANCER_LISTENER_PROVIDER"] = "load-balancer-listener";
    /**
     * Security group provider
     */
    ContextProvider["SECURITY_GROUP_PROVIDER"] = "security-group";
    /**
     * KMS Key Provider
     */
    ContextProvider["KEY_PROVIDER"] = "key-provider";
    /**
     * A plugin provider (the actual plugin name will be in the properties)
     */
    ContextProvider["PLUGIN"] = "plugin";
})(ContextProvider || (exports.ContextProvider = ContextProvider = {}));
/**
 * Type of load balancer
 */
var LoadBalancerType;
(function (LoadBalancerType) {
    /**
     * Network load balancer
     */
    LoadBalancerType["NETWORK"] = "network";
    /**
     * Application load balancer
     */
    LoadBalancerType["APPLICATION"] = "application";
})(LoadBalancerType || (exports.LoadBalancerType = LoadBalancerType = {}));
/**
 * The protocol for connections from clients to the load balancer
 */
var LoadBalancerListenerProtocol;
(function (LoadBalancerListenerProtocol) {
    /**
     * HTTP protocol
     */
    LoadBalancerListenerProtocol["HTTP"] = "HTTP";
    /**
     * HTTPS protocol
     */
    LoadBalancerListenerProtocol["HTTPS"] = "HTTPS";
    /**
     * TCP protocol
     */
    LoadBalancerListenerProtocol["TCP"] = "TCP";
    /**
     * TLS protocol
     */
    LoadBalancerListenerProtocol["TLS"] = "TLS";
    /**
     * UDP protocol
     * */
    LoadBalancerListenerProtocol["UDP"] = "UDP";
    /**
     * TCP and UDP protocol
     * */
    LoadBalancerListenerProtocol["TCP_UDP"] = "TCP_UDP";
})(LoadBalancerListenerProtocol || (exports.LoadBalancerListenerProtocol = LoadBalancerListenerProtocol = {}));
//# sourceMappingURL=data:application/json;base64,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