"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArtifactMetadataEntryType = void 0;
/**
 * Type of artifact metadata entry.
 */
var ArtifactMetadataEntryType;
(function (ArtifactMetadataEntryType) {
    /**
     * Asset in metadata.
     */
    ArtifactMetadataEntryType["ASSET"] = "aws:cdk:asset";
    /**
     * Metadata key used to print INFO-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["INFO"] = "aws:cdk:info";
    /**
     * Metadata key used to print WARNING-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["WARN"] = "aws:cdk:warning";
    /**
     * Metadata key used to print ERROR-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["ERROR"] = "aws:cdk:error";
    /**
     * Represents the CloudFormation logical ID of a resource at a certain path.
     */
    ArtifactMetadataEntryType["LOGICAL_ID"] = "aws:cdk:logicalId";
    /**
     * Represents tags of a stack.
     */
    ArtifactMetadataEntryType["STACK_TAGS"] = "aws:cdk:stack-tags";
})(ArtifactMetadataEntryType || (exports.ArtifactMetadataEntryType = ArtifactMetadataEntryType = {}));
//# sourceMappingURL=data:application/json;base64,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