"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequireApproval = void 0;
/**
 * In what scenarios should the CLI ask for approval
 */
var RequireApproval;
(function (RequireApproval) {
    /**
     * Never ask for approval
     */
    RequireApproval["NEVER"] = "never";
    /**
     * Prompt for approval for any type  of change to the stack
     */
    RequireApproval["ANYCHANGE"] = "any-change";
    /**
     * Only prompt for approval if there are security related changes
     */
    RequireApproval["BROADENING"] = "broadening";
})(RequireApproval || (exports.RequireApproval = RequireApproval = {}));
//# sourceMappingURL=data:application/json;base64,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