import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudinitProviderConfig {
    /**
     * Alias name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit#alias CloudinitProvider#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/cloudinit cloudinit}.
 *
 * @stability stable
 */
export declare class CloudinitProvider extends cdktf.TerraformProvider {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/cloudinit cloudinit} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: CloudinitProviderConfig);
    private _alias?;
    /**
     * @stability stable
     */
    get alias(): string | undefined;
    /**
     * @stability stable
     */
    set alias(value: string | undefined);
    /**
     * @stability stable
     */
    resetAlias(): void;
    /**
     * @stability stable
     */
    get aliasInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
