import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataCloudinitConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/d/config#base64_encode DataCloudinitConfig#base64_encode}.
     *
     * @stability stable
     */
    readonly base64Encode?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/d/config#boundary DataCloudinitConfig#boundary}.
     *
     * @stability stable
     */
    readonly boundary?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/d/config#gzip DataCloudinitConfig#gzip}.
     *
     * @stability stable
     */
    readonly gzip?: boolean | cdktf.IResolvable;
    /**
     * part block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/d/config#part DataCloudinitConfig#part}
     *
     * @stability stable
     */
    readonly part: DataCloudinitConfigPart[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface DataCloudinitConfigPart {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/d/config#content DataCloudinitConfig#content}.
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/d/config#content_type DataCloudinitConfig#content_type}.
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/d/config#filename DataCloudinitConfig#filename}.
     *
     * @stability stable
     */
    readonly filename?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/d/config#merge_type DataCloudinitConfig#merge_type}.
     *
     * @stability stable
     */
    readonly mergeType?: string;
}
export declare function dataCloudinitConfigPartToTerraform(struct?: DataCloudinitConfigPart | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/cloudinit/d/config cloudinit_config}.
 *
 * @stability stable
 */
export declare class DataCloudinitConfig extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/cloudinit/d/config cloudinit_config} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataCloudinitConfigConfig);
    private _base64Encode?;
    /**
     * @stability stable
     */
    get base64Encode(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set base64Encode(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetBase64Encode(): void;
    /**
     * @stability stable
     */
    get base64EncodeInput(): boolean | cdktf.IResolvable | undefined;
    private _boundary?;
    /**
     * @stability stable
     */
    get boundary(): string;
    /**
     * @stability stable
     */
    set boundary(value: string);
    /**
     * @stability stable
     */
    resetBoundary(): void;
    /**
     * @stability stable
     */
    get boundaryInput(): string | undefined;
    private _gzip?;
    /**
     * @stability stable
     */
    get gzip(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set gzip(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGzip(): void;
    /**
     * @stability stable
     */
    get gzipInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get rendered(): string;
    private _part?;
    /**
     * @stability stable
     */
    get part(): DataCloudinitConfigPart[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set part(value: DataCloudinitConfigPart[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get partInput(): cdktf.IResolvable | DataCloudinitConfigPart[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
