"""Operations that can be performed on query results."""

# ruff: noqa: A004

from .classes import ListMerge, Massaman
from .dictstuffs import key_counts, merge as merge_dicts, update_keys
from .funcstuffs import always_true, if_in_list, if_is_instance
from .iterstuffs import merge, merge_lists, merge_sets, merge_tuples, pairwise, window
from .operationstuffs import (
    abs,
    add,
    append,
    clamp,
    decrement,
    default,
    delete,
    div,
    extend,
    format,
    if_else,
    increment,
    lower,
    mod,
    multiply,
    pop,
    pow,
    prepend,
    push,
    replace,
    setter,
    subtract,
    toggle,
    upper,
)

__all__ = [
    "ListMerge",
    "Massaman",
    "abs",
    "add",
    "always_true",
    "append",
    "clamp",
    "decrement",
    "default",
    "delete",
    "div",
    "extend",
    "format",
    "if_else",
    "if_in_list",
    "if_is_instance",
    "increment",
    "key_counts",
    "lower",
    "merge",
    "merge_dicts",
    "merge_lists",
    "merge_sets",
    "merge_tuples",
    "mod",
    "multiply",
    "pairwise",
    "pop",
    "pow",
    "prepend",
    "push",
    "replace",
    "setter",
    "subtract",
    "toggle",
    "update_keys",
    "upper",
    "window",
]
