class t{constructor(t="module-data-content"){this.container=document.getElementById(t),this.currentData=null,this.currentType=null}display(t,e=null){if(this.container)switch(this.currentData=t,this.currentType=e,e||(e=this.detectType(t)),this.container.innerHTML="",e){case"event":this.displayEvent(t);break;case"agent":this.displayAgent(t);break;case"tool":this.displayTool(t);break;case"todo":this.displayTodo(t);break;case"instruction":this.displayInstruction(t);break;case"session":this.displaySession(t);break;case"file_operation":this.displayFileOperation(t);break;case"hook":this.displayHook(t);break;default:this.displayGeneric(t)}else console.warn("UnifiedDataViewer: Container not found")}detectType(t){return t&&"object"==typeof t?t.hook_event_name||t.event_type||t.type&&t.timestamp?"event":t.agent_name||t.agentName||t.name&&("active"===t.status||"completed"===t.status)?"agent":t.tool_name||"TodoWrite"===t.name||"Read"===t.name||t.tool_parameters||t.params&&t.icon||t.name&&"tool"===t.type?"tool":!t.todos||t.name||t.params?t.content&&t.activeForm&&t.status&&!t.name&&!t.params?"todo":t.text&&t.preview&&"user_instruction"===t.type?"instruction":t.session_id&&(t.startTime||t.lastActivity)?"session":t.file_path&&(t.operations||t.operation)?"file_operation":t.event_type&&(t.hook_name||t.subtype)?"hook":"generic":"todo":"generic"}displayEvent(t){let e=`\n            <div class="unified-viewer-header">\n                <h6>${this.formatEventType(t)}</h6>\n                <span class="unified-viewer-timestamp">${this.formatTimestamp(t.timestamp)}</span>\n            </div>\n            <div class="unified-viewer-content">\n        `;if(e+=this.formatEventDetails(t),t.tool_parameters||t.data&&t.data.tool_parameters){const n=t.tool_parameters||t.data.tool_parameters;e+=this.formatParameters(n,"Tool Parameters")}t.data&&Object.keys(t.data).length>0&&(e+=this.formatEventData(t)),e+="</div>",this.container.innerHTML=e}displayAgent(t){const e=this.getAgentIcon(t.name||t.agentName),n=this.formatStatus(t.status);let s=`\n            <div class="unified-viewer-header">\n                <h6>${e} ${t.name||t.agentName||"Unknown Agent"}</h6>\n                <span class="unified-viewer-status">${n}</span>\n            </div>\n            <div class="unified-viewer-content">\n                <div class="detail-row">\n                    <span class="detail-label">Status:</span>\n                    <span class="detail-value">${n}</span>\n                </div>\n                <div class="detail-row">\n                    <span class="detail-label">Session ID:</span>\n                    <span class="detail-value">${t.sessionId||t.session_id||"N/A"}</span>\n                </div>\n                <div class="detail-row">\n                    <span class="detail-label">Timestamp:</span>\n                    <span class="detail-value">${this.formatTimestamp(t.timestamp)}</span>\n                </div>\n        `;t.tools&&t.tools.length>0&&(s+=`\n                <div class="detail-section">\n                    <span class="detail-section-title">Tools Used (${t.tools.length}):</span>\n                    <div class="tools-list">\n                        ${t.tools.map(t=>`\n                            <div class="tool-summary">\n                                <span class="tool-icon">${this.getToolIcon(t.name)}</span>\n                                <span class="tool-name">${t.name}</span>\n                                <span class="tool-status ${this.formatStatusClass(t.status)}">${t.status}</span>\n                            </div>\n                        `).join("")}\n                    </div>\n                </div>\n            `),s+="</div>",this.container.innerHTML=s}displayTool(t){const e=this.getToolIcon(t.name||t.tool_name),n=this.formatStatus(t.status);let s=`\n            <div class="unified-viewer-header">\n                <h6>${e} ${t.name||t.tool_name||"Unknown Tool"}</h6>\n                <span class="unified-viewer-status">${n}</span>\n            </div>\n            <div class="unified-viewer-content">\n                <div class="detail-row">\n                    <span class="detail-label">Type:</span>\n                    <span class="detail-value">Tool</span>\n                </div>\n                <div class="detail-row">\n                    <span class="detail-label">Name:</span>\n                    <span class="detail-value">${t.name||t.tool_name||"Unknown Tool"}</span>\n                </div>\n                <div class="detail-row">\n                    <span class="detail-label">Status:</span>\n                    <span class="detail-value">${n}</span>\n                </div>\n        `;if(t.params||t.tool_parameters){const e=t.params||t.tool_parameters;s+=this.formatParameters(e,"Parameters")}t.timestamp&&(s+=`\n                <div class="detail-row">\n                    <span class="detail-label">Timestamp:</span>\n                    <span class="detail-value">${this.formatTimestamp(t.timestamp)}</span>\n                </div>\n            `),t.result&&(s+=`\n                <div class="detail-section">\n                    <span class="detail-section-title">Result:</span>\n                    <pre class="tool-result">${this.escapeHtml(JSON.stringify(t.result,null,2))}</pre>\n                </div>\n            `),s+="</div>",this.container.innerHTML=s}displayTodo(t){let e,n="Todo List",s=null,a=null;t.todos&&Array.isArray(t.todos)?e=t.todos:t.tool_parameters&&t.tool_parameters.todos?(e=t.tool_parameters.todos,n="TodoWrite",s=t.timestamp,a=t.status):e=Array.isArray(t)?t:t.content&&t.activeForm&&t.status?[t]:[];let o=`\n            <div class="unified-viewer-header">\n                <h6>📝 ${n}</h6>\n                ${a?`<span class="unified-viewer-status">${this.formatStatus(a)}</span>`:""}\n            </div>\n            <div class="unified-viewer-content">\n        `;if(s&&(o+=`\n                <div class="detail-row">\n                    <span class="detail-label">Timestamp:</span>\n                    <span class="detail-value">${this.formatTimestamp(s)}</span>\n                </div>\n            `),e.length>0){const t=this.getTodoStatusCounts(e);o+=`\n                <div class="detail-section">\n                    <span class="detail-section-title">Todo Summary</span>\n                    <div class="todo-summary">\n                        <div class="summary-item completed">\n                            <span class="summary-icon">✅</span>\n                            <span class="summary-count">${t.completed}</span>\n                            <span class="summary-label">Completed</span>\n                        </div>\n                        <div class="summary-item in_progress">\n                            <span class="summary-icon">🔄</span>\n                            <span class="summary-count">${t.in_progress}</span>\n                            <span class="summary-label">In Progress</span>\n                        </div>\n                        <div class="summary-item pending">\n                            <span class="summary-icon">⏳</span>\n                            <span class="summary-count">${t.pending}</span>\n                            <span class="summary-label">Pending</span>\n                        </div>\n                    </div>\n                </div>\n            `,o+=`\n                <div class="detail-section">\n                    <span class="detail-section-title">Todo List (${e.length} items)</span>\n                    <div class="todo-checklist">\n            `,e.forEach((t,e)=>{const n=this.getCheckboxIcon(t.status),s="in_progress"===t.status&&t.activeForm||t.content,a=this.formatStatusClass(t.status);o+=`\n                    <div class="todo-checklist-item ${t.status}">\n                        <div class="todo-checkbox">\n                            <span class="checkbox-icon ${a}">${n}</span>\n                        </div>\n                        <div class="todo-text">\n                            <span class="todo-content">${this.escapeHtml(s)}</span>\n                            <span class="todo-status-badge ${a}">${t.status.replace("_"," ")}</span>\n                        </div>\n                    </div>\n                `}),o+="\n                    </div>\n                </div>\n            "}else o+='\n                <div class="detail-section">\n                    <div class="no-todos">No todo items found</div>\n                </div>\n            ';o+="</div>",this.container.innerHTML=o}displayInstruction(t){let e=`\n            <div class="unified-viewer-header">\n                <h6>💬 User Instruction</h6>\n                <span class="unified-viewer-timestamp">${this.formatTimestamp(t.timestamp)}</span>\n            </div>\n            <div class="unified-viewer-content">\n                <div class="detail-row">\n                    <span class="detail-label">Content:</span>\n                    <div class="detail-value instruction-text">${this.escapeHtml(t.text)}</div>\n                </div>\n                <div class="detail-row">\n                    <span class="detail-label">Length:</span>\n                    <span class="detail-value">${t.text.length} characters</span>\n                </div>\n            </div>\n        `;this.container.innerHTML=e}displaySession(t){let e=`\n            <div class="unified-viewer-header">\n                <h6>🎯 Session: ${t.session_id||t.id}</h6>\n                <span class="unified-viewer-status">${this.formatStatus(t.status||"active")}</span>\n            </div>\n            <div class="unified-viewer-content">\n                <div class="detail-row">\n                    <span class="detail-label">Session ID:</span>\n                    <span class="detail-value">${t.session_id||t.id}</span>\n                </div>\n                <div class="detail-row">\n                    <span class="detail-label">Start Time:</span>\n                    <span class="detail-value">${this.formatTimestamp(t.startTime||t.timestamp)}</span>\n                </div>\n        `;t.working_directory&&(e+=`\n                <div class="detail-row">\n                    <span class="detail-label">Working Directory:</span>\n                    <span class="detail-value">${t.working_directory}</span>\n                </div>\n            `),t.git_branch&&(e+=`\n                <div class="detail-row">\n                    <span class="detail-label">Git Branch:</span>\n                    <span class="detail-value">${t.git_branch}</span>\n                </div>\n            `),void 0!==t.eventCount&&(e+=`\n                <div class="detail-row">\n                    <span class="detail-label">Events:</span>\n                    <span class="detail-value">${t.eventCount}</span>\n                </div>\n            `),e+="</div>",this.container.innerHTML=e}displayFileOperation(t){let e=`\n            <div class="unified-viewer-header">\n                <h6>📄 File: ${t.file_path}</h6>\n                <span class="unified-viewer-count">${t.operations?t.operations.length:1} operation${t.operations&&1!==t.operations.length?"s":""}</span>\n            </div>\n            <div class="unified-viewer-content">\n                <div class="detail-row">\n                    <span class="detail-label">File Path:</span>\n                    <span class="detail-value">${t.file_path}</span>\n                </div>\n        `;t.operations&&Array.isArray(t.operations)&&(e+=`\n                <div class="detail-section">\n                    <span class="detail-section-title">Operations:</span>\n                    <div class="operations-list">\n                        ${t.operations.map(t=>`\n                            <div class="operation-item">\n                                <span class="operation-type">${t.operation}</span>\n                                <span class="operation-timestamp">${this.formatTimestamp(t.timestamp)}</span>\n                            </div>\n                        `).join("")}\n                    </div>\n                </div>\n            `),e+="</div>",this.container.innerHTML=e}displayHook(t){let e=`\n            <div class="unified-viewer-header">\n                <h6>🔗 Hook: ${t.event_type||t.subtype||"unknown"}</h6>\n                <span class="unified-viewer-timestamp">${this.formatTimestamp(t.timestamp)}</span>\n            </div>\n            <div class="unified-viewer-content">\n        `;e+=this.formatHookDetails(t),e+="</div>",this.container.innerHTML=e}displayGeneric(t){let e=`\n            <div class="unified-viewer-header">\n                <h6>📊 Data Details</h6>\n                ${t.timestamp?`<span class="unified-viewer-timestamp">${this.formatTimestamp(t.timestamp)}</span>`:""}\n            </div>\n            <div class="unified-viewer-content">\n        `;if("object"==typeof t&&null!==t){const n=["id","name","type","status","timestamp","text","content","message"];for(let s of n)if(void 0!==t[s]){let n=t[s];"string"==typeof n&&n.length>200&&(n=n.substring(0,200)+"..."),e+=`\n                        <div class="detail-row">\n                            <span class="detail-label">${s}:</span>\n                            <span class="detail-value">${this.escapeHtml(String(n))}</span>\n                        </div>\n                    `}}else e+=`<div class="simple-value">${this.escapeHtml(String(t))}</div>`;e+="</div>",this.container.innerHTML=e}formatEventType(t){return t.type&&t.subtype?t.type===t.subtype||"generic"===t.subtype?t.type:`${t.type}.${t.subtype}`:t.type?t.type:t.hook_event_name?t.hook_event_name:"unknown"}formatEventDetails(t){switch(t.data,t.type){case"hook":return this.formatHookDetails(t);case"agent":return this.formatAgentEventDetails(t);case"todo":return this.formatTodoEventDetails(t);case"session":return this.formatSessionEventDetails(t);default:return this.formatGenericEventDetails(t)}}formatHookDetails(t){const e=t.data||{},n=t.subtype||t.event_type||"unknown";let s=`\n            <div class="detail-row">\n                <span class="detail-label">Hook Type:</span>\n                <span class="detail-value">${n}</span>\n            </div>\n        `;switch(n){case"user_prompt":const t=e.prompt_text||e.prompt_preview||"";s+=`\n                    <div class="detail-row">\n                        <span class="detail-label">Prompt:</span>\n                        <div class="detail-value prompt-text">${this.escapeHtml(t)}</div>\n                    </div>\n                `;break;case"pre_tool":case"post_tool":s+=`\n                    <div class="detail-row">\n                        <span class="detail-label">Tool:</span>\n                        <span class="detail-value">${e.tool_name||"Unknown tool"}</span>\n                    </div>\n                `,e.operation_type&&(s+=`\n                        <div class="detail-row">\n                            <span class="detail-label">Operation:</span>\n                            <span class="detail-value">${e.operation_type}</span>\n                        </div>\n                    `),"post_tool"===n&&e.duration_ms&&(s+=`\n                        <div class="detail-row">\n                            <span class="detail-label">Duration:</span>\n                            <span class="detail-value">${e.duration_ms}ms</span>\n                        </div>\n                    `);break;case"subagent_start":case"subagent_stop":s+=`\n                    <div class="detail-row">\n                        <span class="detail-label">Agent:</span>\n                        <span class="detail-value">${e.agent_type||e.agent||"Unknown"}</span>\n                    </div>\n                `,"subagent_start"===n&&e.prompt&&(s+=`\n                        <div class="detail-row">\n                            <span class="detail-label">Task:</span>\n                            <div class="detail-value">${this.escapeHtml(e.prompt)}</div>\n                        </div>\n                    `),"subagent_stop"===n&&e.reason&&(s+=`\n                        <div class="detail-row">\n                            <span class="detail-label">Reason:</span>\n                            <span class="detail-value">${e.reason}</span>\n                        </div>\n                    `)}return s}formatAgentEventDetails(t){const e=t.data||{};let n="";return(e.agent_type||e.name)&&(n+=`\n                <div class="detail-row">\n                    <span class="detail-label">Agent Type:</span>\n                    <span class="detail-value">${e.agent_type||e.name}</span>\n                </div>\n            `),t.subtype&&(n+=`\n                <div class="detail-row">\n                    <span class="detail-label">Action:</span>\n                    <span class="detail-value">${t.subtype}</span>\n                </div>\n            `),n}formatTodoEventDetails(t){const e=t.data||{};let n="";if(e.todos&&Array.isArray(e.todos)){const t=this.getTodoStatusCounts(e.todos);n+=`\n                <div class="detail-row">\n                    <span class="detail-label">Todo Items:</span>\n                    <span class="detail-value">${e.todos.length} total</span>\n                </div>\n                <div class="detail-row">\n                    <span class="detail-label">Status:</span>\n                    <span class="detail-value">${t.completed} completed, ${t.in_progress} in progress</span>\n                </div>\n            `}return n}formatSessionEventDetails(t){const e=t.data||{};let n="";return e.session_id&&(n+=`\n                <div class="detail-row">\n                    <span class="detail-label">Session ID:</span>\n                    <span class="detail-value">${e.session_id}</span>\n                </div>\n            `),t.subtype&&(n+=`\n                <div class="detail-row">\n                    <span class="detail-label">Action:</span>\n                    <span class="detail-value">${t.subtype}</span>\n                </div>\n            `),n}formatGenericEventDetails(t){const e=t.data||{};let n="";const s=["message","description","value","result"];for(let a of s)if(void 0!==e[a]){let t=e[a];"string"==typeof t&&t.length>200&&(t=t.substring(0,200)+"..."),n+=`\n                    <div class="detail-row">\n                        <span class="detail-label">${a}:</span>\n                        <span class="detail-value">${this.escapeHtml(String(t))}</span>\n                    </div>\n                `}return n}formatEventData(t){const e=t.data;return e&&0!==Object.keys(e).length?`\n            <div class="detail-section">\n                <span class="detail-section-title">Event Data:</span>\n                <pre class="event-data-json">${this.escapeHtml(JSON.stringify(e,null,2))}</pre>\n            </div>\n        `:""}formatParameters(t,e="Parameters"){if(!t||0===Object.keys(t).length)return`\n                <div class="detail-section">\n                    <span class="detail-section-title">${e}:</span>\n                    <div class="no-params">No parameters</div>\n                </div>\n            `;const n=Object.keys(t);return`\n            <div class="detail-section">\n                <span class="detail-section-title">${e} (${n.length}):</span>\n                <div class="params-list">\n                    ${n.map(e=>{const n=t[e];return`\n                            <div class="param-item">\n                                <div class="param-key">${e}:</div>\n                                <div class="param-value">${this.formatParameterValue(n)}</div>\n                            </div>\n                        `}).join("")}\n                </div>\n            </div>\n        `}formatParameterValue(t){if("string"==typeof t)return t.length>500?`<pre class="param-text-long">${this.escapeHtml(t.substring(0,500)+"...\n\n[Content truncated - "+t.length+" total characters]")}</pre>`:t.length>100?`<pre class="param-text">${this.escapeHtml(t)}</pre>`:`<span class="param-text-short">${this.escapeHtml(t)}</span>`;if("object"!=typeof t||null===t)return`<span class="param-primitive">${this.escapeHtml(String(t))}</span>`;if(Array.isArray(t)&&t.length>0&&t[0].hasOwnProperty("content")&&t[0].hasOwnProperty("status"))return this.formatTodosAsParameter(t);try{return`<pre class="param-json">${this.escapeHtml(JSON.stringify(t,null,2))}</pre>`}catch(e){return'<span class="param-error">Error displaying object</span>'}}formatTodosAsParameter(t){const e=this.getTodoStatusCounts(t);let n=`\n            <div class="param-todos">\n                <div class="param-todos-header">\n                    Array of todo objects (${t.length} items)\n                </div>\n                <div class="param-todos-summary">\n                    ${e.completed} completed • ${e.in_progress} in progress • ${e.pending} pending\n                </div>\n                <div class="param-todos-list">\n        `;return t.forEach((t,e)=>{const s=this.getCheckboxIcon(t.status),a="in_progress"===t.status&&t.activeForm||t.content,o=this.formatStatusClass(t.status);n+=`\n                <div class="param-todo-item ${t.status}">\n                    <div class="param-todo-checkbox">\n                        <span class="param-checkbox-icon ${o}">${s}</span>\n                    </div>\n                    <div class="param-todo-text">\n                        <span class="param-todo-content">${this.escapeHtml(a)}</span>\n                        <span class="param-todo-status-badge ${o}">${t.status.replace("_"," ")}</span>\n                    </div>\n                </div>\n            `}),n+="\n                </div>\n            </div>\n        ",n}formatTimestamp(t){if(!t)return"Unknown time";try{const e=new Date(t);return isNaN(e.getTime())?"Invalid date":e.toLocaleString()}catch(e){return"Invalid date"}}formatStatus(t){if(!t)return"unknown";return{active:"🟢 Active",completed:"✅ Completed",in_progress:"🔄 In Progress",pending:"⏳ Pending",error:"❌ Error",failed:"❌ Failed"}[t]||t}formatStatusClass(t){return`status-${t}`}getAgentIcon(t){return{PM:"🎯",Engineer:"🔧","Engineer Agent":"🔧",Research:"🔍","Research Agent":"🔍",QA:"✅","QA Agent":"✅",Architect:"🏗️","Architect Agent":"🏗️",Ops:"⚙️","Ops Agent":"⚙️"}[t]||"🤖"}getToolIcon(t){return{Read:"👁️",Write:"✍️",Edit:"✏️",MultiEdit:"📝",Bash:"💻",Grep:"🔍",Glob:"📂",LS:"📁",TodoWrite:"📝",Task:"📋",WebFetch:"🌐"}[t]||"🔧"}getCheckboxIcon(t){return{pending:"⏳",in_progress:"🔄",completed:"✅"}[t]||"❓"}getTodoStatusCounts(t){const e={completed:0,in_progress:0,pending:0};return t.forEach(t=>{e.hasOwnProperty(t.status)&&e[t.status]++}),e}escapeHtml(t){if("string"!=typeof t)return"";const e=document.createElement("div");return e.textContent=t,e.innerHTML}clear(){this.container&&(this.container.innerHTML=""),this.currentData=null,this.currentType=null}getCurrentData(){return this.currentData}getCurrentType(){return this.currentType}hasData(){return null!==this.currentData}}window.UnifiedDataViewer=t;class e{constructor(e){this.container=document.getElementById(e),this.dataContainer=null,this.jsonContainer=null,this.currentEvent=null,this.eventsByClass=new Map,this.globalJsonExpanded="true"===localStorage.getItem("dashboard-json-expanded"),this.keyboardListenerAdded=!1,this.unifiedViewer=new t("module-data-content"),this.init()}init(){this.setupContainers(),this.setupEventHandlers(),this.showEmptyState()}setupContainers(){this.dataContainer=document.getElementById("module-data-content"),this.jsonContainer=null,this.dataContainer||console.error("Module viewer data container not found")}setupEventHandlers(){document.addEventListener("eventSelected",t=>{this.showEventDetails(t.detail.event)}),document.addEventListener("eventSelectionCleared",()=>{this.showEmptyState()}),document.addEventListener("socketEventUpdate",t=>{this.updateEventsByClass(t.detail.events)})}showEmptyState(){this.dataContainer&&(this.dataContainer.innerHTML='\n                <div class="module-empty">\n                    <p>Click on an event to view structured data</p>\n                    <p class="module-hint">Data is organized by event type</p>\n                </div>\n            '),this.currentEvent=null}showEventDetails(t){if(this.currentEvent=t,!this.unifiedViewer)return console.warn("ModuleViewer: UnifiedDataViewer not available"),this.renderStructuredData(t),void this.renderJsonData(t);this.unifiedViewer.display(t,"event")}renderStructuredData(t){if(!this.dataContainer)return;const e=this.createContextualHeader(t),n=this.createEventStructuredView(t),s=this.createCollapsibleJsonSection(t);this.dataContainer.innerHTML=e+n+s,this.initializeJsonToggle()}renderJsonData(t){}ingest(t){Array.isArray(t)?t.length>0?this.showEventDetails(t[0]):this.showEmptyState():t&&"object"==typeof t?this.showEventDetails(t):this.showEmptyState()}updateEventsByClass(t){this.eventsByClass.clear(),t.forEach(t=>{const e=this.getEventClass(t);this.eventsByClass.has(e)||this.eventsByClass.set(e,[]),this.eventsByClass.get(e).push(t)})}getEventClass(t){if(!t.type)return"unknown";switch(t.type){case"session":return"Session Management";case"claude":return"Claude Interactions";case"agent":return"Agent Operations";case"hook":return"Hook System";case"todo":return"Task Management";case"memory":return"Memory Operations";case"log":return"System Logs";case"connection":return"Connection Events";default:return"Other Events"}}createContextualHeader(t){const e=this.formatTimestamp(t.timestamp),n=t.data||{};let s="";switch(t.type){case"hook":const a=this.extractToolName(n),o=this.extractAgent(t)||"Unknown";if(a)s=`${a}: ${o} ${e}`;else{s=`${this.getHookDisplayName(t,n)}: ${o} ${e}`}break;case"agent":s=`Agent: ${n.agent_type||n.name||"Unknown"} ${e}`;break;case"todo":s=`TodoWrite: ${this.extractAgent(t)||"PM"} ${e}`;break;case"memory":s=`Memory: ${n.operation||"Unknown"} ${e}`;break;case"session":case"claude":case"log":case"connection":s=`Event: ${t.type}.${t.subtype||"default"} ${e}`;break;default:const i=this.extractFileName(n);if(i)s=`File: ${i} ${e}`;else{s=`Event: ${t.type||"Unknown"}.${t.subtype||"default"} ${e}`}}return`\n            <div class="contextual-header">\n                <h3 class="contextual-header-text">${s}</h3>\n            </div>\n        `}createEventStructuredView(t){const e=this.getEventClass(t),n=(this.eventsByClass.get(e)||[]).length;let s=`\n            <div class="structured-view-section">\n                ${this.createEventDetailCard(t.type,t,n)}\n            </div>\n        `;switch(t.type){case"agent":s+=this.createAgentStructuredView(t);break;case"hook":"Task"===t.data?.tool_name&&t.data?.tool_parameters?.subagent_type?s+=this.createAgentStructuredView(t):s+=this.createHookStructuredView(t);break;case"todo":s+=this.createTodoStructuredView(t);break;case"memory":s+=this.createMemoryStructuredView(t);break;case"claude":s+=this.createClaudeStructuredView(t);break;case"session":s+=this.createSessionStructuredView(t);break;default:s+=this.createGenericStructuredView(t)}return s}createEventDetailCard(t,e,n){const s=new Date(e.timestamp).toLocaleString();return`\n            <div class="event-detail-card">\n                <div class="event-detail-header">\n                    <div class="event-detail-title">\n                        ${this.getEventIcon(t)} ${t||"Unknown"}.${e.subtype||"default"}\n                    </div>\n                    <div class="event-detail-time">${s}</div>\n                </div>\n                <div class="event-detail-content">\n                    ${this.createProperty("Event ID",e.id||"N/A")}\n                    ${this.createProperty("Type",`${t}.${e.subtype||"default"}`)}\n                    ${this.createProperty("Class Events",n)}\n                    ${e.data&&e.data.session_id?this.createProperty("Session",e.data.session_id):""}\n                </div>\n            </div>\n        `}createAgentStructuredView(t){const e=t.data||{};if("hook"===t.type&&"Task"===e.tool_name&&e.tool_parameters?.subagent_type){const n=e.tool_parameters;return`\n                <div class="structured-view-section">\n                    <div class="structured-data">\n                        ${this.createProperty("Agent Type",n.subagent_type)}\n                        ${this.createProperty("Task Type","Subagent Delegation")}\n                        ${this.createProperty("Phase",t.subtype||"pre_tool")}\n                        ${n.description?this.createProperty("Description",n.description):""}\n                        ${n.prompt?this.createProperty("Prompt Preview",this.truncateText(n.prompt,200)):""}\n                        ${e.session_id?this.createProperty("Session ID",e.session_id):""}\n                        ${e.working_directory?this.createProperty("Working Directory",e.working_directory):""}\n                    </div>\n                    ${n.prompt?`\n                        <div class="prompt-section">\n                            <div class="contextual-header">\n                                <h3 class="contextual-header-text">📝 Task Prompt</h3>\n                            </div>\n                            <div class="structured-data">\n                                <div class="task-prompt" style="white-space: pre-wrap; max-height: 300px; overflow-y: auto; padding: 10px; background: #f8fafc; border-radius: 6px; font-family: monospace; font-size: 12px; line-height: 1.4;">\n                                    ${n.prompt}\n                                </div>\n                            </div>\n                        </div>\n                    `:""}\n                </div>\n            `}return`\n            <div class="structured-view-section">\n                <div class="structured-data">\n                    ${this.createProperty("Agent Type",e.agent_type||e.subagent_type||"Unknown")}\n                    ${this.createProperty("Name",e.name||"N/A")}\n                    ${this.createProperty("Phase",t.subtype||"N/A")}\n                    ${e.config?this.createProperty("Config","object"==typeof e.config?Object.keys(e.config).join(", "):String(e.config)):""}\n                    ${e.capabilities?this.createProperty("Capabilities",e.capabilities.join(", ")):""}\n                    ${e.result?this.createProperty("Result","object"==typeof e.result?"[Object]":String(e.result)):""}\n                </div>\n            </div>\n        `}createHookStructuredView(t){const e=t.data||{},n=this.extractFilePathFromHook(e),s=this.extractToolInfoFromHook(e),a=this.createInlineToolResultContent(e,t);return`\n            <div class="structured-view-section">\n                <div class="structured-data">\n                    ${this.createProperty("Hook Name",this.getHookDisplayName(t,e))}\n                    ${this.createProperty("Event Type",e.event_type||t.subtype||"N/A")}\n                    ${n?this.createProperty("File Path",n):""}\n                    ${s.tool_name?this.createProperty("Tool",s.tool_name):""}\n                    ${s.operation_type?this.createProperty("Operation",s.operation_type):""}\n                    ${e.session_id?this.createProperty("Session ID",e.session_id):""}\n                    ${e.working_directory?this.createProperty("Working Directory",e.working_directory):""}\n                    ${e.duration_ms?this.createProperty("Duration",`${e.duration_ms}ms`):""}\n                    ${a}\n                </div>\n            </div>\n        `}createInlineToolResultContent(t,e=null){const n=t.result_summary,s=e?.subtype||t.event_type||t.phase,a="post_tool"===s||s?.includes("post");if(window.DEBUG_TOOL_RESULTS&&console.log("🔧 createInlineToolResultContent debug:",{hasResultSummary:!!n,eventPhase:s,isPostTool:a,eventSubtype:e?.subtype,dataEventType:t.event_type,dataPhase:t.phase,toolName:t.tool_name,resultSummaryKeys:n?Object.keys(n):[]}),!n)return"";if("pre_tool"===s||s?.includes("pre")&&!s?.includes("post"))return"";let o="";if(n.has_output&&n.output_preview&&(o+=`\n                ${this.createProperty("Output",this.truncateText(n.output_preview,200))}\n                ${n.output_lines?this.createProperty("Output Lines",n.output_lines):""}\n            `),n.has_error&&n.error_preview&&(o+=`\n                ${this.createProperty("Error",this.truncateText(n.error_preview,200))}\n            `),!n.has_output&&!n.has_error&&Object.keys(n).length>3){o+=Object.entries(n).filter(([t,e])=>!["has_output","has_error","exit_code"].includes(t)&&void 0!==e).map(([t,e])=>this.createProperty(this.formatFieldName(t),String(e))).join("")}return o}createToolResultSection(t,e=null){const n=t.result_summary,s=e?.subtype||t.event_type||t.phase,a="post_tool"===s||s?.includes("post");if(window.DEBUG_TOOL_RESULTS&&console.log("🔧 createToolResultSection debug:",{hasResultSummary:!!n,eventPhase:s,isPostTool:a,eventSubtype:e?.subtype,dataEventType:t.event_type,dataPhase:t.phase,toolName:t.tool_name,resultSummaryKeys:n?Object.keys(n):[]}),!n)return"";if("pre_tool"===s||s?.includes("pre")&&!s?.includes("post"))return"";let o="⏳",i="tool-running",r="Unknown";!0===t.success?(o="✅",i="tool-success",r="Success"):!1===t.success?(o="❌",i="tool-failure",r="Failed"):0===t.exit_code?(o="✅",i="tool-success",r="Completed"):2===t.exit_code?(o="⚠️",i="tool-blocked",r="Blocked"):void 0!==t.exit_code&&0!==t.exit_code&&(o="❌",i="tool-failure",r="Error");let l="";if(l+=`\n            <div class="tool-result-status ${i}">\n                <span class="tool-result-icon">${o}</span>\n                <span class="tool-result-text">${r}</span>\n                ${void 0!==t.exit_code?`<span class="tool-exit-code">Exit Code: ${t.exit_code}</span>`:""}\n            </div>\n        `,n.has_output&&n.output_preview&&(l+=`\n                <div class="tool-result-output">\n                    <div class="tool-result-label">📄 Output:</div>\n                    <div class="tool-result-preview">\n                        <pre>${this.escapeHtml(n.output_preview)}</pre>\n                    </div>\n                    ${n.output_lines?`<div class="tool-result-meta">Lines: ${n.output_lines}</div>`:""}\n                </div>\n            `),n.has_error&&n.error_preview&&(l+=`\n                <div class="tool-result-error">\n                    <div class="tool-result-label">⚠️ Error:</div>\n                    <div class="tool-result-preview error-preview">\n                        <pre>${this.escapeHtml(n.error_preview)}</pre>\n                    </div>\n                </div>\n            `),!n.has_output&&!n.has_error&&Object.keys(n).length>3){const t=Object.entries(n).filter(([t,e])=>!["has_output","has_error","exit_code"].includes(t)&&void 0!==e).map(([t,e])=>this.createProperty(this.formatFieldName(t),String(e))).join("");t&&(l+=`\n                    <div class="tool-result-other">\n                        <div class="tool-result-label">📊 Result Details:</div>\n                        <div class="structured-data">\n                            ${t}\n                        </div>\n                    </div>\n                `)}return l.trim()?`\n            <div class="tool-result-section">\n                <div class="contextual-header">\n                    <h3 class="contextual-header-text">🔧 Tool Result</h3>\n                </div>\n                <div class="tool-result-content">\n                    ${l}\n                </div>\n            </div>\n        `:""}isWriteOperation(t,e){if(["Write","Edit","MultiEdit","NotebookEdit"].includes(t))return!0;if(e.tool_parameters){const t=e.tool_parameters;if(t.content||t.new_string||t.edits)return!0;if(t.edit_mode&&"read"!==t.edit_mode)return!0}return!("post_tool"!==e.event_type&&"pre_tool"!==e.event_type||!t||!(t.toLowerCase().includes("write")||t.toLowerCase().includes("edit")||t.toLowerCase().includes("modify")))}isReadOnlyOperation(t){if(!t)return!0;const e=t.toLowerCase();return!!["read"].includes(e)||!["write","edit","multiedit","create","delete","move","copy"].includes(e)}createTodoStructuredView(t){const e=t.data||{};let n="";return e.todos&&Array.isArray(e.todos)&&(n+=`\n                <div class="todo-checklist">\n                    ${e.todos.map(t=>`\n                        <div class="todo-item todo-${t.status||"pending"}">\n                            <span class="todo-status">${this.getTodoStatusIcon(t.status)}</span>\n                            <span class="todo-content">${t.content||"No content"}</span>\n                            <span class="todo-priority priority-${t.priority||"medium"}">${this.getTodoPriorityIcon(t.priority)}</span>\n                        </div>\n                    `).join("")}\n                </div>\n            `),n}createMemoryStructuredView(t){const e=t.data||{};return`\n            <div class="structured-view-section">\n                <div class="structured-data">\n                    ${this.createProperty("Operation",e.operation||"Unknown")}\n                    ${this.createProperty("Key",e.key||"N/A")}\n                    ${e.value?this.createProperty("Value","object"==typeof e.value?"[Object]":String(e.value)):""}\n                    ${e.namespace?this.createProperty("Namespace",e.namespace):""}\n                    ${e.metadata?this.createProperty("Metadata","object"==typeof e.metadata?"[Object]":String(e.metadata)):""}\n                </div>\n            </div>\n        `}createClaudeStructuredView(t){const e=t.data||{};return`\n            <div class="structured-view-section">\n                <div class="structured-data">\n                    ${this.createProperty("Type",t.subtype||"N/A")}\n                    ${e.prompt?this.createProperty("Prompt",this.truncateText(e.prompt,200)):""}\n                    ${e.message?this.createProperty("Message",this.truncateText(e.message,200)):""}\n                    ${e.response?this.createProperty("Response",this.truncateText(e.response,200)):""}\n                    ${e.content?this.createProperty("Content",this.truncateText(e.content,200)):""}\n                    ${e.tokens?this.createProperty("Tokens",e.tokens):""}\n                    ${e.model?this.createProperty("Model",e.model):""}\n                </div>\n            </div>\n        `}createSessionStructuredView(t){const e=t.data||{};return`\n            <div class="structured-view-section">\n                <div class="structured-data">\n                    ${this.createProperty("Action",t.subtype||"N/A")}\n                    ${this.createProperty("Session ID",e.session_id||"N/A")}\n                    ${e.working_directory?this.createProperty("Working Dir",e.working_directory):""}\n                    ${e.git_branch?this.createProperty("Git Branch",e.git_branch):""}\n                    ${e.agent_type?this.createProperty("Agent Type",e.agent_type):""}\n                </div>\n            </div>\n        `}createGenericStructuredView(t){const e=t.data||{},n=Object.keys(e);return 0===n.length?"":`\n            <div class="structured-view-section">\n                <div class="structured-data">\n                    ${n.map(t=>this.createProperty(t,"object"==typeof e[t]?"[Object]":String(e[t]))).join("")}\n                </div>\n            </div>\n        `}createCollapsibleJsonSection(t){const e="json-section-"+Math.random().toString(36).substr(2,9),n=this.formatJSON(t),s=this.globalJsonExpanded;return`\n            <div class="collapsible-json-section" id="${e}">\n                <div class="json-toggle-header"\n                     onclick="window.moduleViewer.toggleJsonSection()"\n                     role="button"\n                     tabindex="0"\n                     aria-expanded="${s?"true":"false"}"\n                     onkeydown="if(event.key==='Enter'||event.key===' '){window.moduleViewer.toggleJsonSection();event.preventDefault();}">\n                    <span class="json-toggle-text">Raw JSON</span>\n                    <span class="json-toggle-arrow">${s?"▲":"▼"}</span>\n                </div>\n                <div class="json-content-collapsible" style="display: ${s?"block":"none"};" aria-hidden="${!s}">\n                    <div class="json-display" onclick="window.moduleViewer.copyJsonToClipboard(event)">\n                        <pre>${n}</pre>\n                    </div>\n                </div>\n            </div>\n        `}async copyJsonToClipboard(t){const e=t.currentTarget.getBoundingClientRect(),n=t.clientX-e.left,s=t.clientY-e.top;if(n>e.width-50&&s<30){const e=t.currentTarget.querySelector("pre");if(e)try{await navigator.clipboard.writeText(e.textContent),this.showNotification("JSON copied to clipboard","success")}catch(a){console.error("Failed to copy JSON:",a),this.showNotification("Failed to copy JSON","error")}t.stopPropagation()}}initializeJsonToggle(){window.moduleViewer=this,this.globalJsonExpanded&&setTimeout(()=>{this.updateAllJsonSections()},0),this.keyboardListenerAdded||(this.keyboardListenerAdded=!0,document.addEventListener("keydown",t=>{t.target.classList.contains("json-toggle-header")&&("Enter"!==t.key&&" "!==t.key||(this.toggleJsonSection(),t.preventDefault()))}))}toggleJsonSection(){this.globalJsonExpanded=!this.globalJsonExpanded,localStorage.setItem("dashboard-json-expanded",this.globalJsonExpanded.toString()),this.updateAllJsonSections(),document.dispatchEvent(new CustomEvent("jsonToggleChanged",{detail:{expanded:this.globalJsonExpanded}}))}updateAllJsonSections(){const t=document.querySelectorAll(".json-content-collapsible"),e=document.querySelectorAll(".json-toggle-arrow"),n=document.querySelectorAll(".json-toggle-header");t.forEach((t,s)=>{this.globalJsonExpanded?(t.style.display="block",t.setAttribute("aria-hidden","false"),e[s]&&(e[s].textContent="▲"),n[s]&&n[s].setAttribute("aria-expanded","true")):(t.style.display="none",t.setAttribute("aria-hidden","true"),e[s]&&(e[s].textContent="▼"),n[s]&&n[s].setAttribute("aria-expanded","false"))}),this.globalJsonExpanded&&t.length>0&&setTimeout(()=>{const e=t[0];e&&e.scrollIntoView({behavior:"smooth",block:"nearest"})},100)}createProperty(t,e){const n=this.truncateText(String(e),300);return this.isFilePathProperty(t,e)?`\n                <div class="event-property">\n                    <span class="event-property-key">${t}:</span>\n                    <span class="event-property-value">\n                        ${this.createClickableFilePath(e)}\n                    </span>\n                </div>\n            `:`\n            <div class="event-property">\n                <span class="event-property-key">${t}:</span>\n                <span class="event-property-value">${n}</span>\n            </div>\n        `}isFilePathProperty(t,e){if(["File Path","file_path","notebook_path","Full Path","Working Directory","working_directory"].some(e=>t.toLowerCase().includes(e.toLowerCase()))){const t=String(e);return t.length>0&&(t.includes("/")||t.includes("\\"))&&t.length<500}return!1}createClickableFilePath(t){const e=this.truncateText(String(t),300);return`\n            <span class="clickable-file-path"\n                  onclick="showFileViewerModal('${t.replace(/'/g,"\\'")}')"\n                  title="Click to view file contents with syntax highlighting&#10;Path: ${t}">\n                ${e}\n            </span>\n        `}getEventIcon(t){const e={session:"📱",claude:"🤖",agent:"🎯",hook:"🔗",todo:"✅",memory:"🧠",log:"📝",connection:"🔌",unknown:"❓"};return e[t]||e.unknown}getTodoStatusIcon(t){const e={completed:"✅",in_progress:"🔄",pending:"⏳",cancelled:"❌"};return e[t]||e.pending}getTodoPriorityIcon(t){const e={high:"🔴",medium:"🟡",low:"🟢"};return e[t]||e.medium}getHookDisplayName(t,e){if(e.hook_name)return e.hook_name;if(e.name)return e.name;const n=t.subtype||e.event_type,s={user_prompt:"User Prompt",pre_tool:"Tool Execution (Pre)",post_tool:"Tool Execution (Post)",notification:"Notification",stop:"Session Stop",subagent_stop:"Subagent Stop"};if(s[n])return s[n];if("string"==typeof t.type&&t.type.startsWith("hook.")){const e=t.type.replace("hook.","");if(s[e])return s[e]}return n?n.split("_").map(t=>t.charAt(0).toUpperCase()+t.slice(1)).join(" "):"Unknown Hook"}extractFilePathFromHook(t){return t.tool_parameters&&t.tool_parameters.file_path?t.tool_parameters.file_path:t.file_path?t.file_path:t.tool_input&&t.tool_input.file_path?t.tool_input.file_path:t.tool_parameters&&t.tool_parameters.notebook_path?t.tool_parameters.notebook_path:null}extractToolInfoFromHook(t){return{tool_name:t.tool_name||t.tool_parameters&&t.tool_parameters.tool_name,operation_type:t.operation_type||t.tool_parameters&&t.tool_parameters.operation_type}}truncateText(t,e){return!t||t.length<=e?t:t.substring(0,e)+"..."}formatOperationDetails(t){if(!t||"object"!=typeof t)return"";let e="";if(t.parameters&&t.parameters.command&&(e+=`<br><strong>Command:</strong> <code>${this.escapeHtml(t.parameters.command)}</code>`),void 0!==t.success&&(e+="<br><strong>Status:</strong> "+(t.success?"✅ Success":"❌ Failed")),void 0!==t.exit_code&&null!==t.exit_code&&(e+=`<br><strong>Exit Code:</strong> ${t.exit_code}`),void 0!==t.duration_ms&&null!==t.duration_ms){e+=`<br><strong>Duration:</strong> ${t.duration_ms>1e3?`${(t.duration_ms/1e3).toFixed(2)}s`:`${t.duration_ms}ms`}`}return t.error&&(e+=`<br><strong>Error:</strong> ${this.escapeHtml(this.truncateText(t.error,200))}`),e}escapeHtml(t){if(!t)return"";const e=document.createElement("div");return e.textContent=t,e.innerHTML}formatJSON(t){try{return JSON.stringify(t,null,2)}catch(e){return String(t)}}formatTimestamp(t){if(!t)return"Unknown time";try{return new Date(t).toLocaleTimeString("en-US",{hour:"numeric",minute:"2-digit",second:"2-digit",hour12:!0})}catch(e){return"Invalid time"}}escapeHtml(t){if(!t)return"";const e=document.createElement("div");return e.textContent=t,e.innerHTML}formatFieldName(t){return t.split("_").map(t=>t.charAt(0).toUpperCase()+t.slice(1)).join(" ")}extractToolName(t){if(t.tool_name)return t.tool_name;if(t.tool_parameters&&t.tool_parameters.tool_name)return t.tool_parameters.tool_name;if(t.tool_input&&t.tool_input.tool_name)return t.tool_input.tool_name;if(t.tool_parameters){if(t.tool_parameters.file_path||t.tool_parameters.notebook_path)return"FileOperation";if(t.tool_parameters.pattern)return"Search";if(t.tool_parameters.command)return"Bash";if(t.tool_parameters.todos)return"TodoWrite"}return null}extractAgent(t){if(t._agentName&&"Unknown Agent"!==t._agentName)return t._agentName;if(t._inference&&t._inference.agentName&&"Unknown"!==t._inference.agentName)return t._inference.agentName;if(t.agent)return t.agent;if(t.agent_type)return t.agent_type;if(t.agent_name)return t.agent_name;if(t.session_id&&"string"==typeof t.session_id){const e=t.session_id.split("_");if(e.length>1)return e[0].toUpperCase()}return t.todos||"TodoWrite"===t.tool_name?"PM":null}extractFileName(t){const e=this.extractFilePathFromHook(t);if(e){const t=e.split("/");return t[t.length-1]}return t.filename?t.filename:t.file?t.file:null}clear(){this.unifiedViewer&&this.unifiedViewer.clear(),this.showEmptyState()}showToolCall(t,e){if(!t)return void this.showEmptyState();const n=t.tool_name||"Unknown Tool",s=t.agent_type||"PM",a=this.formatTimestamp(t.timestamp),o=t.pre_event,i=t.post_event,r=o?.tool_parameters||{},l=o?this.extractToolTarget(n,r):"Unknown target",c=t.duration_ms?`${t.duration_ms}ms`:"-",d=void 0!==t.success?t.success:null;void 0!==t.exit_code&&t.exit_code;let p=t.result_summary||"No summary available";if("object"==typeof p&&null!==p){const t=[];void 0!==p.exit_code&&t.push(`Exit Code: ${p.exit_code}`),void 0!==p.has_output&&t.push("Has Output: "+(p.has_output?"Yes":"No")),void 0!==p.has_error&&t.push("Has Error: "+(p.has_error?"Yes":"No")),void 0!==p.output_lines&&t.push(`Output Lines: ${p.output_lines}`),p.output_preview&&t.push(`Output Preview: ${p.output_preview}`),p.error_preview&&t.push(`Error Preview: ${p.error_preview}`)}let u="⏳",m="Running...",h="tool-running";i&&(!0===d?(u="✅",m="Success",h="tool-success"):!1===d?(u="❌",m="Failed",h="tool-failure"):(u="⏳",m="Completed",h="tool-completed"));const v=`\n            <div class="contextual-header">\n                <h3 class="contextual-header-text">${n}: ${s} ${a}</h3>\n            </div>\n        `;if("TodoWrite"===n&&r.todos){const e=`\n                <div class="todo-checklist">\n                    ${r.todos.map(t=>{const e=this.getTodoStatusIcon(t.status),n=this.getTodoPriorityIcon(t.priority);return`\n                            <div class="todo-item todo-${t.status||"pending"}">\n                                <span class="todo-status">${e}</span>\n                                <span class="todo-content">${t.content||"No content"}</span>\n                                <span class="todo-priority priority-${t.priority||"medium"}">${n}</span>\n                            </div>\n                        `}).join("")}\n                </div>\n            `,n={toolCall:t,preEvent:o,postEvent:i},s=this.createCollapsibleJsonSection(n);this.dataContainer&&(this.dataContainer.innerHTML=v+e+s),this.initializeJsonToggle()}else if("Grep"===n||"Search"===n||r&&r.pattern&&!r.file_path){const e=r.pattern||"No pattern specified",a=r.path||r.directory||".",l=r.type||r.glob||"all files";let d="";t.result_summary&&(d="string"==typeof t.result_summary?t.result_summary:t.result_summary.output_preview?t.result_summary.output_preview:JSON.stringify(t.result_summary,null,2));const p=`\n                <div class="structured-view-section">\n                    <div class="tool-call-details">\n                        <div class="tool-call-info ${h}">\n                            <div class="structured-field">\n                                <strong>Tool Name:</strong> ${n}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Agent:</strong> ${s}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Status:</strong> ${u} ${m}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Search Pattern:</strong> <code>${e}</code>\n                            </div>\n                            <div class="structured-field">\n                                <strong>Search Path:</strong> ${a}\n                            </div>\n                            <div class="structured-field">\n                                <strong>File Type:</strong> ${l}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Started:</strong> ${new Date(t.timestamp).toLocaleString()}\n                            </div>\n                            ${c&&"-"!==c?`\n                                <div class="structured-field">\n                                    <strong>Duration:</strong> ${c}\n                                </div>\n                            `:""}\n                        </div>\n\n                        <div class="search-view-action" style="margin-top: 20px;">\n                            <button class="btn-view-search" data-search-params='${JSON.stringify(r)}' data-search-results='${JSON.stringify(d).replace(/'/g,"&#39;")}' onclick="window.showSearchViewerModal(JSON.parse(this.getAttribute('data-search-params')), JSON.parse(this.getAttribute('data-search-results')))">\n                                🔍 View Search Details\n                            </button>\n                        </div>\n\n                        ${this.createToolResultFromToolCall(t)}\n                    </div>\n                </div>\n            `,g={toolCall:t,preEvent:o,postEvent:i},f=this.createCollapsibleJsonSection(g);this.dataContainer&&(this.dataContainer.innerHTML=v+p+f),this.initializeJsonToggle()}else{const e=`\n                <div class="structured-view-section">\n                    <div class="tool-call-details">\n                        <div class="tool-call-info ${h}">\n                            <div class="structured-field">\n                                <strong>Tool Name:</strong> ${n}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Agent:</strong> ${s}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Status:</strong> ${u} ${m}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Target:</strong> ${l}\n                            </div>\n                            <div class="structured-field">\n                                <strong>Started:</strong> ${new Date(t.timestamp).toLocaleString()}\n                            </div>\n                            ${c&&"-"!==c?`\n                                <div class="structured-field">\n                                    <strong>Duration:</strong> ${c}\n                                </div>\n                            `:""}\n                            ${t.session_id?`\n                                <div class="structured-field">\n                                    <strong>Session ID:</strong> ${t.session_id}\n                                </div>\n                            `:""}\n                        </div>\n\n                        ${this.createToolResultFromToolCall(t)}\n                    </div>\n                </div>\n            `,a={toolCall:t,preEvent:o,postEvent:i},r=this.createCollapsibleJsonSection(a);this.dataContainer&&(this.dataContainer.innerHTML=v+e+r),this.initializeJsonToggle()}}showFileOperations(t,e){if(!t||!e)return void this.showEmptyState();const n=e.split("/").pop()||e,s=t.operations||[],a=s[s.length-1],o=`\n            <div class="contextual-header">\n                <h3 class="contextual-header-text">File: ${n} ${a?this.formatTimestamp(a.timestamp):""}</h3>\n            </div>\n        `,i=`\n            <div class="structured-view-section">\n                <div class="file-details">\n                    <div class="file-path-display">\n                        <strong>Full Path:</strong> ${this.createClickableFilePath(e)}\n                        <div id="git-track-status-${e.replace(/[^a-zA-Z0-9]/g,"-")}" class="git-track-status" style="margin-top: 8px;">\n                            \x3c!-- Git tracking status will be populated here --\x3e\n                        </div>\n                    </div>\n                    <div class="operations-list">\n                        ${s.map(t=>`\n                            <div class="operation-item">\n                                <div class="operation-header">\n                                    <span class="operation-icon">${this.getOperationIcon(t.operation)}</span>\n                                    <span class="operation-type">${t.operation}</span>\n                                    <span class="operation-timestamp">${new Date(t.timestamp).toLocaleString()}</span>\n                                    ${this.isReadOnlyOperation(t.operation)?`\n                                        \x3c!-- Read-only operation: show only file viewer --\x3e\n                                        <span class="file-viewer-icon"\n                                              onclick="showFileViewerModal('${e}')"\n                                              title="View file contents with syntax highlighting"\n                                              style="margin-left: 8px; cursor: pointer; font-size: 16px;">\n                                            👁️\n                                        </span>\n                                    `:`\n                                        \x3c!-- Edit operation: show both file viewer and git diff --\x3e\n                                        <span class="file-viewer-icon"\n                                              onclick="showFileViewerModal('${e}')"\n                                              title="View file contents with syntax highlighting"\n                                              style="margin-left: 8px; cursor: pointer; font-size: 16px;">\n                                            👁️\n                                        </span>\n                                        <span class="git-diff-icon"\n                                              onclick="showGitDiffModal('${e}', '${t.timestamp}')"\n                                              title="View git diff for this file operation"\n                                              style="margin-left: 8px; cursor: pointer; font-size: 16px; display: none;"\n                                              data-file-path="${e}"\n                                              data-operation-timestamp="${t.timestamp}">\n                                            📋\n                                        </span>\n                                    `}\n                                </div>\n                                <div class="operation-details">\n                                    <strong>Agent:</strong> ${t.agent}<br>\n                                    <strong>Session:</strong> ${t.sessionId?t.sessionId.substring(0,8)+"...":"Unknown"}\n                                    ${t.details?this.formatOperationDetails(t.details):""}\n                                </div>\n                            </div>\n                        `).join("")}\n                    </div>\n                </div>\n            </div>\n        `;this.checkAndShowTrackControl(e),this.checkAndShowGitDiffIcons(e);const r=this.createCollapsibleJsonSection(t);this.dataContainer&&(this.dataContainer.innerHTML=o+i+r),this.initializeJsonToggle()}showErrorMessage(t,e){const n=`\n            <div class="module-error">\n                <div class="error-header">\n                    <h3>❌ ${t}</h3>\n                </div>\n                <div class="error-message">\n                    <p>${e}</p>\n                </div>\n            </div>\n        `,s={title:t,message:e},a=this.createCollapsibleJsonSection(s);this.dataContainer&&(this.dataContainer.innerHTML=n+a),this.initializeJsonToggle()}showAgentEvent(t,e){this.showAgentSpecificDetails(t,e)}showAgentSpecificDetails(t,e){if(!t)return void this.showEmptyState();const n=window.dashboard?.agentInference,s=window.dashboard?.eventViewer;if(!n||!s)return console.warn("AgentInference or EventViewer not available, falling back to single event view"),void this.showEventDetails(t);const a=n.getInferredAgentForEvent(t),o=a?.agentName||this.extractAgent(t)||"Unknown",i=s.events||[],r=this.getAgentSpecificEvents(i,o,n);console.log(`Showing details for agent: ${o}, found ${r.length} related events`);const l=this.extractAgentSpecificData(o,r);this.renderAgentSpecificView(o,l,t)}getAgentSpecificEvents(t,e,n){return t.filter(t=>{const s=n.getInferredAgentForEvent(t);return(s?.agentName||this.extractAgent(t)||"Unknown").toLowerCase()===e.toLowerCase()})}extractAgentSpecificData(t,e){const n={agentName:t,totalEvents:e.length,prompt:null,todos:[],toolsCalled:[],sessions:new Set,firstSeen:null,lastSeen:null,eventTypes:new Set};return e.forEach(e=>{const s=e.data||{},a=new Date(e.timestamp);(!n.firstSeen||a<n.firstSeen)&&(n.firstSeen=a),(!n.lastSeen||a>n.lastSeen)&&(n.lastSeen=a),(e.session_id||s.session_id)&&n.sessions.add(e.session_id||s.session_id);const o=e.hook_event_name||e.type||"unknown";if(n.eventTypes.add(o),"hook"===e.type&&"Task"===s.tool_name&&s.tool_parameters){const e=s.tool_parameters;e.prompt&&!n.prompt&&(n.prompt=e.prompt),e.description&&!n.description&&(n.description=e.description),e.subagent_type===t&&e.prompt&&(n.prompt=e.prompt)}if(!s.prompt||s.agent_type!==t&&s.subagent_type!==t||(n.prompt=s.prompt),"todo"===e.type||"hook"===e.type&&"TodoWrite"===s.tool_name){const t=s.todos||s.tool_parameters?.todos;t&&Array.isArray(t)&&t.forEach(t=>{const e=n.todos.findIndex(e=>e.id===t.id||e.content===t.content);e>=0?n.todos[e]={...n.todos[e],...t,timestamp:a}:n.todos.push({...t,timestamp:a})})}if("hook"===e.type&&s.tool_name){const t=e.subtype||s.event_type,o=this.generateToolCallId(s.tool_name,s.tool_parameters,a);"pre_tool"===t?(n._preToolEvents||(n._preToolEvents=new Map),n._preToolEvents.set(o,{toolName:s.tool_name,timestamp:a,target:this.extractToolTarget(s.tool_name,s.tool_parameters,null),parameters:s.tool_parameters})):"post_tool"===t&&(n._postToolEvents||(n._postToolEvents=new Map),n._postToolEvents.set(o,{toolName:s.tool_name,timestamp:a,success:s.success,duration:s.duration_ms,resultSummary:s.result_summary,exitCode:s.exit_code}))}}),n.todos.sort((t,e)=>(e.timestamp||0)-(t.timestamp||0)),n.toolsCalled=this.consolidateToolCalls(n._preToolEvents,n._postToolEvents),delete n._preToolEvents,delete n._postToolEvents,n.toolsCalled.sort((t,e)=>e.timestamp-t.timestamp),n}generateToolCallId(t,e,n){const s=Math.floor(n.getTime()/5e3);let a="";if(e){const t=[];e.file_path&&t.push(e.file_path),e.command&&t.push(e.command.substring(0,50)),e.pattern&&t.push(e.pattern),e.subagent_type&&t.push(e.subagent_type),e.notebook_path&&t.push(e.notebook_path),e.url&&t.push(e.url),e.prompt&&t.push(e.prompt.substring(0,30)),a=t.join("|")}return a||(a="default"),`${t}:${s}:${a}`}consolidateToolCalls(t,e){const n=[],s=new Set;t||(t=new Map),e||(e=new Map);for(const[a,o]of t){if(s.has(a))continue;const t=e.get(a),i={toolName:o.toolName,timestamp:o.timestamp,target:o.target,parameters:o.parameters,status:this.determineToolCallStatus(o,t),statusIcon:this.getToolCallStatusIcon(o,t),phase:t?"completed":"running"};t&&(i.success=t.success,i.duration=t.duration,i.resultSummary=t.resultSummary,i.exitCode=t.exitCode,i.completedAt=t.timestamp),n.push(i),s.add(a)}for(const[a,o]of e){if(s.has(a))continue;const t={toolName:o.toolName,timestamp:o.timestamp,target:"Unknown target",parameters:null,status:this.determineToolCallStatus(null,o),statusIcon:this.getToolCallStatusIcon(null,o),phase:"completed",success:o.success,duration:o.duration,resultSummary:o.resultSummary,exitCode:o.exitCode,completedAt:o.timestamp};n.push(t),s.add(a)}return n}determineToolCallStatus(t,e){return e?!0===e.success?"Success":!1===e.success?"Failed":0===e.exitCode?"Completed":2===e.exitCode?"Blocked":void 0!==e.exitCode&&0!==e.exitCode?"Error":"Completed":"Running..."}getToolCallStatusIcon(t,e){return e?!0===e.success?"✅":!1===e.success?"❌":0===e.exitCode?"✅":2===e.exitCode?"⚠️":void 0!==e.exitCode&&0!==e.exitCode?"❌":"✅":"⏳"}estimateTokenCount(t){if(!t||"string"!=typeof t)return 0;const e=t.trim().split(/\s+/).length,n=Math.ceil(t.length/4);return Math.max(1.3*e,n)}trimPromptWhitespace(t){return t&&"string"==typeof t?t=(t=(t=t.trim()).replace(/\n\s*\n\s*\n+/g,"\n\n")).split("\n").map(t=>t.replace(/\s+$/,"")).join("\n"):""}renderAgentSpecificView(t,e,n){const s=this.formatTimestamp(n.timestamp),a=`\n            <div class="contextual-header">\n                <h3 class="contextual-header-text">🤖 ${t} Agent Details ${s}</h3>\n            </div>\n        `;let o=`\n            <div class="agent-overview-section">\n                <div class="structured-data">\n                    ${this.createProperty("Agent Name",t)}\n                    ${this.createProperty("Total Events",e.totalEvents)}\n                    ${this.createProperty("Active Sessions",e.sessions.size)}\n                    ${this.createProperty("Event Types",Array.from(e.eventTypes).join(", "))}\n                    ${e.firstSeen?this.createProperty("First Seen",e.firstSeen.toLocaleString()):""}\n                    ${e.lastSeen?this.createProperty("Last Seen",e.lastSeen.toLocaleString()):""}\n                </div>\n            </div>\n        `;if(e.prompt){const t=this.trimPromptWhitespace(e.prompt);o+=`\n                <div class="agent-prompt-section">\n                    <div class="contextual-header">\n                        <h3 class="contextual-header-text">📝 Agent Task Prompt</h3>\n                        <div class="prompt-stats" style="font-size: 11px; color: #64748b; margin-top: 4px;">\n                            ~${Math.round(this.estimateTokenCount(t))} tokens • ${t.trim().split(/\s+/).length} words • ${t.length} characters\n                        </div>\n                    </div>\n                    <div class="structured-data">\n                        <div class="agent-prompt" style="white-space: pre-wrap; max-height: 300px; overflow-y: auto; padding: 10px; background: #f8fafc; border-radius: 6px; font-family: monospace; font-size: 12px; line-height: 1.4; border: 1px solid #e2e8f0;">\n                            ${this.escapeHtml(t)}\n                        </div>\n                    </div>\n                </div>\n            `}e.todos.length>0&&(o+=`\n                <div class="agent-todos-section">\n                    <div class="contextual-header">\n                        <h3 class="contextual-header-text">✅ Agent Todo List (${e.todos.length} items)</h3>\n                    </div>\n                    <div class="todo-checklist">\n                        ${e.todos.map(t=>`\n                            <div class="todo-item todo-${t.status||"pending"}">\n                                <span class="todo-status">${this.getTodoStatusIcon(t.status)}</span>\n                                <span class="todo-content">${t.content||"No content"}</span>\n                                <span class="todo-priority priority-${t.priority||"medium"}">${this.getTodoPriorityIcon(t.priority)}</span>\n                                ${t.timestamp?`<span class="todo-timestamp">${new Date(t.timestamp).toLocaleTimeString()}</span>`:""}\n                            </div>\n                        `).join("")}\n                    </div>\n                </div>\n            `),e.toolsCalled.length>0&&(o+=`\n                <div class="agent-tools-section">\n                    <div class="contextual-header">\n                        <h3 class="contextual-header-text">🔧 Tools Called by Agent (${e.toolsCalled.length} calls)</h3>\n                    </div>\n                    <div class="tools-list">\n                        ${e.toolsCalled.map(e=>{let n="";return"✅"===e.statusIcon?n="status-success":"❌"===e.statusIcon?n="status-failed":"⚠️"===e.statusIcon?n="status-blocked":"⏳"===e.statusIcon&&(n="status-running"),`\n                                <div class="tool-call-item">\n                                    <div class="tool-call-header">\n                                        <div style="display: flex; align-items: center; gap: 12px; flex: 1;">\n                                            <span class="tool-name">🔧 ${e.toolName}</span>\n                                            <span class="tool-agent">${t}</span>\n                                            <span class="tool-status-indicator ${n}">${e.statusIcon} ${e.status}</span>\n                                        </div>\n                                        <span class="tool-timestamp" style="margin-left: auto;">${e.timestamp.toLocaleTimeString()}</span>\n                                    </div>\n                                    <div class="tool-call-details">\n                                        ${e.target?`<span class="tool-target">Target: ${e.target}</span>`:""}\n                                        ${e.duration?`<span class="tool-duration">Duration: ${e.duration}ms</span>`:""}\n                                        ${e.completedAt&&e.completedAt!==e.timestamp?`<span class="tool-completed">Completed: ${e.completedAt.toLocaleTimeString()}</span>`:""}\n                                    </div>\n                                </div>\n                            `}).join("")}\n                    </div>\n                </div>\n            `);const i={agentName:t,agentData:e,originalEvent:n},r=this.createCollapsibleJsonSection(i);this.dataContainer&&(this.dataContainer.innerHTML=a+o+r),this.initializeJsonToggle()}createToolResultFromToolCall(t){if(!t.result_summary)return"";const e={event_type:"post_tool",result_summary:t.result_summary,success:t.success,exit_code:t.exit_code},n=this.createInlineToolResultContent(e,{subtype:"post_tool"});return n.trim()?`\n                <div class="tool-result-inline">\n                    <div class="structured-data">\n                        ${n}\n                    </div>\n                </div>\n            `:""}extractToolTarget(t,e,n){const s=e||n||{};switch(t?.toLowerCase()){case"write":case"read":case"edit":case"multiedit":return s.file_path||"Unknown file";case"bash":return s.command?`${s.command.substring(0,50)}${s.command.length>50?"...":""}`:"Unknown command";case"grep":return s.pattern?`Pattern: ${s.pattern}`:"Unknown pattern";case"glob":return s.pattern?`Pattern: ${s.pattern}`:"Unknown glob";case"todowrite":return`${s.todos?.length||0} todos`;case"task":return s.subagent_type||s.agent_type||"Subagent delegation";default:return s.file_path?s.file_path:s.pattern?`Pattern: ${s.pattern}`:s.command?`Command: ${s.command.substring(0,30)}...`:s.path?s.path:"Unknown target"}}getOperationIcon(t){return{read:"👁️",write:"✏️",edit:"📝",multiedit:"📝",create:"🆕",delete:"🗑️",move:"📦",copy:"📋"}[t?.toLowerCase()]||"📄"}getCurrentEvent(){return this.currentEvent}async checkAndShowTrackControl(t){if(t)try{const e=window.socket||window.dashboard?.socketClient?.socket;if(!e)return void console.warn("No socket connection available for git tracking check");let n=window.dashboard?.currentWorkingDir;if(!n||"Unknown"===n||""===n.trim()){const t=document.getElementById("footer-working-dir");n=t?.textContent?.trim()&&"Unknown"!==t.textContent.trim()?t.textContent.trim():".",console.log("[MODULE-VIEWER-DEBUG] Working directory fallback used:",n)}const s=new Promise((n,s)=>{const a=s=>{s.file_path===t&&(e.off("file_tracked_response",a),n(s))};e.on("file_tracked_response",a),setTimeout(()=>{e.off("file_tracked_response",a),s(new Error("Request timeout"))},5e3)});e.emit("check_file_tracked",{file_path:t,working_dir:n});const a=await s;this.displayTrackingStatus(t,a)}catch(e){console.error("Error checking file tracking status:",e),this.displayTrackingStatus(t,{success:!1,error:e.message,file_path:t})}}displayTrackingStatus(t,e){const n=`git-track-status-${t.replace(/[^a-zA-Z0-9]/g,"-")}`,s=document.getElementById(n);s&&(e.success&&!1===e.is_tracked?s.innerHTML=`\n                <div class="untracked-file-notice">\n                    <span class="untracked-icon">⚠️</span>\n                    <span class="untracked-text">This file is not tracked by git</span>\n                    <button class="track-file-button"\n                            onclick="window.moduleViewer.trackFile('${t}')"\n                            title="Add this file to git tracking">\n                        <span class="git-icon">📁</span> Track File\n                    </button>\n                </div>\n            `:e.success&&!0===e.is_tracked?s.innerHTML='\n                <div class="tracked-file-notice">\n                    <span class="tracked-icon">✅</span>\n                    <span class="tracked-text">This file is tracked by git</span>\n                </div>\n            ':e.success||(s.innerHTML=`\n                <div class="tracking-error-notice">\n                    <span class="error-icon">❌</span>\n                    <span class="error-text">Could not check git status: ${e.error||"Unknown error"}</span>\n                </div>\n            `))}async trackFile(t){if(t)try{const e=window.socket||window.dashboard?.socketClient?.socket;if(!e)return void console.warn("No socket connection available for git add");let n=window.dashboard?.currentWorkingDir;if(!n||"Unknown"===n||""===n.trim()){const t=document.getElementById("footer-working-dir");n=t?.textContent?.trim()&&"Unknown"!==t.textContent.trim()?t.textContent.trim():".",console.log("[MODULE-VIEWER-DEBUG] Working directory fallback used:",n)}const s=`git-track-status-${t.replace(/[^a-zA-Z0-9]/g,"-")}`,a=document.getElementById(s);a&&(a.innerHTML='\n                    <div class="tracking-file-notice">\n                        <span class="loading-icon">⏳</span>\n                        <span class="loading-text">Adding file to git tracking...</span>\n                    </div>\n                ');const o=new Promise((n,s)=>{const a=s=>{s.file_path===t&&(e.off("git_add_response",a),n(s))};e.on("git_add_response",a),setTimeout(()=>{e.off("git_add_response",a),s(new Error("Request timeout"))},1e4)});e.emit("git_add_file",{file_path:t,working_dir:n}),console.log("📁 Git add request sent:",{filePath:t,workingDir:n});const i=await o;console.log("📦 Git add result:",i),i.success?(a&&(a.innerHTML='\n                        <div class="tracked-file-notice">\n                            <span class="tracked-icon">✅</span>\n                            <span class="tracked-text">File successfully added to git tracking</span>\n                        </div>\n                    '),this.showNotification("File tracked successfully","success")):(a&&(a.innerHTML=`\n                        <div class="tracking-error-notice">\n                            <span class="error-icon">❌</span>\n                            <span class="error-text">Failed to track file: ${i.error||"Unknown error"}</span>\n                            <button class="track-file-button"\n                                    onclick="window.moduleViewer.trackFile('${t}')"\n                                    title="Try again">\n                                <span class="git-icon">📁</span> Retry\n                            </button>\n                        </div>\n                    `),this.showNotification(`Failed to track file: ${i.error}`,"error"))}catch(e){console.error("❌ Failed to track file:",e);const n=`git-track-status-${t.replace(/[^a-zA-Z0-9]/g,"-")}`,s=document.getElementById(n);s&&(s.innerHTML=`\n                    <div class="tracking-error-notice">\n                        <span class="error-icon">❌</span>\n                        <span class="error-text">Error: ${e.message}</span>\n                        <button class="track-file-button"\n                                onclick="window.moduleViewer.trackFile('${t}')"\n                                title="Try again">\n                            <span class="git-icon">📁</span> Retry\n                        </button>\n                    </div>\n                `),this.showNotification(`Error tracking file: ${e.message}`,"error")}}async checkAndShowGitDiffIcons(t){if(t){console.debug("[GIT-DIFF-ICONS] Checking git diff icons for file:",t);try{const e=window.socket||window.dashboard?.socketClient?.socket;if(!e)return void console.warn("[GIT-DIFF-ICONS] No socket connection available for git status check");console.debug("[GIT-DIFF-ICONS] Socket connection available, proceeding");let n=window.dashboard?.currentWorkingDir;if(n&&"Unknown"!==n&&""!==n.trim())console.debug("[GIT-DIFF-ICONS] Using working directory:",n);else{const t=document.getElementById("footer-working-dir");n=t?.textContent?.trim()&&"Unknown"!==t.textContent.trim()?t.textContent.trim():".",console.log("[GIT-DIFF-ICONS] Working directory fallback used:",n)}const s=new Promise((n,s)=>{const a=s=>{console.debug("[GIT-DIFF-ICONS] Received git status response:",s),s.file_path===t?(e.off("git_status_response",a),n(s)):console.debug("[GIT-DIFF-ICONS] Response for different file, ignoring:",s.file_path)};e.on("git_status_response",a),setTimeout(()=>{e.off("git_status_response",a),console.warn("[GIT-DIFF-ICONS] Timeout waiting for git status response"),s(new Error("Request timeout"))},3e3)});console.debug("[GIT-DIFF-ICONS] Sending check_git_status event"),e.emit("check_git_status",{file_path:t,working_dir:n});const a=await s;console.debug("[GIT-DIFF-ICONS] Git status check result:",a),a.success?(console.debug("[GIT-DIFF-ICONS] Git status check successful, showing icons for:",t),this.showGitDiffIconsForFile(t)):console.debug("[GIT-DIFF-ICONS] Git status check failed, icons will remain hidden:",a.error)}catch(e){console.warn("[GIT-DIFF-ICONS] Git status check failed, hiding git diff icons:",e.message)}}else console.debug("[GIT-DIFF-ICONS] No filePath provided, skipping git diff icon check")}showGitDiffIconsForFile(t){console.debug("[GIT-DIFF-ICONS] Showing git diff icons for file:",t);const e=document.querySelectorAll(`[data-file-path="${t}"]`);console.debug("[GIT-DIFF-ICONS] Found",e.length,"elements with matching file path");let n=0;e.forEach((t,e)=>{console.debug("[GIT-DIFF-ICONS] Processing element",e,":",t),console.debug("[GIT-DIFF-ICONS] Element classes:",t.classList.toString()),t.classList.contains("git-diff-icon")?(console.debug("[GIT-DIFF-ICONS] Setting display to inline for git-diff-icon"),t.style.display="inline",n++):console.debug("[GIT-DIFF-ICONS] Element is not a git-diff-icon, skipping")}),console.debug("[GIT-DIFF-ICONS] Showed",n,"git diff icons for file:",t)}showNotification(t,e="info"){const n=document.createElement("div");n.className=`notification notification-${e}`,n.innerHTML=`\n            <span class="notification-icon">${"success"===e?"✅":"error"===e?"❌":"ℹ️"}</span>\n            <span class="notification-message">${t}</span>\n        `,n.style.cssText=`\n            position: fixed;\n            top: 20px;\n            right: 20px;\n            background: ${"success"===e?"#d4edda":"error"===e?"#f8d7da":"#d1ecf1"};\n            color: ${"success"===e?"#155724":"error"===e?"#721c24":"#0c5460"};\n            border: 1px solid ${"success"===e?"#c3e6cb":"error"===e?"#f5c6cb":"#bee5eb"};\n            border-radius: 6px;\n            padding: 12px 16px;\n            font-size: 14px;\n            font-weight: 500;\n            z-index: 2000;\n            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);\n            display: flex;\n            align-items: center;\n            gap: 8px;\n            max-width: 400px;\n            animation: slideIn 0.3s ease-out;\n        `;const s=document.createElement("style");s.textContent="\n            @keyframes slideIn {\n                from { transform: translateX(100%); opacity: 0; }\n                to { transform: translateX(0); opacity: 1; }\n            }\n            @keyframes slideOut {\n                from { transform: translateX(0); opacity: 1; }\n                to { transform: translateX(100%); opacity: 0; }\n            }\n        ",document.head.appendChild(s),document.body.appendChild(n),setTimeout(()=>{n.style.animation="slideOut 0.3s ease-in",setTimeout(()=>{n.parentNode&&n.parentNode.removeChild(n),s.parentNode&&s.parentNode.removeChild(s)},300)},5e3)}showAgentInstance(t){if(!t)return void this.showEmptyState();const e={type:"pm_delegation",subtype:t.agentName,agent_type:t.agentName,timestamp:t.timestamp,session_id:t.sessionId,metadata:{delegation_type:"explicit",event_count:t.agentEvents.length,pm_call:t.pmCall||null,agent_events:t.agentEvents}};console.log("Showing PM delegation details:",t),this.showAgentSpecificDetails(e,0)}showImpliedAgent(t){if(!t)return void this.showEmptyState();const e={type:"implied_delegation",subtype:t.agentName,agent_type:t.agentName,timestamp:t.timestamp,session_id:t.sessionId,metadata:{delegation_type:"implied",event_count:t.eventCount,pm_call:null,note:"No explicit PM call found - inferred from agent activity"}};console.log("Showing implied agent details:",t),this.showAgentSpecificDetails(e,0)}}window.ModuleViewer=e,window.enableToolResultDebugging=function(){window.DEBUG_TOOL_RESULTS=!0,console.log("🔧 Tool result debugging enabled. Click on tool events to see debug info.")},window.disableToolResultDebugging=function(){window.DEBUG_TOOL_RESULTS=!1,console.log("🔧 Tool result debugging disabled.")};export{e as M};
//# sourceMappingURL=module-viewer.js.map
