/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.io.IOException;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.graph.invariant.Canon;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.ringsearch.RingSearch;
import org.openscience.cdk.smiles.CDKToBeam;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.beam.Graph;

public class CanonSmiAdapter {
    static final CDKToBeam CDK2BEAM = new CDKToBeam();
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(CanonSmiAdapter.class);

    public static String create(IAtomContainer ac) throws CDKException, IOException {
        GraphUtil.EdgeToBondMap bonds = GraphUtil.EdgeToBondMap.withSpaceFor(ac);
        int[][] graph = GraphUtil.toAdjList(ac, bonds);
        long[] labels = Canon.label(ac, graph, CanonSmiAdapter.betterInvariants(ac, graph, bonds));
        Graph g = CDK2BEAM.toBeamGraph(ac);
        g = g.permute(CanonSmiAdapter.toPermutation(labels));
        g = g.resonate();
        return g.toSmiles();
    }

    private static int[] toPermutation(long[] labels) throws CDKException {
        int[] cpy = new int[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            cpy[i] = (int)labels[i] - 1;
        }
        return cpy;
    }

    public static long[] betterInvariants(IAtomContainer container, int[][] graph, GraphUtil.EdgeToBondMap bonds) {
        long[] labels = new long[graph.length];
        RingSearch ringSearch = new RingSearch(container, graph);
        for (int v = 0; v < graph.length; ++v) {
            IAtom atom = container.getAtom(v);
            int deg = graph[v].length;
            int impH = CanonSmiAdapter.implH(atom);
            int expH = 0;
            int elem = CanonSmiAdapter.atomicNumber(atom);
            int chg = CanonSmiAdapter.charge(atom);
            int valence = impH;
            for (int w : graph[v]) {
                if (CanonSmiAdapter.atomicNumber(container.getAtom(w)) == 1) {
                    ++expH;
                }
                if (bonds.get(v, w).getOrder() == null) continue;
                valence += bonds.get(v, w).getOrder().numeric().intValue();
            }
            long label = 0L;
            label |= (long)(deg + impH & 0xF);
            label <<= 4;
            label |= (long)(deg - expH & 0xF);
            label <<= 7;
            label |= (long)(elem & 0x7F);
            label <<= 4;
            label |= (long)(valence & 0xF);
            label <<= 1;
            label |= (long)(chg >> 31 & 1);
            label <<= 2;
            label |= (long)(Math.abs(chg) & 3);
            label <<= 4;
            label |= (long)(impH + expH & 0xF);
            label <<= 1;
            labels[v] = label |= ringSearch.cyclic(v) ? 0L : 1L;
        }
        return labels;
    }

    private static int atomicNumber(IAtom atom) {
        Integer elem = atom.getAtomicNumber();
        if (elem != null) {
            return elem;
        }
        if (atom instanceof IPseudoAtom) {
            return 0;
        }
        throw new NullPointerException("a non-psuedo atom had unset atomic number");
    }

    private static int implH(IAtom atom) {
        Integer h = atom.getImplicitHydrogenCount();
        if (h != null) {
            return h;
        }
        if (atom instanceof IPseudoAtom) {
            return 0;
        }
        throw new NullPointerException("a non-psuedo atom had unset hydrogen count");
    }

    private static int charge(IAtom atom) {
        Integer charge = atom.getFormalCharge();
        if (charge != null) {
            return charge;
        }
        return 0;
    }

    private CanonSmiAdapter() {
    }
}

