/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.helper.MoleculeInitializer;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;

public final class AtomAtomMapping
implements Serializable {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(AtomAtomMapping.class);
    private static final long serialVersionUID = 1223637237262778L;
    private final IAtomContainer query;
    private final IAtomContainer target;
    private final Map<IAtom, IAtom> mapping;
    private final Map<Integer, Integer> mappingIndex;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AtomAtomMapping other = (AtomAtomMapping)obj;
        if (!(this.getQuery() == other.getQuery() || this.getQuery() != null && this.query.equals(other.query))) {
            return false;
        }
        if (!(this.getTarget() == other.getTarget() || this.getTarget() != null && this.target.equals(other.target))) {
            return false;
        }
        if (!(this.mapping == other.getMappingsByAtoms() || this.mapping != null && this.mapping.equals(other.mapping))) {
            return false;
        }
        return this.mappingIndex == other.getMappingsByIndex() || this.mappingIndex != null && this.mappingIndex.equals(other.mappingIndex);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.getQuery() != null ? this.getQuery().hashCode() : 0);
        hash = 67 * hash + (this.getTarget() != null ? this.getTarget().hashCode() : 0);
        hash = 67 * hash + (this.mapping != null ? this.getMappingsByAtoms().hashCode() : 0);
        hash = 67 * hash + (this.mappingIndex != null ? this.getMappingsByIndex().hashCode() : 0);
        return hash;
    }

    public AtomAtomMapping(IAtomContainer query2, IAtomContainer target) {
        this.query = query2;
        this.target = target;
        this.mapping = new TreeMap<IAtom, IAtom>(new MyQueryIAtomComp());
        this.mappingIndex = Collections.synchronizedSortedMap(new TreeMap());
    }

    public synchronized void put(IAtom atom1, IAtom atom2) {
        try {
            atom1.setID((String)(atom1.getID() == null ? "" + this.getQuery().indexOf(atom1) : atom1.getID()));
            atom2.setID((String)(atom2.getID() == null ? "" + this.getTarget().indexOf(atom2) : atom2.getID()));
            this.mapping.put(atom1, atom2);
            this.mappingIndex.put(this.getQuery().indexOf(atom1), this.getTarget().indexOf(atom2));
        }
        catch (Exception e) {
            LOGGER.error("Error: Add Mapping to the Map", e.getMessage());
        }
    }

    public synchronized String toString() {
        StringBuilder s = new StringBuilder();
        try {
            IReaction reaction = SilentChemObjectBuilder.getInstance().newInstance(IReaction.class, new Object[0]);
            reaction.addReactant(this.getQuery().clone(), 1.0);
            reaction.addProduct(this.getTarget().clone(), 1.0);
            int counter = 1;
            for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
                for (IAtom a : ac.atoms()) {
                    IAtom refAtom = this.getQuery().getAtom(ac.indexOf(a));
                    if (this.mapping.containsKey(refAtom)) {
                        a.setProperty("cdk:AtomAtomMapping", counter);
                        a.setFlag(128, true);
                        IAtom mappedAtom = this.mapping.get(refAtom);
                        int mappedAtomIndex = this.getTarget().indexOf(mappedAtom);
                        IAtom b = reaction.getProducts().getAtomContainer(0).getAtom(mappedAtomIndex);
                        b.setProperty("cdk:AtomAtomMapping", counter);
                        b.setFlag(128, true);
                        IMapping aammapping = reaction.getBuilder().newInstance(IMapping.class, a, b);
                        reaction.addMapping(aammapping);
                    }
                    ++counter;
                }
            }
            String createReactionSMILES = "NA";
            try {
                SmilesGenerator withAtomClasses = new SmilesGenerator(1796);
                createReactionSMILES = withAtomClasses.create(reaction);
            }
            catch (CDKException ex) {
                LOGGER.error(ex);
            }
            s.append("MMP: ").append(createReactionSMILES).append(", AAM:[");
            this.mapping.keySet().stream().forEach(firstAtom -> {
                int keyIndex = this.getQuery().indexOf((IAtom)firstAtom) + 1;
                int valueIndex = this.getTarget().indexOf(this.mapping.get(firstAtom)) + 1;
                s.append(keyIndex).append(":").append(valueIndex).append("|");
            });
            s.append("]");
            try {
                s.append(", MCS: ").append(this.getCommonFragmentAsSMILES());
            }
            catch (CDKException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
        }
        catch (CloneNotSupportedException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        return s.toString();
    }

    public synchronized boolean isEmpty() {
        return this.mapping.isEmpty();
    }

    public synchronized void clear() {
        this.mapping.clear();
        this.mappingIndex.clear();
    }

    public synchronized int getCount() {
        return this.mapping.isEmpty() ? 0 : this.mapping.size();
    }

    public synchronized Map<IAtom, IAtom> getMappingsByAtoms() {
        return Collections.unmodifiableMap(new LinkedHashMap<IAtom, IAtom>(this.mapping));
    }

    public synchronized Map<Integer, Integer> getMappingsByIndex() {
        return Collections.unmodifiableSortedMap(new TreeMap<Integer, Integer>(this.mappingIndex));
    }

    public synchronized int getQueryIndex(IAtom atom) {
        return this.getQuery().indexOf(atom);
    }

    public synchronized int getTargetIndex(IAtom atom) {
        return this.getTarget().indexOf(atom);
    }

    public synchronized IAtomContainer getQuery() {
        return this.query;
    }

    public synchronized IAtomContainer getTarget() {
        return this.target;
    }

    public synchronized IAtomContainer getMapCommonFragmentOnQuery() throws CloneNotSupportedException {
        IAtomContainer ac = this.getQuery().clone();
        List<IAtom> unmappedAtoms = Collections.synchronizedList(new ArrayList());
        for (IAtom atom2 : this.getQuery().atoms()) {
            if (this.mapping.containsKey(atom2)) continue;
            unmappedAtoms.add(ac.getAtom(this.getQueryIndex(atom2)));
        }
        unmappedAtoms.stream().forEach(atom -> ac.removeAtom((IAtom)atom));
        return ac;
    }

    public synchronized IAtomContainer getMapCommonFragmentOnTarget() throws CloneNotSupportedException {
        IAtomContainer ac = this.getTarget().clone();
        List<IAtom> unmappedAtoms = Collections.synchronizedList(new ArrayList());
        for (IAtom atom2 : this.getTarget().atoms()) {
            if (this.mapping.containsValue(atom2)) continue;
            unmappedAtoms.add(ac.getAtom(this.getTargetIndex(atom2)));
        }
        unmappedAtoms.stream().forEach(atom -> ac.removeAtom((IAtom)atom));
        return ac;
    }

    public synchronized IAtomContainer getCommonFragment() throws CloneNotSupportedException {
        IAtomContainer ac = this.getQuery().clone();
        List<IAtom> unmappedAtoms = Collections.synchronizedList(new ArrayList());
        for (IAtom atom2 : this.getQuery().atoms()) {
            if (this.mapping.containsKey(atom2)) continue;
            unmappedAtoms.add(ac.getAtom(this.getQueryIndex(atom2)));
        }
        for (IBond queryBond : this.getQuery().bonds()) {
            IAtom atom2InCommonContainer;
            IAtom atom1InCommonContainer;
            IAtom targetAtomBegin = this.mapping.get(queryBond.getBegin());
            IAtom targetAtomEnd = this.mapping.get(queryBond.getEnd());
            if (targetAtomBegin == null || targetAtomEnd == null) continue;
            IBond targetBond = this.getTarget().getBond(targetAtomBegin, targetAtomEnd);
            if (targetBond == null) {
                atom1InCommonContainer = ac.getAtom(this.getQueryIndex(queryBond.getBegin()));
                atom2InCommonContainer = ac.getAtom(this.getQueryIndex(queryBond.getEnd()));
                ac.removeBond(ac.getBond(atom1InCommonContainer, atom2InCommonContainer));
            }
            if (targetBond == null || queryBond.isAromatic() || targetBond.isAromatic()) continue;
            atom1InCommonContainer = ac.getAtom(this.getQueryIndex(queryBond.getBegin()));
            atom2InCommonContainer = ac.getAtom(this.getQueryIndex(queryBond.getEnd()));
            IBond bond = ac.getBond(atom1InCommonContainer, atom2InCommonContainer);
            if (queryBond.getOrder().numeric() <= targetBond.getOrder().numeric()) continue;
            bond.setOrder(targetBond.getOrder());
        }
        unmappedAtoms.stream().forEach(atom -> ac.removeAtom((IAtom)atom));
        try {
            CDKHydrogenAdder.getInstance(ac.getBuilder()).addImplicitHydrogens(ac);
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        try {
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(ac);
            MoleculeInitializer.initializeMolecule(ac);
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        return ac;
    }

    public synchronized String getCommonFragmentAsSMILES() throws CloneNotSupportedException, CDKException {
        SmilesGenerator smiles = new SmilesGenerator(1813);
        IAtomContainer commonFragment = this.getCommonFragment();
        return smiles.create(commonFragment);
    }

    public Map<IAtom, IAtom> sortByValues(Map<IAtom, IAtom> map) {
        LinkedList<Map.Entry<IAtom, IAtom>> entries = new LinkedList<Map.Entry<IAtom, IAtom>>(map.entrySet());
        Collections.sort(entries, (o1, o2) -> {
            int atomNumber1 = this.getQuery().indexOf((IAtom)o1.getKey());
            int atomNumber2 = this.getQuery().indexOf((IAtom)o2.getKey());
            return atomNumber1 - atomNumber2;
        });
        LinkedHashMap<IAtom, IAtom> sortedMap = new LinkedHashMap<IAtom, IAtom>();
        entries.stream().forEach(entry -> sortedMap.put((IAtom)entry.getKey(), (IAtom)entry.getValue()));
        return sortedMap;
    }

    class MyQueryIAtomComp
    implements Comparator<IAtom> {
        MyQueryIAtomComp() {
        }

        @Override
        public int compare(IAtom o1, IAtom o2) {
            int atomNumber1 = AtomAtomMapping.this.getQuery().indexOf(o1);
            int atomNumber2 = AtomAtomMapping.this.getQuery().indexOf(o2);
            return atomNumber1 - atomNumber2;
        }
    }
}

