/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.filters.ChemicalFilters;
import org.openscience.smsd.interfaces.IAtomMapping;

public class BaseMapping
extends ChemicalFilters
implements IAtomMapping {
    private boolean subgraph;
    private List<Double> stereoScoreList;
    private List<Integer> fragmentSizeList;
    private List<Double> bondEnergiesList;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(BaseMapping.class);
    final AtomMatcher atomMatcher;
    final BondMatcher bondMatcher;

    public BaseMapping(IAtomContainer mol1, IAtomContainer mol2, AtomMatcher am, BondMatcher bm) {
        super(mol1, mol2);
        this.atomMatcher = am;
        this.bondMatcher = bm;
    }

    public BaseMapping(IQueryAtomContainer mol1, IAtomContainer mol2, AtomMatcher am, BondMatcher bm) {
        super(mol1, mol2);
        this.atomMatcher = am;
        this.bondMatcher = bm;
    }

    @Override
    public synchronized void setChemFilters(boolean stereoFilter, boolean fragmentFilter, boolean energyFilter) {
        if (this.getMappingCount() > 0) {
            if (fragmentFilter) {
                this.sortResultsByFragments();
                this.fragmentSizeList = this.getSortedFragment();
            }
            if (stereoFilter) {
                try {
                    this.sortResultsByStereoAndBondMatch();
                    this.stereoScoreList = this.getStereoMatches();
                }
                catch (CDKException ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
            }
            if (energyFilter) {
                try {
                    this.sortResultsByEnergies();
                    this.bondEnergiesList = this.getSortedEnergy();
                }
                catch (CDKException ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
            }
        }
    }

    @Override
    public synchronized Integer getFragmentSize(int Key2) {
        return this.fragmentSizeList != null && !this.fragmentSizeList.isEmpty() ? this.fragmentSizeList.get(Key2) : null;
    }

    @Override
    public synchronized Integer getStereoScore(int Key2) {
        return this.stereoScoreList != null && !this.stereoScoreList.isEmpty() ? Integer.valueOf(this.stereoScoreList.get(Key2).intValue()) : null;
    }

    @Override
    public synchronized Double getEnergyScore(int Key2) {
        return this.bondEnergiesList != null && !this.bondEnergiesList.isEmpty() ? this.bondEnergiesList.get(Key2) : null;
    }

    @Override
    public synchronized double getTanimotoSimilarity() {
        AtomAtomMapping firstAtomMCS;
        int decimalPlaces = 4;
        double tanimotoAtom = 0.0;
        if (this.getMappingCount() > 0 && !(firstAtomMCS = this.getMCSList().iterator().next()).isEmpty()) {
            double rAtomCount = this.getMCSList().iterator().next().getQuery().getAtomCount();
            double pAtomCount = this.getMCSList().iterator().next().getTarget().getAtomCount();
            double matchCount = firstAtomMCS.getCount();
            tanimotoAtom = matchCount / (rAtomCount + pAtomCount - matchCount);
            BigDecimal tan = new BigDecimal(tanimotoAtom);
            tan = tan.setScale(decimalPlaces, RoundingMode.HALF_UP);
            tanimotoAtom = tan.doubleValue();
        }
        return tanimotoAtom;
    }

    @Override
    public synchronized boolean isStereoMisMatch() {
        boolean flag = false;
        IAtomContainer reactant = this.getQuery();
        IAtomContainer product = this.getTarget();
        int stereoMisMatchScore = 0;
        if (this.getMappingCount() > 0) {
            AtomAtomMapping firstAtomMCS = this.getMCSList().iterator().next();
            for (IAtom indexI : firstAtomMCS.getMappingsByAtoms().keySet()) {
                IAtom indexJ = firstAtomMCS.getMappingsByAtoms().get(indexI);
                for (IAtom indexIPlus : firstAtomMCS.getMappingsByAtoms().keySet()) {
                    IAtom indexJPlus = firstAtomMCS.getMappingsByAtoms().get(indexIPlus);
                    if (indexI.equals(indexIPlus) || indexJ.equals(indexJPlus)) continue;
                    IAtom sourceAtom1 = indexI;
                    IAtom sourceAtom2 = indexIPlus;
                    IBond rBond = reactant.getBond(sourceAtom1, sourceAtom2);
                    IAtom targetAtom1 = indexJ;
                    IAtom targetAtom2 = indexJPlus;
                    IBond pBond = product.getBond(targetAtom1, targetAtom2);
                    if (rBond == null || pBond == null || rBond.getStereo() == pBond.getStereo()) continue;
                    ++stereoMisMatchScore;
                }
            }
        }
        if (stereoMisMatchScore > 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    public synchronized int getMappingCount() {
        return this.getMCSList().isEmpty() ? 0 : this.getMCSList().size();
    }

    @Override
    public synchronized double getEuclideanDistance() {
        AtomAtomMapping firstAtomMCS;
        int decimalPlaces = 4;
        double euclidean = -1.0;
        if (this.getMappingCount() > 0 && !(firstAtomMCS = this.getMCSList().iterator().next()).isEmpty()) {
            double sourceAtomCount = this.getMCSList().iterator().next().getQuery().getAtomCount();
            double targetAtomCount = this.getMCSList().iterator().next().getTarget().getAtomCount();
            double common = firstAtomMCS.getCount();
            euclidean = Math.sqrt(sourceAtomCount + targetAtomCount - 2.0 * common);
            BigDecimal dist = new BigDecimal(euclidean);
            dist = dist.setScale(decimalPlaces, RoundingMode.HALF_UP);
            euclidean = dist.doubleValue();
        }
        return euclidean;
    }

    @Override
    public synchronized List<AtomAtomMapping> getAllAtomMapping() {
        return Collections.unmodifiableList(new ArrayList<AtomAtomMapping>(this.getMCSList()));
    }

    @Override
    public synchronized AtomAtomMapping getFirstAtomMapping() {
        return this.getMCSList().isEmpty() ? new AtomAtomMapping(this.getQuery(), this.getTarget()) : this.getMCSList().iterator().next();
    }

    public synchronized boolean isSubgraph() {
        return this.subgraph;
    }

    public synchronized void clearMaps() {
        this.getMCSList().clear();
    }

    public synchronized List<Map<IBond, IBond>> getAllBondMaps() {
        if (!this.getMCSList().isEmpty()) {
            return this.makeBondMapsOfAtomMaps(this.getQuery(), this.getTarget(), this.getMCSList());
        }
        return new ArrayList<Map<IBond, IBond>>();
    }

    public synchronized void setSubgraph(boolean subgraph) {
        this.subgraph = subgraph;
    }

    public synchronized List<Map<IBond, IBond>> makeBondMapsOfAtomMaps(IAtomContainer ac1, IAtomContainer ac2, List<AtomAtomMapping> mappings) {
        List<Map<IBond, IBond>> bondMaps = Collections.synchronizedList(new ArrayList());
        mappings.stream().forEach(mapping -> bondMaps.add(this.makeBondMapOfAtomMap(ac1, ac2, (AtomAtomMapping)mapping)));
        return bondMaps;
    }

    private synchronized Map<IBond, IBond> makeBondMapOfAtomMap(IAtomContainer ac1, IAtomContainer ac2, AtomAtomMapping mapping) {
        Map<IBond, IBond> bondbondMappingMap = Collections.synchronizedMap(new HashMap());
        mapping.getMappingsByAtoms().entrySet().stream().forEach(map1 -> mapping.getMappingsByAtoms().entrySet().stream().filter(map2 -> map1.getKey() != map2.getKey()).forEach(map2 -> {
            IBond bond1 = ac1.getBond((IAtom)map1.getKey(), (IAtom)map2.getKey());
            IBond bond2 = ac2.getBond((IAtom)map1.getValue(), (IAtom)map2.getValue());
            if (bond1 != null && bond2 != null && !bondbondMappingMap.containsKey(bond1)) {
                bondbondMappingMap.put(bond1, bond2);
            }
        }));
        return bondbondMappingMap;
    }

    boolean isMoleculeConnected(IAtomContainer compound1, IAtomContainer compound2) {
        boolean connected1 = true;
        IAtomContainerSet partitionIntoMolecules = ConnectivityChecker.partitionIntoMolecules(compound1);
        for (IAtomContainer a : partitionIntoMolecules.atomContainers()) {
            if (a.getAtomCount() != 1) continue;
            connected1 = false;
        }
        boolean connected2 = true;
        partitionIntoMolecules = ConnectivityChecker.partitionIntoMolecules(compound2);
        for (IAtomContainer a : partitionIntoMolecules.atomContainers()) {
            if (a.getAtomCount() != 1) continue;
            connected2 = false;
        }
        return connected1 & connected2;
    }

    int expectedMaxGraphmatch(IAtomContainer q, IAtomContainer t) {
        Object hyb;
        ArrayList<Object> atomUniqueCounter1 = new ArrayList<Object>();
        ArrayList<Object> atomUniqueCounter2 = new ArrayList<Object>();
        for (IAtom a : q.atoms()) {
            hyb = a.getAtomicNumber() == null ? a.getSymbol() : "" + a.getAtomicNumber();
            atomUniqueCounter1.add(hyb);
        }
        for (IAtom b : t.atoms()) {
            hyb = b.getAtomicNumber() == null ? b.getSymbol() : "" + b.getAtomicNumber();
            atomUniqueCounter2.add(hyb);
        }
        Collections.sort(atomUniqueCounter1);
        Collections.sort(atomUniqueCounter2);
        if (atomUniqueCounter1.isEmpty()) {
            return 0;
        }
        LinkedList common = new LinkedList(atomUniqueCounter1);
        common.retainAll(atomUniqueCounter2);
        atomUniqueCounter1.clear();
        atomUniqueCounter2.clear();
        return common.size();
    }
}

