/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd;

import java.io.Serializable;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.BaseMapping;
import org.openscience.smsd.Substructure;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.mcsplus1.MCSPlusMapper;
import org.openscience.smsd.algorithm.rgraph.CDKMCSHandler;
import org.openscience.smsd.algorithm.single.SingleMappingHandler;
import org.openscience.smsd.algorithm.ventofoggia.VF2MCS;
import org.openscience.smsd.interfaces.Algorithm;
import org.openscience.smsd.interfaces.IResults;

public final class Isomorphism
extends BaseMapping
implements Serializable {
    private static final boolean DEBUG = false;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(Isomorphism.class);
    static final long serialVersionUID = 10278639972837495L;
    private final Algorithm algorithmType;
    private double bondSensitiveMcGregorOut = -1.0;
    private double bondInSensitiveMcGregor = -1.0;

    public Isomorphism(IAtomContainer query2, IAtomContainer target, Algorithm algorithmType, AtomMatcher am, BondMatcher bm) throws CDKException {
        super(query2, target, am, bm);
        this.algorithmType = algorithmType;
        this.mcsBuilder(super.getQuery(), super.getTarget());
        super.setSubgraph(this.isSubgraph());
    }

    public Isomorphism(IQueryAtomContainer query2, IAtomContainer target, Algorithm algorithmType) throws CDKException {
        super(query2, target, AtomMatcher.forQuery(), BondMatcher.forQuery());
        this.algorithmType = algorithmType;
        this.mcsBuilder(super.getQuery(), super.getTarget());
        super.setSubgraph(this.isSubgraph());
    }

    private synchronized void mcsBuilder(IAtomContainer mol1, IAtomContainer mol2) throws CDKException {
        int rBondCount = mol1.getBondCount();
        int pBondCount = mol2.getBondCount();
        int rAtomCount = mol1.getAtomCount();
        int pAtomCount = mol2.getAtomCount();
        int expectedMaxGraphmatch = this.expectedMaxGraphmatch(mol1, mol2);
        if (expectedMaxGraphmatch == 1 || rAtomCount == 1 || pAtomCount == 1) {
            this.singleMapping();
        } else {
            this.chooseAlgorithm();
        }
    }

    private synchronized void chooseAlgorithm() throws CDKException {
        switch (this.algorithmType) {
            case CDKMCS: {
                this.cdkMCSAlgorithm();
                break;
            }
            case DEFAULT: {
                this.defaultMCSAlgorithm();
                break;
            }
            case MCSPlus: {
                this.mcsPlusAlgorithm();
                break;
            }
            case VFLibMCS: {
                this.vfLibMCSAlgorithm();
            }
        }
    }

    private synchronized boolean cdkMCSAlgorithm() {
        CDKMCSHandler mcs = this.getQuery() instanceof IQueryAtomContainer ? new CDKMCSHandler(this.getQuery(), this.getTarget(), this.atomMatcher, this.bondMatcher) : new CDKMCSHandler(this.getQuery(), this.getTarget(), this.atomMatcher, this.bondMatcher);
        this.clearMaps();
        this.getMCSList().addAll(mcs.getAllAtomMapping());
        return mcs.isTimeout();
    }

    private synchronized boolean mcsPlusAlgorithm() throws CDKException {
        int expectedMaxGraphmatch = this.expectedMaxGraphmatch(this.getQuery(), this.getTarget());
        IResults mcs = this.getQuery() instanceof IQueryAtomContainer ? new org.openscience.smsd.algorithm.mcsplus2.MCSPlusMapper((IQueryAtomContainer)this.getQuery(), this.getTarget(), this.atomMatcher, this.bondMatcher) : (expectedMaxGraphmatch < 3 ? new MCSPlusMapper(this.getQuery(), this.getTarget(), this.atomMatcher, this.bondMatcher) : (expectedMaxGraphmatch > 3 ? new org.openscience.smsd.algorithm.mcsplus.MCSPlusMapper(this.getQuery(), this.getTarget(), this.atomMatcher, this.bondMatcher) : new org.openscience.smsd.algorithm.mcsplus2.MCSPlusMapper(this.getQuery(), this.getTarget(), this.atomMatcher, this.bondMatcher)));
        this.clearMaps();
        this.getMCSList().addAll(mcs.getAllAtomMapping());
        return false;
    }

    private synchronized boolean substructureAlgorithm() throws CDKException {
        Substructure mcs = this.getQuery() instanceof IQueryAtomContainer ? new Substructure((IQueryAtomContainer)this.getQuery(), this.getTarget(), this.atomMatcher, this.bondMatcher, true) : new Substructure(this.getQuery(), this.getTarget(), this.atomMatcher, this.bondMatcher, true);
        this.clearMaps();
        if (mcs.isSubgraph()) {
            this.getMCSList().addAll(mcs.getAllAtomMapping());
        }
        return mcs.isSubgraph();
    }

    private synchronized void vfLibMCSAlgorithm() throws CDKException {
        VF2MCS mcs = this.getQuery() instanceof IQueryAtomContainer ? new VF2MCS((IQueryAtomContainer)this.getQuery(), this.getTarget(), this.atomMatcher, this.bondMatcher) : new VF2MCS(this.getQuery(), this.getTarget(), this.atomMatcher, this.bondMatcher);
        this.clearMaps();
        this.getMCSList().addAll(mcs.getAllAtomMapping());
    }

    private synchronized void singleMapping() {
        SingleMappingHandler mcs = new SingleMappingHandler(this.getQuery(), this.getTarget(), this.atomMatcher);
        this.clearMaps();
        this.getMCSList().addAll(mcs.getAllAtomMapping());
    }

    private synchronized void defaultMCSAlgorithm() {
        try {
            boolean substructureAlgorithm = false;
            if (this.getQuery().getAtomCount() > 1 && this.getTarget().getAtomCount() > 1) {
                substructureAlgorithm = this.substructureAlgorithm();
            }
            if (!substructureAlgorithm) {
                int expectedMaxGraphmatch = this.expectedMaxGraphmatch(this.getQuery(), this.getTarget());
                boolean moleculeConnected = this.isMoleculeConnected(this.getQuery(), this.getTarget());
                if (moleculeConnected && this.getQuery().getBondCount() > 1 && this.getTarget().getBondCount() > 1) {
                    this.cdkMCSAlgorithm();
                } else {
                    this.mcsPlusAlgorithm();
                }
            }
        }
        catch (CDKException e) {
            LOGGER.error(Level.SEVERE, null, e);
        }
    }

    @Override
    public synchronized boolean isSubgraph() {
        if (this.getMappingCount() <= 0) {
            return false;
        }
        float mappingSize = this.getAllAtomMapping().iterator().next().getCount();
        int sourceAtomCount = this.getQuery().getAtomCount();
        int targetAtomCount = this.getTarget().getAtomCount();
        if (mappingSize == (float)sourceAtomCount && mappingSize <= (float)targetAtomCount) {
            if (mappingSize == 1.0f) {
                return true;
            }
            if (!this.getAllBondMaps().isEmpty() && this.getAllBondMaps().iterator().next().size() == this.getQuery().getBondCount()) {
                return true;
            }
        }
        return false;
    }

    public double getBondSensitiveMcGregorOut() {
        return this.bondSensitiveMcGregorOut;
    }

    public void setBondSenSitiveMcGregorOut(double bondSensitiveMcGregorOut) {
        this.bondSensitiveMcGregorOut = bondSensitiveMcGregorOut;
    }

    public double getBondInSensitiveMcGregor() {
        return this.bondInSensitiveMcGregor;
    }

    public void setBondInSenSitiveMcGregor(double bondInSensitiveMcGregor) {
        this.bondInSensitiveMcGregor = bondInSensitiveMcGregor;
    }
}

