/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.BaseMapping;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.single.SingleMappingHandler;
import org.openscience.smsd.algorithm.ventofoggia.VF2Substructure;

public final class Substructure
extends BaseMapping {
    private static final boolean DEBUG = false;
    private int vfMappingSize = -1;
    private final ILoggingTool Logger = LoggingToolFactory.createLoggingTool(Substructure.class);

    public Substructure(IAtomContainer query2, IAtomContainer target, AtomMatcher am, BondMatcher bm, boolean findAllSubgraph) throws CDKException {
        super(query2, target, am, bm);
        super.setSubgraph(this.findSubgraphs(findAllSubgraph));
    }

    public Substructure(IQueryAtomContainer query2, IAtomContainer target, boolean findAllSubgraphFlag) throws CDKException {
        super(query2, target, AtomMatcher.forQuery(), BondMatcher.forQuery());
        super.setSubgraph(this.findSubgraphs(findAllSubgraphFlag));
    }

    private synchronized boolean hasMap(AtomAtomMapping map, List<AtomAtomMapping> mapGlobal) {
        return mapGlobal.stream().anyMatch(test -> test.equals(map));
    }

    private synchronized boolean findSubgraphs(boolean findAllMatches) throws CDKException {
        boolean isSubgraph;
        if (this.getTarget() == null || this.getQuery() == null) {
            throw new CDKException("Query or Target molecule is not initialized (NULL)");
        }
        if (this.getQuery().getAtomCount() > this.getTarget().getAtomCount()) {
            return false;
        }
        int rBondCount = this.getQuery().getBondCount();
        int pBondCount = this.getTarget().getBondCount();
        int rAtomCount = this.getQuery().getAtomCount();
        int pAtomCount = this.getTarget().getAtomCount();
        int expectedMaxGraphmatch = this.expectedMaxGraphmatch(this.getQuery(), this.getTarget());
        if (expectedMaxGraphmatch == 1 && rAtomCount <= pAtomCount) {
            isSubgraph = this.singleMapping();
        } else {
            ArrayList<AtomAtomMapping> mappingsVF2 = new ArrayList<AtomAtomMapping>();
            VF2Substructure mapper = this.getQuery() instanceof IQueryAtomContainer ? new VF2Substructure((IQueryAtomContainer)this.getQuery(), this.getTarget(), findAllMatches, this.atomMatcher, this.bondMatcher) : new VF2Substructure(this.getQuery(), this.getTarget(), this.atomMatcher, this.bondMatcher, findAllMatches);
            isSubgraph = mapper.isSubgraph();
            List<AtomAtomMapping> atomMappings = mapper.getAllAtomMapping();
            if (!isSubgraph) {
                return false;
            }
            mappingsVF2.addAll(atomMappings);
            this.setVFMappings(mappingsVF2);
        }
        return isSubgraph;
    }

    private synchronized void setVFMappings(List<AtomAtomMapping> mappingsVF2) {
        int counter = 0;
        for (AtomAtomMapping solution : mappingsVF2) {
            AtomAtomMapping atomatomMapping = new AtomAtomMapping(this.getQuery(), this.getTarget());
            if (solution.getCount() > this.vfMappingSize) {
                this.vfMappingSize = solution.getCount();
                counter = 0;
            }
            solution.getMappingsByAtoms().entrySet().stream().forEach(mapping -> {
                IAtom qAtom = (IAtom)mapping.getKey();
                IAtom tAtom = (IAtom)mapping.getValue();
                if (qAtom != null && tAtom != null) {
                    atomatomMapping.put(qAtom, tAtom);
                } else {
                    try {
                        throw new CDKException("Atom index pointing to NULL");
                    }
                    catch (CDKException ex) {
                        this.Logger.error(Level.SEVERE, null, ex);
                    }
                }
            });
            if (atomatomMapping.isEmpty() || this.hasMap(atomatomMapping, this.getMCSList()) || atomatomMapping.getCount() != this.vfMappingSize) continue;
            this.getMCSList().add(counter, atomatomMapping);
            ++counter;
        }
    }

    private synchronized boolean singleMapping() {
        SingleMappingHandler mcs = !(this.getQuery() instanceof IQueryAtomContainer) && !(this.getTarget() instanceof IQueryAtomContainer) ? new SingleMappingHandler(this.getQuery(), this.getTarget(), this.atomMatcher) : new SingleMappingHandler((IQueryAtomContainer)this.getQuery(), this.getTarget(), this.atomMatcher);
        return mcs.getAllAtomMapping() != null && !mcs.getAllAtomMapping().isEmpty();
    }
}

