/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.matchers;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;

public class AtomBondMatcher {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(AtomBondMatcher.class);
    private static final boolean DEBUG = false;

    public static boolean matchAtomAndBond(IBond b1, IBond b2, AtomMatcher atomMatcher, BondMatcher bondMatcher, boolean undirected) {
        boolean atomMatch = AtomBondMatcher.matches(b1.getBegin(), b2.getBegin(), atomMatcher) && AtomBondMatcher.matches(b1.getEnd(), b2.getEnd(), atomMatcher);
        boolean bondMatch = AtomBondMatcher.matches(b1, b2, bondMatcher);
        if (undirected) {
            atomMatch |= AtomBondMatcher.matches(b1.getBegin(), b2.getEnd(), atomMatcher) && AtomBondMatcher.matches(b1.getEnd(), b2.getBegin(), atomMatcher);
        }
        return atomMatch && bondMatch;
    }

    public static boolean matches(IBond bondA1, IBond bondA2, BondMatcher bm) {
        return bm.matches(bondA1, bondA2);
    }

    public static boolean matches(IAtom a1, IAtom a2, AtomMatcher am) {
        return am.matches(a1, a2);
    }

    public static AtomMatcher atomMatcher(boolean matchAtomTypes, boolean shouldMatchRings) {
        AtomMatcher am = AtomMatcher.forElement();
        if (matchAtomTypes) {
            am = AtomMatcher.forAtomTypeMatcher();
        }
        if (shouldMatchRings && !matchAtomTypes) {
            am = AtomMatcher.forRingMatcher();
        }
        if (shouldMatchRings && matchAtomTypes) {
            am = AtomMatcher.forRingAtomTypeMatcher();
        }
        return am;
    }

    public static BondMatcher bondMatcher(boolean matchBond, boolean shouldMatchRings) {
        BondMatcher bm = BondMatcher.forAny();
        if (matchBond) {
            bm = BondMatcher.forOrder();
        }
        if (shouldMatchRings) {
            bm = BondMatcher.forRing();
        }
        if (matchBond && shouldMatchRings) {
            bm = BondMatcher.forStrictOrder();
        }
        return bm;
    }

    public static AtomMatcher queryAtomMatcher() {
        return AtomMatcher.forQuery();
    }

    public static BondMatcher queryBondMatcher() {
        return BondMatcher.forQuery();
    }
}

