/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.matchers;

import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;

public abstract class AtomMatcher {
    public abstract String toString();

    public abstract boolean matches(IAtom var1, IAtom var2);

    public static AtomMatcher forAny() {
        return new AnyMatcher();
    }

    public static AtomMatcher forElement() {
        return new ElementMatcher();
    }

    public static AtomMatcher forQuery() {
        return new QueryMatcher();
    }

    public static AtomMatcher forRingAtomTypeMatcher() {
        return new RingAtomTypeMatcher();
    }

    public static AtomMatcher forAtomTypeMatcher() {
        return new forAtomTypeElementMatcher();
    }

    public static AtomMatcher forRingMatcher() {
        return new forRingElementMatcher();
    }

    private static final class AnyMatcher
    extends AtomMatcher {
        private AnyMatcher() {
        }

        @Override
        public boolean matches(IAtom atom1, IAtom atom2) {
            return true;
        }

        @Override
        public String toString() {
            return "AnyMatcher";
        }
    }

    private static final class ElementMatcher
    extends AtomMatcher {
        private ElementMatcher() {
        }

        @Override
        public boolean matches(IAtom atom1, IAtom atom2) {
            return this.atomicNumber(atom1) == this.atomicNumber(atom2);
        }

        private int atomicNumber(IAtom atom) {
            Integer elem = atom.getAtomicNumber();
            if (elem != null) {
                return elem;
            }
            if (atom instanceof IPseudoAtom) {
                return 0;
            }
            throw new NullPointerException("an atom had unset atomic number");
        }

        @Override
        public String toString() {
            return "ElementMatcher";
        }
    }

    private static final class QueryMatcher
    extends AtomMatcher {
        private QueryMatcher() {
        }

        @Override
        public boolean matches(IAtom atom1, IAtom atom2) {
            return ((IQueryAtom)atom1).matches(atom2);
        }

        @Override
        public String toString() {
            return "QueryMatcher";
        }
    }

    private static final class RingAtomTypeMatcher
    extends AtomMatcher {
        private RingAtomTypeMatcher() {
        }

        @Override
        public boolean matches(IAtom atom1, IAtom atom2) {
            return this.atomicNumber(atom1) == this.atomicNumber(atom2) && this.matchAtomType(atom1, atom2) && this.isRingSizeMatch(atom1, atom2);
        }

        private int atomicNumber(IAtom atom) {
            Integer elem = atom.getAtomicNumber();
            if (elem != null) {
                return elem;
            }
            if (atom instanceof IPseudoAtom) {
                return 0;
            }
            throw new NullPointerException("an atom had unset atomic number");
        }

        private boolean matchAtomType(IAtom atom1, IAtom atom2) {
            String rAtom = atom1.getAtomTypeName() == null ? atom1.getSymbol() : atom1.getAtomTypeName();
            String tAtom = atom2.getAtomTypeName() == null ? atom2.getSymbol() : atom2.getAtomTypeName();
            return rAtom.equals(tAtom);
        }

        private boolean isRingSizeMatch(IAtom atom1, IAtom atom2) {
            if (atom1.isInRing() & atom2.isInRing()) {
                List ringsizesQ = (List)atom1.getProperty("cdk:RingSizes");
                List ringsizesT = (List)atom2.getProperty("cdk:RingSizes");
                if (ringsizesQ == null || ringsizesT == null) {
                    return false;
                }
                return ringsizesT.containsAll(ringsizesQ) || ringsizesQ.containsAll(ringsizesT);
            }
            return !atom1.isAromatic() && !atom2.isAromatic();
        }

        @Override
        public String toString() {
            return "RingAtomTypeMatcher";
        }
    }

    private static final class forAtomTypeElementMatcher
    extends AtomMatcher {
        private forAtomTypeElementMatcher() {
        }

        @Override
        public boolean matches(IAtom atom1, IAtom atom2) {
            return this.atomicNumber(atom1) == this.atomicNumber(atom2) && this.matchAtomType(atom1, atom2);
        }

        private int atomicNumber(IAtom atom) {
            Integer elem = atom.getAtomicNumber();
            if (elem != null) {
                return elem;
            }
            if (atom instanceof IPseudoAtom) {
                return 0;
            }
            throw new NullPointerException("an atom had unset atomic number");
        }

        private boolean matchAtomType(IAtom atom1, IAtom atom2) {
            String rAtom = atom1.getAtomTypeName() == null ? atom1.getSymbol() : atom1.getAtomTypeName();
            String tAtom = atom2.getAtomTypeName() == null ? atom2.getSymbol() : atom2.getAtomTypeName();
            return rAtom.equals(tAtom);
        }

        @Override
        public String toString() {
            return "forAtomTypeElementMatcher";
        }
    }

    private static final class forRingElementMatcher
    extends AtomMatcher {
        private forRingElementMatcher() {
        }

        @Override
        public boolean matches(IAtom atom1, IAtom atom2) {
            return this.atomicNumber(atom1) == this.atomicNumber(atom2) && this.isRingSizeMatch(atom1, atom2);
        }

        private int atomicNumber(IAtom atom) {
            Integer elem = atom.getAtomicNumber();
            if (elem != null) {
                return elem;
            }
            if (atom instanceof IPseudoAtom) {
                return 0;
            }
            throw new NullPointerException("an atom had unset atomic number");
        }

        private boolean isRingSizeMatch(IAtom atom1, IAtom atom2) {
            if (atom1.isInRing() & atom2.isInRing()) {
                List ringsizesQ = (List)atom1.getProperty("cdk:RingSizes");
                List ringsizesT = (List)atom2.getProperty("cdk:RingSizes");
                if (ringsizesQ == null || ringsizesT == null) {
                    return false;
                }
                return ringsizesT.containsAll(ringsizesQ) || ringsizesQ.containsAll(ringsizesT);
            }
            return !atom1.isAromatic() && !atom2.isAromatic();
        }

        @Override
        public String toString() {
            return "forRingElementMatcher";
        }
    }
}

