/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.matchers;

import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;

public abstract class BondMatcher {
    public abstract String toString();

    public abstract boolean matches(IBond var1, IBond var2);

    public static BondMatcher forAny() {
        return new AnyMatcher();
    }

    public static BondMatcher forStrictOrder() {
        return new StrictOrderMatcher();
    }

    public static BondMatcher forOrder() {
        return new OrderMatcher();
    }

    public static BondMatcher forRing() {
        return new RingMatcher();
    }

    public static BondMatcher forQuery() {
        return new QueryMatcher();
    }

    private static final class AnyMatcher
    extends BondMatcher {
        private AnyMatcher() {
        }

        @Override
        public boolean matches(IBond bond1, IBond bond2) {
            return true;
        }

        @Override
        public String toString() {
            return "AnyMatcher";
        }
    }

    private static final class StrictOrderMatcher
    extends BondMatcher {
        private StrictOrderMatcher() {
        }

        @Override
        public boolean matches(IBond bond1, IBond bond2) {
            return bond1.isAromatic() == bond2.isAromatic() && (bond1.getOrder() == bond2.getOrder() || bond1.isAromatic() && bond2.isAromatic());
        }

        @Override
        public String toString() {
            return "StrictOrderMatcher";
        }
    }

    private static final class OrderMatcher
    extends BondMatcher {
        private OrderMatcher() {
        }

        @Override
        public boolean matches(IBond bond1, IBond bond2) {
            return bond1.isAromatic() && bond2.isAromatic() || bond1.getOrder() == bond2.getOrder();
        }

        @Override
        public String toString() {
            return "OrderMatcher";
        }
    }

    private static final class RingMatcher
    extends BondMatcher {
        private RingMatcher() {
        }

        @Override
        public boolean matches(IBond bond1, IBond bond2) {
            return bond1.isAromatic() == bond2.isAromatic() || !bond1.isAromatic() && !bond2.isAromatic();
        }

        @Override
        public String toString() {
            return "RingMatcher";
        }
    }

    private static final class QueryMatcher
    extends BondMatcher {
        private QueryMatcher() {
        }

        @Override
        public boolean matches(IBond bond1, IBond bond2) {
            return ((IQueryBond)bond1).matches(bond2);
        }

        @Override
        public String toString() {
            return "QueryMatcher";
        }
    }
}

