/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.mcgregor.McGregor;
import org.openscience.smsd.algorithm.mcsplus.MappingHandler;
import org.openscience.smsd.graph.EdgeProductGraph;
import org.openscience.smsd.graph.Graph;
import org.openscience.smsd.graph.Vertex;
import org.openscience.smsd.graph.algorithm.GraphKoch;
import org.openscience.smsd.tools.IterationManager;

public final class MCSPlus {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MCSPlus.class);
    private static final boolean DEBUG = false;
    private final IAtomContainer ac1;
    private final IAtomContainer ac2;
    private final List<List<Integer>> overlaps;
    private boolean timeout = false;
    private IterationManager iterationManager = null;
    private final AtomMatcher atomMatcher;
    private final BondMatcher bondMatcher;

    public synchronized boolean isTimeout() {
        return this.timeout;
    }

    private IterationManager getIterationManager() {
        return this.iterationManager;
    }

    private void setIterationManager(IterationManager iterationManager) {
        this.iterationManager = iterationManager;
    }

    public MCSPlus(IAtomContainer ac1, IAtomContainer ac2, AtomMatcher am, BondMatcher bm) {
        this.atomMatcher = am;
        this.bondMatcher = bm;
        this.ac1 = ac1;
        this.ac2 = ac2;
        this.overlaps = this.calculateMCS();
    }

    public MCSPlus(IQueryAtomContainer ac1, IAtomContainer ac2, AtomMatcher am, BondMatcher bm) {
        this.atomMatcher = am;
        this.bondMatcher = bm;
        this.ac1 = ac1;
        this.ac2 = ac2;
        this.overlaps = this.calculateMCS();
    }

    private List<List<Integer>> calculateMCS() {
        ArrayList<List<Integer>> finalMapping = new ArrayList<List<Integer>>();
        this.setIterationManager(new IterationManager(this.ac1.getAtomCount() * this.ac2.getAtomCount()));
        try {
            EdgeProductGraph gcg = EdgeProductGraph.create(this.ac1, this.ac2, this.atomMatcher, this.bondMatcher);
            int search_cliques = gcg.searchCliques();
            Graph comp_graph_nodes = gcg.getCompatibilityGraph();
            GraphKoch init = null;
            boolean connected = ConnectivityChecker.isConnected(this.ac1) && ConnectivityChecker.isConnected(this.ac2);
            init = new GraphKoch(comp_graph_nodes);
            init.findMaximalCliques();
            Stack<Set<Vertex>> maxCliqueSet = init.getMaxCliquesSet();
            ArrayList<Map<Integer, Integer>> mappings = new ArrayList<Map<Integer, Integer>>();
            while (!maxCliqueSet.empty()) {
                Map<Integer, Integer> indexindexMapping = MappingHandler.getMapping(comp_graph_nodes, this.ac1, this.ac2, maxCliqueSet.peek(), this.atomMatcher, this.bondMatcher);
                if (indexindexMapping != null) {
                    mappings.add(indexindexMapping);
                }
                maxCliqueSet.pop();
            }
            gcg.clear();
            for (Map map2 : mappings) {
                ArrayList exact_mapped_atoms = new ArrayList();
                map2.entrySet().stream().map(map -> {
                    exact_mapped_atoms.add((Integer)map.getKey());
                    return map;
                }).forEach(map -> exact_mapped_atoms.add((Integer)map.getValue()));
                finalMapping.add(exact_mapped_atoms);
            }
            List<List<Integer>> extendMappings = null;
            extendMappings = this.ac1 instanceof IQueryAtomContainer ? this.searchMcGregorMapping((IQueryAtomContainer)this.ac1, this.ac2, mappings) : this.searchMcGregorMapping(this.ac1, this.ac2, mappings);
            if (extendMappings != null && !extendMappings.isEmpty()) {
                finalMapping.addAll(extendMappings);
            }
        }
        catch (IOException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        return finalMapping;
    }

    private List<List<Integer>> searchMcGregorMapping(IAtomContainer ac1, IAtomContainer ac2, List<Map<Integer, Integer>> allMCSCopy) throws IOException {
        List<List<Integer>> cliques = new ArrayList<List<Integer>>();
        boolean ROPFlag = true;
        for (Map<Integer, Integer> firstPassMappings : allMCSCopy) {
            McGregor mgit;
            TreeMap<Integer, Integer> extendMapping = new TreeMap<Integer, Integer>(firstPassMappings);
            if (ac1.getAtomCount() >= ac2.getAtomCount() && extendMapping.size() < ac2.getAtomCount()) {
                mgit = new McGregor(ac1, ac2, cliques, this.atomMatcher, this.bondMatcher);
                mgit.startMcGregorIteration(ac1, mgit.getMCSSize(), extendMapping);
                cliques = mgit.getMappings();
            } else if (ac1.getAtomCount() < ac2.getAtomCount() && extendMapping.size() < ac1.getAtomCount()) {
                extendMapping.clear();
                ROPFlag = false;
                firstPassMappings.entrySet().stream().forEach(map -> extendMapping.put((Integer)map.getValue(), (Integer)map.getKey()));
                mgit = new McGregor(ac2, ac1, cliques, this.atomMatcher, this.bondMatcher);
                mgit.startMcGregorIteration(ac2, mgit.getMCSSize(), extendMapping);
                cliques = mgit.getMappings();
            } else {
                ROPFlag = true;
                ArrayList exact_mapped_atoms = new ArrayList();
                extendMapping.entrySet().stream().map(map -> {
                    exact_mapped_atoms.add((Integer)map.getKey());
                    return map;
                }).forEach(map -> exact_mapped_atoms.add((Integer)map.getValue()));
                cliques.add(exact_mapped_atoms);
            }
            if (!this.checkTimeout()) continue;
            break;
        }
        List<List<Integer>> finalMappings = this.setMappings(ROPFlag, cliques);
        return finalMappings;
    }

    private List<List<Integer>> searchMcGregorMapping(IQueryAtomContainer ac1, IAtomContainer ac2, List<Map<Integer, Integer>> allMCSCopy) throws IOException {
        List<List<Integer>> cliques = new ArrayList<List<Integer>>();
        boolean ROPFlag = true;
        for (Map<Integer, Integer> firstPassMappings : allMCSCopy) {
            TreeMap<Integer, Integer> extendMapping = new TreeMap<Integer, Integer>(firstPassMappings);
            McGregor mgit = new McGregor(ac1, ac2, cliques, this.atomMatcher, this.bondMatcher);
            mgit.startMcGregorIteration(ac1, mgit.getMCSSize(), extendMapping);
            cliques = mgit.getMappings();
            if (!this.checkTimeout()) continue;
            break;
        }
        List<List<Integer>> finalMappings = this.setMappings(ROPFlag, cliques);
        return finalMappings;
    }

    private List<List<Integer>> setMappings(boolean RONP, List<List<Integer>> mappings) {
        int counter = 0;
        int mcsSize = 0;
        ArrayList<List<Integer>> finalMappings = new ArrayList<List<Integer>>();
        for (List<Integer> mapping : mappings) {
            ArrayList<Integer> indexindexMapping = new ArrayList<Integer>();
            for (int index = 0; index < mapping.size(); index += 2) {
                Integer tIndex;
                Integer qIndex;
                if (RONP) {
                    qIndex = mapping.get(index);
                    tIndex = mapping.get(index + 1);
                } else {
                    qIndex = mapping.get(index + 1);
                    tIndex = mapping.get(index);
                }
                if (qIndex == null || tIndex == null) continue;
                indexindexMapping.add(qIndex);
                indexindexMapping.add(tIndex);
            }
            if (!indexindexMapping.isEmpty() && indexindexMapping.size() > mcsSize) {
                mcsSize = indexindexMapping.size();
                finalMappings.clear();
                counter = 0;
            }
            if (indexindexMapping.isEmpty() || finalMappings.contains(indexindexMapping) || indexindexMapping.size() != mcsSize) continue;
            finalMappings.add(counter, indexindexMapping);
            ++counter;
        }
        return finalMappings;
    }

    private boolean checkTimeout() {
        if (this.getIterationManager().isMaxIteration()) {
            this.timeout = true;
            return true;
        }
        this.getIterationManager().increment();
        return false;
    }

    public synchronized List<List<Integer>> getOverlaps() {
        return Collections.unmodifiableList(this.overlaps);
    }
}

