/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus;

import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.mcsplus.MCSPlus;

public class MCSPlusBuilder {
    private IAtomContainer ac1;
    private IAtomContainer ac2;
    private AtomMatcher am;
    private BondMatcher bm;

    public MCSPlusBuilder setQuery(IAtomContainer ac1) {
        this.ac1 = ac1;
        return this;
    }

    public MCSPlusBuilder setTarget(IAtomContainer ac2) {
        this.ac2 = ac2;
        return this;
    }

    public MCSPlusBuilder setAtomMatcher(AtomMatcher am) {
        this.am = am;
        return this;
    }

    public MCSPlusBuilder setBondMatcher(BondMatcher bm) {
        this.bm = bm;
        return this;
    }

    public MCSPlus createMCSPlus() {
        return new MCSPlus(this.ac1, this.ac2, this.am, this.bm);
    }
}

