/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.mcsplus.MCSPlus;
import org.openscience.smsd.algorithm.mcsplus.MCSPlusBuilder;
import org.openscience.smsd.filters.PostFilter;
import org.openscience.smsd.interfaces.IResults;

public final class MCSPlusMapper
implements IResults {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MCSPlusMapper.class);
    private final List<AtomAtomMapping> allAtomMCS;
    private final List<Map<Integer, Integer>> allMCS;
    private final IAtomContainer source;
    private final IAtomContainer target;
    private boolean flagExchange = false;
    private final boolean timeout;
    private final boolean DEBUG = false;
    private final AtomMatcher atomMatcher;
    private final BondMatcher bondMatcher;

    public MCSPlusMapper(IAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) throws CDKException {
        this.source = source;
        this.target = target;
        this.atomMatcher = am;
        this.bondMatcher = bm;
        this.allAtomMCS = Collections.synchronizedList(new ArrayList());
        this.allMCS = Collections.synchronizedList(new ArrayList());
        this.timeout = this.searchMCS();
    }

    public MCSPlusMapper(IQueryAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) throws CDKException {
        this.source = source;
        this.target = target;
        this.atomMatcher = am;
        this.bondMatcher = bm;
        this.allAtomMCS = Collections.synchronizedList(new ArrayList());
        this.allMCS = Collections.synchronizedList(new ArrayList());
        this.timeout = this.searchMCS();
    }

    private synchronized boolean searchMCS() {
        List<List<Integer>> mappings;
        List<List<Integer>> overlaps;
        if (this.source instanceof IQueryAtomContainer) {
            MCSPlus mcsplus = new MCSPlus((IQueryAtomContainer)this.source, this.target, this.atomMatcher, this.bondMatcher);
            overlaps = mcsplus.getOverlaps();
            mappings = Collections.synchronizedList(overlaps);
        } else if (!(this.source instanceof IQueryAtomContainer) && this.source.getAtomCount() <= this.target.getAtomCount()) {
            MCSPlus mcsplus = new MCSPlusBuilder().setQuery(this.source).setTarget(this.target).setAtomMatcher(this.atomMatcher).setBondMatcher(this.bondMatcher).createMCSPlus();
            overlaps = mcsplus.getOverlaps();
            mappings = Collections.synchronizedList(overlaps);
        } else {
            this.flagExchange = true;
            MCSPlus mcsplus = new MCSPlusBuilder().setQuery(this.target).setTarget(this.source).setAtomMatcher(this.atomMatcher).setBondMatcher(this.bondMatcher).createMCSPlus();
            overlaps = mcsplus.getOverlaps();
            mappings = Collections.synchronizedList(overlaps);
        }
        if (this.flagExchange) {
            mappings = this.reverseMappings(mappings);
        }
        List<Map<Integer, Integer>> solutions = PostFilter.filter(mappings);
        this.setAllMapping(solutions);
        this.setAllAtomMapping();
        return mappings.isEmpty();
    }

    private synchronized void setAllMapping(List<Map<Integer, Integer>> solutions) {
        try {
            int bestSolSize = 0;
            for (Map<Integer, Integer> solution : solutions) {
                SortedMap<Integer, Integer> validSolution = Collections.synchronizedSortedMap(new TreeMap());
                validSolution.putAll(solution);
                if (validSolution.size() > bestSolSize && validSolution.size() <= this.source.getAtomCount() && validSolution.size() <= this.target.getAtomCount()) {
                    bestSolSize = validSolution.size();
                    this.allMCS.clear();
                }
                if (validSolution.size() != bestSolSize) continue;
                this.allMCS.add(validSolution);
            }
        }
        catch (Exception ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
    }

    private synchronized void setAllAtomMapping() {
        try {
            this.allMCS.stream().map(solution -> {
                AtomAtomMapping atomMapping = new AtomAtomMapping(this.source, this.target);
                solution.entrySet().stream().forEach(m -> {
                    int indexI = (Integer)m.getKey();
                    int indexJ = (Integer)m.getValue();
                    IAtom sourceAtom = this.source.getAtom(indexI);
                    IAtom targetAtom = this.target.getAtom(indexJ);
                    atomMapping.put(sourceAtom, targetAtom);
                });
                return atomMapping;
            }).forEach(atomMapping -> this.allAtomMCS.add((AtomAtomMapping)atomMapping));
        }
        catch (Exception e) {
            LOGGER.error(Level.SEVERE, null, e);
        }
    }

    @Override
    public synchronized List<AtomAtomMapping> getAllAtomMapping() {
        return Collections.unmodifiableList(this.allAtomMCS);
    }

    @Override
    public synchronized AtomAtomMapping getFirstAtomMapping() {
        if (this.allAtomMCS.iterator().hasNext()) {
            return this.allAtomMCS.iterator().next();
        }
        return new AtomAtomMapping(this.source, this.target);
    }

    public synchronized boolean isTimeout() {
        return this.timeout;
    }

    private List<List<Integer>> reverseMappings(List<List<Integer>> mappings) {
        ArrayList<List<Integer>> reverse = new ArrayList<List<Integer>>();
        mappings.stream().map(mapping -> {
            Collections.reverse(mapping);
            return mapping;
        }).forEach(mapping -> reverse.add((List<Integer>)mapping));
        return reverse;
    }
}

