/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.graph.Graph;
import org.openscience.smsd.graph.Vertex;

public class MappingHandler {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MappingHandler.class);
    private static final boolean DEBUG = false;

    private static List<Integer> extractCliqueMapping(List<Integer> comp_graph_nodes, List<Integer> clique_List_org) {
        List<Integer> clique_mapping = Collections.synchronizedList(new ArrayList());
        ArrayList<Integer> clique_List = new ArrayList<Integer>(clique_List_org);
        int clique_siz = clique_List.size();
        int vec_size = comp_graph_nodes.size();
        for (int a = 0; a < clique_siz; ++a) {
            for (int b = 0; b < vec_size; b += 3) {
                if (!Objects.equals(clique_List.get(a), comp_graph_nodes.get(b + 2))) continue;
                clique_mapping.add(comp_graph_nodes.get(b));
                clique_mapping.add(comp_graph_nodes.get(b + 1));
            }
        }
        return clique_mapping;
    }

    public static List<List<Integer>> extractMapping(List<List<Integer>> _mappings, List<Integer> comp_graph_nodes, List<Integer> clique_List_org) {
        try {
            List<Integer> clique_List = MappingHandler.extractCliqueMapping(comp_graph_nodes, clique_List_org);
            _mappings.add(clique_List);
        }
        catch (Exception e) {
            LOGGER.debug("Error in FinalMapping List: " + e.getCause());
            e.printStackTrace();
            System.exit(1);
        }
        return _mappings;
    }

    public static Map<Integer, Integer> getMapping(List<Integer> comp_graph_nodes, Collection<Integer> clique_List_org) {
        SortedMap<Integer, Integer> clique_mapping = Collections.synchronizedSortedMap(new TreeMap());
        try {
            ArrayList<Integer> clique_List = new ArrayList<Integer>(clique_List_org);
            for (int a = 0; a < clique_List.size(); ++a) {
                for (int b = 0; b < comp_graph_nodes.size(); b += 3) {
                    if (!Objects.equals(clique_List.get(a), comp_graph_nodes.get(b + 2))) continue;
                    clique_mapping.put(comp_graph_nodes.get(b), comp_graph_nodes.get(b + 1));
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error in FinalMapping List: " + e.getCause());
            e.printStackTrace();
            System.exit(1);
        }
        return clique_mapping;
    }

    public static Map<Integer, Integer> getMapping(Graph comp_graph_nodes, IAtomContainer s, IAtomContainer t, Set<Vertex> cliques, AtomMatcher am, BondMatcher bm) {
        TreeMap<Integer, Integer> bondCliques = new TreeMap<Integer, Integer>();
        cliques.forEach(v -> bondCliques.put(v.getQueryBondIndex(), v.getTargetBondIndex()));
        Map<Integer, Integer> atomatommapping = MappingHandler.makeAtomsMapOfBondsMap(bondCliques, s, t, am, bm);
        return atomatommapping;
    }

    public static IAtomContainer toSubstructures(Set<Integer> bondMap, IAtomContainer ac) {
        IAtomContainer submol = ac.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        bondMap.stream().map(b -> {
            submol.addAtom(ac.getBond((int)b).getAtom(0));
            return b;
        }).map(b -> {
            submol.addAtom(ac.getBond((int)b).getAtom(1));
            return b;
        }).forEachOrdered(b -> submol.addBond(ac.getBond((int)b)));
        return submol;
    }

    public static synchronized Set<Map<Integer, Integer>> filter(List<List<Integer>> mappings) {
        TreeSet<Map<Integer, Integer>> final_MAPPINGS = new TreeSet<Map<Integer, Integer>>();
        mappings.stream().map(map -> {
            TreeMap<Integer, Integer> mapping = new TreeMap<Integer, Integer>();
            for (int i = 0; i < map.size(); i += 2) {
                mapping.put((Integer)map.get(i), (Integer)map.get(i + 1));
            }
            return mapping;
        }).forEachOrdered(mapping -> final_MAPPINGS.add((Map<Integer, Integer>)mapping));
        return final_MAPPINGS;
    }

    public static Map<Integer, Integer> makeAtomsMapOfBondsMap(Map<Integer, Integer> l, IAtomContainer g1, IAtomContainer g2, AtomMatcher am, BondMatcher bm) {
        if (l == null) {
            return new TreeMap<Integer, Integer>();
        }
        Map<Integer, Integer> result = new TreeMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> map : l.entrySet()) {
            IBond bond1 = g1.getBond(map.getKey());
            IBond bond2 = g2.getBond(map.getValue());
            IAtom[] atom1 = BondManipulator.getAtomArray(bond1);
            IAtom[] atom2 = BondManipulator.getAtomArray(bond2);
            for (int j = 0; j < 2; ++j) {
                List<IBond> bondsConnectedToAtom1j = g1.getConnectedBondsList(atom1[j]);
                for (int k = 0; k < bondsConnectedToAtom1j.size(); ++k) {
                    if (bondsConnectedToAtom1j.get(k).equals(bond1)) continue;
                    IBond testBond = bondsConnectedToAtom1j.get(k);
                    for (Map.Entry<Integer, Integer> m : l.entrySet()) {
                        if (m.getKey().intValue() != g1.indexOf(testBond)) continue;
                        IBond testBond2 = g2.getBond(m.getValue());
                        for (int n = 0; n < 2; ++n) {
                            List<IBond> bondsToTest = g2.getConnectedBondsList(atom2[n]);
                            if (!bondsToTest.contains(testBond2)) continue;
                            if (j == n) {
                                if (!result.containsKey(g1.indexOf(atom1[0])) && !result.containsValue(g2.indexOf(atom2[0]))) {
                                    result.put(g1.indexOf(atom1[0]), g2.indexOf(atom2[0]));
                                }
                            } else if (!result.containsKey(g1.indexOf(atom1[1])) && !result.containsValue(g2.indexOf(atom2[0]))) {
                                result.put(g1.indexOf(atom1[1]), g2.indexOf(atom2[0]));
                            }
                            if (j == n) {
                                if (result.containsKey(g1.indexOf(atom1[1])) || result.containsValue(g2.indexOf(atom2[1]))) continue;
                                result.put(g1.indexOf(atom1[1]), g2.indexOf(atom2[1]));
                                continue;
                            }
                            if (result.containsKey(g1.indexOf(atom1[0])) || result.containsValue(g2.indexOf(atom2[1]))) continue;
                            result.put(g1.indexOf(atom1[0]), g2.indexOf(atom2[1]));
                        }
                    }
                }
            }
        }
        if (result.isEmpty() && l.size() == 1) {
            result = MappingHandler.SingleMappingCase(l, g1, g2, am, bm);
        }
        return result;
    }

    public static IAtomContainer getSubgraphProjectAtoms(IAtomContainer ac1, Set<Integer> mapping) throws CloneNotSupportedException {
        IAtomContainer ac = ac1.clone();
        HashSet<IAtom> remove = new HashSet<IAtom>();
        for (IAtom a2 : ac1.atoms()) {
            if (mapping.contains(ac1.indexOf(a2))) continue;
            remove.add(a2);
        }
        remove.forEach(a -> ac.removeAtom((IAtom)a));
        System.out.println("");
        return ac;
    }

    public static IAtomContainer getSubgraphProjectBonds(Graph comp_graph_nodes, IAtomContainer ac, Collection<Integer> mapping) throws CloneNotSupportedException {
        IAtomContainer result = ac.clone();
        HashSet commonAtoms = new HashSet();
        mapping.forEach(b1 -> mapping.stream().map(b2 -> MappingHandler.commonVertices(ac, ac.getBond((int)b1), ac.getBond((int)b2))).filter(commonVertices -> !commonVertices.isEmpty()).forEachOrdered(commonVertices -> commonAtoms.addAll(commonVertices)));
        HashSet<IAtom> removeAtoms = new HashSet<IAtom>();
        for (IAtom a2 : result.atoms()) {
            if (commonAtoms.contains(result.indexOf(a2))) continue;
            removeAtoms.add(a2);
        }
        removeAtoms.forEach(a -> result.removeAtom((IAtom)a));
        return result;
    }

    public static Set<Integer> commonVertices(IAtomContainer ac, IBond e1, IBond e2) {
        LinkedHashSet<Integer> commonVertices = new LinkedHashSet<Integer>();
        for (IAtom a : e1.atoms()) {
            for (IAtom b : e2.atoms()) {
                if (a != b) continue;
                commonVertices.add(ac.indexOf(a));
            }
        }
        return commonVertices;
    }

    private static Map<Integer, Integer> SingleMappingCase(Map<Integer, Integer> l, IAtomContainer g1, IAtomContainer g2, AtomMatcher am, BondMatcher bm) {
        TreeMap<Integer, Integer> result = new TreeMap<Integer, Integer>();
        if (l.size() == 1) {
            IBond bond1 = g1.getBond(l.keySet().iterator().next());
            IBond bond2 = g2.getBond(l.values().iterator().next());
            if (bond1 instanceof IQueryBond) {
                if (((IQueryBond)bond1).matches(bond2)) {
                    IQueryAtom atom1 = (IQueryAtom)bond1.getAtom(0);
                    IQueryAtom atom2 = (IQueryAtom)bond1.getAtom(1);
                    if (atom1.matches(bond2.getAtom(0)) && atom2.matches(bond2.getAtom(1))) {
                        result.put(g1.indexOf(bond1.getAtom(0)), g2.indexOf(bond2.getAtom(0)));
                        result.put(g1.indexOf(bond1.getAtom(1)), g2.indexOf(bond2.getAtom(1)));
                    }
                    if (atom1.matches(bond2.getAtom(1)) && atom2.matches(bond2.getAtom(0))) {
                        result.put(g1.indexOf(bond1.getAtom(0)), g2.indexOf(bond2.getAtom(1)));
                        result.put(g1.indexOf(bond1.getAtom(1)), g2.indexOf(bond2.getAtom(0)));
                    }
                }
            } else {
                IAtom a1 = bond1.getBegin();
                IAtom a2 = bond1.getEnd();
                IAtom b1 = bond2.getBegin();
                IAtom b2 = bond2.getEnd();
                if (AtomBondMatcher.matches(a1, b1, am) && AtomBondMatcher.matches(a2, b2, am)) {
                    result.put(g1.indexOf(bond1.getAtom(0)), g2.indexOf(bond2.getAtom(0)));
                    result.put(g1.indexOf(bond1.getAtom(1)), g2.indexOf(bond2.getAtom(1)));
                }
                if (AtomBondMatcher.matches(a1, b2, am) && AtomBondMatcher.matches(a2, b1, am)) {
                    result.put(g1.indexOf(bond1.getAtom(0)), g2.indexOf(bond2.getAtom(1)));
                    result.put(g1.indexOf(bond1.getAtom(1)), g2.indexOf(bond2.getAtom(0)));
                }
            }
        }
        return result;
    }
}

