/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus1;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.graph.Edge;
import uk.ac.ebi.reactionblast.graphics.direct.MoleculeLabelDrawer;

public class BKKCKCF {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MoleculeLabelDrawer.class);
    private final List<Integer> comp_graph_nodes;
    private final List<Integer> c_edges;
    private final List<Integer> d_edges;
    private final Stack<List<Integer>> max_Cliques_Set;
    private int best_clique_size;
    protected final List<Integer> T;

    public BKKCKCF(List<Integer> comp_graph_nodes, List<Edge> cEdges, List<Edge> dEdges) {
        this.comp_graph_nodes = comp_graph_nodes;
        this.c_edges = new ArrayList<Integer>();
        this.d_edges = new ArrayList<Integer>();
        cEdges.stream().map(e -> {
            this.c_edges.add(e.getSource());
            return e;
        }).forEachOrdered(e -> this.c_edges.add(e.getSink()));
        dEdges.stream().map(e -> {
            this.d_edges.add(e.getSource());
            return e;
        }).forEachOrdered(e -> this.d_edges.add(e.getSink()));
        this.best_clique_size = 0;
        this.max_Cliques_Set = new Stack();
        this.T = new Stack<Integer>();
    }

    int init_Algorithm() {
        ArrayList<Integer> R = new ArrayList<Integer>();
        Stack<Integer> Q = new Stack<Integer>();
        ArrayList<Integer> X = new ArrayList<Integer>();
        List<Object> N = new ArrayList();
        Stack<Integer> P = new Stack<Integer>();
        Stack<Integer> V = new Stack<Integer>();
        int V_set_size = this.comp_graph_nodes.size() / 3;
        for (int a = 0; a < V_set_size; ++a) {
            V.push(this.comp_graph_nodes.get(a * 3 + 2));
        }
        V.push(0);
        int b = 0;
        while ((Integer)V.get(b) != 0) {
            int central_node = (Integer)V.get(b);
            P.clear();
            Q.clear();
            X.clear();
            N.clear();
            R.clear();
            N = this.find_neighbors(central_node);
            for (int c = 0; c < N.size(); c += 2) {
                if ((Integer)N.get(c + 1) == 1) {
                    if (this.T.contains(N.get(c))) {
                        X.add((Integer)N.get(c));
                    } else {
                        P.push((Integer)N.get(c));
                    }
                } else if ((Integer)N.get(c + 1) == 2) {
                    Q.push((Integer)N.get(c));
                }
                int V_size = V.size();
                int neighbor_position = -1;
                for (int d = 0; d < V_size; ++d) {
                    if (((Integer)N.get(c)).intValue() != ((Integer)V.get(d)).intValue()) continue;
                    neighbor_position = d;
                }
                if (neighbor_position == -1) continue;
                for (int e = neighbor_position; e < V_size - 1; ++e) {
                    V.set(e, (Integer)V.get(e + 1));
                }
                V.pop();
                if (neighbor_position >= b) continue;
                --b;
            }
            P.add(0);
            R.add(central_node);
            this.Enumerate_Cliques(R, P, Q, X);
            this.T.add(central_node);
            ++b;
        }
        return 0;
    }

    private int Enumerate_Cliques(List<Integer> R, Stack<Integer> P, Stack<Integer> Q, List<Integer> X) {
        List<Object> N = new ArrayList();
        Stack<Integer> P_Prime = new Stack<Integer>();
        P.stream().forEach(I -> P_Prime.add((Integer)I));
        ArrayList<Integer> R_copy = new ArrayList<Integer>();
        Stack<Integer> P_copy = new Stack<Integer>();
        Stack<Integer> Q_copy = new Stack<Integer>();
        ArrayList<Integer> X_copy = new ArrayList<Integer>();
        if (P.size() == 1 && X.isEmpty()) {
            int clique_size = R.size();
            if (clique_size >= this.best_clique_size) {
                if (clique_size > this.best_clique_size) {
                    while (!this.max_Cliques_Set.empty()) {
                        this.getMax_Cliques_Set().pop();
                    }
                    this.best_clique_size = clique_size;
                }
                if (clique_size == this.best_clique_size) {
                    this.getMax_Cliques_Set().push(R);
                }
            }
            return 0;
        }
        int a = 0;
        while ((Integer)P_Prime.get(a) != 0) {
            int counter;
            int ui = (Integer)P_Prime.get(a);
            int P_size = P.size();
            int ut_node_pos = Integer.MAX_VALUE;
            for (counter = 0; counter < P_size - 1; ++counter) {
                if (((Integer)P.get(counter)).intValue() != ((Integer)P_Prime.get(a)).intValue()) continue;
                ut_node_pos = counter;
            }
            if (ut_node_pos == Integer.MAX_VALUE) {
                LOGGER.debug("ut_node_pos = 2147483647");
            }
            for (counter = ut_node_pos; counter < P_size - 1; ++counter) {
                P.setElementAt((Integer)P.get(counter + 1), counter);
            }
            P.pop();
            R_copy.clear();
            P_copy.clear();
            Q_copy.clear();
            X_copy.clear();
            N.clear();
            R.stream().forEach(obj -> R_copy.add((Integer)obj));
            P.stream().forEach(obj -> P_copy.add((Integer)obj));
            Q.stream().forEach(obj -> Q_copy.add((Integer)obj));
            X.stream().forEach(obj -> X_copy.add((Integer)obj));
            P_copy.pop();
            N = this.find_neighbors((Integer)P_Prime.get(a));
            int N_size = N.size();
            for (int b = 0; b < N_size; b += 2) {
                int e;
                int D_set_size = Q.size();
                int n_element_at_b = (Integer)N.get(b);
                for (int c = 0; c < D_set_size; ++c) {
                    int e2;
                    if (n_element_at_b != (Integer)Q.elementAt(c) || (Integer)N.get(b + 1) != 1) continue;
                    if (this.T.contains(n_element_at_b)) {
                        X_copy.add((Integer)N.get(b));
                    } else {
                        P_copy.push((Integer)N.get(b));
                    }
                    int D_copy_size = Q_copy.size();
                    int n_b_position = Integer.MAX_VALUE;
                    for (e2 = 0; e2 < D_copy_size; ++e2) {
                        if (n_element_at_b != (Integer)Q_copy.elementAt(e2)) continue;
                        n_b_position = e2;
                    }
                    for (e2 = n_b_position; e2 < D_copy_size - 1; ++e2) {
                        Q_copy.set(e2, (Integer)Q_copy.get(e2 + 1));
                    }
                    Q_copy.pop();
                }
                int ut_set_size = P_Prime.size();
                int neighbor_position = -1;
                for (e = 0; e < ut_set_size; ++e) {
                    if (!((Integer)N.get(b)).equals(P_Prime.get(e))) continue;
                    neighbor_position = e;
                }
                if (neighbor_position == -1) continue;
                for (e = neighbor_position; e < ut_set_size - 1; ++e) {
                    P_Prime.setElementAt((Integer)P_Prime.get(e + 1), e);
                }
                P_Prime.pop();
                if (neighbor_position >= a) continue;
                --a;
            }
            Stack<Integer> P_copy_N_intersec = new Stack<Integer>();
            Stack<Integer> Q_copy_N_intersec = new Stack<Integer>();
            ArrayList<Integer> X_copy_N_intersec = new ArrayList<Integer>();
            for (int sec = 0; sec < N_size; sec += 2) {
                int nElement = (Integer)N.get(sec);
                if (P_copy.contains(nElement)) {
                    P_copy_N_intersec.push(nElement);
                }
                if (Q_copy.contains(nElement)) {
                    Q_copy_N_intersec.push(nElement);
                }
                if (!X_copy.contains(nElement)) continue;
                X_copy_N_intersec.add(nElement);
            }
            P_copy_N_intersec.push(0);
            R_copy.add(ui);
            this.Enumerate_Cliques(R_copy, P_copy_N_intersec, Q_copy_N_intersec, X_copy_N_intersec);
            X.add(ui);
            ++a;
        }
        return 0;
    }

    private List<Integer> find_neighbors(int central_node) {
        ArrayList<Integer> neighbor_vec = new ArrayList<Integer>();
        int C_edge_number = this.c_edges.size() / 2;
        for (int a = 0; a < C_edge_number; ++a) {
            if (this.c_edges.get(a * 2 + 0) == central_node) {
                neighbor_vec.add(this.c_edges.get(a * 2 + 1));
                neighbor_vec.add(1);
            }
            if (this.c_edges.get(a * 2 + 1) != central_node) continue;
            neighbor_vec.add(this.c_edges.get(a * 2 + 0));
            neighbor_vec.add(1);
        }
        int D_edge_number = this.d_edges.size() / 2;
        for (int a = 0; a < D_edge_number; ++a) {
            if (this.d_edges.get(a * 2 + 0) == central_node) {
                neighbor_vec.add(this.d_edges.get(a * 2 + 1));
                neighbor_vec.add(2);
            }
            if (this.d_edges.get(a * 2 + 1) != central_node) continue;
            neighbor_vec.add(this.d_edges.get(a * 2 + 0));
            neighbor_vec.add(2);
        }
        return neighbor_vec;
    }

    public Stack<List<Integer>> getMax_Cliques_Set() {
        return this.max_Cliques_Set;
    }
}

