/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus1;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.mcsplus1.MoleculeHandler;
import org.openscience.smsd.graph.Edge;
import org.openscience.smsd.tools.Utility;

public class CompatibilityGraph {
    private final AtomMatcher atomMatcher;
    private final BondMatcher bondMatcher;
    private final List<Edge> global_c_edges = new ArrayList<Edge>();
    private final List<Edge> global_d_edges = new ArrayList<Edge>();
    private final List<Integer> comp_graph_nodes;
    private final List<Integer> comp_graph_nodes_C_zero;
    private final int atom_num_H_1;
    private final int atom_num_H_2;
    private final int bond_number1;
    private final int bond_number2;
    private final Map<String, Integer> SYMBOL_VALUE;
    private final List<Integer> i_tab1;
    private final List<Integer> i_tab2;
    private final List<String> c_tab1;
    private final List<String> c_tab2;
    private final IAtomContainer ac1;
    private final IAtomContainer ac2;
    private final List<IAtom> atomstr1;
    private final List<IAtom> atomstr2;
    private final boolean DEBUG = false;

    public List<Edge> getCEdges() {
        return this.global_c_edges;
    }

    public List<Edge> getDEdges() {
        return this.global_d_edges;
    }

    public List<Integer> getCompGraphNodes() {
        return this.comp_graph_nodes;
    }

    public CompatibilityGraph(IAtomContainer f1, IAtomContainer f2, AtomMatcher am, BondMatcher bm) {
        this.atomMatcher = am;
        this.bondMatcher = bm;
        this.SYMBOL_VALUE = new TreeMap<String, Integer>();
        MoleculeHandler file1 = new MoleculeHandler(f1, false);
        MoleculeHandler file2 = new MoleculeHandler(f2, false);
        this.atom_num_H_1 = file1.getStartHatom_num();
        this.atom_num_H_2 = file2.getStartHatom_num();
        this.bond_number1 = file1.getBondNumber();
        this.bond_number2 = file2.getBondNumber();
        this.atomstr1 = file1.getAtomString();
        this.atomstr2 = file2.getAtomString();
        this.i_tab1 = file1.intTable;
        this.i_tab2 = file2.intTable;
        this.c_tab1 = file1.charTable;
        this.c_tab2 = file2.charTable;
        this.ac1 = file1.getAtomContainer();
        this.ac2 = file2.getAtomContainer();
        this.comp_graph_nodes = new ArrayList<Integer>();
        this.comp_graph_nodes_C_zero = new ArrayList<Integer>();
    }

    public int searchCliques() {
        this.generate_compatibility_graph_nodes();
        this.generate_compatibility_graph();
        if (this.getCEdges().isEmpty()) {
            this.getCompGraphNodes().clear();
            this.getCEdges().clear();
            this.getDEdges().clear();
            this.generate_compatibility_graph_nodes_if_C_edge_number_is_zero();
            this.generate_compatibility_graph_if_C_edge_number_is_zero();
            this.comp_graph_nodes_C_zero.clear();
        }
        ArrayList<Edge> unique_global_c_edges = new ArrayList<Edge>(new HashSet<Edge>(this.getCEdges()));
        ArrayList<Edge> unique_global_d_edges = new ArrayList<Edge>(new HashSet<Edge>(this.getDEdges()));
        return this.getCompGraphNodes().size();
    }

    private List<List<Integer>> label_atoms(List<Integer> basic_atom_vector, int bond_num, List<IAtom> atoms, List<Integer> i_tab, List<String> c_tab) {
        ArrayList<List<Integer>> label_list = new ArrayList<List<Integer>>();
        for (int a = 0; a < basic_atom_vector.size(); ++a) {
            ArrayList<Integer> label = new ArrayList<Integer>(7);
            for (int i = 0; i < 7; ++i) {
                label.add(0);
            }
            IAtom atom1 = atoms.get(a);
            String atom1_type = atom1.getSymbol();
            if (this.SYMBOL_VALUE.containsKey(atom1_type)) {
                label.set(0, this.SYMBOL_VALUE.get(atom1_type));
            } else {
                int value = atom1.getAtomicNumber() == null ? atom1.hashCode() + 1000 : atom1.getAtomicNumber() + 1000;
                this.SYMBOL_VALUE.put(atom1_type, value);
                label.set(0, this.SYMBOL_VALUE.get(atom1_type));
            }
            int count_neighbors = 1;
            for (int b = 0; b < bond_num; ++b) {
                int value;
                String atom2_type;
                IAtom atom2;
                if (basic_atom_vector.get(a).equals(i_tab.get(b * 3 + 0))) {
                    atom2 = atoms.get(i_tab.get(b * 3 + 1) - 1);
                    atom2_type = c_tab.get(b * 2 + 1);
                    if (this.SYMBOL_VALUE.containsKey(atom2_type)) {
                        label.set(count_neighbors, this.SYMBOL_VALUE.get(atom2_type));
                    } else {
                        value = atom2.getAtomicNumber() == null ? atom2.hashCode() + 1000 : atom2.getAtomicNumber() + 1000;
                        this.SYMBOL_VALUE.put(atom2_type, value);
                        label.set(count_neighbors, this.SYMBOL_VALUE.get(atom2_type));
                    }
                    ++count_neighbors;
                }
                if (!basic_atom_vector.get(a).equals(i_tab.get(b * 3 + 1))) continue;
                atom2 = atoms.get(i_tab.get(b * 3 + 0) - 1);
                atom2_type = c_tab.get(b * 2 + 0);
                if (this.SYMBOL_VALUE.containsKey(atom2_type)) {
                    label.set(count_neighbors, this.SYMBOL_VALUE.get(atom2_type));
                } else {
                    value = atom2.getAtomicNumber() == null ? atom2.hashCode() + 1000 : atom2.getAtomicNumber() + 1000;
                    this.SYMBOL_VALUE.put(atom2_type, value);
                    label.set(count_neighbors, this.SYMBOL_VALUE.get(atom2_type));
                }
                ++count_neighbors;
            }
            List<Integer> bubbleSort = Utility.getBubbleSort(label);
            label_list.add(bubbleSort);
        }
        return label_list;
    }

    private List<Integer> reduce_atomset(int atom_num, int bond_numb, List<IAtom> a_str, List<Integer> i_table, List<String> c_table) {
        ArrayList<Integer> phosphate_O_atoms = new ArrayList<Integer>();
        ArrayList<Integer> h_atoms = new ArrayList<Integer>();
        for (int a = 0; a < atom_num; ++a) {
            if ("O".equals(a_str.get(a).getSymbol())) {
                int O_neighbor_num = 0;
                boolean P_neighbor = false;
                for (int b = 0; b < bond_numb; ++b) {
                    if (a + 1 == i_table.get(b * 3 + 0)) {
                        ++O_neighbor_num;
                        if ("P".equals(a_str.get(i_table.get(b * 3 + 1) - 1).getSymbol()) && i_table.get(b * 3 + 2) != 2) {
                            P_neighbor = true;
                        }
                    }
                    if (a + 1 != i_table.get(b * 3 + 1)) continue;
                    ++O_neighbor_num;
                    if (!"P".equals(a_str.get(i_table.get(b * 3 + 0) - 1).getSymbol()) || i_table.get(b * 3 + 2) == 2) continue;
                    P_neighbor = true;
                }
                if (O_neighbor_num == 1 && P_neighbor) {
                    phosphate_O_atoms.add(a + 1);
                }
            }
            if (!"H".equals(a_str.get(a).getSymbol())) continue;
            h_atoms.add(a + 1);
        }
        ArrayList<Integer> basic_atoms = new ArrayList<Integer>();
        int phosphate_O_atoms_size = phosphate_O_atoms.size();
        int H_atoms_size = h_atoms.size();
        for (int a = 0; a < atom_num; ++a) {
            boolean no_P_O_atom = true;
            for (int b = 0; b < phosphate_O_atoms_size; ++b) {
                if (a + 1 != (Integer)phosphate_O_atoms.get(b)) continue;
                no_P_O_atom = false;
            }
            boolean no_H_atom = true;
            for (int b = 0; b < H_atoms_size; ++b) {
                if (a + 1 != (Integer)h_atoms.get(b)) continue;
                no_H_atom = false;
            }
            if (!no_P_O_atom || !no_H_atom) continue;
            basic_atoms.add(a + 1);
        }
        return basic_atoms;
    }

    private int generate_compatibility_graph_nodes() {
        List<Integer> basic_atom_vec_A = this.reduce_atomset(this.atom_num_H_1, this.bond_number1, this.atomstr1, this.i_tab1, this.c_tab1);
        List<Integer> basic_atom_vec_B = this.reduce_atomset(this.atom_num_H_2, this.bond_number2, this.atomstr2, this.i_tab2, this.c_tab2);
        List<List<Integer>> label_list_molA = this.label_atoms(basic_atom_vec_A, this.bond_number1, this.atomstr1, this.i_tab1, this.c_tab1);
        List<List<Integer>> label_list_molB = this.label_atoms(basic_atom_vec_B, this.bond_number2, this.atomstr2, this.i_tab2, this.c_tab2);
        int molA_nodes = 0;
        int count_nodes = 1;
        for (List<Integer> labelA : label_list_molA) {
            int molB_nodes = 0;
            for (List<Integer> labelB : label_list_molB) {
                if (labelA.equals(labelB)) {
                    this.getCompGraphNodes().add(basic_atom_vec_A.get(molA_nodes));
                    this.getCompGraphNodes().add(basic_atom_vec_B.get(molB_nodes));
                    this.getCompGraphNodes().add(count_nodes++);
                }
                ++molB_nodes;
            }
            ++molA_nodes;
        }
        return 0;
    }

    private int generate_compatibility_graph() {
        int vector_size = this.getCompGraphNodes().size();
        for (int a = 0; a < vector_size; a += 3) {
            for (int b = a + 3; b < vector_size; b += 3) {
                Edge edge;
                IAtom a2;
                IAtom a1;
                if (a == b || this.comp_graph_nodes.get(a).equals(this.comp_graph_nodes.get(b)) || this.comp_graph_nodes.get(a + 1).equals(this.comp_graph_nodes.get(b + 1))) continue;
                boolean molecule1_pair_connected = false;
                boolean molecule2_pair_connected = false;
                IBond bond1 = null;
                IBond bond2 = null;
                for (int x = 0; x < this.bond_number1; ++x) {
                    if (this.getCompGraphNodes().get(a).equals(this.i_tab1.get(x * 3 + 0)) && this.getCompGraphNodes().get(b).equals(this.i_tab1.get(x * 3 + 1))) {
                        a1 = this.ac1.getAtom(this.getCompGraphNodes().get(a) - 1);
                        a2 = this.ac1.getAtom(this.getCompGraphNodes().get(b) - 1);
                        bond1 = this.ac1.getBond(a1, a2);
                        molecule1_pair_connected = true;
                        if (bond1 == null) continue;
                        break;
                    }
                    if (!this.getCompGraphNodes().get(a).equals(this.i_tab1.get(x * 3 + 1)) || !this.getCompGraphNodes().get(b).equals(this.i_tab1.get(x * 3 + 0))) continue;
                    a1 = this.ac1.getAtom(this.getCompGraphNodes().get(a) - 1);
                    a2 = this.ac1.getAtom(this.getCompGraphNodes().get(b) - 1);
                    bond1 = this.ac1.getBond(a1, a2);
                    molecule1_pair_connected = true;
                    if (bond1 != null) break;
                }
                for (int y = 0; y < this.bond_number2; ++y) {
                    if (this.getCompGraphNodes().get(a + 1).equals(this.i_tab2.get(y * 3 + 0)) && this.getCompGraphNodes().get(b + 1).equals(this.i_tab2.get(y * 3 + 1))) {
                        a1 = this.ac2.getAtom(this.getCompGraphNodes().get(a + 1) - 1);
                        a2 = this.ac2.getAtom(this.getCompGraphNodes().get(b + 1) - 1);
                        bond2 = this.ac2.getBond(a1, a2);
                        molecule2_pair_connected = true;
                        if (bond2 == null) continue;
                        break;
                    }
                    if (!this.getCompGraphNodes().get(a + 1).equals(this.i_tab2.get(y * 3 + 1)) || !this.getCompGraphNodes().get(b + 1).equals(this.i_tab2.get(y * 3 + 0))) continue;
                    a1 = this.ac2.getAtom(this.getCompGraphNodes().get(a + 1) - 1);
                    a2 = this.ac2.getAtom(this.getCompGraphNodes().get(b + 1) - 1);
                    bond2 = this.ac2.getBond(a1, a2);
                    molecule2_pair_connected = true;
                    if (bond2 != null) break;
                }
                boolean connectedFlag = false;
                boolean disConnectedFlag = false;
                boolean matchBondFlag = false;
                if (molecule1_pair_connected && molecule2_pair_connected) {
                    connectedFlag = true;
                }
                if (!molecule1_pair_connected && !molecule2_pair_connected) {
                    disConnectedFlag = true;
                }
                if (connectedFlag && AtomBondMatcher.matchAtomAndBond(bond1, bond2, this.atomMatcher, this.bondMatcher, true)) {
                    matchBondFlag = true;
                }
                if (connectedFlag && matchBondFlag) {
                    edge = new Edge(a / 3 + 1, b / 3 + 1);
                    this.getCEdges().add(edge);
                }
                if (!disConnectedFlag) continue;
                edge = new Edge(a / 3 + 1, b / 3 + 1);
                this.getDEdges().add(edge);
            }
        }
        return 0;
    }

    private int generate_compatibility_graph_nodes_if_C_edge_number_is_zero() {
        int count_nodes = 1;
        for (int a = 0; a < this.atom_num_H_1; ++a) {
            String atom1_type = this.atomstr1.get(a).getSymbol();
            int value = this.atomstr1.get(a).getAtomicNumber() == null ? this.atomstr1.get(a).hashCode() + 1000 : this.atomstr1.get(a).getAtomicNumber() + 1000;
            this.SYMBOL_VALUE.put(atom1_type, value);
            for (int b = 0; b < this.atom_num_H_2; ++b) {
                String atom2_type = this.atomstr2.get(b).getSymbol();
                if (!atom1_type.equals(atom2_type)) continue;
                this.comp_graph_nodes_C_zero.add(a + 1);
                this.comp_graph_nodes_C_zero.add(b + 1);
                this.comp_graph_nodes_C_zero.add(this.SYMBOL_VALUE.get(atom1_type));
                this.comp_graph_nodes_C_zero.add(count_nodes);
                this.getCompGraphNodes().add(a + 1);
                this.getCompGraphNodes().add(b + 1);
                this.getCompGraphNodes().add(count_nodes);
                ++count_nodes;
            }
        }
        return 0;
    }

    private int generate_compatibility_graph_if_C_edge_number_is_zero() {
        int vector_size = this.comp_graph_nodes_C_zero.size();
        for (int a = 0; a < vector_size; a += 4) {
            for (int b = a; b < vector_size; b += 4) {
                Edge edge;
                IAtom a2;
                IAtom a1;
                if (a == b || this.comp_graph_nodes_C_zero.get(a).equals(this.comp_graph_nodes_C_zero.get(b)) || this.comp_graph_nodes_C_zero.get(a + 1).equals(this.comp_graph_nodes_C_zero.get(b + 1))) continue;
                boolean molecule1_pair_connected = false;
                boolean molecule2_pair_connected = false;
                IBond bond1 = null;
                IBond bond2 = null;
                for (int x = 0; x < this.bond_number1; ++x) {
                    if (this.comp_graph_nodes_C_zero.get(a).equals(this.i_tab1.get(x * 3 + 0)) && this.comp_graph_nodes_C_zero.get(b).equals(this.i_tab1.get(x * 3 + 1))) {
                        molecule1_pair_connected = true;
                        a1 = this.ac1.getAtom(this.comp_graph_nodes_C_zero.get(a) - 1);
                        a2 = this.ac1.getAtom(this.comp_graph_nodes_C_zero.get(b) - 1);
                        bond1 = this.ac1.getBond(a1, a2);
                        break;
                    }
                    if (!this.comp_graph_nodes_C_zero.get(a).equals(this.i_tab1.get(x * 3 + 1)) || !this.comp_graph_nodes_C_zero.get(b).equals(this.i_tab1.get(x * 3 + 0))) continue;
                    molecule1_pair_connected = true;
                    IAtom a12 = this.ac1.getAtom(this.comp_graph_nodes_C_zero.get(a) - 1);
                    IAtom a22 = this.ac1.getAtom(this.comp_graph_nodes_C_zero.get(b) - 1);
                    bond1 = this.ac1.getBond(a12, a22);
                    break;
                }
                for (int y = 0; y < this.bond_number2; ++y) {
                    if (this.comp_graph_nodes_C_zero.get(a + 1).equals(this.i_tab2.get(y * 3 + 0)) && this.comp_graph_nodes_C_zero.get(b + 1).equals(this.i_tab2.get(y * 3 + 1))) {
                        molecule2_pair_connected = true;
                        a1 = this.ac2.getAtom(this.comp_graph_nodes_C_zero.get(a + 1) - 1);
                        a2 = this.ac2.getAtom(this.comp_graph_nodes_C_zero.get(b + 1) - 1);
                        bond2 = this.ac2.getBond(a1, a2);
                        break;
                    }
                    if (!this.comp_graph_nodes_C_zero.get(a + 1).equals(this.i_tab2.get(y * 3 + 1)) || !this.comp_graph_nodes_C_zero.get(b + 1).equals(this.i_tab2.get(y * 3 + 0))) continue;
                    molecule2_pair_connected = true;
                    a1 = this.ac2.getAtom(this.comp_graph_nodes_C_zero.get(a + 1) - 1);
                    a2 = this.ac2.getAtom(this.comp_graph_nodes_C_zero.get(b + 1) - 1);
                    bond2 = this.ac2.getBond(a1, a2);
                    break;
                }
                boolean connectedFlag = false;
                boolean disConnectedFlag = false;
                boolean matchBondFlag = false;
                if (molecule1_pair_connected && molecule2_pair_connected) {
                    connectedFlag = true;
                }
                if (!molecule1_pair_connected && !molecule2_pair_connected) {
                    disConnectedFlag = true;
                }
                if (connectedFlag && AtomBondMatcher.matchAtomAndBond(bond1, bond2, this.atomMatcher, this.bondMatcher, true)) {
                    matchBondFlag = true;
                }
                if (connectedFlag && matchBondFlag) {
                    edge = new Edge(a / 4 + 1, b / 4 + 1);
                    this.getCEdges().add(edge);
                }
                if (!disConnectedFlag) continue;
                edge = new Edge(a / 4 + 1, b / 4 + 1);
                this.getDEdges().add(edge);
            }
        }
        return 0;
    }

    public void clear() {
        this.getCompGraphNodes().clear();
        this.comp_graph_nodes_C_zero.clear();
        this.c_tab1.clear();
        this.c_tab2.clear();
        this.getCEdges().clear();
        this.getDEdges().clear();
    }
}

