/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus1;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.mcsplus1.McGregor;

public class Filter
extends McGregor {
    public Filter(IAtomContainer f1, IAtomContainer f2, AtomMatcher am, BondMatcher bm) {
        super(f1, f2, am, bm);
    }

    /*
     * WARNING - void declaration
     */
    int postfilter() {
        int b;
        int c;
        if (this.best_MAPPING_size == 0 && this.best_clique_size != 0) {
            Iterator<List<Integer>> iter = this.getFinalMappings().iterator();
            List<Integer> vec = iter.next();
            this.best_MAPPING_size = vec.size() / 2;
        }
        if (this.best_MAPPING_size == 0 && this.best_clique_size == 0) {
            return 0;
        }
        ArrayList<Integer> C_index_A = new ArrayList<Integer>();
        ArrayList carb_vec_A = new ArrayList();
        for (int a = 0; a < this.atom_num_H_1; ++a) {
            if (!"C".equals(((IAtom)this.atomstr1.get(a)).getSymbol())) continue;
            int O_num = 0;
            ArrayList<Integer> carboxy_C_vec = new ArrayList<Integer>();
            boolean c_group = true;
            for (int b2 = 0; b2 < this.bond_number1; ++b2) {
                if (a + 1 == (Integer)this.i_tab1.get(b2 * 3 + 0) && "O".equals(this.c_tab1.get(b2 * 2 + 1))) {
                    if (this.check((Integer)this.i_tab1.get(b2 * 3 + 1), 1)) {
                        carboxy_C_vec.add((Integer)this.i_tab1.get(b2 * 3 + 1));
                        carboxy_C_vec.add((Integer)this.i_tab1.get(b2 * 3 + 2));
                        ++O_num;
                    } else {
                        c_group = false;
                    }
                }
                if (a + 1 != (Integer)this.i_tab1.get(b2 * 3 + 1) || !"O".equals(this.c_tab1.get(b2 * 2 + 0))) continue;
                if (this.check((Integer)this.i_tab1.get(b2 * 3 + 0), 1)) {
                    carboxy_C_vec.add((Integer)this.i_tab1.get(b2 * 3 + 0));
                    carboxy_C_vec.add((Integer)this.i_tab1.get(b2 * 3 + 2));
                    ++O_num;
                    continue;
                }
                c_group = false;
            }
            if (O_num != 2 || !c_group) continue;
            ArrayList<Integer> temp_vec = new ArrayList<Integer>();
            if ((Integer)carboxy_C_vec.get(1) != 2) {
                temp_vec.add((Integer)carboxy_C_vec.get(2));
                temp_vec.add((Integer)carboxy_C_vec.get(3));
                temp_vec.add((Integer)carboxy_C_vec.get(0));
                temp_vec.add((Integer)carboxy_C_vec.get(1));
            } else {
                temp_vec = carboxy_C_vec;
            }
            C_index_A.add(a + 1);
            carb_vec_A.add(temp_vec);
        }
        int C_index_A_size = C_index_A.size();
        ArrayList<Integer> C_index_B = new ArrayList<Integer>();
        ArrayList carb_vec_B = new ArrayList();
        for (int a = 0; a < this.atom_num_H_2; ++a) {
            if (!"C".equals(((IAtom)this.atomstr2.get(a)).getSymbol())) continue;
            int O_num = 0;
            ArrayList<Integer> carboxy_C_vec = new ArrayList<Integer>();
            boolean c_group = true;
            for (int b3 = 0; b3 < this.bond_number2; ++b3) {
                if (a + 1 == (Integer)this.i_tab2.get(b3 * 3 + 0) && "O".equals(this.c_tab2.get(b3 * 2 + 1))) {
                    if (this.check((Integer)this.i_tab2.get(b3 * 3 + 1), 2)) {
                        carboxy_C_vec.add((Integer)this.i_tab2.get(b3 * 3 + 1));
                        carboxy_C_vec.add((Integer)this.i_tab2.get(b3 * 3 + 2));
                        ++O_num;
                    } else {
                        c_group = false;
                    }
                }
                if (a + 1 != (Integer)this.i_tab2.get(b3 * 3 + 1) || !"O".equals(this.c_tab2.get(b3 * 2 + 0))) continue;
                if (this.check((Integer)this.i_tab2.get(b3 * 3 + 0), 2)) {
                    carboxy_C_vec.add((Integer)this.i_tab2.get(b3 * 3 + 0));
                    carboxy_C_vec.add((Integer)this.i_tab2.get(b3 * 3 + 2));
                    ++O_num;
                    continue;
                }
                c_group = false;
            }
            if (O_num != 2 || !c_group) continue;
            ArrayList<Integer> temp_vec = new ArrayList<Integer>();
            if ((Integer)carboxy_C_vec.get(1) != 2) {
                temp_vec.add((Integer)carboxy_C_vec.get(2));
                temp_vec.add((Integer)carboxy_C_vec.get(3));
                temp_vec.add((Integer)carboxy_C_vec.get(0));
                temp_vec.add((Integer)carboxy_C_vec.get(1));
            } else {
                temp_vec = carboxy_C_vec;
            }
            C_index_B.add(a + 1);
            carb_vec_B.add(temp_vec);
        }
        int C_index_B_size = C_index_B.size();
        ArrayList<List<Integer>> carboxy_final_MAPPINGS = new ArrayList<List<Integer>>();
        boolean carboxy_groups_in_both = true;
        if (C_index_A_size == 0 || C_index_B_size == 0) {
            carboxy_groups_in_both = false;
            carboxy_final_MAPPINGS.addAll(this.getFinalMappings());
        }
        if (carboxy_groups_in_both) {
            this.getFinalMappings().stream().forEach(final_solution -> {
                boolean map_correct = true;
                for (int a = 0; a < this.best_MAPPING_size && map_correct; ++a) {
                    boolean not_found = true;
                    for (int b = 0; b < C_index_A_size && not_found; ++b) {
                        if (((Integer)final_solution.get(a * 2 + 0)).intValue() != ((Integer)C_index_A.get(b)).intValue()) continue;
                        not_found = false;
                        List vector_A = (List)carb_vec_A.get(b);
                        int first_A = (Integer)vector_A.get(0);
                        int secon_A = (Integer)vector_A.get(2);
                        int first_B = 0;
                        int secon_B = 0;
                        boolean mapped_on_a_carboxy_group = false;
                        for (int c = 0; c < C_index_B_size; ++c) {
                            if (((Integer)final_solution.get(a * 2 + 1)).intValue() != ((Integer)C_index_B.get(c)).intValue()) continue;
                            List vector_B = (List)carb_vec_B.get(c);
                            first_B = (Integer)vector_B.get(0);
                            secon_B = (Integer)vector_B.get(2);
                            mapped_on_a_carboxy_group = true;
                        }
                        if (!mapped_on_a_carboxy_group) continue;
                        boolean miss_map = true;
                        for (int c = 0; c < this.best_MAPPING_size; ++c) {
                            if ((Integer)final_solution.get(c * 2 + 0) != first_A || (Integer)final_solution.get(c * 2 + 1) != first_B) continue;
                            miss_map = false;
                        }
                        if (!miss_map) continue;
                        map_correct = false;
                    }
                }
                if (map_correct) {
                    carboxy_final_MAPPINGS.add((List<Integer>)final_solution);
                }
            });
        }
        ArrayList<Integer> P_index_A = new ArrayList<Integer>();
        ArrayList phos_vec_A = new ArrayList();
        for (int a = 0; a < this.atom_num_H_1; ++a) {
            ArrayList<Integer> temp_vec;
            boolean no_double;
            if (!"P".equals(((IAtom)this.atomstr1.get(a)).getSymbol())) continue;
            int P_num = 0;
            ArrayList<Integer> phos_P_vec = new ArrayList<Integer>();
            for (int b4 = 0; b4 < this.bond_number1; ++b4) {
                if (a + 1 == (Integer)this.i_tab1.get(b4 * 3 + 0) && "O".equals(this.c_tab1.get(b4 * 2 + 1)) && this.check((Integer)this.i_tab1.get(b4 * 3 + 1), 1)) {
                    phos_P_vec.add((Integer)this.i_tab1.get(b4 * 3 + 1));
                    phos_P_vec.add((Integer)this.i_tab1.get(b4 * 3 + 2));
                    ++P_num;
                }
                if (a + 1 != (Integer)this.i_tab1.get(b4 * 3 + 1) || !"O".equals(this.c_tab1.get(b4 * 2 + 0)) || !this.check((Integer)this.i_tab1.get(b4 * 3 + 0), 1)) continue;
                phos_P_vec.add((Integer)this.i_tab1.get(b4 * 3 + 0));
                phos_P_vec.add((Integer)this.i_tab1.get(b4 * 3 + 2));
                ++P_num;
            }
            if (P_num == 1) {
                ArrayList<Integer> temp_vec2 = new ArrayList<Integer>();
                temp_vec2.add((Integer)phos_P_vec.get(0));
                temp_vec2.add((Integer)phos_P_vec.get(1));
                P_index_A.add(a + 1);
                phos_vec_A.add(temp_vec2);
            }
            if (P_num == 2) {
                ArrayList<Integer> temp_vec3 = new ArrayList<Integer>();
                if ((Integer)phos_P_vec.get(1) != 2) {
                    temp_vec3.add((Integer)phos_P_vec.get(2));
                    temp_vec3.add((Integer)phos_P_vec.get(3));
                    temp_vec3.add((Integer)phos_P_vec.get(0));
                    temp_vec3.add((Integer)phos_P_vec.get(1));
                } else {
                    temp_vec3 = phos_P_vec;
                }
                P_index_A.add(a + 1);
                phos_vec_A.add(temp_vec3);
            }
            if (P_num == 3) {
                no_double = true;
                temp_vec = new ArrayList<Integer>();
                if ((Integer)phos_P_vec.get(1) == 2) {
                    temp_vec = phos_P_vec;
                    no_double = false;
                }
                if ((Integer)phos_P_vec.get(3) == 2) {
                    temp_vec.add((Integer)phos_P_vec.get(2));
                    temp_vec.add((Integer)phos_P_vec.get(3));
                    temp_vec.add((Integer)phos_P_vec.get(0));
                    temp_vec.add((Integer)phos_P_vec.get(1));
                    temp_vec.add((Integer)phos_P_vec.get(4));
                    temp_vec.add((Integer)phos_P_vec.get(5));
                    no_double = false;
                }
                if ((Integer)phos_P_vec.get(5) == 2) {
                    temp_vec.add((Integer)phos_P_vec.get(4));
                    temp_vec.add((Integer)phos_P_vec.get(5));
                    temp_vec.add((Integer)phos_P_vec.get(0));
                    temp_vec.add((Integer)phos_P_vec.get(1));
                    temp_vec.add((Integer)phos_P_vec.get(2));
                    temp_vec.add((Integer)phos_P_vec.get(3));
                    no_double = false;
                }
                if (no_double) {
                    temp_vec = phos_P_vec;
                }
                P_index_A.add(a + 1);
                phos_vec_A.add(temp_vec);
            }
            if (P_num != 4) continue;
            no_double = true;
            temp_vec = new ArrayList();
            if ((Integer)phos_P_vec.get(1) == 2) {
                temp_vec = phos_P_vec;
                no_double = false;
            }
            if ((Integer)phos_P_vec.get(3) == 2) {
                temp_vec.add((Integer)phos_P_vec.get(2));
                temp_vec.add((Integer)phos_P_vec.get(3));
                temp_vec.add((Integer)phos_P_vec.get(0));
                temp_vec.add((Integer)phos_P_vec.get(1));
                temp_vec.add((Integer)phos_P_vec.get(4));
                temp_vec.add((Integer)phos_P_vec.get(5));
                temp_vec.add((Integer)phos_P_vec.get(6));
                temp_vec.add((Integer)phos_P_vec.get(7));
                no_double = false;
            }
            if ((Integer)phos_P_vec.get(5) == 2) {
                temp_vec.add((Integer)phos_P_vec.get(4));
                temp_vec.add((Integer)phos_P_vec.get(5));
                temp_vec.add((Integer)phos_P_vec.get(0));
                temp_vec.add((Integer)phos_P_vec.get(1));
                temp_vec.add((Integer)phos_P_vec.get(2));
                temp_vec.add((Integer)phos_P_vec.get(3));
                temp_vec.add((Integer)phos_P_vec.get(6));
                temp_vec.add((Integer)phos_P_vec.get(7));
                no_double = false;
            }
            if ((Integer)phos_P_vec.get(7) == 2) {
                temp_vec.add((Integer)phos_P_vec.get(6));
                temp_vec.add((Integer)phos_P_vec.get(7));
                temp_vec.add((Integer)phos_P_vec.get(0));
                temp_vec.add((Integer)phos_P_vec.get(1));
                temp_vec.add((Integer)phos_P_vec.get(2));
                temp_vec.add((Integer)phos_P_vec.get(3));
                temp_vec.add((Integer)phos_P_vec.get(4));
                temp_vec.add((Integer)phos_P_vec.get(5));
                no_double = false;
            }
            if (no_double) {
                temp_vec = phos_P_vec;
            }
            P_index_A.add(a + 1);
            phos_vec_A.add(temp_vec);
        }
        int P_index_A_size = P_index_A.size();
        ArrayList<Integer> P_index_B = new ArrayList<Integer>();
        ArrayList<Object> phos_vec_B = new ArrayList<Object>();
        for (int a = 0; a < this.atom_num_H_2; ++a) {
            void var18_46;
            void var18_44;
            boolean no_double;
            if (!"P".equals(((IAtom)this.atomstr2.get(a)).getSymbol())) continue;
            int P_num = 0;
            ArrayList<Integer> phos_P_vec = new ArrayList<Integer>();
            for (int b5 = 0; b5 < this.bond_number2; ++b5) {
                if (a + 1 == (Integer)this.i_tab2.get(b5 * 3 + 0) && "O".equals(this.c_tab2.get(b5 * 2 + 1)) && this.check((Integer)this.i_tab2.get(b5 * 3 + 1), 2)) {
                    phos_P_vec.add((Integer)this.i_tab2.get(b5 * 3 + 1));
                    phos_P_vec.add((Integer)this.i_tab2.get(b5 * 3 + 2));
                    ++P_num;
                }
                if (a + 1 != (Integer)this.i_tab2.get(b5 * 3 + 1) || !"O".equals(this.c_tab2.get(b5 * 2 + 0)) || !this.check((Integer)this.i_tab2.get(b5 * 3 + 0), 2)) continue;
                phos_P_vec.add((Integer)this.i_tab2.get(b5 * 3 + 0));
                phos_P_vec.add((Integer)this.i_tab2.get(b5 * 3 + 2));
                ++P_num;
            }
            if (P_num == 1) {
                ArrayList<Integer> temp_vec4 = new ArrayList<Integer>();
                temp_vec4.add((Integer)phos_P_vec.get(0));
                temp_vec4.add((Integer)phos_P_vec.get(1));
                P_index_B.add(a + 1);
                phos_vec_B.add(temp_vec4);
            }
            if (P_num == 2) {
                ArrayList<Integer> temp_vec5 = new ArrayList<Integer>();
                if ((Integer)phos_P_vec.get(1) != 2) {
                    temp_vec5.add((Integer)phos_P_vec.get(2));
                    temp_vec5.add((Integer)phos_P_vec.get(3));
                    temp_vec5.add((Integer)phos_P_vec.get(0));
                    temp_vec5.add((Integer)phos_P_vec.get(1));
                } else {
                    temp_vec5 = phos_P_vec;
                }
                P_index_B.add(a + 1);
                phos_vec_B.add(temp_vec5);
            }
            if (P_num == 3) {
                void var18_41;
                void var18_39;
                no_double = true;
                ArrayList arrayList = new ArrayList();
                if ((Integer)phos_P_vec.get(1) == 2) {
                    ArrayList<Integer> arrayList2 = phos_P_vec;
                    no_double = false;
                }
                if ((Integer)phos_P_vec.get(3) == 2) {
                    var18_39.add((Integer)phos_P_vec.get(2));
                    var18_39.add((Integer)phos_P_vec.get(3));
                    var18_39.add((Integer)phos_P_vec.get(0));
                    var18_39.add((Integer)phos_P_vec.get(1));
                    var18_39.add((Integer)phos_P_vec.get(4));
                    var18_39.add((Integer)phos_P_vec.get(5));
                    no_double = false;
                }
                if ((Integer)phos_P_vec.get(5) == 2) {
                    var18_39.add((Integer)phos_P_vec.get(4));
                    var18_39.add((Integer)phos_P_vec.get(5));
                    var18_39.add((Integer)phos_P_vec.get(0));
                    var18_39.add((Integer)phos_P_vec.get(1));
                    var18_39.add((Integer)phos_P_vec.get(2));
                    var18_39.add((Integer)phos_P_vec.get(3));
                    no_double = false;
                }
                if (no_double) {
                    ArrayList<Integer> arrayList3 = phos_P_vec;
                }
                P_index_B.add(a + 1);
                phos_vec_B.add(var18_41);
            }
            if (P_num != 4) continue;
            no_double = true;
            ArrayList arrayList = new ArrayList();
            if ((Integer)phos_P_vec.get(1) == 2) {
                ArrayList<Integer> arrayList4 = phos_P_vec;
            }
            if ((Integer)phos_P_vec.get(3) == 2) {
                var18_44.add((Integer)phos_P_vec.get(2));
                var18_44.add((Integer)phos_P_vec.get(3));
                var18_44.add((Integer)phos_P_vec.get(0));
                var18_44.add((Integer)phos_P_vec.get(1));
                var18_44.add((Integer)phos_P_vec.get(4));
                var18_44.add((Integer)phos_P_vec.get(5));
                var18_44.add((Integer)phos_P_vec.get(6));
                var18_44.add((Integer)phos_P_vec.get(7));
                no_double = false;
            }
            if ((Integer)phos_P_vec.get(5) == 2) {
                var18_44.add((Integer)phos_P_vec.get(4));
                var18_44.add((Integer)phos_P_vec.get(5));
                var18_44.add((Integer)phos_P_vec.get(0));
                var18_44.add((Integer)phos_P_vec.get(1));
                var18_44.add((Integer)phos_P_vec.get(2));
                var18_44.add((Integer)phos_P_vec.get(3));
                var18_44.add((Integer)phos_P_vec.get(6));
                var18_44.add((Integer)phos_P_vec.get(7));
                no_double = false;
            }
            if ((Integer)phos_P_vec.get(7) == 2) {
                var18_44.add((Integer)phos_P_vec.get(6));
                var18_44.add((Integer)phos_P_vec.get(7));
                var18_44.add((Integer)phos_P_vec.get(0));
                var18_44.add((Integer)phos_P_vec.get(1));
                var18_44.add((Integer)phos_P_vec.get(2));
                var18_44.add((Integer)phos_P_vec.get(3));
                var18_44.add((Integer)phos_P_vec.get(4));
                var18_44.add((Integer)phos_P_vec.get(5));
                no_double = false;
            }
            if (no_double) {
                ArrayList<Integer> arrayList5 = phos_P_vec;
            }
            P_index_B.add(a + 1);
            phos_vec_B.add(var18_46);
        }
        int P_index_B_size = P_index_B.size();
        ArrayList<List> phosphate_final_MAPPINGS = new ArrayList<List>();
        boolean phosphate_groups_in_both = true;
        if (P_index_A_size == 0 || P_index_B_size == 0) {
            phosphate_groups_in_both = false;
            phosphate_final_MAPPINGS = carboxy_final_MAPPINGS;
        }
        if (phosphate_groups_in_both) {
            for (List list : carboxy_final_MAPPINGS) {
                boolean map_correct = true;
                for (int a = 0; a < this.best_MAPPING_size && map_correct; ++a) {
                    boolean not_found = true;
                    for (int b6 = 0; b6 < P_index_A_size && not_found; ++b6) {
                        if (!((Integer)list.get(a * 2 + 0)).equals(P_index_A.get(b6))) continue;
                        not_found = false;
                        List vector_A = (List)phos_vec_A.get(b6);
                        int first_A = (Integer)vector_A.get(0);
                        int first_B = 0;
                        boolean mapped_on_a_phos_group = false;
                        for (int c2 = 0; c2 < P_index_B_size; ++c2) {
                            if (!((Integer)list.get(a * 2 + 1)).equals(P_index_B.get(c2))) continue;
                            List vector_B = (List)phos_vec_B.get(c2);
                            first_B = (Integer)vector_B.get(0);
                            mapped_on_a_phos_group = true;
                        }
                        if (!mapped_on_a_phos_group) continue;
                        boolean miss_map = true;
                        for (int c3 = 0; c3 < this.best_MAPPING_size; ++c3) {
                            if ((Integer)list.get(c3 * 2 + 0) != first_A || (Integer)list.get(c3 * 2 + 1) != first_B) continue;
                            miss_map = false;
                        }
                        if (!miss_map) continue;
                        map_correct = false;
                    }
                }
                if (!map_correct) continue;
                phosphate_final_MAPPINGS.add(list);
            }
        }
        ArrayList<Integer> N_index_A = new ArrayList<Integer>();
        ArrayList arrayList = new ArrayList();
        for (int a = 0; a < this.atom_num_H_1; ++a) {
            if (!((IAtom)this.atomstr1.get(a)).getSymbol().equals("C")) continue;
            int N_num = 0;
            ArrayList<Integer> amino_N_vec = new ArrayList<Integer>();
            for (int b7 = 0; b7 < this.bond_number1; ++b7) {
                if (a + 1 == (Integer)this.i_tab1.get(b7 * 3 + 0) && "N".equals(this.c_tab1.get(b7 * 2 + 1)) && this.check((Integer)this.i_tab1.get(b7 * 3 + 1), 1)) {
                    amino_N_vec.add((Integer)this.i_tab1.get(b7 * 3 + 1));
                    amino_N_vec.add((Integer)this.i_tab1.get(b7 * 3 + 2));
                    ++N_num;
                }
                if (a + 1 != (Integer)this.i_tab1.get(b7 * 3 + 1) || !"N".equals(this.c_tab1.get(b7 * 2 + 0)) || !this.check((Integer)this.i_tab1.get(b7 * 3 + 0), 1)) continue;
                amino_N_vec.add((Integer)this.i_tab1.get(b7 * 3 + 0));
                amino_N_vec.add((Integer)this.i_tab1.get(b7 * 3 + 2));
                ++N_num;
            }
            if (N_num == 2) {
                ArrayList<Integer> temp_vec = new ArrayList<Integer>();
                if ((Integer)amino_N_vec.get(1) != 2) {
                    temp_vec.add((Integer)amino_N_vec.get(2));
                    temp_vec.add((Integer)amino_N_vec.get(3));
                    temp_vec.add((Integer)amino_N_vec.get(0));
                    temp_vec.add((Integer)amino_N_vec.get(1));
                } else {
                    temp_vec = amino_N_vec;
                }
                N_index_A.add(a + 1);
                arrayList.add(temp_vec);
            }
            if (N_num != 3) continue;
            boolean no_double_bond = true;
            ArrayList<Integer> temp_vec = new ArrayList<Integer>();
            if ((Integer)amino_N_vec.get(1) == 2) {
                temp_vec = amino_N_vec;
                no_double_bond = false;
            }
            if ((Integer)amino_N_vec.get(3) == 2) {
                temp_vec.add((Integer)amino_N_vec.get(2));
                temp_vec.add((Integer)amino_N_vec.get(3));
                temp_vec.add((Integer)amino_N_vec.get(0));
                temp_vec.add((Integer)amino_N_vec.get(1));
                temp_vec.add((Integer)amino_N_vec.get(4));
                temp_vec.add((Integer)amino_N_vec.get(5));
                no_double_bond = false;
            }
            if ((Integer)amino_N_vec.get(5) == 2) {
                temp_vec.add((Integer)amino_N_vec.get(4));
                temp_vec.add((Integer)amino_N_vec.get(5));
                temp_vec.add((Integer)amino_N_vec.get(0));
                temp_vec.add((Integer)amino_N_vec.get(1));
                temp_vec.add((Integer)amino_N_vec.get(2));
                temp_vec.add((Integer)amino_N_vec.get(3));
                no_double_bond = false;
            }
            if (no_double_bond) {
                temp_vec = amino_N_vec;
            }
            N_index_A.add(a + 1);
            arrayList.add(temp_vec);
        }
        int N_index_A_size = N_index_A.size();
        ArrayList<Integer> N_index_B = new ArrayList<Integer>();
        ArrayList amino_vec_B = new ArrayList();
        for (int a = 0; a < this.atom_num_H_2; ++a) {
            if (!"C".equals(((IAtom)this.atomstr2.get(a)).getSymbol())) continue;
            int N_num = 0;
            ArrayList<Integer> amino_N_vec = new ArrayList<Integer>();
            for (int b8 = 0; b8 < this.bond_number2; ++b8) {
                if (a + 1 == (Integer)this.i_tab2.get(b8 * 3 + 0) && "N".equals(this.c_tab2.get(b8 * 2 + 1)) && this.check((Integer)this.i_tab2.get(b8 * 3 + 1), 2)) {
                    amino_N_vec.add((Integer)this.i_tab2.get(b8 * 3 + 1));
                    amino_N_vec.add((Integer)this.i_tab2.get(b8 * 3 + 2));
                    ++N_num;
                }
                if (a + 1 != (Integer)this.i_tab2.get(b8 * 3 + 1) || !"N".equals(this.c_tab2.get(b8 * 2 + 0)) || !this.check((Integer)this.i_tab2.get(b8 * 3 + 0), 2)) continue;
                amino_N_vec.add((Integer)this.i_tab2.get(b8 * 3 + 0));
                amino_N_vec.add((Integer)this.i_tab2.get(b8 * 3 + 2));
                ++N_num;
            }
            if (N_num == 2) {
                ArrayList<Integer> temp_vec = new ArrayList<Integer>();
                if ((Integer)amino_N_vec.get(1) != 2) {
                    temp_vec.add((Integer)amino_N_vec.get(2));
                    temp_vec.add((Integer)amino_N_vec.get(3));
                    temp_vec.add((Integer)amino_N_vec.get(0));
                    temp_vec.add((Integer)amino_N_vec.get(1));
                } else {
                    temp_vec = amino_N_vec;
                }
                N_index_B.add(a + 1);
                amino_vec_B.add(temp_vec);
            }
            if (N_num != 3) continue;
            boolean no_double_bond = true;
            ArrayList<Integer> temp_vec = new ArrayList<Integer>();
            if ((Integer)amino_N_vec.get(1) == 2) {
                temp_vec = amino_N_vec;
                no_double_bond = false;
            }
            if ((Integer)amino_N_vec.get(3) == 2) {
                temp_vec.add((Integer)amino_N_vec.get(2));
                temp_vec.add((Integer)amino_N_vec.get(3));
                temp_vec.add((Integer)amino_N_vec.get(0));
                temp_vec.add((Integer)amino_N_vec.get(1));
                temp_vec.add((Integer)amino_N_vec.get(4));
                temp_vec.add((Integer)amino_N_vec.get(5));
                no_double_bond = false;
            }
            if ((Integer)amino_N_vec.get(5) == 2) {
                temp_vec.add((Integer)amino_N_vec.get(4));
                temp_vec.add((Integer)amino_N_vec.get(5));
                temp_vec.add((Integer)amino_N_vec.get(0));
                temp_vec.add((Integer)amino_N_vec.get(1));
                temp_vec.add((Integer)amino_N_vec.get(2));
                temp_vec.add((Integer)amino_N_vec.get(3));
                no_double_bond = false;
            }
            if (no_double_bond) {
                temp_vec = amino_N_vec;
            }
            N_index_B.add(a + 1);
            amino_vec_B.add(temp_vec);
        }
        int N_index_B_size = N_index_B.size();
        ArrayList<List> amino_final_MAPPINGS = new ArrayList<List>();
        boolean amino_groups_in_both = true;
        if (N_index_A_size == 0 || N_index_B_size == 0) {
            amino_groups_in_both = false;
            amino_final_MAPPINGS = phosphate_final_MAPPINGS;
        }
        if (amino_groups_in_both) {
            for (List phosphate_solution : phosphate_final_MAPPINGS) {
                boolean map_correct = true;
                for (int a = 0; a < this.best_MAPPING_size && map_correct; ++a) {
                    boolean not_found = true;
                    for (int b9 = 0; b9 < N_index_A_size && not_found; ++b9) {
                        if (!((Integer)phosphate_solution.get(a * 2 + 0)).equals(N_index_A.get(b9))) continue;
                        not_found = false;
                        List vector_A = (List)arrayList.get(b9);
                        int first_A = (Integer)vector_A.get(0);
                        int secon_A = (Integer)vector_A.get(2);
                        int first_B = 0;
                        int secon_B = 0;
                        boolean mapped_on_a_amino_group = false;
                        for (c = 0; c < N_index_B_size; ++c) {
                            if (!((Integer)phosphate_solution.get(a * 2 + 1)).equals(N_index_B.get(c))) continue;
                            List vector_B = (List)amino_vec_B.get(c);
                            first_B = (Integer)vector_B.get(0);
                            secon_B = (Integer)vector_B.get(2);
                            mapped_on_a_amino_group = true;
                        }
                        if (!mapped_on_a_amino_group) continue;
                        boolean miss_map = true;
                        for (int c4 = 0; c4 < this.best_MAPPING_size; ++c4) {
                            if ((Integer)phosphate_solution.get(c4 * 2 + 0) != first_A || (Integer)phosphate_solution.get(c4 * 2 + 1) != first_B) continue;
                            miss_map = false;
                        }
                        if (!miss_map) continue;
                        map_correct = false;
                    }
                }
                if (!map_correct) continue;
                amino_final_MAPPINGS.add(phosphate_solution);
            }
        }
        ArrayList<Integer> SO_index_A = new ArrayList<Integer>();
        ArrayList sulfo_vec_A = new ArrayList();
        for (int a = 0; a < this.atom_num_H_1; ++a) {
            if (!"S".equals(((IAtom)this.atomstr1.get(a)).getSymbol())) continue;
            int O_num = 0;
            ArrayList<Integer> sulfo_S_vec = new ArrayList<Integer>();
            for (int b10 = 0; b10 < this.bond_number1; ++b10) {
                if (a + 1 == (Integer)this.i_tab1.get(b10 * 3 + 0) && "O".equals(this.c_tab1.get(b10 * 2 + 1)) && this.check((Integer)this.i_tab1.get(b10 * 3 + 1), 1)) {
                    sulfo_S_vec.add((Integer)this.i_tab1.get(b10 * 3 + 1));
                    sulfo_S_vec.add((Integer)this.i_tab1.get(b10 * 3 + 2));
                    ++O_num;
                }
                if (a + 1 != (Integer)this.i_tab1.get(b10 * 3 + 1) || !"O".equals(this.c_tab1.get(b10 * 2 + 0)) || !this.check((Integer)this.i_tab1.get(b10 * 3 + 0), 1)) continue;
                sulfo_S_vec.add((Integer)this.i_tab1.get(b10 * 3 + 0));
                sulfo_S_vec.add((Integer)this.i_tab1.get(b10 * 3 + 2));
                ++O_num;
            }
            if (O_num == 2) {
                ArrayList<Integer> temp_vec = new ArrayList<Integer>();
                if ((Integer)sulfo_S_vec.get(1) != 2) {
                    temp_vec.add((Integer)sulfo_S_vec.get(2));
                    temp_vec.add((Integer)sulfo_S_vec.get(3));
                    temp_vec.add((Integer)sulfo_S_vec.get(0));
                    temp_vec.add((Integer)sulfo_S_vec.get(1));
                } else {
                    temp_vec = sulfo_S_vec;
                }
                SO_index_A.add(a + 1);
                sulfo_vec_A.add(temp_vec);
            }
            if (O_num == 3) {
                boolean no_single_bond = true;
                ArrayList<Integer> temp_vec = new ArrayList<Integer>();
                if ((Integer)sulfo_S_vec.get(5) == 1) {
                    temp_vec = sulfo_S_vec;
                    no_single_bond = false;
                }
                if ((Integer)sulfo_S_vec.get(1) == 1) {
                    temp_vec.add((Integer)sulfo_S_vec.get(2));
                    temp_vec.add((Integer)sulfo_S_vec.get(3));
                    temp_vec.add((Integer)sulfo_S_vec.get(4));
                    temp_vec.add((Integer)sulfo_S_vec.get(5));
                    temp_vec.add((Integer)sulfo_S_vec.get(0));
                    temp_vec.add((Integer)sulfo_S_vec.get(1));
                    no_single_bond = false;
                }
                if ((Integer)sulfo_S_vec.get(3) == 1) {
                    temp_vec.add((Integer)sulfo_S_vec.get(0));
                    temp_vec.add((Integer)sulfo_S_vec.get(1));
                    temp_vec.add((Integer)sulfo_S_vec.get(4));
                    temp_vec.add((Integer)sulfo_S_vec.get(5));
                    temp_vec.add((Integer)sulfo_S_vec.get(2));
                    temp_vec.add((Integer)sulfo_S_vec.get(3));
                    no_single_bond = false;
                }
                if (no_single_bond) {
                    temp_vec = sulfo_S_vec;
                }
                SO_index_A.add(a + 1);
                sulfo_vec_A.add(temp_vec);
            }
            if (O_num != 4) continue;
            ArrayList<Integer> temp_vec = new ArrayList<Integer>();
            ArrayList<Integer> single_bond_posi = new ArrayList<Integer>();
            ArrayList<Integer> double_bond_posi = new ArrayList<Integer>();
            for (int c5 = 1; c5 < 8; c5 += 2) {
                if ((Integer)sulfo_S_vec.get(c5) == 1) {
                    single_bond_posi.add((Integer)sulfo_S_vec.get(c5 - 1));
                    single_bond_posi.add((Integer)sulfo_S_vec.get(c5));
                }
                if ((Integer)sulfo_S_vec.get(c5) != 2) continue;
                double_bond_posi.add((Integer)sulfo_S_vec.get(c5 - 1));
                double_bond_posi.add((Integer)sulfo_S_vec.get(c5));
            }
            int d_b_posi_size = double_bond_posi.size();
            for (int c6 = 0; c6 < d_b_posi_size; c6 += 2) {
                temp_vec.add((Integer)double_bond_posi.get(c6));
                temp_vec.add((Integer)double_bond_posi.get(c6 + 1));
            }
            int s_b_posi_size = single_bond_posi.size();
            for (int c7 = 0; c7 < s_b_posi_size; c7 += 2) {
                temp_vec.add((Integer)single_bond_posi.get(c7));
                temp_vec.add((Integer)single_bond_posi.get(c7 + 1));
            }
            SO_index_A.add(a + 1);
            sulfo_vec_A.add(temp_vec);
        }
        int SO_index_A_size = SO_index_A.size();
        ArrayList<Integer> SO_index_B = new ArrayList<Integer>();
        ArrayList sulfo_vec_B = new ArrayList();
        for (int a = 0; a < this.atom_num_H_2; ++a) {
            if (!((IAtom)this.atomstr2.get(a)).getSymbol().equals("S")) continue;
            int O_num = 0;
            ArrayList<Integer> sulfo_S_vec = new ArrayList<Integer>();
            for (int b11 = 0; b11 < this.bond_number2; ++b11) {
                if (a + 1 == (Integer)this.i_tab2.get(b11 * 3 + 0) && "O".equals(this.c_tab2.get(b11 * 2 + 1)) && this.check((Integer)this.i_tab2.get(b11 * 3 + 1), 2)) {
                    sulfo_S_vec.add((Integer)this.i_tab2.get(b11 * 3 + 1));
                    sulfo_S_vec.add((Integer)this.i_tab2.get(b11 * 3 + 2));
                    ++O_num;
                }
                if (a + 1 != (Integer)this.i_tab2.get(b11 * 3 + 1) || !"O".equals(this.c_tab2.get(b11 * 2 + 0)) || !this.check((Integer)this.i_tab2.get(b11 * 3 + 0), 2)) continue;
                sulfo_S_vec.add((Integer)this.i_tab2.get(b11 * 3 + 0));
                sulfo_S_vec.add((Integer)this.i_tab2.get(b11 * 3 + 2));
                ++O_num;
            }
            if (O_num == 2) {
                ArrayList<Integer> temp_vec = new ArrayList<Integer>();
                if ((Integer)sulfo_S_vec.get(1) != 2) {
                    temp_vec.add((Integer)sulfo_S_vec.get(2));
                    temp_vec.add((Integer)sulfo_S_vec.get(3));
                    temp_vec.add((Integer)sulfo_S_vec.get(0));
                    temp_vec.add((Integer)sulfo_S_vec.get(1));
                } else {
                    temp_vec = sulfo_S_vec;
                }
                SO_index_B.add(a + 1);
                sulfo_vec_B.add(temp_vec);
            }
            if (O_num == 3) {
                boolean no_single_bond = true;
                ArrayList<Integer> temp_vec = new ArrayList<Integer>();
                if ((Integer)sulfo_S_vec.get(5) == 1) {
                    temp_vec = sulfo_S_vec;
                    no_single_bond = false;
                }
                if ((Integer)sulfo_S_vec.get(1) == 1) {
                    temp_vec.add((Integer)sulfo_S_vec.get(2));
                    temp_vec.add((Integer)sulfo_S_vec.get(3));
                    temp_vec.add((Integer)sulfo_S_vec.get(4));
                    temp_vec.add((Integer)sulfo_S_vec.get(5));
                    temp_vec.add((Integer)sulfo_S_vec.get(0));
                    temp_vec.add((Integer)sulfo_S_vec.get(1));
                    no_single_bond = false;
                }
                if ((Integer)sulfo_S_vec.get(3) == 1) {
                    temp_vec.add((Integer)sulfo_S_vec.get(0));
                    temp_vec.add((Integer)sulfo_S_vec.get(1));
                    temp_vec.add((Integer)sulfo_S_vec.get(4));
                    temp_vec.add((Integer)sulfo_S_vec.get(5));
                    temp_vec.add((Integer)sulfo_S_vec.get(2));
                    temp_vec.add((Integer)sulfo_S_vec.get(3));
                    no_single_bond = false;
                }
                if (no_single_bond) {
                    temp_vec = sulfo_S_vec;
                }
                SO_index_B.add(a + 1);
                sulfo_vec_B.add(temp_vec);
            }
            if (O_num != 4) continue;
            ArrayList<Integer> temp_vec = new ArrayList<Integer>();
            ArrayList<Integer> single_bond_posi = new ArrayList<Integer>();
            ArrayList<Integer> double_bond_posi = new ArrayList<Integer>();
            for (int c8 = 1; c8 < 8; c8 += 2) {
                if ((Integer)sulfo_S_vec.get(c8) == 1) {
                    single_bond_posi.add((Integer)sulfo_S_vec.get(c8 - 1));
                    single_bond_posi.add((Integer)sulfo_S_vec.get(c8));
                }
                if ((Integer)sulfo_S_vec.get(c8) != 2) continue;
                double_bond_posi.add((Integer)sulfo_S_vec.get(c8 - 1));
                double_bond_posi.add((Integer)sulfo_S_vec.get(c8));
            }
            int d_b_posi_size = double_bond_posi.size();
            for (c = 0; c < d_b_posi_size; c += 2) {
                temp_vec.add((Integer)double_bond_posi.get(c));
                temp_vec.add((Integer)double_bond_posi.get(c + 1));
            }
            int s_b_posi_size = single_bond_posi.size();
            for (int c9 = 0; c9 < s_b_posi_size; c9 += 2) {
                temp_vec.add((Integer)single_bond_posi.get(c9));
                temp_vec.add((Integer)single_bond_posi.get(c9 + 1));
            }
            SO_index_B.add(a + 1);
            sulfo_vec_B.add(temp_vec);
        }
        int SO_index_B_size = SO_index_B.size();
        ArrayList<List> sulfo_final_MAPPINGS = new ArrayList<List>();
        boolean sulfo_groups_in_both = true;
        if (SO_index_A_size == 0 || SO_index_B_size == 0) {
            sulfo_groups_in_both = false;
            sulfo_final_MAPPINGS = amino_final_MAPPINGS;
        }
        if (sulfo_groups_in_both) {
            int a;
            boolean no_correct_mapping = true;
            for (List amino_solution : amino_final_MAPPINGS) {
                boolean map_correct = true;
                for (a = 0; a < this.best_MAPPING_size && map_correct; ++a) {
                    boolean not_found = true;
                    for (int b12 = 0; b12 < SO_index_A_size && not_found; ++b12) {
                        if (!((Integer)amino_solution.get(a * 2 + 0)).equals(SO_index_A.get(b12))) continue;
                        not_found = false;
                        List vector_A = (List)sulfo_vec_A.get(b12);
                        int first_A = (Integer)vector_A.get(0);
                        int secon_A = (Integer)vector_A.get(2);
                        int first_B = 0;
                        int secon_B = 0;
                        boolean mapped_on_a_sulfo_group = false;
                        for (int c10 = 0; c10 < SO_index_B_size; ++c10) {
                            if (!((Integer)amino_solution.get(a * 2 + 1)).equals(SO_index_B.get(c10))) continue;
                            List vector_B = (List)sulfo_vec_B.get(c10);
                            first_B = (Integer)vector_B.get(0);
                            secon_B = (Integer)vector_B.get(2);
                            mapped_on_a_sulfo_group = true;
                        }
                        if (!mapped_on_a_sulfo_group) continue;
                        boolean miss_map1 = true;
                        boolean miss_map2 = true;
                        for (int c11 = 0; c11 < this.best_MAPPING_size; ++c11) {
                            if ((Integer)amino_solution.get(c11 * 2 + 0) == first_A && (Integer)amino_solution.get(c11 * 2 + 1) == first_B) {
                                miss_map1 = false;
                            }
                            if ((Integer)amino_solution.get(c11 * 2 + 0) != secon_A || (Integer)amino_solution.get(c11 * 2 + 1) != secon_B) continue;
                            miss_map2 = false;
                        }
                        if (miss_map1 || miss_map2) {
                            map_correct = false;
                        }
                        if (!miss_map1) continue;
                        map_correct = false;
                    }
                }
                if (!map_correct) continue;
                sulfo_final_MAPPINGS.add(amino_solution);
                no_correct_mapping = false;
            }
            if (no_correct_mapping) {
                ArrayList<Integer> Mol_A_Os = new ArrayList<Integer>();
                for (int a3 = 0; a3 < SO_index_A_size; ++a3) {
                    List s_v_A = (List)sulfo_vec_A.get(a3);
                    int s_v_A_size = s_v_A.size();
                    for (int b13 = 0; b13 < s_v_A_size; b13 += 2) {
                        Mol_A_Os.add((Integer)s_v_A.get(b13));
                    }
                }
                int Mol_A_Os_size = Mol_A_Os.size();
                ArrayList<Integer> Mol_B_Os = new ArrayList<Integer>();
                for (a = 0; a < SO_index_B_size; ++a) {
                    List s_v_B = (List)sulfo_vec_B.get(a);
                    int s_v_B_size = s_v_B.size();
                    for (int b14 = 0; b14 < s_v_B_size; b14 += 2) {
                        Mol_B_Os.add((Integer)s_v_B.get(b14));
                    }
                }
                int Mol_B_Os_size = Mol_B_Os.size();
                ArrayList temp_s_f_M = new ArrayList();
                for (List amino_solution : phosphate_final_MAPPINGS) {
                    ArrayList<Integer> t_map = new ArrayList<Integer>();
                    for (int a2 = 0; a2 < this.best_MAPPING_size; a2 += 2) {
                        boolean store = true;
                        for (int b15 = 0; b15 < Mol_A_Os_size && store; ++b15) {
                            for (int c12 = 0; c12 < Mol_B_Os_size && store; ++c12) {
                                if (!((Integer)Mol_A_Os.get(b15)).equals(amino_solution.get(a2)) || !((Integer)Mol_B_Os.get(c12)).equals(amino_solution.get(a2 + 1))) continue;
                                store = false;
                            }
                        }
                        if (!store) continue;
                        t_map.add((Integer)amino_solution.get(a2));
                        t_map.add((Integer)amino_solution.get(a2 + 1));
                    }
                    temp_s_f_M.add(t_map);
                }
                int temp_s_f_M_size = temp_s_f_M.size();
                ArrayList<List> temp_s_f_M2 = new ArrayList<List>();
                for (int a4 = 0; a4 < temp_s_f_M_size; ++a4) {
                    List map_A = (List)temp_s_f_M.get(a4);
                    int map_A_size = map_A.size();
                    boolean unique_map = true;
                    for (int b16 = a4 + 1; b16 < temp_s_f_M_size && unique_map && a4 != temp_s_f_M_size - 1; ++b16) {
                        boolean map_contained = true;
                        List map_B = (List)temp_s_f_M.get(b16);
                        int map_B_size = map_B.size();
                        for (int c13 = 0; c13 < map_A_size && map_contained; c13 += 2) {
                            boolean map_not_contained = true;
                            for (int d = 0; d < map_B_size && map_not_contained; d += 2) {
                                if (!((Integer)map_A.get(c13)).equals(map_B.get(d)) || !((Integer)map_A.get(c13 + 1)).equals(map_B.get(d + 1))) continue;
                                map_not_contained = false;
                            }
                            if (!map_not_contained) continue;
                            map_contained = false;
                        }
                        if (!map_contained) continue;
                        unique_map = false;
                    }
                    if (!unique_map) continue;
                    temp_s_f_M2.add(map_A);
                }
                int temp_s_f_M2_size = temp_s_f_M2.size();
                for (int a2 = 0; a2 < temp_s_f_M2_size; ++a2) {
                    List map_element = (List)temp_s_f_M2.get(a2);
                    List new_element = (List)temp_s_f_M2.get(a2);
                    int map_element_size = map_element.size();
                    b = 0;
                    while (b < map_element_size) {
                        for (int c14 = 0; c14 < SO_index_A_size; ++c14) {
                            if (!((Integer)map_element.get(b)).equals(SO_index_A.get(c14))) continue;
                            List Os_A = (List)sulfo_vec_A.get(c14);
                            List Os_B = new ArrayList();
                            for (int d = 0; d < SO_index_B_size; ++d) {
                                if (!((Integer)map_element.get(b + 1)).equals(SO_index_B.get(d))) continue;
                                Os_B = (List)sulfo_vec_B.get(d);
                            }
                            int Os_A_size = Os_A.size();
                            int Os_B_size = Os_B.size();
                            for (int e = 0; e < Os_A_size && e < Os_B_size; e += 2) {
                                new_element.add((Integer)Os_A.get(e));
                                new_element.add((Integer)Os_B.get(e));
                            }
                        }
                        b = a2 + 2;
                    }
                    sulfo_final_MAPPINGS.add(new_element);
                }
            }
        }
        ArrayList<Integer> NO_index_A = new ArrayList<Integer>();
        ArrayList nitro_vec_A = new ArrayList();
        for (int a = 0; a < this.atom_num_H_1; ++a) {
            if (!((IAtom)this.atomstr1.get(a)).getSymbol().equals("N")) continue;
            int O_num = 0;
            ArrayList<Integer> nitro_N_vec = new ArrayList<Integer>();
            for (int b17 = 0; b17 < this.bond_number1; ++b17) {
                if (a + 1 == (Integer)this.i_tab1.get(b17 * 3 + 0) && "O".equals(this.c_tab1.get(b17 * 2 + 1)) && this.check((Integer)this.i_tab1.get(b17 * 3 + 1), 1)) {
                    nitro_N_vec.add((Integer)this.i_tab1.get(b17 * 3 + 1));
                    nitro_N_vec.add((Integer)this.i_tab1.get(b17 * 3 + 2));
                    ++O_num;
                }
                if (a + 1 != (Integer)this.i_tab1.get(b17 * 3 + 1) || !"O".equals(this.c_tab1.get(b17 * 2 + 0)) || !this.check((Integer)this.i_tab1.get(b17 * 3 + 0), 1)) continue;
                nitro_N_vec.add((Integer)this.i_tab1.get(b17 * 3 + 0));
                nitro_N_vec.add((Integer)this.i_tab1.get(b17 * 3 + 2));
                ++O_num;
            }
            if (O_num == 2) {
                ArrayList<Integer> temp_vec = new ArrayList<Integer>();
                if ((Integer)nitro_N_vec.get(1) != 2) {
                    temp_vec.add((Integer)nitro_N_vec.get(2));
                    temp_vec.add((Integer)nitro_N_vec.get(3));
                    temp_vec.add((Integer)nitro_N_vec.get(0));
                    temp_vec.add((Integer)nitro_N_vec.get(1));
                } else {
                    temp_vec = nitro_N_vec;
                }
                NO_index_A.add(a + 1);
                nitro_vec_A.add(temp_vec);
            }
            if (O_num != 3) continue;
            boolean no_single_bond = true;
            ArrayList<Integer> temp_vec = new ArrayList<Integer>();
            for (int c15 = 0; c15 < 6; c15 += 2) {
                if ((Integer)nitro_N_vec.get(c15 + 1) != 2) continue;
                temp_vec.add((Integer)nitro_N_vec.get(c15));
                temp_vec.add((Integer)nitro_N_vec.get(c15 + 1));
            }
            for (int c2 = 0; c2 < 6; c2 += 2) {
                if ((Integer)nitro_N_vec.get(c2 + 1) != 1) continue;
                temp_vec.add((Integer)nitro_N_vec.get(c2));
                temp_vec.add((Integer)nitro_N_vec.get(c2 + 1));
                no_single_bond = false;
            }
            if (no_single_bond) {
                temp_vec = nitro_N_vec;
            }
            NO_index_A.add(a + 1);
            nitro_vec_A.add(temp_vec);
        }
        int NO_index_A_size = NO_index_A.size();
        ArrayList<Integer> NO_index_B = new ArrayList<Integer>();
        ArrayList nitro_vec_B = new ArrayList();
        for (int a = 0; a < this.atom_num_H_2; ++a) {
            if (!"N".equals(((IAtom)this.atomstr2.get(a)).getSymbol())) continue;
            int O_num = 0;
            ArrayList<Integer> nitro_N_vec = new ArrayList<Integer>();
            for (int b18 = 0; b18 < this.bond_number2; ++b18) {
                if (a + 1 == (Integer)this.i_tab2.get(b18 * 3 + 0) && "O".equals(this.c_tab2.get(b18 * 2 + 1)) && this.check((Integer)this.i_tab2.get(b18 * 3 + 1), 2)) {
                    nitro_N_vec.add((Integer)this.i_tab2.get(b18 * 3 + 1));
                    nitro_N_vec.add((Integer)this.i_tab2.get(b18 * 3 + 2));
                    ++O_num;
                }
                if (a + 1 != (Integer)this.i_tab2.get(b18 * 3 + 1) || !"O".equals(this.c_tab2.get(b18 * 2 + 0)) || !this.check((Integer)this.i_tab2.get(b18 * 3 + 0), 2)) continue;
                nitro_N_vec.add((Integer)this.i_tab2.get(b18 * 3 + 0));
                nitro_N_vec.add((Integer)this.i_tab2.get(b18 * 3 + 2));
                ++O_num;
            }
            if (O_num == 2) {
                ArrayList<Integer> temp_vec = new ArrayList<Integer>();
                if ((Integer)nitro_N_vec.get(1) != 2) {
                    temp_vec.add((Integer)nitro_N_vec.get(2));
                    temp_vec.add((Integer)nitro_N_vec.get(3));
                    temp_vec.add((Integer)nitro_N_vec.get(0));
                    temp_vec.add((Integer)nitro_N_vec.get(1));
                } else {
                    temp_vec = nitro_N_vec;
                }
                NO_index_B.add(a + 1);
                nitro_vec_B.add(temp_vec);
            }
            if (O_num != 3) continue;
            boolean no_single_bond = true;
            ArrayList<Integer> temp_vec = new ArrayList<Integer>();
            for (int c16 = 0; c16 < 6; c16 += 2) {
                if ((Integer)nitro_N_vec.get(c16 + 1) != 2) continue;
                temp_vec.add((Integer)nitro_N_vec.get(c16));
                temp_vec.add((Integer)nitro_N_vec.get(c16 + 1));
            }
            for (int c3 = 0; c3 < 6; c3 += 2) {
                if ((Integer)nitro_N_vec.get(c3 + 1) != 1) continue;
                temp_vec.add((Integer)nitro_N_vec.get(c3));
                temp_vec.add((Integer)nitro_N_vec.get(c3 + 1));
                no_single_bond = false;
            }
            if (no_single_bond) {
                temp_vec = nitro_N_vec;
            }
            NO_index_B.add(a + 1);
            nitro_vec_B.add(temp_vec);
        }
        int NO_index_B_size = NO_index_B.size();
        ArrayList<List> nitro_final_MAPPINGS = new ArrayList<List>();
        boolean nitro_groups_in_both = true;
        if (NO_index_A_size == 0 || NO_index_B_size == 0) {
            nitro_groups_in_both = false;
            nitro_final_MAPPINGS = sulfo_final_MAPPINGS;
        }
        if (nitro_groups_in_both) {
            boolean no_correct_mapping = true;
            for (List sulfo_solution : sulfo_final_MAPPINGS) {
                boolean map_correct = true;
                for (int a = 0; a < this.best_MAPPING_size && map_correct; ++a) {
                    boolean not_found = true;
                    for (b = 0; b < NO_index_A_size && not_found; ++b) {
                        if (!((Integer)sulfo_solution.get(a * 2 + 0)).equals(NO_index_A.get(b))) continue;
                        not_found = false;
                        List vector_A = (List)nitro_vec_A.get(b);
                        int first_A = (Integer)vector_A.get(0);
                        int secon_A = (Integer)vector_A.get(2);
                        int first_B = 0;
                        int secon_B = 0;
                        boolean mapped_on_a_nitro_group = false;
                        for (int c4 = 0; c4 < NO_index_B_size; ++c4) {
                            if (!((Integer)sulfo_solution.get(a * 2 + 1)).equals(NO_index_B.get(c4))) continue;
                            List vector_B = (List)nitro_vec_B.get(c4);
                            first_B = (Integer)vector_B.get(0);
                            secon_B = (Integer)vector_B.get(2);
                            mapped_on_a_nitro_group = true;
                        }
                        if (!mapped_on_a_nitro_group) continue;
                        boolean miss_map1 = true;
                        boolean miss_map2 = true;
                        for (int c18 = 0; c18 < this.best_MAPPING_size; ++c18) {
                            if ((Integer)sulfo_solution.get(c18 * 2 + 0) == first_A && (Integer)sulfo_solution.get(c18 * 2 + 1) == first_B) {
                                miss_map1 = false;
                            }
                            if ((Integer)sulfo_solution.get(c18 * 2 + 0) != secon_A || (Integer)sulfo_solution.get(c18 * 2 + 1) != secon_B) continue;
                            miss_map2 = false;
                        }
                        if (miss_map1 || miss_map2) {
                            map_correct = false;
                        }
                        if (!miss_map1) continue;
                        map_correct = false;
                    }
                }
                if (!map_correct) continue;
                nitro_final_MAPPINGS.add(sulfo_solution);
                no_correct_mapping = false;
            }
            if (no_correct_mapping) {
                int d;
                int a;
                ArrayList<Integer> Mol_A_Os = new ArrayList<Integer>();
                for (int a5 = 0; a5 < NO_index_A_size; ++a5) {
                    List n_v_A = (List)nitro_vec_A.get(a5);
                    int n_v_A_size = n_v_A.size();
                    for (int b19 = 0; b19 < n_v_A_size; b19 += 2) {
                        Mol_A_Os.add((Integer)n_v_A.get(b19));
                    }
                }
                int Mol_A_Os_size = Mol_A_Os.size();
                ArrayList<Integer> Mol_B_Os = new ArrayList<Integer>();
                for (int a6 = 0; a6 < NO_index_B_size; ++a6) {
                    List n_v_B = (List)nitro_vec_B.get(a6);
                    int n_v_B_size = n_v_B.size();
                    for (int b20 = 0; b20 < n_v_B_size; b20 += 2) {
                        Mol_B_Os.add((Integer)n_v_B.get(b20));
                    }
                }
                int Mol_B_Os_size = Mol_B_Os.size();
                ArrayList temp_n_f_M = new ArrayList();
                for (List sulfo_solution : sulfo_final_MAPPINGS) {
                    ArrayList<Integer> t_map = new ArrayList<Integer>();
                    for (a = 0; a < this.best_MAPPING_size; a += 2) {
                        boolean store = true;
                        for (int b21 = 0; b21 < Mol_A_Os_size && store; ++b21) {
                            for (int c17 = 0; c17 < Mol_B_Os_size && store; ++c17) {
                                if (!((Integer)Mol_A_Os.get(b21)).equals(sulfo_solution.get(a)) || !((Integer)Mol_B_Os.get(c17)).equals(sulfo_solution.get(a + 1))) continue;
                                store = false;
                            }
                        }
                        if (!store) continue;
                        t_map.add((Integer)sulfo_solution.get(a));
                        t_map.add((Integer)sulfo_solution.get(a + 1));
                    }
                    temp_n_f_M.add(t_map);
                }
                int temp_n_f_M_size = temp_n_f_M.size();
                ArrayList<List> temp_n_f_M2 = new ArrayList<List>();
                for (a = 0; a < temp_n_f_M_size; ++a) {
                    List map_A = (List)temp_n_f_M.get(a);
                    int map_A_size = map_A.size();
                    boolean unique_map = true;
                    for (int b22 = a + 1; b22 < temp_n_f_M_size && unique_map && a != temp_n_f_M_size - 1; ++b22) {
                        boolean map_contained = true;
                        List map_B = (List)temp_n_f_M.get(b22);
                        int map_B_size = map_B.size();
                        for (int c19 = 0; c19 < map_A_size && map_contained; c19 += 2) {
                            boolean map_not_contained = true;
                            for (d = 0; d < map_B_size && map_not_contained; d += 2) {
                                if (!((Integer)map_A.get(c19)).equals(map_B.get(d)) || !((Integer)map_A.get(c19 + 1)).equals(map_B.get(d + 1))) continue;
                                map_not_contained = false;
                            }
                            if (!map_not_contained) continue;
                            map_contained = false;
                        }
                        if (!map_contained) continue;
                        unique_map = false;
                    }
                    if (!unique_map) continue;
                    temp_n_f_M2.add(map_A);
                }
                boolean no_correct_solution = true;
                int temp_n_f_M2_size = temp_n_f_M2.size();
                for (int a7 = 0; a7 < temp_n_f_M2_size; ++a7) {
                    List map_element = (List)temp_n_f_M2.get(a7);
                    List new_element = (List)temp_n_f_M2.get(a7);
                    int map_element_size = map_element.size();
                    int b23 = 0;
                    while (b23 < map_element_size) {
                        for (int c20 = 0; c20 < NO_index_A_size; ++c20) {
                            if (!((Integer)map_element.get(b23)).equals(NO_index_A.get(c20))) continue;
                            List Os_A = (List)nitro_vec_A.get(c20);
                            List Os_B = new ArrayList();
                            for (d = 0; d < NO_index_B_size; ++d) {
                                if (!((Integer)map_element.get(b23 + 1)).equals(NO_index_B.get(d))) continue;
                                Os_B = (List)nitro_vec_B.get(d);
                            }
                            int Os_A_size = Os_A.size();
                            int Os_B_size = Os_B.size();
                            for (int e = 0; e < Os_A_size && e < Os_B_size; e += 2) {
                                new_element.add((Integer)Os_A.get(e));
                                new_element.add((Integer)Os_B.get(e));
                            }
                        }
                        b23 = a7 + 2;
                    }
                    if (new_element.size() == this.best_MAPPING_size) {
                        no_correct_solution = false;
                        continue;
                    }
                    nitro_final_MAPPINGS.add(new_element);
                }
                if (no_correct_solution) {
                    nitro_final_MAPPINGS.clear();
                    nitro_final_MAPPINGS = sulfo_final_MAPPINGS;
                }
            }
        }
        this.getFinalMappings().clear();
        this.getFinalMappings().addAll(nitro_final_MAPPINGS);
        return 0;
    }

    boolean check(int atom, int molecule) {
        int a;
        int count_neighb = 0;
        if (molecule == 1) {
            for (a = 0; a < this.bond_number1; ++a) {
                if (atom != (Integer)this.i_tab1.get(a * 3 + 0) && atom != (Integer)this.i_tab1.get(a * 3 + 1)) continue;
                ++count_neighb;
            }
        }
        if (molecule == 2) {
            for (a = 0; a < this.bond_number2; ++a) {
                if (atom != (Integer)this.i_tab2.get(a * 3 + 0) && atom != (Integer)this.i_tab2.get(a * 3 + 1)) continue;
                ++count_neighb;
            }
        }
        return count_neighb == 1;
    }
}

