/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.mcsplus1.MCSPlus;
import org.openscience.smsd.filters.PostFilter;
import org.openscience.smsd.interfaces.IResults;

public final class MCSPlusMapper
implements IResults {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MCSPlusMapper.class);
    private final List<AtomAtomMapping> allAtomMCS;
    private final List<Map<Integer, Integer>> allMCS;
    private final IAtomContainer source;
    private final IAtomContainer target;
    private boolean flagExchange = false;
    private final boolean timeout;
    private final boolean DEBUG = false;
    private AtomMatcher am;
    private BondMatcher bm;

    public MCSPlusMapper(IAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) throws CDKException {
        this.source = source;
        this.target = target;
        this.allAtomMCS = Collections.synchronizedList(new ArrayList());
        this.allMCS = Collections.synchronizedList(new ArrayList());
        this.am = am;
        this.bm = bm;
        this.timeout = this.searchMCS();
    }

    public MCSPlusMapper(IQueryAtomContainer source, IAtomContainer target, AtomMatcher am, BondMatcher bm) throws CDKException {
        this.source = source;
        this.target = target;
        this.allAtomMCS = Collections.synchronizedList(new ArrayList());
        this.allMCS = Collections.synchronizedList(new ArrayList());
        this.am = am;
        this.bm = bm;
        this.timeout = this.searchMCS();
    }

    private synchronized boolean searchMCS() throws CDKException {
        MCSPlus mcs;
        List<Object> mappings = new ArrayList();
        if (this.source instanceof IQueryAtomContainer || this.target instanceof IQueryAtomContainer) {
            throw new CDKException("Not supported");
        }
        if (this.source.getAtomCount() > this.target.getAtomCount()) {
            this.flagExchange = true;
            mcs = new MCSPlus(this.target, this.source, this.am, this.bm);
            mcs.search_cliques();
            mappings = Collections.synchronizedList(mcs.getFinalMappings());
        } else {
            this.flagExchange = false;
            mcs = new MCSPlus(this.source, this.target, this.am, this.bm);
            mcs.search_cliques();
            mappings = Collections.synchronizedList(mcs.getFinalMappings());
        }
        if (this.flagExchange) {
            mappings = this.reverseMappings(mappings);
        }
        List<Map<Integer, Integer>> solutions = PostFilter.filter(mappings);
        this.setAllMapping(solutions);
        this.setAllAtomMapping();
        return !mappings.isEmpty();
    }

    private synchronized void setAllMapping(List<Map<Integer, Integer>> solutions) {
        try {
            int bestSolSize = 0;
            for (Map<Integer, Integer> solution : solutions) {
                SortedMap validSolution = Collections.synchronizedSortedMap(new TreeMap());
                solution.entrySet().stream().forEach(map -> validSolution.put((Integer)map.getKey(), (Integer)map.getValue()));
                if (validSolution.size() > bestSolSize && validSolution.size() <= this.source.getAtomCount() && validSolution.size() <= this.target.getAtomCount()) {
                    bestSolSize = validSolution.size();
                    this.allMCS.clear();
                }
                if (validSolution.size() != bestSolSize) continue;
                this.allMCS.add(validSolution);
            }
        }
        catch (Exception ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
    }

    private synchronized void setAllAtomMapping() {
        try {
            this.allMCS.stream().map(solution -> {
                AtomAtomMapping atomMapping = new AtomAtomMapping(this.source, this.target);
                solution.entrySet().stream().forEach(m -> {
                    int indexI = (Integer)m.getKey() - 1;
                    int indexJ = (Integer)m.getValue() - 1;
                    IAtom sourceAtom = this.source.getAtom(indexI);
                    IAtom targetAtom = this.target.getAtom(indexJ);
                    atomMapping.put(sourceAtom, targetAtom);
                });
                return atomMapping;
            }).forEach(atomMapping -> this.allAtomMCS.add((AtomAtomMapping)atomMapping));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(Level.SEVERE, null, e);
        }
    }

    @Override
    public synchronized List<AtomAtomMapping> getAllAtomMapping() {
        return Collections.unmodifiableList(this.allAtomMCS);
    }

    @Override
    public synchronized AtomAtomMapping getFirstAtomMapping() {
        if (this.allAtomMCS.iterator().hasNext()) {
            return this.allAtomMCS.iterator().next();
        }
        return new AtomAtomMapping(this.source, this.target);
    }

    public synchronized boolean isTimeout() {
        return this.timeout;
    }

    private List<List<Integer>> reverseMappings(List<List<Integer>> mappings) {
        ArrayList<List<Integer>> reverse = new ArrayList<List<Integer>>();
        mappings.stream().map(mapping -> {
            Collections.reverse(mapping);
            return mapping;
        }).forEach(mapping -> reverse.add((List<Integer>)mapping));
        return reverse;
    }
}

